/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@data-driven-forms/common/esm/form-template/form-template.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/form-template/form-template.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FormControls": () => (/* binding */ FormControls),
/* harmony export */   "completeButtons": () => (/* binding */ completeButtons),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "isDisabled": () => (/* binding */ isDisabled)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/form-spy */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js");



var _excluded = ["FormWrapper", "Title", "Description", "Button", "ButtonGroup", "formWrapperProps", "showFormControls", "disableSubmit", "Header", "headerProps", "titleProps", "descriptionProps", "buttonGroupProps", "buttonsProps", "alertProps", "BeforeError"];




var isDisabled = function isDisabled(disableStates, getState) {
  return disableStates.map(function (item) {
    return getState()[item];
  }).find(function (item) {
    return !!item;
  });
};
var completeButtons = function completeButtons(buttonOrder) {
  var expectedOrder = (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(buttonOrder);

  if (!expectedOrder.includes('submit')) {
    expectedOrder.push('submit');
  }

  if (!expectedOrder.includes('reset')) {
    expectedOrder.push('reset');
  }

  if (!expectedOrder.includes('cancel')) {
    expectedOrder.push('cancel');
  }

  return expectedOrder;
};
var FormControls = function FormControls(_ref) {
  var onCancel = _ref.onCancel,
      onReset = _ref.onReset,
      submitLabel = _ref.submitLabel,
      cancelLabel = _ref.cancelLabel,
      resetLabel = _ref.resetLabel,
      canReset = _ref.canReset,
      disableSubmit = _ref.disableSubmit,
      buttonOrder = _ref.buttonOrder,
      buttonClassName = _ref.buttonClassName,
      FormButtons = _ref.FormButtons,
      Button = _ref.Button,
      ButtonGroup = _ref.ButtonGroup,
      formSpyProps = _ref.formSpyProps,
      buttonsProps = _ref.buttonsProps,
      buttonGroupProps = _ref.buttonGroupProps;

  if (FormButtons) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(FormButtons, null);
  }

  var submitting = formSpyProps.submitting,
      pristine = formSpyProps.pristine,
      validating = formSpyProps.validating;
  var submit = buttonsProps.submit,
      reset = buttonsProps.reset,
      cancel = buttonsProps.cancel;
  var buttons = {
    submit: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: "form-submit",
      type: "submit",
      variant: "primary",
      buttonType: "submit",
      disabled: submitting || validating || disableSubmit,
      label: submitLabel
    }, submit)),
    reset: canReset ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: "form-reset",
      type: "button",
      buttonType: "reset",
      disabled: pristine,
      onClick: onReset,
      label: resetLabel
    }, reset)) : null,
    cancel: onCancel ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: "form-cancel",
      type: "button",
      buttonType: "cancel",
      onClick: onCancel,
      label: cancelLabel
    }, cancel)) : null
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(ButtonGroup, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, buttonGroupProps, buttonClassName && {
    className: buttonClassName
  }), completeButtons(buttonOrder).map(function (button) {
    return buttons[button];
  }));
};
FormControls.propTypes = {
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  onReset: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  submitLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  cancelLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  resetLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  canReset: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  disableSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  buttonOrder: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)),
  buttonClassName: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  FormButtons: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)]),
  Button: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)]),
  ButtonGroup: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)]),
  formSpyProps: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    submitting: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
    pristine: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
    validating: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
    form: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
      reset: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)
    }),
    values: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
  }),
  buttonGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  buttonsProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
FormControls.defaultProps = {
  submitLabel: 'Submit',
  cancelLabel: 'Cancel',
  resetLabel: 'Reset',
  canReset: false,
  canSubmit: false,
  buttonOrder: ['submit', 'reset', 'cancel'],
  buttonsProps: {}
};

var FormTemplate = function FormTemplate(_ref2) {
  var FormWrapper = _ref2.FormWrapper,
      Title = _ref2.Title,
      Description = _ref2.Description,
      Button = _ref2.Button,
      ButtonGroup = _ref2.ButtonGroup,
      formWrapperProps = _ref2.formWrapperProps,
      showFormControls = _ref2.showFormControls,
      disableSubmit = _ref2.disableSubmit,
      Header = _ref2.Header,
      headerProps = _ref2.headerProps,
      titleProps = _ref2.titleProps,
      descriptionProps = _ref2.descriptionProps,
      buttonGroupProps = _ref2.buttonGroupProps,
      buttonsProps = _ref2.buttonsProps,
      alertProps = _ref2.alertProps,
      BeforeError = _ref2.BeforeError,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref2, _excluded);

  var _rest$schema = rest.schema,
      title = _rest$schema.title,
      description = _rest$schema.description,
      label = _rest$schema.label,
      formFields = rest.formFields;

  var _useFormApi = (0,_data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_4__["default"])(),
      onReset = _useFormApi.onReset,
      onCancel = _useFormApi.onCancel,
      getState = _useFormApi.getState,
      handleSubmit = _useFormApi.handleSubmit;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(FormWrapper, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    onSubmit: handleSubmit
  }, formWrapperProps), (title || label || description) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Header, headerProps, (title || label) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Title, titleProps, title || label), description && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Description, descriptionProps, description)), BeforeError && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__["default"], {
    subscription: {
      submitError: true,
      error: true
    }
  }, function () {
    var state = getState();
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(BeforeError, {
      formError: state.error || state.submitError,
      formSpyProps: state,
      alertProps: alertProps
    });
  }), formFields, showFormControls && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__["default"], null, function (formSpyProps) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(FormControls, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      Button: Button,
      FormSpy: _data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__["default"],
      buttonGroupProps: buttonGroupProps,
      buttonsProps: buttonsProps,
      ButtonGroup: ButtonGroup,
      onReset: onReset,
      onCancel: onCancel,
      disableSubmit: isDisabled(disableSubmit, getState),
      formSpyProps: formSpyProps
    }, rest));
  }));
};

FormTemplate.propTypes = {
  FormWrapper: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element)]).isRequired,
  Title: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element)]).isRequired,
  Description: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element)]).isRequired,
  Button: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element)]).isRequired,
  ButtonGroup: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element)]).isRequired,
  formWrapperProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  showFormControls: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  disableSubmit: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)),
  Header: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().element), prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOf([react__WEBPACK_IMPORTED_MODULE_3__.Fragment])]),
  headerProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  titleProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  descriptionProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  buttonGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  buttonsProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  BeforeError: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  alertProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
FormTemplate.defaultProps = {
  showFormControls: true,
  disableSubmit: [],
  Header: react__WEBPACK_IMPORTED_MODULE_3__.Fragment
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormTemplate);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/form-template/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/form-template/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FormControls": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.FormControls),
/* harmony export */   "completeButtons": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.completeButtons),
/* harmony export */   "default": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "isDisabled": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.isDisabled)
/* harmony export */ });
/* harmony import */ var _form_template__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-template */ "./node_modules/@data-driven-forms/common/esm/form-template/form-template.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/hooks/use-is-mounted.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/hooks/use-is-mounted.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");


var useIsMounted = function useIsMounted() {
  var isMounted = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    isMounted.current = true;
    return function () {
      return isMounted.current = false;
    };
  }, []);
  return isMounted;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useIsMounted);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/multiple-choice-list/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/multiple-choice-list/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _multiple_choice_list__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "wrapperProps": () => (/* reexport safe */ _multiple_choice_list__WEBPACK_IMPORTED_MODULE_0__.wrapperProps)
/* harmony export */ });
/* harmony import */ var _multiple_choice_list__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./multiple-choice-list */ "./node_modules/@data-driven-forms/common/esm/multiple-choice-list/multiple-choice-list.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/multiple-choice-list/multiple-choice-list.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/multiple-choice-list/multiple-choice-list.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "wrapperProps": () => (/* binding */ wrapperProps)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _prop_types_templates__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../prop-types-templates */ "./node_modules/@data-driven-forms/common/esm/prop-types-templates/index.js");



var _excluded = ["input", "Checkbox"],
    _excluded2 = ["Wrapper", "Checkbox", "label", "validateOnMount", "isRequired", "helperText", "meta", "input", "options", "isDisabled", "isReadOnly", "description"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }






var SingleCheckbox = function SingleCheckbox(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(_objectSpread(_objectSpread({}, props), {}, {
    type: 'checkbox'
  })),
      input = _useFieldApi.input,
      Checkbox = _useFieldApi.Checkbox,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Checkbox, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, input, rest));
};

var MultipleChoiceList = function MultipleChoiceList(props) {
  var _useFieldApi2 = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(props),
      Wrapper = _useFieldApi2.Wrapper,
      Checkbox = _useFieldApi2.Checkbox,
      label = _useFieldApi2.label,
      validateOnMount = _useFieldApi2.validateOnMount,
      isRequired = _useFieldApi2.isRequired,
      helperText = _useFieldApi2.helperText,
      meta = _useFieldApi2.meta,
      input = _useFieldApi2.input,
      options = _useFieldApi2.options,
      isDisabled = _useFieldApi2.isDisabled,
      isReadOnly = _useFieldApi2.isReadOnly,
      description = _useFieldApi2.description,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_useFieldApi2, _excluded2);

  var error = meta.error,
      touched = meta.touched,
      submitError = meta.submitError;
  var showError = Boolean((touched || validateOnMount) && (error || submitError));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Wrapper, {
    showError: showError,
    isRequired: isRequired,
    label: label,
    helperText: helperText,
    meta: meta,
    description: description,
    rest: rest,
    error: error || submitError,
    name: input.name
  }, options.map(function (option) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(SingleCheckbox, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      Checkbox: Checkbox,
      "aria-label": option['aria-label'] || option.label
    }, rest, {
      value: option.value,
      label: option.label,
      name: input.name,
      option: option,
      id: "".concat(rest.id || input.name, "-").concat(option.value),
      key: "".concat(rest.id || input.name, "-").concat(option.value),
      isDisabled: isDisabled || isReadOnly
    }));
  }));
};

MultipleChoiceList.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string.isRequired),
  Wrapper: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)]),
  Checkbox: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func)])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultipleChoiceList);
var wrapperProps = _objectSpread(_objectSpread({}, _prop_types_templates__WEBPACK_IMPORTED_MODULE_5__.formGroup), {}, {
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)])
});

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/prop-types-templates/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/prop-types-templates/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "childrenPropTypes": () => (/* reexport safe */ _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__.childrenPropTypes),
/* harmony export */   "formGroup": () => (/* reexport safe */ _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__.formGroup),
/* harmony export */   "input": () => (/* reexport safe */ _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__.input),
/* harmony export */   "meta": () => (/* reexport safe */ _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__.meta),
/* harmony export */   "optionsPropType": () => (/* reexport safe */ _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__.optionsPropType)
/* harmony export */ });
/* harmony import */ var _prop_types_templates__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./prop-types-templates */ "./node_modules/@data-driven-forms/common/esm/prop-types-templates/prop-types-templates.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/prop-types-templates/prop-types-templates.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/prop-types-templates/prop-types-templates.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "childrenPropTypes": () => (/* binding */ childrenPropTypes),
/* harmony export */   "formGroup": () => (/* binding */ formGroup),
/* harmony export */   "input": () => (/* binding */ input),
/* harmony export */   "meta": () => (/* binding */ meta),
/* harmony export */   "optionsPropType": () => (/* binding */ optionsPropType)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);

var optionsPropType = prop_types__WEBPACK_IMPORTED_MODULE_0___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
  label: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().node.isRequired),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any)
}));
var meta = prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
  active: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  dirty: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  dirtySinceLastSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any),
  initial: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any),
  invalid: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  modified: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  pristine: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  submitError: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any),
  submitFailed: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  submitSucceeded: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  submitting: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  touched: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  valid: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  validating: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  visited: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool)
});
var formGroup = {
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().node),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().node),
  meta: meta,
  description: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().node)
};
var input = prop_types__WEBPACK_IMPORTED_MODULE_0___default().shape({
  name: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().string.isRequired),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().any)
});
var childrenPropTypes = prop_types__WEBPACK_IMPORTED_MODULE_0___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_0___default().node), prop_types__WEBPACK_IMPORTED_MODULE_0___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_0___default().node))]);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/select/flat-options.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/select/flat-options.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");


var flatOptions = function flatOptions(options) {
  return options.flatMap(function (option) {
    return option.options ? [{
      group: option.label
    }].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(option.options)) : [option];
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (flatOptions);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/select/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/select/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _select__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "flatOptions": () => (/* reexport safe */ _flat_options__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "parseInternalValue": () => (/* reexport safe */ _parse_internal_value__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select */ "./node_modules/@data-driven-forms/common/esm/select/select.js");
/* harmony import */ var _parse_internal_value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse-internal-value */ "./node_modules/@data-driven-forms/common/esm/select/parse-internal-value.js");
/* harmony import */ var _flat_options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./flat-options */ "./node_modules/@data-driven-forms/common/esm/select/flat-options.js");




/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/select/parse-internal-value.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/select/parse-internal-value.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");


/**
 * Parses internal select value based on isMulti attribute
 * @param {Array} value value of the ddf internal select implementaion
 * @param {Boolean} isMulti if true, select is multi value
 * @returns {Array|String|Number|Boolean|Object|undefined|null}
 */
var parseInternalValue = function parseInternalValue(value) {
  var isMulti = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var internalValue = value;

  if (isMulti && Array.isArray(internalValue)) {
    internalValue = value.map(function (item) {
      return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(item) === 'object' ? item.value : item;
    });
  }

  if (!isMulti && Array.isArray(internalValue) && internalValue[0]) {
    internalValue = (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(internalValue[0]) === 'object' ? internalValue[0].value : internalValue[0];
  }

  if (!isMulti && Array.isArray(internalValue) && !internalValue[0]) {
    internalValue = undefined;
  }

  return internalValue;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parseInternalValue);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/select/select.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/select/select.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.m.js");
/* harmony import */ var _use_select_use_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../use-select/use-select */ "./node_modules/@data-driven-forms/common/esm/use-select/use-select.js");


var _excluded = ["invalid", "classNamePrefix", "simpleValue", "isMulti", "pluckSingleValue", "options", "loadOptions", "loadingMessage", "loadingProps", "selectVariant", "updatingMessage", "noOptionsMessage", "value", "onChange", "loadOptionsChangeCounter", "SelectComponent", "noValueUpdates", "optionsTransformer"];

/* eslint-disable react-hooks/exhaustive-deps */





var Select = function Select(_ref) {
  var invalid = _ref.invalid,
      classNamePrefix = _ref.classNamePrefix,
      simpleValue = _ref.simpleValue,
      isMulti = _ref.isMulti,
      pluckSingleValue = _ref.pluckSingleValue,
      propsOptions = _ref.options,
      loadOptions = _ref.loadOptions,
      loadingMessage = _ref.loadingMessage,
      loadingProps = _ref.loadingProps,
      selectVariant = _ref.selectVariant,
      updatingMessage = _ref.updatingMessage,
      noOptionsMessage = _ref.noOptionsMessage,
      value = _ref.value,
      onChange = _ref.onChange,
      loadOptionsChangeCounter = _ref.loadOptionsChangeCounter,
      SelectComponent = _ref.SelectComponent,
      noValueUpdates = _ref.noValueUpdates,
      optionsTransformer = _ref.optionsTransformer,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  var _useSelect = (0,_use_select_use_select__WEBPACK_IMPORTED_MODULE_4__["default"])({
    loadOptions: loadOptions,
    optionsTransformer: optionsTransformer,
    options: propsOptions,
    noValueUpdates: noValueUpdates,
    onChange: onChange,
    value: value,
    loadOptionsChangeCounter: loadOptionsChangeCounter,
    isSearchable: props.isSearchable,
    pluckSingleValue: pluckSingleValue,
    isMulti: isMulti,
    simpleValue: simpleValue
  }),
      state = _useSelect.state,
      selectValue = _useSelect.value,
      selectOnChange = _useSelect.onChange,
      onInputChange = _useSelect.onInputChange,
      isFetching = _useSelect.isFetching;

  var renderNoOptionsMessage = function renderNoOptionsMessage() {
    return Object.values(state.promises).some(function (value) {
      return value;
    }) ? function () {
      return updatingMessage;
    } : function () {
      return noOptionsMessage;
    };
  }; // When isMulti is true, the "getSelect" always creates new value array, we need to memoize it to not create new array instance
  // Memo is required to fix https://github.com/data-driven-forms/react-forms/issues/1366
  // Keeping prev values in ref and calling lodash.isEqual is not reliable as it ca return false positive beucase it only has true/false result.
  // If we have multiple updates during one reconciliation pahse the search input reset will trigger on initial key stroke
  // JSON.stringify is expensive but seems to be working better.


  var selectValueInternal = (0,react__WEBPACK_IMPORTED_MODULE_2__.useMemo)(function () {
    return selectValue;
  }, [JSON.stringify(selectValue)]);

  if (state.isLoading) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(SelectComponent, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, props, {
      classNamePrefix: classNamePrefix,
      isDisabled: true,
      isFetching: true,
      placeholder: loadingMessage,
      options: state.options,
      onChange: function onChange() {},
      onInputChange: onInputChange,
      value: selectValueInternal,
      isMulti: isMulti
    }, loadingProps, {
      noOptionsMessage: renderNoOptionsMessage()
    }, state.originalOptions && {
      originalOptions: state.originalOptions
    }));
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(SelectComponent, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    className: (0,clsx__WEBPACK_IMPORTED_MODULE_3__["default"])(classNamePrefix, {
      'has-error': invalid
    })
  }, props, {
    isDisabled: props.isDisabled || props.isReadOnly,
    options: state.options,
    classNamePrefix: classNamePrefix,
    isMulti: isMulti,
    value: selectValueInternal,
    onChange: selectOnChange,
    onInputChange: onInputChange,
    isFetching: isFetching,
    noOptionsMessage: renderNoOptionsMessage(),
    hideSelectedOptions: false,
    closeMenuOnSelect: !isMulti
  }, state.originalOptions && {
    originalOptions: state.originalOptions
  }));
};

Select.propTypes = {
  options: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  classNamePrefix: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  invalid: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  simpleValue: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  isMulti: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  pluckSingleValue: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().any),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  loadOptionsChangeCounter: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  loadOptions: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  loadingMessage: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  loadingProps: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object),
  selectVariant: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  updatingMessage: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  noOptionsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  SelectComponent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().elementType.isRequired),
  noValueUpdates: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  optionsTransformer: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func)
};
Select.defaultProps = {
  options: [],
  invalid: false,
  simpleValue: true,
  pluckSingleValue: true,
  placeholder: 'Choose...',
  isSearchable: false,
  isClearable: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/use-select/reducer.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/use-select/reducer.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "init": () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

var init = function init(_ref) {
  var propsOptions = _ref.propsOptions,
      optionsTransformer = _ref.optionsTransformer;
  return _objectSpread({
    isLoading: false,
    options: optionsTransformer ? optionsTransformer(propsOptions) : propsOptions,
    promises: {},
    isInitialLoaded: false
  }, optionsTransformer && {
    originalOptions: propsOptions
  });
};

var reducer = function reducer(state, _ref2) {
  var type = _ref2.type,
      payload = _ref2.payload,
      _ref2$options = _ref2.options,
      options = _ref2$options === void 0 ? [] : _ref2$options,
      optionsTransformer = _ref2.optionsTransformer;

  switch (type) {
    case 'updateOptions':
      return _objectSpread(_objectSpread({}, state), {}, {
        options: optionsTransformer ? optionsTransformer(payload) : payload,
        isLoading: false,
        promises: {}
      }, optionsTransformer && {
        originalOptions: payload
      });

    case 'startLoading':
      return _objectSpread(_objectSpread({}, state), {}, {
        isLoading: true
      });

    case 'setOptions':
      return _objectSpread(_objectSpread({}, state), {}, {
        options: optionsTransformer ? optionsTransformer(payload) : payload
      }, optionsTransformer && {
        originalOptions: payload
      });

    case 'initialLoaded':
      return _objectSpread(_objectSpread({}, state), {}, {
        isInitialLoaded: true
      });

    case 'setPromises':
      return _objectSpread(_objectSpread({}, state), {}, {
        promises: _objectSpread(_objectSpread({}, state.promises), payload),
        options: optionsTransformer ? optionsTransformer([].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(state.options), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(options.filter(function (_ref3) {
          var value = _ref3.value;
          return !state.options.find(function (option) {
            return option.value === value;
          });
        })))) : [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(state.options), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(options.filter(function (_ref4) {
          var value = _ref4.value;
          return !state.options.find(function (option) {
            return option.value === value;
          });
        })))
      }, optionsTransformer && {
        originalOptions: [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(state.options), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(options.filter(function (_ref5) {
          var value = _ref5.value;
          return !state.options.find(function (option) {
            return option.value === value;
          });
        })))
      });

    default:
      return state;
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reducer);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/use-select/use-select.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/use-select/use-select.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _hooks_use_is_mounted__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/use-is-mounted */ "./node_modules/@data-driven-forms/common/esm/hooks/use-is-mounted.js");
/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./reducer */ "./node_modules/@data-driven-forms/common/esm/use-select/reducer.js");
/* harmony import */ var _utils_fn_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/fn-to-string */ "./node_modules/@data-driven-forms/common/esm/utils/fn-to-string.js");





function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }







var getSelectValue = function getSelectValue(stateValue, simpleValue, isMulti, allOptions) {
  var enhancedValue = stateValue;
  var hasSelectAll = isMulti && allOptions.find(function (_ref) {
    var selectAll = _ref.selectAll;
    return selectAll;
  });
  var hasSelectNone = isMulti && allOptions.find(function (_ref2) {
    var selectNone = _ref2.selectNone;
    return selectNone;
  });

  if (hasSelectAll || hasSelectNone) {
    enhancedValue = enhancedValue || [];
    var optionsLength = allOptions.filter(function (_ref3) {
      var selectAll = _ref3.selectAll,
          selectNone = _ref3.selectNone,
          divider = _ref3.divider,
          options = _ref3.options;
      return !selectAll && !selectNone && !divider && !options;
    }).length;
    var selectedAll = optionsLength === enhancedValue.length;
    var selectedNone = enhancedValue.length === 0;
    enhancedValue = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(enhancedValue), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(hasSelectAll && selectedAll ? [simpleValue ? hasSelectAll.value : hasSelectAll] : []), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(hasSelectNone && selectedNone ? [simpleValue ? hasSelectNone.value : hasSelectNone] : []));
  }

  return simpleValue ? allOptions.filter(function (_ref4) {
    var value = _ref4.value;
    return isMulti ? enhancedValue.includes(value) : lodash_isEqual__WEBPACK_IMPORTED_MODULE_5___default()(value, enhancedValue);
  }) : enhancedValue;
};

var handleSelectChange = function handleSelectChange(option, simpleValue, isMulti, onChange, allOptions, removeSelectAll, removeSelectNone) {
  var enhanceOption = option;

  if (removeSelectNone) {
    enhanceOption = enhanceOption.filter(function (_ref5) {
      var selectNone = _ref5.selectNone;
      return !selectNone;
    });
  } else if (removeSelectAll) {
    enhanceOption = enhanceOption.filter(function (_ref6) {
      var selectAll = _ref6.selectAll;
      return !selectAll;
    });
  }

  var sanitizedOption = !enhanceOption && isMulti ? [] : enhanceOption;

  if (isMulti && sanitizedOption.find(function (_ref7) {
    var selectAll = _ref7.selectAll;
    return selectAll;
  })) {
    return onChange(allOptions.filter(function (_ref8) {
      var selectAll = _ref8.selectAll,
          selectNone = _ref8.selectNone,
          value = _ref8.value;
      return !selectAll && !selectNone && value;
    }).map(function (_ref9) {
      var value = _ref9.value;
      return value;
    }));
  }

  if (isMulti && sanitizedOption.find(function (_ref10) {
    var selectNone = _ref10.selectNone;
    return selectNone;
  })) {
    return onChange([]);
  }

  return simpleValue ? onChange(isMulti ? sanitizedOption.map(function (item) {
    return item.value;
  }) : sanitizedOption ? sanitizedOption.value : undefined) : onChange(sanitizedOption);
};

var useSelect = function useSelect(_ref11) {
  var loadOptions = _ref11.loadOptions,
      optionsTransformer = _ref11.optionsTransformer,
      propsOptions = _ref11.options,
      noValueUpdates = _ref11.noValueUpdates,
      _onChange = _ref11.onChange,
      value = _ref11.value,
      loadOptionsChangeCounter = _ref11.loadOptionsChangeCounter,
      isSearchable = _ref11.isSearchable,
      pluckSingleValue = _ref11.pluckSingleValue,
      isMulti = _ref11.isMulti,
      simpleValue = _ref11.simpleValue;

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_4__.useReducer)(_reducer__WEBPACK_IMPORTED_MODULE_7__["default"], {
    optionsTransformer: optionsTransformer,
    propsOptions: propsOptions
  }, _reducer__WEBPACK_IMPORTED_MODULE_7__.init),
      _useReducer2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useReducer, 2),
      state = _useReducer2[0],
      originalDispatch = _useReducer2[1];

  var dispatch = function dispatch(action) {
    return originalDispatch(_objectSpread(_objectSpread({}, action), {}, {
      optionsTransformer: optionsTransformer
    }));
  };

  var isMounted = (0,_hooks_use_is_mounted__WEBPACK_IMPORTED_MODULE_6__["default"])();

  var updateOptions = function updateOptions() {
    dispatch({
      type: 'startLoading'
    });
    return loadOptions().then(function (data) {
      if (isMounted.current) {
        if (!noValueUpdates) {
          if (value && Array.isArray(value)) {
            var _selectValue = value.filter(function (value) {
              return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(value) === 'object' ? data.find(function (option) {
                return value.value === option.value;
              }) : data.find(function (option) {
                return value === option.value;
              });
            });

            _onChange(_selectValue.length === 0 ? undefined : _selectValue);
          } else if (value && !data.find(function (_ref12) {
            var internalValue = _ref12.value;
            return internalValue === value;
          })) {
            _onChange(undefined);
          }
        }

        dispatch({
          type: 'updateOptions',
          payload: data
        });
      }
    });
  };

  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(function () {
    if (loadOptions) {
      updateOptions();
    }

    dispatch({
      type: 'initialLoaded'
    });
  }, []);
  var loadOptionsStr = loadOptions ? (0,_utils_fn_to_string__WEBPACK_IMPORTED_MODULE_8__["default"])(loadOptions) : '';
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(function () {
    if (loadOptionsStr && state.isInitialLoaded) {
      updateOptions();
    }
  }, [loadOptionsStr, loadOptionsChangeCounter]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(function () {
    if (state.isInitialLoaded) {
      if (!noValueUpdates && value && !propsOptions.map(function (_ref13) {
        var value = _ref13.value;
        return value;
      }).includes(value)) {
        _onChange(undefined);
      }

      dispatch({
        type: 'setOptions',
        payload: propsOptions
      });
    }
  }, [propsOptions]);

  var onInputChange = function onInputChange(inputValue) {
    if (inputValue && loadOptions && state.promises[inputValue] === undefined && isSearchable) {
      dispatch({
        type: 'setPromises',
        payload: (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, inputValue, true)
      });
      loadOptions(inputValue).then(function (options) {
        if (isMounted.current) {
          dispatch({
            type: 'setPromises',
            payload: (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, inputValue, false),
            options: options
          });
        }
      })["catch"](function (error) {
        dispatch({
          type: 'setPromises',
          payload: (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, inputValue, false)
        }); // eslint-disable-next-line no-console

        console.error(error);
      });
    }
  };

  var selectValue = pluckSingleValue ? isMulti ? value : Array.isArray(value) && value[0] ? value[0] : value : value;
  var filteredLength = state.options.filter(function (_ref14) {
    var selectAll = _ref14.selectAll,
        selectNone = _ref14.selectNone;
    return !selectAll && !selectNone;
  }).length;
  var shouldRemoveSelectAll = isMulti && state.options.find(function (_ref15) {
    var selectAll = _ref15.selectAll;
    return selectAll;
  }) && selectValue.length === filteredLength;
  var shouldRemoveSelectNone = isMulti && state.options.find(function (_ref16) {
    var selectNone = _ref16.selectNone;
    return selectNone;
  }) && selectValue.length === 0;
  return {
    value: getSelectValue(selectValue, simpleValue, isMulti, state.options),
    onChange: function onChange(option) {
      return handleSelectChange(option, simpleValue, isMulti, _onChange, state.options, shouldRemoveSelectAll, shouldRemoveSelectNone);
    },
    onInputChange: onInputChange,
    isFetching: Object.values(state.promises).some(function (value) {
      return value;
    }),
    state: state
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSelect);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/esm/utils/fn-to-string.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/esm/utils/fn-to-string.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var fnToString = function fnToString() {
  var fn = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  return fn.toString().replace(/\s+/g, ' ');
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fnToString);

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/select/parse-internal-value.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/select/parse-internal-value.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js"));

/**
 * Parses internal select value based on isMulti attribute
 * @param {Array} value value of the ddf internal select implementaion
 * @param {Boolean} isMulti if true, select is multi value
 * @returns {Array|String|Number|Boolean|Object|undefined|null}
 */
var parseInternalValue = function parseInternalValue(value) {
  var isMulti = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var internalValue = value;

  if (isMulti && Array.isArray(internalValue)) {
    internalValue = value.map(function (item) {
      return (0, _typeof2["default"])(item) === 'object' ? item.value : item;
    });
  }

  if (!isMulti && Array.isArray(internalValue) && internalValue[0]) {
    internalValue = (0, _typeof2["default"])(internalValue[0]) === 'object' ? internalValue[0].value : internalValue[0];
  }

  if (!isMulti && Array.isArray(internalValue) && !internalValue[0]) {
    internalValue = undefined;
  }

  return internalValue;
};

var _default = parseInternalValue;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/utils/valid-text-fields.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/utils/valid-text-fields.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var validTextFields = ['p', 'span', 'strong', 'b', 'cite', 'caption', 'code', 'em', 'i', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'h6', 'div', 'label', 'pre', 'q', 'samp', 'small', 'sub', 'sup'];
var _default = validTextFields;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/wizard/consts.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/wizard/consts.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CONDITIONAL_SUBMIT_FLAG = void 0;
var CONDITIONAL_SUBMIT_FLAG = '@@ddf-common-wizard__conditional-submit-step';
exports.CONDITIONAL_SUBMIT_FLAG = CONDITIONAL_SUBMIT_FLAG;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/wizard/enter-handler.js":
/*!************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/wizard/enter-handler.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _selectNext = _interopRequireDefault(__webpack_require__(/*! ./select-next */ "./node_modules/@data-driven-forms/common/wizard/select-next.js"));

var enterHandler = function enterHandler(e, formOptions, activeStep, findCurrentStep, handleNext, handleSubmit) {
  if (e.key === 'Enter' && !e.shiftKey && !e.ctrlKey) {
    var isNotButton = e.target.type !== 'button';

    if (isNotButton) {
      e.preventDefault();
      var schemaNextStep = findCurrentStep(activeStep).nextStep;
      var hasCustomButtons = findCurrentStep(activeStep).buttons;
      var nextStep;

      if (schemaNextStep) {
        nextStep = (0, _selectNext["default"])(schemaNextStep, formOptions.getState);
      }

      var canContinue = formOptions.valid && !formOptions.getState().validating;

      if (canContinue && nextStep && !hasCustomButtons) {
        handleNext(nextStep, formOptions.getRegisteredFields);
      } else if (canContinue && !schemaNextStep && !hasCustomButtons) {
        handleSubmit();
      }
    }
  }
};

var _default = enterHandler;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/wizard/reducer.js":
/*!******************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/wizard/reducer.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.findCurrentStep = exports["default"] = exports.DYNAMIC_WIZARD_TYPES = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js"));

var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/toConsumableArray.js"));

var _get = _interopRequireDefault(__webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

var DYNAMIC_WIZARD_TYPES = ['function', 'object'];
exports.DYNAMIC_WIZARD_TYPES = DYNAMIC_WIZARD_TYPES;

var createSchema = function createSchema(_ref) {
  var formOptions = _ref.formOptions,
      fields = _ref.fields;

  var _formOptions$getState = formOptions.getState(),
      values = _formOptions$getState.values;

  var schema = [];
  var field = fields[0]; // find first wizard step

  var index = -1;

  var _loop = function _loop() {
    var _field$substepOf, _schema, _schema2, _field$substepOf2;

    index += 1;
    schema = [].concat((0, _toConsumableArray2["default"])(schema), [{
      name: field.name,
      title: field.title,
      substepOf: ((_field$substepOf = field.substepOf) === null || _field$substepOf === void 0 ? void 0 : _field$substepOf.name) || field.substepOf,
      substepOfTitle: field.substepOf === ((_schema = schema[schema.length - 1]) === null || _schema === void 0 ? void 0 : _schema.substepOf) && ((_schema2 = schema[schema.length - 1]) === null || _schema2 === void 0 ? void 0 : _schema2.substepOfTitle) || ((_field$substepOf2 = field.substepOf) === null || _field$substepOf2 === void 0 ? void 0 : _field$substepOf2.title) || field.substepOf,
      index: index,
      primary: !schema[schema.length - 1] || !field.substepOf || field.substepOf !== schema[schema.length - 1].substepOf
    }]);
    var nextStep = field.nextStep;

    if ((0, _typeof2["default"])(field.nextStep) === 'object') {
      nextStep = nextStep.stepMapper[(0, _get["default"])(values, nextStep.when)];
    }

    if (typeof field.nextStep === 'function') {
      nextStep = field.nextStep({
        values: values
      });
    }

    if (nextStep) {
      field = fields.find(function (_ref2) {
        var name = _ref2.name;
        return name === nextStep;
      });
    } else {
      field = undefined;
    }
  };

  while (field) {
    _loop();
  }

  return schema;
};

var handleNext = function handleNext(state, nextStep, formOptions, fields) {
  var newActiveIndex = state.activeStepIndex + 1;
  var shouldInsertStepIntoHistory = state.prevSteps.includes(state.activeStep);
  return _objectSpread(_objectSpread({}, state), {}, {
    registeredFieldsHistory: _objectSpread(_objectSpread({}, state.registeredFieldsHistory), {}, (0, _defineProperty2["default"])({}, state.activeStep, formOptions.getRegisteredFields())),
    activeStep: nextStep,
    prevSteps: shouldInsertStepIntoHistory ? state.prevSteps : [].concat((0, _toConsumableArray2["default"])(state.prevSteps), [state.activeStep]),
    activeStepIndex: newActiveIndex,
    maxStepIndex: newActiveIndex > state.maxStepIndex ? newActiveIndex : state.maxStepIndex,
    navSchema: state.isDynamic ? createSchema({
      fields: fields,
      formOptions: formOptions
    }) : state.navSchema
  });
};

var findCurrentStep = function findCurrentStep(activeStep, fields) {
  return fields.find(function (_ref3) {
    var name = _ref3.name;
    return name === activeStep;
  });
};

exports.findCurrentStep = findCurrentStep;

var jumpToStep = function jumpToStep(state, index, valid, fields, crossroads, formOptions) {
  if (index === state.activeStepIndex) {
    return state;
  }

  var clickOnPreviousStep = state.prevSteps[index];

  if (!clickOnPreviousStep) {
    return state;
  }

  if (clickOnPreviousStep) {
    var originalActiveStep;
    var includeActiveStep = state.prevSteps.includes(state.activeStep, fields);
    originalActiveStep = state.activeStep;

    var newState = _objectSpread(_objectSpread({}, state), {}, {
      activeStep: state.prevSteps[index],
      prevSteps: includeActiveStep ? state.prevSteps : [].concat((0, _toConsumableArray2["default"])(state.prevSteps), [state.activeStep]),
      activeStepIndex: index
    });

    var INDEXING_BY_ZERO = 1;
    var currentStep = findCurrentStep(newState.prevSteps[index], fields);
    var currentStepHasStepMapper = DYNAMIC_WIZARD_TYPES.includes((0, _typeof2["default"])(currentStep.nextStep));
    var hardcodedCrossroads = crossroads;
    var dynamicStepShouldDisableNav = newState.isDynamic && currentStepHasStepMapper;
    var invalidStepShouldDisableNav = valid === false;

    var updatedState = _objectSpread({}, newState);

    if (dynamicStepShouldDisableNav && !hardcodedCrossroads) {
      updatedState = _objectSpread(_objectSpread({}, updatedState), {}, {
        navSchema: createSchema({
          formOptions: formOptions,
          fields: fields
        }),
        prevSteps: newState.prevSteps.slice(0, index),
        maxStepIndex: index
      });
    } else if (currentStep.disableForwardJumping) {
      updatedState = _objectSpread(_objectSpread({}, updatedState), {}, {
        prevSteps: newState.prevSteps.slice(0, index),
        maxStepIndex: index
      });
    } else if (invalidStepShouldDisableNav) {
      var indexOfCurrentStep = newState.prevSteps.indexOf(originalActiveStep);
      updatedState = _objectSpread(_objectSpread({}, updatedState), {}, {
        prevSteps: newState.prevSteps.slice(0, indexOfCurrentStep + INDEXING_BY_ZERO),
        maxStepIndex: newState.prevSteps.slice(0, indexOfCurrentStep + INDEXING_BY_ZERO).length - INDEXING_BY_ZERO
      });
    }

    return updatedState;
  }
};

var reducer = function reducer(state, _ref4) {
  var type = _ref4.type,
      payload = _ref4.payload;

  switch (type) {
    case 'finishLoading':
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false,
        navSchema: createSchema({
          fields: payload.fields,
          formOptions: payload.formOptions
        })
      });

    case 'handleNext':
      return handleNext(state, payload.nextStep, payload.formOptions, payload.fields);

    case 'setPrevSteps':
      return _objectSpread(_objectSpread({}, state), {}, {
        prevSteps: state.prevSteps.slice(0, state.activeStepIndex),
        maxStepIndex: state.activeStepIndex,
        navSchema: createSchema({
          fields: payload.fields,
          formOptions: payload.formOptions
        })
      });

    case 'jumpToStep':
      return jumpToStep(state, payload.index, payload.valid, payload.fields, payload.crossroads, payload.formOptions);

    default:
      return state;
  }
};

var _default = reducer;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/wizard/select-next.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/wizard/select-next.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _get = _interopRequireDefault(__webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js"));

var selectNext = function selectNext(nextStep, getState) {
  if (typeof nextStep === 'string') {
    return nextStep;
  }

  if (typeof nextStep === 'function') {
    return nextStep({
      values: getState().values
    });
  }

  var selectedValue = (0, _get["default"])(getState().values, nextStep.when);
  return nextStep.stepMapper[selectedValue];
};

var _default = selectNext;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/common/wizard/wizard.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@data-driven-forms/common/wizard/wizard.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

var _typeof3 = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.wizardProps = exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/toConsumableArray.js"));

var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/slicedToArray.js"));

var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));

var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js"));

var _useFormApi = _interopRequireDefault(__webpack_require__(/*! @data-driven-forms/react-form-renderer/use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js"));

var _wizardContext = _interopRequireDefault(__webpack_require__(/*! @data-driven-forms/react-form-renderer/wizard-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/index.js"));

var _get = _interopRequireDefault(__webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js"));

var _set = _interopRequireDefault(__webpack_require__(/*! lodash/set */ "./node_modules/lodash/set.js"));

var _flattenDeep = _interopRequireDefault(__webpack_require__(/*! lodash/flattenDeep */ "./node_modules/lodash/flattenDeep.js"));

var _enterHandler = _interopRequireDefault(__webpack_require__(/*! ./enter-handler */ "./node_modules/@data-driven-forms/common/wizard/enter-handler.js"));

var _reducer = _interopRequireWildcard(__webpack_require__(/*! ./reducer */ "./node_modules/@data-driven-forms/common/wizard/reducer.js"));

var _selectNext = _interopRequireDefault(__webpack_require__(/*! ./select-next */ "./node_modules/@data-driven-forms/common/wizard/select-next.js"));

var _consts = __webpack_require__(/*! ./consts */ "./node_modules/@data-driven-forms/common/wizard/consts.js");

var _excluded = ["fields", "isDynamic", "crossroads", "Wizard", "component", "initialState"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

var Wizard = function Wizard(_ref) {
  var fields = _ref.fields,
      isDynamic = _ref.isDynamic,
      crossroads = _ref.crossroads,
      Wizard = _ref.Wizard,
      component = _ref.component,
      initialState = _ref.initialState,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var formOptions = (0, _useFormApi["default"])();

  var _useReducer = (0, _react.useReducer)(_reducer["default"], _objectSpread(_objectSpread({
    activeStep: fields[0].name,
    prevSteps: [],
    activeStepIndex: 0,
    maxStepIndex: 0
  }, initialState), {}, {
    isDynamic: isDynamic || fields.some(function (_ref2) {
      var nextStep = _ref2.nextStep;
      return _reducer.DYNAMIC_WIZARD_TYPES.includes((0, _typeof2["default"])(nextStep));
    }),
    loading: true
  })),
      _useReducer2 = (0, _slicedToArray2["default"])(_useReducer, 2),
      state = _useReducer2[0],
      dispatch = _useReducer2[1];

  (0, _react.useEffect)(function () {
    dispatch({
      type: 'finishLoading',
      payload: {
        formOptions: formOptions,
        fields: fields
      }
    });
  }, [fields]);

  if (state.loading) {
    return null;
  }

  var prepareValues = function prepareValues(values, visitedSteps, getRegisteredFields) {
    // Add the final step fields to history
    var finalRegisteredFieldsHistory = _objectSpread(_objectSpread({}, state.registeredFieldsHistory), {}, (0, _defineProperty2["default"])({}, state.activeStep, getRegisteredFields()));

    var finalObject = {}; // Find only visited fields

    (0, _flattenDeep["default"])(Object.values([].concat((0, _toConsumableArray2["default"])(visitedSteps), [state.activeStep]).reduce(function (obj, key) {
      return _objectSpread(_objectSpread({}, obj), {}, (0, _defineProperty2["default"])({}, key, finalRegisteredFieldsHistory[key]));
    }, {}))).forEach(function (key) {
      return (0, _set["default"])(finalObject, key, (0, _get["default"])(values, key));
    });
    return finalObject;
  };

  var onCancel = function onCancel() {
    return formOptions.onCancel(state);
  };

  var handleSubmit = function handleSubmit() {
    return formOptions.onSubmit(prepareValues(formOptions.getState().values, [].concat((0, _toConsumableArray2["default"])(state.prevSteps), [state.activeStep]), formOptions.getRegisteredFields), formOptions, state);
  };

  var jumpToStep = function jumpToStep(index, valid) {
    return dispatch({
      type: 'jumpToStep',
      payload: {
        index: index,
        valid: valid,
        fields: fields,
        crossroads: crossroads,
        formOptions: formOptions
      }
    });
  };

  var handlePrev = function handlePrev() {
    return jumpToStep(state.activeStepIndex - 1);
  };

  var handleNext = function handleNext(nextStep) {
    return dispatch({
      type: 'handleNext',
      payload: {
        nextStep: nextStep,
        formOptions: formOptions,
        fields: fields
      }
    });
  };

  var setPrevSteps = function setPrevSteps() {
    return dispatch({
      type: 'setPrevSteps',
      payload: {
        formOptions: formOptions,
        fields: fields
      }
    });
  };

  var findCurrentStepWrapped = function findCurrentStepWrapped(step) {
    return (0, _reducer.findCurrentStep)(step, fields);
  };

  var onKeyDown = function onKeyDown(e) {
    return (0, _enterHandler["default"])(e, formOptions, state.activeStep, findCurrentStepWrapped, handleNext, handleSubmit);
  };

  return /*#__PURE__*/_react["default"].createElement(_wizardContext["default"].Provider, {
    value: {
      handleNext: handleNext,
      onKeyDown: onKeyDown,
      setPrevSteps: setPrevSteps,
      currentStep: (0, _reducer.findCurrentStep)(state.activeStep, fields),
      jumpToStep: jumpToStep,
      handlePrev: handlePrev,
      formOptions: _objectSpread(_objectSpread({}, formOptions), {}, {
        onCancel: onCancel,
        handleSubmit: handleSubmit
      }),
      navSchema: state.navSchema,
      activeStepIndex: state.activeStepIndex,
      maxStepIndex: state.maxStepIndex,
      isDynamic: state.isDynamic,
      crossroads: crossroads,
      prevSteps: state.prevSteps,
      selectNext: _selectNext["default"]
    }
  }, /*#__PURE__*/_react["default"].createElement(Wizard, props));
};

Wizard.propTypes = {
  fields: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    name: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number]).isRequired
  })).isRequired,
  isDynamic: _propTypes["default"].bool,
  crossroads: _propTypes["default"].arrayOf(_propTypes["default"].string),
  Wizard: _propTypes["default"].oneOfType([_propTypes["default"].node, _propTypes["default"].func]),
  component: _propTypes["default"].any,
  initialState: _propTypes["default"].object,
  conditionalSubmitFlag: _propTypes["default"].string
};
Wizard.defaultProps = {
  conditionalSubmitFlag: _consts.CONDITIONAL_SUBMIT_FLAG
};
var _default = Wizard;
exports["default"] = _default;
var wizardProps = {
  currentStep: _propTypes["default"].object,
  handlePrev: _propTypes["default"].func,
  onKeyDown: _propTypes["default"].func,
  jumpToStep: _propTypes["default"].func,
  setPrevSteps: _propTypes["default"].func,
  handleNext: _propTypes["default"].func,
  navSchema: _propTypes["default"].array,
  activeStepIndex: _propTypes["default"].number,
  maxStepIndex: _propTypes["default"].number,
  formOptions: _propTypes["default"].shape({
    onCancel: _propTypes["default"].func
  }),
  prevSteps: _propTypes["default"].array
};
exports.wizardProps = wizardProps;

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/checkbox.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/checkbox.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _multiple_choice_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./multiple-choice-list */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/multiple-choice-list.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Checkbox_Checkbox_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js");
/* harmony import */ var _is_required_is_required__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../is-required/is-required */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/is-required/is-required.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"],
    _excluded2 = ["options"];








var SingleCheckbox = function SingleCheckbox(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_5__["default"], {
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: true,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Checkbox_Checkbox_js__WEBPACK_IMPORTED_MODULE_7__.Checkbox, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    isChecked: input.checked
  }, input, {
    id: id || input.name,
    label: isRequired ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_is_required_is_required__WEBPACK_IMPORTED_MODULE_6__["default"], null, label) : label,
    "aria-label": rest.name
  }, rest, {
    isDisabled: isDisabled || isReadOnly
  })));
};

SingleCheckbox.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object)
};

var Checkbox = function Checkbox(_ref) {
  var options = _ref.options,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded2);

  return options ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_multiple_choice_list__WEBPACK_IMPORTED_MODULE_3__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    options: options
  }, props)) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(SingleCheckbox, props);
};

Checkbox.propTypes = {
  options: prop_types__WEBPACK_IMPORTED_MODULE_8___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().any)
  }))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Checkbox);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _checkbox__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _checkbox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checkbox */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/checkbox.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/multiple-choice-list.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/multiple-choice-list.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_Checkbox_Checkbox_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js");
/* harmony import */ var _data_driven_forms_common_multiple_choice_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/common/multiple-choice-list */ "./node_modules/@data-driven-forms/common/esm/multiple-choice-list/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");



var _excluded = ["option"],
    _excluded2 = ["meta", "children"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }







var FinalCheckbox = function FinalCheckbox(_ref) {
  var option = _ref.option,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Checkbox_Checkbox_js__WEBPACK_IMPORTED_MODULE_6__.Checkbox, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    isChecked: props.checked
  }, props, {
    onChange: function onChange(_value, e) {
      return props.onChange(e);
    }
  }, option));
};

FinalCheckbox.propTypes = {
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func.isRequired),
  option: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)
};

var Wrapper = function Wrapper(_ref2) {
  var meta = _ref2.meta,
      children = _ref2.children,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref2, _excluded2);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_5__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, rest, {
    id: rest.name || rest.id,
    meta: meta
  }), children);
};

Wrapper.propTypes = _objectSpread({}, _data_driven_forms_common_multiple_choice_list__WEBPACK_IMPORTED_MODULE_4__.wrapperProps);

var MultipleChoiceList = function MultipleChoiceList(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_data_driven_forms_common_multiple_choice_list__WEBPACK_IMPORTED_MODULE_4__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, props, {
    Wrapper: Wrapper,
    Checkbox: FinalCheckbox
  }));
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultipleChoiceList);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/component-mapper.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/component-mapper.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "components": () => (/* binding */ components),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "rawComponents": () => (/* binding */ rawComponents)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../tabs */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/index.js");
/* harmony import */ var _sub_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sub-form */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/index.js");
/* harmony import */ var _wizard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../wizard */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/index.js");
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/index.js");
/* harmony import */ var _select_select_select__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../select/select/select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/select.js");
/* harmony import */ var _field_array__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../field-array */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/index.js");
/* harmony import */ var _text_field__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../text-field */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/index.js");
/* harmony import */ var _textarea__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../textarea */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/index.js");
/* harmony import */ var _checkbox__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../checkbox */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/index.js");
/* harmony import */ var _radio__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../radio */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/index.js");
/* harmony import */ var _date_picker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../date-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/index.js");
/* harmony import */ var _time_picker__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../time-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/index.js");
/* harmony import */ var _switch__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../switch */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/index.js");
/* harmony import */ var _plain_text__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../plain-text */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/index.js");
/* harmony import */ var _dual_list_select__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../dual-list-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/index.js");
/* harmony import */ var _slider__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../slider */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/index.js");


var _mapper;


















var mapper = (_mapper = {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].TEXT_FIELD, _text_field__WEBPACK_IMPORTED_MODULE_8__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].TEXTAREA, _textarea__WEBPACK_IMPORTED_MODULE_9__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].SELECT, _select__WEBPACK_IMPORTED_MODULE_5__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].CHECKBOX, _checkbox__WEBPACK_IMPORTED_MODULE_10__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_FORM, _sub_form__WEBPACK_IMPORTED_MODULE_3__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].RADIO, _radio__WEBPACK_IMPORTED_MODULE_11__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].TABS, _tabs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].DATE_PICKER, _date_picker__WEBPACK_IMPORTED_MODULE_12__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].TIME_PICKER, _time_picker__WEBPACK_IMPORTED_MODULE_13__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].WIZARD, _wizard__WEBPACK_IMPORTED_MODULE_4__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].SWITCH, _switch__WEBPACK_IMPORTED_MODULE_14__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].PLAIN_TEXT, _plain_text__WEBPACK_IMPORTED_MODULE_15__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].FIELD_ARRAY, _field_array__WEBPACK_IMPORTED_MODULE_7__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].DUAL_LIST_SELECT, _dual_list_select__WEBPACK_IMPORTED_MODULE_16__["default"]), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_mapper, _data_driven_forms_react_form_renderer_component_types__WEBPACK_IMPORTED_MODULE_1__["default"].SLIDER, _slider__WEBPACK_IMPORTED_MODULE_17__["default"]), _mapper);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mapper);
var components = {
  TextField: _text_field__WEBPACK_IMPORTED_MODULE_8__["default"],
  Textarea: _textarea__WEBPACK_IMPORTED_MODULE_9__["default"],
  Checkbox: _checkbox__WEBPACK_IMPORTED_MODULE_10__["default"],
  Radio: _radio__WEBPACK_IMPORTED_MODULE_11__["default"],
  Select: _select__WEBPACK_IMPORTED_MODULE_5__["default"],
  DatePicker: _date_picker__WEBPACK_IMPORTED_MODULE_12__["default"],
  TimePicker: _time_picker__WEBPACK_IMPORTED_MODULE_13__["default"],
  Switch: _switch__WEBPACK_IMPORTED_MODULE_14__["default"],
  PlainText: _plain_text__WEBPACK_IMPORTED_MODULE_15__["default"],
  DualListSelect: _dual_list_select__WEBPACK_IMPORTED_MODULE_16__["default"],
  Slider: _slider__WEBPACK_IMPORTED_MODULE_17__["default"]
};
var rawComponents = {
  RawSelect: _select_select_select__WEBPACK_IMPORTED_MODULE_6__["default"]
};

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/index.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/index.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "components": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__.components),
/* harmony export */   "default": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "rawComponents": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__.rawComponents)
/* harmony export */ });
/* harmony import */ var _component_mapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component-mapper */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/component-mapper.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/date-picker.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/date-picker.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_DatePicker_DatePicker_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/DatePicker/DatePicker.js */ "./node_modules/@patternfly/react-core/dist/esm/components/DatePicker/DatePicker.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];






var DatePicker = function DatePicker(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_4__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_DatePicker_DatePicker_js__WEBPACK_IMPORTED_MODULE_5__.DatePicker, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, input, rest, {
    id: id || input.name,
    isDisabled: isDisabled || isReadOnly
  })));
};

DatePicker.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DatePicker);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/index.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _date_picker__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _date_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./date-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/date-picker.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/dual-list-context.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/dual-list-context.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var DualListContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DualListContext);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _dual_list_context__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _dual_list_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dual-list-context */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/dual-list-context.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/dual-list-select.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/dual-list-select.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_DualListSelector_DualListSelector_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _dual_list_tree_select_dual_list_tree_select__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dual-list-tree-select/dual-list-tree-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/dual-list-tree-select.js");
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/index.js");
/* harmony import */ var _dual_list_context__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../dual-list-context */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js");






var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "id", "input", "FormGroupProps", "options", "getValueFromNode", "isSearchable", "isSortable"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }










var DualList = function DualList(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_7__["default"])(_objectSpread(_objectSpread({}, props), {}, {
    FieldProps: {
      isEqual: function isEqual(current, initial) {
        return lodash_isEqual__WEBPACK_IMPORTED_MODULE_8___default()((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(current || []).sort(), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(initial || []).sort());
      }
    }
  })),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      id = _useFieldApi.id,
      input = _useFieldApi.input,
      FormGroupProps = _useFieldApi.FormGroupProps,
      options = _useFieldApi.options,
      getValueFromNode = _useFieldApi.getValueFromNode,
      isSearchable = _useFieldApi.isSearchable,
      isSortable = _useFieldApi.isSortable,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_5__["default"])(_useFieldApi, _excluded);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(function () {
    return {
      left: isSortable && 'asc',
      right: isSortable && 'asc'
    };
  }),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useState, 2),
      sortConfig = _useState2[0],
      setSortConfig = _useState2[1];

  var value = input.value || [];
  var leftOptions;
  var rightOptions;
  var onListChange;
  var filterOption;

  if (!getValueFromNode) {
    leftOptions = options.filter(function (option) {
      return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(option) === 'object' ? !value.includes(option.value) : !value.includes(option);
    }).map(function (option) {
      return option.label || option;
    });
    rightOptions = options.filter(function (option) {
      return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(option) === 'object' ? value.includes(option.value) : value.includes(option);
    }).map(function (option) {
      return option.label || option;
    });

    onListChange = function onListChange(_newLeft, newRight) {
      return input.onChange(newRight);
    };

    filterOption = function filterOption(option, input) {
      return option.value ? option.value.includes(input) : option.includes(input);
    };
  } else {
    leftOptions = options.filter(function (option) {
      return option.value ? !value.includes(option.value) : !value.includes(getValueFromNode(option));
    }).map(function (option) {
      return option.label || option;
    });
    rightOptions = options.filter(function (option) {
      return option.value ? value.includes(option.value) : value.includes(getValueFromNode(option));
    }).map(function (option) {
      return option.label || option;
    });

    onListChange = function onListChange(_newLeft, newRight) {
      return input.onChange(newRight === null || newRight === void 0 ? void 0 : newRight.map(getValueFromNode));
    };

    filterOption = function filterOption(option, input) {
      return option.value ? option.value.includes(input) : getValueFromNode(option).includes(input);
    };
  }

  if (isSortable) {
    var sort = function sort(direction, a, b) {
      return direction === 'asc' ? a.localeCompare(b) : b.localeCompare(a);
    };

    if (!getValueFromNode) {
      leftOptions = leftOptions.sort(function (a, b) {
        return sort(sortConfig.left, a.label || a, b.label || b);
      });
      rightOptions = rightOptions.sort(function (a, b) {
        return sort(sortConfig.right, a.label || a, b.label || b);
      });
    } else {
      leftOptions = leftOptions.sort(function (a, b) {
        return sort(sortConfig.left, getValueFromNode(a.label || a), getValueFromNode(b.label || b));
      });
      rightOptions = rightOptions.sort(function (a, b) {
        return sort(sortConfig.right, getValueFromNode(a.label || a), getValueFromNode(b.label || b));
      });
    }
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_form_group__WEBPACK_IMPORTED_MODULE_10__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_dual_list_context__WEBPACK_IMPORTED_MODULE_11__["default"].Provider, {
    value: {
      sortConfig: sortConfig,
      setSortConfig: setSortConfig
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_patternfly_react_core_dist_esm_components_DualListSelector_DualListSelector_js__WEBPACK_IMPORTED_MODULE_12__.DualListSelector, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    availableOptions: leftOptions,
    chosenOptions: rightOptions,
    onListChange: onListChange,
    id: id || input.name,
    isSearchable: isSearchable
  }, getValueFromNode && {
    addAll: onListChange,
    addSelected: onListChange,
    filterOption: filterOption,
    removeAll: onListChange,
    removeSelected: onListChange
  }, rest))));
};

DualList.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  getValueFromNode: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool),
  isSortable: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool)
};

var DualListWrapper = function DualListWrapper(props) {
  return props.isTree ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_dual_list_tree_select_dual_list_tree_select__WEBPACK_IMPORTED_MODULE_9__["default"], props) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(DualList, props);
};

DualListWrapper.propTypes = {
  isTree: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DualListWrapper);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/index.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/index.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _dual_list_select__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _dual_list_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dual-list-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/dual-list-select.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/dual-list-sort-button.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/dual-list-sort-button.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Button/Button.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_pficon_sort_common_asc_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/pficon-sort-common-asc-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/pficon-sort-common-asc-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_pficon_sort_common_desc_icon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/pficon-sort-common-desc-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/pficon-sort-common-desc-icon.js");
/* harmony import */ var _dual_list_context__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dual-list-context */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js");



var _excluded = ["position"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }









var DualListSortButton = function DualListSortButton(_ref) {
  var position = _ref.position,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref, _excluded);

  var _useContext = (0,react__WEBPACK_IMPORTED_MODULE_3__.useContext)(_dual_list_context__WEBPACK_IMPORTED_MODULE_4__["default"]),
      sortConfig = _useContext.sortConfig,
      setSortConfig = _useContext.setSortConfig;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_5__.Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    variant: _patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_5__.ButtonVariant.plain,
    onClick: sortConfig[position] === 'asc' ? function () {
      return setSortConfig(_objectSpread(_objectSpread({}, sortConfig), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, position, 'desc')));
    } : function () {
      return setSortConfig(_objectSpread(_objectSpread({}, sortConfig), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])({}, position, 'asc')));
    },
    "aria-label": "Sort"
  }, rest), sortConfig[position] === 'asc' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_icons_dist_esm_icons_pficon_sort_common_asc_icon__WEBPACK_IMPORTED_MODULE_6__["default"], null) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_icons_dist_esm_icons_pficon_sort_common_desc_icon__WEBPACK_IMPORTED_MODULE_7__["default"], null));
};

DualListSortButton.propTypes = {
  position: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOf(['left', 'right'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DualListSortButton);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/index.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/index.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _dual_list_sort_button__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _dual_list_sort_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dual-list-sort-button */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/dual-list-sort-button.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/dual-list-tree-select.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/dual-list-tree-select.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "convertOptions": () => (/* binding */ convertOptions),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "getValueFromSelected": () => (/* binding */ getValueFromSelected),
/* harmony export */   "selectedOptions": () => (/* binding */ selectedOptions)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_DualListSelector_DualListSelector_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/index.js");
/* harmony import */ var _dual_list_context__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dual-list-context */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js");





var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "id", "input", "FormGroupProps", "options", "isSortable"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }








var convertOptions = function convertOptions(options, sort) {
  if (Array.isArray(options)) {
    var result = options.map(function (option) {
      return convertOptions(option, sort);
    }).filter(Boolean);

    if (sort) {
      var sortFn = function sortFn(a, b) {
        return sort === 'asc' ? a.localeCompare(b) : b.localeCompare(a);
      };

      result = result.sort(function (a, b) {
        return sortFn(a.text || a.label, b.text || b.label);
      });
    }

    return result;
  }

  return _objectSpread(_objectSpread({
    text: options.label,
    id: options.value || options.key || options.label || options.text,
    isChecked: false
  }, options), options.children && {
    children: convertOptions(options.children, sort).filter(Boolean)
  });
};
var selectedOptions = function selectedOptions(options, value, selected) {
  if (Array.isArray(options)) {
    return options.map(function (option) {
      return selectedOptions(option, value, selected);
    }).filter(Boolean);
  }

  if (options.value) {
    if (selected ? value.includes(options.value) : !value.includes(options.value)) {
      return options;
    }
  }

  if (options.children) {
    var someSelected = selectedOptions(options.children, value, selected).filter(Boolean);

    if (someSelected.length) {
      return _objectSpread(_objectSpread({}, options), {}, {
        children: someSelected
      });
    }
  }
};
var getValueFromSelected = function getValueFromSelected(options) {
  var newValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  if (Array.isArray(options)) {
    options.map(function (option) {
      return getValueFromSelected(option, newValue);
    });
  }

  if (options.value) {
    newValue.push(options.value);
  }

  if (options.children) {
    getValueFromSelected(options.children, newValue);
  }

  return newValue;
};

var DualListTreeSelect = function DualListTreeSelect(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_6__["default"])(_objectSpread(_objectSpread({}, props), {}, {
    FieldProps: {
      isEqual: function isEqual(current, initial) {
        return lodash_isEqual__WEBPACK_IMPORTED_MODULE_7___default()((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(current || []).sort(), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(initial || []).sort());
      }
    }
  })),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      id = _useFieldApi.id,
      input = _useFieldApi.input,
      FormGroupProps = _useFieldApi.FormGroupProps,
      options = _useFieldApi.options,
      isSortable = _useFieldApi.isSortable,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_useFieldApi, _excluded);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(function () {
    return {
      left: isSortable && 'asc',
      right: isSortable && 'asc'
    };
  }),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useState, 2),
      sortConfig = _useState2[0],
      setSortConfig = _useState2[1];

  var value = input.value || [];
  var leftOptions = selectedOptions(options, value, false);
  var rightOptions = selectedOptions(options, value, true);

  var onListChange = function onListChange(_newLeft, newRight) {
    return input.onChange(getValueFromSelected(newRight));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(_form_group__WEBPACK_IMPORTED_MODULE_8__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(_dual_list_context__WEBPACK_IMPORTED_MODULE_9__["default"].Provider, {
    value: {
      sortConfig: sortConfig,
      setSortConfig: setSortConfig
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(_patternfly_react_core_dist_esm_components_DualListSelector_DualListSelector_js__WEBPACK_IMPORTED_MODULE_10__.DualListSelector, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    availableOptions: convertOptions(leftOptions, sortConfig.left),
    chosenOptions: convertOptions(rightOptions, sortConfig.right),
    onListChange: onListChange,
    id: id || input.name,
    isTree: true
  }, rest))));
};

DualListTreeSelect.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  isSortable: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DualListTreeSelect);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/index.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/index.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "convertOptions": () => (/* reexport safe */ _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_0__.convertOptions),
/* harmony export */   "default": () => (/* reexport safe */ _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "getValueFromSelected": () => (/* reexport safe */ _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_0__.getValueFromSelected),
/* harmony export */   "selectedOptions": () => (/* reexport safe */ _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_0__.selectedOptions)
/* harmony export */ });
/* harmony import */ var _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dual-list-tree-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/dual-list-tree-select.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/field-array.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/field-array.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_field_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/field-array */ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Bullseye_Bullseye_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Button/Button.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Flex_Flex_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Flex/Flex.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Flex/Flex.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Flex_FlexItem_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Flex/FlexItem.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Flex/FlexItem.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_FormFieldGroup_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/FormFieldGroup.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroup.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_FormFieldGroupHeader_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/FormFieldGroupHeader.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroupHeader.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_FormHelperText_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/FormHelperText.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/FormHelperText.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Grid_Grid_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Grid/Grid.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Grid/Grid.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Grid_GridItem_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Grid/GridItem.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Grid/GridItem.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_trash_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/trash-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/trash-icon.js");
/* harmony import */ var _final_form_array_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./final-form-array.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/final-form-array.css");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");



var _excluded = ["remove"],
    _excluded2 = ["remove"],
    _excluded3 = ["arrayValidator", "label", "description", "fields", "defaultItem", "meta", "minItems", "maxItems", "noItemsMessage", "buttonLabels"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }



















var Spacer = function Spacer() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("span", {
    className: "ddf-final-form-spacer"
  });
};

var ArrayItem = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(function (_ref) {
  var fields = _ref.fields,
      fieldIndex = _ref.fieldIndex,
      name = _ref.name,
      remove = _ref.remove,
      length = _ref.length,
      minItems = _ref.minItems,
      buttonLabels = _ref.buttonLabels,
      isLast = _ref.isLast;

  var _useFormApi = (0,_data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_5__["default"])(),
      renderForm = _useFormApi.renderForm;

  var editedFields = fields.map(function (field, index) {
    var computedName = field.name ? "".concat(name, ".").concat(field.name) : name;
    return _objectSpread(_objectSpread({}, field), {}, {
      name: computedName,
      key: "".concat(name, "-").concat(index)
    });
  });
  var isRemoveDisabled = length <= minItems;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Flex_Flex_js__WEBPACK_IMPORTED_MODULE_9__.Flex, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Flex_FlexItem_js__WEBPACK_IMPORTED_MODULE_10__.FlexItem, {
    className: "pf-c-form",
    grow: {
      "default": 'flex_1'
    }
  }, editedFields.map(function (field) {
    return renderForm([field]);
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Flex_FlexItem_js__WEBPACK_IMPORTED_MODULE_10__.FlexItem, null, editedFields[0].label && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(Spacer, null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_11__.Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    variant: "plain",
    "aria-label": buttonLabels.remove,
    disabled: isRemoveDisabled
  }, !isRemoveDisabled && {
    onClick: function onClick() {
      return remove(fieldIndex);
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_icons_dist_esm_icons_trash_icon__WEBPACK_IMPORTED_MODULE_12__["default"], null)))), !isLast && editedFields.length > 1 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("hr", {
    className: "ddf-final-form-hr"
  }));
}, function (_ref2, _ref3) {
  var _prevRemove = _ref2.remove,
      prev = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref2, _excluded);

  var _nextRemove = _ref3.remove,
      next = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref3, _excluded2);

  return lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(prev, next);
});
ArrayItem.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  fieldIndex: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number.isRequired),
  fields: prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)),
  remove: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func.isRequired),
  length: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number),
  minItems: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number),
  buttonLabels: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    remove: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
  }),
  isLast: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().bool)
};

var DynamicArray = function DynamicArray(_ref4) {
  var props = (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, _ref4);

  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_8__["default"])(props),
      arrayValidator = _useFieldApi.arrayValidator,
      label = _useFieldApi.label,
      description = _useFieldApi.description,
      formFields = _useFieldApi.fields,
      defaultItem = _useFieldApi.defaultItem,
      meta = _useFieldApi.meta,
      minItems = _useFieldApi.minItems,
      maxItems = _useFieldApi.maxItems,
      noItemsMessage = _useFieldApi.noItemsMessage,
      buttonLabels = _useFieldApi.buttonLabels,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_useFieldApi, _excluded3);

  var dirty = meta.dirty,
      submitFailed = meta.submitFailed,
      error = meta.error,
      submitError = meta.submitError;
  var isError = (dirty || submitFailed) && (error || submitError) && (typeof error === 'string' || typeof submitError === 'string');

  var combinedButtonLabels = _objectSpread({
    add: 'Add item',
    removeAll: 'Delete all',
    remove: 'Remove'
  }, buttonLabels);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_data_driven_forms_react_form_renderer_field_array__WEBPACK_IMPORTED_MODULE_6__["default"], {
    key: rest.input.name,
    name: rest.input.name,
    validate: arrayValidator
  }, function (_ref5) {
    var _ref5$fields = _ref5.fields,
        map = _ref5$fields.map,
        _ref5$fields$value = _ref5$fields.value,
        value = _ref5$fields$value === void 0 ? [] : _ref5$fields$value,
        push = _ref5$fields.push,
        remove = _ref5$fields.remove,
        removeBatch = _ref5$fields.removeBatch;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Form_FormFieldGroup_js__WEBPACK_IMPORTED_MODULE_14__.FormFieldGroup, {
      header: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Form_FormFieldGroupHeader_js__WEBPACK_IMPORTED_MODULE_15__.FormFieldGroupHeader, {
        titleText: {
          text: label,
          id: props.name
        },
        titleDescription: description,
        actions: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, null, minItems === 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_11__.Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
          variant: "link",
          isDisabled: value.length === 0
        }, value.length !== 0 && {
          onClick: function onClick() {
            return removeBatch(value.map(function (_, index) {
              return index;
            }));
          }
        }), combinedButtonLabels.removeAll), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_11__.Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
          variant: "secondary",
          isDisabled: value.length >= maxItems
        }, !(value.length >= maxItems) && {
          onClick: function onClick() {
            return push(defaultItem);
          }
        }), combinedButtonLabels.add))
      })
    }, value.length <= 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Bullseye_Bullseye_js__WEBPACK_IMPORTED_MODULE_16__.Bullseye, null, noItemsMessage), map(function (name, index) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(ArrayItem, {
        key: "".concat(name, "-").concat(index),
        fields: formFields,
        name: name,
        fieldIndex: index,
        remove: remove,
        length: value.length,
        minItems: minItems,
        buttonLabels: combinedButtonLabels,
        isLast: value.length === index + 1
      });
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Grid_Grid_js__WEBPACK_IMPORTED_MODULE_17__.Grid, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_layouts_Grid_GridItem_js__WEBPACK_IMPORTED_MODULE_18__.GridItem, {
      sm: 11
    }, isError && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Form_FormHelperText_js__WEBPACK_IMPORTED_MODULE_19__.FormHelperText, {
      isHidden: false,
      isError: true
    }, error || submitError))));
  });
};

DynamicArray.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  fields: prop_types__WEBPACK_IMPORTED_MODULE_13___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_13___default().object)).isRequired,
  defaultItem: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().any),
  minItems: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number),
  maxItems: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().number),
  noItemsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  buttonLabels: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    add: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
    remove: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
    removeAll: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
  })
};
DynamicArray.defaultProps = {
  maxItems: Infinity,
  minItems: 0,
  noItemsMessage: 'No items added'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DynamicArray);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/index.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _field_array__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _field_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field-array */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/field-array.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_FormGroup_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/FormGroup.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/FormGroup.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/TextContent.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/TextContent.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/Text.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/Text.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _show_error_show_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../show-error/show-error */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js");








var FormGroup = function FormGroup(_ref) {
  var label = _ref.label,
      isRequired = _ref.isRequired,
      helperText = _ref.helperText,
      meta = _ref.meta,
      validateOnMount = _ref.validateOnMount,
      description = _ref.description,
      hideLabel = _ref.hideLabel,
      children = _ref.children,
      id = _ref.id,
      FormGroupProps = _ref.FormGroupProps;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Form_FormGroup_js__WEBPACK_IMPORTED_MODULE_3__.FormGroup, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    isRequired: isRequired,
    label: !hideLabel && label,
    fieldId: id,
    helperText: (meta.touched || validateOnMount) && meta.warning || helperText,
    helperTextInvalid: meta.error || meta.submitError
  }, (0,_show_error_show_error__WEBPACK_IMPORTED_MODULE_2__["default"])(meta, validateOnMount), FormGroupProps), description && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_4__.TextContent, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_5__.Text, {
    component: "small"
  }, description)), children);
};

FormGroup.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  meta: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object.isRequired),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string.isRequired),
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().element), prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().element))]).isRequired,
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormGroup);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _form_group__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/form-template.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/form-template.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Button": () => (/* binding */ Button),
/* harmony export */   "ButtonGroup": () => (/* binding */ ButtonGroup),
/* harmony export */   "Description": () => (/* binding */ Description),
/* harmony export */   "FormError": () => (/* binding */ FormError),
/* harmony export */   "Title": () => (/* binding */ Title),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_common_form_template__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/common/form-template */ "./node_modules/@data-driven-forms/common/esm/form-template/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Button/Button.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_ActionGroup_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/ActionGroup.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/ActionGroup.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Form_Form_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Form/Form.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Form/Form.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/TextContent.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/TextContent.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/Text.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/Text.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Alert_Alert_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Alert/Alert.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/Alert.js");



var _excluded = ["label", "bsStyle", "children", "disabled", "buttonType"],
    _excluded2 = ["children"],
    _excluded3 = ["children"],
    _excluded4 = ["children"],
    _excluded5 = ["title", "description"];










var Button = function Button(_ref) {
  var label = _ref.label,
      bsStyle = _ref.bsStyle,
      children = _ref.children,
      disabled = _ref.disabled,
      buttonType = _ref.buttonType,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_5__.Button, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    variant: buttonType === 'cancel' ? 'link' : bsStyle || 'secondary',
    isDisabled: disabled
  }, props), label, children);
};
Button.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node.isRequired),
  bsStyle: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)]),
  buttonType: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};
var ButtonGroup = function ButtonGroup(_ref2) {
  var children = _ref2.children,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref2, _excluded2);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Form_ActionGroup_js__WEBPACK_IMPORTED_MODULE_7__.ActionGroup, props, children);
};
ButtonGroup.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)])
};
var Title = function Title(_ref3) {
  var children = _ref3.children,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref3, _excluded3);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_8__.TextContent, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_9__.Text, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    component: _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_9__.TextVariants.h1
  }, props), children));
};
Title.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)])
};
var Description = function Description(_ref4) {
  var children = _ref4.children,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref4, _excluded4);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_8__.TextContent, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_9__.Text, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    component: _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_9__.TextVariants.p
  }, props), children));
};
Description.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node)])
};
var FormError = function FormError(_ref5) {
  var formError = _ref5.formError,
      alertProps = _ref5.alertProps;

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(formError) === 'object' && formError.title) {
    var title = formError.title,
        description = formError.description,
        props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(formError, _excluded5);

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Alert_Alert_js__WEBPACK_IMPORTED_MODULE_10__.Alert, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      variant: "danger",
      isInline: true,
      title: title
    }, props, alertProps), description);
  }

  if (typeof formError === 'string') {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Alert_Alert_js__WEBPACK_IMPORTED_MODULE_10__.Alert, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      variant: "danger",
      isInline: true,
      title: formError
    }, alertProps));
  }

  return null;
};
FormError.propTypes = {
  formError: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().any),
  alertProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

var PF4FormTemplate = function PF4FormTemplate(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_data_driven_forms_common_form_template__WEBPACK_IMPORTED_MODULE_4__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    BeforeError: FormError,
    FormWrapper: _patternfly_react_core_dist_esm_components_Form_Form_js__WEBPACK_IMPORTED_MODULE_11__.Form,
    Button: Button,
    ButtonGroup: ButtonGroup,
    Title: Title,
    Description: Description
  }, props));
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PF4FormTemplate);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/index.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Button": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.Button),
/* harmony export */   "ButtonGroup": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.ButtonGroup),
/* harmony export */   "Description": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.Description),
/* harmony export */   "FormError": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.FormError),
/* harmony export */   "Title": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__.Title),
/* harmony export */   "default": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form_template__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-template */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/form-template.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Checkbox": () => (/* reexport safe */ _checkbox__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "DatePicker": () => (/* reexport safe */ _date_picker__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "DualListContext": () => (/* reexport safe */ _dual_list_context__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "DualListSelect": () => (/* reexport safe */ _dual_list_select__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "DualListSelectTree": () => (/* reexport safe */ _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "DualListSortButton": () => (/* reexport safe */ _dual_list_sort_button__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "FieldArray": () => (/* reexport safe */ _field_array__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "FormTemplate": () => (/* reexport safe */ _form_template__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "PlainText": () => (/* reexport safe */ _plain_text__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "Radio": () => (/* reexport safe */ _radio__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "Select": () => (/* reexport safe */ _select__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "Slider": () => (/* reexport safe */ _slider__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "SubForm": () => (/* reexport safe */ _sub_form__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "Switch": () => (/* reexport safe */ _switch__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   "Tabs": () => (/* reexport safe */ _tabs__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "Textarea": () => (/* reexport safe */ _textarea__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   "TimePicker": () => (/* reexport safe */ _time_picker__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   "Wizard": () => (/* reexport safe */ _wizard__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   "componentMapper": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "components": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__.components),
/* harmony export */   "rawComponents": () => (/* reexport safe */ _component_mapper__WEBPACK_IMPORTED_MODULE_0__.rawComponents),
/* harmony export */   "showError": () => (/* reexport safe */ _show_error__WEBPACK_IMPORTED_MODULE_19__["default"])
/* harmony export */ });
/* harmony import */ var _component_mapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component-mapper */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/component-mapper/index.js");
/* harmony import */ var _form_template__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-template */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-template/index.js");
/* harmony import */ var _checkbox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./checkbox */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/checkbox/index.js");
/* harmony import */ var _date_picker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./date-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/date-picker/index.js");
/* harmony import */ var _dual_list_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dual-list-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-select/index.js");
/* harmony import */ var _dual_list_tree_select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dual-list-tree-select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-tree-select/index.js");
/* harmony import */ var _dual_list_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dual-list-context */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-context/index.js");
/* harmony import */ var _dual_list_sort_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./dual-list-sort-button */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/dual-list-sort-button/index.js");
/* harmony import */ var _field_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./field-array */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/field-array/index.js");
/* harmony import */ var _plain_text__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./plain-text */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/index.js");
/* harmony import */ var _radio__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./radio */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/index.js");
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/index.js");
/* harmony import */ var _slider__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./slider */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/index.js");
/* harmony import */ var _sub_form__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./sub-form */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/index.js");
/* harmony import */ var _switch__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./switch */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./tabs */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/index.js");
/* harmony import */ var _textarea__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./textarea */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/index.js");
/* harmony import */ var _time_picker__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./time-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/index.js");
/* harmony import */ var _wizard__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./wizard */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/index.js");
/* harmony import */ var _show_error__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./show-error */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/index.js");





















/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/is-required/is-required.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/is-required/is-required.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _data_driven_forms_common_prop_types_templates__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @data-driven-forms/common/prop-types-templates */ "./node_modules/@data-driven-forms/common/esm/prop-types-templates/index.js");



var IsRequired = function IsRequired(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "pf-c-form__label-required",
    "aria-hidden": "true"
  }, "*"));
};

IsRequired.propTypes = {
  children: _data_driven_forms_common_prop_types_templates__WEBPACK_IMPORTED_MODULE_1__.childrenPropTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IsRequired);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _plain_text__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _plain_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plain-text */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/plain-text.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/plain-text.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/plain-text/plain-text.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/TextContent.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/TextContent.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/Text.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/Text.js");
/* harmony import */ var _data_driven_forms_common_utils_valid_text_fields__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/common/utils/valid-text-fields */ "./node_modules/@data-driven-forms/common/utils/valid-text-fields.js");


var _excluded = ["component", "label", "name", "variant", "TextContentProps"];






var PlainText = function PlainText(_ref) {
  var component = _ref.component,
      label = _ref.label,
      name = _ref.name,
      variant = _ref.variant,
      TextContentProps = _ref.TextContentProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_4__.TextContent, TextContentProps, typeof label === 'string' ? label.split('\n').map(function (paragraph, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_5__.Text, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      component: variant
    }, rest, {
      key: "".concat(name, "-").concat(index)
    }), paragraph);
  }) : label);
};

PlainText.propTypes = {
  variant: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOf(_data_driven_forms_common_utils_valid_text_fields__WEBPACK_IMPORTED_MODULE_3__["default"]),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node.isRequired),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string.isRequired),
  TextContentProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  component: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};
PlainText.defaultProps = {
  variant: 'p'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlainText);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/index.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/index.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _radio__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _radio__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./radio */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/radio.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/radio.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/radio/radio.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Radio_Radio_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Radio/Radio.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Radio/Radio.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");



var _excluded = ["value", "label"],
    _excluded2 = ["name", "type"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }







var RadioOption = function RadioOption(_ref) {
  var name = _ref.name,
      _ref$option = _ref.option,
      value = _ref$option.value,
      label = _ref$option.label,
      restOption = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref$option, _excluded),
      isDisabled = _ref.isDisabled,
      isReadOnly = _ref.isReadOnly;

  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])({
    name: name,
    value: value
  }),
      input = _useFieldApi.input;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Radio_Radio_js__WEBPACK_IMPORTED_MODULE_6__.Radio, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
    key: "".concat(name, "-").concat(value)
  }, input, {
    isChecked: input.value === value,
    value: value,
    onChange: function onChange() {
      return input.onChange(value);
    },
    label: label,
    id: "".concat(name, "-").concat(value),
    "aria-label": label,
    isDisabled: isDisabled || isReadOnly
  }, restOption));
};

RadioOption.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string.isRequired),
  option: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node.isRequired),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any.isRequired)
  }).isRequired,
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  radioGroupValue: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any)
};

var Radio = function Radio(_ref2) {
  var name = _ref2.name,
      type = _ref2.type,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref2, _excluded2);

  /**
   * You cannot assign type radio to PF4 radio buttons input. It will break and will not set input value, only checked property
   * It has to be reqular input and we have change the radio value manully to the option value
   */
  var _useFieldApi2 = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(_objectSpread({
    name: name
  }, props)),
      label = _useFieldApi2.label,
      isRequired = _useFieldApi2.isRequired,
      helperText = _useFieldApi2.helperText,
      meta = _useFieldApi2.meta,
      validateOnMount = _useFieldApi2.validateOnMount,
      description = _useFieldApi2.description,
      hideLabel = _useFieldApi2.hideLabel,
      input = _useFieldApi2.input,
      isReadOnly = _useFieldApi2.isReadOnly,
      isDisabled = _useFieldApi2.isDisabled,
      id = _useFieldApi2.id,
      FormGroupProps = _useFieldApi2.FormGroupProps,
      options = _useFieldApi2.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_5__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, options.map(function (option) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(RadioOption, {
      key: option.value,
      name: name,
      option: option,
      isReadOnly: isReadOnly,
      isDisabled: isDisabled
    });
  }));
};

Radio.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string.isRequired),
  options: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any)
  })).isRequired,
  type: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Radio);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InternalSelect": () => (/* reexport safe */ _select__WEBPACK_IMPORTED_MODULE_0__.InternalSelect),
/* harmony export */   "default": () => (/* reexport safe */ _select__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InternalSelect": () => (/* binding */ InternalSelect),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./select/select */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/select.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];






var Select = function Select(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_4__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_select_select__WEBPACK_IMPORTED_MODULE_5__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, input, rest, {
    isDisabled: isDisabled || isReadOnly
  })));
};

Select.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);
var InternalSelect = _select_select__WEBPACK_IMPORTED_MODULE_5__["default"];

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/clear-indicator.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/clear-indicator.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_times_circle_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/times-circle-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/times-circle-icon.js");
/* harmony import */ var _clear_indicator_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./clear-indicator.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/clear-indicator.css");





var ClearIndicator = function ClearIndicator(_ref) {
  var clearSelection = _ref.clearSelection;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    onClick: function onClick(event) {
      clearSelection();
      event.stopPropagation();
    },
    className: "pf-c-button pf-m-plain pf-c-select__toggle-clear pf-u-p-0",
    type: "button",
    "aria-label": "Clear all"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_times_circle_icon__WEBPACK_IMPORTED_MODULE_2__["default"], null));
};

ClearIndicator.propTypes = {
  clearSelection: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ClearIndicator);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/empty-options.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/empty-options.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



var EmptyOptions = function EmptyOptions(_ref) {
  var noOptionsMessage = _ref.noOptionsMessage,
      noResultsMessage = _ref.noResultsMessage,
      getInputProps = _ref.getInputProps,
      isSearchable = _ref.isSearchable,
      isFetching = _ref.isFetching;

  var _getInputProps = getInputProps(),
      value = _getInputProps.value;

  var message = isFetching ? noOptionsMessage() : isSearchable && value ? noResultsMessage : noOptionsMessage();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "pf-c-select__menu-item pf-m-disabled"
  }, message);
};

EmptyOptions.propTypes = {
  noOptionsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired),
  noResultsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),
  getInputProps: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func.isRequired),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  isFetching: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EmptyOptions);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/input.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/input.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _input_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./input.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/input.css");



var _excluded = ["inputRef", "isSearchable", "isDisabled", "getInputProps", "value"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }





var getInputString = function getInputString(filter, value) {
  if (typeof filter === 'string') {
    return filter;
  }

  if (typeof value === 'string') {
    return value;
  }

  if (Array.isArray(value) && typeof value[0] === 'string') {
    return value[0];
  }

  return '';
};

var Input = function Input(_ref) {
  var inputRef = _ref.inputRef,
      isSearchable = _ref.isSearchable,
      isDisabled = _ref.isDisabled,
      getInputProps = _ref.getInputProps,
      value = _ref.value,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref, _excluded);

  var inputProps = getInputProps({
    disabled: isDisabled
  });
  var initialInputValue = getInputString(inputProps.value, value);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("input", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    value: ""
  }, props, {
    className: "pf-c-form-control pf-c-select__toggle-typeahead",
    ref: inputRef
  }, _objectSpread(_objectSpread({}, inputProps), {}, {
    value: initialInputValue,
    onKeyDown: function onKeyDown(event) {
      event.stopPropagation();

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      inputProps.onKeyDown.apply(inputProps, [event].concat(args));
    },
    onChange: inputProps.onChange || Function
  })));
};

Input.propTypes = {
  inputRef: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    current: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(Element)
  }),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  getInputProps: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  value: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string))])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Input);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/menu.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/menu.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var _option__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./option */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/option.js");
/* harmony import */ var _empty_options__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./empty-options */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/empty-options.js");
/* harmony import */ var _menu_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./menu.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/menu.css");




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

/* eslint-disable react/prop-types */






var getScrollParent = function getScrollParent(element) {
  var style = getComputedStyle(element);
  var excludeStaticParent = style.position === 'absolute';
  var overflowRx = /(auto|scroll)/;
  var docEl = document.documentElement;

  if (style.position === 'fixed') {
    return docEl;
  }

  for (var parent = element; parent = parent.parentElement;) {
    // eslint-disable-line
    style = getComputedStyle(parent);

    if (excludeStaticParent && style.position === 'static') {
      continue;
    }

    if (overflowRx.test(style.overflow + style.overflowY + style.overflowX)) {
      return parent;
    }
  }

  return docEl;
};

var getMenuPosition = function getMenuPosition(selectBase) {
  if (!selectBase) {
    return {};
  }

  return selectBase.getBoundingClientRect();
};

var checkScrollVisibility = function checkScrollVisibility(scrollableParent, selectRoot, menuRoot) {
  var parentProportions = scrollableParent.getBoundingClientRect();
  var rootProportions = selectRoot.getBoundingClientRect();
  var menuProportions = menuRoot.getBoundingClientRect();
  return {
    rootPosition: parentProportions.y,
    cropSize: rootProportions.y + rootProportions.height - parentProportions.y,
    maxHeight: window.innerHeight - menuProportions.top + 1
  };
};

var MenuPortal = function MenuPortal(_ref) {
  var selectToggleRef = _ref.selectToggleRef,
      menuPortalTarget = _ref.menuPortalTarget,
      children = _ref.children;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(getMenuPosition(selectToggleRef.current)),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useState, 2),
      position = _useState2[0],
      setPosition = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)({}),
      _useState4 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useState3, 2),
      _useState4$ = _useState4[0],
      cropSize = _useState4$.cropSize,
      rootPosition = _useState4$.rootPosition,
      maxHeight = _useState4$.maxHeight,
      setCropSize = _useState4[1];

  var menuRef = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)();
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(function () {
    setCropSize({
      maxHeight: window.innerHeight - menuRef.current.getBoundingClientRect().top - 4
    });
    var scrollParentElement = getScrollParent(selectToggleRef.current);

    var scrollHandler = function scrollHandler() {
      setCropSize(checkScrollVisibility(scrollParentElement, selectToggleRef.current, menuRef.current));
      setPosition(getMenuPosition(selectToggleRef.current));
    };

    var resizeHandler = function resizeHandler() {
      setCropSize(function (prevSize) {
        return _objectSpread(_objectSpread({}, prevSize), {}, {
          maxHeight: window.innerHeight - menuRef.current.getBoundingClientRect().top - 4
        });
      });
      setPosition(getMenuPosition(selectToggleRef.current));
    };

    scrollParentElement.addEventListener('scroll', scrollHandler, true);
    window.addEventListener('resize', resizeHandler, true);
    return function () {
      window.removeEventListener('resize', resizeHandler, true);
      scrollParentElement.removeEventListener('scroll', scrollHandler, true);
    };
  }, [selectToggleRef]);
  var top = position.top + position.height;
  var sizedMenu = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.cloneElement(children, {
    style: {
      maxHeight: cropSize < 0 ? maxHeight + cropSize : maxHeight,
      overflow: 'auto'
    }
  });
  var portalDiv = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    ref: menuRef,
    className: "pf-c-select ddorg_pf4-component-mapper__select-portal-menu",
    style: {
      zIndex: 401,
      position: 'absolute',
      top: cropSize < 0 ? rootPosition : top,
      left: position.left,
      width: position.width,
      overflow: 'hidden'
    }
  }, cropSize < 0 ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
    style: {
      position: 'relative',
      top: cropSize,
      width: position.width
    }
  }, sizedMenu) : sizedMenu);
  return /*#__PURE__*/(0,react_dom__WEBPACK_IMPORTED_MODULE_4__.createPortal)(portalDiv, menuPortalTarget);
};

var Menu = function Menu(_ref2) {
  var noResultsMessage = _ref2.noResultsMessage,
      noOptionsMessage = _ref2.noOptionsMessage,
      filterOptions = _ref2.filterOptions,
      isSearchable = _ref2.isSearchable,
      filterValue = _ref2.filterValue,
      options = _ref2.options,
      getItemProps = _ref2.getItemProps,
      getInputProps = _ref2.getInputProps,
      highlightedIndex = _ref2.highlightedIndex,
      selectedItem = _ref2.selectedItem,
      isMulti = _ref2.isMulti,
      isFetching = _ref2.isFetching,
      menuPortalTarget = _ref2.menuPortalTarget,
      menuIsPortal = _ref2.menuIsPortal,
      selectToggleRef = _ref2.selectToggleRef,
      originalOptions = _ref2.originalOptions;
  var filteredOptions = isSearchable ? filterOptions(originalOptions, filterValue) : originalOptions;
  var index = 0;

  var createOption = function createOption(item) {
    index++;
    var itemProps = getItemProps({
      item: item,
      index: index,
      isActive: highlightedIndex === index,
      isSelected: isMulti ? !!selectedItem.find(function (_ref3) {
        var value = _ref3.value;
        return item.value === value;
      }) : selectedItem === item.value,
      onMouseUp: function onMouseUp(e) {
        return e.stopPropagation();
      } // we need this to prevent issues with portal menu not selecting a option

    });
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_option__WEBPACK_IMPORTED_MODULE_5__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      key: item.key || item.value || typeof item.label === 'string' && item.label || item,
      item: item
    }, itemProps));
  };

  var menuItems = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("ul", {
    className: "pf-c-select__menu".concat(menuIsPortal ? ' ddorg__pf4-component-mapper__select-menu-portal' : '')
  }, filteredOptions.length === 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_empty_options__WEBPACK_IMPORTED_MODULE_6__["default"], {
    isSearchable: isSearchable,
    noOptionsMessage: noOptionsMessage,
    noResultsMessage: noResultsMessage,
    getInputProps: getInputProps,
    isFetching: isFetching
  }), filteredOptions.map(function (item, arrayIndex) {
    if (item.options) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
        className: "pf-c-select__menu-group",
        key: "group-".concat(arrayIndex)
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
        className: "pf-c-select__menu-group-title"
      }, item.label), item.options.map(function (nestedItem) {
        return createOption(nestedItem);
      }));
    }

    if (item.divider) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("hr", {
        className: "pf-c-divider",
        key: "divider-".concat(index)
      });
    }

    return createOption(item);
  }));

  if (menuIsPortal) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(MenuPortal, {
      menuPortalTarget: menuPortalTarget,
      selectToggleRef: selectToggleRef
    }, menuItems);
  }

  return menuItems;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Menu);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/option.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/option.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_check_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/check-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/check-icon.js");


var _excluded = ["item", "isActive", "isSelected"];




var Option = function Option(_ref) {
  var item = _ref.item,
      isActive = _ref.isActive,
      isSelected = _ref.isSelected,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("button", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, props, {
    disabled: item.isDisabled || item.disabled,
    type: "button",
    className: "pf-c-select__menu-item".concat(isSelected ? ' pf-m-selected' : '').concat(isActive ? ' pf-m-focus' : '').concat(item.isDisabled || item.disabled ? ' pf-m-disabled' : '')
  }), item.label, isSelected && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("span", {
    className: "pf-c-select__menu-item-icon"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_icons_dist_esm_icons_check_icon__WEBPACK_IMPORTED_MODULE_3__["default"], null)), item.description && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", {
    className: "pf-c-select__menu-item-description"
  }, item.description)));
};

Option.propTypes = {
  item: prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
    isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
    description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node)
  }).isRequired,
  isActive: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  isSelected: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Option);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/select.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/select.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _data_driven_forms_common_select__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @data-driven-forms/common/select */ "./node_modules/@data-driven-forms/common/esm/select/index.js");
/* harmony import */ var _data_driven_forms_common_select_parse_internal_value__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @data-driven-forms/common/select/parse-internal-value */ "./node_modules/@data-driven-forms/common/select/parse-internal-value.js");
/* harmony import */ var downshift__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! downshift */ "./node_modules/downshift/dist/downshift.esm.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/caret-down-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/caret-down-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_close_icon__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/close-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/close-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_circle_notch_icon__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/circle-notch-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/circle-notch-icon.js");
/* harmony import */ var _select_styles_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./select-styles.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/select-styles.css");
/* harmony import */ var _patternfly_react_styles_css_components_Select_select_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Select/select.css */ "./node_modules/@patternfly/react-styles/css/components/Select/select.css");
/* harmony import */ var _patternfly_react_styles_css_components_Chip_chip_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Chip/chip.css */ "./node_modules/@patternfly/react-styles/css/components/Chip/chip.css");
/* harmony import */ var _patternfly_react_styles_css_components_ChipGroup_chip_group_css__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @patternfly/react-styles/css/components/ChipGroup/chip-group.css */ "./node_modules/@patternfly/react-styles/css/components/ChipGroup/chip-group.css");
/* harmony import */ var _patternfly_react_styles_css_components_Divider_divider_css__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Divider/divider.css */ "./node_modules/@patternfly/react-styles/css/components/Divider/divider.css");
/* harmony import */ var _menu__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./menu */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/menu.js");
/* harmony import */ var _clear_indicator__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./clear-indicator */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/clear-indicator.js");
/* harmony import */ var _value_container__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./value-container */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/value-container.js");






var _excluded = ["noResultsMessage", "noOptionsMessage", "onChange", "options", "value", "simpleValue", "placeholder", "isSearchable", "isDisabled", "isClearable", "isMulti", "isFetching", "onInputChange", "loadingMessage", "menuPortalTarget", "menuIsPortal", "originalOptions"],
    _excluded2 = ["menuIsPortal"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


















var _itemToString = function itemToString(value, isMulti, showMore, handleShowMore, handleChange) {
  if (!value) {
    return '';
  }

  if (Array.isArray(value)) {
    if (!value || value.length === 0) {
      return;
    }

    if (isMulti) {
      var visibleOptions = showMore ? value : value.slice(0, 3);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("div", {
        className: "pf-c-chip-group pf-u-ml-sm",
        onClick: function onClick(event) {
          return event.stopPropagation();
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("ul", {
        className: "pf-c-chip-group__list",
        "aria-label": "Chip group category"
      }, visibleOptions.map(function (item, index) {
        var label = (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(item) === 'object' ? item.label : item;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("li", {
          className: "pf-c-chip-group__list-item",
          onClick: function onClick(event) {
            return event.stopPropagation();
          },
          key: item.key || item.value || item
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("div", {
          className: "pf-c-chip"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("span", {
          className: "pf-c-chip__text",
          id: "pf-random-id-".concat(index, "-").concat(label)
        }, label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("button", {
          onClick: function onClick() {
            return handleChange(item);
          },
          className: "pf-c-button pf-m-plain",
          type: "button",
          "aria-label": "remove option"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_patternfly_react_icons_dist_esm_icons_close_icon__WEBPACK_IMPORTED_MODULE_17__["default"], null))));
      }), value.length > 3 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("li", {
        className: "pf-c-chip-group__list-item"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("button", {
        type: "button",
        onClick: handleShowMore,
        className: "pf-c-chip pf-m-overflow"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("span", {
        className: "pf-c-chip__text"
      }, showMore ? 'Show less' : "".concat(value.length - 3, " more"))))));
    }

    return value.map(function (item) {
      return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(item) === 'object' ? item.label : item;
    });
  }

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(value) === 'object') {
    return value.label;
  }

  return value;
}; // TODO fix the value of internal select not to be an array all the time. It forces the filter value to be an array and it crashes sometimes.


var filterOptions = function filterOptions(options) {
  var filterValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var filter = (Array.isArray(filterValue) && filterValue.length > 0 ? filterValue[0] : filterValue).toLowerCase();

  if (!filter) {
    return options;
  }

  return options.map(function (option) {
    var _option$label2;

    if (option.options) {
      var filteredNested = option.options.map(function (option) {
        var _option$label;

        return (_option$label = option.label) !== null && _option$label !== void 0 && _option$label.toLowerCase().includes(filter) ? option : null;
      }).filter(Boolean);

      if (filteredNested.length === 0) {
        return null;
      }

      return _objectSpread(_objectSpread({}, option), {}, {
        options: filteredNested
      });
    }

    if ((_option$label2 = option.label) !== null && _option$label2 !== void 0 && _option$label2.toLowerCase().includes(filter)) {
      return option;
    }

    return null;
  }).filter(Boolean);
};

var getValue = function getValue(isMulti, option, value) {
  if (!isMulti || !option) {
    return option;
  }

  var isSelected = value.find(function (_ref) {
    var value = _ref.value;
    return value === option.value;
  });
  return isSelected ? value.filter(function (_ref2) {
    var value = _ref2.value;
    return value !== option.value;
  }) : [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(value), [option]);
};

var _stateReducer = function stateReducer(state, changes, isMulti) {
  switch (changes.type) {
    case downshift__WEBPACK_IMPORTED_MODULE_18__["default"].stateChangeTypes.clickButton:
      return _objectSpread(_objectSpread(_objectSpread({}, state), changes), {}, {
        highlightedIndex: undefined,
        // reset the item focus to prevent initial scroll and portal menu warping
        inputValue: undefined
      });

    case downshift__WEBPACK_IMPORTED_MODULE_18__["default"].stateChangeTypes.keyDownEnter:
    case downshift__WEBPACK_IMPORTED_MODULE_18__["default"].stateChangeTypes.clickItem:
      return _objectSpread(_objectSpread({}, changes), {}, {
        isOpen: isMulti ? state.isOpen : !state.isOpen,
        highlightedIndex: state.highlightedIndex,
        inputValue: isMulti ? state.inputValue : changes.inputValue // prevent filter value change after option click

      });

    case downshift__WEBPACK_IMPORTED_MODULE_18__["default"].stateChangeTypes.controlledPropUpdatedSelectedItem:
      return _objectSpread(_objectSpread({}, changes), {}, {
        inputValue: state.inputValue
      });

    case downshift__WEBPACK_IMPORTED_MODULE_18__["default"].stateChangeTypes.mouseUp:
      if (typeof changes.inputValue === 'string') {
        return _objectSpread({}, changes);
      }

      if (Array.isArray(changes.inputValue) && typeof changes.inputValue[0] === 'string') {
        return _objectSpread(_objectSpread({}, changes), {}, {
          inputValue: changes.inputValue[0]
        });
      }

      if (state.isOpen === true && changes.isOpen === false && changes.inputValue) {
        return _objectSpread(_objectSpread(_objectSpread({}, state), changes), {}, {
          inputValue: ''
        });
      }

      return _objectSpread(_objectSpread({}, changes), {}, {
        inputValue: state.inputValue
      });

    default:
      return changes;
  }
};

var InternalSelect = function InternalSelect(_ref3) {
  var noResultsMessage = _ref3.noResultsMessage,
      noOptionsMessage = _ref3.noOptionsMessage,
      onChange = _ref3.onChange,
      options = _ref3.options,
      value = _ref3.value,
      simpleValue = _ref3.simpleValue,
      placeholder = _ref3.placeholder,
      isSearchable = _ref3.isSearchable,
      isDisabled = _ref3.isDisabled,
      isClearable = _ref3.isClearable,
      isMulti = _ref3.isMulti,
      isFetching = _ref3.isFetching,
      onInputChange = _ref3.onInputChange,
      loadingMessage = _ref3.loadingMessage,
      menuPortalTarget = _ref3.menuPortalTarget,
      menuIsPortal = _ref3.menuIsPortal,
      originalOptions = _ref3.originalOptions,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref3, _excluded);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useState, 2),
      showMore = _useState2[0],
      setShowMore = _useState2[1];

  var inputRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)();
  var selectToggleRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)();
  var parsedValue = (0,_data_driven_forms_common_select_parse_internal_value__WEBPACK_IMPORTED_MODULE_8__["default"])(value);

  var handleShowMore = function handleShowMore() {
    return setShowMore(function (prev) {
      return !prev;
    });
  };

  var handleChange = function handleChange(option) {
    return onChange(getValue(isMulti, option, value));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(downshift__WEBPACK_IMPORTED_MODULE_18__["default"], {
    id: props.id || props.name,
    onChange: handleChange,
    itemToString: function itemToString(value) {
      return _itemToString(value, isMulti, showMore, handleShowMore, handleChange);
    },
    selectedItem: value || '',
    stateReducer: function stateReducer(state, changes) {
      return _stateReducer(state, changes, isMulti);
    },
    onInputValueChange: function onInputValueChange(inputValue, _ref4) {
      var selectedItem = _ref4.selectedItem;

      /**
       * Prevent firing te load options callback when selecting value not filtering
       */
      if (onInputChange && typeof inputValue === 'string' && (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.label) !== inputValue) {
        onInputChange(inputValue);
      }
    }
  }, function (_ref5) {
    var isOpen = _ref5.isOpen,
        inputValue = _ref5.inputValue,
        itemToString = _ref5.itemToString,
        selectedItem = _ref5.selectedItem,
        clearSelection = _ref5.clearSelection,
        getInputProps = _ref5.getInputProps,
        getToggleButtonProps = _ref5.getToggleButtonProps,
        getItemProps = _ref5.getItemProps,
        highlightedIndex = _ref5.highlightedIndex;
    var toggleButtonProps = getToggleButtonProps();
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("div", {
      className: "pf-c-select"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("div", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
      ref: selectToggleRef,
      disabled: isDisabled,
      className: "pf-c-select__toggle".concat(isDisabled ? ' pf-m-disabled' : '').concat(isSearchable ? ' pf-m-typeahead' : '', " ddorg__pf4-component-mapper__select-toggle"),
      tabIndex: 0
    }, toggleButtonProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("div", {
      className: "pf-c-select_toggle-wrapper ddorg__pf4-component-mapper__select-toggle-wrapper"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_value_container__WEBPACK_IMPORTED_MODULE_16__["default"], {
      isMulti: isMulti,
      isSearchable: isSearchable,
      placeholder: placeholder,
      inputRef: inputRef,
      getInputProps: getInputProps,
      value: itemToString(selectedItem, isMulti, showMore, handleShowMore, handleChange)
    })), isClearable && parsedValue && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_clear_indicator__WEBPACK_IMPORTED_MODULE_15__["default"], {
      clearSelection: clearSelection
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement("span", {
      className: "pf-c-select__toggle-arrow"
    }, isFetching ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_patternfly_react_icons_dist_esm_icons_circle_notch_icon__WEBPACK_IMPORTED_MODULE_19__["default"], {
      className: "ddorg__pf4-component-mapper__select-loading-icon"
    }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_20__["default"], null))), isOpen && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_menu__WEBPACK_IMPORTED_MODULE_14__["default"], {
      noResultsMessage: noResultsMessage,
      noOptionsMessage: noOptionsMessage,
      isFetching: isFetching,
      isDisabled: isDisabled,
      isSearchable: isSearchable,
      getInputProps: getInputProps,
      filterOptions: filterOptions,
      filterValue: inputValue,
      options: options,
      getItemProps: getItemProps,
      highlightedIndex: highlightedIndex,
      selectedItem: isMulti ? value : parsedValue,
      isMulti: isMulti,
      menuPortalTarget: menuPortalTarget,
      menuIsPortal: menuIsPortal,
      selectToggleRef: selectToggleRef,
      originalOptions: originalOptions
    }));
  });
};

InternalSelect.propTypes = {
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().func.isRequired),
  options: prop_types__WEBPACK_IMPORTED_MODULE_21___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_21___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
    divider: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool)
  })).isRequired,
  value: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
  simpleValue: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().string),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().string),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().string.isRequired),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  isClearable: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  noResultsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  noOptionsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().func),
  isMulti: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  isFetching: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  onInputChange: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().func),
  loadingMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  menuPortalTarget: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
  menuIsPortal: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  originalOptions: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().array)
};

var Select = function Select(_ref6) {
  var menuIsPortal = _ref6.menuIsPortal,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref6, _excluded2);

  var menuPortalTarget = menuIsPortal ? document.body : undefined;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6__.createElement(_data_driven_forms_common_select__WEBPACK_IMPORTED_MODULE_7__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    SelectComponent: InternalSelect,
    menuPortalTarget: menuPortalTarget,
    menuIsPortal: menuIsPortal
  }, props, {
    optionsTransformer: _data_driven_forms_common_select__WEBPACK_IMPORTED_MODULE_7__.flatOptions
  }));
};

Select.propTypes = {
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  showMoreLabel: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  showLessLabel: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  simpleValue: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  value: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
  options: prop_types__WEBPACK_IMPORTED_MODULE_21___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_21___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().any)
  })),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().func.isRequired),
  isMulti: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  loadOptions: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().func),
  loadingMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  updatingMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  menuIsPortal: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().bool),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().string),
  noResultsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node),
  noOptionsMessage: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().node)
};
Select.defaultProps = {
  showMoreLabel: 'more',
  showLessLabel: 'Show less',
  simpleValue: true,
  loadingMessage: 'Loading...',
  updatingMessage: 'Loading data...',
  options: [],
  menuIsPortal: false,
  placeholder: 'Choose...',
  isSearchable: false,
  isClearable: false,
  noResultsMessage: 'No results found',
  noOptionsMessage: 'No options'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Select);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/value-container.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/value-container.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./input */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/select/select/input.js");




var ValueContainer = function ValueContainer(_ref) {
  var value = _ref.value,
      isMulti = _ref.isMulti,
      placeholder = _ref.placeholder,
      getInputProps = _ref.getInputProps,
      isSearchable = _ref.isSearchable,
      inputRef = _ref.inputRef;

  if (isMulti && isSearchable) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, value, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_input__WEBPACK_IMPORTED_MODULE_1__["default"], {
      placeholder: placeholder,
      inputRef: inputRef,
      getInputProps: getInputProps
    }));
  }

  if (!isMulti && isSearchable) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_input__WEBPACK_IMPORTED_MODULE_1__["default"], {
      placeholder: placeholder,
      inputRef: inputRef,
      getInputProps: getInputProps,
      value: value
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "pf-c-select__toggle-text"
  }, value || placeholder);
};

ValueContainer.propTypes = {
  value: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node),
  isMulti: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  getInputProps: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func.isRequired),
  isSearchable: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  inputRef: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ValueContainer);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _show_error__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _show_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./show-error */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var showError = function showError(_ref, validateOnMount) {
  var error = _ref.error,
      touched = _ref.touched,
      warning = _ref.warning,
      submitError = _ref.submitError;

  if ((touched || validateOnMount) && error) {
    return {
      validated: 'error'
    };
  }

  if ((touched || validateOnMount) && submitError) {
    return {
      validated: 'error'
    };
  }

  if ((touched || validateOnMount) && warning) {
    return {
      validated: 'warning'
    };
  }

  return {
    validated: 'default'
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (showError);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _slider__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _slider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./slider */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/slider.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/slider.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/slider/slider.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Slider_Slider_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Slider/Slider.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Slider/Slider.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];






var Slider = function Slider(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group__WEBPACK_IMPORTED_MODULE_4__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Slider_Slider_js__WEBPACK_IMPORTED_MODULE_5__.Slider, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    onChange: input.onChange,
    onValueChange: input.onChange,
    currentValue: input.value,
    inputValue: input.value
  }, rest)));
};

Slider.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Slider);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _sub_form__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _sub_form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sub-form */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/sub-form.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/sub-form.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/sub-form/sub-form.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Title_Title_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Title/Title.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Title/Title.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Grid_Grid_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Grid/Grid.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Grid/Grid.js");
/* harmony import */ var _patternfly_react_core_dist_esm_layouts_Grid_GridItem_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/layouts/Grid/GridItem.js */ "./node_modules/@patternfly/react-core/dist/esm/layouts/Grid/GridItem.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/TextContent.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/TextContent.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Text/Text.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Text/Text.js");


var _excluded = ["fields", "title", "description", "validate", "component"];










var SubForm = function SubForm(_ref) {
  var fields = _ref.fields,
      title = _ref.title,
      description = _ref.description,
      _validate = _ref.validate,
      component = _ref.component,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  var formOptions = (0,_data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_3__["default"])();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_layouts_Grid_Grid_js__WEBPACK_IMPORTED_MODULE_4__.Grid, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    hasGutter: true
  }, rest), title && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_layouts_Grid_GridItem_js__WEBPACK_IMPORTED_MODULE_5__.GridItem, {
    sm: 12
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Title_Title_js__WEBPACK_IMPORTED_MODULE_6__.Title, {
    headingLevel: "h2",
    size: "xl"
  }, title)), description && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_layouts_Grid_GridItem_js__WEBPACK_IMPORTED_MODULE_5__.GridItem, {
    sm: 12
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Text_TextContent_js__WEBPACK_IMPORTED_MODULE_7__.TextContent, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_8__.Text, {
    component: _patternfly_react_core_dist_esm_components_Text_Text_js__WEBPACK_IMPORTED_MODULE_8__.TextVariants.small,
    style: {
      marginBottom: 0
    }
  }, description))), formOptions.renderForm(fields, formOptions));
};

SubForm.propTypes = {
  fields: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().array.isRequired),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  validate: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().any),
  component: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().any)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SubForm);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _switch__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _switch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./switch */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/switch.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/switch.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/switch/switch.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_Switch_Switch_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Switch/Switch.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Switch/Switch.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _is_required_is_required__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../is-required/is-required */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/is-required/is-required.js");



var _excluded = ["label", "offText", "onText", "isRequired", "helperText", "meta", "validateOnMount", "description", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }








var Switch = function Switch(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(_objectSpread(_objectSpread({}, props), {}, {
    type: 'checkbox'
  })),
      label = _useFieldApi.label,
      offText = _useFieldApi.offText,
      onText = _useFieldApi.onText,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_5__["default"], {
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: true,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Switch_Switch_js__WEBPACK_IMPORTED_MODULE_7__.Switch, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, rest, input, {
    id: id || input.name,
    isDisabled: isDisabled || isReadOnly,
    label: isRequired ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_is_required_is_required__WEBPACK_IMPORTED_MODULE_6__["default"], null, onText || label) : onText || label,
    labelOff: isRequired ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_is_required_is_required__WEBPACK_IMPORTED_MODULE_6__["default"], null, offText || label) : offText || label
  })));
};

Switch.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  onText: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  offText: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Switch);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/index.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _tabs__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tabs */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/tabs.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/tabs.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/tabs/tabs.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Tabs_Tab_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Tabs/Tab.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Tabs/Tab.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Tabs_Tabs_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Tabs/Tabs.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Tabs/Tabs.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Tabs_TabTitleText_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Tabs/TabTitleText.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Tabs/TabTitleText.js");



var _excluded = ["fields", "dataType", "validate", "component"];







var FormTabs = function FormTabs(_ref) {
  var fields = _ref.fields,
      dataType = _ref.dataType,
      validate = _ref.validate,
      component = _ref.component,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref, _excluded);

  var formOptions = (0,_data_driven_forms_react_form_renderer_use_form_api__WEBPACK_IMPORTED_MODULE_4__["default"])();

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(0),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useState, 2),
      activeTabKey = _useState2[0],
      setActiveTabKey = _useState2[1];

  var handleTabClick = function handleTabClick(event, tabIndex) {
    event.preventDefault();
    setActiveTabKey(tabIndex);
  };

  var renderTabItems = function renderTabItems(fields) {
    return fields.map(function (_ref2, index) {
      var fields = _ref2.fields,
          title = _ref2.title,
          name = _ref2.name;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Tabs_Tab_js__WEBPACK_IMPORTED_MODULE_5__.Tab, {
        key: name,
        eventKey: index,
        title: typeof title === 'string' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Tabs_TabTitleText_js__WEBPACK_IMPORTED_MODULE_6__.TabTitleText, null, title) : title
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement("div", {
        className: "pf-c-form"
      }, formOptions.renderForm(fields, formOptions)));
    });
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Tabs_Tabs_js__WEBPACK_IMPORTED_MODULE_7__.Tabs, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    activeKey: activeTabKey,
    onSelect: handleTabClick
  }, rest), renderTabItems(fields, formOptions));
};

FormTabs.propTypes = {
  fields: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().array.isRequired),
  dataType: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().any),
  validate: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().any),
  component: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().any)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormTabs);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _text_field__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _text_field__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./text-field */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/text-field.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/text-field.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/text-field/text-field.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_TextInput_TextInput_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/TextInput/TextInput.js */ "./node_modules/@patternfly/react-core/dist/esm/components/TextInput/TextInput.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _show_error_show_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../show-error/show-error */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];







var TextField = function TextField(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_3__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_TextInput_TextInput_js__WEBPACK_IMPORTED_MODULE_6__.TextInput, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, input, (0,_show_error_show_error__WEBPACK_IMPORTED_MODULE_5__["default"])(meta, validateOnMount), rest, {
    id: id || input.name,
    isRequired: isRequired,
    isReadOnly: isReadOnly,
    isDisabled: isDisabled
  })));
};

TextField.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextField);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _textarea__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _textarea__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./textarea */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/textarea.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/textarea.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/textarea/textarea.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_TextArea_TextArea_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/TextArea/TextArea.js */ "./node_modules/@patternfly/react-core/dist/esm/components/TextArea/TextArea.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _show_error_show_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../show-error/show-error */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/show-error/show-error.js");


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];







var Textarea = function Textarea(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_3__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_4__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_TextArea_TextArea_js__WEBPACK_IMPORTED_MODULE_6__.TextArea, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, (0,_show_error_show_error__WEBPACK_IMPORTED_MODULE_5__["default"])(meta, validateOnMount), {
    isRequired: isRequired,
    disabled: isDisabled || isReadOnly
  }, input, {
    id: id || input.name
  }, rest)));
};

Textarea.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Textarea);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/index.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _time_picker__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _time_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./time-picker */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/time-picker.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/time-picker.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/time-picker/time-picker.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _form_group_form_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../form-group/form-group */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/form-group/form-group.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_TimePicker_TimePicker_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/TimePicker/TimePicker.js */ "./node_modules/@patternfly/react-core/dist/esm/components/TimePicker/TimePicker.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);


var _excluded = ["label", "isRequired", "helperText", "meta", "validateOnMount", "description", "hideLabel", "input", "isReadOnly", "isDisabled", "id", "FormGroupProps"];






var TimePicker = function TimePicker(props) {
  var _useFieldApi = (0,_data_driven_forms_react_form_renderer_use_field_api__WEBPACK_IMPORTED_MODULE_4__["default"])(props),
      label = _useFieldApi.label,
      isRequired = _useFieldApi.isRequired,
      helperText = _useFieldApi.helperText,
      meta = _useFieldApi.meta,
      validateOnMount = _useFieldApi.validateOnMount,
      description = _useFieldApi.description,
      hideLabel = _useFieldApi.hideLabel,
      input = _useFieldApi.input,
      isReadOnly = _useFieldApi.isReadOnly,
      isDisabled = _useFieldApi.isDisabled,
      id = _useFieldApi.id,
      FormGroupProps = _useFieldApi.FormGroupProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_useFieldApi, _excluded);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_form_group_form_group__WEBPACK_IMPORTED_MODULE_3__["default"], {
    label: label,
    isRequired: isRequired,
    helperText: helperText,
    meta: meta,
    validateOnMount: validateOnMount,
    description: description,
    hideLabel: hideLabel,
    id: id || input.name,
    FormGroupProps: FormGroupProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_TimePicker_TimePicker_js__WEBPACK_IMPORTED_MODULE_5__.TimePicker, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, input, {
    defaultTime: input.value
  }, rest, {
    id: id || input.name,
    isDisabled: isDisabled || isReadOnly
  })));
};

TimePicker.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  validateOnMount: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isReadOnly: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isRequired: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  FormGroupProps: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TimePicker);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/index.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _wizard__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _wizard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wizard */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/reducer.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/reducer.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

var reducer = function reducer(state, _ref) {
  var type = _ref.type;

  switch (type) {
    case 'openNav':
      return _objectSpread(_objectSpread({}, state), {}, {
        openNav: true
      });

    case 'closeNav':
      return _objectSpread(_objectSpread({}, state), {}, {
        openNav: false
      });

    case 'finishLoading':
      return _objectSpread(_objectSpread({}, state), {}, {
        loading: false
      });

    case 'setContainer':
      return _objectSpread(_objectSpread({}, state), {}, {
        container: state.container || document.createElement('div')
      });

    default:
      return state;
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reducer);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/step-buttons.js":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/step-buttons.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Button/Button.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _data_driven_forms_common_wizard_select_next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @data-driven-forms/common/wizard/select-next */ "./node_modules/@data-driven-forms/common/wizard/select-next.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/form-spy */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js");







var NextButton = function NextButton(_ref) {
  var nextStep = _ref.nextStep,
      valid = _ref.valid,
      handleNext = _ref.handleNext,
      nextLabel = _ref.nextLabel,
      getState = _ref.getState,
      handleSubmit = _ref.handleSubmit,
      submitLabel = _ref.submitLabel,
      conditionalSubmitFlag = _ref.conditionalSubmitFlag;
  var nextResult = nextStep ? (0,_data_driven_forms_common_wizard_select_next__WEBPACK_IMPORTED_MODULE_2__["default"])(nextStep, getState) : nextStep;
  var progressNext = nextResult !== conditionalSubmitFlag && nextStep;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_4__.Button, {
    variant: "primary",
    type: "button",
    isDisabled: !valid || getState().validating,
    onClick: function onClick() {
      return progressNext ? handleNext((0,_data_driven_forms_common_wizard_select_next__WEBPACK_IMPORTED_MODULE_2__["default"])(nextStep, getState)) : handleSubmit();
    }
  }, progressNext ? nextLabel : submitLabel);
};

NextButton.propTypes = {
  nextStep: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object)]),
  handleSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  submitLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired),
  valid: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  handleNext: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  nextLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired),
  getState: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  conditionalSubmitFlag: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)
};

var WizardStepButtons = function WizardStepButtons(_ref2) {
  var Buttons = _ref2.buttons,
      disableBack = _ref2.disableBack,
      handlePrev = _ref2.handlePrev,
      nextStep = _ref2.nextStep,
      handleNext = _ref2.handleNext,
      buttonsClassName = _ref2.buttonsClassName,
      _ref2$buttonLabels = _ref2.buttonLabels,
      cancel = _ref2$buttonLabels.cancel,
      submit = _ref2$buttonLabels.submit,
      back = _ref2$buttonLabels.back,
      next = _ref2$buttonLabels.next,
      formOptions = _ref2.formOptions,
      conditionalSubmitFlag = _ref2.conditionalSubmitFlag;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement("footer", {
    className: "pf-c-wizard__footer ".concat(buttonsClassName ? buttonsClassName : '')
  }, Buttons ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(Buttons, {
    disableBack: disableBack,
    handlePrev: handlePrev,
    nextStep: nextStep,
    handleNext: handleNext,
    buttonsClassName: buttonsClassName,
    buttonLabels: {
      cancel: cancel,
      submit: submit,
      back: back,
      next: next
    },
    renderNextButton: function renderNextButton(args) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(NextButton, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, formOptions, {
        handleNext: handleNext,
        nextStep: nextStep,
        nextLabel: next,
        submitLabel: submit
      }, args));
    },
    selectNext: _data_driven_forms_common_wizard_select_next__WEBPACK_IMPORTED_MODULE_2__["default"]
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_3__["default"], null, function () {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(NextButton, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, formOptions, {
      conditionalSubmitFlag: conditionalSubmitFlag,
      handleNext: handleNext,
      nextStep: nextStep,
      nextLabel: next,
      submitLabel: submit
    })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_4__.Button, {
      type: "button",
      variant: "secondary",
      isDisabled: disableBack,
      onClick: handlePrev
    }, back), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", {
      className: "pf-c-wizard__footer-cancel"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(_patternfly_react_core_dist_esm_components_Button_Button_js__WEBPACK_IMPORTED_MODULE_4__.Button, {
      type: "button",
      variant: "link",
      onClick: formOptions.onCancel
    }, cancel)));
  }));
};

WizardStepButtons.propTypes = {
  disableBack: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  conditionalSubmitFlag: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  handlePrev: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  handleNext: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
  nextStep: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    when: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string.isRequired),
    stepMapper: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object.isRequired)
  }), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func)]),
  buttonLabels: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    submit: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired),
    cancel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired),
    back: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired),
    next: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node.isRequired)
  }).isRequired,
  buttonsClassName: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  buttons: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func)]),
  formOptions: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    getState: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired),
    onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired)
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardStepButtons);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-nav.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-nav.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Wizard_WizardNavItem_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Wizard/WizardNavItem.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Wizard/WizardNavItem.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Wizard_WizardNav_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Wizard/WizardNav.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Wizard/WizardNav.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);



var _excluded = ["setPrevSteps", "crossroads", "values"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }








var memoValues = function memoValues(initialValue) {
  var valueCache = initialValue;
  return function (value) {
    if (!lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(value, valueCache)) {
      valueCache = value;
      return true;
    }

    return false;
  };
};

var WizardNavigationInternal = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.memo(function (_ref) {
  var navSchema = _ref.navSchema,
      activeStepIndex = _ref.activeStepIndex,
      maxStepIndex = _ref.maxStepIndex,
      jumpToStep = _ref.jumpToStep,
      valid = _ref.valid,
      validating = _ref.validating;
  return navSchema.filter(function (field) {
    return field.primary;
  }).map(function (step) {
    var substeps = step.substepOf && navSchema.filter(function (field) {
      return field.substepOf === step.substepOf;
    });
    var isValid = valid && !validating;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardNavItem_js__WEBPACK_IMPORTED_MODULE_6__.WizardNavItem, {
      key: step.substepOf || step.name,
      content: step.substepOfTitle || step.title,
      isCurrent: substeps ? activeStepIndex >= step.index && activeStepIndex < step.index + substeps.length : activeStepIndex === step.index,
      isDisabled: isValid ? maxStepIndex < step.index : step.index > activeStepIndex,
      onNavItemClick: function onNavItemClick(ind) {
        return jumpToStep(ind, isValid);
      },
      step: step.index,
      type: "button"
    }, substeps && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardNav_js__WEBPACK_IMPORTED_MODULE_7__.WizardNav, {
      returnList: true
    }, substeps.map(function (substep) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardNavItem_js__WEBPACK_IMPORTED_MODULE_6__.WizardNavItem, {
        type: "button",
        key: substep.name,
        content: substep.title,
        isCurrent: activeStepIndex === substep.index,
        isDisabled: isValid ? maxStepIndex < substep.index : substep.index > activeStepIndex,
        onNavItemClick: function onNavItemClick(ind) {
          return jumpToStep(ind, isValid);
        },
        step: substep.index
      });
    })));
  });
}, (lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()));
WizardNavigationInternal.propTypes = {
  activeStepIndex: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number.isRequired),
  maxStepIndex: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number.isRequired),
  jumpToStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func.isRequired),
  navSchema: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().array.isRequired),
  valid: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool.isRequired),
  validating: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool.isRequired)
};

var WizardNavigation = function WizardNavigation(_ref2) {
  var setPrevSteps = _ref2.setPrevSteps,
      crossroads = _ref2.crossroads,
      values = _ref2.values,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref2, _excluded);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(function () {
    return memoValues(crossroads ? crossroads.reduce(function (acc, curr) {
      return _objectSpread(_objectSpread({}, acc), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, curr, lodash_get__WEBPACK_IMPORTED_MODULE_5___default()(values, curr)));
    }, {}) : {});
  }),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useState, 1),
      memoValue = _useState2[0];

  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(function () {
    if (crossroads) {
      var modifiedRoad = crossroads.reduce(function (acc, curr) {
        return _objectSpread(_objectSpread({}, acc), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, curr, lodash_get__WEBPACK_IMPORTED_MODULE_5___default()(values, curr)));
      }, {});

      if (memoValue(modifiedRoad)) {
        setPrevSteps();
      }
    }
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.createElement(WizardNavigationInternal, props);
};

WizardNavigation.propTypes = {
  setPrevSteps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().func.isRequired),
  values: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object.isRequired),
  crossroads: prop_types__WEBPACK_IMPORTED_MODULE_8___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_8___default().string))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardNavigation);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-step.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-step.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RenderTitle": () => (/* binding */ RenderTitle),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Title_Title_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Title/Title.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Title/Title.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Wizard_WizardBody_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Wizard/WizardBody.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Wizard/WizardBody.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _step_buttons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./step-buttons */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/step-buttons.js");


var _excluded = ["name", "title", "description", "fields", "formOptions", "showTitles", "showTitle", "customTitle", "hasNoBodyPadding", "StepTemplate"];





var RenderTitle = function RenderTitle(_ref) {
  var title = _ref.title,
      customTitle = _ref.customTitle;
  return customTitle ? customTitle : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Title_Title_js__WEBPACK_IMPORTED_MODULE_4__.Title, {
    headingLevel: "h1",
    size: "xl"
  }, title);
};
RenderTitle.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  customTitle: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

var DefaultStepTemplate = function DefaultStepTemplate(_ref2) {
  var formFields = _ref2.formFields,
      formRef = _ref2.formRef,
      title = _ref2.title,
      customTitle = _ref2.customTitle,
      showTitle = _ref2.showTitle,
      showTitles = _ref2.showTitles;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("div", {
    ref: formRef,
    className: "pf-c-form"
  }, (showTitles && showTitle !== false || showTitle) && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(RenderTitle, {
    title: title,
    customTitle: customTitle
  }), formFields);
};

DefaultStepTemplate.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  formFields: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array.isRequired),
  formOptions: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    renderForm: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired)
  }).isRequired,
  showTitles: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  showTitle: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  customTitle: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  formRef: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().func), prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    current: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(Element)
  })])
};

var WizardStep = function WizardStep(_ref3) {
  var name = _ref3.name,
      title = _ref3.title,
      description = _ref3.description,
      fields = _ref3.fields,
      formOptions = _ref3.formOptions,
      showTitles = _ref3.showTitles,
      showTitle = _ref3.showTitle,
      customTitle = _ref3.customTitle,
      hasNoBodyPadding = _ref3.hasNoBodyPadding,
      StepTemplate = _ref3.StepTemplate,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref3, _excluded);

  var formRef = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)();
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(function () {
    // HACK: I can not pass ref to WizardBody because it is not
    // wrapped by forwardRef. However, the step body (the one that overflows)
    // is the grand parent of the form element.
    var stepBody = formRef.current && formRef.current.parentNode.parentNode;
    stepBody && stepBody.scrollTo({
      top: 0,
      left: 0,
      behavior: 'smooth'
    });
  }, [name]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(react__WEBPACK_IMPORTED_MODULE_2__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardBody_js__WEBPACK_IMPORTED_MODULE_6__.WizardBody, {
    hasNoBodyPadding: hasNoBodyPadding
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(StepTemplate, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formFields: fields.map(function (item) {
      return formOptions.renderForm([item], formOptions);
    }),
    name: name,
    title: title,
    description: description,
    formOptions: formOptions,
    showTitles: showTitles,
    showTitle: showTitle,
    customTitle: customTitle,
    hasNoBodyPadding: hasNoBodyPadding,
    formRef: formRef,
    fields: fields
  }, rest))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(_step_buttons__WEBPACK_IMPORTED_MODULE_3__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formOptions: formOptions
  }, rest)));
};

WizardStep.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  fields: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array.isRequired),
  formOptions: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({
    renderForm: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func.isRequired)
  }).isRequired,
  showTitles: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  showTitle: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  customTitle: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  name: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)]),
  hasNoBodyPadding: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  StepTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().elementType),
  conditionalSubmitFlag: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)
};
WizardStep.defaultProps = {
  StepTemplate: DefaultStepTemplate
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardStep);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-toggle.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-toggle.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/caret-down-icon */ "./node_modules/@patternfly/react-icons/dist/esm/icons/caret-down-icon.js");





var WizardToggle = function WizardToggle(_ref) {
  var _navSchema$find, _navSchema$find2, _navSchema$find3;

  var activeStepIndex = _ref.activeStepIndex,
      currentStep = _ref.currentStep,
      navSchema = _ref.navSchema,
      isOpen = _ref.isOpen,
      dispatch = _ref.dispatch;
  var substepTitle = (_navSchema$find = navSchema.find(function (step) {
    return step.name === currentStep.name;
  })) === null || _navSchema$find === void 0 ? void 0 : _navSchema$find.substepOfTitle;
  var substepName = (_navSchema$find2 = navSchema.find(function (step) {
    return step.name === currentStep.name;
  })) === null || _navSchema$find2 === void 0 ? void 0 : _navSchema$find2.substepOf;
  var index = substepName ? (_navSchema$find3 = navSchema.find(function (step) {
    return step.substepOf === substepName;
  })) === null || _navSchema$find3 === void 0 ? void 0 : _navSchema$find3.index : activeStepIndex;
  var activeStepName = substepTitle || currentStep.title;
  var activeStepSubName = substepTitle ? currentStep.title : undefined;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    onClick: function onClick() {
      return dispatch({
        type: isOpen ? 'closeNav' : 'openNav'
      });
    },
    className: "pf-c-wizard__toggle ".concat(isOpen ? 'pf-m-expanded' : ''),
    "aria-label": "Wizard Toggle",
    "aria-expanded": isOpen,
    type: "button"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ol", {
    className: "pf-c-wizard__toggle-list"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: "pf-c-wizard__toggle-list-item"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "pf-c-wizard__toggle-num"
  }, index + 1), " ", activeStepName, activeStepSubName && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: "pf-c-wizard__toggle-separator",
    "aria-hidden": "true"
  })), activeStepSubName && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: "pf-c-wizard__toggle-list-item"
  }, activeStepSubName)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "pf-c-wizard__toggle-icon"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_2__["default"], {
    "aria-hidden": "true"
  })));
};

WizardToggle.propTypes = {
  activeStepIndex: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  currentStep: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object),
  navSchema: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().array),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dispatch: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardToggle);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/form-spy */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js");
/* harmony import */ var _data_driven_forms_react_form_renderer_wizard_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @data-driven-forms/react-form-renderer/wizard-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/index.js");
/* harmony import */ var _data_driven_forms_common_wizard_wizard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @data-driven-forms/common/wizard/wizard */ "./node_modules/@data-driven-forms/common/wizard/wizard.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Wizard_WizardNav_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Wizard/WizardNav.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Wizard/WizardNav.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Wizard_WizardHeader_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Wizard/WizardHeader.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Wizard/WizardHeader.js");
/* harmony import */ var _patternfly_react_core_dist_esm_components_Modal_Modal_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @patternfly/react-core/dist/esm/components/Modal/Modal.js */ "./node_modules/@patternfly/react-core/dist/esm/components/Modal/Modal.js");
/* harmony import */ var _wizard_components_wizard_step__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./wizard-components/wizard-step */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-step.js");
/* harmony import */ var _wizard_components_wizard_styles_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./wizard-components/wizard-styles.css */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-styles.css");
/* harmony import */ var _wizard_components_wizard_nav__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./wizard-components/wizard-nav */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-nav.js");
/* harmony import */ var _wizard_components_reducer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./wizard-components/reducer */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/reducer.js");
/* harmony import */ var _wizard_components_wizard_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./wizard-components/wizard-toggle */ "./node_modules/@data-driven-forms/pf4-component-mapper/esm/wizard/wizard-components/wizard-toggle.js");




var _excluded = ["children", "container", "inModal"],
    _excluded2 = ["inModal", "title", "description", "buttonLabels", "buttonsClassName", "showTitles", "container", "hideClose", "titleId", "descriptionId", "closeButtonAriaLabel", "hasNoBodyPadding", "navAriaLabel", "StepTemplate", "className", "conditionalSubmitFlag"],
    _excluded3 = ["buttonLabels"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }















var Modal = function Modal(_ref) {
  var children = _ref.children,
      container = _ref.container,
      inModal = _ref.inModal,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref, _excluded);

  return inModal ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_patternfly_react_core_dist_esm_components_Modal_Modal_js__WEBPACK_IMPORTED_MODULE_13__.Modal, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
    variant: "large",
    isOpen: true,
    showClose: false,
    hasNoBodyWrapper: true,
    appendTo: container
  }, rest), children) : children;
};

Modal.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
  container: prop_types__WEBPACK_IMPORTED_MODULE_14___default().instanceOf(Element),
  inModal: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool)
};

var WizardInternal = function WizardInternal(_ref2) {
  var inModal = _ref2.inModal,
      title = _ref2.title,
      description = _ref2.description,
      buttonLabels = _ref2.buttonLabels,
      buttonsClassName = _ref2.buttonsClassName,
      showTitles = _ref2.showTitles,
      container = _ref2.container,
      hideClose = _ref2.hideClose,
      titleId = _ref2.titleId,
      descriptionId = _ref2.descriptionId,
      closeButtonAriaLabel = _ref2.closeButtonAriaLabel,
      hasNoBodyPadding = _ref2.hasNoBodyPadding,
      navAriaLabel = _ref2.navAriaLabel,
      StepTemplate = _ref2.StepTemplate,
      className = _ref2.className,
      conditionalSubmitFlag = _ref2.conditionalSubmitFlag,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref2, _excluded2);

  var _useContext = (0,react__WEBPACK_IMPORTED_MODULE_4__.useContext)(_data_driven_forms_react_form_renderer_wizard_context__WEBPACK_IMPORTED_MODULE_6__["default"]),
      crossroads = _useContext.crossroads,
      formOptions = _useContext.formOptions,
      currentStep = _useContext.currentStep,
      handlePrev = _useContext.handlePrev,
      _onKeyDown = _useContext.onKeyDown,
      _jumpToStep = _useContext.jumpToStep,
      setPrevSteps = _useContext.setPrevSteps,
      _handleNext = _useContext.handleNext,
      navSchema = _useContext.navSchema,
      activeStepIndex = _useContext.activeStepIndex,
      maxStepIndex = _useContext.maxStepIndex,
      isDynamic = _useContext.isDynamic;

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_4__.useReducer)(_wizard_components_reducer__WEBPACK_IMPORTED_MODULE_11__["default"], {
    loading: true,
    container: container,
    openNav: false
  }),
      _useReducer2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useReducer, 2),
      state = _useReducer2[0],
      dispatch = _useReducer2[1];

  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(function () {
    if (inModal) {
      dispatch({
        type: 'setContainer'
      });
    } else {
      dispatch({
        type: 'finishLoading'
      });
    }
  }, [inModal]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(function () {
    if (state.container) {
      document.body.appendChild(state.container);
      dispatch({
        type: 'finishLoading'
      });
    }

    return function () {
      if (inModal && state.container) {
        document.body.removeChild(state.container);
      }
    };
  }, [state.container, inModal]);

  if (state.loading) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(Modal, {
    inModal: inModal,
    container: state.container,
    "aria-labelledby": rest.name
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement("div", (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
    tabIndex: inModal ? 0 : null,
    className: "pf-c-wizard ".concat(inModal ? '' : 'no-shadow', " ddorg__pf4-component-mapper__wizard ").concat(className ? className : ''),
    role: "dialog",
    "aria-modal": inModal ? 'true' : undefined,
    onKeyDown: function onKeyDown(e) {
      _onKeyDown(e);

      if (e.key === 'Escape' && inModal) {
        formOptions.onCancel();
      }
    }
  }, rest), title && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardHeader_js__WEBPACK_IMPORTED_MODULE_15__.WizardHeader, {
    title: title,
    description: description,
    onClose: formOptions.onCancel,
    hideClose: hideClose,
    titleId: titleId,
    descriptionId: descriptionId,
    closeButtonAriaLabel: closeButtonAriaLabel
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_wizard_components_wizard_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
    activeStepIndex: activeStepIndex,
    currentStep: currentStep,
    navSchema: navSchema,
    isOpen: state.openNav,
    dispatch: dispatch
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement("div", {
    className: "pf-c-wizard__outer-wrap"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement("div", {
    className: "pf-c-wizard__inner-wrap"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_patternfly_react_core_dist_esm_components_Wizard_WizardNav_js__WEBPACK_IMPORTED_MODULE_16__.WizardNav, {
    "aria-label": navAriaLabel,
    isOpen: state.openNav
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_data_driven_forms_react_form_renderer_form_spy__WEBPACK_IMPORTED_MODULE_5__["default"], {
    subscription: {
      values: true,
      valid: true,
      validating: true
    }
  }, function (_ref3) {
    var values = _ref3.values,
        valid = _ref3.valid,
        validating = _ref3.validating;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_wizard_components_wizard_nav__WEBPACK_IMPORTED_MODULE_10__["default"], {
      navSchema: navSchema,
      activeStepIndex: activeStepIndex,
      valid: valid,
      maxStepIndex: maxStepIndex,
      jumpToStep: function jumpToStep() {
        state.openNav && dispatch({
          type: 'closeNav'
        });
        return _jumpToStep.apply(void 0, arguments);
      },
      crossroads: crossroads,
      isDynamic: isDynamic,
      values: values,
      setPrevSteps: setPrevSteps,
      validating: validating
    });
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_wizard_components_wizard_step__WEBPACK_IMPORTED_MODULE_8__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
    conditionalSubmitFlag: conditionalSubmitFlag,
    buttonLabels: buttonLabels,
    buttonsClassName: buttonsClassName,
    showTitles: showTitles,
    hasNoBodyPadding: hasNoBodyPadding,
    StepTemplate: StepTemplate
  }, currentStep, {
    formOptions: formOptions,
    handleNext: function handleNext(nextStep) {
      return _handleNext(nextStep);
    },
    handlePrev: handlePrev,
    disableBack: activeStepIndex === 0
  }))))));
};

WizardInternal.propTypes = {
  buttonLabels: prop_types__WEBPACK_IMPORTED_MODULE_14___default().shape({
    submit: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node.isRequired),
    cancel: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node.isRequired),
    back: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node.isRequired),
    next: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node.isRequired)
  }).isRequired,
  buttonsClassName: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().any),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().any),
  inModal: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool),
  showTitles: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool),
  hideClose: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool),
  titleId: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  descriptionId: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  closeButtonAriaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  hasNoBodyPadding: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool),
  navAriaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  container: prop_types__WEBPACK_IMPORTED_MODULE_14___default().instanceOf(Element),
  StepTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().elementType),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string),
  conditionalSubmitFlag: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string)
};
var defaultLabels = {
  submit: 'Submit',
  cancel: 'Cancel',
  back: 'Back',
  next: 'Next'
};

var WizardFunction = function WizardFunction(_ref4) {
  var buttonLabels = _ref4.buttonLabels,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref4, _excluded3);

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_data_driven_forms_common_wizard_wizard__WEBPACK_IMPORTED_MODULE_7__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
    Wizard: WizardInternal
  }, props, {
    buttonLabels: _objectSpread(_objectSpread({}, defaultLabels), buttonLabels)
  }));
};

WizardFunction.propTypes = {
  buttonLabels: prop_types__WEBPACK_IMPORTED_MODULE_14___default().shape({
    submit: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
    cancel: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
    back: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node)
  })
};
WizardFunction.defaultProps = {
  buttonLabels: {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardFunction);

/***/ }),

/***/ "./node_modules/@data-driven-forms/pf4-component-mapper/show-error/show-error.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/pf4-component-mapper/show-error/show-error.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var showError = function showError(_ref, validateOnMount) {
  var error = _ref.error,
      touched = _ref.touched,
      warning = _ref.warning,
      submitError = _ref.submitError;

  if ((touched || validateOnMount) && error) {
    return {
      validated: 'error'
    };
  }

  if ((touched || validateOnMount) && submitError) {
    return {
      validated: 'error'
    };
  }

  if ((touched || validateOnMount) && warning) {
    return {
      validated: 'warning'
    };
  }

  return {
    validated: 'default'
  };
};

var _default = showError;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/common/helpers.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/common/helpers.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TO_STRING": () => (/* binding */ TO_STRING),
/* harmony export */   "assign": () => (/* binding */ assign),
/* harmony export */   "isNumber": () => (/* binding */ isNumber),
/* harmony export */   "memoize": () => (/* binding */ memoize),
/* harmony export */   "prepare": () => (/* binding */ prepare),
/* harmony export */   "prepareMsg": () => (/* binding */ prepareMsg),
/* harmony export */   "selectNum": () => (/* binding */ selectNum),
/* harmony export */   "trunc": () => (/* binding */ trunc)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _validators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/index.js");


/* eslint-disable no-unused-vars */


var HAS_PROP = {}.hasOwnProperty;
var TO_STRING = {}.toString;

var isObject = function isObject(obj) {
  return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(obj) === 'object' && TO_STRING.call(obj) === '[object Object]' && obj !== null;
};

var stringify = function stringify(args) {
  var arr = [];
  var value;
  var options = args;

  if (typeof options === 'number') {
    options = options.toString();
  }

  for (var k in options) {
    if (HAS_PROP.call(options, k)) {
      value = options[k];
      arr.push(k, /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(value) ? stringify(value.props) : isObject(value) ? stringify(value) : value.toString());
    }
  }

  return JSON.stringify(arr);
};

var memoize = function memoize(func) {
  if (!func.cache) {
    func.cache = {};
  }

  return function (value, allValues) {
    var key = stringify(value, allValues);

    for (var _len = arguments.length, options = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      options[_key - 2] = arguments[_key];
    }

    return HAS_PROP.call(func.cache, key) ? func.cache[key] : func.cache[key] = func.apply(void 0, [value, allValues].concat(options));
  };
};

var defaultMessage = function defaultMessage(type, values) {
  var msg = _validators__WEBPACK_IMPORTED_MODULE_2__["default"].messages[type];
  return typeof msg === 'string' ? {
    defaultMessage: msg,
    values: values
  } : Object.assign({}, msg, {
    values: values
  });
};

var prepareMsg = function prepareMsg(msg, type, values) {
  if (msg == null) {
    return defaultMessage(type, values);
  }

  if (HAS_PROP.call(msg, 'props') && /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(msg)) {
    msg = msg.props;
  }

  if (msg[type] != null) {
    msg = msg[type];
  }

  if (isObject(msg)) {
    if (HAS_PROP.call(msg, 'id') || HAS_PROP.call(msg, 'defaultMessage')) {
      return Object.assign({}, msg, {
        values: values
      });
    }

    return defaultMessage(type, values);
  }

  return {
    id: msg,
    defaultMessage: msg,
    values: values
  };
};
var assign = Object.assign;
var prepare = function prepare(func) {
  return function (value, allValues) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }

    return func.apply(void 0, [value, allValues].concat(args));
  };
};
var isNumber = function isNumber(num) {
  return !isNaN(num) && (num !== 0 || ('' + num).trim() !== '');
};
function selectNum(var1, var2) {
  return isNumber(var1) ? +var1 : arguments.length > 1 && isNumber(var2) ? +var2 : null;
}
var trunc = function trunc(num) {
  return Math.trunc ? Math.trunc(num) : num < 0 ? Math.ceil(num) : Math.floor(num);
};

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/component-types.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/component-types.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var componentTypes = {
  TEXT_FIELD: 'text-field',
  FIELD_ARRAY: 'field-array',
  CHECKBOX: 'checkbox',
  SUB_FORM: 'sub-form',
  RADIO: 'radio',
  TABS: 'tabs',
  TAB_ITEM: 'tab-item',
  DATE_PICKER: 'date-picker',
  TIME_PICKER: 'time-picker',
  WIZARD: 'wizard',
  SWITCH: 'switch',
  TEXTAREA: 'textarea',
  SELECT: 'select',
  PLAIN_TEXT: 'plain-text',
  BUTTON: 'button',
  INPUT_ADDON_GROUP: 'input-addon-group',
  INPUT_ADDON_BUTTON_GROUP: 'input-addon-button-group',
  DUAL_LIST_SELECT: 'dual-list-select',
  SLIDER: 'slider'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (componentTypes);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _component_types__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _component_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/component-types.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/compose-validators.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/compose-validators.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toArray */ "./node_modules/@babel/runtime/helpers/esm/toArray.js");


var composeValidators = function composeValidators() {
  var validators = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return function (value, allValues, meta) {
    var _validators = (0,_babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_0__["default"])(validators),
        initialValidator = _validators[0],
        sequenceValidators = _validators.slice(1);

    var resolveValidator = function resolveValidator(error, validator) {
      if (error) {
        return error;
      }

      if (typeof validator !== 'function') {
        return undefined;
      }

      return validator(value, allValues, meta);
    };

    var result = resolveValidator(undefined, initialValidator);

    if (result !== null && result !== void 0 && result.then) {
      return result.then(function () {
        return sequenceValidators.reduce(resolveValidator, undefined);
      })["catch"](function (error) {
        return error;
      });
    }

    return sequenceValidators.reduce(resolveValidator, result);
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (composeValidators);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/index.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/index.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _compose_validators__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _compose_validators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compose-validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/compose-validators.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/condition/condition.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/condition/condition.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "reducer": () => (/* binding */ reducer)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _use_form_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _parse_condition__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../parse-condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/index.js");




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }







var setterValueCheck = function setterValueCheck(setterValue) {
  if (setterValue === null || Array.isArray(setterValue)) {
    console.error('Received invalid setterValue. Expected object, received: ', setterValue);
    return false;
  }

  return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_2__["default"])(setterValue) === 'object';
};

var reducer = function reducer(state, _ref) {
  var type = _ref.type,
      sets = _ref.sets;

  switch (type) {
    case 'formResetted':
      return _objectSpread(_objectSpread({}, state), {}, {
        initial: true
      });

    case 'rememberSets':
      return _objectSpread(_objectSpread({}, state), {}, {
        initial: false,
        sets: sets
      });

    default:
      return state;
  }
};
var Condition = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3__.memo(function (_ref2) {
  var condition = _ref2.condition,
      children = _ref2.children,
      values = _ref2.values,
      field = _ref2.field;
  var formOptions = (0,_use_form_api__WEBPACK_IMPORTED_MODULE_5__["default"])();
  var dirty = formOptions.getState().dirty;

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_3__.useReducer)(reducer, {
    sets: [],
    initial: true
  }),
      _useReducer2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_useReducer, 2),
      state = _useReducer2[0],
      dispatch = _useReducer2[1];

  var conditionResult = (0,_parse_condition__WEBPACK_IMPORTED_MODULE_6__["default"])(condition, values, field);
  var setters = conditionResult.set ? [conditionResult.set] : conditionResult.sets;
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(function () {
    if (!dirty) {
      dispatch({
        type: 'formResetted'
      });
    }
  }, [dirty]);
  var setValue = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(function (setter) {
    Object.entries(setter).forEach(function (_ref3) {
      var _ref4 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref3, 2),
          name = _ref4[0],
          value = _ref4[1];

      formOptions.change(name, value);
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(function () {
    if (setters && setters.length > 0 && (state.initial || !lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(setters, state.sets))) {
      setters.forEach(function (setter, index) {
        if (setter && (state.initial || !lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(setter, state.sets[index]))) {
          setTimeout(function () {
            /**
             * We have to get the meta in the timetout to wait for state initialization
             */
            var meta = formOptions.getFieldState(field.name);
            var isFormModified = Object.values(formOptions.getState().modified).some(Boolean);
            /**
             * Apply setter only
             *    - field has no initial value
             *    - form is modified
             *    - when meta is false = field was unmounted before timeout, we finish the condition
             */

            if (!meta || isFormModified || typeof meta.initial === 'undefined') {
              formOptions.batch(function () {
                if (typeof setter !== 'function') {
                  setValue(setter);
                } else {
                  var setterValue = setter(formOptions.getState(), formOptions.getFieldState);

                  if (setterValueCheck(setterValue)) {
                    setValue(setterValue);
                  } else {
                    console.error('Received invalid setterValue. Expected object, received: ', setterValue);
                  }
                }
              });
            }
          });
        }
      });
      dispatch({
        type: 'rememberSets',
        sets: setters
      });
    }
  }, [setters, state.initial]);
  return conditionResult.visible ? children : null;
}, function (a, b) {
  return lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(a.values, b.values) && lodash_isEqual__WEBPACK_IMPORTED_MODULE_4___default()(a.condition, b.condition);
});
var conditionProps = {
  when: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().string), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func)]),
  is: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)]),
  isNotEmpty: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  isEmpty: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  pattern: function pattern(props, name, componentName) {
    if (!props[name]) {
      return;
    }

    if (typeof props[name] === 'string') {
      return;
    }

    if (props[name] instanceof RegExp) {
      return;
    }

    return new Error("Invalid prop pattern supplied to condition in `".concat(componentName, "`. Validation failed.\n    pattern has to be RegExp or string. Received `").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_2__["default"])(props[name]), "`."));
  },
  notMatch: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().any),
  then: prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    visible: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    set: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func)])
  }),
  "else": prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    visible: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    set: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func)])
  })
};
var nestedConditions = {
  or: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps))]),
  and: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps))]),
  not: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps))]),
  sequence: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionProps))
};

var conditionsProps = _objectSpread(_objectSpread({}, conditionProps), nestedConditions);

Condition.propTypes = {
  condition: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionsProps), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape(conditionsProps))]),
  children: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().node), prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().node))]).isRequired,
  values: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object.isRequired),
  field: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Condition);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/condition/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/condition/index.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "reducer": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_0__.reducer)
/* harmony export */ });
/* harmony import */ var _condition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/condition/condition.js");



/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/data-types.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/data-types.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var dataTypes = {
  INTEGER: 'integer',
  FLOAT: 'float',
  NUMBER: 'number',
  BOOLEAN: 'boolean',
  STRING: 'string'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dataTypes);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/index.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _data_types__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _data_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./data-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/data-types.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/default-schema-validator.js":
/*!**********************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/default-schema-validator.js ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _schema_errors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../schema-errors */ "./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/index.js");
/* harmony import */ var _component_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js");
/* harmony import */ var _data_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../data-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/index.js");


/* eslint-disable no-prototype-builtins */
 //import isValidComponent from './isValidComponent';



var componentBlackList = [_component_types__WEBPACK_IMPORTED_MODULE_2__["default"].FIELD_ARRAY, 'tab-item'];

var checkFieldsArray = function checkFieldsArray(obj, objectKey) {
  if (!obj.hasOwnProperty('fields')) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("Component of type ".concat(objectKey, " must contain \"fields\" property of type array, received undefined!"));
  }

  if (!Array.isArray(obj.fields)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("Component of type ".concat(objectKey, " must contain \"fields\" property of type array, received type: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(obj.fields), "!"));
  }
};

var checkConditionalAction = function checkConditionalAction(type, action, fieldName) {
  if (action.hasOwnProperty('visible') && typeof action.visible !== 'boolean') {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'visible' property in action \"").concat(type, "\" has to be a boolean value! Received: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(action.visible), ".\n    "));
  }

  if (action.hasOwnProperty('set') && ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(action.set) !== 'object' && typeof action.set !== 'function' || Array.isArray(action.set))) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'set' property in action \"").concat(type, "\" has to be a object! Received: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(action.visible), ", isArray: ").concat(Array.isArray(action.set), ".\n    "));
  }
};

var checkCondition = function checkCondition(condition, fieldName, isRoot) {
  /**
   * validate array condition
   */
  if (Array.isArray(condition)) {
    return condition.forEach(function (item) {
      return checkCondition(item, fieldName);
    });
  }

  if (condition.hasOwnProperty('and') && !Array.isArray(condition.and)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'and' property in a field condition must be an array! Received: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition.and), ".\n    "));
  }

  if (condition.hasOwnProperty('or') && !Array.isArray(condition.or)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'or' property in a field condition must be an array! Received: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition.or), ".\n    "));
  }

  if (condition.hasOwnProperty('sequence') && !Array.isArray(condition.sequence)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'sequence' property in a field condition must be an array! Received: ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition.sequence), ".\n    "));
  }

  if (condition.hasOwnProperty('sequence') && !isRoot) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'sequence' condition has to be the root condition: \" condition: { sequence: [ ... ]} \"\n    "));
  }

  if ((condition.hasOwnProperty('then') || condition.hasOwnProperty('else')) && !isRoot) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      'then', 'else' condition keys can be included only in root conditions or in a 'sequence'.\n    "));
  }

  if (condition.hasOwnProperty('then')) {
    checkConditionalAction('then', condition.then, fieldName);
  }

  if (condition.hasOwnProperty('else')) {
    checkConditionalAction('else', condition["else"], fieldName);
  }

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition) !== 'object') {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field condition must be an object, received ").concat(Array.isArray(condition) ? 'array' : (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition), "!\n    "));
  }

  if (!condition.hasOwnProperty('and') && !condition.hasOwnProperty('or') && !condition.hasOwnProperty('not') && !condition.hasOwnProperty('sequence')) {
    if (!condition.hasOwnProperty('when')) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with \"name\" property: \"".concat(fieldName, "\".\n      Field condition must have \"when\" property! Properties received: [").concat(Object.keys(condition), "].\n    "));
    }

    if (!(typeof condition.when === 'string' || typeof condition.when === 'function' || Array.isArray(condition.when))) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field condition property \"when\" must be of type \"string\", \"function\" or \"array\", ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition.when), " received!].\n    "));
    }

    if (!condition.hasOwnProperty('is') && !condition.hasOwnProperty('isEmpty') && !condition.hasOwnProperty('isNotEmpty') && !condition.hasOwnProperty('pattern') && !condition.hasOwnProperty('greaterThan') && !condition.hasOwnProperty('greaterThanOrEqualTo') && !condition.hasOwnProperty('lessThan') && !condition.hasOwnProperty('lessThanOrEqualTo')) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field condition must have one of \"is\", \"isEmpty\", \"isNotEmpty\", \"pattern\", \"greaterThan\", \"greaterThanOrEqualTo\", \"lessThan\", \"lessThanOrEqualTo\" property! Properties received: [").concat(Object.keys(condition), "].\n    "));
    }

    if (condition.hasOwnProperty('notMatch') && !condition.hasOwnProperty('pattern') && !condition.hasOwnProperty('is')) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field condition must have \"pattern\" or \"is\" property when \"notMatch\" is set! Properties received: [").concat(Object.keys(condition), "].\n    "));
    }

    if (condition.hasOwnProperty('pattern') && !(condition.pattern instanceof RegExp) && typeof condition.pattern !== 'string') {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field condition must have \"pattern\" of instance \"RegExp\" or \"string\"! Instance received: [").concat(condition.pattern.constructor.name, "].\n    "));
    }
  } else {
    ['and', 'or', 'not'].forEach(function (key) {
      if (condition.hasOwnProperty(key)) {
        checkCondition(condition[key], fieldName);
      }
    });

    if (condition.hasOwnProperty('sequence')) {
      condition.sequence.forEach(function (item) {
        return checkCondition(item, fieldName, 'root');
      });
    }
  }
};

var checkValidators = function checkValidators(validate, fieldName, validatorTypes) {
  var validatorMapper = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  if (validate === undefined) {
    return;
  }

  if (!Array.isArray(validate)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Error occured in field definition with name: \"".concat(fieldName, "\".\n      Field validate property must be an Array, ").concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(validate), " received!\n    "));
  }

  validate.forEach(function (validator, index) {
    if (Array.isArray(validator) || (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(validator) !== 'object' && typeof validator !== 'function') {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n        Error occured in field definition with name: \"".concat(fieldName, "\".\n        Field validator at index: ").concat(index, " must be an object or a function, ").concat(Array.isArray(validator) ? 'array' : (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(validator), " received!\n      "));
    }

    if (typeof validator !== 'function') {
      if (!validator.hasOwnProperty('type')) {
        throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n        Error occured in field definition with name: \"".concat(fieldName, "\".\n        Field validator at index: ").concat(index, " does not have \"type\" property! Properties received: [").concat(Object.keys(validator), "].\n      "));
      }

      if (!validatorTypes.includes(validator.type)) {
        throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n        Error occured in field definition with name: \"".concat(fieldName, "\".\n        Field validator at index: ").concat(index, " does not have correct \"type\" property!\n        Received \"").concat(validator.type, "\", expected one of: [").concat(validatorTypes, "].\n      "));
      }

      if (validatorMapper.hasOwnProperty(validator.type)) {
        validatorMapper[validator.type](validator, fieldName);
      }
    }
  });
};

var checkDataType = function checkDataType(type, fieldName) {
  if (typeof type !== 'string') {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n    Error occured in field definition with name: \"".concat(fieldName, "\".\n    Unknow dataType. Data type must be string\n    "));
  }

  if (!Object.values(_data_types__WEBPACK_IMPORTED_MODULE_3__["default"]).includes(type)) {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n    Error occured in field definition with name: \"".concat(fieldName, "\".\n    Unknow dataType ").concat(type, ". Must be one these values: ").concat(Object.values(_data_types__WEBPACK_IMPORTED_MODULE_3__["default"]), "\n    "));
  }
};

var checkActions = function checkActions(actions, name, actionTypes) {
  var actionsValidator = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  Object.keys(actions).forEach(function (prop) {
    if (!Array.isArray(actions[prop])) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Action on prop \"".concat(prop, "\" in component \"").concat(name, "\" is not an array.\n      Please, make sure you defined your action in the schema.\n      ActionMapper has these values: [").concat(actionTypes, "]\n    "));
    }

    if (!actions[prop][0]) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Action on prop \"".concat(prop, "\" in component \"").concat(name, "\" has not defined action type as the first element.\n      Please, make sure you defined your action in the schema.\n      ActionMapper has these values: [").concat(actionTypes, "]\n    "));
    }

    if (!actionTypes.includes(actions[prop][0])) {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n      Action on prop \"".concat(prop, "\" in component \"").concat(name, "\" does not exist in ActionMapper.\n      ActionMapper has these values: [").concat(actionTypes, "].\n      Use one of them or define new action in the mapper.\n    "));
    }

    if (actionsValidator.hasOwnProperty(actions[prop][0])) {
      actionsValidator[actions[prop][0]](actions[prop], name);
    }
  });
};

var iterateOverFields = function iterateOverFields(fields, componentMapper, validatorTypes, actionTypes, schemaValidatorMapper) {
  var parent = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};
  fields.forEach(function (field) {
    if (Array.isArray(field)) {
      return iterateOverFields(field, componentMapper, validatorTypes, actionTypes, schemaValidatorMapper);
    }

    if (![_component_types__WEBPACK_IMPORTED_MODULE_2__["default"].WIZARD, _component_types__WEBPACK_IMPORTED_MODULE_2__["default"].TABS].includes(parent.component)) {
      if (parent.component !== _component_types__WEBPACK_IMPORTED_MODULE_2__["default"].WIZARD && !field.hasOwnProperty('component')) {
        throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("Each fields item must have \"component\" property!");
      }

      if (!componentBlackList.includes(field.component) && !componentMapper.hasOwnProperty(field.component)) {
        throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("\n          Component of type \"".concat(field.component, "\" is not present in componentMapper.\n          Please make sure \"").concat(field.component, " is included in your componentMapper.\"\n          componentMapper has these values: [").concat(Object.keys(componentMapper), "]\n        "));
      }
      /**
       * Investiage
       */
      //if (!componentBlackList.includes(field.component) && !isValidComponent(componentMapper[field.component])) {
      //  throw new DefaultSchemaError(`FormComponent "${field.component}" from componentMapper is not a valid React component!`);
      //}

    }

    if (!field.hasOwnProperty('name') && parent.component !== 'field-array') {
      throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("Each fields item must have \"name\" property! Name is used as a unique identifier of form fields.");
    }

    if (field.hasOwnProperty('condition')) {
      checkCondition(field.condition, field.name, 'root');
    }

    if (field.hasOwnProperty('validate')) {
      checkValidators(field.validate, field.name, validatorTypes, schemaValidatorMapper.validators);
    }

    if (field.hasOwnProperty('dataType')) {
      checkDataType(field.dataType, field.name);
    }

    if (field.hasOwnProperty('fields')) {
      iterateOverFields(field.fields, componentMapper, validatorTypes, actionTypes, schemaValidatorMapper, field);
    }

    if (field.hasOwnProperty('actions')) {
      checkActions(field.actions, field.name, actionTypes, schemaValidatorMapper.actions);
    }

    if (schemaValidatorMapper.components && schemaValidatorMapper.components.hasOwnProperty(field.component)) {
      schemaValidatorMapper.components[field.component](field);
    }
  });
};

var defaultSchemaValidator = function defaultSchemaValidator(schema, componentMapper) {
  var validatorTypes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var actionTypes = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
  var schemaValidatorMapper = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

  if (Array.isArray(schema) || (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(schema) !== 'object') {
    throw new _schema_errors__WEBPACK_IMPORTED_MODULE_1__["default"]("Form Schema must be an object, received ".concat(Array.isArray(schema) ? 'array' : (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(schema), "!"));
  }

  checkFieldsArray(schema, 'schema');
  iterateOverFields(schema.fields, componentMapper, validatorTypes, actionTypes, schemaValidatorMapper);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (defaultSchemaValidator);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/index.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/index.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _default_schema_validator__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _default_schema_validator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./default-schema-validator */ "./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/default-schema-validator.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/field-array.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/field-array.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_final_form_arrays__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-final-form-arrays */ "./node_modules/react-final-form-arrays/dist/react-final-form-arrays.es.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react_final_form_arrays__WEBPACK_IMPORTED_MODULE_0__.FieldArray);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _field_array__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _field_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field-array */ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/field-array.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/field-provider.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/field-provider.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _use_field_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");


var _excluded = ["Component", "render"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }





var FieldProvider = function FieldProvider(_ref) {
  var Component = _ref.Component,
      render = _ref.render,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  var fieldProviderProps = (0,_use_field_api__WEBPACK_IMPORTED_MODULE_3__["default"])(props);

  if (Component) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement(Component, fieldProviderProps);
  }

  if (render) {
    return render(_objectSpread({}, fieldProviderProps));
  }

  throw new Error('Field provider is missing either Component or render prop.');
};

FieldProvider.propTypes = {
  Component: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)]),
  render: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FieldProvider);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/index.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _field_provider__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _field_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field-provider */ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/field-provider.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/form-error.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/form-error.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var final_form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! final-form */ "./node_modules/final-form/dist/final-form.es.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (final_form__WEBPACK_IMPORTED_MODULE_0__.FORM_ERROR);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/index.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _form_error__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-error */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/form-error.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/form-renderer.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/form-renderer.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var final_form_arrays__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! final-form-arrays */ "./node_modules/final-form-arrays/dist/final-form-arrays.es.js");
/* harmony import */ var final_form_focus__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! final-form-focus */ "./node_modules/final-form-focus/dist/final-form-focus.es.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _default_schema_validator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../default-schema-validator */ "./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/index.js");
/* harmony import */ var _validator_mapper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../validator-mapper */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/index.js");
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../form */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form/index.js");
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js");
/* harmony import */ var _render_form__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./render-form */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/render-form.js");
/* harmony import */ var _schema_error_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./schema-error-component */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/schema-error-component.js");






var _excluded = ["actionMapper", "children", "clearedValue", "clearOnUnmount", "componentMapper", "decorators", "FormTemplate", "FormTemplateProps", "mutators", "onCancel", "onError", "onReset", "onSubmit", "schema", "schemaValidatorMapper", "subscription", "validatorMapper"],
    _excluded2 = ["reset", "mutators", "getState", "submit"];

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(key) === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }












var isFunc = function isFunc(fn) {
  return typeof fn === 'function';
};

var renderChildren = function renderChildren(children, props) {
  if (isFunc(children)) {
    return children(props);
  }

  var childElement = children;

  if (Array.isArray(children)) {
    /**
     * Only permit one child element
     */
    if (children.length !== 1) {
      throw new Error('FormRenderer expects only one child element!');
    }

    childElement = children[0];
  }

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(childElement) === 'object') {
    /**
     * Clone react element, pass form fields and schema as props, but override them with child props if present
     */
    return /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_8__.cloneElement)(children, _objectSpread(_objectSpread({}, props), childElement.props));
  }

  throw new Error("Invalid children prop! Expected one of [null, Function, object], got ".concat((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_5__["default"])(children)));
};

var FormRenderer = function FormRenderer(_ref) {
  var actionMapper = _ref.actionMapper,
      children = _ref.children,
      clearedValue = _ref.clearedValue,
      clearOnUnmount = _ref.clearOnUnmount,
      componentMapper = _ref.componentMapper,
      decorators = _ref.decorators,
      FormTemplate = _ref.FormTemplate,
      FormTemplateProps = _ref.FormTemplateProps,
      mutators = _ref.mutators,
      onCancel = _ref.onCancel,
      onError = _ref.onError,
      onReset = _ref.onReset,
      onSubmit = _ref.onSubmit,
      schema = _ref.schema,
      schemaValidatorMapper = _ref.schemaValidatorMapper,
      subscription = _ref.subscription,
      validatorMapper = _ref.validatorMapper,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref, _excluded);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)([]),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_useState, 2),
      fileInputs = _useState2[0],
      setFileInputs = _useState2[1];

  var formFields = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(function () {
    return (0,_render_form__WEBPACK_IMPORTED_MODULE_13__["default"])(schema.fields);
  }, [schema]);
  var registeredFields = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)({});
  var focusDecorator = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)((0,final_form_focus__WEBPACK_IMPORTED_MODULE_7__["default"])());
  var validatorMapperMerged = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(function () {
    return _objectSpread(_objectSpread({}, _validator_mapper__WEBPACK_IMPORTED_MODULE_10__["default"]), validatorMapper);
  }, [validatorMapper]);
  var mutatorsMerged = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(function () {
    return _objectSpread(_objectSpread({}, final_form_arrays__WEBPACK_IMPORTED_MODULE_6__["default"]), mutators);
  }, [mutators]);
  var decoratorsMerged = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(function () {
    return [focusDecorator.current].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(Array.isArray(decorators) ? decorators : []));
  }, [decorators]);
  var handleSubmitCallback = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (values, formApi) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    return !isFunc(onSubmit) ? undefined : onSubmit.apply(void 0, [values, _objectSpread(_objectSpread({}, formApi), {}, {
      fileInputs: fileInputs
    })].concat(args));
  }, [onSubmit, fileInputs]);
  var handleCancelCallback = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (getState) {
    return function () {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return onCancel.apply(void 0, [getState().values].concat(args));
    };
  }, [onCancel]);
  var handleResetCallback = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (reset) {
    return function () {
      reset();
      return !isFunc(onReset) ? void 0 : onReset.apply(void 0, arguments);
    };
  }, [onReset]);
  var handleErrorCallback = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function () {
    var _console;

    // eslint-disable-next-line no-console
    (_console = console).error.apply(_console, arguments);

    return !isFunc(onError) ? void 0 : onError.apply(void 0, arguments);
  }, [onError]);
  var registerInputFile = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (name) {
    setFileInputs(function (prevFiles) {
      return [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(prevFiles), [name]);
    });
  }, []);
  var unRegisterInputFile = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (name) {
    setFileInputs(function (prevFiles) {
      return (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(prevFiles.splice(prevFiles.indexOf(name)));
    });
  }, []);
  var setRegisteredFields = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (fn) {
    return registeredFields.current = fn(_objectSpread({}, registeredFields.current));
  }, []);
  var internalRegisterField = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (name) {
    setRegisteredFields(function (prev) {
      return prev[name] ? _objectSpread(_objectSpread({}, prev), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, name, prev[name] + 1)) : _objectSpread(_objectSpread({}, prev), {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, name, 1));
    });
  }, []);
  var internalUnRegisterField = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function (name) {
    setRegisteredFields(function (_ref2) {
      var currentField = _ref2[name],
          prev = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref2, [name].map(_toPropertyKey));

      return currentField && currentField > 1 ? _objectSpread((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, name, currentField - 1), prev) : prev;
    });
  }, []);
  var internalGetRegisteredFields = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(function () {
    var fields = registeredFields.current;
    return Object.entries(fields).reduce(function (acc, _ref3) {
      var _ref4 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref3, 2),
          name = _ref4[0],
          value = _ref4[1];

      return value > 0 ? [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__["default"])(acc), [name]) : acc;
    }, []);
  }, []);

  try {
    var validatorTypes = Object.keys(validatorMapperMerged);
    var actionTypes = actionMapper ? Object.keys(actionMapper) : [];
    (0,_default_schema_validator__WEBPACK_IMPORTED_MODULE_9__["default"])(schema, componentMapper, validatorTypes, actionTypes, schemaValidatorMapper);
  } catch (error) {
    handleErrorCallback('schema-error', error);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8__.createElement(_schema_error_component__WEBPACK_IMPORTED_MODULE_14__["default"], {
      name: error.name,
      message: error.message
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8__.createElement(_form__WEBPACK_IMPORTED_MODULE_11__["default"], (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
    onSubmit: handleSubmitCallback,
    mutators: mutatorsMerged,
    decorators: decoratorsMerged,
    subscription: _objectSpread({
      pristine: true,
      submitting: true,
      valid: true
    }, subscription),
    render: function render(_ref5) {
      var handleSubmit = _ref5.handleSubmit,
          pristine = _ref5.pristine,
          valid = _ref5.valid,
          _ref5$form = _ref5.form,
          reset = _ref5$form.reset,
          mutators = _ref5$form.mutators,
          getState = _ref5$form.getState,
          submit = _ref5$form.submit,
          form = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_3__["default"])(_ref5$form, _excluded2);

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8__.createElement(_renderer_context__WEBPACK_IMPORTED_MODULE_12__["default"].Provider, {
        value: {
          componentMapper: componentMapper,
          validatorMapper: validatorMapperMerged,
          actionMapper: actionMapper,
          formOptions: _objectSpread(_objectSpread(_objectSpread({
            registerInputFile: registerInputFile,
            unRegisterInputFile: unRegisterInputFile,
            pristine: pristine,
            onSubmit: onSubmit,
            onCancel: isFunc(onCancel) ? handleCancelCallback(getState) : undefined,
            onReset: handleResetCallback(reset),
            onError: handleErrorCallback,
            getState: getState,
            valid: valid,
            clearedValue: clearedValue,
            submit: submit,
            handleSubmit: handleSubmit,
            reset: reset,
            clearOnUnmount: clearOnUnmount,
            renderForm: _render_form__WEBPACK_IMPORTED_MODULE_13__["default"],
            internalRegisterField: internalRegisterField,
            internalUnRegisterField: internalUnRegisterField
          }, mutators), form), {}, {
            ffGetRegisteredFields: form.getRegisteredFields,
            getRegisteredFields: internalGetRegisteredFields,
            initialValues: props.initialValues,
            schema: schema
          })
        }
      }, FormTemplate && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8__.createElement(FormTemplate, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({
        formFields: formFields,
        schema: schema
      }, FormTemplateProps)), children && renderChildren(children, {
        formFields: formFields,
        schema: schema
      }));
    }
  }, props));
};

FormRenderer.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_15___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_15___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().element)]),
  onSubmit: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func),
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func),
  onReset: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func),
  onError: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func),
  schema: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().object.isRequired),
  clearOnUnmount: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool),
  subscription: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool))),
  clearedValue: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().any),
  componentMapper: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), prop_types__WEBPACK_IMPORTED_MODULE_15___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_15___default().node), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().elementType)]))).isRequired,
  FormTemplate: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().elementType),
  FormTemplateProps: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().object),
  validatorMapper: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func))),
  actionMapper: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func))),
  schemaValidatorMapper: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape({
    components: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func))),
    validators: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func))),
    actions: prop_types__WEBPACK_IMPORTED_MODULE_15___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func)))
  }),
  initialValues: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().object),
  decorators: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().array),
  mutators: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().object)
};
FormRenderer.defaultProps = {
  initialValues: {},
  clearOnUnmount: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormRenderer);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _form_renderer__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form_renderer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-renderer */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/form-renderer.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/render-form.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/render-form.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var lodash_setWith__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/setWith */ "./node_modules/lodash/setWith.js");
/* harmony import */ var lodash_setWith__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_setWith__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/cloneDeep */ "./node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_final_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-final-form */ "./node_modules/react-final-form/dist/react-final-form.es.js");
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js");
/* harmony import */ var _condition__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/condition/index.js");
/* harmony import */ var _get_condition_triggers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../get-condition-triggers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/index.js");
/* harmony import */ var _prepare_component_props__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../prepare-component-props */ "./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/index.js");




var _excluded = ["component", "condition", "hideField"];










var FormFieldHideWrapper = function FormFieldHideWrapper(_ref) {
  var hideField = _ref.hideField,
      children = _ref.children;
  return hideField ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement("div", {
    hidden: true
  }, children) : children;
};

FormFieldHideWrapper.propTypes = {
  hideField: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  children: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().node), prop_types__WEBPACK_IMPORTED_MODULE_12___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_12___default().node))]).isRequired
};
FormFieldHideWrapper.defaultProps = {
  hideField: false
};

var ConditionTriggerWrapper = function ConditionTriggerWrapper(_ref2) {
  var condition = _ref2.condition,
      values = _ref2.values,
      children = _ref2.children,
      field = _ref2.field;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(_condition__WEBPACK_IMPORTED_MODULE_9__["default"], {
    condition: condition,
    values: values,
    field: field
  }, children);
};

ConditionTriggerWrapper.propTypes = {
  condition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node.isRequired),
  field: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object),
  values: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object.isRequired)
};

var ConditionTriggerDetector = function ConditionTriggerDetector(_ref3) {
  var _ref3$values = _ref3.values,
      values = _ref3$values === void 0 ? {} : _ref3$values,
      _ref3$triggers = _ref3.triggers,
      triggers = _ref3$triggers === void 0 ? [] : _ref3$triggers,
      children = _ref3.children,
      condition = _ref3.condition,
      field = _ref3.field;

  var internalTriggers = (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(triggers);

  if (internalTriggers.length === 0) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(ConditionTriggerWrapper, {
      condition: condition,
      values: values,
      field: field
    }, children);
  }

  var name = internalTriggers.shift();
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(react_final_form__WEBPACK_IMPORTED_MODULE_7__.Field, {
    name: name,
    subscription: {
      value: true
    }
  }, function (_ref4) {
    var value = _ref4.input.value;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(ConditionTriggerDetector, {
      triggers: (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__["default"])(internalTriggers),
      values: lodash_setWith__WEBPACK_IMPORTED_MODULE_5___default()(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_6___default()(values), name, value, Object),
      condition: condition,
      field: field
    }, children);
  });
};

ConditionTriggerDetector.propTypes = {
  values: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object),
  triggers: prop_types__WEBPACK_IMPORTED_MODULE_12___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_12___default().string)),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  condition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array)]),
  field: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object.isRequired)
};

var FormConditionWrapper = function FormConditionWrapper(_ref5) {
  var condition = _ref5.condition,
      children = _ref5.children,
      field = _ref5.field;

  if (condition) {
    var triggers = (0,_get_condition_triggers__WEBPACK_IMPORTED_MODULE_10__["default"])(condition, field);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(ConditionTriggerDetector, {
      triggers: triggers,
      condition: condition,
      field: field
    }, children);
  }

  return children;
};

FormConditionWrapper.propTypes = {
  condition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node.isRequired),
  field: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object)
};

var SingleField = function SingleField(_ref6) {
  var component = _ref6.component,
      condition = _ref6.condition,
      hideField = _ref6.hideField,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref6, _excluded);

  var _useContext = (0,react__WEBPACK_IMPORTED_MODULE_4__.useContext)(_renderer_context__WEBPACK_IMPORTED_MODULE_8__["default"]),
      actionMapper = _useContext.actionMapper,
      componentMapper = _useContext.componentMapper;

  var _prepareComponentProp = (0,_prepare_component_props__WEBPACK_IMPORTED_MODULE_11__["default"])({
    component: component,
    rest: rest,
    componentMapper: componentMapper,
    actionMapper: actionMapper
  }),
      componentProps = _prepareComponentProp.componentProps,
      Component = _prepareComponentProp.Component,
      overrideProps = _prepareComponentProp.overrideProps,
      mergedResolveProps = _prepareComponentProp.mergedResolveProps;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(FormConditionWrapper, {
    condition: condition,
    field: componentProps
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(FormFieldHideWrapper, {
    hideField: hideField
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(Component, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({}, componentProps, overrideProps, mergedResolveProps && {
    resolveProps: mergedResolveProps
  }))));
};

SingleField.propTypes = {
  component: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string.isRequired),
  condition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().array)]),
  hideField: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().bool),
  dataType: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  validate: prop_types__WEBPACK_IMPORTED_MODULE_12___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().func), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().object)])),
  initialValue: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().any),
  actions: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func))),
  resolveProps: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func)
};

var renderForm = function renderForm(fields) {
  return fields.map(function (field) {
    return Array.isArray(field) ? renderForm(field) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(SingleField, (0,_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: field.name
    }, field));
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderForm);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/schema-error-component.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/schema-error-component.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);



var SchemaErrorComponent = function SchemaErrorComponent(_ref) {
  var name = _ref.name,
      message = _ref.message;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    style: {
      padding: 5,
      border: '1px solid #bbb',
      borderCollapse: 'collapse',
      borderRadius: 2
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h1", {
    style: {
      fontSize: 24,
      marginBottom: 5
    }
  }, "Form could not be rendered, because of invalid form schema."), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", {
    style: {
      fontSize: 20,
      marginBottom: 5
    }
  }, name, ":"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", {
    style: {
      marginBottom: 5
    }
  }, message), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "If you don't know what this error means, please contact site administrator."));
};

SchemaErrorComponent.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaErrorComponent);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/form-spy.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/form-spy.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_final_form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-final-form */ "./node_modules/react-final-form/dist/react-final-form.es.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react_final_form__WEBPACK_IMPORTED_MODULE_0__.FormSpy);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _form_spy__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form_spy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form-spy */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/form-spy.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form/form.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form/form.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_final_form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-final-form */ "./node_modules/react-final-form/dist/react-final-form.es.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react_final_form__WEBPACK_IMPORTED_MODULE_0__.Form);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/form/index.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/form/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form/form.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/get-condition-triggers.js":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/get-condition-triggers.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");



var _excluded = ["when"];

var mergeFunctionTrigger = function mergeFunctionTrigger(fn, field) {
  var internalTriggers = [];
  var internalWhen = fn(field);

  if (Array.isArray(internalWhen)) {
    internalTriggers = (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(internalWhen);
  } else {
    internalTriggers.push(internalWhen);
  }

  return internalTriggers;
};

var getConditionTriggers = function getConditionTriggers(condition, field) {
  var triggers = [];

  if (Array.isArray(condition)) {
    return condition.reduce(function (acc, item) {
      return [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(acc), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(getConditionTriggers(item, field)));
    }, []);
  }

  var when = condition.when,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(condition, _excluded);

  var nestedKeys = ['and', 'or', 'sequence'];

  if (typeof when === 'string') {
    triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), [when]);
  }

  if (typeof when === 'function') {
    triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(mergeFunctionTrigger(when, field)));
  }

  if (Array.isArray(when)) {
    when.forEach(function (item) {
      if (typeof item === 'string') {
        triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), [item]);
      }

      if (typeof item === 'function') {
        triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(mergeFunctionTrigger(item, field)));
      }
    });
  }

  nestedKeys.forEach(function (key) {
    if (typeof rest[key] !== 'undefined') {
      rest[key].forEach(function (item) {
        triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(getConditionTriggers(item, field)));
      });
    }
  });

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(condition.not) === 'object') {
    triggers = [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(triggers), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_2__["default"])(getConditionTriggers(condition.not, field)));
  }

  return Array.from(new Set(triggers));
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getConditionTriggers);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/index.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/index.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _get_condition_triggers__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _get_condition_triggers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./get-condition-triggers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/get-condition-triggers/get-condition-triggers.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FieldArray": () => (/* reexport safe */ _field_array__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "FieldProvider": () => (/* reexport safe */ _field_provider__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "Form": () => (/* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "FormError": () => (/* reexport safe */ _form_error__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "FormRenderer": () => (/* reexport safe */ _form_renderer__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "FormSpy": () => (/* reexport safe */ _form_spy__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "RendererContext": () => (/* reexport safe */ _renderer_context__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "componentTypes": () => (/* reexport safe */ _component_types__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "composeValidators": () => (/* reexport safe */ _compose_validators__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "condition": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "dataTypes": () => (/* reexport safe */ _data_types__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "defaultSchemaValidator": () => (/* reexport safe */ _default_schema_validator__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "parseCondition": () => (/* reexport safe */ _parse_condition__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "schemaErrors": () => (/* reexport safe */ _schema_errors__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "useFieldApi": () => (/* reexport safe */ _use_field_api__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   "useFormApi": () => (/* reexport safe */ _use_form_api__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "validatorMapper": () => (/* reexport safe */ _validator_mapper__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   "validatorTypes": () => (/* reexport safe */ _validator_types__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   "validators": () => (/* reexport safe */ _validators__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   "wizardContext": () => (/* reexport safe */ _wizard_context__WEBPACK_IMPORTED_MODULE_19__["default"])
/* harmony export */ });
/* harmony import */ var _component_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js");
/* harmony import */ var _compose_validators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./compose-validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/index.js");
/* harmony import */ var _condition__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/condition/index.js");
/* harmony import */ var _data_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./data-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/index.js");
/* harmony import */ var _default_schema_validator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./default-schema-validator */ "./node_modules/@data-driven-forms/react-form-renderer/esm/default-schema-validator/index.js");
/* harmony import */ var _field_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./field-array */ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-array/index.js");
/* harmony import */ var _field_provider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./field-provider */ "./node_modules/@data-driven-forms/react-form-renderer/esm/field-provider/index.js");
/* harmony import */ var _form_renderer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./form-renderer */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-renderer/index.js");
/* harmony import */ var _form_spy__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./form-spy */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-spy/index.js");
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./form */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form/index.js");
/* harmony import */ var _form_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./form-error */ "./node_modules/@data-driven-forms/react-form-renderer/esm/form-error/index.js");
/* harmony import */ var _parse_condition__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./parse-condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/index.js");
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js");
/* harmony import */ var _schema_errors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./schema-errors */ "./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/index.js");
/* harmony import */ var _use_field_api__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js");
/* harmony import */ var _use_form_api__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js");
/* harmony import */ var _validator_mapper__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./validator-mapper */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/index.js");
/* harmony import */ var _validator_types__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./validator-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/index.js");
/* harmony import */ var _validators__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/index.js");
/* harmony import */ var _wizard_context__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./wizard-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/index.js");





















/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/index.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _parse_condition__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _parse_condition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse-condition */ "./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/parse-condition.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/parse-condition.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/parse-condition/parse-condition.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "parseCondition": () => (/* binding */ parseCondition)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isEmpty */ "./node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_3__);



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }




var isEmptyValue = function isEmptyValue(value) {
  return typeof value === 'number' || value === true ? false : lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default()(value);
};

var fieldCondition = function fieldCondition(value, config) {
  if (config.isNotEmpty) {
    return !isEmptyValue(value);
  }

  if (config.isEmpty) {
    return isEmptyValue(value);
  }

  if (config.pattern) {
    var regExpPattern = RegExp(config.pattern, config.flags);
    return config.notMatch ? !regExpPattern.test(value) : regExpPattern.test(value);
  }

  if (typeof config.is === 'function') {
    return config.is(value, config);
  }

  if (Object.prototype.hasOwnProperty.call(config, 'greaterThan')) {
    return value > config.greaterThan;
  }

  if (Object.prototype.hasOwnProperty.call(config, 'greaterThanOrEqualTo')) {
    return value >= config.greaterThanOrEqualTo;
  }

  if (Object.prototype.hasOwnProperty.call(config, 'lessThan')) {
    return value < config.lessThan;
  }

  if (Object.prototype.hasOwnProperty.call(config, 'lessThanOrEqualTo')) {
    return value <= config.lessThanOrEqualTo;
  }

  var isMatched = Array.isArray(config.is) ? !!config.is.includes(value) : value === config.is;
  return config.notMatch ? !isMatched : isMatched;
};

var parseCondition = function parseCondition(condition, values, field) {
  var positiveResult = _objectSpread(_objectSpread({
    visible: true
  }, condition.then), {}, {
    result: true
  });

  var negativeResult = _objectSpread(_objectSpread({
    visible: false
  }, condition["else"]), {}, {
    result: false
  });

  if (Array.isArray(condition)) {
    return !condition.map(function (condition) {
      return parseCondition(condition, values, field);
    }).some(function (_ref) {
      var result = _ref.result;
      return result === false;
    }) ? positiveResult : negativeResult;
  }

  if (condition.and) {
    return !condition.and.map(function (condition) {
      return parseCondition(condition, values, field);
    }).some(function (_ref2) {
      var result = _ref2.result;
      return result === false;
    }) ? positiveResult : negativeResult;
  }

  if (condition.sequence) {
    return condition.sequence.reduce(function (acc, curr) {
      var result = parseCondition(curr, values);
      return {
        sets: [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(acc.sets), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(result.set ? [result.set] : [])),
        visible: acc.visible || result.visible,
        result: acc.result || result.result
      };
    }, _objectSpread(_objectSpread({}, negativeResult), {}, {
      sets: []
    }));
  }

  if (condition.or) {
    return condition.or.map(function (condition) {
      return parseCondition(condition, values, field);
    }).some(function (_ref3) {
      var result = _ref3.result;
      return result === true;
    }) ? positiveResult : negativeResult;
  }

  if (condition.not) {
    return !parseCondition(condition.not, values).result ? positiveResult : negativeResult;
  }

  var finalWhen = typeof condition.when === 'function' ? condition.when(field) : condition.when;

  if (typeof finalWhen === 'string') {
    return fieldCondition(lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(values, finalWhen), condition) ? positiveResult : negativeResult;
  }

  if (Array.isArray(finalWhen)) {
    return finalWhen.map(function (fieldName) {
      return fieldCondition(lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(values, typeof fieldName === 'function' ? fieldName(field) : fieldName), condition);
    }).find(function (condition) {
      return !!condition;
    }) ? positiveResult : negativeResult;
  }

  return negativeResult;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parseCondition);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/index.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/index.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _prepare_component_props__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _prepare_component_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./prepare-component-props */ "./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/prepare-component-props.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/prepare-component-props.js":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/prepare-component-props/prepare-component-props.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/toArray */ "./node_modules/@babel/runtime/helpers/esm/toArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");





var _excluded = ["component"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_4__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

var prepareComponentProps = function prepareComponentProps(_ref) {
  var component = _ref.component,
      rest = _ref.rest,
      componentMapper = _ref.componentMapper,
      actionMapper = _ref.actionMapper;

  var componentProps = _objectSpread({
    component: component
  }, rest);

  var componentBinding = componentMapper[component];
  var Component;

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_3__["default"])(componentBinding) === 'object' && Object.prototype.hasOwnProperty.call(componentBinding, 'component')) {
    var _component = componentBinding.component,
        mapperProps = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(componentBinding, _excluded);

    Component = _component;
    componentProps = _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, mapperProps), componentProps), mapperProps.actions && rest.actions ? {
      actions: _objectSpread(_objectSpread({}, mapperProps.actions), rest.actions)
    } : {}), mapperProps.resolveProps && rest.resolveProps ? {
      resolveProps: function resolveProps() {
        return _objectSpread(_objectSpread({}, mapperProps.resolveProps.apply(mapperProps, arguments)), rest.resolveProps.apply(rest, arguments));
      }
    } : {});
  } else {
    Component = componentBinding;
  }
  /**
   * Map actions to props
   */


  var overrideProps = {};
  var mergedResolveProps; // new object has to be created because of references

  if (componentProps.actions) {
    Object.keys(componentProps.actions).forEach(function (prop) {
      var _componentProps$actio = (0,_babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_1__["default"])(componentProps.actions[prop]),
          action = _componentProps$actio[0],
          args = _componentProps$actio.slice(1);

      overrideProps[prop] = actionMapper[action].apply(actionMapper, (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(args));
    }); // Merge componentProps resolve props and actions resolve props

    if (componentProps.resolveProps && overrideProps.resolveProps) {
      mergedResolveProps = function mergedResolveProps() {
        var _componentProps;

        return _objectSpread(_objectSpread({}, (_componentProps = componentProps).resolveProps.apply(_componentProps, arguments)), overrideProps.resolveProps.apply(overrideProps, arguments));
      };
    } // do not pass actions object to components


    delete componentProps.actions;
  }

  return {
    componentProps: componentProps,
    overrideProps: overrideProps,
    mergedResolveProps: mergedResolveProps,
    Component: Component
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prepareComponentProps);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _renderer_context__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/renderer-context.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/renderer-context.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/renderer-context.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var RendererContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  formOptions: {}
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RendererContext);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _schema_errors__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _schema_errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./schema-errors */ "./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/schema-errors.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/schema-errors.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/schema-errors/schema-errors.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/esm/inherits.js");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js");
/* harmony import */ var _babel_runtime_helpers_wrapNativeSuper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/wrapNativeSuper */ "./node_modules/@babel/runtime/helpers/esm/wrapNativeSuper.js");








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0,_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_5__["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0,_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_5__["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0,_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_4__["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var DefaultSchemaError = /*#__PURE__*/function (_Error) {
  (0,_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_3__["default"])(DefaultSchemaError, _Error);

  var _super = _createSuper(DefaultSchemaError);

  function DefaultSchemaError() {
    var _this;

    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__["default"])(this, DefaultSchemaError);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    _this.name = 'DefaultSchemaError';

    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace((0,_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_2__["default"])(_this), _this.constructor);
    } else {
      _this.stack = new Error(args[0]).stack;
    }

    return _this;
  }

  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__["default"])(DefaultSchemaError);
}( /*#__PURE__*/(0,_babel_runtime_helpers_wrapNativeSuper__WEBPACK_IMPORTED_MODULE_6__["default"])(Error));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefaultSchemaError);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/assign-special-type.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/assign-special-type.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _component_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js");


var assignSpecialType = function assignSpecialType(componentType) {
  return [_component_types__WEBPACK_IMPORTED_MODULE_0__["default"].CHECKBOX, _component_types__WEBPACK_IMPORTED_MODULE_0__["default"].RADIO].includes(componentType) ? componentType : undefined;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (assignSpecialType);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/compose-validators.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/compose-validators.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toArray */ "./node_modules/@babel/runtime/helpers/esm/toArray.js");


var composeValidators = function composeValidators() {
  var validators = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return function (value, allValues, meta) {
    var _validators = (0,_babel_runtime_helpers_toArray__WEBPACK_IMPORTED_MODULE_0__["default"])(validators),
        initialValidator = _validators[0],
        sequenceValidators = _validators.slice(1);

    var resolveValidator = function resolveValidator(error, validator) {
      if (error) {
        return error;
      }

      if (typeof validator !== 'function') {
        return undefined;
      }

      return validator(value, allValues, meta);
    };

    var result = resolveValidator(undefined, initialValidator);

    if (result !== null && result !== void 0 && result.then) {
      return result.then(function () {
        return sequenceValidators.reduce(resolveValidator, undefined);
      })["catch"](function (error) {
        return error;
      });
    }

    return sequenceValidators.reduce(resolveValidator, result);
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (composeValidators);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-initial-value.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-initial-value.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _convert_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./convert-type */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-type.js");



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }



var convertInitialValue = function convertInitialValue(initialValue, dataType) {
  if (initialValue === undefined || !dataType) {
    return initialValue;
  }

  if (Array.isArray(initialValue)) {
    return initialValue.map(function (value) {
      return (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(value) === 'object' ? _objectSpread(_objectSpread({}, value), {}, {
        value: Object.prototype.hasOwnProperty.call(value, 'value') ? (0,_convert_type__WEBPACK_IMPORTED_MODULE_2__["default"])(dataType, value.value) : value
      }) : (0,_convert_type__WEBPACK_IMPORTED_MODULE_2__["default"])(dataType, value);
    });
  }

  return (0,_convert_type__WEBPACK_IMPORTED_MODULE_2__["default"])(dataType, initialValue);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (convertInitialValue);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-type.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-type.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _data_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../data-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/data-types/index.js");

/**
 * Casts string true/false to boolean
 * @param {String} value value
 */

var castToBoolean = function castToBoolean(value) {
  if (typeof value === 'boolean') {
    return value;
  }

  return value === 'true';
};
/**
 * Check if the value can be converted to number
 * @param {Any} value value to be checked
 */


var canBeConvertedToNumber = function canBeConvertedToNumber(value) {
  return !isNaN(Number(value)) && value !== '';
};
/**
 * Check if the value can be converted to float
 * @param {Any} value value to be checked
 */


var canBeConvertedToFloat = function canBeConvertedToFloat(value) {
  if (typeof value == 'string' && value.endsWith('.')) {
    return false;
  }

  return canBeConvertedToNumber(value);
};
/**
 * Changes the value type
 * @param {FieldDataTypes} dataType type for value conversion
 * @param {Any} value value to be converted
 */


var convertType = function convertType(dataType, value) {
  switch (dataType) {
    case _data_types__WEBPACK_IMPORTED_MODULE_0__["default"].INTEGER:
      return canBeConvertedToNumber(value) ? parseInt(value) : value;

    case _data_types__WEBPACK_IMPORTED_MODULE_0__["default"].FLOAT:
      return canBeConvertedToFloat(value) ? parseFloat(value) : value;

    case _data_types__WEBPACK_IMPORTED_MODULE_0__["default"].NUMBER:
      return canBeConvertedToNumber(value) ? Number(value) : value;

    case _data_types__WEBPACK_IMPORTED_MODULE_0__["default"].BOOLEAN:
      return castToBoolean(value);

    default:
      return value;
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (convertType);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/enhanced-on-change.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/enhanced-on-change.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isEmpty */ "./node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _convert_type__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./convert-type */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-type.js");


var _excluded = ["dataType", "onChange", "initial", "clearedValue", "dirty"];


/**
 * Pick a value from event object and returns it
 * @param {Object|Any} event event value returned from form field
 */

var sanitizeValue = function sanitizeValue(event) {
  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(event) === 'object' && event !== null && event.target) {
    if (event.target.type === 'checkbox') {
      return event;
    }

    if (event.target.type === 'file') {
      return {
        inputValue: event.target.value,
        inputFiles: event.target.files
      };
    }

    return event.target.value;
  }

  return event;
};
/**
 * Checks the value and returns undefined if its empty. Converst epmtry strings, arrays and objects.
 * If value is empty its overriden to undefined for further processing.
 * @param {Any} value Any JS variable to be check if is empty
 */


var checkEmpty = function checkEmpty(value) {
  if (typeof value === 'number') {
    return false;
  }

  if (typeof value === 'boolean') {
    return false;
  }

  if (typeof value === 'string' && value.length > 0) {
    return false;
  }

  if (value instanceof Date) {
    return false;
  }

  if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_2___default()(value)) {
    return false;
  }

  return true;
};
/**
 * Casts input value into selected data type
 */


var enhancedOnChange = function enhancedOnChange(_ref, value) {
  var dataType = _ref.dataType,
      onChange = _ref.onChange,
      initial = _ref.initial,
      clearedValue = _ref.clearedValue,
      dirty = _ref.dirty,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref, _excluded);

  var sanitizedValue = sanitizeValue(value);
  var result;

  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(sanitizedValue) == 'object' && sanitizedValue !== null && sanitizedValue.target && sanitizedValue.target.type === 'checkbox') {
    result = sanitizedValue;
  } else {
    result = Array.isArray(sanitizedValue) ? sanitizedValue.map(function (item) {
      return (0,_convert_type__WEBPACK_IMPORTED_MODULE_3__["default"])(dataType, sanitizeValue(item));
    }) : (0,_convert_type__WEBPACK_IMPORTED_MODULE_3__["default"])(dataType, sanitizedValue);
  }

  for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }

  if (checkEmpty(result) && typeof initial !== 'undefined') {
    return onChange.apply(void 0, [clearedValue].concat(args));
  }

  return onChange.apply(void 0, [result].concat(args));
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (enhancedOnChange);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _use_field_api__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _use_field_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./use-field-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/use-field-api.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/use-field-api.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/use-field-api.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_final_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-final-form */ "./node_modules/react-final-form/dist/react-final-form.es.js");
/* harmony import */ var _enhanced_on_change__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./enhanced-on-change */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/enhanced-on-change.js");
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js");
/* harmony import */ var _convert_initial_value__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./convert-initial-value */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/convert-initial-value.js");
/* harmony import */ var _assign_special_type__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./assign-special-type */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/assign-special-type.js");
/* harmony import */ var _component_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../component-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/component-types/index.js");
/* harmony import */ var _validator_helpers__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./validator-helpers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/validator-helpers.js");
/* harmony import */ var _compose_validators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./compose-validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/compose-validators.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! lodash/isEqual */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! lodash/get */ "./node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_16__);





var _excluded = ["value", "blur", "change", "focus"],
    _excluded2 = ["name", "resolveProps", "skipRegistration"],
    _excluded3 = ["initializeOnMount", "component", "render", "validate", "useWarnings", "clearOnUnmount", "dataType", "FieldProps"],
    _excluded4 = ["initialValue", "clearedValue"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_3__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }














var calculateInitialValue = function calculateInitialValue(props) {
  if (Object.prototype.hasOwnProperty.call(props, 'initialValue') && props.dataType) {
    return (0,_convert_initial_value__WEBPACK_IMPORTED_MODULE_10__["default"])(props.initialValue, props.dataType);
  }
};

var calculateArrayValidator = function calculateArrayValidator(props, validate, component, validatorMapper) {
  if ((validate || props.dataType) && _component_types__WEBPACK_IMPORTED_MODULE_12__["default"].FIELD_ARRAY === component) {
    return (0,_validator_helpers__WEBPACK_IMPORTED_MODULE_13__.prepareArrayValidator)((0,_validator_helpers__WEBPACK_IMPORTED_MODULE_13__.getValidate)(validate, props.dataType, validatorMapper));
  }
};

var calculateValidate = function calculateValidate(props, validate, component, validatorMapper, setWarning, useWarnings) {
  if ((validate || props.dataType) && _component_types__WEBPACK_IMPORTED_MODULE_12__["default"].FIELD_ARRAY !== component) {
    var validateFn = (0,_compose_validators__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_validator_helpers__WEBPACK_IMPORTED_MODULE_13__.getValidate)(validate, props.dataType, validatorMapper));

    if (useWarnings) {
      return /*#__PURE__*/(0,_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_4__["default"])( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_5___default().mark(function _callee() {
        var result,
            _args = arguments;
        return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_5___default().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                setWarning(undefined);
                _context.next = 3;
                return validateFn.apply(void 0, _args);

              case 3:
                result = _context.sent;

                if (!((result === null || result === void 0 ? void 0 : result.type) === 'warning')) {
                  _context.next = 7;
                  break;
                }

                setWarning(result.error);
                return _context.abrupt("return");

              case 7:
                return _context.abrupt("return", result);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));
    }

    return validateFn;
  }
};

var init = function init(_ref2) {
  var props = _ref2.props,
      validate = _ref2.validate,
      component = _ref2.component,
      validatorMapper = _ref2.validatorMapper,
      setWarning = _ref2.setWarning,
      useWarnings = _ref2.useWarnings;
  return {
    initialValue: calculateInitialValue(props),
    arrayValidator: calculateArrayValidator(props, validate, component, validatorMapper),
    validate: calculateValidate(props, validate, component, validatorMapper, setWarning, useWarnings),
    type: (0,_assign_special_type__WEBPACK_IMPORTED_MODULE_11__["default"])(component)
  };
};

var reducer = function reducer(state, _ref3) {
  var type = _ref3.type,
      specialType = _ref3.specialType,
      validate = _ref3.validate,
      arrayValidator = _ref3.arrayValidator,
      initialValue = _ref3.initialValue;

  switch (type) {
    case 'setType':
      return _objectSpread(_objectSpread({}, state), {}, {
        type: specialType
      });

    case 'setValidators':
      return _objectSpread(_objectSpread({}, state), {}, {
        validate: validate,
        arrayValidator: arrayValidator
      });

    case 'setInitialValue':
      return _objectSpread(_objectSpread({}, state), {}, {
        initialValue: initialValue
      });

    default:
      return state;
  }
};

var createFieldProps = function createFieldProps(name, formOptions) {
  var _ref4 = formOptions.getFieldState(name) || {},
      value = _ref4.value,
      blur = _ref4.blur,
      change = _ref4.change,
      focus = _ref4.focus,
      meta = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref4, _excluded);

  return {
    meta: meta,
    input: {
      name: name,
      value: value
    }
  };
};

var useFieldApi = function useFieldApi(_ref5) {
  var name = _ref5.name,
      resolveProps = _ref5.resolveProps,
      _ref5$skipRegistratio = _ref5.skipRegistration,
      skipRegistration = _ref5$skipRegistratio === void 0 ? false : _ref5$skipRegistratio,
      props = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(_ref5, _excluded2);

  var _useContext = (0,react__WEBPACK_IMPORTED_MODULE_6__.useContext)(_renderer_context__WEBPACK_IMPORTED_MODULE_9__["default"]),
      validatorMapper = _useContext.validatorMapper,
      formOptions = _useContext.formOptions;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(),
      _useState2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useState, 2),
      warning = _useState2[0],
      setWarning = _useState2[1]; // if there is field initial value, we have to check form initialValues
  // initialValues should have higher priority


  var formInitialValue = Object.prototype.hasOwnProperty.call(props, 'initialValue') ? lodash_get__WEBPACK_IMPORTED_MODULE_16___default()(formOptions.initialValues, name) : undefined;
  var resolvedProps = resolveProps ? resolveProps(props, createFieldProps(name, formOptions), formOptions) || {} : {};

  var combinedProps = _objectSpread(_objectSpread({}, props), resolvedProps);

  var initializeOnMount = combinedProps.initializeOnMount,
      component = combinedProps.component,
      render = combinedProps.render,
      validate = combinedProps.validate,
      useWarnings = combinedProps.useWarnings,
      clearOnUnmount = combinedProps.clearOnUnmount,
      dataType = combinedProps.dataType,
      FieldProps = combinedProps.FieldProps,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(combinedProps, _excluded3);

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_6__.useReducer)(reducer, {
    props: combinedProps,
    validate: validate,
    component: component,
    validatorMapper: validatorMapper,
    setWarning: setWarning,
    useWarnings: useWarnings
  }, init),
      _useReducer2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_useReducer, 2),
      _useReducer2$ = _useReducer2[0],
      type = _useReducer2$.type,
      initialValue = _useReducer2$.initialValue,
      stateValidate = _useReducer2$.validate,
      arrayValidator = _useReducer2$.arrayValidator,
      dispatch = _useReducer2[1];

  var mounted = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);

  var enhancedProps = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({
    dataType: dataType,
    type: combinedProps.type
  }, Object.prototype.hasOwnProperty.call(combinedProps, 'initialValue') ? {
    initialValue: combinedProps.initialValue
  } : {}), Object.prototype.hasOwnProperty.call(combinedProps, 'value') ? {
    value: combinedProps.value
  } : {}), FieldProps), type ? {
    type: type
  } : {}), initialValue ? {
    initialValue: initialValue
  } : {}), stateValidate ? {
    validate: stateValidate
  } : {});

  var field = (0,react_final_form__WEBPACK_IMPORTED_MODULE_7__.useField)(name, _objectSpread(_objectSpread({}, enhancedProps), typeof formInitialValue !== 'undefined' && {
    initialValue: formInitialValue
  }));
  /** Reinitilize type */

  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(function () {
    if (mounted.current) {
      var specialType = (0,_assign_special_type__WEBPACK_IMPORTED_MODULE_11__["default"])(component);

      if (specialType !== type) {
        dispatch({
          type: 'setType',
          specialType: specialType
        });
      }
    }
  }, [component]);
  /** Reinitilize array validator/validate */

  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(function () {
    if (mounted.current) {
      dispatch({
        type: 'setValidators',
        validate: calculateValidate(enhancedProps, validate, component, validatorMapper, setWarning, useWarnings),
        arrayValidator: calculateArrayValidator(enhancedProps, validate, component, validatorMapper)
      });
    }
    /**
     * We have to stringify the validate array in order to preven infinite looping when validate was passed directly to useFieldApi
     * const x = useFieldApu({name: 'foo', validate: [{type: 'bar'}]}) will trigger infinite looping witouth the serialize.
     * Using stringify is acceptable here since the array is usually very small.
     * If we notice performance hit, we can implement custom hook with a deep equal functionality.
     */

  }, [validate ? JSON.stringify(validate) : false, component, dataType]);
  /** Re-convert initialValue when changed */

  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(function () {
    if (mounted.current) {
      var newInitialValue = calculateInitialValue(enhancedProps);

      if (!lodash_isEqual__WEBPACK_IMPORTED_MODULE_15___default()(initialValue, newInitialValue)) {
        dispatch({
          type: 'setInitialValue',
          initialValue: newInitialValue
        });
      }
    }
  }, [enhancedProps.initialValue, dataType]);
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(function () {
    /**
     * Re initialize field when mounted to the Form
     * This affects conditional fields
     */
    if (initializeOnMount) {
      var value = Object.prototype.hasOwnProperty.call(enhancedProps, 'initialValue') ? enhancedProps.initialValue : formOptions.getFieldState(name).initial;
      field.input.onChange(value);
    }
  }, [initializeOnMount, enhancedProps.initialValue, field.meta.initial, dataType]);
  /**
   * Prepare deleted value of field
   */

  var fieldClearedValue = Object.prototype.hasOwnProperty.call(rest, 'clearedValue') ? rest.clearedValue : formOptions.clearedValue;
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(function () {
    if (!skipRegistration) {
      formOptions.internalRegisterField(name);
    }

    mounted.current = true;

    if (field.input.type === 'file') {
      formOptions.registerInputFile(field.input.name);
    }

    return function () {
      mounted.current = false;
      /**
       * Delete the value from form state when field is inmounted
       */

      if ((formOptions.clearOnUnmount || clearOnUnmount) && clearOnUnmount !== false) {
        field.input.onChange(fieldClearedValue);
      }

      if (field.input.type === 'file') {
        formOptions.unRegisterInputFile(field.input.name);
      }

      if (!skipRegistration) {
        formOptions.internalUnRegisterField(name);
      }
    };
  }, // eslint-disable-next-line react-hooks/exhaustive-deps
  []);

  var _initialValue = rest.initialValue,
      clearedValue = rest.clearedValue,
      cleanProps = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_2__["default"])(rest, _excluded4);
  /**
   * construct component props necessary that would live in field provider
   */


  return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, cleanProps), field), arrayValidator && {
    arrayValidator: arrayValidator
  }), useWarnings && {
    meta: _objectSpread(_objectSpread({}, field.meta), {}, {
      warning: warning
    })
  }), {}, {
    input: _objectSpread(_objectSpread({}, field.input), {}, {
      value: field.input.type === 'file' && (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(field.input.value) === 'object' ? field.input.value.inputValue : field.input.value,
      onChange: function onChange() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _enhanced_on_change__WEBPACK_IMPORTED_MODULE_8__["default"].apply(void 0, [_objectSpread(_objectSpread({}, field.meta), {}, {
          dataType: dataType,
          onChange: field.input.onChange,
          clearedValue: fieldClearedValue
        })].concat(args));
      }
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useFieldApi);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/validator-helpers.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-field-api/validator-helpers.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "convertToWarning": () => (/* binding */ convertToWarning),
/* harmony export */   "getValidate": () => (/* binding */ getValidate),
/* harmony export */   "prepareArrayValidator": () => (/* binding */ prepareArrayValidator),
/* harmony export */   "prepareValidator": () => (/* binding */ prepareValidator)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _common_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/helpers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/common/helpers.js");
/* harmony import */ var _validators_validator_functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../validators/validator-functions */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validator-functions.js");
/* harmony import */ var _compose_validators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../compose-validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/compose-validators/index.js");



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }




var convertToWarning = function convertToWarning(validator) {
  return function () {
    return {
      type: 'warning',
      error: validator.apply(void 0, arguments)
    };
  };
};
var prepareValidator = function prepareValidator(validator, mapper) {
  if (typeof validator === 'function') {
    return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(validator);
  }

  if (validator.warning) {
    return convertToWarning(mapper[validator.type](_objectSpread({}, validator)));
  }

  return mapper[validator.type](_objectSpread({}, validator));
};
var getValidate = function getValidate(validate, dataType) {
  var mapper = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return [].concat((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(validate ? validate.map(function (validator) {
    return prepareValidator(validator, mapper);
  }) : []), (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(dataType ? [(0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_3__.dataTypeValidator)(dataType)()] : []));
};
var prepareArrayValidator = function prepareArrayValidator(validation) {
  return function () {
    var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

    if (!Array.isArray(value)) {
      return;
    }

    var arrayValidator = (0,_compose_validators__WEBPACK_IMPORTED_MODULE_4__["default"])(validation);
    var result = arrayValidator(value && value.length > 0 ? value : undefined);

    if (typeof result === 'function') {
      result = result(value);
    }

    return result;
  };
};

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _use_form_api__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _use_form_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./use-form-api */ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/use-form-api.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/use-form-api.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/use-form-api/use-form-api.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _renderer_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../renderer-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/renderer-context/index.js");



var useFormApi = function useFormApi() {
  var _useContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_renderer_context__WEBPACK_IMPORTED_MODULE_1__["default"]),
      formOptions = _useContext.formOptions;

  return formOptions;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useFormApi);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/index.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/index.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _validator_mapper__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _validator_mapper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validator-mapper */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/validator-mapper.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/validator-mapper.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validator-mapper/validator-mapper.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "./node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js");
/* harmony import */ var _validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../validators/validator-functions */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validator-functions.js");
/* harmony import */ var _validators_url_validator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../validators/url-validator */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/url-validator.js");
/* harmony import */ var _validator_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../validator-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/index.js");



var _validatorMapper;

var _excluded = ["threshold"],
    _excluded2 = ["threshold"],
    _excluded3 = ["threshold"],
    _excluded4 = ["threshold"],
    _excluded5 = ["value", "includeThreshold"],
    _excluded6 = ["value", "includeThreshold"],
    _excluded7 = ["message"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }




var validatorMapper = (_validatorMapper = {}, (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].REQUIRED, _validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.required), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].MIN_LENGTH, function (_ref) {
  var threshold = _ref.threshold,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.length)(_objectSpread({
    minimum: threshold
  }, rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].MAX_LENGTH, function (_ref2) {
  var threshold = _ref2.threshold,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref2, _excluded2);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.length)(_objectSpread({
    maximum: threshold
  }, rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].EXACT_LENGTH, function (_ref3) {
  var threshold = _ref3.threshold,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref3, _excluded3);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.length)(_objectSpread({
    is: threshold
  }, rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].MIN_ITEMS, function (_ref4) {
  var threshold = _ref4.threshold,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref4, _excluded4);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.length)(_objectSpread({
    minimum: threshold,
    message: "Must have at least ".concat(threshold, " items.")
  }, rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].PATTERN, _validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.pattern), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].MAX_NUMBER_VALUE, function (_ref5) {
  var value = _ref5.value,
      _ref5$includeThreshol = _ref5.includeThreshold,
      includeThreshold = _ref5$includeThreshol === void 0 ? true : _ref5$includeThreshol,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref5, _excluded5);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.numericality)(_objectSpread((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, includeThreshold ? '<=' : '<', value), rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].MIN_NUMBER_VALUE, function (_ref6) {
  var value = _ref6.value,
      _ref6$includeThreshol = _ref6.includeThreshold,
      includeThreshold = _ref6$includeThreshol === void 0 ? true : _ref6$includeThreshol,
      rest = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref6, _excluded6);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.numericality)(_objectSpread((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, includeThreshold ? '>=' : '>', value), rest));
}), (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(_validatorMapper, _validator_types__WEBPACK_IMPORTED_MODULE_4__["default"].URL, function (_ref7) {
  var message = _ref7.message,
      options = (0,_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref7, _excluded7);

  return (0,_validators_validator_functions__WEBPACK_IMPORTED_MODULE_2__.pattern)({
    pattern: (0,_validators_url_validator__WEBPACK_IMPORTED_MODULE_3__["default"])(options),
    message: message || 'String is not URL.'
  });
}), _validatorMapper);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validatorMapper);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/index.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _validator_types__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _validator_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validator-types */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/validator-types.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/validator-types.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validator-types/validator-types.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var validatorTypes = {
  REQUIRED: 'required',
  MIN_LENGTH: 'min-length',
  MAX_LENGTH: 'max-length',
  EXACT_LENGTH: 'exact-length',
  MIN_ITEMS: 'min-items',
  MIN_NUMBER_VALUE: 'min-number-value',
  MAX_NUMBER_VALUE: 'max-number-value',
  PATTERN: 'pattern',
  URL: 'url'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validatorTypes);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/index.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validators/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _validators__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _validators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validators.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/messages.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validators/messages.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// babel-plugin-react-intl.
var defineMessages = function defineMessages(messageDescriptors) {
  return messageDescriptors;
};

var messages = defineMessages({
  even: {
    id: 'form.errors.even',
    defaultMessage: 'Number must be even'
  },
  equalTo: {
    id: 'form.errors.equalTo',
    defaultMessage: function defaultMessage(equal) {
      return "must be equal to ".concat(equal, ".");
    }
  },
  greaterThan: {
    id: 'form.errors.greaterThan',
    defaultMessage: function defaultMessage(number) {
      return "Value must be greater than ".concat(number, ".");
    }
  },
  greaterThanOrEqualTo: {
    id: 'form.errors.greaterThanOrEqualTo',
    defaultMessage: function defaultMessage(number) {
      return "Value must be greater than or equal to ".concat(number, ".");
    }
  },
  lessThan: {
    id: 'form.errors.lessThan',
    defaultMessage: function defaultMessage(number) {
      return "Value must be less than ".concat(number);
    }
  },
  lessThanOrEqualTo: {
    id: 'form.errors.lessThanOrEqualTo',
    defaultMessage: function defaultMessage(number) {
      return "Value must be less than or equal to ".concat(number);
    }
  },
  mustBeBool: {
    id: 'forms.errors.mustBeBool',
    defaultMessage: 'Value must be boolean.'
  },
  mustBeString: {
    id: 'form.errors.mustBeString',
    defaultMessage: 'Value must be a string'
  },
  notANumber: {
    id: 'form.errors.notANumber',
    defaultMessage: 'Value is not a number'
  },
  odd: {
    id: 'form.errors.odd',
    defaultMessage: 'Number must be odd'
  },
  otherThan: {
    id: 'form.errors.otherThan',
    defaultMessage: function defaultMessage(number) {
      return "Value must be other than ".concat(number, ".");
    }
  },
  pattern: {
    id: 'form.errors.required',
    defaultMessage: function defaultMessage(pattern) {
      return "Value does not match pattern: ".concat(pattern, ".");
    }
  },
  required: {
    id: 'form.errors.required',
    defaultMessage: 'Required'
  },
  tooLong: {
    id: 'form.errors.tooLong',
    defaultMessage: function defaultMessage(count) {
      return "Can have maximum of ".concat(count, " characters.");
    }
  },
  tooShort: {
    id: 'form.errors.tooShort',
    defaultMessage: function defaultMessage(count) {
      return "Must have at least ".concat(count, " characters.");
    }
  },
  wrongLength: {
    id: 'form.errors.wrongLength',
    defaultMessage: function defaultMessage(count) {
      return "Should be ".concat(count, " characters long.");
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (messages);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/url-validator.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validators/url-validator.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../validators */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/index.js");
/* harmony import */ var _common_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/helpers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/common/helpers.js");

 // user:pass BasicAuth (optional)

var BASIC_AUTH = '(?:\\S+(?::\\S*)?@)?'; // IP address dotted notation octets

var IPV4 = '(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)'; // the IPv6 matching part is from here: https://gist.github.com/syzdek/6086792

var IPV6 = '((?:[0-9A-Fa-f]{1,4}))((?::[0-9A-Fa-f]{1,4}))*::((?:[0-9A-Fa-f]{1,4}))((?::[0-9A-Fa-f]{1,4}))*|((?:[0-9A-Fa-f]{1,4}))((?::[0-9A-Fa-f]{1,4})){7}|::1|1::'; // eslint-disable-line max-len
// host & domain names, may end with dot

var HOST = // can be replaced by
// '(?:(?:[a-z0-9\\u00a1-\\uffff][a-z0-9\\u00a1-\\uffff_-]{0,62})?[a-z0-9\\u00a1-\\uffff]\\.)+' +
"(?![-_])(?:[-\\w\\u00a1-\\uffff]{0,63}[^-_]\\.)+" + // TLD identifier name, may end with dot
"(?:[a-z\\u00a1-\\uffff]{2,}\\.?)"; // port number (optional)

var PORT = '(?::\\d{2,5})?'; // resource path (optional)

var PATH = '(?:[/][^\\s?#]*)?';
var SEARCH = '(?:[?][^\\s#]*)?';
var HASH = '(?:[#]\\S*)?';
var DEFAULT_OPTIONS = {
  emptyProtocol: true,
  protocolIdentifier: true,
  basicAuth: true,
  local: true,
  ipv4: true,
  ipv6: true,
  host: true,
  port: true,
  path: true,
  search: true,
  hash: true
};

var url = function url(options) {
  return buildReg(defaultOptions(options), false);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (url);

function defaultOptions(options) {
  options = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_1__.assign)({}, DEFAULT_OPTIONS, options);
  options.protocols = [].concat(options.protocol || options.protocols || _validators__WEBPACK_IMPORTED_MODULE_0__["default"].urlProtocols).join('|');
  return options;
}

function group(option, regPart, capture) {
  return option ? capture ? "(".concat(regPart, ")") : regPart : '';
}

function buildReg(options, capture) {
  return new RegExp('^' + group(true, "(?:(?:(?:".concat(options.protocols, "):)").concat(options.emptyProtocol ? '?' : '', "\\/\\/)").concat(options.protocolIdentifier ? '' : '?'), capture) + group(options.basicAuth, BASIC_AUTH, capture) + "(?:".concat([group(options.ipv4, IPV4, capture), group(options.ipv6, IPV6, capture), group(options.host, HOST, capture), group(options.local, 'localhost', capture)].filter(function (g) {
    return g;
  }).join('|'), ")") + group(options.port, PORT, capture) + group(options.path, PATH, capture) + group(options.search, SEARCH, capture) + group(options.hash, HASH, capture) + '$', 'i');
}

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validator-functions.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validator-functions.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dataTypeValidator": () => (/* binding */ dataTypeValidator),
/* harmony export */   "length": () => (/* binding */ length),
/* harmony export */   "numericality": () => (/* binding */ numericality),
/* harmony export */   "pattern": () => (/* binding */ pattern),
/* harmony export */   "required": () => (/* binding */ required)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _common_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/helpers */ "./node_modules/@data-driven-forms/react-form-renderer/esm/common/helpers.js");



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


var required = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      message = _ref.message;

  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    var cond = typeof value === 'string' ? !value.trim() : value && !isNaN(value.length) ? !value.length : !value;

    if (cond) {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'required').defaultMessage;
    }
  });
});
var length = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      equal = _ref2['='],
      is = _ref2.is,
      max = _ref2.max,
      maximum = _ref2.maximum,
      min = _ref2.min,
      minimum = _ref2.minimum,
      message = _ref2.message;

  equal = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(equal, is);
  min = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(min, minimum);
  max = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(max, maximum);
  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    if (!value) {
      return;
    }

    if (equal !== null && value.length !== equal) {
      var msg = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'wrongLength', {
        count: equal
      }).defaultMessage;
      return typeof msg === 'string' ? msg : msg(equal);
    }

    if (max !== null && value.length > max) {
      var _msg = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'tooLong', {
        count: max
      }).defaultMessage;
      return typeof _msg === 'string' ? _msg : _msg(max);
    }

    if (min !== null && value.length < min) {
      var _msg2 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'tooShort', {
        count: min
      }).defaultMessage;
      return typeof _msg2 === 'string' ? _msg2 : _msg2(min);
    }
  });
});
var pattern = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      pattern = _ref3.pattern,
      message = _ref3.message,
      flags = _ref3.flags;

  var verifiedPattern = typeof pattern === 'string' ? new RegExp(pattern, flags) : pattern;
  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    if (!value) {
      return;
    }

    if (Array.isArray(value)) {
      var error = value.find(function (item) {
        var parsedValue = (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(item) === 'object' && Object.prototype.hasOwnProperty.call(item, 'value') ? item.value.toString() : typeof item === 'string' ? item : item.toString();
        return pattern && !parsedValue.match(verifiedPattern);
      });
      var msg = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'pattern').defaultMessage;
      return error ? typeof msg === 'string' ? msg : msg(pattern) : undefined;
    }

    var parsedValue = typeof value === 'string' ? value : value.toString();

    if (pattern && !parsedValue.match(verifiedPattern)) {
      var _msg3 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'pattern').defaultMessage;
      return typeof _msg3 === 'string' ? _msg3 : _msg3(pattern);
    }
  });
});
var numericality = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      even = _ref4.even,
      odd = _ref4.odd,
      equal = _ref4['='],
      equalTo = _ref4.equalTo,
      diff = _ref4['!='],
      otherThan = _ref4.otherThan,
      greater = _ref4['>'],
      greaterThan = _ref4.greaterThan,
      less = _ref4['<'],
      lessThan = _ref4.lessThan,
      greaterOrEqual = _ref4['>='],
      greaterThanOrEqualTo = _ref4.greaterThanOrEqualTo,
      lessOrEqual = _ref4['<='],
      lessThanOrEqualTo = _ref4.lessThanOrEqualTo,
      message = _ref4.message;

  equal = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(equal, equalTo);
  diff = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(diff, otherThan);
  greater = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(greater, greaterThan);
  greaterOrEqual = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(greaterOrEqual, greaterThanOrEqualTo);
  less = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(less, lessThan);
  lessOrEqual = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.selectNum)(lessOrEqual, lessThanOrEqualTo);
  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    if (!value) {
      return;
    }

    if (!(0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.isNumber)(value)) {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'notANumber').defaultMessage;
    }

    if (equal !== null && +value !== equal) {
      var msg = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'equalTo').defaultMessage;
      return typeof msg === 'string' ? msg : msg(equal);
    }

    if (diff !== null && +value === diff) {
      var _msg4 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'otherThan').defaultMessage;
      return typeof _msg4 === 'string' ? _msg4 : _msg4(diff);
    }

    if (greater !== null && +value <= greater) {
      var _msg5 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'greaterThan').defaultMessage;
      return typeof _msg5 === 'string' ? _msg5 : _msg5(greater);
    }

    if (greaterOrEqual !== null && +value < greaterOrEqual) {
      var _msg6 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'greaterThanOrEqualTo').defaultMessage;
      return typeof _msg6 === 'string' ? _msg6 : _msg6(greaterOrEqual);
    }

    if (less !== null && +value >= less) {
      var _msg7 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'lessThan').defaultMessage;
      return typeof _msg7 === 'string' ? _msg7 : _msg7(less);
    }

    if (lessOrEqual !== null && +value > lessOrEqual) {
      var _msg8 = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'lessThanOrEqualTo').defaultMessage;
      return typeof _msg8 === 'string' ? _msg8 : _msg8(lessOrEqual);
    }

    if (even && (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.trunc)(+value) % 2) {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'even').defaultMessage;
    }

    if (odd && !((0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.trunc)(+value) % 2)) {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'odd').defaultMessage;
    }
  });
});
var stringValidator = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      message = _ref5.message;

  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    if (!value) {
      return;
    }

    if (Array.isArray(value)) {
      var error = value.find(function (item) {
        return typeof item !== 'string';
      });
      return error ? (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'mustBeString').defaultMessage : undefined;
    }

    if (typeof value !== 'string') {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'mustBeString').defaultMessage;
    }
  });
});
var booleanValidator = (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.memoize)(function () {
  var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      message = _ref6.message;

  return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepare)(function (value) {
    if (!value) {
      return;
    }

    if (Array.isArray(value)) {
      var error = value.find(function (item) {
        return typeof item !== 'boolean';
      });
      return error ? (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'mustBeBool').defaultMessage : undefined;
    }

    if (typeof value !== 'boolean') {
      return (0,_common_helpers__WEBPACK_IMPORTED_MODULE_2__.prepareMsg)(message, 'mustBeBool').defaultMessage;
    }
  });
});
var dataTypeValidator = function dataTypeValidator(type) {
  return {
    string: function string(options) {
      return stringValidator(_objectSpread({
        message: 'Field value has to be string'
      }, options));
    },
    integer: function integer(options) {
      return pattern(_objectSpread({
        pattern: /^-?\d*$/,
        message: 'Value must be integer'
      }, options));
    },
    "boolean": function boolean(options) {
      return booleanValidator(_objectSpread({
        message: 'Field value has to be boolean'
      }, options));
    },
    number: function number(options) {
      return pattern(_objectSpread({
        pattern: /^-?\d*[.]{0,1}\d*$/,
        message: 'Values must be number'
      }, options));
    },
    "float": function float(options) {
      return pattern(_objectSpread({
        pattern: /^-?\d*[.]{0,1}\d*$/,
        message: 'Values must be number'
      }, options));
    }
  }[type];
};

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validators.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/validators/validators.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validators_messages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../validators/messages */ "./node_modules/@data-driven-forms/react-form-renderer/esm/validators/messages.js");

var Validators = {
  messages: _validators_messages__WEBPACK_IMPORTED_MODULE_0__["default"],
  urlProtocols: ['http', 'https']
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Validators);

/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/index.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _wizard_context__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _wizard_context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wizard-context */ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/wizard-context.js");


/***/ }),

/***/ "./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/wizard-context.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@data-driven-forms/react-form-renderer/esm/wizard-context/wizard-context.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var WizardContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WizardContext);

/***/ }),

/***/ "./node_modules/@formatjs/ecma402-abstract/lib/utils.js":
/*!**************************************************************!*\
  !*** ./node_modules/@formatjs/ecma402-abstract/lib/utils.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UNICODE_EXTENSION_SEQUENCE_REGEX": () => (/* binding */ UNICODE_EXTENSION_SEQUENCE_REGEX),
/* harmony export */   "defineProperty": () => (/* binding */ defineProperty),
/* harmony export */   "getInternalSlot": () => (/* binding */ getInternalSlot),
/* harmony export */   "getMagnitude": () => (/* binding */ getMagnitude),
/* harmony export */   "getMultiInternalSlots": () => (/* binding */ getMultiInternalSlots),
/* harmony export */   "invariant": () => (/* binding */ invariant),
/* harmony export */   "isLiteralPart": () => (/* binding */ isLiteralPart),
/* harmony export */   "repeat": () => (/* binding */ repeat),
/* harmony export */   "setInternalSlot": () => (/* binding */ setInternalSlot),
/* harmony export */   "setMultiInternalSlots": () => (/* binding */ setMultiInternalSlots)
/* harmony export */ });
/**
 * Cannot do Math.log(x) / Math.log(10) bc if IEEE floating point issue
 * @param x number
 */
function getMagnitude(x) {
    // Cannot count string length via Number.toString because it may use scientific notation
    // for very small or very large numbers.
    return Math.floor(Math.log(x) * Math.LOG10E);
}
function repeat(s, times) {
    if (typeof s.repeat === 'function') {
        return s.repeat(times);
    }
    var arr = new Array(times);
    for (var i = 0; i < arr.length; i++) {
        arr[i] = s;
    }
    return arr.join('');
}
function setInternalSlot(map, pl, field, value) {
    if (!map.get(pl)) {
        map.set(pl, Object.create(null));
    }
    var slots = map.get(pl);
    slots[field] = value;
}
function setMultiInternalSlots(map, pl, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
        var k = _a[_i];
        setInternalSlot(map, pl, k, props[k]);
    }
}
function getInternalSlot(map, pl, field) {
    return getMultiInternalSlots(map, pl, field)[field];
}
function getMultiInternalSlots(map, pl) {
    var fields = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        fields[_i - 2] = arguments[_i];
    }
    var slots = map.get(pl);
    if (!slots) {
        throw new TypeError("".concat(pl, " InternalSlot has not been initialized"));
    }
    return fields.reduce(function (all, f) {
        all[f] = slots[f];
        return all;
    }, Object.create(null));
}
function isLiteralPart(patternPart) {
    return patternPart.type === 'literal';
}
/*
  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
*/
function defineProperty(target, name, _a) {
    var value = _a.value;
    Object.defineProperty(target, name, {
        configurable: true,
        enumerable: false,
        writable: true,
        value: value,
    });
}
var UNICODE_EXTENSION_SEQUENCE_REGEX = /-u(?:-[0-9a-z]{2,8})+/gi;
function invariant(condition, message, Err) {
    if (Err === void 0) { Err = Error; }
    if (!condition) {
        throw new Err(message);
    }
}


/***/ }),

/***/ "./node_modules/@formatjs/fast-memoize/lib/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@formatjs/fast-memoize/lib/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ memoize),
/* harmony export */   "strategies": () => (/* binding */ strategies)
/* harmony export */ });
//
// Main
//
function memoize(fn, options) {
    var cache = options && options.cache ? options.cache : cacheDefault;
    var serializer = options && options.serializer ? options.serializer : serializerDefault;
    var strategy = options && options.strategy ? options.strategy : strategyDefault;
    return strategy(fn, {
        cache: cache,
        serializer: serializer,
    });
}
//
// Strategy
//
function isPrimitive(value) {
    return (value == null || typeof value === 'number' || typeof value === 'boolean'); // || typeof value === "string" 'unsafe' primitive for our needs
}
function monadic(fn, cache, serializer, arg) {
    var cacheKey = isPrimitive(arg) ? arg : serializer(arg);
    var computedValue = cache.get(cacheKey);
    if (typeof computedValue === 'undefined') {
        computedValue = fn.call(this, arg);
        cache.set(cacheKey, computedValue);
    }
    return computedValue;
}
function variadic(fn, cache, serializer) {
    var args = Array.prototype.slice.call(arguments, 3);
    var cacheKey = serializer(args);
    var computedValue = cache.get(cacheKey);
    if (typeof computedValue === 'undefined') {
        computedValue = fn.apply(this, args);
        cache.set(cacheKey, computedValue);
    }
    return computedValue;
}
function assemble(fn, context, strategy, cache, serialize) {
    return strategy.bind(context, fn, cache, serialize);
}
function strategyDefault(fn, options) {
    var strategy = fn.length === 1 ? monadic : variadic;
    return assemble(fn, this, strategy, options.cache.create(), options.serializer);
}
function strategyVariadic(fn, options) {
    return assemble(fn, this, variadic, options.cache.create(), options.serializer);
}
function strategyMonadic(fn, options) {
    return assemble(fn, this, monadic, options.cache.create(), options.serializer);
}
//
// Serializer
//
var serializerDefault = function () {
    return JSON.stringify(arguments);
};
//
// Cache
//
function ObjectWithoutPrototypeCache() {
    this.cache = Object.create(null);
}
ObjectWithoutPrototypeCache.prototype.get = function (key) {
    return this.cache[key];
};
ObjectWithoutPrototypeCache.prototype.set = function (key, value) {
    this.cache[key] = value;
};
var cacheDefault = {
    create: function create() {
        // @ts-ignore
        return new ObjectWithoutPrototypeCache();
    },
};
var strategies = {
    variadic: strategyVariadic,
    monadic: strategyMonadic,
};


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/date-time-pattern-generator.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/date-time-pattern-generator.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getBestPattern": () => (/* binding */ getBestPattern)
/* harmony export */ });
/* harmony import */ var _time_data_generated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./time-data.generated */ "./node_modules/@formatjs/icu-messageformat-parser/lib/time-data.generated.js");

/**
 * Returns the best matching date time pattern if a date time skeleton
 * pattern is provided with a locale. Follows the Unicode specification:
 * https://www.unicode.org/reports/tr35/tr35-dates.html#table-mapping-requested-time-skeletons-to-patterns
 * @param skeleton date time skeleton pattern that possibly includes j, J or C
 * @param locale
 */
function getBestPattern(skeleton, locale) {
    var skeletonCopy = '';
    for (var patternPos = 0; patternPos < skeleton.length; patternPos++) {
        var patternChar = skeleton.charAt(patternPos);
        if (patternChar === 'j') {
            var extraLength = 0;
            while (patternPos + 1 < skeleton.length &&
                skeleton.charAt(patternPos + 1) === patternChar) {
                extraLength++;
                patternPos++;
            }
            var hourLen = 1 + (extraLength & 1);
            var dayPeriodLen = extraLength < 2 ? 1 : 3 + (extraLength >> 1);
            var dayPeriodChar = 'a';
            var hourChar = getDefaultHourSymbolFromLocale(locale);
            if (hourChar == 'H' || hourChar == 'k') {
                dayPeriodLen = 0;
            }
            while (dayPeriodLen-- > 0) {
                skeletonCopy += dayPeriodChar;
            }
            while (hourLen-- > 0) {
                skeletonCopy = hourChar + skeletonCopy;
            }
        }
        else if (patternChar === 'J') {
            skeletonCopy += 'H';
        }
        else {
            skeletonCopy += patternChar;
        }
    }
    return skeletonCopy;
}
/**
 * Maps the [hour cycle type](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/hourCycle)
 * of the given `locale` to the corresponding time pattern.
 * @param locale
 */
function getDefaultHourSymbolFromLocale(locale) {
    var hourCycle = locale.hourCycle;
    if (hourCycle === undefined &&
        // @ts-ignore hourCycle(s) is not identified yet
        locale.hourCycles &&
        // @ts-ignore
        locale.hourCycles.length) {
        // @ts-ignore
        hourCycle = locale.hourCycles[0];
    }
    if (hourCycle) {
        switch (hourCycle) {
            case 'h24':
                return 'k';
            case 'h23':
                return 'H';
            case 'h12':
                return 'h';
            case 'h11':
                return 'K';
            default:
                throw new Error('Invalid hourCycle');
        }
    }
    // TODO: Once hourCycle is fully supported remove the following with data generation
    var languageTag = locale.language;
    var regionTag;
    if (languageTag !== 'root') {
        regionTag = locale.maximize().region;
    }
    var hourCycles = _time_data_generated__WEBPACK_IMPORTED_MODULE_0__.timeData[regionTag || ''] ||
        _time_data_generated__WEBPACK_IMPORTED_MODULE_0__.timeData[languageTag || ''] ||
        _time_data_generated__WEBPACK_IMPORTED_MODULE_0__.timeData["".concat(languageTag, "-001")] ||
        _time_data_generated__WEBPACK_IMPORTED_MODULE_0__.timeData["001"];
    return hourCycles[0];
}


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/error.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/error.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ErrorKind": () => (/* binding */ ErrorKind)
/* harmony export */ });
var ErrorKind;
(function (ErrorKind) {
    /** Argument is unclosed (e.g. `{0`) */
    ErrorKind[ErrorKind["EXPECT_ARGUMENT_CLOSING_BRACE"] = 1] = "EXPECT_ARGUMENT_CLOSING_BRACE";
    /** Argument is empty (e.g. `{}`). */
    ErrorKind[ErrorKind["EMPTY_ARGUMENT"] = 2] = "EMPTY_ARGUMENT";
    /** Argument is malformed (e.g. `{foo!}``) */
    ErrorKind[ErrorKind["MALFORMED_ARGUMENT"] = 3] = "MALFORMED_ARGUMENT";
    /** Expect an argument type (e.g. `{foo,}`) */
    ErrorKind[ErrorKind["EXPECT_ARGUMENT_TYPE"] = 4] = "EXPECT_ARGUMENT_TYPE";
    /** Unsupported argument type (e.g. `{foo,foo}`) */
    ErrorKind[ErrorKind["INVALID_ARGUMENT_TYPE"] = 5] = "INVALID_ARGUMENT_TYPE";
    /** Expect an argument style (e.g. `{foo, number, }`) */
    ErrorKind[ErrorKind["EXPECT_ARGUMENT_STYLE"] = 6] = "EXPECT_ARGUMENT_STYLE";
    /** The number skeleton is invalid. */
    ErrorKind[ErrorKind["INVALID_NUMBER_SKELETON"] = 7] = "INVALID_NUMBER_SKELETON";
    /** The date time skeleton is invalid. */
    ErrorKind[ErrorKind["INVALID_DATE_TIME_SKELETON"] = 8] = "INVALID_DATE_TIME_SKELETON";
    /** Exepct a number skeleton following the `::` (e.g. `{foo, number, ::}`) */
    ErrorKind[ErrorKind["EXPECT_NUMBER_SKELETON"] = 9] = "EXPECT_NUMBER_SKELETON";
    /** Exepct a date time skeleton following the `::` (e.g. `{foo, date, ::}`) */
    ErrorKind[ErrorKind["EXPECT_DATE_TIME_SKELETON"] = 10] = "EXPECT_DATE_TIME_SKELETON";
    /** Unmatched apostrophes in the argument style (e.g. `{foo, number, 'test`) */
    ErrorKind[ErrorKind["UNCLOSED_QUOTE_IN_ARGUMENT_STYLE"] = 11] = "UNCLOSED_QUOTE_IN_ARGUMENT_STYLE";
    /** Missing select argument options (e.g. `{foo, select}`) */
    ErrorKind[ErrorKind["EXPECT_SELECT_ARGUMENT_OPTIONS"] = 12] = "EXPECT_SELECT_ARGUMENT_OPTIONS";
    /** Expecting an offset value in `plural` or `selectordinal` argument (e.g `{foo, plural, offset}`) */
    ErrorKind[ErrorKind["EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE"] = 13] = "EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE";
    /** Offset value in `plural` or `selectordinal` is invalid (e.g. `{foo, plural, offset: x}`) */
    ErrorKind[ErrorKind["INVALID_PLURAL_ARGUMENT_OFFSET_VALUE"] = 14] = "INVALID_PLURAL_ARGUMENT_OFFSET_VALUE";
    /** Expecting a selector in `select` argument (e.g `{foo, select}`) */
    ErrorKind[ErrorKind["EXPECT_SELECT_ARGUMENT_SELECTOR"] = 15] = "EXPECT_SELECT_ARGUMENT_SELECTOR";
    /** Expecting a selector in `plural` or `selectordinal` argument (e.g `{foo, plural}`) */
    ErrorKind[ErrorKind["EXPECT_PLURAL_ARGUMENT_SELECTOR"] = 16] = "EXPECT_PLURAL_ARGUMENT_SELECTOR";
    /** Expecting a message fragment after the `select` selector (e.g. `{foo, select, apple}`) */
    ErrorKind[ErrorKind["EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT"] = 17] = "EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT";
    /**
     * Expecting a message fragment after the `plural` or `selectordinal` selector
     * (e.g. `{foo, plural, one}`)
     */
    ErrorKind[ErrorKind["EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT"] = 18] = "EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT";
    /** Selector in `plural` or `selectordinal` is malformed (e.g. `{foo, plural, =x {#}}`) */
    ErrorKind[ErrorKind["INVALID_PLURAL_ARGUMENT_SELECTOR"] = 19] = "INVALID_PLURAL_ARGUMENT_SELECTOR";
    /**
     * Duplicate selectors in `plural` or `selectordinal` argument.
     * (e.g. {foo, plural, one {#} one {#}})
     */
    ErrorKind[ErrorKind["DUPLICATE_PLURAL_ARGUMENT_SELECTOR"] = 20] = "DUPLICATE_PLURAL_ARGUMENT_SELECTOR";
    /** Duplicate selectors in `select` argument.
     * (e.g. {foo, select, apple {apple} apple {apple}})
     */
    ErrorKind[ErrorKind["DUPLICATE_SELECT_ARGUMENT_SELECTOR"] = 21] = "DUPLICATE_SELECT_ARGUMENT_SELECTOR";
    /** Plural or select argument option must have `other` clause. */
    ErrorKind[ErrorKind["MISSING_OTHER_CLAUSE"] = 22] = "MISSING_OTHER_CLAUSE";
    /** The tag is malformed. (e.g. `<bold!>foo</bold!>) */
    ErrorKind[ErrorKind["INVALID_TAG"] = 23] = "INVALID_TAG";
    /** The tag name is invalid. (e.g. `<123>foo</123>`) */
    ErrorKind[ErrorKind["INVALID_TAG_NAME"] = 25] = "INVALID_TAG_NAME";
    /** The closing tag does not match the opening tag. (e.g. `<bold>foo</italic>`) */
    ErrorKind[ErrorKind["UNMATCHED_CLOSING_TAG"] = 26] = "UNMATCHED_CLOSING_TAG";
    /** The opening tag has unmatched closing tag. (e.g. `<bold>foo`) */
    ErrorKind[ErrorKind["UNCLOSED_TAG"] = 27] = "UNCLOSED_TAG";
})(ErrorKind || (ErrorKind = {}));


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SKELETON_TYPE": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.SKELETON_TYPE),
/* harmony export */   "TYPE": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.TYPE),
/* harmony export */   "_Parser": () => (/* binding */ _Parser),
/* harmony export */   "createLiteralElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.createLiteralElement),
/* harmony export */   "createNumberElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.createNumberElement),
/* harmony export */   "isArgumentElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isArgumentElement),
/* harmony export */   "isDateElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isDateElement),
/* harmony export */   "isDateTimeSkeleton": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isDateTimeSkeleton),
/* harmony export */   "isLiteralElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isLiteralElement),
/* harmony export */   "isNumberElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isNumberElement),
/* harmony export */   "isNumberSkeleton": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isNumberSkeleton),
/* harmony export */   "isPluralElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isPluralElement),
/* harmony export */   "isPoundElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isPoundElement),
/* harmony export */   "isSelectElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isSelectElement),
/* harmony export */   "isTagElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isTagElement),
/* harmony export */   "isTimeElement": () => (/* reexport safe */ _types__WEBPACK_IMPORTED_MODULE_2__.isTimeElement),
/* harmony export */   "parse": () => (/* binding */ parse)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/icu-messageformat-parser/lib/error.js");
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parser */ "./node_modules/@formatjs/icu-messageformat-parser/lib/parser.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./types */ "./node_modules/@formatjs/icu-messageformat-parser/lib/types.js");




function pruneLocation(els) {
    els.forEach(function (el) {
        delete el.location;
        if ((0,_types__WEBPACK_IMPORTED_MODULE_2__.isSelectElement)(el) || (0,_types__WEBPACK_IMPORTED_MODULE_2__.isPluralElement)(el)) {
            for (var k in el.options) {
                delete el.options[k].location;
                pruneLocation(el.options[k].value);
            }
        }
        else if ((0,_types__WEBPACK_IMPORTED_MODULE_2__.isNumberElement)(el) && (0,_types__WEBPACK_IMPORTED_MODULE_2__.isNumberSkeleton)(el.style)) {
            delete el.style.location;
        }
        else if (((0,_types__WEBPACK_IMPORTED_MODULE_2__.isDateElement)(el) || (0,_types__WEBPACK_IMPORTED_MODULE_2__.isTimeElement)(el)) &&
            (0,_types__WEBPACK_IMPORTED_MODULE_2__.isDateTimeSkeleton)(el.style)) {
            delete el.style.location;
        }
        else if ((0,_types__WEBPACK_IMPORTED_MODULE_2__.isTagElement)(el)) {
            pruneLocation(el.children);
        }
    });
}
function parse(message, opts) {
    if (opts === void 0) { opts = {}; }
    opts = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__assign)({ shouldParseSkeletons: true, requiresOtherClause: true }, opts);
    var result = new _parser__WEBPACK_IMPORTED_MODULE_1__.Parser(message, opts).parse();
    if (result.err) {
        var error = SyntaxError(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind[result.err.kind]);
        // @ts-expect-error Assign to error object
        error.location = result.err.location;
        // @ts-expect-error Assign to error object
        error.originalMessage = result.err.message;
        throw error;
    }
    if (!(opts === null || opts === void 0 ? void 0 : opts.captureLocation)) {
        pruneLocation(result.val);
    }
    return result.val;
}

// only for testing
var _Parser = _parser__WEBPACK_IMPORTED_MODULE_1__.Parser;


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/parser.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/parser.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Parser": () => (/* binding */ Parser)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/icu-messageformat-parser/lib/error.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types */ "./node_modules/@formatjs/icu-messageformat-parser/lib/types.js");
/* harmony import */ var _regex_generated__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./regex.generated */ "./node_modules/@formatjs/icu-messageformat-parser/lib/regex.generated.js");
/* harmony import */ var _formatjs_icu_skeleton_parser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @formatjs/icu-skeleton-parser */ "./node_modules/@formatjs/icu-skeleton-parser/lib/index.js");
/* harmony import */ var _date_time_pattern_generator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./date-time-pattern-generator */ "./node_modules/@formatjs/icu-messageformat-parser/lib/date-time-pattern-generator.js");
var _a;






var SPACE_SEPARATOR_START_REGEX = new RegExp("^".concat(_regex_generated__WEBPACK_IMPORTED_MODULE_2__.SPACE_SEPARATOR_REGEX.source, "*"));
var SPACE_SEPARATOR_END_REGEX = new RegExp("".concat(_regex_generated__WEBPACK_IMPORTED_MODULE_2__.SPACE_SEPARATOR_REGEX.source, "*$"));
function createLocation(start, end) {
    return { start: start, end: end };
}
// #region Ponyfills
// Consolidate these variables up top for easier toggling during debugging
var hasNativeStartsWith = !!String.prototype.startsWith;
var hasNativeFromCodePoint = !!String.fromCodePoint;
var hasNativeFromEntries = !!Object.fromEntries;
var hasNativeCodePointAt = !!String.prototype.codePointAt;
var hasTrimStart = !!String.prototype.trimStart;
var hasTrimEnd = !!String.prototype.trimEnd;
var hasNativeIsSafeInteger = !!Number.isSafeInteger;
var isSafeInteger = hasNativeIsSafeInteger
    ? Number.isSafeInteger
    : function (n) {
        return (typeof n === 'number' &&
            isFinite(n) &&
            Math.floor(n) === n &&
            Math.abs(n) <= 0x1fffffffffffff);
    };
// IE11 does not support y and u.
var REGEX_SUPPORTS_U_AND_Y = true;
try {
    var re = RE('([^\\p{White_Space}\\p{Pattern_Syntax}]*)', 'yu');
    /**
     * legacy Edge or Xbox One browser
     * Unicode flag support: supported
     * Pattern_Syntax support: not supported
     * See https://github.com/formatjs/formatjs/issues/2822
     */
    REGEX_SUPPORTS_U_AND_Y = ((_a = re.exec('a')) === null || _a === void 0 ? void 0 : _a[0]) === 'a';
}
catch (_) {
    REGEX_SUPPORTS_U_AND_Y = false;
}
var startsWith = hasNativeStartsWith
    ? // Native
        function startsWith(s, search, position) {
            return s.startsWith(search, position);
        }
    : // For IE11
        function startsWith(s, search, position) {
            return s.slice(position, position + search.length) === search;
        };
var fromCodePoint = hasNativeFromCodePoint
    ? String.fromCodePoint
    : // IE11
        function fromCodePoint() {
            var codePoints = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                codePoints[_i] = arguments[_i];
            }
            var elements = '';
            var length = codePoints.length;
            var i = 0;
            var code;
            while (length > i) {
                code = codePoints[i++];
                if (code > 0x10ffff)
                    throw RangeError(code + ' is not a valid code point');
                elements +=
                    code < 0x10000
                        ? String.fromCharCode(code)
                        : String.fromCharCode(((code -= 0x10000) >> 10) + 0xd800, (code % 0x400) + 0xdc00);
            }
            return elements;
        };
var fromEntries = 
// native
hasNativeFromEntries
    ? Object.fromEntries
    : // Ponyfill
        function fromEntries(entries) {
            var obj = {};
            for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
                var _a = entries_1[_i], k = _a[0], v = _a[1];
                obj[k] = v;
            }
            return obj;
        };
var codePointAt = hasNativeCodePointAt
    ? // Native
        function codePointAt(s, index) {
            return s.codePointAt(index);
        }
    : // IE 11
        function codePointAt(s, index) {
            var size = s.length;
            if (index < 0 || index >= size) {
                return undefined;
            }
            var first = s.charCodeAt(index);
            var second;
            return first < 0xd800 ||
                first > 0xdbff ||
                index + 1 === size ||
                (second = s.charCodeAt(index + 1)) < 0xdc00 ||
                second > 0xdfff
                ? first
                : ((first - 0xd800) << 10) + (second - 0xdc00) + 0x10000;
        };
var trimStart = hasTrimStart
    ? // Native
        function trimStart(s) {
            return s.trimStart();
        }
    : // Ponyfill
        function trimStart(s) {
            return s.replace(SPACE_SEPARATOR_START_REGEX, '');
        };
var trimEnd = hasTrimEnd
    ? // Native
        function trimEnd(s) {
            return s.trimEnd();
        }
    : // Ponyfill
        function trimEnd(s) {
            return s.replace(SPACE_SEPARATOR_END_REGEX, '');
        };
// Prevent minifier to translate new RegExp to literal form that might cause syntax error on IE11.
function RE(s, flag) {
    return new RegExp(s, flag);
}
// #endregion
var matchIdentifierAtIndex;
if (REGEX_SUPPORTS_U_AND_Y) {
    // Native
    var IDENTIFIER_PREFIX_RE_1 = RE('([^\\p{White_Space}\\p{Pattern_Syntax}]*)', 'yu');
    matchIdentifierAtIndex = function matchIdentifierAtIndex(s, index) {
        var _a;
        IDENTIFIER_PREFIX_RE_1.lastIndex = index;
        var match = IDENTIFIER_PREFIX_RE_1.exec(s);
        return (_a = match[1]) !== null && _a !== void 0 ? _a : '';
    };
}
else {
    // IE11
    matchIdentifierAtIndex = function matchIdentifierAtIndex(s, index) {
        var match = [];
        while (true) {
            var c = codePointAt(s, index);
            if (c === undefined || _isWhiteSpace(c) || _isPatternSyntax(c)) {
                break;
            }
            match.push(c);
            index += c >= 0x10000 ? 2 : 1;
        }
        return fromCodePoint.apply(void 0, match);
    };
}
var Parser = /** @class */ (function () {
    function Parser(message, options) {
        if (options === void 0) { options = {}; }
        this.message = message;
        this.position = { offset: 0, line: 1, column: 1 };
        this.ignoreTag = !!options.ignoreTag;
        this.locale = options.locale;
        this.requiresOtherClause = !!options.requiresOtherClause;
        this.shouldParseSkeletons = !!options.shouldParseSkeletons;
    }
    Parser.prototype.parse = function () {
        if (this.offset() !== 0) {
            throw Error('parser can only be used once');
        }
        return this.parseMessage(0, '', false);
    };
    Parser.prototype.parseMessage = function (nestingLevel, parentArgType, expectingCloseTag) {
        var elements = [];
        while (!this.isEOF()) {
            var char = this.char();
            if (char === 123 /* `{` */) {
                var result = this.parseArgument(nestingLevel, expectingCloseTag);
                if (result.err) {
                    return result;
                }
                elements.push(result.val);
            }
            else if (char === 125 /* `}` */ && nestingLevel > 0) {
                break;
            }
            else if (char === 35 /* `#` */ &&
                (parentArgType === 'plural' || parentArgType === 'selectordinal')) {
                var position = this.clonePosition();
                this.bump();
                elements.push({
                    type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.pound,
                    location: createLocation(position, this.clonePosition()),
                });
            }
            else if (char === 60 /* `<` */ &&
                !this.ignoreTag &&
                this.peek() === 47 // char code for '/'
            ) {
                if (expectingCloseTag) {
                    break;
                }
                else {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.UNMATCHED_CLOSING_TAG, createLocation(this.clonePosition(), this.clonePosition()));
                }
            }
            else if (char === 60 /* `<` */ &&
                !this.ignoreTag &&
                _isAlpha(this.peek() || 0)) {
                var result = this.parseTag(nestingLevel, parentArgType);
                if (result.err) {
                    return result;
                }
                elements.push(result.val);
            }
            else {
                var result = this.parseLiteral(nestingLevel, parentArgType);
                if (result.err) {
                    return result;
                }
                elements.push(result.val);
            }
        }
        return { val: elements, err: null };
    };
    /**
     * A tag name must start with an ASCII lower/upper case letter. The grammar is based on the
     * [custom element name][] except that a dash is NOT always mandatory and uppercase letters
     * are accepted:
     *
     * ```
     * tag ::= "<" tagName (whitespace)* "/>" | "<" tagName (whitespace)* ">" message "</" tagName (whitespace)* ">"
     * tagName ::= [a-z] (PENChar)*
     * PENChar ::=
     *     "-" | "." | [0-9] | "_" | [a-z] | [A-Z] | #xB7 | [#xC0-#xD6] | [#xD8-#xF6] | [#xF8-#x37D] |
     *     [#x37F-#x1FFF] | [#x200C-#x200D] | [#x203F-#x2040] | [#x2070-#x218F] | [#x2C00-#x2FEF] |
     *     [#x3001-#xD7FF] | [#xF900-#xFDCF] | [#xFDF0-#xFFFD] | [#x10000-#xEFFFF]
     * ```
     *
     * [custom element name]: https://html.spec.whatwg.org/multipage/custom-elements.html#valid-custom-element-name
     * NOTE: We're a bit more lax here since HTML technically does not allow uppercase HTML element but we do
     * since other tag-based engines like React allow it
     */
    Parser.prototype.parseTag = function (nestingLevel, parentArgType) {
        var startPosition = this.clonePosition();
        this.bump(); // `<`
        var tagName = this.parseTagName();
        this.bumpSpace();
        if (this.bumpIf('/>')) {
            // Self closing tag
            return {
                val: {
                    type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.literal,
                    value: "<".concat(tagName, "/>"),
                    location: createLocation(startPosition, this.clonePosition()),
                },
                err: null,
            };
        }
        else if (this.bumpIf('>')) {
            var childrenResult = this.parseMessage(nestingLevel + 1, parentArgType, true);
            if (childrenResult.err) {
                return childrenResult;
            }
            var children = childrenResult.val;
            // Expecting a close tag
            var endTagStartPosition = this.clonePosition();
            if (this.bumpIf('</')) {
                if (this.isEOF() || !_isAlpha(this.char())) {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_TAG, createLocation(endTagStartPosition, this.clonePosition()));
                }
                var closingTagNameStartPosition = this.clonePosition();
                var closingTagName = this.parseTagName();
                if (tagName !== closingTagName) {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.UNMATCHED_CLOSING_TAG, createLocation(closingTagNameStartPosition, this.clonePosition()));
                }
                this.bumpSpace();
                if (!this.bumpIf('>')) {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_TAG, createLocation(endTagStartPosition, this.clonePosition()));
                }
                return {
                    val: {
                        type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.tag,
                        value: tagName,
                        children: children,
                        location: createLocation(startPosition, this.clonePosition()),
                    },
                    err: null,
                };
            }
            else {
                return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.UNCLOSED_TAG, createLocation(startPosition, this.clonePosition()));
            }
        }
        else {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_TAG, createLocation(startPosition, this.clonePosition()));
        }
    };
    /**
     * This method assumes that the caller has peeked ahead for the first tag character.
     */
    Parser.prototype.parseTagName = function () {
        var startOffset = this.offset();
        this.bump(); // the first tag name character
        while (!this.isEOF() && _isPotentialElementNameChar(this.char())) {
            this.bump();
        }
        return this.message.slice(startOffset, this.offset());
    };
    Parser.prototype.parseLiteral = function (nestingLevel, parentArgType) {
        var start = this.clonePosition();
        var value = '';
        while (true) {
            var parseQuoteResult = this.tryParseQuote(parentArgType);
            if (parseQuoteResult) {
                value += parseQuoteResult;
                continue;
            }
            var parseUnquotedResult = this.tryParseUnquoted(nestingLevel, parentArgType);
            if (parseUnquotedResult) {
                value += parseUnquotedResult;
                continue;
            }
            var parseLeftAngleResult = this.tryParseLeftAngleBracket();
            if (parseLeftAngleResult) {
                value += parseLeftAngleResult;
                continue;
            }
            break;
        }
        var location = createLocation(start, this.clonePosition());
        return {
            val: { type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.literal, value: value, location: location },
            err: null,
        };
    };
    Parser.prototype.tryParseLeftAngleBracket = function () {
        if (!this.isEOF() &&
            this.char() === 60 /* `<` */ &&
            (this.ignoreTag ||
                // If at the opening tag or closing tag position, bail.
                !_isAlphaOrSlash(this.peek() || 0))) {
            this.bump(); // `<`
            return '<';
        }
        return null;
    };
    /**
     * Starting with ICU 4.8, an ASCII apostrophe only starts quoted text if it immediately precedes
     * a character that requires quoting (that is, "only where needed"), and works the same in
     * nested messages as on the top level of the pattern. The new behavior is otherwise compatible.
     */
    Parser.prototype.tryParseQuote = function (parentArgType) {
        if (this.isEOF() || this.char() !== 39 /* `'` */) {
            return null;
        }
        // Parse escaped char following the apostrophe, or early return if there is no escaped char.
        // Check if is valid escaped character
        switch (this.peek()) {
            case 39 /* `'` */:
                // double quote, should return as a single quote.
                this.bump();
                this.bump();
                return "'";
            // '{', '<', '>', '}'
            case 123:
            case 60:
            case 62:
            case 125:
                break;
            case 35: // '#'
                if (parentArgType === 'plural' || parentArgType === 'selectordinal') {
                    break;
                }
                return null;
            default:
                return null;
        }
        this.bump(); // apostrophe
        var codePoints = [this.char()]; // escaped char
        this.bump();
        // read chars until the optional closing apostrophe is found
        while (!this.isEOF()) {
            var ch = this.char();
            if (ch === 39 /* `'` */) {
                if (this.peek() === 39 /* `'` */) {
                    codePoints.push(39);
                    // Bump one more time because we need to skip 2 characters.
                    this.bump();
                }
                else {
                    // Optional closing apostrophe.
                    this.bump();
                    break;
                }
            }
            else {
                codePoints.push(ch);
            }
            this.bump();
        }
        return fromCodePoint.apply(void 0, codePoints);
    };
    Parser.prototype.tryParseUnquoted = function (nestingLevel, parentArgType) {
        if (this.isEOF()) {
            return null;
        }
        var ch = this.char();
        if (ch === 60 /* `<` */ ||
            ch === 123 /* `{` */ ||
            (ch === 35 /* `#` */ &&
                (parentArgType === 'plural' || parentArgType === 'selectordinal')) ||
            (ch === 125 /* `}` */ && nestingLevel > 0)) {
            return null;
        }
        else {
            this.bump();
            return fromCodePoint(ch);
        }
    };
    Parser.prototype.parseArgument = function (nestingLevel, expectingCloseTag) {
        var openingBracePosition = this.clonePosition();
        this.bump(); // `{`
        this.bumpSpace();
        if (this.isEOF()) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
        }
        if (this.char() === 125 /* `}` */) {
            this.bump();
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EMPTY_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
        }
        // argument name
        var value = this.parseIdentifierIfPossible().value;
        if (!value) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.MALFORMED_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
        }
        this.bumpSpace();
        if (this.isEOF()) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
        }
        switch (this.char()) {
            // Simple argument: `{name}`
            case 125 /* `}` */: {
                this.bump(); // `}`
                return {
                    val: {
                        type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.argument,
                        // value does not include the opening and closing braces.
                        value: value,
                        location: createLocation(openingBracePosition, this.clonePosition()),
                    },
                    err: null,
                };
            }
            // Argument with options: `{name, format, ...}`
            case 44 /* `,` */: {
                this.bump(); // `,`
                this.bumpSpace();
                if (this.isEOF()) {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
                }
                return this.parseArgumentOptions(nestingLevel, expectingCloseTag, value, openingBracePosition);
            }
            default:
                return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.MALFORMED_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
        }
    };
    /**
     * Advance the parser until the end of the identifier, if it is currently on
     * an identifier character. Return an empty string otherwise.
     */
    Parser.prototype.parseIdentifierIfPossible = function () {
        var startingPosition = this.clonePosition();
        var startOffset = this.offset();
        var value = matchIdentifierAtIndex(this.message, startOffset);
        var endOffset = startOffset + value.length;
        this.bumpTo(endOffset);
        var endPosition = this.clonePosition();
        var location = createLocation(startingPosition, endPosition);
        return { value: value, location: location };
    };
    Parser.prototype.parseArgumentOptions = function (nestingLevel, expectingCloseTag, value, openingBracePosition) {
        var _a;
        // Parse this range:
        // {name, type, style}
        //        ^---^
        var typeStartPosition = this.clonePosition();
        var argType = this.parseIdentifierIfPossible().value;
        var typeEndPosition = this.clonePosition();
        switch (argType) {
            case '':
                // Expecting a style string number, date, time, plural, selectordinal, or select.
                return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_TYPE, createLocation(typeStartPosition, typeEndPosition));
            case 'number':
            case 'date':
            case 'time': {
                // Parse this range:
                // {name, number, style}
                //              ^-------^
                this.bumpSpace();
                var styleAndLocation = null;
                if (this.bumpIf(',')) {
                    this.bumpSpace();
                    var styleStartPosition = this.clonePosition();
                    var result = this.parseSimpleArgStyleIfPossible();
                    if (result.err) {
                        return result;
                    }
                    var style = trimEnd(result.val);
                    if (style.length === 0) {
                        return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_STYLE, createLocation(this.clonePosition(), this.clonePosition()));
                    }
                    var styleLocation = createLocation(styleStartPosition, this.clonePosition());
                    styleAndLocation = { style: style, styleLocation: styleLocation };
                }
                var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
                if (argCloseResult.err) {
                    return argCloseResult;
                }
                var location_1 = createLocation(openingBracePosition, this.clonePosition());
                // Extract style or skeleton
                if (styleAndLocation && startsWith(styleAndLocation === null || styleAndLocation === void 0 ? void 0 : styleAndLocation.style, '::', 0)) {
                    // Skeleton starts with `::`.
                    var skeleton = trimStart(styleAndLocation.style.slice(2));
                    if (argType === 'number') {
                        var result = this.parseNumberSkeletonFromString(skeleton, styleAndLocation.styleLocation);
                        if (result.err) {
                            return result;
                        }
                        return {
                            val: { type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.number, value: value, location: location_1, style: result.val },
                            err: null,
                        };
                    }
                    else {
                        if (skeleton.length === 0) {
                            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_DATE_TIME_SKELETON, location_1);
                        }
                        var dateTimePattern = skeleton;
                        // Get "best match" pattern only if locale is passed, if not, let it
                        // pass as-is where `parseDateTimeSkeleton()` will throw an error
                        // for unsupported patterns.
                        if (this.locale) {
                            dateTimePattern = (0,_date_time_pattern_generator__WEBPACK_IMPORTED_MODULE_4__.getBestPattern)(skeleton, this.locale);
                        }
                        var style = {
                            type: _types__WEBPACK_IMPORTED_MODULE_1__.SKELETON_TYPE.dateTime,
                            pattern: dateTimePattern,
                            location: styleAndLocation.styleLocation,
                            parsedOptions: this.shouldParseSkeletons
                                ? (0,_formatjs_icu_skeleton_parser__WEBPACK_IMPORTED_MODULE_3__.parseDateTimeSkeleton)(dateTimePattern)
                                : {},
                        };
                        var type = argType === 'date' ? _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.date : _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.time;
                        return {
                            val: { type: type, value: value, location: location_1, style: style },
                            err: null,
                        };
                    }
                }
                // Regular style or no style.
                return {
                    val: {
                        type: argType === 'number'
                            ? _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.number
                            : argType === 'date'
                                ? _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.date
                                : _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.time,
                        value: value,
                        location: location_1,
                        style: (_a = styleAndLocation === null || styleAndLocation === void 0 ? void 0 : styleAndLocation.style) !== null && _a !== void 0 ? _a : null,
                    },
                    err: null,
                };
            }
            case 'plural':
            case 'selectordinal':
            case 'select': {
                // Parse this range:
                // {name, plural, options}
                //              ^---------^
                var typeEndPosition_1 = this.clonePosition();
                this.bumpSpace();
                if (!this.bumpIf(',')) {
                    return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_SELECT_ARGUMENT_OPTIONS, createLocation(typeEndPosition_1, (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__assign)({}, typeEndPosition_1)));
                }
                this.bumpSpace();
                // Parse offset:
                // {name, plural, offset:1, options}
                //                ^-----^
                //
                // or the first option:
                //
                // {name, plural, one {...} other {...}}
                //                ^--^
                var identifierAndLocation = this.parseIdentifierIfPossible();
                var pluralOffset = 0;
                if (argType !== 'select' && identifierAndLocation.value === 'offset') {
                    if (!this.bumpIf(':')) {
                        return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE, createLocation(this.clonePosition(), this.clonePosition()));
                    }
                    this.bumpSpace();
                    var result = this.tryParseDecimalInteger(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE, _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);
                    if (result.err) {
                        return result;
                    }
                    // Parse another identifier for option parsing
                    this.bumpSpace();
                    identifierAndLocation = this.parseIdentifierIfPossible();
                    pluralOffset = result.val;
                }
                var optionsResult = this.tryParsePluralOrSelectOptions(nestingLevel, argType, expectingCloseTag, identifierAndLocation);
                if (optionsResult.err) {
                    return optionsResult;
                }
                var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
                if (argCloseResult.err) {
                    return argCloseResult;
                }
                var location_2 = createLocation(openingBracePosition, this.clonePosition());
                if (argType === 'select') {
                    return {
                        val: {
                            type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.select,
                            value: value,
                            options: fromEntries(optionsResult.val),
                            location: location_2,
                        },
                        err: null,
                    };
                }
                else {
                    return {
                        val: {
                            type: _types__WEBPACK_IMPORTED_MODULE_1__.TYPE.plural,
                            value: value,
                            options: fromEntries(optionsResult.val),
                            offset: pluralOffset,
                            pluralType: argType === 'plural' ? 'cardinal' : 'ordinal',
                            location: location_2,
                        },
                        err: null,
                    };
                }
            }
            default:
                return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_ARGUMENT_TYPE, createLocation(typeStartPosition, typeEndPosition));
        }
    };
    Parser.prototype.tryParseArgumentClose = function (openingBracePosition) {
        // Parse: {value, number, ::currency/GBP }
        //
        if (this.isEOF() || this.char() !== 125 /* `}` */) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
        }
        this.bump(); // `}`
        return { val: true, err: null };
    };
    /**
     * See: https://github.com/unicode-org/icu/blob/af7ed1f6d2298013dc303628438ec4abe1f16479/icu4c/source/common/messagepattern.cpp#L659
     */
    Parser.prototype.parseSimpleArgStyleIfPossible = function () {
        var nestedBraces = 0;
        var startPosition = this.clonePosition();
        while (!this.isEOF()) {
            var ch = this.char();
            switch (ch) {
                case 39 /* `'` */: {
                    // Treat apostrophe as quoting but include it in the style part.
                    // Find the end of the quoted literal text.
                    this.bump();
                    var apostrophePosition = this.clonePosition();
                    if (!this.bumpUntil("'")) {
                        return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE, createLocation(apostrophePosition, this.clonePosition()));
                    }
                    this.bump();
                    break;
                }
                case 123 /* `{` */: {
                    nestedBraces += 1;
                    this.bump();
                    break;
                }
                case 125 /* `}` */: {
                    if (nestedBraces > 0) {
                        nestedBraces -= 1;
                    }
                    else {
                        return {
                            val: this.message.slice(startPosition.offset, this.offset()),
                            err: null,
                        };
                    }
                    break;
                }
                default:
                    this.bump();
                    break;
            }
        }
        return {
            val: this.message.slice(startPosition.offset, this.offset()),
            err: null,
        };
    };
    Parser.prototype.parseNumberSkeletonFromString = function (skeleton, location) {
        var tokens = [];
        try {
            tokens = (0,_formatjs_icu_skeleton_parser__WEBPACK_IMPORTED_MODULE_3__.parseNumberSkeletonFromString)(skeleton);
        }
        catch (e) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_NUMBER_SKELETON, location);
        }
        return {
            val: {
                type: _types__WEBPACK_IMPORTED_MODULE_1__.SKELETON_TYPE.number,
                tokens: tokens,
                location: location,
                parsedOptions: this.shouldParseSkeletons
                    ? (0,_formatjs_icu_skeleton_parser__WEBPACK_IMPORTED_MODULE_3__.parseNumberSkeleton)(tokens)
                    : {},
            },
            err: null,
        };
    };
    /**
     * @param nesting_level The current nesting level of messages.
     *     This can be positive when parsing message fragment in select or plural argument options.
     * @param parent_arg_type The parent argument's type.
     * @param parsed_first_identifier If provided, this is the first identifier-like selector of
     *     the argument. It is a by-product of a previous parsing attempt.
     * @param expecting_close_tag If true, this message is directly or indirectly nested inside
     *     between a pair of opening and closing tags. The nested message will not parse beyond
     *     the closing tag boundary.
     */
    Parser.prototype.tryParsePluralOrSelectOptions = function (nestingLevel, parentArgType, expectCloseTag, parsedFirstIdentifier) {
        var _a;
        var hasOtherClause = false;
        var options = [];
        var parsedSelectors = new Set();
        var selector = parsedFirstIdentifier.value, selectorLocation = parsedFirstIdentifier.location;
        // Parse:
        // one {one apple}
        // ^--^
        while (true) {
            if (selector.length === 0) {
                var startPosition = this.clonePosition();
                if (parentArgType !== 'select' && this.bumpIf('=')) {
                    // Try parse `={number}` selector
                    var result = this.tryParseDecimalInteger(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR, _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.INVALID_PLURAL_ARGUMENT_SELECTOR);
                    if (result.err) {
                        return result;
                    }
                    selectorLocation = createLocation(startPosition, this.clonePosition());
                    selector = this.message.slice(startPosition.offset, this.offset());
                }
                else {
                    break;
                }
            }
            // Duplicate selector clauses
            if (parsedSelectors.has(selector)) {
                return this.error(parentArgType === 'select'
                    ? _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.DUPLICATE_SELECT_ARGUMENT_SELECTOR
                    : _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.DUPLICATE_PLURAL_ARGUMENT_SELECTOR, selectorLocation);
            }
            if (selector === 'other') {
                hasOtherClause = true;
            }
            // Parse:
            // one {one apple}
            //     ^----------^
            this.bumpSpace();
            var openingBracePosition = this.clonePosition();
            if (!this.bumpIf('{')) {
                return this.error(parentArgType === 'select'
                    ? _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT
                    : _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT, createLocation(this.clonePosition(), this.clonePosition()));
            }
            var fragmentResult = this.parseMessage(nestingLevel + 1, parentArgType, expectCloseTag);
            if (fragmentResult.err) {
                return fragmentResult;
            }
            var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
            if (argCloseResult.err) {
                return argCloseResult;
            }
            options.push([
                selector,
                {
                    value: fragmentResult.val,
                    location: createLocation(openingBracePosition, this.clonePosition()),
                },
            ]);
            // Keep track of the existing selectors
            parsedSelectors.add(selector);
            // Prep next selector clause.
            this.bumpSpace();
            (_a = this.parseIdentifierIfPossible(), selector = _a.value, selectorLocation = _a.location);
        }
        if (options.length === 0) {
            return this.error(parentArgType === 'select'
                ? _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_SELECT_ARGUMENT_SELECTOR
                : _error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR, createLocation(this.clonePosition(), this.clonePosition()));
        }
        if (this.requiresOtherClause && !hasOtherClause) {
            return this.error(_error__WEBPACK_IMPORTED_MODULE_0__.ErrorKind.MISSING_OTHER_CLAUSE, createLocation(this.clonePosition(), this.clonePosition()));
        }
        return { val: options, err: null };
    };
    Parser.prototype.tryParseDecimalInteger = function (expectNumberError, invalidNumberError) {
        var sign = 1;
        var startingPosition = this.clonePosition();
        if (this.bumpIf('+')) {
        }
        else if (this.bumpIf('-')) {
            sign = -1;
        }
        var hasDigits = false;
        var decimal = 0;
        while (!this.isEOF()) {
            var ch = this.char();
            if (ch >= 48 /* `0` */ && ch <= 57 /* `9` */) {
                hasDigits = true;
                decimal = decimal * 10 + (ch - 48);
                this.bump();
            }
            else {
                break;
            }
        }
        var location = createLocation(startingPosition, this.clonePosition());
        if (!hasDigits) {
            return this.error(expectNumberError, location);
        }
        decimal *= sign;
        if (!isSafeInteger(decimal)) {
            return this.error(invalidNumberError, location);
        }
        return { val: decimal, err: null };
    };
    Parser.prototype.offset = function () {
        return this.position.offset;
    };
    Parser.prototype.isEOF = function () {
        return this.offset() === this.message.length;
    };
    Parser.prototype.clonePosition = function () {
        // This is much faster than `Object.assign` or spread.
        return {
            offset: this.position.offset,
            line: this.position.line,
            column: this.position.column,
        };
    };
    /**
     * Return the code point at the current position of the parser.
     * Throws if the index is out of bound.
     */
    Parser.prototype.char = function () {
        var offset = this.position.offset;
        if (offset >= this.message.length) {
            throw Error('out of bound');
        }
        var code = codePointAt(this.message, offset);
        if (code === undefined) {
            throw Error("Offset ".concat(offset, " is at invalid UTF-16 code unit boundary"));
        }
        return code;
    };
    Parser.prototype.error = function (kind, location) {
        return {
            val: null,
            err: {
                kind: kind,
                message: this.message,
                location: location,
            },
        };
    };
    /** Bump the parser to the next UTF-16 code unit. */
    Parser.prototype.bump = function () {
        if (this.isEOF()) {
            return;
        }
        var code = this.char();
        if (code === 10 /* '\n' */) {
            this.position.line += 1;
            this.position.column = 1;
            this.position.offset += 1;
        }
        else {
            this.position.column += 1;
            // 0 ~ 0x10000 -> unicode BMP, otherwise skip the surrogate pair.
            this.position.offset += code < 0x10000 ? 1 : 2;
        }
    };
    /**
     * If the substring starting at the current position of the parser has
     * the given prefix, then bump the parser to the character immediately
     * following the prefix and return true. Otherwise, don't bump the parser
     * and return false.
     */
    Parser.prototype.bumpIf = function (prefix) {
        if (startsWith(this.message, prefix, this.offset())) {
            for (var i = 0; i < prefix.length; i++) {
                this.bump();
            }
            return true;
        }
        return false;
    };
    /**
     * Bump the parser until the pattern character is found and return `true`.
     * Otherwise bump to the end of the file and return `false`.
     */
    Parser.prototype.bumpUntil = function (pattern) {
        var currentOffset = this.offset();
        var index = this.message.indexOf(pattern, currentOffset);
        if (index >= 0) {
            this.bumpTo(index);
            return true;
        }
        else {
            this.bumpTo(this.message.length);
            return false;
        }
    };
    /**
     * Bump the parser to the target offset.
     * If target offset is beyond the end of the input, bump the parser to the end of the input.
     */
    Parser.prototype.bumpTo = function (targetOffset) {
        if (this.offset() > targetOffset) {
            throw Error("targetOffset ".concat(targetOffset, " must be greater than or equal to the current offset ").concat(this.offset()));
        }
        targetOffset = Math.min(targetOffset, this.message.length);
        while (true) {
            var offset = this.offset();
            if (offset === targetOffset) {
                break;
            }
            if (offset > targetOffset) {
                throw Error("targetOffset ".concat(targetOffset, " is at invalid UTF-16 code unit boundary"));
            }
            this.bump();
            if (this.isEOF()) {
                break;
            }
        }
    };
    /** advance the parser through all whitespace to the next non-whitespace code unit. */
    Parser.prototype.bumpSpace = function () {
        while (!this.isEOF() && _isWhiteSpace(this.char())) {
            this.bump();
        }
    };
    /**
     * Peek at the *next* Unicode codepoint in the input without advancing the parser.
     * If the input has been exhausted, then this returns null.
     */
    Parser.prototype.peek = function () {
        if (this.isEOF()) {
            return null;
        }
        var code = this.char();
        var offset = this.offset();
        var nextCode = this.message.charCodeAt(offset + (code >= 0x10000 ? 2 : 1));
        return nextCode !== null && nextCode !== void 0 ? nextCode : null;
    };
    return Parser;
}());

/**
 * This check if codepoint is alphabet (lower & uppercase)
 * @param codepoint
 * @returns
 */
function _isAlpha(codepoint) {
    return ((codepoint >= 97 && codepoint <= 122) ||
        (codepoint >= 65 && codepoint <= 90));
}
function _isAlphaOrSlash(codepoint) {
    return _isAlpha(codepoint) || codepoint === 47; /* '/' */
}
/** See `parseTag` function docs. */
function _isPotentialElementNameChar(c) {
    return (c === 45 /* '-' */ ||
        c === 46 /* '.' */ ||
        (c >= 48 && c <= 57) /* 0..9 */ ||
        c === 95 /* '_' */ ||
        (c >= 97 && c <= 122) /** a..z */ ||
        (c >= 65 && c <= 90) /* A..Z */ ||
        c == 0xb7 ||
        (c >= 0xc0 && c <= 0xd6) ||
        (c >= 0xd8 && c <= 0xf6) ||
        (c >= 0xf8 && c <= 0x37d) ||
        (c >= 0x37f && c <= 0x1fff) ||
        (c >= 0x200c && c <= 0x200d) ||
        (c >= 0x203f && c <= 0x2040) ||
        (c >= 0x2070 && c <= 0x218f) ||
        (c >= 0x2c00 && c <= 0x2fef) ||
        (c >= 0x3001 && c <= 0xd7ff) ||
        (c >= 0xf900 && c <= 0xfdcf) ||
        (c >= 0xfdf0 && c <= 0xfffd) ||
        (c >= 0x10000 && c <= 0xeffff));
}
/**
 * Code point equivalent of regex `\p{White_Space}`.
 * From: https://www.unicode.org/Public/UCD/latest/ucd/PropList.txt
 */
function _isWhiteSpace(c) {
    return ((c >= 0x0009 && c <= 0x000d) ||
        c === 0x0020 ||
        c === 0x0085 ||
        (c >= 0x200e && c <= 0x200f) ||
        c === 0x2028 ||
        c === 0x2029);
}
/**
 * Code point equivalent of regex `\p{Pattern_Syntax}`.
 * See https://www.unicode.org/Public/UCD/latest/ucd/PropList.txt
 */
function _isPatternSyntax(c) {
    return ((c >= 0x0021 && c <= 0x0023) ||
        c === 0x0024 ||
        (c >= 0x0025 && c <= 0x0027) ||
        c === 0x0028 ||
        c === 0x0029 ||
        c === 0x002a ||
        c === 0x002b ||
        c === 0x002c ||
        c === 0x002d ||
        (c >= 0x002e && c <= 0x002f) ||
        (c >= 0x003a && c <= 0x003b) ||
        (c >= 0x003c && c <= 0x003e) ||
        (c >= 0x003f && c <= 0x0040) ||
        c === 0x005b ||
        c === 0x005c ||
        c === 0x005d ||
        c === 0x005e ||
        c === 0x0060 ||
        c === 0x007b ||
        c === 0x007c ||
        c === 0x007d ||
        c === 0x007e ||
        c === 0x00a1 ||
        (c >= 0x00a2 && c <= 0x00a5) ||
        c === 0x00a6 ||
        c === 0x00a7 ||
        c === 0x00a9 ||
        c === 0x00ab ||
        c === 0x00ac ||
        c === 0x00ae ||
        c === 0x00b0 ||
        c === 0x00b1 ||
        c === 0x00b6 ||
        c === 0x00bb ||
        c === 0x00bf ||
        c === 0x00d7 ||
        c === 0x00f7 ||
        (c >= 0x2010 && c <= 0x2015) ||
        (c >= 0x2016 && c <= 0x2017) ||
        c === 0x2018 ||
        c === 0x2019 ||
        c === 0x201a ||
        (c >= 0x201b && c <= 0x201c) ||
        c === 0x201d ||
        c === 0x201e ||
        c === 0x201f ||
        (c >= 0x2020 && c <= 0x2027) ||
        (c >= 0x2030 && c <= 0x2038) ||
        c === 0x2039 ||
        c === 0x203a ||
        (c >= 0x203b && c <= 0x203e) ||
        (c >= 0x2041 && c <= 0x2043) ||
        c === 0x2044 ||
        c === 0x2045 ||
        c === 0x2046 ||
        (c >= 0x2047 && c <= 0x2051) ||
        c === 0x2052 ||
        c === 0x2053 ||
        (c >= 0x2055 && c <= 0x205e) ||
        (c >= 0x2190 && c <= 0x2194) ||
        (c >= 0x2195 && c <= 0x2199) ||
        (c >= 0x219a && c <= 0x219b) ||
        (c >= 0x219c && c <= 0x219f) ||
        c === 0x21a0 ||
        (c >= 0x21a1 && c <= 0x21a2) ||
        c === 0x21a3 ||
        (c >= 0x21a4 && c <= 0x21a5) ||
        c === 0x21a6 ||
        (c >= 0x21a7 && c <= 0x21ad) ||
        c === 0x21ae ||
        (c >= 0x21af && c <= 0x21cd) ||
        (c >= 0x21ce && c <= 0x21cf) ||
        (c >= 0x21d0 && c <= 0x21d1) ||
        c === 0x21d2 ||
        c === 0x21d3 ||
        c === 0x21d4 ||
        (c >= 0x21d5 && c <= 0x21f3) ||
        (c >= 0x21f4 && c <= 0x22ff) ||
        (c >= 0x2300 && c <= 0x2307) ||
        c === 0x2308 ||
        c === 0x2309 ||
        c === 0x230a ||
        c === 0x230b ||
        (c >= 0x230c && c <= 0x231f) ||
        (c >= 0x2320 && c <= 0x2321) ||
        (c >= 0x2322 && c <= 0x2328) ||
        c === 0x2329 ||
        c === 0x232a ||
        (c >= 0x232b && c <= 0x237b) ||
        c === 0x237c ||
        (c >= 0x237d && c <= 0x239a) ||
        (c >= 0x239b && c <= 0x23b3) ||
        (c >= 0x23b4 && c <= 0x23db) ||
        (c >= 0x23dc && c <= 0x23e1) ||
        (c >= 0x23e2 && c <= 0x2426) ||
        (c >= 0x2427 && c <= 0x243f) ||
        (c >= 0x2440 && c <= 0x244a) ||
        (c >= 0x244b && c <= 0x245f) ||
        (c >= 0x2500 && c <= 0x25b6) ||
        c === 0x25b7 ||
        (c >= 0x25b8 && c <= 0x25c0) ||
        c === 0x25c1 ||
        (c >= 0x25c2 && c <= 0x25f7) ||
        (c >= 0x25f8 && c <= 0x25ff) ||
        (c >= 0x2600 && c <= 0x266e) ||
        c === 0x266f ||
        (c >= 0x2670 && c <= 0x2767) ||
        c === 0x2768 ||
        c === 0x2769 ||
        c === 0x276a ||
        c === 0x276b ||
        c === 0x276c ||
        c === 0x276d ||
        c === 0x276e ||
        c === 0x276f ||
        c === 0x2770 ||
        c === 0x2771 ||
        c === 0x2772 ||
        c === 0x2773 ||
        c === 0x2774 ||
        c === 0x2775 ||
        (c >= 0x2794 && c <= 0x27bf) ||
        (c >= 0x27c0 && c <= 0x27c4) ||
        c === 0x27c5 ||
        c === 0x27c6 ||
        (c >= 0x27c7 && c <= 0x27e5) ||
        c === 0x27e6 ||
        c === 0x27e7 ||
        c === 0x27e8 ||
        c === 0x27e9 ||
        c === 0x27ea ||
        c === 0x27eb ||
        c === 0x27ec ||
        c === 0x27ed ||
        c === 0x27ee ||
        c === 0x27ef ||
        (c >= 0x27f0 && c <= 0x27ff) ||
        (c >= 0x2800 && c <= 0x28ff) ||
        (c >= 0x2900 && c <= 0x2982) ||
        c === 0x2983 ||
        c === 0x2984 ||
        c === 0x2985 ||
        c === 0x2986 ||
        c === 0x2987 ||
        c === 0x2988 ||
        c === 0x2989 ||
        c === 0x298a ||
        c === 0x298b ||
        c === 0x298c ||
        c === 0x298d ||
        c === 0x298e ||
        c === 0x298f ||
        c === 0x2990 ||
        c === 0x2991 ||
        c === 0x2992 ||
        c === 0x2993 ||
        c === 0x2994 ||
        c === 0x2995 ||
        c === 0x2996 ||
        c === 0x2997 ||
        c === 0x2998 ||
        (c >= 0x2999 && c <= 0x29d7) ||
        c === 0x29d8 ||
        c === 0x29d9 ||
        c === 0x29da ||
        c === 0x29db ||
        (c >= 0x29dc && c <= 0x29fb) ||
        c === 0x29fc ||
        c === 0x29fd ||
        (c >= 0x29fe && c <= 0x2aff) ||
        (c >= 0x2b00 && c <= 0x2b2f) ||
        (c >= 0x2b30 && c <= 0x2b44) ||
        (c >= 0x2b45 && c <= 0x2b46) ||
        (c >= 0x2b47 && c <= 0x2b4c) ||
        (c >= 0x2b4d && c <= 0x2b73) ||
        (c >= 0x2b74 && c <= 0x2b75) ||
        (c >= 0x2b76 && c <= 0x2b95) ||
        c === 0x2b96 ||
        (c >= 0x2b97 && c <= 0x2bff) ||
        (c >= 0x2e00 && c <= 0x2e01) ||
        c === 0x2e02 ||
        c === 0x2e03 ||
        c === 0x2e04 ||
        c === 0x2e05 ||
        (c >= 0x2e06 && c <= 0x2e08) ||
        c === 0x2e09 ||
        c === 0x2e0a ||
        c === 0x2e0b ||
        c === 0x2e0c ||
        c === 0x2e0d ||
        (c >= 0x2e0e && c <= 0x2e16) ||
        c === 0x2e17 ||
        (c >= 0x2e18 && c <= 0x2e19) ||
        c === 0x2e1a ||
        c === 0x2e1b ||
        c === 0x2e1c ||
        c === 0x2e1d ||
        (c >= 0x2e1e && c <= 0x2e1f) ||
        c === 0x2e20 ||
        c === 0x2e21 ||
        c === 0x2e22 ||
        c === 0x2e23 ||
        c === 0x2e24 ||
        c === 0x2e25 ||
        c === 0x2e26 ||
        c === 0x2e27 ||
        c === 0x2e28 ||
        c === 0x2e29 ||
        (c >= 0x2e2a && c <= 0x2e2e) ||
        c === 0x2e2f ||
        (c >= 0x2e30 && c <= 0x2e39) ||
        (c >= 0x2e3a && c <= 0x2e3b) ||
        (c >= 0x2e3c && c <= 0x2e3f) ||
        c === 0x2e40 ||
        c === 0x2e41 ||
        c === 0x2e42 ||
        (c >= 0x2e43 && c <= 0x2e4f) ||
        (c >= 0x2e50 && c <= 0x2e51) ||
        c === 0x2e52 ||
        (c >= 0x2e53 && c <= 0x2e7f) ||
        (c >= 0x3001 && c <= 0x3003) ||
        c === 0x3008 ||
        c === 0x3009 ||
        c === 0x300a ||
        c === 0x300b ||
        c === 0x300c ||
        c === 0x300d ||
        c === 0x300e ||
        c === 0x300f ||
        c === 0x3010 ||
        c === 0x3011 ||
        (c >= 0x3012 && c <= 0x3013) ||
        c === 0x3014 ||
        c === 0x3015 ||
        c === 0x3016 ||
        c === 0x3017 ||
        c === 0x3018 ||
        c === 0x3019 ||
        c === 0x301a ||
        c === 0x301b ||
        c === 0x301c ||
        c === 0x301d ||
        (c >= 0x301e && c <= 0x301f) ||
        c === 0x3020 ||
        c === 0x3030 ||
        c === 0xfd3e ||
        c === 0xfd3f ||
        (c >= 0xfe45 && c <= 0xfe46));
}


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/regex.generated.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/regex.generated.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SPACE_SEPARATOR_REGEX": () => (/* binding */ SPACE_SEPARATOR_REGEX),
/* harmony export */   "WHITE_SPACE_REGEX": () => (/* binding */ WHITE_SPACE_REGEX)
/* harmony export */ });
// @generated from regex-gen.ts
var SPACE_SEPARATOR_REGEX = /[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/;
var WHITE_SPACE_REGEX = /[\t-\r \x85\u200E\u200F\u2028\u2029]/;


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/time-data.generated.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/time-data.generated.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "timeData": () => (/* binding */ timeData)
/* harmony export */ });
// @generated from time-data-gen.ts
// prettier-ignore  
var timeData = {
    "AX": [
        "H"
    ],
    "BQ": [
        "H"
    ],
    "CP": [
        "H"
    ],
    "CZ": [
        "H"
    ],
    "DK": [
        "H"
    ],
    "FI": [
        "H"
    ],
    "ID": [
        "H"
    ],
    "IS": [
        "H"
    ],
    "ML": [
        "H"
    ],
    "NE": [
        "H"
    ],
    "RU": [
        "H"
    ],
    "SE": [
        "H"
    ],
    "SJ": [
        "H"
    ],
    "SK": [
        "H"
    ],
    "AS": [
        "h",
        "H"
    ],
    "BT": [
        "h",
        "H"
    ],
    "DJ": [
        "h",
        "H"
    ],
    "ER": [
        "h",
        "H"
    ],
    "GH": [
        "h",
        "H"
    ],
    "IN": [
        "h",
        "H"
    ],
    "LS": [
        "h",
        "H"
    ],
    "PG": [
        "h",
        "H"
    ],
    "PW": [
        "h",
        "H"
    ],
    "SO": [
        "h",
        "H"
    ],
    "TO": [
        "h",
        "H"
    ],
    "VU": [
        "h",
        "H"
    ],
    "WS": [
        "h",
        "H"
    ],
    "001": [
        "H",
        "h"
    ],
    "AL": [
        "h",
        "H",
        "hB"
    ],
    "TD": [
        "h",
        "H",
        "hB"
    ],
    "ca-ES": [
        "H",
        "h",
        "hB"
    ],
    "CF": [
        "H",
        "h",
        "hB"
    ],
    "CM": [
        "H",
        "h",
        "hB"
    ],
    "fr-CA": [
        "H",
        "h",
        "hB"
    ],
    "gl-ES": [
        "H",
        "h",
        "hB"
    ],
    "it-CH": [
        "H",
        "h",
        "hB"
    ],
    "it-IT": [
        "H",
        "h",
        "hB"
    ],
    "LU": [
        "H",
        "h",
        "hB"
    ],
    "NP": [
        "H",
        "h",
        "hB"
    ],
    "PF": [
        "H",
        "h",
        "hB"
    ],
    "SC": [
        "H",
        "h",
        "hB"
    ],
    "SM": [
        "H",
        "h",
        "hB"
    ],
    "SN": [
        "H",
        "h",
        "hB"
    ],
    "TF": [
        "H",
        "h",
        "hB"
    ],
    "VA": [
        "H",
        "h",
        "hB"
    ],
    "CY": [
        "h",
        "H",
        "hb",
        "hB"
    ],
    "GR": [
        "h",
        "H",
        "hb",
        "hB"
    ],
    "CO": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "DO": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "KP": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "KR": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "NA": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "PA": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "PR": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "VE": [
        "h",
        "H",
        "hB",
        "hb"
    ],
    "AC": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "AI": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "BW": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "BZ": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "CC": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "CK": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "CX": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "DG": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "FK": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "GB": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "GG": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "GI": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "IE": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "IM": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "IO": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "JE": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "LT": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "MK": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "MN": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "MS": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "NF": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "NG": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "NR": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "NU": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "PN": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "SH": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "SX": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "TA": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "ZA": [
        "H",
        "h",
        "hb",
        "hB"
    ],
    "af-ZA": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "AR": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "CL": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "CR": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "CU": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "EA": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-BO": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-BR": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-EC": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-ES": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-GQ": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "es-PE": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "GT": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "HN": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "IC": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "KG": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "KM": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "LK": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "MA": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "MX": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "NI": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "PY": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "SV": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "UY": [
        "H",
        "h",
        "hB",
        "hb"
    ],
    "JP": [
        "H",
        "h",
        "K"
    ],
    "AD": [
        "H",
        "hB"
    ],
    "AM": [
        "H",
        "hB"
    ],
    "AO": [
        "H",
        "hB"
    ],
    "AT": [
        "H",
        "hB"
    ],
    "AW": [
        "H",
        "hB"
    ],
    "BE": [
        "H",
        "hB"
    ],
    "BF": [
        "H",
        "hB"
    ],
    "BJ": [
        "H",
        "hB"
    ],
    "BL": [
        "H",
        "hB"
    ],
    "BR": [
        "H",
        "hB"
    ],
    "CG": [
        "H",
        "hB"
    ],
    "CI": [
        "H",
        "hB"
    ],
    "CV": [
        "H",
        "hB"
    ],
    "DE": [
        "H",
        "hB"
    ],
    "EE": [
        "H",
        "hB"
    ],
    "FR": [
        "H",
        "hB"
    ],
    "GA": [
        "H",
        "hB"
    ],
    "GF": [
        "H",
        "hB"
    ],
    "GN": [
        "H",
        "hB"
    ],
    "GP": [
        "H",
        "hB"
    ],
    "GW": [
        "H",
        "hB"
    ],
    "HR": [
        "H",
        "hB"
    ],
    "IL": [
        "H",
        "hB"
    ],
    "IT": [
        "H",
        "hB"
    ],
    "KZ": [
        "H",
        "hB"
    ],
    "MC": [
        "H",
        "hB"
    ],
    "MD": [
        "H",
        "hB"
    ],
    "MF": [
        "H",
        "hB"
    ],
    "MQ": [
        "H",
        "hB"
    ],
    "MZ": [
        "H",
        "hB"
    ],
    "NC": [
        "H",
        "hB"
    ],
    "NL": [
        "H",
        "hB"
    ],
    "PM": [
        "H",
        "hB"
    ],
    "PT": [
        "H",
        "hB"
    ],
    "RE": [
        "H",
        "hB"
    ],
    "RO": [
        "H",
        "hB"
    ],
    "SI": [
        "H",
        "hB"
    ],
    "SR": [
        "H",
        "hB"
    ],
    "ST": [
        "H",
        "hB"
    ],
    "TG": [
        "H",
        "hB"
    ],
    "TR": [
        "H",
        "hB"
    ],
    "WF": [
        "H",
        "hB"
    ],
    "YT": [
        "H",
        "hB"
    ],
    "BD": [
        "h",
        "hB",
        "H"
    ],
    "PK": [
        "h",
        "hB",
        "H"
    ],
    "AZ": [
        "H",
        "hB",
        "h"
    ],
    "BA": [
        "H",
        "hB",
        "h"
    ],
    "BG": [
        "H",
        "hB",
        "h"
    ],
    "CH": [
        "H",
        "hB",
        "h"
    ],
    "GE": [
        "H",
        "hB",
        "h"
    ],
    "LI": [
        "H",
        "hB",
        "h"
    ],
    "ME": [
        "H",
        "hB",
        "h"
    ],
    "RS": [
        "H",
        "hB",
        "h"
    ],
    "UA": [
        "H",
        "hB",
        "h"
    ],
    "UZ": [
        "H",
        "hB",
        "h"
    ],
    "XK": [
        "H",
        "hB",
        "h"
    ],
    "AG": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "AU": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "BB": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "BM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "BS": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "CA": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "DM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "en-001": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "FJ": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "FM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "GD": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "GM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "GU": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "GY": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "JM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "KI": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "KN": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "KY": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "LC": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "LR": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "MH": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "MP": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "MW": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "NZ": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "SB": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "SG": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "SL": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "SS": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "SZ": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "TC": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "TT": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "UM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "US": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "VC": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "VG": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "VI": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "ZM": [
        "h",
        "hb",
        "H",
        "hB"
    ],
    "BO": [
        "H",
        "hB",
        "h",
        "hb"
    ],
    "EC": [
        "H",
        "hB",
        "h",
        "hb"
    ],
    "ES": [
        "H",
        "hB",
        "h",
        "hb"
    ],
    "GQ": [
        "H",
        "hB",
        "h",
        "hb"
    ],
    "PE": [
        "H",
        "hB",
        "h",
        "hb"
    ],
    "AE": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "ar-001": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "BH": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "DZ": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "EG": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "EH": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "HK": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "IQ": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "JO": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "KW": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "LB": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "LY": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "MO": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "MR": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "OM": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "PH": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "PS": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "QA": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "SA": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "SD": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "SY": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "TN": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "YE": [
        "h",
        "hB",
        "hb",
        "H"
    ],
    "AF": [
        "H",
        "hb",
        "hB",
        "h"
    ],
    "LA": [
        "H",
        "hb",
        "hB",
        "h"
    ],
    "CN": [
        "H",
        "hB",
        "hb",
        "h"
    ],
    "LV": [
        "H",
        "hB",
        "hb",
        "h"
    ],
    "TL": [
        "H",
        "hB",
        "hb",
        "h"
    ],
    "zu-ZA": [
        "H",
        "hB",
        "hb",
        "h"
    ],
    "CD": [
        "hB",
        "H"
    ],
    "IR": [
        "hB",
        "H"
    ],
    "hi-IN": [
        "hB",
        "h",
        "H"
    ],
    "kn-IN": [
        "hB",
        "h",
        "H"
    ],
    "ml-IN": [
        "hB",
        "h",
        "H"
    ],
    "te-IN": [
        "hB",
        "h",
        "H"
    ],
    "KH": [
        "hB",
        "h",
        "H",
        "hb"
    ],
    "ta-IN": [
        "hB",
        "h",
        "hb",
        "H"
    ],
    "BN": [
        "hb",
        "hB",
        "h",
        "H"
    ],
    "MY": [
        "hb",
        "hB",
        "h",
        "H"
    ],
    "ET": [
        "hB",
        "hb",
        "h",
        "H"
    ],
    "gu-IN": [
        "hB",
        "hb",
        "h",
        "H"
    ],
    "mr-IN": [
        "hB",
        "hb",
        "h",
        "H"
    ],
    "pa-IN": [
        "hB",
        "hb",
        "h",
        "H"
    ],
    "TW": [
        "hB",
        "hb",
        "h",
        "H"
    ],
    "KE": [
        "hB",
        "hb",
        "H",
        "h"
    ],
    "MM": [
        "hB",
        "hb",
        "H",
        "h"
    ],
    "TZ": [
        "hB",
        "hb",
        "H",
        "h"
    ],
    "UG": [
        "hB",
        "hb",
        "H",
        "h"
    ]
};


/***/ }),

/***/ "./node_modules/@formatjs/icu-messageformat-parser/lib/types.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@formatjs/icu-messageformat-parser/lib/types.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SKELETON_TYPE": () => (/* binding */ SKELETON_TYPE),
/* harmony export */   "TYPE": () => (/* binding */ TYPE),
/* harmony export */   "createLiteralElement": () => (/* binding */ createLiteralElement),
/* harmony export */   "createNumberElement": () => (/* binding */ createNumberElement),
/* harmony export */   "isArgumentElement": () => (/* binding */ isArgumentElement),
/* harmony export */   "isDateElement": () => (/* binding */ isDateElement),
/* harmony export */   "isDateTimeSkeleton": () => (/* binding */ isDateTimeSkeleton),
/* harmony export */   "isLiteralElement": () => (/* binding */ isLiteralElement),
/* harmony export */   "isNumberElement": () => (/* binding */ isNumberElement),
/* harmony export */   "isNumberSkeleton": () => (/* binding */ isNumberSkeleton),
/* harmony export */   "isPluralElement": () => (/* binding */ isPluralElement),
/* harmony export */   "isPoundElement": () => (/* binding */ isPoundElement),
/* harmony export */   "isSelectElement": () => (/* binding */ isSelectElement),
/* harmony export */   "isTagElement": () => (/* binding */ isTagElement),
/* harmony export */   "isTimeElement": () => (/* binding */ isTimeElement)
/* harmony export */ });
var TYPE;
(function (TYPE) {
    /**
     * Raw text
     */
    TYPE[TYPE["literal"] = 0] = "literal";
    /**
     * Variable w/o any format, e.g `var` in `this is a {var}`
     */
    TYPE[TYPE["argument"] = 1] = "argument";
    /**
     * Variable w/ number format
     */
    TYPE[TYPE["number"] = 2] = "number";
    /**
     * Variable w/ date format
     */
    TYPE[TYPE["date"] = 3] = "date";
    /**
     * Variable w/ time format
     */
    TYPE[TYPE["time"] = 4] = "time";
    /**
     * Variable w/ select format
     */
    TYPE[TYPE["select"] = 5] = "select";
    /**
     * Variable w/ plural format
     */
    TYPE[TYPE["plural"] = 6] = "plural";
    /**
     * Only possible within plural argument.
     * This is the `#` symbol that will be substituted with the count.
     */
    TYPE[TYPE["pound"] = 7] = "pound";
    /**
     * XML-like tag
     */
    TYPE[TYPE["tag"] = 8] = "tag";
})(TYPE || (TYPE = {}));
var SKELETON_TYPE;
(function (SKELETON_TYPE) {
    SKELETON_TYPE[SKELETON_TYPE["number"] = 0] = "number";
    SKELETON_TYPE[SKELETON_TYPE["dateTime"] = 1] = "dateTime";
})(SKELETON_TYPE || (SKELETON_TYPE = {}));
/**
 * Type Guards
 */
function isLiteralElement(el) {
    return el.type === TYPE.literal;
}
function isArgumentElement(el) {
    return el.type === TYPE.argument;
}
function isNumberElement(el) {
    return el.type === TYPE.number;
}
function isDateElement(el) {
    return el.type === TYPE.date;
}
function isTimeElement(el) {
    return el.type === TYPE.time;
}
function isSelectElement(el) {
    return el.type === TYPE.select;
}
function isPluralElement(el) {
    return el.type === TYPE.plural;
}
function isPoundElement(el) {
    return el.type === TYPE.pound;
}
function isTagElement(el) {
    return el.type === TYPE.tag;
}
function isNumberSkeleton(el) {
    return !!(el && typeof el === 'object' && el.type === SKELETON_TYPE.number);
}
function isDateTimeSkeleton(el) {
    return !!(el && typeof el === 'object' && el.type === SKELETON_TYPE.dateTime);
}
function createLiteralElement(value) {
    return {
        type: TYPE.literal,
        value: value,
    };
}
function createNumberElement(value, style) {
    return {
        type: TYPE.number,
        value: value,
        style: style,
    };
}


/***/ }),

/***/ "./node_modules/@formatjs/icu-skeleton-parser/lib/date-time.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@formatjs/icu-skeleton-parser/lib/date-time.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "parseDateTimeSkeleton": () => (/* binding */ parseDateTimeSkeleton)
/* harmony export */ });
/**
 * https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
 * Credit: https://github.com/caridy/intl-datetimeformat-pattern/blob/master/index.js
 * with some tweaks
 */
var DATE_TIME_REGEX = /(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
/**
 * Parse Date time skeleton into Intl.DateTimeFormatOptions
 * Ref: https://unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
 * @public
 * @param skeleton skeleton string
 */
function parseDateTimeSkeleton(skeleton) {
    var result = {};
    skeleton.replace(DATE_TIME_REGEX, function (match) {
        var len = match.length;
        switch (match[0]) {
            // Era
            case 'G':
                result.era = len === 4 ? 'long' : len === 5 ? 'narrow' : 'short';
                break;
            // Year
            case 'y':
                result.year = len === 2 ? '2-digit' : 'numeric';
                break;
            case 'Y':
            case 'u':
            case 'U':
            case 'r':
                throw new RangeError('`Y/u/U/r` (year) patterns are not supported, use `y` instead');
            // Quarter
            case 'q':
            case 'Q':
                throw new RangeError('`q/Q` (quarter) patterns are not supported');
            // Month
            case 'M':
            case 'L':
                result.month = ['numeric', '2-digit', 'short', 'long', 'narrow'][len - 1];
                break;
            // Week
            case 'w':
            case 'W':
                throw new RangeError('`w/W` (week) patterns are not supported');
            case 'd':
                result.day = ['numeric', '2-digit'][len - 1];
                break;
            case 'D':
            case 'F':
            case 'g':
                throw new RangeError('`D/F/g` (day) patterns are not supported, use `d` instead');
            // Weekday
            case 'E':
                result.weekday = len === 4 ? 'short' : len === 5 ? 'narrow' : 'short';
                break;
            case 'e':
                if (len < 4) {
                    throw new RangeError('`e..eee` (weekday) patterns are not supported');
                }
                result.weekday = ['short', 'long', 'narrow', 'short'][len - 4];
                break;
            case 'c':
                if (len < 4) {
                    throw new RangeError('`c..ccc` (weekday) patterns are not supported');
                }
                result.weekday = ['short', 'long', 'narrow', 'short'][len - 4];
                break;
            // Period
            case 'a': // AM, PM
                result.hour12 = true;
                break;
            case 'b': // am, pm, noon, midnight
            case 'B': // flexible day periods
                throw new RangeError('`b/B` (period) patterns are not supported, use `a` instead');
            // Hour
            case 'h':
                result.hourCycle = 'h12';
                result.hour = ['numeric', '2-digit'][len - 1];
                break;
            case 'H':
                result.hourCycle = 'h23';
                result.hour = ['numeric', '2-digit'][len - 1];
                break;
            case 'K':
                result.hourCycle = 'h11';
                result.hour = ['numeric', '2-digit'][len - 1];
                break;
            case 'k':
                result.hourCycle = 'h24';
                result.hour = ['numeric', '2-digit'][len - 1];
                break;
            case 'j':
            case 'J':
            case 'C':
                throw new RangeError('`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead');
            // Minute
            case 'm':
                result.minute = ['numeric', '2-digit'][len - 1];
                break;
            // Second
            case 's':
                result.second = ['numeric', '2-digit'][len - 1];
                break;
            case 'S':
            case 'A':
                throw new RangeError('`S/A` (second) patterns are not supported, use `s` instead');
            // Zone
            case 'z': // 1..3, 4: specific non-location format
                result.timeZoneName = len < 4 ? 'short' : 'long';
                break;
            case 'Z': // 1..3, 4, 5: The ISO8601 varios formats
            case 'O': // 1, 4: miliseconds in day short, long
            case 'v': // 1, 4: generic non-location format
            case 'V': // 1, 2, 3, 4: time zone ID or city
            case 'X': // 1, 2, 3, 4: The ISO8601 varios formats
            case 'x': // 1, 2, 3, 4: The ISO8601 varios formats
                throw new RangeError('`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead');
        }
        return '';
    });
    return result;
}


/***/ }),

/***/ "./node_modules/@formatjs/icu-skeleton-parser/lib/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@formatjs/icu-skeleton-parser/lib/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "parseDateTimeSkeleton": () => (/* reexport safe */ _date_time__WEBPACK_IMPORTED_MODULE_0__.parseDateTimeSkeleton),
/* harmony export */   "parseNumberSkeleton": () => (/* reexport safe */ _number__WEBPACK_IMPORTED_MODULE_1__.parseNumberSkeleton),
/* harmony export */   "parseNumberSkeletonFromString": () => (/* reexport safe */ _number__WEBPACK_IMPORTED_MODULE_1__.parseNumberSkeletonFromString)
/* harmony export */ });
/* harmony import */ var _date_time__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./date-time */ "./node_modules/@formatjs/icu-skeleton-parser/lib/date-time.js");
/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./number */ "./node_modules/@formatjs/icu-skeleton-parser/lib/number.js");




/***/ }),

/***/ "./node_modules/@formatjs/icu-skeleton-parser/lib/number.js":
/*!******************************************************************!*\
  !*** ./node_modules/@formatjs/icu-skeleton-parser/lib/number.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "parseNumberSkeleton": () => (/* binding */ parseNumberSkeleton),
/* harmony export */   "parseNumberSkeletonFromString": () => (/* binding */ parseNumberSkeletonFromString)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _regex_generated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./regex.generated */ "./node_modules/@formatjs/icu-skeleton-parser/lib/regex.generated.js");


function parseNumberSkeletonFromString(skeleton) {
    if (skeleton.length === 0) {
        throw new Error('Number skeleton cannot be empty');
    }
    // Parse the skeleton
    var stringTokens = skeleton
        .split(_regex_generated__WEBPACK_IMPORTED_MODULE_0__.WHITE_SPACE_REGEX)
        .filter(function (x) { return x.length > 0; });
    var tokens = [];
    for (var _i = 0, stringTokens_1 = stringTokens; _i < stringTokens_1.length; _i++) {
        var stringToken = stringTokens_1[_i];
        var stemAndOptions = stringToken.split('/');
        if (stemAndOptions.length === 0) {
            throw new Error('Invalid number skeleton');
        }
        var stem = stemAndOptions[0], options = stemAndOptions.slice(1);
        for (var _a = 0, options_1 = options; _a < options_1.length; _a++) {
            var option = options_1[_a];
            if (option.length === 0) {
                throw new Error('Invalid number skeleton');
            }
        }
        tokens.push({ stem: stem, options: options });
    }
    return tokens;
}
function icuUnitToEcma(unit) {
    return unit.replace(/^(.*?)-/, '');
}
var FRACTION_PRECISION_REGEX = /^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g;
var SIGNIFICANT_PRECISION_REGEX = /^(@+)?(\+|#+)?[rs]?$/g;
var INTEGER_WIDTH_REGEX = /(\*)(0+)|(#+)(0+)|(0+)/g;
var CONCISE_INTEGER_WIDTH_REGEX = /^(0+)$/;
function parseSignificantPrecision(str) {
    var result = {};
    if (str[str.length - 1] === 'r') {
        result.roundingPriority = 'morePrecision';
    }
    else if (str[str.length - 1] === 's') {
        result.roundingPriority = 'lessPrecision';
    }
    str.replace(SIGNIFICANT_PRECISION_REGEX, function (_, g1, g2) {
        // @@@ case
        if (typeof g2 !== 'string') {
            result.minimumSignificantDigits = g1.length;
            result.maximumSignificantDigits = g1.length;
        }
        // @@@+ case
        else if (g2 === '+') {
            result.minimumSignificantDigits = g1.length;
        }
        // .### case
        else if (g1[0] === '#') {
            result.maximumSignificantDigits = g1.length;
        }
        // .@@## or .@@@ case
        else {
            result.minimumSignificantDigits = g1.length;
            result.maximumSignificantDigits =
                g1.length + (typeof g2 === 'string' ? g2.length : 0);
        }
        return '';
    });
    return result;
}
function parseSign(str) {
    switch (str) {
        case 'sign-auto':
            return {
                signDisplay: 'auto',
            };
        case 'sign-accounting':
        case '()':
            return {
                currencySign: 'accounting',
            };
        case 'sign-always':
        case '+!':
            return {
                signDisplay: 'always',
            };
        case 'sign-accounting-always':
        case '()!':
            return {
                signDisplay: 'always',
                currencySign: 'accounting',
            };
        case 'sign-except-zero':
        case '+?':
            return {
                signDisplay: 'exceptZero',
            };
        case 'sign-accounting-except-zero':
        case '()?':
            return {
                signDisplay: 'exceptZero',
                currencySign: 'accounting',
            };
        case 'sign-never':
        case '+_':
            return {
                signDisplay: 'never',
            };
    }
}
function parseConciseScientificAndEngineeringStem(stem) {
    // Engineering
    var result;
    if (stem[0] === 'E' && stem[1] === 'E') {
        result = {
            notation: 'engineering',
        };
        stem = stem.slice(2);
    }
    else if (stem[0] === 'E') {
        result = {
            notation: 'scientific',
        };
        stem = stem.slice(1);
    }
    if (result) {
        var signDisplay = stem.slice(0, 2);
        if (signDisplay === '+!') {
            result.signDisplay = 'always';
            stem = stem.slice(2);
        }
        else if (signDisplay === '+?') {
            result.signDisplay = 'exceptZero';
            stem = stem.slice(2);
        }
        if (!CONCISE_INTEGER_WIDTH_REGEX.test(stem)) {
            throw new Error('Malformed concise eng/scientific notation');
        }
        result.minimumIntegerDigits = stem.length;
    }
    return result;
}
function parseNotationOptions(opt) {
    var result = {};
    var signOpts = parseSign(opt);
    if (signOpts) {
        return signOpts;
    }
    return result;
}
/**
 * https://github.com/unicode-org/icu/blob/master/docs/userguide/format_parse/numbers/skeletons.md#skeleton-stems-and-options
 */
function parseNumberSkeleton(tokens) {
    var result = {};
    for (var _i = 0, tokens_1 = tokens; _i < tokens_1.length; _i++) {
        var token = tokens_1[_i];
        switch (token.stem) {
            case 'percent':
            case '%':
                result.style = 'percent';
                continue;
            case '%x100':
                result.style = 'percent';
                result.scale = 100;
                continue;
            case 'currency':
                result.style = 'currency';
                result.currency = token.options[0];
                continue;
            case 'group-off':
            case ',_':
                result.useGrouping = false;
                continue;
            case 'precision-integer':
            case '.':
                result.maximumFractionDigits = 0;
                continue;
            case 'measure-unit':
            case 'unit':
                result.style = 'unit';
                result.unit = icuUnitToEcma(token.options[0]);
                continue;
            case 'compact-short':
            case 'K':
                result.notation = 'compact';
                result.compactDisplay = 'short';
                continue;
            case 'compact-long':
            case 'KK':
                result.notation = 'compact';
                result.compactDisplay = 'long';
                continue;
            case 'scientific':
                result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), { notation: 'scientific' }), token.options.reduce(function (all, opt) { return ((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, all), parseNotationOptions(opt))); }, {}));
                continue;
            case 'engineering':
                result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), { notation: 'engineering' }), token.options.reduce(function (all, opt) { return ((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, all), parseNotationOptions(opt))); }, {}));
                continue;
            case 'notation-simple':
                result.notation = 'standard';
                continue;
            // https://github.com/unicode-org/icu/blob/master/icu4c/source/i18n/unicode/unumberformatter.h
            case 'unit-width-narrow':
                result.currencyDisplay = 'narrowSymbol';
                result.unitDisplay = 'narrow';
                continue;
            case 'unit-width-short':
                result.currencyDisplay = 'code';
                result.unitDisplay = 'short';
                continue;
            case 'unit-width-full-name':
                result.currencyDisplay = 'name';
                result.unitDisplay = 'long';
                continue;
            case 'unit-width-iso-code':
                result.currencyDisplay = 'symbol';
                continue;
            case 'scale':
                result.scale = parseFloat(token.options[0]);
                continue;
            // https://unicode-org.github.io/icu/userguide/format_parse/numbers/skeletons.html#integer-width
            case 'integer-width':
                if (token.options.length > 1) {
                    throw new RangeError('integer-width stems only accept a single optional option');
                }
                token.options[0].replace(INTEGER_WIDTH_REGEX, function (_, g1, g2, g3, g4, g5) {
                    if (g1) {
                        result.minimumIntegerDigits = g2.length;
                    }
                    else if (g3 && g4) {
                        throw new Error('We currently do not support maximum integer digits');
                    }
                    else if (g5) {
                        throw new Error('We currently do not support exact integer digits');
                    }
                    return '';
                });
                continue;
        }
        // https://unicode-org.github.io/icu/userguide/format_parse/numbers/skeletons.html#integer-width
        if (CONCISE_INTEGER_WIDTH_REGEX.test(token.stem)) {
            result.minimumIntegerDigits = token.stem.length;
            continue;
        }
        if (FRACTION_PRECISION_REGEX.test(token.stem)) {
            // Precision
            // https://unicode-org.github.io/icu/userguide/format_parse/numbers/skeletons.html#fraction-precision
            // precision-integer case
            if (token.options.length > 1) {
                throw new RangeError('Fraction-precision stems only accept a single optional option');
            }
            token.stem.replace(FRACTION_PRECISION_REGEX, function (_, g1, g2, g3, g4, g5) {
                // .000* case (before ICU67 it was .000+)
                if (g2 === '*') {
                    result.minimumFractionDigits = g1.length;
                }
                // .### case
                else if (g3 && g3[0] === '#') {
                    result.maximumFractionDigits = g3.length;
                }
                // .00## case
                else if (g4 && g5) {
                    result.minimumFractionDigits = g4.length;
                    result.maximumFractionDigits = g4.length + g5.length;
                }
                else {
                    result.minimumFractionDigits = g1.length;
                    result.maximumFractionDigits = g1.length;
                }
                return '';
            });
            var opt = token.options[0];
            // https://unicode-org.github.io/icu/userguide/format_parse/numbers/skeletons.html#trailing-zero-display
            if (opt === 'w') {
                result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), { trailingZeroDisplay: 'stripIfInteger' });
            }
            else if (opt) {
                result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), parseSignificantPrecision(opt));
            }
            continue;
        }
        // https://unicode-org.github.io/icu/userguide/format_parse/numbers/skeletons.html#significant-digits-precision
        if (SIGNIFICANT_PRECISION_REGEX.test(token.stem)) {
            result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), parseSignificantPrecision(token.stem));
            continue;
        }
        var signOpts = parseSign(token.stem);
        if (signOpts) {
            result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), signOpts);
        }
        var conciseScientificAndEngineeringOpts = parseConciseScientificAndEngineeringStem(token.stem);
        if (conciseScientificAndEngineeringOpts) {
            result = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, result), conciseScientificAndEngineeringOpts);
        }
    }
    return result;
}


/***/ }),

/***/ "./node_modules/@formatjs/icu-skeleton-parser/lib/regex.generated.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@formatjs/icu-skeleton-parser/lib/regex.generated.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WHITE_SPACE_REGEX": () => (/* binding */ WHITE_SPACE_REGEX)
/* harmony export */ });
// @generated from regex-gen.ts
var WHITE_SPACE_REGEX = /[\t-\r \x85\u200E\u200F\u2028\u2029]/i;


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/create-intl.js":
/*!************************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/create-intl.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createIntl": () => (/* binding */ createIntl)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");
/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./number */ "./node_modules/@formatjs/intl/lib/src/number.js");
/* harmony import */ var _relativeTime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./relativeTime */ "./node_modules/@formatjs/intl/lib/src/relativeTime.js");
/* harmony import */ var _dateTime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dateTime */ "./node_modules/@formatjs/intl/lib/src/dateTime.js");
/* harmony import */ var _plural__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./plural */ "./node_modules/@formatjs/intl/lib/src/plural.js");
/* harmony import */ var _message__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./message */ "./node_modules/@formatjs/intl/lib/src/message.js");
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./list */ "./node_modules/@formatjs/intl/lib/src/list.js");
/* harmony import */ var _displayName__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./displayName */ "./node_modules/@formatjs/intl/lib/src/displayName.js");










function messagesContainString(messages) {
    var firstMessage = messages ? messages[Object.keys(messages)[0]] : undefined;
    return typeof firstMessage === 'string';
}
function verifyConfigMessages(config) {
    if (config.onWarn &&
        config.defaultRichTextElements &&
        messagesContainString(config.messages || {})) {
        config.onWarn("[@formatjs/intl] \"defaultRichTextElements\" was specified but \"message\" was not pre-compiled. \nPlease consider using \"@formatjs/cli\" to pre-compile your messages for performance.\nFor more details see https://formatjs.io/docs/getting-started/message-distribution");
    }
}
/**
 * Create intl object
 * @param config intl config
 * @param cache cache for formatter instances to prevent memory leak
 */
function createIntl(config, cache) {
    var formatters = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.createFormatters)(cache);
    var resolvedConfig = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, _utils__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_INTL_CONFIG), config);
    var locale = resolvedConfig.locale, defaultLocale = resolvedConfig.defaultLocale, onError = resolvedConfig.onError;
    if (!locale) {
        if (onError) {
            onError(new _error__WEBPACK_IMPORTED_MODULE_2__.InvalidConfigError("\"locale\" was not configured, using \"".concat(defaultLocale, "\" as fallback. See https://formatjs.io/docs/react-intl/api#intlshape for more details")));
        }
        // Since there's no registered locale data for `locale`, this will
        // fallback to the `defaultLocale` to make sure things can render.
        // The `messages` are overridden to the `defaultProps` empty object
        // to maintain referential equality across re-renders. It's assumed
        // each <FormattedMessage> contains a `defaultMessage` prop.
        resolvedConfig.locale = resolvedConfig.defaultLocale || 'en';
    }
    else if (!Intl.NumberFormat.supportedLocalesOf(locale).length && onError) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_2__.MissingDataError("Missing locale data for locale: \"".concat(locale, "\" in Intl.NumberFormat. Using default locale: \"").concat(defaultLocale, "\" as fallback. See https://formatjs.io/docs/react-intl#runtime-requirements for more details")));
    }
    else if (!Intl.DateTimeFormat.supportedLocalesOf(locale).length &&
        onError) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_2__.MissingDataError("Missing locale data for locale: \"".concat(locale, "\" in Intl.DateTimeFormat. Using default locale: \"").concat(defaultLocale, "\" as fallback. See https://formatjs.io/docs/react-intl#runtime-requirements for more details")));
    }
    verifyConfigMessages(resolvedConfig);
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, resolvedConfig), { formatters: formatters, formatNumber: _number__WEBPACK_IMPORTED_MODULE_3__.formatNumber.bind(null, resolvedConfig, formatters.getNumberFormat), formatNumberToParts: _number__WEBPACK_IMPORTED_MODULE_3__.formatNumberToParts.bind(null, resolvedConfig, formatters.getNumberFormat), formatRelativeTime: _relativeTime__WEBPACK_IMPORTED_MODULE_4__.formatRelativeTime.bind(null, resolvedConfig, formatters.getRelativeTimeFormat), formatDate: _dateTime__WEBPACK_IMPORTED_MODULE_5__.formatDate.bind(null, resolvedConfig, formatters.getDateTimeFormat), formatDateToParts: _dateTime__WEBPACK_IMPORTED_MODULE_5__.formatDateToParts.bind(null, resolvedConfig, formatters.getDateTimeFormat), formatTime: _dateTime__WEBPACK_IMPORTED_MODULE_5__.formatTime.bind(null, resolvedConfig, formatters.getDateTimeFormat), formatDateTimeRange: _dateTime__WEBPACK_IMPORTED_MODULE_5__.formatDateTimeRange.bind(null, resolvedConfig, formatters.getDateTimeFormat), formatTimeToParts: _dateTime__WEBPACK_IMPORTED_MODULE_5__.formatTimeToParts.bind(null, resolvedConfig, formatters.getDateTimeFormat), formatPlural: _plural__WEBPACK_IMPORTED_MODULE_6__.formatPlural.bind(null, resolvedConfig, formatters.getPluralRules), 
        // @ts-expect-error TODO: will get to this later
        formatMessage: _message__WEBPACK_IMPORTED_MODULE_7__.formatMessage.bind(null, resolvedConfig, formatters), 
        // @ts-expect-error TODO: will get to this later
        $t: _message__WEBPACK_IMPORTED_MODULE_7__.formatMessage.bind(null, resolvedConfig, formatters), formatList: _list__WEBPACK_IMPORTED_MODULE_8__.formatList.bind(null, resolvedConfig, formatters.getListFormat), formatListToParts: _list__WEBPACK_IMPORTED_MODULE_8__.formatListToParts.bind(null, resolvedConfig, formatters.getListFormat), formatDisplayName: _displayName__WEBPACK_IMPORTED_MODULE_9__.formatDisplayName.bind(null, resolvedConfig, formatters.getDisplayNames) });
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/dateTime.js":
/*!*********************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/dateTime.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatDate": () => (/* binding */ formatDate),
/* harmony export */   "formatDateTimeRange": () => (/* binding */ formatDateTimeRange),
/* harmony export */   "formatDateToParts": () => (/* binding */ formatDateToParts),
/* harmony export */   "formatTime": () => (/* binding */ formatTime),
/* harmony export */   "formatTimeToParts": () => (/* binding */ formatTimeToParts),
/* harmony export */   "getFormatter": () => (/* binding */ getFormatter)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");



var DATE_TIME_FORMAT_OPTIONS = [
    'formatMatcher',
    'timeZone',
    'hour12',
    'weekday',
    'era',
    'year',
    'month',
    'day',
    'hour',
    'minute',
    'second',
    'timeZoneName',
    'hourCycle',
    'dateStyle',
    'timeStyle',
    'calendar',
    // 'dayPeriod',
    'numberingSystem',
    'fractionalSecondDigits',
];
function getFormatter(_a, type, getDateTimeFormat, options) {
    var locale = _a.locale, formats = _a.formats, onError = _a.onError, timeZone = _a.timeZone;
    if (options === void 0) { options = {}; }
    var format = options.format;
    var defaults = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, (timeZone && { timeZone: timeZone })), (format && (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getNamedFormat)(formats, type, format, onError)));
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.filterProps)(options, DATE_TIME_FORMAT_OPTIONS, defaults);
    if (type === 'time' &&
        !filteredOptions.hour &&
        !filteredOptions.minute &&
        !filteredOptions.second &&
        !filteredOptions.timeStyle &&
        !filteredOptions.dateStyle) {
        // Add default formatting options if hour, minute, or second isn't defined.
        filteredOptions = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, filteredOptions), { hour: 'numeric', minute: 'numeric' });
    }
    return getDateTimeFormat(locale, filteredOptions);
}
function formatDate(config, getDateTimeFormat) {
    var _a = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        _a[_i - 2] = arguments[_i];
    }
    var value = _a[0], _b = _a[1], options = _b === void 0 ? {} : _b;
    var date = typeof value === 'string' ? new Date(value || 0) : value;
    try {
        return getFormatter(config, 'date', getDateTimeFormat, options).format(date);
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting date.', e));
    }
    return String(date);
}
function formatTime(config, getDateTimeFormat) {
    var _a = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        _a[_i - 2] = arguments[_i];
    }
    var value = _a[0], _b = _a[1], options = _b === void 0 ? {} : _b;
    var date = typeof value === 'string' ? new Date(value || 0) : value;
    try {
        return getFormatter(config, 'time', getDateTimeFormat, options).format(date);
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting time.', e));
    }
    return String(date);
}
function formatDateTimeRange(config, getDateTimeFormat) {
    var _a = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        _a[_i - 2] = arguments[_i];
    }
    var from = _a[0], to = _a[1], _b = _a[2], options = _b === void 0 ? {} : _b;
    var timeZone = config.timeZone, locale = config.locale, onError = config.onError;
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.filterProps)(options, DATE_TIME_FORMAT_OPTIONS, timeZone ? { timeZone: timeZone } : {});
    try {
        return getDateTimeFormat(locale, filteredOptions).formatRange(from, to);
    }
    catch (e) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting date time range.', e));
    }
    return String(from);
}
function formatDateToParts(config, getDateTimeFormat) {
    var _a = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        _a[_i - 2] = arguments[_i];
    }
    var value = _a[0], _b = _a[1], options = _b === void 0 ? {} : _b;
    var date = typeof value === 'string' ? new Date(value || 0) : value;
    try {
        return getFormatter(config, 'date', getDateTimeFormat, options).formatToParts(date); // TODO: remove this when https://github.com/microsoft/TypeScript/pull/50402 is merged
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting date.', e));
    }
    return [];
}
function formatTimeToParts(config, getDateTimeFormat) {
    var _a = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        _a[_i - 2] = arguments[_i];
    }
    var value = _a[0], _b = _a[1], options = _b === void 0 ? {} : _b;
    var date = typeof value === 'string' ? new Date(value || 0) : value;
    try {
        return getFormatter(config, 'time', getDateTimeFormat, options).formatToParts(date); // TODO: remove this when https://github.com/microsoft/TypeScript/pull/50402 is merged
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting time.', e));
    }
    return [];
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/displayName.js":
/*!************************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/displayName.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatDisplayName": () => (/* binding */ formatDisplayName)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/error.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");



var DISPLAY_NAMES_OPTONS = [
    'style',
    'type',
    'fallback',
    'languageDisplay',
];
function formatDisplayName(_a, getDisplayNames, value, options) {
    var locale = _a.locale, onError = _a.onError;
    var DisplayNames = Intl.DisplayNames;
    if (!DisplayNames) {
        onError(new intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.FormatError("Intl.DisplayNames is not available in this environment.\nTry polyfilling it using \"@formatjs/intl-displaynames\"\n", intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.ErrorCode.MISSING_INTL_API));
    }
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.filterProps)(options, DISPLAY_NAMES_OPTONS);
    try {
        return getDisplayNames(locale, filteredOptions).of(value);
    }
    catch (e) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlError(_error__WEBPACK_IMPORTED_MODULE_2__.IntlErrorCode.FORMAT_ERROR, 'Error formatting display name.', e));
    }
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/error.js":
/*!******************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/error.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntlError": () => (/* binding */ IntlError),
/* harmony export */   "IntlErrorCode": () => (/* binding */ IntlErrorCode),
/* harmony export */   "IntlFormatError": () => (/* binding */ IntlFormatError),
/* harmony export */   "InvalidConfigError": () => (/* binding */ InvalidConfigError),
/* harmony export */   "MessageFormatError": () => (/* binding */ MessageFormatError),
/* harmony export */   "MissingDataError": () => (/* binding */ MissingDataError),
/* harmony export */   "MissingTranslationError": () => (/* binding */ MissingTranslationError),
/* harmony export */   "UnsupportedFormatterError": () => (/* binding */ UnsupportedFormatterError)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

var IntlErrorCode;
(function (IntlErrorCode) {
    IntlErrorCode["FORMAT_ERROR"] = "FORMAT_ERROR";
    IntlErrorCode["UNSUPPORTED_FORMATTER"] = "UNSUPPORTED_FORMATTER";
    IntlErrorCode["INVALID_CONFIG"] = "INVALID_CONFIG";
    IntlErrorCode["MISSING_DATA"] = "MISSING_DATA";
    IntlErrorCode["MISSING_TRANSLATION"] = "MISSING_TRANSLATION";
})(IntlErrorCode || (IntlErrorCode = {}));
var IntlError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(IntlError, _super);
    function IntlError(code, message, exception) {
        var _this = this;
        var err = exception
            ? exception instanceof Error
                ? exception
                : new Error(String(exception))
            : undefined;
        _this = _super.call(this, "[@formatjs/intl Error ".concat(code, "] ").concat(message, "\n").concat(err ? "\n".concat(err.message, "\n").concat(err.stack) : '')) || this;
        _this.code = code;
        // @ts-ignore just so we don't need to declare dep on @types/node
        if (typeof Error.captureStackTrace === 'function') {
            // @ts-ignore just so we don't need to declare dep on @types/node
            Error.captureStackTrace(_this, IntlError);
        }
        return _this;
    }
    return IntlError;
}(Error));

var UnsupportedFormatterError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(UnsupportedFormatterError, _super);
    function UnsupportedFormatterError(message, exception) {
        return _super.call(this, IntlErrorCode.UNSUPPORTED_FORMATTER, message, exception) || this;
    }
    return UnsupportedFormatterError;
}(IntlError));

var InvalidConfigError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(InvalidConfigError, _super);
    function InvalidConfigError(message, exception) {
        return _super.call(this, IntlErrorCode.INVALID_CONFIG, message, exception) || this;
    }
    return InvalidConfigError;
}(IntlError));

var MissingDataError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MissingDataError, _super);
    function MissingDataError(message, exception) {
        return _super.call(this, IntlErrorCode.MISSING_DATA, message, exception) || this;
    }
    return MissingDataError;
}(IntlError));

var IntlFormatError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(IntlFormatError, _super);
    function IntlFormatError(message, locale, exception) {
        return _super.call(this, IntlErrorCode.FORMAT_ERROR, "".concat(message, "\nLocale: ").concat(locale, "\n"), exception) || this;
    }
    return IntlFormatError;
}(IntlError));

var MessageFormatError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MessageFormatError, _super);
    function MessageFormatError(message, locale, descriptor, exception) {
        var _this = _super.call(this, "".concat(message, "\nMessageID: ").concat(descriptor === null || descriptor === void 0 ? void 0 : descriptor.id, "\nDefault Message: ").concat(descriptor === null || descriptor === void 0 ? void 0 : descriptor.defaultMessage, "\nDescription: ").concat(descriptor === null || descriptor === void 0 ? void 0 : descriptor.description, "\n"), locale, exception) || this;
        _this.descriptor = descriptor;
        return _this;
    }
    return MessageFormatError;
}(IntlFormatError));

var MissingTranslationError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MissingTranslationError, _super);
    function MissingTranslationError(descriptor, locale) {
        var _this = _super.call(this, IntlErrorCode.MISSING_TRANSLATION, "Missing message: \"".concat(descriptor.id, "\" for locale \"").concat(locale, "\", using ").concat(descriptor.defaultMessage
            ? "default message (".concat(typeof descriptor.defaultMessage === 'string'
                ? descriptor.defaultMessage
                : descriptor.defaultMessage
                    .map(function (e) { var _a; return (_a = e.value) !== null && _a !== void 0 ? _a : JSON.stringify(e); })
                    .join(), ")")
            : 'id', " as fallback.")) || this;
        _this.descriptor = descriptor;
        return _this;
    }
    return MissingTranslationError;
}(IntlError));



/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/list.js":
/*!*****************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/list.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatList": () => (/* binding */ formatList),
/* harmony export */   "formatListToParts": () => (/* binding */ formatListToParts)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/error.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");




var LIST_FORMAT_OPTIONS = [
    'type',
    'style',
];
var now = Date.now();
function generateToken(i) {
    return "".concat(now, "_").concat(i, "_").concat(now);
}
function formatList(opts, getListFormat, values, options) {
    if (options === void 0) { options = {}; }
    var results = formatListToParts(opts, getListFormat, values, options).reduce(function (all, el) {
        var val = el.value;
        if (typeof val !== 'string') {
            all.push(val);
        }
        else if (typeof all[all.length - 1] === 'string') {
            all[all.length - 1] += val;
        }
        else {
            all.push(val);
        }
        return all;
    }, []);
    return results.length === 1 ? results[0] : results.length === 0 ? '' : results;
}
function formatListToParts(_a, getListFormat, values, options) {
    var locale = _a.locale, onError = _a.onError;
    if (options === void 0) { options = {}; }
    var ListFormat = Intl.ListFormat;
    if (!ListFormat) {
        onError(new intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.FormatError("Intl.ListFormat is not available in this environment.\nTry polyfilling it using \"@formatjs/intl-listformat\"\n", intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.ErrorCode.MISSING_INTL_API));
    }
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.filterProps)(options, LIST_FORMAT_OPTIONS);
    try {
        var richValues_1 = {};
        var serializedValues = values.map(function (v, i) {
            if (typeof v === 'object') {
                var id = generateToken(i);
                richValues_1[id] = v;
                return id;
            }
            return String(v);
        });
        return getListFormat(locale, filteredOptions)
            .formatToParts(serializedValues)
            .map(function (part) {
            return part.type === 'literal'
                ? part
                : (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_2__.__assign)({}, part), { value: richValues_1[part.value] || part.value });
        });
    }
    catch (e) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_3__.IntlError(_error__WEBPACK_IMPORTED_MODULE_3__.IntlErrorCode.FORMAT_ERROR, 'Error formatting list.', e));
    }
    // @ts-ignore
    return values;
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/message.js":
/*!********************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/message.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatMessage": () => (/* binding */ formatMessage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _formatjs_ecma402_abstract__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @formatjs/ecma402-abstract */ "./node_modules/@formatjs/ecma402-abstract/lib/utils.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/core.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");
/* harmony import */ var _formatjs_icu_messageformat_parser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @formatjs/icu-messageformat-parser */ "./node_modules/@formatjs/icu-messageformat-parser/lib/index.js");





function setTimeZoneInOptions(opts, timeZone) {
    return Object.keys(opts).reduce(function (all, k) {
        all[k] = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({ timeZone: timeZone }, opts[k]);
        return all;
    }, {});
}
function deepMergeOptions(opts1, opts2) {
    var keys = Object.keys((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, opts1), opts2));
    return keys.reduce(function (all, k) {
        all[k] = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, (opts1[k] || {})), (opts2[k] || {}));
        return all;
    }, {});
}
function deepMergeFormatsAndSetTimeZone(f1, timeZone) {
    if (!timeZone) {
        return f1;
    }
    var mfFormats = intl_messageformat__WEBPACK_IMPORTED_MODULE_2__.IntlMessageFormat.formats;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, mfFormats), f1), { date: deepMergeOptions(setTimeZoneInOptions(mfFormats.date, timeZone), setTimeZoneInOptions(f1.date || {}, timeZone)), time: deepMergeOptions(setTimeZoneInOptions(mfFormats.time, timeZone), setTimeZoneInOptions(f1.time || {}, timeZone)) });
}
var formatMessage = function (_a, state, messageDescriptor, values, opts) {
    var locale = _a.locale, formats = _a.formats, messages = _a.messages, defaultLocale = _a.defaultLocale, defaultFormats = _a.defaultFormats, fallbackOnEmptyString = _a.fallbackOnEmptyString, onError = _a.onError, timeZone = _a.timeZone, defaultRichTextElements = _a.defaultRichTextElements;
    if (messageDescriptor === void 0) { messageDescriptor = { id: '' }; }
    var msgId = messageDescriptor.id, defaultMessage = messageDescriptor.defaultMessage;
    // `id` is a required field of a Message Descriptor.
    (0,_formatjs_ecma402_abstract__WEBPACK_IMPORTED_MODULE_3__.invariant)(!!msgId, "[@formatjs/intl] An `id` must be provided to format a message. You can either:\n1. Configure your build toolchain with [babel-plugin-formatjs](https://formatjs.io/docs/tooling/babel-plugin)\nor [@formatjs/ts-transformer](https://formatjs.io/docs/tooling/ts-transformer) OR\n2. Configure your `eslint` config to include [eslint-plugin-formatjs](https://formatjs.io/docs/tooling/linter#enforce-id)\nto autofix this issue");
    var id = String(msgId);
    var message = 
    // In case messages is Object.create(null)
    // e.g import('foo.json') from webpack)
    // See https://github.com/formatjs/formatjs/issues/1914
    messages &&
        Object.prototype.hasOwnProperty.call(messages, id) &&
        messages[id];
    // IMPORTANT: Hot path if `message` is AST with a single literal node
    if (Array.isArray(message) &&
        message.length === 1 &&
        message[0].type === _formatjs_icu_messageformat_parser__WEBPACK_IMPORTED_MODULE_0__.TYPE.literal) {
        return message[0].value;
    }
    // IMPORTANT: Hot path straight lookup for performance
    if (!values &&
        message &&
        typeof message === 'string' &&
        !defaultRichTextElements) {
        return message.replace(/'\{(.*?)\}'/gi, "{$1}");
    }
    values = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({}, defaultRichTextElements), (values || {}));
    formats = deepMergeFormatsAndSetTimeZone(formats, timeZone);
    defaultFormats = deepMergeFormatsAndSetTimeZone(defaultFormats, timeZone);
    if (!message) {
        if (fallbackOnEmptyString === false && message === '') {
            return message;
        }
        if (!defaultMessage ||
            (locale && locale.toLowerCase() !== defaultLocale.toLowerCase())) {
            // This prevents warnings from littering the console in development
            // when no `messages` are passed into the <IntlProvider> for the
            // default locale.
            onError(new _error__WEBPACK_IMPORTED_MODULE_4__.MissingTranslationError(messageDescriptor, locale));
        }
        if (defaultMessage) {
            try {
                var formatter = state.getMessageFormat(defaultMessage, defaultLocale, defaultFormats, opts);
                return formatter.format(values);
            }
            catch (e) {
                onError(new _error__WEBPACK_IMPORTED_MODULE_4__.MessageFormatError("Error formatting default message for: \"".concat(id, "\", rendering default message verbatim"), locale, messageDescriptor, e));
                return typeof defaultMessage === 'string' ? defaultMessage : id;
            }
        }
        return id;
    }
    // We have the translated message
    try {
        var formatter = state.getMessageFormat(message, locale, formats, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({ formatters: state }, (opts || {})));
        return formatter.format(values);
    }
    catch (e) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_4__.MessageFormatError("Error formatting message: \"".concat(id, "\", using ").concat(defaultMessage ? 'default message' : 'id', " as fallback."), locale, messageDescriptor, e));
    }
    if (defaultMessage) {
        try {
            var formatter = state.getMessageFormat(defaultMessage, defaultLocale, defaultFormats, opts);
            return formatter.format(values);
        }
        catch (e) {
            onError(new _error__WEBPACK_IMPORTED_MODULE_4__.MessageFormatError("Error formatting the default message for: \"".concat(id, "\", rendering message verbatim"), locale, messageDescriptor, e));
        }
    }
    if (typeof message === 'string') {
        return message;
    }
    if (typeof defaultMessage === 'string') {
        return defaultMessage;
    }
    return id;
};


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/number.js":
/*!*******************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/number.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatNumber": () => (/* binding */ formatNumber),
/* harmony export */   "formatNumberToParts": () => (/* binding */ formatNumberToParts),
/* harmony export */   "getFormatter": () => (/* binding */ getFormatter)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");


var NUMBER_FORMAT_OPTIONS = [
    'style',
    'currency',
    'currencyDisplay',
    'unit',
    'unitDisplay',
    'useGrouping',
    'minimumIntegerDigits',
    'minimumFractionDigits',
    'maximumFractionDigits',
    'minimumSignificantDigits',
    'maximumSignificantDigits',
    // ES2020 NumberFormat
    'compactDisplay',
    'currencyDisplay',
    'currencySign',
    'notation',
    'signDisplay',
    'unit',
    'unitDisplay',
    'numberingSystem',
];
function getFormatter(_a, getNumberFormat, options) {
    var locale = _a.locale, formats = _a.formats, onError = _a.onError;
    if (options === void 0) { options = {}; }
    var format = options.format;
    var defaults = ((format &&
        (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getNamedFormat)(formats, 'number', format, onError)) ||
        {});
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.filterProps)(options, NUMBER_FORMAT_OPTIONS, defaults);
    return getNumberFormat(locale, filteredOptions);
}
function formatNumber(config, getNumberFormat, value, options) {
    if (options === void 0) { options = {}; }
    try {
        return getFormatter(config, getNumberFormat, options).format(value);
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_1__.IntlError(_error__WEBPACK_IMPORTED_MODULE_1__.IntlErrorCode.FORMAT_ERROR, 'Error formatting number.', e));
    }
    return String(value);
}
function formatNumberToParts(config, getNumberFormat, value, options) {
    if (options === void 0) { options = {}; }
    try {
        return getFormatter(config, getNumberFormat, options).formatToParts(value);
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_1__.IntlError(_error__WEBPACK_IMPORTED_MODULE_1__.IntlErrorCode.FORMAT_ERROR, 'Error formatting number.', e));
    }
    return [];
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/plural.js":
/*!*******************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/plural.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatPlural": () => (/* binding */ formatPlural)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/error.js");



var PLURAL_FORMAT_OPTIONS = ['type'];
function formatPlural(_a, getPluralRules, value, options) {
    var locale = _a.locale, onError = _a.onError;
    if (options === void 0) { options = {}; }
    if (!Intl.PluralRules) {
        onError(new intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.FormatError("Intl.PluralRules is not available in this environment.\nTry polyfilling it using \"@formatjs/intl-pluralrules\"\n", intl_messageformat__WEBPACK_IMPORTED_MODULE_0__.ErrorCode.MISSING_INTL_API));
    }
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.filterProps)(options, PLURAL_FORMAT_OPTIONS);
    try {
        return getPluralRules(locale, filteredOptions).select(value);
    }
    catch (e) {
        onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlFormatError('Error formatting plural.', locale, e));
    }
    return 'other';
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/relativeTime.js":
/*!*************************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/relativeTime.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatRelativeTime": () => (/* binding */ formatRelativeTime)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/@formatjs/intl/lib/src/utils.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/error.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");



var RELATIVE_TIME_FORMAT_OPTIONS = ['numeric', 'style'];
function getFormatter(_a, getRelativeTimeFormat, options) {
    var locale = _a.locale, formats = _a.formats, onError = _a.onError;
    if (options === void 0) { options = {}; }
    var format = options.format;
    var defaults = (!!format && (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getNamedFormat)(formats, 'relative', format, onError)) || {};
    var filteredOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.filterProps)(options, RELATIVE_TIME_FORMAT_OPTIONS, defaults);
    return getRelativeTimeFormat(locale, filteredOptions);
}
function formatRelativeTime(config, getRelativeTimeFormat, value, unit, options) {
    if (options === void 0) { options = {}; }
    if (!unit) {
        unit = 'second';
    }
    var RelativeTimeFormat = Intl.RelativeTimeFormat;
    if (!RelativeTimeFormat) {
        config.onError(new intl_messageformat__WEBPACK_IMPORTED_MODULE_1__.FormatError("Intl.RelativeTimeFormat is not available in this environment.\nTry polyfilling it using \"@formatjs/intl-relativetimeformat\"\n", intl_messageformat__WEBPACK_IMPORTED_MODULE_1__.ErrorCode.MISSING_INTL_API));
    }
    try {
        return getFormatter(config, getRelativeTimeFormat, options).format(value, unit);
    }
    catch (e) {
        config.onError(new _error__WEBPACK_IMPORTED_MODULE_2__.IntlFormatError('Error formatting relative time.', config.locale, e));
    }
    return String(value);
}


/***/ }),

/***/ "./node_modules/@formatjs/intl/lib/src/utils.js":
/*!******************************************************!*\
  !*** ./node_modules/@formatjs/intl/lib/src/utils.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_INTL_CONFIG": () => (/* binding */ DEFAULT_INTL_CONFIG),
/* harmony export */   "createFormatters": () => (/* binding */ createFormatters),
/* harmony export */   "createIntlCache": () => (/* binding */ createIntlCache),
/* harmony export */   "filterProps": () => (/* binding */ filterProps),
/* harmony export */   "getNamedFormat": () => (/* binding */ getNamedFormat)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var intl_messageformat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! intl-messageformat */ "./node_modules/intl-messageformat/lib/src/core.js");
/* harmony import */ var _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @formatjs/fast-memoize */ "./node_modules/@formatjs/fast-memoize/lib/index.js");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error */ "./node_modules/@formatjs/intl/lib/src/error.js");




function filterProps(props, allowlist, defaults) {
    if (defaults === void 0) { defaults = {}; }
    return allowlist.reduce(function (filtered, name) {
        if (name in props) {
            filtered[name] = props[name];
        }
        else if (name in defaults) {
            filtered[name] = defaults[name];
        }
        return filtered;
    }, {});
}
var defaultErrorHandler = function (error) {
    // @ts-ignore just so we don't need to declare dep on @types/node
    if (true) {
        console.error(error);
    }
};
var defaultWarnHandler = function (warning) {
    // @ts-ignore just so we don't need to declare dep on @types/node
    if (true) {
        console.warn(warning);
    }
};
var DEFAULT_INTL_CONFIG = {
    formats: {},
    messages: {},
    timeZone: undefined,
    defaultLocale: 'en',
    defaultFormats: {},
    fallbackOnEmptyString: true,
    onError: defaultErrorHandler,
    onWarn: defaultWarnHandler,
};
function createIntlCache() {
    return {
        dateTime: {},
        number: {},
        message: {},
        relativeTime: {},
        pluralRules: {},
        list: {},
        displayNames: {},
    };
}
function createFastMemoizeCache(store) {
    return {
        create: function () {
            return {
                get: function (key) {
                    return store[key];
                },
                set: function (key, value) {
                    store[key] = value;
                },
            };
        },
    };
}
/**
 * Create intl formatters and populate cache
 * @param cache explicit cache to prevent leaking memory
 */
function createFormatters(cache) {
    if (cache === void 0) { cache = createIntlCache(); }
    var RelativeTimeFormat = Intl.RelativeTimeFormat;
    var ListFormat = Intl.ListFormat;
    var DisplayNames = Intl.DisplayNames;
    var getDateTimeFormat = (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
        var _a;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new ((_a = Intl.DateTimeFormat).bind.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
    }, {
        cache: createFastMemoizeCache(cache.dateTime),
        strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
    });
    var getNumberFormat = (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
        var _a;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new ((_a = Intl.NumberFormat).bind.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
    }, {
        cache: createFastMemoizeCache(cache.number),
        strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
    });
    var getPluralRules = (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
        var _a;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new ((_a = Intl.PluralRules).bind.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
    }, {
        cache: createFastMemoizeCache(cache.pluralRules),
        strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
    });
    return {
        getDateTimeFormat: getDateTimeFormat,
        getNumberFormat: getNumberFormat,
        getMessageFormat: (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function (message, locales, overrideFormats, opts) {
            return new intl_messageformat__WEBPACK_IMPORTED_MODULE_2__.IntlMessageFormat(message, locales, overrideFormats, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__assign)({ formatters: {
                    getNumberFormat: getNumberFormat,
                    getDateTimeFormat: getDateTimeFormat,
                    getPluralRules: getPluralRules,
                } }, (opts || {})));
        }, {
            cache: createFastMemoizeCache(cache.message),
            strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
        }),
        getRelativeTimeFormat: (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return new (RelativeTimeFormat.bind.apply(RelativeTimeFormat, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
        }, {
            cache: createFastMemoizeCache(cache.relativeTime),
            strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
        }),
        getPluralRules: getPluralRules,
        getListFormat: (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return new (ListFormat.bind.apply(ListFormat, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
        }, {
            cache: createFastMemoizeCache(cache.list),
            strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
        }),
        getDisplayNames: (0,_formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return new (DisplayNames.bind.apply(DisplayNames, (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__spreadArray)([void 0], args, false)))();
        }, {
            cache: createFastMemoizeCache(cache.displayNames),
            strategy: _formatjs_fast_memoize__WEBPACK_IMPORTED_MODULE_0__.strategies.variadic,
        }),
    };
}
function getNamedFormat(formats, type, name, onError) {
    var formatType = formats && formats[type];
    var format;
    if (formatType) {
        format = formatType[name];
    }
    if (format) {
        return format;
    }
    onError(new _error__WEBPACK_IMPORTED_MODULE_3__.UnsupportedFormatterError("No ".concat(type, " format named: ").concat(name)));
}


/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/Alert.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Alert/Alert.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Alert": () => (/* binding */ Alert),
/* harmony export */   "AlertVariant": () => (/* binding */ AlertVariant)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Alert/alert */ "./node_modules/@patternfly/react-styles/css/components/Alert/alert.js");
/* harmony import */ var _patternfly_react_styles_css_utilities_Accessibility_accessibility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/utilities/Accessibility/accessibility */ "./node_modules/@patternfly/react-styles/css/utilities/Accessibility/accessibility.js");
/* harmony import */ var _AlertIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./AlertIcon */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertIcon.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");
/* harmony import */ var _AlertContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AlertContext */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js");
/* harmony import */ var _patternfly_react_tokens_dist_esm_c_alert_title_max_lines__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-tokens/dist/esm/c_alert__title_max_lines */ "./node_modules/@patternfly/react-tokens/dist/esm/c_alert__title_max_lines.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Tooltip */ "./node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js");
/* harmony import */ var _AlertToggleExpandButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./AlertToggleExpandButton */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertToggleExpandButton.js");












var AlertVariant;
(function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
    AlertVariant["default"] = "default";
})(AlertVariant || (AlertVariant = {}));
const Alert = (_a) => {
    var { variant = AlertVariant.default, isInline = false, isPlain = false, isLiveRegion = false, variantLabel = `${(0,_helpers__WEBPACK_IMPORTED_MODULE_1__.capitalize)(variant)} alert:`, 'aria-label': ariaLabel = `${(0,_helpers__WEBPACK_IMPORTED_MODULE_1__.capitalize)(variant)} Alert`, actionClose, actionLinks, title, titleHeadingLevel: TitleHeadingLevel = 'h4', children = '', className = '', ouiaId, ouiaSafe = true, timeout = false, timeoutAnimation = 3000, onTimeout = () => { }, truncateTitle = 0, tooltipPosition, customIcon, isExpandable = false, toggleAriaLabel = `${(0,_helpers__WEBPACK_IMPORTED_MODULE_1__.capitalize)(variant)} alert details`, onMouseEnter = () => { }, onMouseLeave = () => { }, id } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["variant", "isInline", "isPlain", "isLiveRegion", "variantLabel", 'aria-label', "actionClose", "actionLinks", "title", "titleHeadingLevel", "children", "className", "ouiaId", "ouiaSafe", "timeout", "timeoutAnimation", "onTimeout", "truncateTitle", "tooltipPosition", "customIcon", "isExpandable", "toggleAriaLabel", "onMouseEnter", "onMouseLeave", "id"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.useOUIAProps)(Alert.displayName, ouiaId, ouiaSafe, variant);
    const getHeadingContent = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_utilities_Accessibility_accessibility__WEBPACK_IMPORTED_MODULE_5__["default"].screenReader) }, variantLabel),
        title));
    const titleRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(null);
    const divRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const [isTooltipVisible, setIsTooltipVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (!titleRef.current || !truncateTitle) {
            return;
        }
        titleRef.current.style.setProperty(_patternfly_react_tokens_dist_esm_c_alert_title_max_lines__WEBPACK_IMPORTED_MODULE_6__["default"].name, truncateTitle.toString());
        const showTooltip = titleRef.current && titleRef.current.offsetHeight < titleRef.current.scrollHeight;
        if (isTooltipVisible !== showTooltip) {
            setIsTooltipVisible(showTooltip);
        }
    }, [titleRef, truncateTitle, isTooltipVisible]);
    const [timedOut, setTimedOut] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [timedOutAnimation, setTimedOutAnimation] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
    const [isMouseOver, setIsMouseOver] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const [containsFocus, setContainsFocus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
    const dismissed = timedOut && timedOutAnimation && !isMouseOver && !containsFocus;
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        timeout = timeout === true ? 8000 : Number(timeout);
        if (timeout > 0) {
            const timer = setTimeout(() => setTimedOut(true), timeout);
            return () => clearTimeout(timer);
        }
    }, []);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const onDocumentFocus = () => {
            if (divRef.current) {
                if (divRef.current.contains(document.activeElement)) {
                    setContainsFocus(true);
                    setTimedOutAnimation(false);
                }
                else if (containsFocus) {
                    setContainsFocus(false);
                }
            }
        };
        document.addEventListener('focus', onDocumentFocus, true);
        return () => document.removeEventListener('focus', onDocumentFocus, true);
    }, [containsFocus]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (containsFocus === false || isMouseOver === false) {
            const timer = setTimeout(() => setTimedOutAnimation(true), timeoutAnimation);
            return () => clearTimeout(timer);
        }
    }, [containsFocus, isMouseOver]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        dismissed && onTimeout();
    }, [dismissed]);
    const [isExpanded, setIsExpanded] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const onToggleExpand = () => {
        setIsExpanded(!isExpanded);
    };
    const myOnMouseEnter = (ev) => {
        setIsMouseOver(true);
        setTimedOutAnimation(false);
        onMouseEnter(ev);
    };
    const myOnMouseLeave = (ev) => {
        setIsMouseOver(false);
        onMouseLeave(ev);
    };
    if (dismissed) {
        return null;
    }
    const Title = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(TitleHeadingLevel, Object.assign({}, (isTooltipVisible && { tabIndex: 0 }), { ref: titleRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alertTitle, truncateTitle && _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.truncate) }), getHeadingContent));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ ref: divRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alert, isInline && _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.inline, isPlain && _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.plain, isExpandable && _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.expandable, isExpanded && _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.expanded, _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers[variant], className), "aria-label": ariaLabel }, ouiaProps, (isLiveRegion && {
        'aria-live': 'polite',
        'aria-atomic': 'false'
    }), { onMouseEnter: myOnMouseEnter, onMouseLeave: myOnMouseLeave, id: id }, props),
        isExpandable && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertContext__WEBPACK_IMPORTED_MODULE_8__.AlertContext.Provider, { value: { title, variantLabel } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alertToggle) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertToggleExpandButton__WEBPACK_IMPORTED_MODULE_9__.AlertToggleExpandButton, { isExpanded: isExpanded, onToggleExpand: onToggleExpand, "aria-label": toggleAriaLabel })))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertIcon__WEBPACK_IMPORTED_MODULE_10__.AlertIcon, { variant: variant, customIcon: customIcon }),
        isTooltipVisible ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_11__.Tooltip, { content: getHeadingContent, position: tooltipPosition }, Title)) : (Title),
        actionClose && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertContext__WEBPACK_IMPORTED_MODULE_8__.AlertContext.Provider, { value: { title, variantLabel } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alertAction) }, actionClose))),
        children && (!isExpandable || (isExpandable && isExpanded)) && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alertDescription) }, children)),
        actionLinks && react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_7__["default"].alertActionGroup) }, actionLinks)));
};
Alert.displayName = 'Alert';
//# sourceMappingURL=Alert.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertActionCloseButton.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertActionCloseButton.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertActionCloseButton": () => (/* binding */ AlertActionCloseButton)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_times_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/times-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/times-icon.js");
/* harmony import */ var _AlertContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AlertContext */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js");





const AlertActionCloseButton = (_a) => {
    var { className, onClose = () => undefined, 'aria-label': ariaLabel = '', variantLabel } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "onClose", 'aria-label', "variantLabel"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertContext__WEBPACK_IMPORTED_MODULE_2__.AlertContext.Consumer, null, ({ title, variantLabel: alertVariantLabel }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_3__.Button, Object.assign({ variant: _Button__WEBPACK_IMPORTED_MODULE_3__.ButtonVariant.plain, onClick: onClose, "aria-label": ariaLabel === '' ? `Close ${variantLabel || alertVariantLabel} alert: ${title}` : ariaLabel, className: className }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_times_icon__WEBPACK_IMPORTED_MODULE_4__["default"], null)))));
};
AlertActionCloseButton.displayName = 'AlertActionCloseButton';
//# sourceMappingURL=AlertActionCloseButton.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertContext": () => (/* binding */ AlertContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

const AlertContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
//# sourceMappingURL=AlertContext.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertIcon.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertIcon.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertIcon": () => (/* binding */ AlertIcon),
/* harmony export */   "variantIcons": () => (/* binding */ variantIcons)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Alert/alert */ "./node_modules/@patternfly/react-styles/css/components/Alert/alert.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_check_circle_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/check-circle-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/check-circle-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_exclamation_circle_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/exclamation-circle-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_exclamation_triangle_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/exclamation-triangle-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/exclamation-triangle-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_info_circle_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/info-circle-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/info-circle-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_bell_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/bell-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/bell-icon.js");









const variantIcons = {
    success: _patternfly_react_icons_dist_esm_icons_check_circle_icon__WEBPACK_IMPORTED_MODULE_1__["default"],
    danger: _patternfly_react_icons_dist_esm_icons_exclamation_circle_icon__WEBPACK_IMPORTED_MODULE_2__["default"],
    warning: _patternfly_react_icons_dist_esm_icons_exclamation_triangle_icon__WEBPACK_IMPORTED_MODULE_3__["default"],
    info: _patternfly_react_icons_dist_esm_icons_info_circle_icon__WEBPACK_IMPORTED_MODULE_4__["default"],
    default: _patternfly_react_icons_dist_esm_icons_bell_icon__WEBPACK_IMPORTED_MODULE_5__["default"]
};
const AlertIcon = (_a) => {
    var { variant, customIcon, className = '' } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__rest)(_a, ["variant", "customIcon", "className"]);
    const Icon = variantIcons[variant];
    return Icon ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_7__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_8__["default"].alertIcon, className) }), customIcon || react__WEBPACK_IMPORTED_MODULE_0__.createElement(Icon, null))) : null;
};
//# sourceMappingURL=AlertIcon.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertToggleExpandButton.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertToggleExpandButton.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertToggleExpandButton": () => (/* binding */ AlertToggleExpandButton)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _AlertContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AlertContext */ "./node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Alert/alert */ "./node_modules/@patternfly/react-styles/css/components/Alert/alert.js");







const AlertToggleExpandButton = (_a) => {
    var { 'aria-label': ariaLabel = '', variantLabel, onToggleExpand, isExpanded = false } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ['aria-label', "variantLabel", "onToggleExpand", "isExpanded"]);
    const { title, variantLabel: alertVariantLabel } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_AlertContext__WEBPACK_IMPORTED_MODULE_2__.AlertContext);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_3__.Button, Object.assign({ variant: _Button__WEBPACK_IMPORTED_MODULE_3__.ButtonVariant.plain, onClick: onToggleExpand, "aria-expanded": isExpanded, "aria-label": ariaLabel === '' ? `Toggle ${variantLabel || alertVariantLabel} alert: ${title}` : ariaLabel }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Alert_alert__WEBPACK_IMPORTED_MODULE_5__["default"].alertToggleIcon) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_6__["default"], { "aria-hidden": "true" }))));
};
AlertToggleExpandButton.displayName = 'AlertToggleExpandButton';
//# sourceMappingURL=AlertToggleExpandButton.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroup.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroup.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertGroup": () => (/* binding */ AlertGroup)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _AlertGroupInline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AlertGroupInline */ "./node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroupInline.js");





class AlertGroup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.state = {
            container: undefined
        };
    }
    componentDidMount() {
        const container = document.createElement('div');
        const target = this.getTargetElement();
        this.setState({ container });
        target.appendChild(container);
    }
    componentWillUnmount() {
        const target = this.getTargetElement();
        if (this.state.container) {
            target.removeChild(this.state.container);
        }
    }
    getTargetElement() {
        const appendTo = this.props.appendTo;
        if (typeof appendTo === 'function') {
            return appendTo();
        }
        return appendTo || document.body;
    }
    render() {
        const _a = this.props, { className, children, isToast, isLiveRegion, onOverflowClick, overflowMessage } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["className", "children", "isToast", "isLiveRegion", "onOverflowClick", "overflowMessage"]);
        const alertGroup = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertGroupInline__WEBPACK_IMPORTED_MODULE_3__.AlertGroupInline, Object.assign({ onOverflowClick: onOverflowClick, className: className, isToast: isToast, isLiveRegion: isLiveRegion, overflowMessage: overflowMessage }, props), children));
        if (!this.props.isToast) {
            return alertGroup;
        }
        const container = this.state.container;
        if (!_helpers__WEBPACK_IMPORTED_MODULE_4__.canUseDOM || !container) {
            return null;
        }
        return react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal(alertGroup, container);
    }
}
AlertGroup.displayName = 'AlertGroup';
//# sourceMappingURL=AlertGroup.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroupInline.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroupInline.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertGroupInline": () => (/* binding */ AlertGroupInline)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_AlertGroup_alert_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/AlertGroup/alert-group */ "./node_modules/@patternfly/react-styles/css/components/AlertGroup/alert-group.js");




const AlertGroupInline = (_a) => {
    var { className, children, isToast, isLiveRegion, onOverflowClick, overflowMessage } = _a, rest = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children", "isToast", "isLiveRegion", "onOverflowClick", "overflowMessage"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", Object.assign({ "aria-live": isLiveRegion ? 'polite' : null, "aria-atomic": isLiveRegion ? false : null, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_AlertGroup_alert_group__WEBPACK_IMPORTED_MODULE_3__["default"].alertGroup, className, isToast ? _patternfly_react_styles_css_components_AlertGroup_alert_group__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.toast : '') }, rest),
        react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children).map((alert, index) => {
            var _a;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", { key: ((_a = alert.props) === null || _a === void 0 ? void 0 : _a.id) || index }, alert));
        }),
        overflowMessage && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { onClick: onOverflowClick, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_AlertGroup_alert_group__WEBPACK_IMPORTED_MODULE_3__["default"].alertGroupOverflowButton) }, overflowMessage)))));
};
AlertGroupInline.displayName = 'AlertGroupInline';
//# sourceMappingURL=AlertGroupInline.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherSeparator.js":
/*!*********************************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherSeparator.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ApplicationLauncherSeparator": () => (/* binding */ ApplicationLauncherSeparator)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _Dropdown_DropdownSeparator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Dropdown/DropdownSeparator */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownSeparator.js");



const ApplicationLauncherSeparator = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    children } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children"]);
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Dropdown_DropdownSeparator__WEBPACK_IMPORTED_MODULE_2__.DropdownSeparator, Object.assign({}, props));
};
ApplicationLauncherSeparator.displayName = 'ApplicationLauncherSeparator';
//# sourceMappingURL=ApplicationLauncherSeparator.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Backdrop/Backdrop.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Backdrop/Backdrop.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Backdrop": () => (/* binding */ Backdrop)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Backdrop_backdrop__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Backdrop/backdrop */ "./node_modules/@patternfly/react-styles/css/components/Backdrop/backdrop.js");




const Backdrop = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Backdrop_backdrop__WEBPACK_IMPORTED_MODULE_3__["default"].backdrop, className) }), children));
};
Backdrop.displayName = 'Backdrop';
//# sourceMappingURL=Backdrop.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Badge/Badge.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Badge/Badge.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Badge": () => (/* binding */ Badge)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Badge_badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Badge/badge */ "./node_modules/@patternfly/react-styles/css/components/Badge/badge.js");




const Badge = (_a) => {
    var { isRead = false, className = '', children = '', screenReaderText } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["isRead", "className", "children", "screenReaderText"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Badge_badge__WEBPACK_IMPORTED_MODULE_3__["default"].badge, (isRead ? _patternfly_react_styles_css_components_Badge_badge__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.read : _patternfly_react_styles_css_components_Badge_badge__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.unread), className) }),
        children,
        screenReaderText && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "pf-screen-reader" }, screenReaderText)));
};
Badge.displayName = 'Badge';
//# sourceMappingURL=Badge.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/Breadcrumb.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/Breadcrumb.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Breadcrumb": () => (/* binding */ Breadcrumb)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Breadcrumb/breadcrumb */ "./node_modules/@patternfly/react-styles/css/components/Breadcrumb/breadcrumb.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");





const Breadcrumb = (_a) => {
    var { children = null, className = '', 'aria-label': ariaLabel = 'Breadcrumb', ouiaId, ouiaSafe = true } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", 'aria-label', "ouiaId", "ouiaSafe"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_2__.useOUIAProps)(Breadcrumb.displayName, ouiaId, ouiaSafe);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("nav", Object.assign({}, props, { "aria-label": ariaLabel, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_4__["default"].breadcrumb, className) }, ouiaProps),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("ol", { className: _patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_4__["default"].breadcrumbList }, react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, (child, index) => {
            const showDivider = index > 0;
            if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(child)) {
                return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(child, { showDivider });
            }
            return child;
        }))));
};
Breadcrumb.displayName = 'Breadcrumb';
//# sourceMappingURL=Breadcrumb.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/BreadcrumbItem.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/BreadcrumbItem.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BreadcrumbItem": () => (/* binding */ BreadcrumbItem)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Breadcrumb/breadcrumb */ "./node_modules/@patternfly/react-styles/css/components/Breadcrumb/breadcrumb.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");





const BreadcrumbItem = (_a) => {
    var { children = null, className: classNameProp = '', to = undefined, isActive = false, isDropdown = false, showDivider, target = undefined, component = 'a', render = undefined } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "to", "isActive", "isDropdown", "showDivider", "target", "component", "render"]);
    const Component = component;
    const ariaCurrent = isActive ? 'page' : undefined;
    const className = (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__["default"].breadcrumbLink, isActive && _patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.current);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__["default"].breadcrumbItem, classNameProp) }),
        showDivider && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: _patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__["default"].breadcrumbItemDivider },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_4__["default"], null))),
        component === 'button' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { className: className, "aria-current": ariaCurrent, type: "button" }, children)),
        isDropdown && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Breadcrumb_breadcrumb__WEBPACK_IMPORTED_MODULE_3__["default"].breadcrumbDropdown) }, children),
        render && render({ className, ariaCurrent }),
        to && !render && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, { href: to, target: target, className: className, "aria-current": ariaCurrent }, children)),
        !to && component !== 'button' && !isDropdown && children));
};
BreadcrumbItem.displayName = 'BreadcrumbItem';
//# sourceMappingURL=BreadcrumbItem.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Button": () => (/* binding */ Button),
/* harmony export */   "ButtonType": () => (/* binding */ ButtonType),
/* harmony export */   "ButtonVariant": () => (/* binding */ ButtonVariant)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Button/button */ "./node_modules/@patternfly/react-styles/css/components/Button/button.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _Spinner__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Spinner */ "./node_modules/@patternfly/react-core/dist/esm/components/Spinner/Spinner.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Badge */ "./node_modules/@patternfly/react-core/dist/esm/components/Badge/Badge.js");







var ButtonVariant;
(function (ButtonVariant) {
    ButtonVariant["primary"] = "primary";
    ButtonVariant["secondary"] = "secondary";
    ButtonVariant["tertiary"] = "tertiary";
    ButtonVariant["danger"] = "danger";
    ButtonVariant["warning"] = "warning";
    ButtonVariant["link"] = "link";
    ButtonVariant["plain"] = "plain";
    ButtonVariant["control"] = "control";
})(ButtonVariant || (ButtonVariant = {}));
var ButtonType;
(function (ButtonType) {
    ButtonType["button"] = "button";
    ButtonType["submit"] = "submit";
    ButtonType["reset"] = "reset";
})(ButtonType || (ButtonType = {}));
const ButtonBase = (_a) => {
    var { children = null, className = '', component = 'button', isActive = false, isBlock = false, isDisabled = false, isAriaDisabled = false, isLoading = null, isDanger = false, spinnerAriaValueText, spinnerAriaLabelledBy, spinnerAriaLabel, isSmall = false, isLarge = false, inoperableEvents = ['onClick', 'onKeyPress'], isInline = false, type = ButtonType.button, variant = ButtonVariant.primary, iconPosition = 'left', 'aria-label': ariaLabel = null, icon = null, ouiaId, ouiaSafe = true, tabIndex = null, innerRef, countOptions } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isAriaDisabled", "isLoading", "isDanger", "spinnerAriaValueText", "spinnerAriaLabelledBy", "spinnerAriaLabel", "isSmall", "isLarge", "inoperableEvents", "isInline", "type", "variant", "iconPosition", 'aria-label', "icon", "ouiaId", "ouiaSafe", "tabIndex", "innerRef", "countOptions"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_2__.useOUIAProps)(Button.displayName, ouiaId, ouiaSafe, variant);
    const Component = component;
    const isButtonElement = Component === 'button';
    const isInlineSpan = isInline && Component === 'span';
    const preventedEvents = inoperableEvents.reduce((handlers, eventToPrevent) => (Object.assign(Object.assign({}, handlers), { [eventToPrevent]: (event) => {
            event.preventDefault();
        } })), {});
    const getDefaultTabIdx = () => {
        if (isDisabled) {
            return isButtonElement ? null : -1;
        }
        else if (isAriaDisabled) {
            return null;
        }
        else if (isInlineSpan) {
            return 0;
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({}, props, (isAriaDisabled ? preventedEvents : null), { "aria-disabled": isDisabled || isAriaDisabled, "aria-label": ariaLabel, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].button, _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers[variant], isBlock && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.block, isDisabled && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.disabled, isAriaDisabled && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.ariaDisabled, isActive && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.active, isInline && variant === ButtonVariant.link && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.inline, isDanger && (variant === ButtonVariant.secondary || variant === ButtonVariant.link) && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.danger, isLoading !== null && children !== null && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.progress, isLoading && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.inProgress, isSmall && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.small, isLarge && _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.displayLg, className), disabled: isButtonElement ? isDisabled : null, tabIndex: tabIndex !== null ? tabIndex : getDefaultTabIdx(), type: isButtonElement || isInlineSpan ? type : null, role: isInlineSpan ? 'button' : null, ref: innerRef }, ouiaProps),
        isLoading && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].buttonProgress) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Spinner__WEBPACK_IMPORTED_MODULE_5__.Spinner, { size: _Spinner__WEBPACK_IMPORTED_MODULE_5__.spinnerSize.md, isInline: isInline, "aria-valuetext": spinnerAriaValueText, "aria-label": spinnerAriaLabel, "aria-labelledby": spinnerAriaLabelledBy }))),
        variant === ButtonVariant.plain && children === null && icon ? icon : null,
        variant !== ButtonVariant.plain && icon && iconPosition === 'left' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].buttonIcon, _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.start) }, icon)),
        children,
        variant !== ButtonVariant.plain && icon && iconPosition === 'right' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].buttonIcon, _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.end) }, icon)),
        countOptions && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_4__["default"].buttonCount, countOptions.className) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Badge__WEBPACK_IMPORTED_MODULE_6__.Badge, { isRead: countOptions.isRead }, countOptions.count)))));
};
const Button = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(ButtonBase, Object.assign({ innerRef: ref }, props))));
Button.displayName = 'Button';
//# sourceMappingURL=Button.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/CalendarMonth/CalendarMonth.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/CalendarMonth/CalendarMonth.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CalendarMonth": () => (/* binding */ CalendarMonth),
/* harmony export */   "Weekday": () => (/* binding */ Weekday)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _TextInput_TextInput__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../TextInput/TextInput */ "./node_modules/@patternfly/react-core/dist/esm/components/TextInput/TextInput.js");
/* harmony import */ var _Button_Button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Button/Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Select */ "./node_modules/@patternfly/react-core/dist/esm/components/Select/Select.js");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Select */ "./node_modules/@patternfly/react-core/dist/esm/components/Select/SelectOption.js");
/* harmony import */ var _InputGroup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../InputGroup */ "./node_modules/@patternfly/react-core/dist/esm/components/InputGroup/InputGroup.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_left_icon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-left-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-left-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/components/CalendarMonth/calendar-month */ "./node_modules/@patternfly/react-styles/css/components/CalendarMonth/calendar-month.js");
/* harmony import */ var _helpers_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers/util */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/datetimeUtils */ "./node_modules/@patternfly/react-core/dist/esm/helpers/datetimeUtils.js");












var Weekday;
(function (Weekday) {
    Weekday[Weekday["Sunday"] = 0] = "Sunday";
    Weekday[Weekday["Monday"] = 1] = "Monday";
    Weekday[Weekday["Tuesday"] = 2] = "Tuesday";
    Weekday[Weekday["Wednesday"] = 3] = "Wednesday";
    Weekday[Weekday["Thursday"] = 4] = "Thursday";
    Weekday[Weekday["Friday"] = 5] = "Friday";
    Weekday[Weekday["Saturday"] = 6] = "Saturday";
})(Weekday || (Weekday = {}));
// Must be numeric given current header design
const yearFormat = (date) => date.getFullYear();
const buildCalendar = (year, month, weekStart, validators) => {
    const defaultDate = new Date(year, month);
    const firstDayOfWeek = new Date(defaultDate);
    firstDayOfWeek.setDate(firstDayOfWeek.getDate() - firstDayOfWeek.getDay() + weekStart);
    // We will show a maximum of 6 weeks like Google calendar
    // Assume we just want the numbers for now...
    const calendarWeeks = [];
    if (firstDayOfWeek.getMonth() === defaultDate.getMonth() && firstDayOfWeek.getDate() !== 1) {
        firstDayOfWeek.setDate(firstDayOfWeek.getDate() - 7);
    }
    for (let i = 0; i < 6; i++) {
        const week = [];
        for (let j = 0; j < 7; j++) {
            const date = new Date(firstDayOfWeek);
            week.push({
                date,
                isValid: validators.every(validator => validator(date))
            });
            firstDayOfWeek.setDate(firstDayOfWeek.getDate() + 1);
        }
        calendarWeeks.push(week);
        if (firstDayOfWeek.getMonth() !== defaultDate.getMonth()) {
            break;
        }
    }
    return calendarWeeks;
};
const isSameDate = (d1, d2) => d1.getFullYear() === d2.getFullYear() && d1.getMonth() === d2.getMonth() && d1.getDate() === d2.getDate();
const today = new Date();
/** The main calendar month component. */
const CalendarMonth = (_a) => {
    var { date: dateProp, locale = undefined, monthFormat = date => date.toLocaleDateString(locale, { month: 'long' }), weekdayFormat = date => date.toLocaleDateString(locale, { weekday: 'narrow' }), longWeekdayFormat = date => date.toLocaleDateString(locale, { weekday: 'long' }), dayFormat = date => date.getDate(), weekStart = 0, // Use the American Sunday as a default
    onChange = () => { }, validators = [() => true], className, onSelectToggle = () => { }, onMonthChange = () => { }, rangeStart, prevMonthAriaLabel = 'Previous month', nextMonthAriaLabel = 'Next month', yearInputAriaLabel = 'Select year', cellAriaLabel, isDateFocused = false, inlineProps } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["date", "locale", "monthFormat", "weekdayFormat", "longWeekdayFormat", "dayFormat", "weekStart", "onChange", "validators", "className", "onSelectToggle", "onMonthChange", "rangeStart", "prevMonthAriaLabel", "nextMonthAriaLabel", "yearInputAriaLabel", "cellAriaLabel", "isDateFocused", "inlineProps"]);
    const longMonths = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11].map(monthNum => new Date(1990, monthNum)).map(monthFormat);
    const [isSelectOpen, setIsSelectOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    // eslint-disable-next-line prefer-const
    const [focusedDate, setFocusedDate] = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => {
        const initDate = new Date(dateProp);
        if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(initDate)) {
            return initDate;
        }
        else {
            if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(rangeStart)) {
                return rangeStart;
            }
            else {
                return today;
            }
        }
    });
    const [hoveredDate, setHoveredDate] = react__WEBPACK_IMPORTED_MODULE_0__.useState(new Date(focusedDate));
    const focusRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const [hiddenMonthId] = react__WEBPACK_IMPORTED_MODULE_0__.useState((0,_helpers_util__WEBPACK_IMPORTED_MODULE_3__.getUniqueId)('hidden-month-span'));
    const [shouldFocus, setShouldFocus] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const isValidated = (date) => validators.every(validator => validator(date));
    const focusedDateValidated = isValidated(focusedDate);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(dateProp) && !isSameDate(focusedDate, dateProp)) {
            setFocusedDate(dateProp);
        }
        else if (!dateProp) {
            setFocusedDate(today);
        }
    }, [dateProp]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        // Calendar month should not be focused on page load
        // Datepicker should place focus in calendar month when opened
        if ((shouldFocus || isDateFocused) && focusedDateValidated && focusRef.current) {
            focusRef.current.focus();
        }
        else {
            setShouldFocus(true);
        }
    }, [focusedDate, isDateFocused, focusedDateValidated, focusRef]);
    const onMonthClick = (newDate, ev) => {
        setFocusedDate(newDate);
        setHoveredDate(newDate);
        setShouldFocus(false);
        onMonthChange(newDate, ev);
    };
    const onKeyDown = (ev) => {
        const newDate = new Date(focusedDate);
        if (ev.key === 'ArrowUp') {
            newDate.setDate(newDate.getDate() - 7);
        }
        else if (ev.key === 'ArrowRight') {
            newDate.setDate(newDate.getDate() + 1);
        }
        else if (ev.key === 'ArrowDown') {
            newDate.setDate(newDate.getDate() + 7);
        }
        else if (ev.key === 'ArrowLeft') {
            newDate.setDate(newDate.getDate() - 1);
        }
        if (newDate.getTime() !== focusedDate.getTime() && isValidated(newDate)) {
            ev.preventDefault();
            setFocusedDate(newDate);
            setHoveredDate(newDate);
            setShouldFocus(true);
        }
    };
    const addMonth = (toAdd) => {
        const newDate = new Date(focusedDate);
        newDate.setMonth(newDate.getMonth() + toAdd);
        return newDate;
    };
    const prevMonth = addMonth(-1);
    const nextMonth = addMonth(1);
    const focusedYear = focusedDate.getFullYear();
    const focusedMonth = focusedDate.getMonth();
    const calendar = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => buildCalendar(focusedYear, focusedMonth, weekStart, validators), [
        focusedYear,
        focusedMonth,
        weekStart,
        validators
    ]);
    if (!focusedDateValidated) {
        const toFocus = calendar
            .reduce((acc, cur) => [...acc, ...cur], [])
            .filter(({ date, isValid }) => isValid && date.getMonth() === focusedMonth)
            .map(({ date }) => ({ date, days: Math.abs(focusedDate.getTime() - date.getTime()) }))
            .sort((o1, o2) => o1.days - o2.days)
            .map(({ date }) => date)[0];
        if (toFocus) {
            setFocusedDate(toFocus);
            setHoveredDate(toFocus);
        }
    }
    const isHoveredDateValid = isValidated(hoveredDate);
    const monthFormatted = monthFormat(focusedDate);
    const yearFormatted = yearFormat(focusedDate);
    const calendarToRender = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonth, className) }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthHeader },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthHeaderNavControl, _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.prevMonth) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button_Button__WEBPACK_IMPORTED_MODULE_6__.Button, { variant: "plain", "aria-label": prevMonthAriaLabel, onClick: (ev) => onMonthClick(prevMonth, ev) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_left_icon__WEBPACK_IMPORTED_MODULE_7__["default"], { "aria-hidden": true }))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputGroup__WEBPACK_IMPORTED_MODULE_8__.InputGroup, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthHeaderMonth },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { id: hiddenMonthId, hidden: true }, "Month"),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Select__WEBPACK_IMPORTED_MODULE_9__.Select
                    // Max width with "September"
                    , { 
                        // Max width with "September"
                        width: "140px", "aria-labelledby": hiddenMonthId, isOpen: isSelectOpen, onToggle: () => {
                            setIsSelectOpen(!isSelectOpen);
                            onSelectToggle(!isSelectOpen);
                        }, onSelect: (ev, monthNum) => {
                            // When we put CalendarMonth in a Popover we want the Popover's onDocumentClick
                            // to see the SelectOption as a child so it doesn't close the Popover.
                            setTimeout(() => {
                                setIsSelectOpen(false);
                                onSelectToggle(false);
                                const newDate = new Date(focusedDate);
                                newDate.setMonth(Number(monthNum));
                                setFocusedDate(newDate);
                                setHoveredDate(newDate);
                                setShouldFocus(false);
                                onMonthChange(newDate, ev);
                            }, 0);
                        }, variant: "single", selections: monthFormatted }, longMonths.map((longMonth, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Select__WEBPACK_IMPORTED_MODULE_10__.SelectOption, { key: index, value: index, isSelected: longMonth === monthFormatted }, longMonth))))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthHeaderYear },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextInput_TextInput__WEBPACK_IMPORTED_MODULE_11__.TextInput, { "aria-label": yearInputAriaLabel, type: "number", value: yearFormatted, onChange: (year, ev) => {
                            const newDate = new Date(focusedDate);
                            newDate.setFullYear(+year);
                            setFocusedDate(newDate);
                            setHoveredDate(newDate);
                            setShouldFocus(false);
                            onMonthChange(newDate, ev);
                        } }))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthHeaderNavControl, _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.nextMonth) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button_Button__WEBPACK_IMPORTED_MODULE_6__.Button, { variant: "plain", "aria-label": nextMonthAriaLabel, onClick: (ev) => onMonthClick(nextMonth, ev) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_12__["default"], { "aria-hidden": true })))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("table", { className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthCalendar },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("thead", { className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthDays },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("tr", null, calendar[0].map(({ date }, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("th", { key: index, className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthDay, scope: "col" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: "pf-screen-reader" }, longWeekdayFormat(date)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { "aria-hidden": true }, weekdayFormat(date))))))),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("tbody", { onKeyDown: onKeyDown }, calendar.map((week, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("tr", { key: index, className: _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthDatesRow }, week.map(({ date, isValid }, index) => {
                const dayFormatted = dayFormat(date);
                const isToday = isSameDate(date, today);
                const isSelected = (0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(dateProp) && isSameDate(date, dateProp);
                const isFocused = isSameDate(date, focusedDate);
                const isAdjacentMonth = date.getMonth() !== focusedDate.getMonth();
                const isRangeStart = (0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(rangeStart) && isSameDate(date, rangeStart);
                let isInRange = false;
                let isRangeEnd = false;
                if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(rangeStart) && (0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(dateProp)) {
                    isInRange = date > rangeStart && date < dateProp;
                    isRangeEnd = isSameDate(date, dateProp);
                }
                else if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(rangeStart) && isHoveredDateValid) {
                    if (hoveredDate > rangeStart || isSameDate(hoveredDate, rangeStart)) {
                        isInRange = date > rangeStart && date < hoveredDate;
                        isRangeEnd = isSameDate(date, hoveredDate);
                    }
                    // Don't handle focused dates before start dates for now.
                    // Core would likely need new styles
                }
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("td", { key: index, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthDatesCell, isAdjacentMonth && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.adjacentMonth, isToday && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.current, (isSelected || isRangeStart) && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.selected, !isValid && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.disabled, (isInRange || isRangeStart || isRangeEnd) && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.inRange, isRangeStart && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.startRange, isRangeEnd && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.endRange) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].calendarMonthDate, isRangeEnd && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.hover, !isValid && _patternfly_react_styles_css_components_CalendarMonth_calendar_month__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.disabled), type: "button", onClick: () => onChange(date), onMouseOver: () => setHoveredDate(date), tabIndex: isFocused ? 0 : -1, disabled: !isValid, "aria-label": cellAriaLabel
                            ? cellAriaLabel(date)
                            : `${dayFormat(date)} ${monthFormat(date)} ${yearFormat(date)}` }, (isFocused && { ref: focusRef })), dayFormatted)));
            }))))))));
    if (inlineProps !== undefined) {
        const Component = (inlineProps.component ? inlineProps.component : 'article');
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({}, (inlineProps.ariaLabelledby && { 'aria-labelledby': inlineProps.ariaLabelledby })),
            inlineProps.title,
            calendarToRender));
    }
    return calendarToRender;
};
CalendarMonth.displayName = 'CalendarMonth';
//# sourceMappingURL=CalendarMonth.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/Card.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/Card.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Card": () => (/* binding */ Card),
/* harmony export */   "CardContext": () => (/* binding */ CardContext)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");





const CardContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    cardId: '',
    registerTitleId: () => { },
    isExpanded: false
});
const Card = (_a) => {
    var { children = null, id = '', className = '', component = 'article', isHoverable = false, isCompact = false, isSelectable = false, isSelectableRaised = false, isSelected = false, isDisabledRaised = false, isFlat = false, isExpanded = false, isRounded = false, isLarge = false, isFullHeight = false, isPlain = false, ouiaId, ouiaSafe = true, hasSelectableInput = false, selectableInputAriaLabel, onSelectableInputChange = () => { } } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "id", "className", "component", "isHoverable", "isCompact", "isSelectable", "isSelectableRaised", "isSelected", "isDisabledRaised", "isFlat", "isExpanded", "isRounded", "isLarge", "isFullHeight", "isPlain", "ouiaId", "ouiaSafe", "hasSelectableInput", "selectableInputAriaLabel", "onSelectableInputChange"]);
    const Component = component;
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_2__.useOUIAProps)(Card.displayName, ouiaId, ouiaSafe);
    const [titleId, setTitleId] = react__WEBPACK_IMPORTED_MODULE_0__.useState('');
    const [ariaProps, setAriaProps] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
    if (isCompact && isLarge) {
        // eslint-disable-next-line no-console
        console.warn('Card: Cannot use isCompact with isLarge. Defaulting to isCompact');
        isLarge = false;
    }
    const getSelectableModifiers = () => {
        if (isDisabledRaised) {
            return (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.nonSelectableRaised);
        }
        if (isSelectableRaised) {
            return (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.selectableRaised, isSelected && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.selectedRaised);
        }
        if (isSelectable || isHoverable) {
            return (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.selectable, isSelected && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.selected);
        }
        return '';
    };
    const containsCardTitleChildRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
    const registerTitleId = (id) => {
        setTitleId(id);
        containsCardTitleChildRef.current = !!id;
    };
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (selectableInputAriaLabel) {
            setAriaProps({ 'aria-label': selectableInputAriaLabel });
        }
        else if (titleId) {
            setAriaProps({ 'aria-labelledby': titleId });
        }
        else if (hasSelectableInput && !containsCardTitleChildRef.current) {
            setAriaProps({});
            // eslint-disable-next-line no-console
            console.warn('If no CardTitle component is passed as a child of Card the selectableInputAriaLabel prop must be passed');
        }
    }, [hasSelectableInput, selectableInputAriaLabel, titleId]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(CardContext.Provider, { value: {
            cardId: id,
            registerTitleId,
            isExpanded
        } },
        hasSelectableInput && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", Object.assign({ className: "pf-screen-reader", id: `${id}-input` }, ariaProps, { type: "checkbox", checked: isSelected, onChange: event => onSelectableInputChange(id, event), disabled: isDisabledRaised, tabIndex: -1 }))),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ id: id, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].card, isCompact && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.compact, isExpanded && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.expanded, isFlat && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.flat, isRounded && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.rounded, isLarge && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.displayLg, isFullHeight && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.fullHeight, isPlain && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.plain, getSelectableModifiers(), className), tabIndex: isSelectable || isSelectableRaised ? '0' : undefined }, props, ouiaProps), children)));
};
Card.displayName = 'Card';
//# sourceMappingURL=Card.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/CardActions.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/CardActions.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardActions": () => (/* binding */ CardActions)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");




const CardActions = (_a) => {
    var { children = null, className = '', hasNoOffset = false } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "hasNoOffset"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__["default"].cardActions, hasNoOffset && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.noOffset, className) }, props), children));
};
CardActions.displayName = 'CardActions';
//# sourceMappingURL=CardActions.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/CardBody.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/CardBody.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardBody": () => (/* binding */ CardBody)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const CardBody = (_a) => {
    var { children = null, className = '', component = 'div', isFilled = true } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "component", "isFilled"]);
    const Component = component;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__["default"].cardBody, !isFilled && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.noFill, className) }, props), children));
};
CardBody.displayName = 'CardBody';
//# sourceMappingURL=CardBody.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/CardFooter.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/CardFooter.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardFooter": () => (/* binding */ CardFooter)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const CardFooter = (_a) => {
    var { children = null, className = '', component = 'div' } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "component"]);
    const Component = component;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_3__["default"].cardFooter, className) }, props), children));
};
CardFooter.displayName = 'CardFooter';
//# sourceMappingURL=CardFooter.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/CardHeader.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/CardHeader.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardHeader": () => (/* binding */ CardHeader)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Card */ "./node_modules/@patternfly/react-core/dist/esm/components/Card/Card.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");







const CardHeader = (_a) => {
    var { children = null, className = '', id, onExpand, toggleButtonProps, isToggleRightAligned } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "id", "onExpand", "toggleButtonProps", "isToggleRightAligned"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Card__WEBPACK_IMPORTED_MODULE_2__.CardContext.Consumer, null, ({ cardId }) => {
        const cardHeaderToggle = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].cardHeaderToggle) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_5__.Button, Object.assign({ variant: "plain", type: "button", onClick: evt => {
                    onExpand(evt, cardId);
                } }, toggleButtonProps),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].cardHeaderToggleIcon) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_6__["default"], { "aria-hidden": "true" })))));
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].cardHeader, isToggleRightAligned && _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.toggleRight, className), id: id }, props),
            onExpand && !isToggleRightAligned && cardHeaderToggle,
            children,
            onExpand && isToggleRightAligned && cardHeaderToggle));
    }));
};
CardHeader.displayName = 'CardHeader';
//# sourceMappingURL=CardHeader.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Card/CardTitle.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Card/CardTitle.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CardTitle": () => (/* binding */ CardTitle)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Card/card */ "./node_modules/@patternfly/react-styles/css/components/Card/card.js");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Card */ "./node_modules/@patternfly/react-core/dist/esm/components/Card/Card.js");





const CardTitle = (_a) => {
    var { children = null, className = '', component = 'div' } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "component"]);
    const { cardId, registerTitleId } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_Card__WEBPACK_IMPORTED_MODULE_2__.CardContext);
    const Component = component;
    const titleId = cardId ? `${cardId}-title` : '';
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        registerTitleId(titleId);
        return () => registerTitleId('');
    }, [registerTitleId, titleId]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Card_card__WEBPACK_IMPORTED_MODULE_4__["default"].cardTitle, className), id: titleId || undefined }, props), children));
};
CardTitle.displayName = 'CardTitle';
//# sourceMappingURL=CardTitle.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Checkbox": () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Check/check */ "./node_modules/@patternfly/react-styles/css/components/Check/check.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");
/* harmony import */ var _helpers_htmlConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers/htmlConstants */ "./node_modules/@patternfly/react-core/dist/esm/helpers/htmlConstants.js");






// tslint:disable-next-line:no-empty
const defaultOnChange = () => { };
class Checkbox extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            this.props.onChange(event.currentTarget.checked, event);
        };
        this.state = {
            ouiaStateId: (0,_helpers__WEBPACK_IMPORTED_MODULE_1__.getDefaultOUIAId)(Checkbox.displayName)
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, className, onChange, isValid, isDisabled, isRequired, isChecked, label, checked, defaultChecked, description, body, ouiaId, ouiaSafe, component: Component } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ['aria-label', "className", "onChange", "isValid", "isDisabled", "isRequired", "isChecked", "label", "checked", "defaultChecked", "description", "body", "ouiaId", "ouiaSafe", "component"]);
        if (!props.id) {
            // eslint-disable-next-line no-console
            console.error('Checkbox:', 'id is required to make input accessible');
        }
        const checkedProps = {};
        if ([true, false].includes(checked) || isChecked === true) {
            checkedProps.checked = checked || isChecked;
        }
        if (onChange !== defaultOnChange) {
            checkedProps.checked = isChecked;
        }
        if ([false, true].includes(defaultChecked)) {
            checkedProps.defaultChecked = defaultChecked;
        }
        checkedProps.checked = checkedProps.checked === null ? false : checkedProps.checked;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].check, !label && _patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.standalone, className) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].checkInput), type: "checkbox", onChange: this.handleChange, "aria-invalid": !isValid, "aria-label": ariaLabel, disabled: isDisabled, required: isRequired, ref: elem => elem && (elem.indeterminate = isChecked === null) }, checkedProps, (0,_helpers__WEBPACK_IMPORTED_MODULE_1__.getOUIAProps)(Checkbox.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe))),
            label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].checkLabel, isDisabled && _patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.disabled), htmlFor: props.id },
                label,
                isRequired && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].checkLabelRequired), "aria-hidden": "true" }, _helpers_htmlConstants__WEBPACK_IMPORTED_MODULE_5__.ASTERISK)))),
            description && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].checkDescription) }, description),
            body && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Check_check__WEBPACK_IMPORTED_MODULE_4__["default"].checkBody) }, body)));
    }
}
Checkbox.displayName = 'Checkbox';
Checkbox.defaultProps = {
    className: '',
    isValid: true,
    isDisabled: false,
    isRequired: false,
    isChecked: false,
    onChange: defaultOnChange,
    ouiaSafe: true,
    component: 'div'
};
//# sourceMappingURL=Checkbox.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Chip/Chip.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Chip/Chip.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Chip": () => (/* binding */ Chip)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Tooltip */ "./node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_times_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/times-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/times-icon.js");
/* harmony import */ var _patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Chip/chip */ "./node_modules/@patternfly/react-styles/css/components/Chip/chip.js");
/* harmony import */ var _helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../helpers/GenerateId/GenerateId */ "./node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");








class Chip extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.span = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.setChipStyle = () => ({
            '--pf-c-chip__text--MaxWidth': this.props.textMaxWidth
        });
        this.renderOverflowChip = () => {
            const { children, className, onClick, ouiaId } = this.props;
            const Component = this.props.component;
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ onClick: onClick }, (this.props.textMaxWidth && Object.assign({ style: this.setChipStyle() }, this.props.style)), { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_1__.css)(_patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__["default"].chip, _patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__["default"].modifiers.overflow, className) }, (this.props.component === 'button' ? { type: 'button' } : {}), (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.getOUIAProps)('OverflowChip', ouiaId !== undefined ? ouiaId : this.state.ouiaStateId)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_1__.css)(_patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__["default"].chipText) }, children)));
        };
        this.renderChip = (randomId) => {
            const { children, tooltipPosition } = this.props;
            if (this.state.isTooltipVisible) {
                return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_4__.Tooltip, { position: tooltipPosition, content: children }, this.renderInnerChip(randomId)));
            }
            return this.renderInnerChip(randomId);
        };
        this.state = {
            isTooltipVisible: false,
            ouiaStateId: (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.getDefaultOUIAId)(Chip.displayName)
        };
    }
    componentDidMount() {
        this.setState({
            isTooltipVisible: Boolean(this.span.current && this.span.current.offsetWidth < this.span.current.scrollWidth)
        });
    }
    renderInnerChip(id) {
        const { children, className, onClick, closeBtnAriaLabel, isReadOnly, component, ouiaId } = this.props;
        const Component = component;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({}, (this.props.textMaxWidth && {
            style: this.setChipStyle()
        }), { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_1__.css)(_patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__["default"].chip, className) }, (this.state.isTooltipVisible && { tabIndex: 0 }), (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.getOUIAProps)(Chip.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId)),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { ref: this.span, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_1__.css)(_patternfly_react_styles_css_components_Chip_chip__WEBPACK_IMPORTED_MODULE_2__["default"].chipText), id: id }, children),
            !isReadOnly && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_5__.Button, { onClick: onClick, variant: "plain", "aria-label": closeBtnAriaLabel, id: `remove_${id}`, "aria-labelledby": `remove_${id} ${id}`, ouiaId: ouiaId || closeBtnAriaLabel },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_times_icon__WEBPACK_IMPORTED_MODULE_6__["default"], { "aria-hidden": "true" })))));
    }
    render() {
        const { isOverflowChip } = this.props;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_7__.GenerateId, null, randomId => (isOverflowChip ? this.renderOverflowChip() : this.renderChip(this.props.id || randomId))));
    }
}
Chip.displayName = 'Chip';
Chip.defaultProps = {
    closeBtnAriaLabel: 'close',
    className: '',
    isOverflowChip: false,
    isReadOnly: false,
    tooltipPosition: 'top',
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (_e) => undefined,
    component: 'div'
};
//# sourceMappingURL=Chip.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ChipGroup/ChipGroup.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ChipGroup/ChipGroup.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChipGroup": () => (/* binding */ ChipGroup)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/ChipGroup/chip-group */ "./node_modules/@patternfly/react-styles/css/components/ChipGroup/chip-group.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Chip */ "./node_modules/@patternfly/react-core/dist/esm/components/Chip/Chip.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tooltip */ "./node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_times_circle_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/times-circle-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/times-circle-icon.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../helpers/GenerateId/GenerateId */ "./node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");











class ChipGroup extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.headingRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.toggleCollapse = () => {
            this.setState(prevState => ({
                isOpen: !prevState.isOpen,
                isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
            }));
        };
        this.state = {
            isOpen: this.props.defaultIsOpen,
            isTooltipVisible: false
        };
    }
    componentDidMount() {
        this.setState({
            isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
        });
    }
    renderLabel(id) {
        const { categoryName, tooltipPosition } = this.props;
        const { isTooltipVisible } = this.state;
        return isTooltipVisible ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_1__.Tooltip, { position: tooltipPosition, content: categoryName },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { tabIndex: 0, ref: this.headingRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupLabel) },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { id: id }, categoryName)))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { ref: this.headingRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupLabel), id: id }, categoryName));
    }
    render() {
        const _a = this.props, { categoryName, children, className, isClosable, closeBtnAriaLabel, 'aria-label': ariaLabel, onClick, onOverflowChipClick, numChips, expandedText, collapsedText, ouiaId, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        defaultIsOpen, tooltipPosition } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        rest = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__rest)(_a, ["categoryName", "children", "className", "isClosable", "closeBtnAriaLabel", 'aria-label', "onClick", "onOverflowChipClick", "numChips", "expandedText", "collapsedText", "ouiaId", "defaultIsOpen", "tooltipPosition"]);
        const { isOpen } = this.state;
        const numChildren = react__WEBPACK_IMPORTED_MODULE_0__.Children.count(children);
        const collapsedTextResult = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__.fillTemplate)(collapsedText, {
            remaining: react__WEBPACK_IMPORTED_MODULE_0__.Children.count(children) - numChips
        });
        const renderChipGroup = (id) => {
            const chipArray = !isOpen
                ? react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children).slice(0, numChips)
                : react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroup, className, categoryName && _patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.category), role: "group" }, (categoryName && { 'aria-labelledby': id }), (!categoryName && { 'aria-label': ariaLabel }), (0,_helpers__WEBPACK_IMPORTED_MODULE_6__.getOUIAProps)(ChipGroup.displayName, ouiaId)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupMain) },
                    categoryName && this.renderLabel(id),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupList) }, (categoryName && { 'aria-labelledby': id }), (!categoryName && { 'aria-label': ariaLabel }), { role: "list" }, rest),
                        chipArray.map((child, i) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupListItem), key: i }, child))),
                        numChildren > numChips && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupListItem) },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Chip__WEBPACK_IMPORTED_MODULE_7__.Chip, { isOverflowChip: true, onClick: event => {
                                    this.toggleCollapse();
                                    onOverflowChipClick(event);
                                }, component: "button" }, isOpen ? expandedText : collapsedTextResult))))),
                isClosable && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ChipGroup_chip_group__WEBPACK_IMPORTED_MODULE_3__["default"].chipGroupClose) },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_8__.Button, { variant: "plain", "aria-label": closeBtnAriaLabel, onClick: onClick, id: `remove_group_${id}`, "aria-labelledby": `remove_group_${id} ${id}`, ouiaId: ouiaId || closeBtnAriaLabel },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_times_circle_icon__WEBPACK_IMPORTED_MODULE_9__["default"], { "aria-hidden": "true" }))))));
        };
        return numChildren === 0 ? null : react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_10__.GenerateId, null, randomId => renderChipGroup(this.props.id || randomId));
    }
}
ChipGroup.displayName = 'ChipGroup';
ChipGroup.defaultProps = {
    expandedText: 'Show Less',
    collapsedText: '${remaining} more',
    categoryName: '',
    defaultIsOpen: false,
    numChips: 3,
    isClosable: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (_e) => undefined,
    onOverflowChipClick: (_e) => undefined,
    closeBtnAriaLabel: 'Close chip group',
    tooltipPosition: 'top',
    'aria-label': 'Chip group category'
};
//# sourceMappingURL=ChipGroup.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopy.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopy.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClipboardCopy": () => (/* binding */ ClipboardCopy),
/* harmony export */   "ClipboardCopyVariant": () => (/* binding */ ClipboardCopyVariant),
/* harmony export */   "clipboardCopyFunc": () => (/* binding */ clipboardCopyFunc)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/ClipboardCopy/clipboard-copy */ "./node_modules/@patternfly/react-styles/css/components/ClipboardCopy/clipboard-copy.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _Popover__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Popover */ "./node_modules/@patternfly/react-core/dist/esm/components/Popover/Popover.js");
/* harmony import */ var _TextInput__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../TextInput */ "./node_modules/@patternfly/react-core/dist/esm/components/TextInput/TextInput.js");
/* harmony import */ var _helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers/GenerateId/GenerateId */ "./node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js");
/* harmony import */ var _ClipboardCopyButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ClipboardCopyButton */ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyButton.js");
/* harmony import */ var _ClipboardCopyToggle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ClipboardCopyToggle */ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyToggle.js");
/* harmony import */ var _ClipboardCopyExpanded__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ClipboardCopyExpanded */ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyExpanded.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");











const clipboardCopyFunc = (event, text) => {
    navigator.clipboard.writeText(text.toString());
};
var ClipboardCopyVariant;
(function (ClipboardCopyVariant) {
    ClipboardCopyVariant["inline"] = "inline";
    ClipboardCopyVariant["expansion"] = "expansion";
    ClipboardCopyVariant["inlineCompact"] = "inline-compact";
})(ClipboardCopyVariant || (ClipboardCopyVariant = {}));
class ClipboardCopy extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.timer = null;
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        this.componentDidUpdate = (prevProps, prevState) => {
            if (prevProps.children !== this.props.children) {
                this.updateText(this.props.children);
            }
        };
        this.componentWillUnmount = () => {
            if (this.timer) {
                window.clearTimeout(this.timer);
            }
        };
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        this.expandContent = (_event) => {
            this.setState(prevState => ({
                expanded: !prevState.expanded
            }));
        };
        this.updateText = (text) => {
            this.setState({ text });
            this.props.onChange(text);
        };
        this.render = () => {
            const _a = this.props, { 
            /* eslint-disable @typescript-eslint/no-unused-vars */
            isExpanded, onChange, // Don't pass to <div>
            switchDelay, 
            /* eslint-enable @typescript-eslint/no-unused-vars */
            isReadOnly, isCode, isBlock, exitDelay, maxWidth, entryDelay, onCopy, hoverTip, clickTip, textAriaLabel, toggleAriaLabel, variant, position, className, additionalActions, ouiaId, ouiaSafe, removeFindDomNode } = _a, divProps = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["isExpanded", "onChange", "switchDelay", "isReadOnly", "isCode", "isBlock", "exitDelay", "maxWidth", "entryDelay", "onCopy", "hoverTip", "clickTip", "textAriaLabel", "toggleAriaLabel", "variant", "position", "className", "additionalActions", "ouiaId", "ouiaSafe", "removeFindDomNode"]);
            const textIdPrefix = 'text-input-';
            const toggleIdPrefix = 'toggle-';
            const contentIdPrefix = 'content-';
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopy, variant === 'inline-compact' && _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.inline, isBlock && _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.block, this.state.expanded && _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.expanded, className) }, divProps, (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.getOUIAProps)(ClipboardCopy.displayName, ouiaId, ouiaSafe)),
                variant === 'inline-compact' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_5__.GenerateId, { prefix: "" }, id => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    !isCode && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyText), id: `${textIdPrefix}${id}` }, this.state.text)),
                    isCode && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyText, _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.code), id: `${textIdPrefix}${id}` }, this.state.text)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyActions) },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyActionsItem) },
                            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ClipboardCopyButton__WEBPACK_IMPORTED_MODULE_6__.ClipboardCopyButton, { variant: "plain", exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, id: `copy-button-${id}`, textId: `text-input-${id}`, "aria-label": hoverTip, onClick: (event) => {
                                    onCopy(event, this.state.text);
                                    this.setState({ copied: true });
                                }, onTooltipHidden: () => this.setState({ copied: false }) }, this.state.copied ? clickTip : hoverTip)),
                        additionalActions && additionalActions))))),
                variant !== 'inline-compact' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_5__.GenerateId, { prefix: "" }, id => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyGroup) },
                        variant === 'expansion' && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ClipboardCopyToggle__WEBPACK_IMPORTED_MODULE_7__.ClipboardCopyToggle, { isExpanded: this.state.expanded, onClick: this.expandContent, id: `${toggleIdPrefix}${id}`, textId: `${textIdPrefix}${id}`, contentId: `${contentIdPrefix}${id}`, "aria-label": toggleAriaLabel })),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextInput__WEBPACK_IMPORTED_MODULE_8__.TextInput, { isReadOnly: isReadOnly || this.state.expanded, onChange: this.updateText, value: this.state.text, id: `text-input-${id}`, "aria-label": textAriaLabel }),
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ClipboardCopyButton__WEBPACK_IMPORTED_MODULE_6__.ClipboardCopyButton, { exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, id: `copy-button-${id}`, textId: `text-input-${id}`, "aria-label": hoverTip, onClick: (event) => {
                                onCopy(event, this.state.text);
                                this.setState({ copied: true });
                            }, onTooltipHidden: () => this.setState({ copied: false }), removeFindDomNode: removeFindDomNode }, this.state.copied ? clickTip : hoverTip)),
                    this.state.expanded && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ClipboardCopyExpanded__WEBPACK_IMPORTED_MODULE_9__.ClipboardCopyExpanded, { isReadOnly: isReadOnly, isCode: isCode, id: `content-${id}`, onChange: this.updateText }, this.state.text))))))));
        };
        this.state = {
            text: Array.isArray(this.props.children)
                ? this.props.children.join('')
                : this.props.children,
            expanded: this.props.isExpanded,
            copied: false
        };
        if (this.props.switchDelay !== undefined) {
            // eslint-disable-next-line no-console
            console.warn('ClipboardCopy: switchDelay prop has been deprecated. ' +
                'The tooltip message will switch back to the hover tip as soon as the tooltip is hidden.');
        }
    }
}
ClipboardCopy.displayName = 'ClipboardCopy';
ClipboardCopy.defaultProps = {
    hoverTip: 'Copy to clipboard',
    clickTip: 'Successfully copied to clipboard!',
    isReadOnly: false,
    isExpanded: false,
    isCode: false,
    variant: 'inline',
    position: _Popover__WEBPACK_IMPORTED_MODULE_10__.PopoverPosition.top,
    maxWidth: '150px',
    exitDelay: 1500,
    entryDelay: 300,
    onCopy: clipboardCopyFunc,
    onChange: () => undefined,
    textAriaLabel: 'Copyable input',
    toggleAriaLabel: 'Show content',
    additionalActions: null,
    ouiaSafe: true,
    removeFindDomNode: false
};
//# sourceMappingURL=ClipboardCopy.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyButton.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyButton.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClipboardCopyButton": () => (/* binding */ ClipboardCopyButton)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_copy_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/copy-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/copy-icon.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tooltip */ "./node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js");





const ClipboardCopyButton = (_a) => {
    var { onClick, exitDelay = 0, entryDelay = 300, maxWidth = '100px', position = 'top', 'aria-label': ariaLabel = 'Copyable input', id, textId, children, variant = 'control', onTooltipHidden = () => { }, removeFindDomNode = false } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["onClick", "exitDelay", "entryDelay", "maxWidth", "position", 'aria-label', "id", "textId", "children", "variant", "onTooltipHidden", "removeFindDomNode"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_2__.Tooltip, { trigger: "mouseenter focus click", exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, "aria-live": "polite", aria: "none", content: react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, children), onTooltipHidden: onTooltipHidden, removeFindDomNode: removeFindDomNode },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_3__.Button, Object.assign({ type: "button", variant: variant, onClick: onClick, "aria-label": ariaLabel, id: id, "aria-labelledby": `${id} ${textId}` }, props),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_copy_icon__WEBPACK_IMPORTED_MODULE_4__["default"], null))));
};
ClipboardCopyButton.displayName = 'ClipboardCopyButton';
//# sourceMappingURL=ClipboardCopyButton.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyExpanded.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyExpanded.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClipboardCopyExpanded": () => (/* binding */ ClipboardCopyExpanded)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/ClipboardCopy/clipboard-copy */ "./node_modules/@patternfly/react-styles/css/components/ClipboardCopy/clipboard-copy.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




class ClipboardCopyExpanded extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
    }
    render() {
        const _a = this.props, { className, children, onChange, isReadOnly, isCode } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children", "onChange", "isReadOnly", "isCode"]);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ suppressContentEditableWarning: true, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_ClipboardCopy_clipboard_copy__WEBPACK_IMPORTED_MODULE_3__["default"].clipboardCopyExpandableContent, className), onInput: (e) => onChange(e.target.innerText, e), contentEditable: !isReadOnly }, props), isCode ? react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", null, children) : children));
    }
}
ClipboardCopyExpanded.displayName = 'ClipboardCopyExpanded';
ClipboardCopyExpanded.defaultProps = {
    onChange: () => undefined,
    className: '',
    isReadOnly: false,
    isCode: false
};
//# sourceMappingURL=ClipboardCopyExpanded.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyToggle.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyToggle.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClipboardCopyToggle": () => (/* binding */ ClipboardCopyToggle)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_down_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-down-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-down-icon.js");
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button */ "./node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js");





const ClipboardCopyToggle = (_a) => {
    var { onClick, id, textId, contentId, isExpanded = false } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["onClick", "id", "textId", "contentId", "isExpanded"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button__WEBPACK_IMPORTED_MODULE_2__.Button, Object.assign({ type: "button", variant: "control", onClick: onClick, id: id, "aria-labelledby": `${id} ${textId}`, "aria-controls": `${id} ${contentId}`, "aria-expanded": isExpanded }, props), isExpanded ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_down_icon__WEBPACK_IMPORTED_MODULE_3__["default"], { "aria-hidden": "true" }) : react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_4__["default"], { "aria-hidden": "true" })));
};
ClipboardCopyToggle.displayName = 'ClipboardCopyToggle';
//# sourceMappingURL=ClipboardCopyToggle.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlock.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlock.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CodeBlock": () => (/* binding */ CodeBlock)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/CodeBlock/code-block */ "./node_modules/@patternfly/react-styles/css/components/CodeBlock/code-block.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const CodeBlock = (_a) => {
    var { children = null, className, actions = null } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "actions"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlock, className) }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlockHeader) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlockActions) }, actions && actions)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlockContent) }, children)));
};
CodeBlock.displayName = 'CodeBlock';
//# sourceMappingURL=CodeBlock.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlockCode.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlockCode.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CodeBlockCode": () => (/* binding */ CodeBlockCode)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/CodeBlock/code-block */ "./node_modules/@patternfly/react-styles/css/components/CodeBlock/code-block.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const CodeBlockCode = (_a) => {
    var { children = null, className, codeClassName } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "codeClassName"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlockPre, className) }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_CodeBlock_code_block__WEBPACK_IMPORTED_MODULE_3__["default"].codeBlockCode, codeClassName) }, children)));
};
CodeBlockCode.displayName = 'CodeBlockCode';
//# sourceMappingURL=CodeBlockCode.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DatePicker/DatePicker.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DatePicker/DatePicker.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DatePicker": () => (/* binding */ DatePicker),
/* harmony export */   "yyyyMMddFormat": () => (/* binding */ yyyyMMddFormat)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DatePicker/date-picker */ "./node_modules/@patternfly/react-styles/css/components/DatePicker/date-picker.js");
/* harmony import */ var _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Button/button */ "./node_modules/@patternfly/react-styles/css/components/Button/button.js");
/* harmony import */ var _TextInput_TextInput__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../TextInput/TextInput */ "./node_modules/@patternfly/react-core/dist/esm/components/TextInput/TextInput.js");
/* harmony import */ var _Popover_Popover__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Popover/Popover */ "./node_modules/@patternfly/react-core/dist/esm/components/Popover/Popover.js");
/* harmony import */ var _InputGroup_InputGroup__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../InputGroup/InputGroup */ "./node_modules/@patternfly/react-core/dist/esm/components/InputGroup/InputGroup.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_outlined_calendar_alt_icon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/outlined-calendar-alt-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/outlined-calendar-alt-icon.js");
/* harmony import */ var _CalendarMonth__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../CalendarMonth */ "./node_modules/@patternfly/react-core/dist/esm/components/CalendarMonth/CalendarMonth.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/constants.js");
/* harmony import */ var _helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/datetimeUtils */ "./node_modules/@patternfly/react-core/dist/esm/helpers/datetimeUtils.js");













const yyyyMMddFormat = (date) => `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, '0')}-${date
    .getDate()
    .toString()
    .padStart(2, '0')}`;
const DatePickerBase = (_a, ref) => {
    var { className, locale = undefined, dateFormat = yyyyMMddFormat, dateParse = (val) => val.split('-').length === 3 && new Date(`${val}T00:00:00`), isDisabled = false, placeholder = 'YYYY-MM-DD', value: valueProp = '', 'aria-label': ariaLabel = 'Date picker', buttonAriaLabel = 'Toggle date picker', onChange = () => undefined, onBlur = () => undefined, invalidFormatText = 'Invalid date', helperText, appendTo = 'parent', popoverProps, monthFormat, weekdayFormat, longWeekdayFormat, dayFormat, weekStart, validators = [], rangeStart, style: styleProps = {}, inputProps = {} } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "locale", "dateFormat", "dateParse", "isDisabled", "placeholder", "value", 'aria-label', "buttonAriaLabel", "onChange", "onBlur", "invalidFormatText", "helperText", "appendTo", "popoverProps", "monthFormat", "weekdayFormat", "longWeekdayFormat", "dayFormat", "weekStart", "validators", "rangeStart", "style", "inputProps"]);
    const [value, setValue] = react__WEBPACK_IMPORTED_MODULE_0__.useState(valueProp);
    const [valueDate, setValueDate] = react__WEBPACK_IMPORTED_MODULE_0__.useState(dateParse(value));
    const [errorText, setErrorText] = react__WEBPACK_IMPORTED_MODULE_0__.useState('');
    const [popoverOpen, setPopoverOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [selectOpen, setSelectOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [pristine, setPristine] = react__WEBPACK_IMPORTED_MODULE_0__.useState(true);
    const widthChars = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => Math.max(dateFormat(new Date()).length, placeholder.length), [dateFormat]);
    const style = Object.assign({ '--pf-c-date-picker__input--c-form-control--width-chars': widthChars }, styleProps);
    const buttonRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const datePickerWrapperRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        setValue(valueProp);
        setValueDate(dateParse(valueProp));
    }, [valueProp]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        setPristine(!value);
        const newValueDate = dateParse(value);
        if (errorText && (0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(newValueDate)) {
            setError(newValueDate);
        }
    }, [value]);
    const setError = (date) => {
        setErrorText(validators.map(validator => validator(date)).join('\n') || '');
    };
    const onTextInput = (value) => {
        setValue(value);
        setErrorText('');
        const newValueDate = dateParse(value);
        setValueDate(newValueDate);
        if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(newValueDate)) {
            onChange(value, new Date(newValueDate));
        }
        else {
            onChange(value);
        }
    };
    const onInputBlur = () => {
        if (pristine) {
            return;
        }
        const newValueDate = dateParse(value);
        if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(newValueDate)) {
            onBlur(value, new Date(newValueDate));
            setError(newValueDate);
        }
        else {
            onBlur(value);
            setErrorText(invalidFormatText);
        }
    };
    const onDateClick = (newValueDate) => {
        const newValue = dateFormat(newValueDate);
        setValue(newValue);
        setValueDate(newValueDate);
        setError(newValueDate);
        setPopoverOpen(false);
        onChange(newValue, new Date(newValueDate));
    };
    const onKeyPress = (ev) => {
        if (ev.key === 'Enter' && value) {
            if ((0,_helpers_datetimeUtils__WEBPACK_IMPORTED_MODULE_2__.isValidDate)(valueDate)) {
                setError(valueDate);
            }
            else {
                setErrorText(invalidFormatText);
            }
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useImperativeHandle)(ref, () => ({
        setCalendarOpen: (isOpen) => setPopoverOpen(isOpen),
        toggleCalendar: (setOpen, eventKey) => {
            if (eventKey === _helpers__WEBPACK_IMPORTED_MODULE_3__.KeyTypes.Escape && popoverOpen && !selectOpen) {
                setPopoverOpen(prev => (setOpen !== undefined ? setOpen : !prev));
            }
        },
        isCalendarOpen: popoverOpen
    }), [setPopoverOpen, popoverOpen, selectOpen]);
    const getParentElement = () => datePickerWrapperRef && datePickerWrapperRef.current ? datePickerWrapperRef.current : null;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__["default"].datePicker, className), ref: datePickerWrapperRef, style: style }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Popover_Popover__WEBPACK_IMPORTED_MODULE_6__.Popover, Object.assign({ position: "bottom", bodyContent: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_CalendarMonth__WEBPACK_IMPORTED_MODULE_7__.CalendarMonth, { date: valueDate, onChange: onDateClick, locale: locale, 
                // Use truthy values of strings
                validators: validators.map(validator => (date) => !validator(date)), onSelectToggle: open => setSelectOpen(open), monthFormat: monthFormat, weekdayFormat: weekdayFormat, longWeekdayFormat: longWeekdayFormat, dayFormat: dayFormat, weekStart: weekStart, rangeStart: rangeStart, isDateFocused: true }), showClose: false, isVisible: popoverOpen, shouldClose: (_1, _2, event) => {
                event = event;
                if (event.key === _helpers__WEBPACK_IMPORTED_MODULE_3__.KeyTypes.Escape && selectOpen) {
                    event.stopPropagation();
                    setSelectOpen(false);
                    return false;
                }
                // Let our button handle toggling
                if (buttonRef.current && buttonRef.current.contains(event.target)) {
                    return false;
                }
                setPopoverOpen(false);
                if (event.key === _helpers__WEBPACK_IMPORTED_MODULE_3__.KeyTypes.Escape && popoverOpen) {
                    event.stopPropagation();
                }
                return true;
            }, withFocusTrap: true, hasNoPadding: true, hasAutoWidth: true, appendTo: appendTo === 'parent' ? getParentElement() : appendTo }, popoverProps),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__["default"].datePickerInput },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputGroup_InputGroup__WEBPACK_IMPORTED_MODULE_8__.InputGroup, null,
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_TextInput_TextInput__WEBPACK_IMPORTED_MODULE_9__.TextInput, Object.assign({ isDisabled: isDisabled, "aria-label": ariaLabel, placeholder: placeholder, validated: errorText.trim() ? 'error' : 'default', value: value, onChange: onTextInput, onBlur: onInputBlur, onKeyPress: onKeyPress }, inputProps)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", { ref: buttonRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_10__["default"].button, _patternfly_react_styles_css_components_Button_button__WEBPACK_IMPORTED_MODULE_10__["default"].modifiers.control), "aria-label": buttonAriaLabel, type: "button", onClick: () => setPopoverOpen(!popoverOpen), disabled: isDisabled },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_outlined_calendar_alt_icon__WEBPACK_IMPORTED_MODULE_11__["default"], null))))),
        helperText && react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__["default"].datePickerHelperText }, helperText),
        errorText.trim() && react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__["default"].datePickerHelperText, _patternfly_react_styles_css_components_DatePicker_date_picker__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.error) }, errorText)));
};
const DatePicker = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(DatePickerBase);
DatePicker.displayName = 'DatePicker';
//# sourceMappingURL=DatePicker.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionList.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionList.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DescriptionList": () => (/* binding */ DescriptionList)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DescriptionList/description-list */ "./node_modules/@patternfly/react-styles/css/components/DescriptionList/description-list.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");





const setBreakpointModifiers = (prefix, modifiers) => {
    const mods = modifiers;
    return Object.keys(mods || {}).reduce((acc, curr) => curr === 'default' ? Object.assign(Object.assign({}, acc), { [prefix]: mods[curr] }) : Object.assign(Object.assign({}, acc), { [`${prefix}-on-${curr}`]: mods[curr] }), {});
};
const DescriptionList = (_a) => {
    var { className = '', children = null, isHorizontal = false, isAutoColumnWidths, isAutoFit, isInlineGrid, isCompact, isFluid, isFillColumns, displaySize, columnModifier, autoFitMinModifier, termWidth, horizontalTermWidthModifier, orientation, style } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children", "isHorizontal", "isAutoColumnWidths", "isAutoFit", "isInlineGrid", "isCompact", "isFluid", "isFillColumns", "displaySize", "columnModifier", "autoFitMinModifier", "termWidth", "horizontalTermWidthModifier", "orientation", "style"]);
    if (isAutoFit && autoFitMinModifier) {
        style = Object.assign(Object.assign({}, style), setBreakpointModifiers('--pf-c-description-list--GridTemplateColumns--min', autoFitMinModifier));
    }
    if (termWidth) {
        style = Object.assign(Object.assign({}, style), { '--pf-c-description-list__term--width': termWidth });
    }
    if (isHorizontal && horizontalTermWidthModifier) {
        style = Object.assign(Object.assign({}, style), setBreakpointModifiers('--pf-c-description-list--m-horizontal__term--width', horizontalTermWidthModifier));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionList, (isHorizontal || isFluid) && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.horizontal, isAutoColumnWidths && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.autoColumnWidths, isAutoFit && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.autoFit, (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.formatBreakpointMods)(columnModifier, _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"]), (0,_helpers__WEBPACK_IMPORTED_MODULE_4__.formatBreakpointMods)(orientation, _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"]), isInlineGrid && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.inlineGrid, isCompact && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.compact, isFluid && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.fluid, isFillColumns && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.fillColumns, displaySize === 'lg' && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.displayLg, displaySize === '2xl' && _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.display_2xl, className), style: style }, props), children));
};
DescriptionList.displayName = 'DescriptionList';
//# sourceMappingURL=DescriptionList.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListDescription.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListDescription.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DescriptionListDescription": () => (/* binding */ DescriptionListDescription)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DescriptionList/description-list */ "./node_modules/@patternfly/react-styles/css/components/DescriptionList/description-list.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const DescriptionListDescription = (_a) => {
    var { children = null, className } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionListDescription, className) }, props),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: 'pf-c-description-list__text' }, children)));
};
DescriptionListDescription.displayName = 'DescriptionListDescription';
//# sourceMappingURL=DescriptionListDescription.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListGroup.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListGroup.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DescriptionListGroup": () => (/* binding */ DescriptionListGroup)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DescriptionList/description-list */ "./node_modules/@patternfly/react-styles/css/components/DescriptionList/description-list.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const DescriptionListGroup = (_a) => {
    var { className, children } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionListGroup, className) }, props), children));
};
DescriptionListGroup.displayName = 'DescriptionListGroup';
//# sourceMappingURL=DescriptionListGroup.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListTerm.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListTerm.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DescriptionListTerm": () => (/* binding */ DescriptionListTerm)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DescriptionList/description-list */ "./node_modules/@patternfly/react-styles/css/components/DescriptionList/description-list.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const DescriptionListTerm = (_a) => {
    var { children, className, icon } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "icon"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionListTerm, className) }, props),
        icon ? react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionListTermIcon) }, icon) : null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_DescriptionList_description_list__WEBPACK_IMPORTED_MODULE_3__["default"].descriptionListText) }, children)));
};
DescriptionListTerm.displayName = 'DescriptionListTerm';
//# sourceMappingURL=DescriptionListTerm.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Divider/Divider.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Divider/Divider.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Divider": () => (/* binding */ Divider),
/* harmony export */   "DividerVariant": () => (/* binding */ DividerVariant)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Divider_divider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Divider/divider */ "./node_modules/@patternfly/react-styles/css/components/Divider/divider.js");
/* harmony import */ var _helpers_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers/util */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");





var DividerVariant;
(function (DividerVariant) {
    DividerVariant["hr"] = "hr";
    DividerVariant["li"] = "li";
    DividerVariant["div"] = "div";
})(DividerVariant || (DividerVariant = {}));
const Divider = (_a) => {
    var { className, component = DividerVariant.hr, isVertical = false, inset, orientation } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "component", "isVertical", "inset", "orientation"]);
    const Component = component;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Divider_divider__WEBPACK_IMPORTED_MODULE_3__["default"].divider, isVertical && _patternfly_react_styles_css_components_Divider_divider__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.vertical, (0,_helpers_util__WEBPACK_IMPORTED_MODULE_4__.formatBreakpointMods)(inset, _patternfly_react_styles_css_components_Divider_divider__WEBPACK_IMPORTED_MODULE_3__["default"]), (0,_helpers_util__WEBPACK_IMPORTED_MODULE_4__.formatBreakpointMods)(orientation, _patternfly_react_styles_css_components_Divider_divider__WEBPACK_IMPORTED_MODULE_3__["default"]), className) }, (component !== 'hr' && { role: 'separator' }), props)));
};
Divider.displayName = 'Divider';
//# sourceMappingURL=Divider.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/Drawer.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Drawer/Drawer.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Drawer": () => (/* binding */ Drawer),
/* harmony export */   "DrawerColorVariant": () => (/* binding */ DrawerColorVariant),
/* harmony export */   "DrawerContext": () => (/* binding */ DrawerContext)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Drawer/drawer */ "./node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




var DrawerColorVariant;
(function (DrawerColorVariant) {
    DrawerColorVariant["default"] = "default";
    DrawerColorVariant["light200"] = "light-200";
})(DrawerColorVariant || (DrawerColorVariant = {}));
const DrawerContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    isExpanded: false,
    isStatic: false,
    onExpand: () => { },
    position: 'right',
    drawerRef: null,
    drawerContentRef: null,
    isInline: false
});
const Drawer = (_a) => {
    var { className = '', children, isExpanded = false, isInline = false, isStatic = false, position = 'right', onExpand = () => { } } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children", "isExpanded", "isInline", "isStatic", "position", "onExpand"]);
    const drawerRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const drawerContentRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(DrawerContext.Provider, { value: { isExpanded, isStatic, onExpand, position, drawerRef, drawerContentRef, isInline } },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].drawer, isExpanded && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.expanded, isInline && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.inline, isStatic && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers["static"], position === 'left' && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.panelLeft, position === 'bottom' && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.panelBottom, className), ref: drawerRef }, props), children)));
};
Drawer.displayName = 'Drawer';
//# sourceMappingURL=Drawer.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContent.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContent.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerContent": () => (/* binding */ DrawerContent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Drawer/drawer */ "./node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _DrawerMain__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DrawerMain */ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerMain.js");
/* harmony import */ var _Drawer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Drawer */ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/Drawer.js");






const DrawerContent = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, panelContent, colorVariant = _Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerColorVariant["default"] } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["className", "children", "panelContent", "colorVariant"]);
    const { drawerContentRef } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerContext);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DrawerMain__WEBPACK_IMPORTED_MODULE_3__.DrawerMain, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_5__["default"].drawerContent, colorVariant === _Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerColorVariant.light200 && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.light_200, className), ref: drawerContentRef }, props), children),
        panelContent));
};
DrawerContent.displayName = 'DrawerContent';
//# sourceMappingURL=DrawerContent.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContentBody.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContentBody.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerContentBody": () => (/* binding */ DrawerContentBody)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Drawer/drawer */ "./node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const DrawerContentBody = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, hasPadding = false } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children", "hasPadding"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].drawerBody, hasPadding && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].modifiers.padding, className) }, props), children));
};
DrawerContentBody.displayName = 'DrawerContentBody';
//# sourceMappingURL=DrawerContentBody.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerMain.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerMain.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerMain": () => (/* binding */ DrawerMain)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Drawer/drawer */ "./node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");




const DrawerMain = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "children"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_2__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_3__["default"].drawerMain, className) }, props), children));
};
DrawerMain.displayName = 'DrawerMain';
//# sourceMappingURL=DrawerMain.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerPanelContent.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerPanelContent.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DrawerPanelContent": () => (/* binding */ DrawerPanelContent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Drawer/drawer */ "./node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _Drawer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Drawer */ "./node_modules/@patternfly/react-core/dist/esm/components/Drawer/Drawer.js");
/* harmony import */ var _helpers_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers/util */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../helpers/GenerateId/GenerateId */ "./node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js");







let isResizing = null;
let newSize = 0;
const DrawerPanelContent = (_a) => {
    var { className = '', id, children, hasNoBorder = false, isResizable = false, onResize, minSize, defaultSize, maxSize, increment = 5, resizeAriaLabel = 'Resize', widths, colorVariant = _Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerColorVariant["default"] } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["className", "id", "children", "hasNoBorder", "isResizable", "onResize", "minSize", "defaultSize", "maxSize", "increment", "resizeAriaLabel", "widths", "colorVariant"]);
    const panel = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const splitterRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
    const [separatorValue, setSeparatorValue] = react__WEBPACK_IMPORTED_MODULE_0__.useState(0);
    const { position, isExpanded, isStatic, onExpand, drawerRef, drawerContentRef, isInline } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerContext);
    const hidden = isStatic ? false : !isExpanded;
    const [isExpandedInternal, setIsExpandedInternal] = react__WEBPACK_IMPORTED_MODULE_0__.useState(!hidden);
    let currWidth = 0;
    let panelRect;
    let right;
    let left;
    let bottom;
    let setInitialVals = true;
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (!isStatic && isExpanded) {
            setIsExpandedInternal(isExpanded);
        }
    }, [isStatic, isExpanded]);
    const calcValueNow = () => {
        let splitterPos;
        let drawerSize;
        if (isInline && position === 'right') {
            splitterPos = panel.current.getBoundingClientRect().right - splitterRef.current.getBoundingClientRect().left;
            drawerSize = drawerRef.current.getBoundingClientRect().right - drawerRef.current.getBoundingClientRect().left;
        }
        else if (isInline && position === 'left') {
            splitterPos = splitterRef.current.getBoundingClientRect().right - panel.current.getBoundingClientRect().left;
            drawerSize = drawerRef.current.getBoundingClientRect().right - drawerRef.current.getBoundingClientRect().left;
        }
        else if (position === 'right') {
            splitterPos =
                drawerContentRef.current.getBoundingClientRect().right - splitterRef.current.getBoundingClientRect().left;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
        }
        else if (position === 'left') {
            splitterPos =
                splitterRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
        }
        else if (position === 'bottom') {
            splitterPos =
                drawerContentRef.current.getBoundingClientRect().bottom - splitterRef.current.getBoundingClientRect().top;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().bottom - drawerContentRef.current.getBoundingClientRect().top;
        }
        const newSplitterPos = (splitterPos / drawerSize) * 100;
        return Math.round((newSplitterPos + Number.EPSILON) * 100) / 100;
    };
    const handleTouchStart = (e) => {
        e.stopPropagation();
        document.addEventListener('touchmove', callbackTouchMove, { passive: false });
        document.addEventListener('touchend', callbackTouchEnd);
        isResizing = true;
    };
    const handleMousedown = (e) => {
        e.stopPropagation();
        e.preventDefault();
        document.addEventListener('mousemove', callbackMouseMove);
        document.addEventListener('mouseup', callbackMouseUp);
        drawerRef.current.classList.add((0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.resizing));
        isResizing = true;
        setInitialVals = true;
    };
    const handleMouseMove = (e) => {
        const mousePos = position === 'bottom' ? e.clientY : e.clientX;
        handleControlMove(e, mousePos);
    };
    const handleTouchMove = (e) => {
        e.preventDefault();
        e.stopImmediatePropagation();
        const touchPos = position === 'bottom' ? e.touches[0].clientY : e.touches[0].clientX;
        handleControlMove(e, touchPos);
    };
    const handleControlMove = (e, controlPosition) => {
        e.stopPropagation();
        if (!isResizing) {
            return;
        }
        if (setInitialVals) {
            panelRect = panel.current.getBoundingClientRect();
            right = panelRect.right;
            left = panelRect.left;
            bottom = panelRect.bottom;
            setInitialVals = false;
        }
        const mousePos = controlPosition;
        let newSize = 0;
        if (position === 'right') {
            newSize = right - mousePos;
        }
        else if (position === 'left') {
            newSize = mousePos - left;
        }
        else {
            newSize = bottom - mousePos;
        }
        if (position === 'bottom') {
            panel.current.style.overflowAnchor = 'none';
        }
        panel.current.style.setProperty('--pf-c-drawer__panel--md--FlexBasis', newSize + 'px');
        currWidth = newSize;
        setSeparatorValue(calcValueNow());
    };
    const handleMouseup = () => {
        if (!isResizing) {
            return;
        }
        drawerRef.current.classList.remove((0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.resizing));
        isResizing = false;
        onResize && onResize(currWidth, id);
        setInitialVals = true;
        document.removeEventListener('mousemove', callbackMouseMove);
        document.removeEventListener('mouseup', callbackMouseUp);
    };
    const handleTouchEnd = (e) => {
        e.stopPropagation();
        if (!isResizing) {
            return;
        }
        isResizing = false;
        onResize && onResize(currWidth, id);
        document.removeEventListener('touchmove', callbackTouchMove);
        document.removeEventListener('touchend', callbackTouchEnd);
    };
    const callbackMouseMove = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(handleMouseMove, []);
    const callbackTouchEnd = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(handleTouchEnd, []);
    const callbackTouchMove = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(handleTouchMove, []);
    const callbackMouseUp = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(handleMouseup, []);
    const handleKeys = (e) => {
        const key = e.key;
        if (key !== 'Escape' &&
            key !== 'Enter' &&
            key !== 'ArrowUp' &&
            key !== 'ArrowDown' &&
            key !== 'ArrowLeft' &&
            key !== 'ArrowRight') {
            if (isResizing) {
                e.preventDefault();
            }
            return;
        }
        e.preventDefault();
        if (key === 'Escape' || key === 'Enter') {
            onResize && onResize(currWidth, id);
        }
        const panelRect = panel.current.getBoundingClientRect();
        newSize = position === 'bottom' ? panelRect.height : panelRect.width;
        let delta = 0;
        if (key === 'ArrowRight') {
            delta = position === 'left' ? increment : -increment;
        }
        else if (key === 'ArrowLeft') {
            delta = position === 'left' ? -increment : increment;
        }
        else if (key === 'ArrowUp') {
            delta = increment;
        }
        else if (key === 'ArrowDown') {
            delta = -increment;
        }
        newSize = newSize + delta;
        if (position === 'bottom') {
            panel.current.style.overflowAnchor = 'none';
        }
        panel.current.style.setProperty('--pf-c-drawer__panel--md--FlexBasis', newSize + 'px');
        currWidth = newSize;
        setSeparatorValue(calcValueNow());
    };
    const boundaryCssVars = {};
    if (defaultSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis'] = defaultSize;
    }
    if (minSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis--min'] = minSize;
    }
    if (maxSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis--max'] = maxSize;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_GenerateId_GenerateId__WEBPACK_IMPORTED_MODULE_5__.GenerateId, { prefix: "pf-drawer-panel-" }, panelId => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ id: id || panelId, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].drawerPanel, isResizable && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.resizable, hasNoBorder && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.noBorder, (0,_helpers_util__WEBPACK_IMPORTED_MODULE_6__.formatBreakpointMods)(widths, _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"]), colorVariant === _Drawer__WEBPACK_IMPORTED_MODULE_1__.DrawerColorVariant.light200 && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.light_200, className), ref: panel, onTransitionEnd: ev => {
            if (!hidden && ev.nativeEvent.propertyName === 'transform') {
                onExpand();
            }
            setIsExpandedInternal(!hidden);
        }, hidden: hidden }, ((defaultSize || minSize || maxSize) && {
        style: boundaryCssVars
    }), props), isExpandedInternal && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        isResizable && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].drawerSplitter, position !== 'bottom' && _patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.vertical), role: "separator", tabIndex: 0, "aria-orientation": position === 'bottom' ? 'horizontal' : 'vertical', "aria-label": resizeAriaLabel, "aria-valuenow": separatorValue, "aria-valuemin": 0, "aria-valuemax": 100, "aria-controls": id || panelId, onMouseDown: handleMousedown, onKeyDown: handleKeys, onTouchStart: handleTouchStart, ref: splitterRef },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].drawerSplitterHandle), "aria-hidden": true })),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Drawer_drawer__WEBPACK_IMPORTED_MODULE_4__["default"].drawerPanelMain) }, children))),
        !isResizable && children))))));
};
DrawerPanelContent.displayName = 'DrawerPanelContent';
//# sourceMappingURL=DrawerPanelContent.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownItem": () => (/* binding */ DropdownItem)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _InternalDropdownItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./InternalDropdownItem */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/InternalDropdownItem.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");





const DropdownItem = (_a) => {
    var { children, className, component = 'a', isDisabled = false, isAriaDisabled = false, isPlainText = false, href, tooltip, tooltipProps = {}, listItemClassName, onClick, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref, // Types of Ref are different for React.FunctionComponent vs React.Component
    additionalChild, customChild, tabIndex = -1, icon = null, autoFocus, description = null, styleChildren, ouiaId, ouiaSafe } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "component", "isDisabled", "isAriaDisabled", "isPlainText", "href", "tooltip", "tooltipProps", "listItemClassName", "onClick", "ref", "additionalChild", "customChild", "tabIndex", "icon", "autoFocus", "description", "styleChildren", "ouiaId", "ouiaSafe"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_2__.useOUIAProps)(DropdownItem.displayName, ouiaId, ouiaSafe);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_3__.DropdownArrowContext.Consumer, null, context => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InternalDropdownItem__WEBPACK_IMPORTED_MODULE_4__.InternalDropdownItem, Object.assign({ context: context, role: "menuitem", tabIndex: tabIndex, className: className, component: component, isDisabled: isDisabled, isAriaDisabled: isAriaDisabled, isPlainText: isPlainText, href: href, tooltip: tooltip, tooltipProps: tooltipProps, listItemClassName: listItemClassName, onClick: onClick, additionalChild: additionalChild, customChild: customChild, icon: icon, autoFocus: autoFocus, styleChildren: styleChildren, description: description }, ouiaProps, props), children))));
};
DropdownItem.displayName = 'DropdownItem';
//# sourceMappingURL=DropdownItem.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownMenu.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownMenu.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownMenu": () => (/* binding */ DropdownMenu)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Dropdown/dropdown */ "./node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/util */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");







class DropdownMenu extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.refsCollection = [];
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.onKeyDown);
        };
        this.onKeyDown = (event) => {
            if (!this.props.isOpen ||
                !Array.from(document.activeElement.classList).find(className => DropdownMenu.validToggleClasses.concat(this.context.toggleClass).includes(className))) {
                return;
            }
            const refs = this.refsCollection;
            if (event.key === 'ArrowDown') {
                const firstFocusTargetCollection = refs.find(ref => ref && ref[0] && !ref[0].hasAttribute('disabled'));
                DropdownMenu.focusFirstRef(firstFocusTargetCollection);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowUp') {
                const collectionLength = refs.length;
                const lastFocusTargetCollection = refs.slice(collectionLength - 1, collectionLength);
                const lastFocusTarget = lastFocusTargetCollection && lastFocusTargetCollection[0];
                DropdownMenu.focusFirstRef(lastFocusTarget);
                event.stopPropagation();
            }
        };
        this.childKeyHandler = (index, innerIndex, position, custom = false) => {
            (0,_helpers_util__WEBPACK_IMPORTED_MODULE_2__.keyHandler)(index, innerIndex, position, this.refsCollection, this.props.isGrouped ? this.refsCollection : react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(this.props.children), custom);
        };
        this.sendRef = (index, nodes, isDisabled, isSeparator) => {
            this.refsCollection[index] = [];
            nodes.map((node, innerIndex) => {
                if (!node) {
                    this.refsCollection[index][innerIndex] = null;
                }
                else if (!node.getAttribute) {
                    // eslint-disable-next-line react/no-find-dom-node
                    this.refsCollection[index][innerIndex] = react_dom__WEBPACK_IMPORTED_MODULE_1__.findDOMNode(node);
                }
                else if (isSeparator) {
                    this.refsCollection[index][innerIndex] = null;
                }
                else {
                    this.refsCollection[index][innerIndex] = node;
                }
            });
        };
    }
    componentDidMount() {
        document.addEventListener('keydown', this.onKeyDown);
        const { autoFocus } = this.props;
        if (autoFocus) {
            // Focus first non-disabled element
            const focusTargetCollection = this.refsCollection.find(ref => ref && ref[0] && !ref[0].hasAttribute('disabled'));
            const focusTarget = focusTargetCollection && focusTargetCollection[0];
            if (focusTarget && focusTarget.focus) {
                setTimeout(() => focusTarget.focus());
            }
        }
    }
    shouldComponentUpdate() {
        // reset refsCollection before updating to account for child removal between mounts
        this.refsCollection = [];
        return true;
    }
    extendChildren() {
        const { children, isGrouped } = this.props;
        if (isGrouped) {
            let index = 0;
            return react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, groupedChildren => {
                const group = groupedChildren;
                const props = {};
                if (group.props && group.props.children) {
                    if (Array.isArray(group.props.children)) {
                        props.children = react__WEBPACK_IMPORTED_MODULE_0__.Children.map(group.props.children, option => react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(option, {
                            index: index++
                        }));
                    }
                    else {
                        props.children = react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(group.props.children, {
                            index: index++
                        });
                    }
                }
                return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(group, props);
            });
        }
        return react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, (child, index) => react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(child, {
            index
        }));
    }
    render() {
        const _a = this.props, { className, isOpen, position, children, component, isGrouped, setMenuComponentRef, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        openedOnEnter, alignments } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__rest)(_a, ["className", "isOpen", "position", "children", "component", "isGrouped", "setMenuComponentRef", "openedOnEnter", "alignments"]);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownArrowContext.Provider, { value: {
                keyHandler: this.childKeyHandler,
                sendRef: this.sendRef
            } }, component === 'div' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext.Consumer, null, ({ onSelect, menuClass }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__.css)(menuClass, position === _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownPosition.right && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"].modifiers.alignRight, (0,_helpers_util__WEBPACK_IMPORTED_MODULE_2__.formatBreakpointMods)(alignments, _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"], 'align-'), className), hidden: !isOpen, onClick: event => onSelect && onSelect(event), ref: setMenuComponentRef }, children)))) : ((isGrouped && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext.Consumer, null, ({ menuClass, menuComponent }) => {
            const MenuComponent = (menuComponent || 'div');
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuComponent, Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__.css)(menuClass, position === _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownPosition.right && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"].modifiers.alignRight, (0,_helpers_util__WEBPACK_IMPORTED_MODULE_2__.formatBreakpointMods)(alignments, _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"], 'align-'), className), hidden: !isOpen, role: "menu", ref: setMenuComponentRef }), this.extendChildren()));
        }))) || (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext.Consumer, null, ({ menuClass, menuComponent }) => {
            const MenuComponent = (menuComponent || component);
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuComponent, Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__.css)(menuClass, position === _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownPosition.right && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"].modifiers.alignRight, (0,_helpers_util__WEBPACK_IMPORTED_MODULE_2__.formatBreakpointMods)(alignments, _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"], 'align-'), className), hidden: !isOpen, role: "menu", ref: setMenuComponentRef }), this.extendChildren()));
        })))));
    }
}
DropdownMenu.displayName = 'DropdownMenu';
DropdownMenu.defaultProps = {
    className: '',
    isOpen: true,
    openedOnEnter: false,
    autoFocus: true,
    position: _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownPosition.left,
    component: 'ul',
    isGrouped: false,
    setMenuComponentRef: null
};
DropdownMenu.validToggleClasses = [_patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"].dropdownToggle, _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_6__["default"].dropdownToggleButton];
DropdownMenu.focusFirstRef = (refCollection) => {
    if (refCollection && refCollection[0] && refCollection[0].focus) {
        setTimeout(() => refCollection[0].focus());
    }
};
DropdownMenu.contextType = _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext;
//# sourceMappingURL=DropdownMenu.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownSeparator.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownSeparator.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownSeparator": () => (/* binding */ DropdownSeparator)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _InternalDropdownItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./InternalDropdownItem */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/InternalDropdownItem.js");
/* harmony import */ var _Divider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Divider */ "./node_modules/@patternfly/react-core/dist/esm/components/Divider/Divider.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");






const DropdownSeparator = (_a) => {
    var { className = '', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref, // Types of Ref are different for React.FunctionComponent vs React.Component
    ouiaId, ouiaSafe } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["className", "ref", "ouiaId", "ouiaSafe"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_2__.useOUIAProps)(DropdownSeparator.displayName, ouiaId, ouiaSafe);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_3__.DropdownArrowContext.Consumer, null, context => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InternalDropdownItem__WEBPACK_IMPORTED_MODULE_4__.InternalDropdownItem, Object.assign({}, props, { context: context, component: react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Divider__WEBPACK_IMPORTED_MODULE_5__.Divider, { component: _Divider__WEBPACK_IMPORTED_MODULE_5__.DividerVariant.div }), className: className, role: "separator" }, ouiaProps)))));
};
DropdownSeparator.displayName = 'DropdownSeparator';
//# sourceMappingURL=DropdownSeparator.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownToggle": () => (/* binding */ DropdownToggle)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/caret-down-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/caret-down-icon.js");
/* harmony import */ var _Toggle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Toggle */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/Toggle.js");
/* harmony import */ var _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Dropdown/dropdown */ "./node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");








const DropdownToggle = (_a) => {
    var { id = '', children = null, className = '', isOpen = false, parentRef = null, getMenuRef = null, isDisabled = false, isPlain = false, isText = false, isPrimary = false, toggleVariant = 'default', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    isActive = false, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle = (_isOpen) => undefined, icon = null, toggleIndicator: ToggleIndicator = _patternfly_react_icons_dist_esm_icons_caret_down_icon__WEBPACK_IMPORTED_MODULE_1__["default"], splitButtonItems, splitButtonVariant = 'checkbox', 'aria-haspopup': ariaHasPopup, ouiaId, ouiaSafe, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref } = _a, // Types of Ref are different for React.FunctionComponent vs React.Component
    props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["id", "children", "className", "isOpen", "parentRef", "getMenuRef", "isDisabled", "isPlain", "isText", "isPrimary", "toggleVariant", "isActive", "onToggle", "icon", "toggleIndicator", "splitButtonItems", "splitButtonVariant", 'aria-haspopup', "ouiaId", "ouiaSafe", "ref"]);
    const ouiaProps = (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.useOUIAProps)(DropdownToggle.displayName, ouiaId, ouiaSafe);
    const toggle = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext.Consumer, null, ({ toggleTextClass, toggleIndicatorClass, toggleIconClass }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Toggle__WEBPACK_IMPORTED_MODULE_5__.Toggle, Object.assign({}, props, { id: id, className: className, isOpen: isOpen, parentRef: parentRef, getMenuRef: getMenuRef, isActive: isActive, isDisabled: isDisabled, isPlain: isPlain, isText: isText, isPrimary: isPrimary, toggleVariant: toggleVariant, onToggle: onToggle, "aria-haspopup": ariaHasPopup }, ouiaProps, (splitButtonItems && { isSplitButton: true, 'aria-label': props['aria-label'] || 'Select' })),
        icon && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_6__.css)(toggleIconClass) }, icon),
        children && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: ToggleIndicator && (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_6__.css)(toggleTextClass) }, children),
        ToggleIndicator && (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_6__.css)(!splitButtonItems && toggleIndicatorClass) },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(ToggleIndicator, null)))))));
    if (splitButtonItems) {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_6__.css)(_patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].dropdownToggle, _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.splitButton, splitButtonVariant === 'action' && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.action, (toggleVariant === 'primary' || isPrimary) && splitButtonVariant === 'action' && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.primary, toggleVariant === 'secondary' && splitButtonVariant === 'action' && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.secondary, isDisabled && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_7__["default"].modifiers.disabled) },
            splitButtonItems,
            toggle));
    }
    return toggle;
};
DropdownToggle.displayName = 'DropdownToggle';
//# sourceMappingURL=DropdownToggle.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownWithContext.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownWithContext.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownWithContext": () => (/* binding */ DropdownWithContext)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Dropdown/dropdown */ "./node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _DropdownMenu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DropdownMenu */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownMenu.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js");
/* harmony import */ var _helpers_Popper_Popper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../helpers/Popper/Popper */ "./node_modules/@patternfly/react-core/dist/esm/helpers/Popper/Popper.js");








class DropdownWithContext extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.openedOnEnter = false;
        this.baseComponentRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.menuComponentRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.onEnter = () => {
            this.openedOnEnter = true;
        };
        this.setMenuComponentRef = (element) => {
            this.menuComponentRef = element;
        };
        this.getMenuComponentRef = () => this.menuComponentRef;
        if (props.dropdownItems && props.dropdownItems.length > 0 && props.children) {
            // eslint-disable-next-line no-console
            console.error('Children and dropdownItems props have been provided. Only the dropdownItems prop items will be rendered');
        }
    }
    componentDidUpdate() {
        if (!this.props.isOpen) {
            this.openedOnEnter = false;
        }
    }
    render() {
        const _a = this.props, { children, className, direction, dropdownItems, isOpen, isPlain, isText, isGrouped, isFullHeight, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSelect, position, toggle, autoFocus, menuAppendTo, isFlipEnabled, removeFindDomNode, zIndex } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__rest)(_a, ["children", "className", "direction", "dropdownItems", "isOpen", "isPlain", "isText", "isGrouped", "isFullHeight", "onSelect", "position", "toggle", "autoFocus", "menuAppendTo", "isFlipEnabled", "removeFindDomNode", "zIndex"]);
        const id = toggle.props.id || `pf-dropdown-toggle-id-${DropdownWithContext.currentId++}`;
        let component;
        let renderedContent;
        let ariaHasPopup = false;
        if (dropdownItems && dropdownItems.length > 0) {
            component = 'ul';
            renderedContent = dropdownItems;
            ariaHasPopup = true;
        }
        else {
            component = 'div';
            renderedContent = react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children);
        }
        const openedOnEnter = this.openedOnEnter;
        const isStatic = isFlipEnabled && menuAppendTo !== 'inline';
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownContext.Consumer, null, ({ baseClass, baseComponent, id: contextId, ouiaId, ouiaComponentType, ouiaSafe, alignments }) => {
            const BaseComponent = baseComponent;
            const menuContainer = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DropdownMenu__WEBPACK_IMPORTED_MODULE_3__.DropdownMenu, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(isStatic && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers["static"]), setMenuComponentRef: this.setMenuComponentRef, component: component, isOpen: isOpen, position: position, "aria-labelledby": contextId ? `${contextId}-toggle` : id, isGrouped: isGrouped, autoFocus: openedOnEnter && autoFocus, alignments: alignments }, renderedContent));
            const popperContainer = (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(baseClass, direction === _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownDirection.up && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.top, position === _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownPosition.right && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.alignRight, isOpen && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.expanded, className) }, isOpen && menuContainer));
            const mainContainer = (react__WEBPACK_IMPORTED_MODULE_0__.createElement(BaseComponent, Object.assign({}, props, { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_4__.css)(baseClass, direction === _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownDirection.up && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.top, position === _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownPosition.right && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.alignRight, isOpen && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.expanded, isFullHeight && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"].modifiers.fullHeight, className), ref: this.baseComponentRef }, (0,_helpers__WEBPACK_IMPORTED_MODULE_6__.getOUIAProps)(ouiaComponentType, ouiaId, ouiaSafe)),
                react__WEBPACK_IMPORTED_MODULE_0__.Children.map(toggle, oneToggle => react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(oneToggle, {
                    parentRef: this.baseComponentRef,
                    getMenuRef: this.getMenuComponentRef,
                    isOpen,
                    id,
                    isPlain,
                    isText,
                    'aria-haspopup': ariaHasPopup,
                    onEnter: () => {
                        this.onEnter();
                        oneToggle.props.onEnter && oneToggle.props.onEnter();
                    }
                })),
                menuAppendTo === 'inline' && isOpen && menuContainer));
            const getParentElement = () => {
                if (this.baseComponentRef && this.baseComponentRef.current) {
                    return this.baseComponentRef.current.parentElement;
                }
                return null;
            };
            return menuAppendTo === 'inline' ? (mainContainer) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers_Popper_Popper__WEBPACK_IMPORTED_MODULE_7__.Popper, { trigger: mainContainer, popper: popperContainer, direction: direction, position: position, appendTo: menuAppendTo === 'parent' ? getParentElement() : menuAppendTo, isVisible: isOpen, removeFindDomNode: removeFindDomNode, zIndex: zIndex, popperMatchesTriggerWidth: false }));
        }));
    }
}
DropdownWithContext.displayName = 'DropdownWithContext';
// seed for the aria-labelledby ID
DropdownWithContext.currentId = 0;
DropdownWithContext.defaultProps = {
    className: '',
    dropdownItems: [],
    isOpen: false,
    isPlain: false,
    isText: false,
    isGrouped: false,
    position: _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownPosition.left,
    direction: _dropdownConstants__WEBPACK_IMPORTED_MODULE_2__.DropdownDirection.down,
    onSelect: () => undefined,
    autoFocus: true,
    menuAppendTo: 'inline',
    isFlipEnabled: true
};
//# sourceMappingURL=DropdownWithContext.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/InternalDropdownItem.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/InternalDropdownItem.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InternalDropdownItem": () => (/* binding */ InternalDropdownItem)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _helpers_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/constants */ "./node_modules/@patternfly/react-core/dist/esm/helpers/constants.js");
/* harmony import */ var _helpers_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../helpers/util */ "./node_modules/@patternfly/react-core/dist/esm/helpers/util.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Tooltip */ "./node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js");
/* harmony import */ var _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Dropdown/dropdown */ "./node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js");








class InternalDropdownItem extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.ref = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.additionalRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.getInnerNode = (node) => (node && node.childNodes && node.childNodes.length ? node.childNodes[0] : node);
        this.onKeyDown = (event) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
            // Detected key press on this item, notify the menu parent so that the appropriate item can be focused
            const innerIndex = event.target === this.ref.current ? 0 : 1;
            if (!this.props.customChild) {
                event.preventDefault();
            }
            if (event.key === 'ArrowUp') {
                (_b = (_a = this.props.context) === null || _a === void 0 ? void 0 : _a.keyHandler) === null || _b === void 0 ? void 0 : _b.call(_a, this.props.index, innerIndex, _helpers_constants__WEBPACK_IMPORTED_MODULE_1__.KEYHANDLER_DIRECTION.UP);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowDown') {
                (_d = (_c = this.props.context) === null || _c === void 0 ? void 0 : _c.keyHandler) === null || _d === void 0 ? void 0 : _d.call(_c, this.props.index, innerIndex, _helpers_constants__WEBPACK_IMPORTED_MODULE_1__.KEYHANDLER_DIRECTION.DOWN);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowRight') {
                (_f = (_e = this.props.context) === null || _e === void 0 ? void 0 : _e.keyHandler) === null || _f === void 0 ? void 0 : _f.call(_e, this.props.index, innerIndex, _helpers_constants__WEBPACK_IMPORTED_MODULE_1__.KEYHANDLER_DIRECTION.RIGHT);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowLeft') {
                (_h = (_g = this.props.context) === null || _g === void 0 ? void 0 : _g.keyHandler) === null || _h === void 0 ? void 0 : _h.call(_g, this.props.index, innerIndex, _helpers_constants__WEBPACK_IMPORTED_MODULE_1__.KEYHANDLER_DIRECTION.LEFT);
                event.stopPropagation();
            }
            else if (event.key === 'Enter' || event.key === ' ') {
                event.target.click();
                this.props.enterTriggersArrowDown &&
                    ((_k = (_j = this.props.context) === null || _j === void 0 ? void 0 : _j.keyHandler) === null || _k === void 0 ? void 0 : _k.call(_j, this.props.index, innerIndex, _helpers_constants__WEBPACK_IMPORTED_MODULE_1__.KEYHANDLER_DIRECTION.DOWN));
            }
        };
        this.componentRef = (element) => {
            this.ref.current = element;
            const { component } = this.props;
            const ref = component.ref;
            if (ref) {
                if (typeof ref === 'function') {
                    ref(element);
                }
                else {
                    ref.current = element;
                }
            }
        };
    }
    componentDidMount() {
        var _a;
        const { context, index, isDisabled, role, customChild, autoFocus } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        (_a = context === null || context === void 0 ? void 0 : context.sendRef) === null || _a === void 0 ? void 0 : _a.call(context, index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
        autoFocus && setTimeout(() => customRef.focus());
    }
    componentDidUpdate() {
        var _a;
        const { context, index, isDisabled, role, customChild } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        (_a = context === null || context === void 0 ? void 0 : context.sendRef) === null || _a === void 0 ? void 0 : _a.call(context, index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }
    extendAdditionalChildRef() {
        const { additionalChild } = this.props;
        return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(additionalChild, {
            ref: this.additionalRef
        });
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { className, children, context, onClick, component, role, isDisabled, isAriaDisabled, isPlainText, index, href, tooltip, tooltipProps, id, componentID, listItemClassName, additionalChild, customChild, enterTriggersArrowDown, icon, autoFocus, styleChildren, description, inoperableEvents } = _a, additionalProps = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["className", "children", "context", "onClick", "component", "role", "isDisabled", "isAriaDisabled", "isPlainText", "index", "href", "tooltip", "tooltipProps", "id", "componentID", "listItemClassName", "additionalChild", "customChild", "enterTriggersArrowDown", "icon", "autoFocus", "styleChildren", "description", "inoperableEvents"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        let classes = (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(icon && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.icon, isAriaDisabled && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.ariaDisabled, className);
        if (component === 'a') {
            additionalProps['aria-disabled'] = isDisabled || isAriaDisabled;
        }
        else if (component === 'button') {
            additionalProps['aria-disabled'] = isDisabled || isAriaDisabled;
            additionalProps.type = additionalProps.type || 'button';
        }
        const renderWithTooltip = (childNode) => tooltip ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.Tooltip, Object.assign({ content: tooltip }, tooltipProps), childNode)) : (childNode);
        const renderClonedComponent = (element) => react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(element, Object.assign(Object.assign({}, (styleChildren && {
            className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(element.props.className, classes)
        })), (this.props.role !== 'separator' && { role, ref: this.componentRef })));
        const renderDefaultComponent = (tag) => {
            const Component = tag;
            const componentContent = description ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].dropdownMenuItemMain },
                    icon && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].dropdownMenuItemIcon) }, icon),
                    children),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].dropdownMenuItemDescription }, description))) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                icon && react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(_patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].dropdownMenuItemIcon) }, icon),
                children));
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, Object.assign({}, additionalProps, (isDisabled || isAriaDisabled ? (0,_helpers_util__WEBPACK_IMPORTED_MODULE_6__.preventedEvents)(inoperableEvents) : null), { href: href, ref: this.ref, className: classes, id: componentID, role: role }), componentContent));
        };
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_7__.DropdownContext.Consumer, null, ({ onSelect, itemClass, disabledClass, plainTextClass }) => {
            if (this.props.role !== 'separator') {
                classes = (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_3__.css)(classes, isDisabled && disabledClass, isPlainText && plainTextClass, itemClass, description && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"].modifiers.description);
            }
            if (customChild) {
                return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(customChild, {
                    ref: this.ref,
                    onKeyDown: this.onKeyDown
                });
            }
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", Object.assign({}, (listItemClassName && { className: listItemClassName }), { role: "none", onKeyDown: this.onKeyDown, onClick: (event) => {
                    if (!isDisabled && !isAriaDisabled) {
                        onClick === null || onClick === void 0 ? void 0 : onClick(event);
                        onSelect === null || onSelect === void 0 ? void 0 : onSelect(event);
                    }
                }, id: id }),
                renderWithTooltip(react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(component)
                    ? renderClonedComponent(component)
                    : renderDefaultComponent(component)),
                additionalChild && this.extendAdditionalChildRef()));
        }));
    }
}
InternalDropdownItem.displayName = 'InternalDropdownItem';
InternalDropdownItem.defaultProps = {
    className: '',
    component: 'a',
    role: 'none',
    isDisabled: false,
    isPlainText: false,
    tooltipProps: {},
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (event) => undefined,
    index: -1,
    context: {
        keyHandler: () => { },
        sendRef: () => { }
    },
    enterTriggersArrowDown: false,
    icon: null,
    styleChildren: true,
    description: null,
    inoperableEvents: ['onClick', 'onKeyPress']
};
//# sourceMappingURL=InternalDropdownItem.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/Toggle.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/Toggle.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Toggle": () => (/* binding */ Toggle)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @patternfly/react-styles/css/components/Dropdown/dropdown */ "./node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js");
/* harmony import */ var _dropdownConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdownConstants */ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _helpers_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/constants */ "./node_modules/@patternfly/react-core/dist/esm/helpers/constants.js");






const buttonVariantStyles = {
    default: '',
    primary: _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.primary,
    secondary: _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.secondary
};
class Toggle extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor() {
        super(...arguments);
        this.buttonRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.componentDidMount = () => {
            document.addEventListener('click', this.onDocClick);
            document.addEventListener('touchstart', this.onDocClick);
            document.addEventListener('keydown', this.onEscPress);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('click', this.onDocClick);
            document.removeEventListener('touchstart', this.onDocClick);
            document.removeEventListener('keydown', this.onEscPress);
        };
        this.onDocClick = (event) => {
            const { isOpen, parentRef, onToggle, getMenuRef } = this.props;
            const menuRef = getMenuRef && getMenuRef();
            const clickedOnToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const clickedWithinMenu = menuRef && menuRef.contains && menuRef.contains(event.target);
            if (isOpen && !(clickedOnToggle || clickedWithinMenu)) {
                onToggle === null || onToggle === void 0 ? void 0 : onToggle(false, event);
            }
        };
        this.onEscPress = (event) => {
            var _a, _b, _c;
            const { parentRef, getMenuRef } = this.props;
            const menuRef = getMenuRef && getMenuRef();
            const escFromToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const escFromWithinMenu = menuRef && menuRef.contains && menuRef.contains(event.target);
            if (this.props.isOpen &&
                (event.key === _helpers_constants__WEBPACK_IMPORTED_MODULE_2__.KeyTypes.Escape || event.key === 'Tab') &&
                (escFromToggle || escFromWithinMenu)) {
                (_b = (_a = this.props).onToggle) === null || _b === void 0 ? void 0 : _b.call(_a, false, event);
                (_c = this.buttonRef.current) === null || _c === void 0 ? void 0 : _c.focus();
            }
        };
        this.onKeyDown = (event) => {
            var _a, _b, _c, _d, _e, _f;
            if (event.key === 'Tab' && !this.props.isOpen) {
                return;
            }
            if ((event.key === 'Tab' || event.key === 'Enter' || event.key === ' ') && this.props.isOpen) {
                if (!this.props.bubbleEvent) {
                    event.stopPropagation();
                }
                event.preventDefault();
                (_b = (_a = this.props).onToggle) === null || _b === void 0 ? void 0 : _b.call(_a, !this.props.isOpen, event);
            }
            else if ((event.key === 'Enter' || event.key === ' ') && !this.props.isOpen) {
                if (!this.props.bubbleEvent) {
                    event.stopPropagation();
                }
                event.preventDefault();
                (_d = (_c = this.props).onToggle) === null || _d === void 0 ? void 0 : _d.call(_c, !this.props.isOpen, event);
                (_f = (_e = this.props).onEnter) === null || _f === void 0 ? void 0 : _f.call(_e);
            }
        };
    }
    render() {
        const _a = this.props, { className, children, isOpen, isDisabled, isPlain, isText, isPrimary, isSplitButton, toggleVariant, onToggle, 'aria-haspopup': ariaHasPopup, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isActive, bubbleEvent, onEnter, parentRef, getMenuRef, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        id, type } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__rest)(_a, ["className", "children", "isOpen", "isDisabled", "isPlain", "isText", "isPrimary", "isSplitButton", "toggleVariant", "onToggle", 'aria-haspopup', "isActive", "bubbleEvent", "onEnter", "parentRef", "getMenuRef", "id", "type"]);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dropdownConstants__WEBPACK_IMPORTED_MODULE_4__.DropdownContext.Consumer, null, ({ toggleClass }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", Object.assign({}, props, { id: id, ref: this.buttonRef, className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__.css)(isSplitButton ? _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].dropdownToggleButton : toggleClass || _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].dropdownToggle, isActive && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.active, isPlain && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.plain, isText && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.text, isPrimary && _patternfly_react_styles_css_components_Dropdown_dropdown__WEBPACK_IMPORTED_MODULE_1__["default"].modifiers.primary, toggleVariant && buttonVariantStyles[toggleVariant], className), type: type || 'button', onClick: event => onToggle === null || onToggle === void 0 ? void 0 : onToggle(!isOpen, event), "aria-expanded": isOpen, "aria-haspopup": ariaHasPopup, onKeyDown: event => this.onKeyDown(event), disabled: isDisabled }), children))));
    }
}
Toggle.displayName = 'Toggle';
Toggle.defaultProps = {
    className: '',
    isOpen: false,
    isActive: false,
    isDisabled: false,
    isPlain: false,
    isText: false,
    isPrimary: false,
    isSplitButton: false,
    onToggle: () => { },
    onEnter: () => { },
    bubbleEvent: false
};
//# sourceMappingURL=Toggle.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DropdownArrowContext": () => (/* binding */ DropdownArrowContext),
/* harmony export */   "DropdownContext": () => (/* binding */ DropdownContext),
/* harmony export */   "DropdownDirection": () => (/* binding */ DropdownDirection),
/* harmony export */   "DropdownPosition": () => (/* binding */ DropdownPosition)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var DropdownPosition;
(function (DropdownPosition) {
    DropdownPosition["right"] = "right";
    DropdownPosition["left"] = "left";
})(DropdownPosition || (DropdownPosition = {}));
var DropdownDirection;
(function (DropdownDirection) {
    DropdownDirection["up"] = "up";
    DropdownDirection["down"] = "down";
})(DropdownDirection || (DropdownDirection = {}));
const DropdownContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onSelect: (event) => undefined,
    id: '',
    toggleIndicatorClass: '',
    toggleIconClass: '',
    toggleTextClass: '',
    menuClass: '',
    itemClass: '',
    toggleClass: '',
    baseClass: '',
    baseComponent: 'div',
    sectionClass: '',
    sectionTitleClass: '',
    sectionComponent: 'section',
    disabledClass: '',
    plainTextClass: '',
    menuComponent: 'ul'
});
const DropdownArrowContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    keyHandler: null,
    sendRef: null
});
//# sourceMappingURL=dropdownConstants.js.map

/***/ }),

/***/ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DualListSelector": () => (/* binding */ DualListSelector)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _patternfly_react_styles_css_components_DualListSelector_dual_list_selector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @patternfly/react-styles/css/components/DualListSelector/dual-list-selector */ "./node_modules/@patternfly/react-styles/css/components/DualListSelector/dual-list-selector.js");
/* harmony import */ var _patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @patternfly/react-styles */ "./node_modules/@patternfly/react-styles/dist/esm/index.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_double_left_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-double-left-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-double-left-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_left_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-left-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-left-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_double_right_icon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-double-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-double-right-icon.js");
/* harmony import */ var _patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @patternfly/react-icons/dist/esm/icons/angle-right-icon */ "./node_modules/@patternfly/react-core/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js");
/* harmony import */ var _DualListSelectorPane__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DualListSelectorPane */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorPane.js");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../helpers */ "./node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js");
/* harmony import */ var _treeUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./treeUtils */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/treeUtils.js");
/* harmony import */ var _DualListSelectorControlsWrapper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DualListSelectorControlsWrapper */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorControlsWrapper.js");
/* harmony import */ var _DualListSelectorControl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./DualListSelectorControl */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorControl.js");
/* harmony import */ var _DualListSelectorContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DualListSelectorContext */ "./node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorContext.js");














class DualListSelector extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.addAllButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.addSelectedButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.removeSelectedButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.removeAllButtonRef = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        /** In dev environment, prevents circular structure during JSON stringification when
         * options passed in to the dual list selector include HTML elements.
         */
        this.replacer = (key, value) => {
            if (key[0] === '_') {
                return undefined;
            }
            return value;
        };
        this.onFilterUpdate = (newFilteredOptions, paneType, isSearchReset) => {
            const { isTree } = this.props;
            if (paneType === 'available') {
                if (isSearchReset) {
                    this.setState({
                        availableFilteredOptions: null,
                        availableTreeFilteredOptions: null
                    });
                    return;
                }
                if (isTree) {
                    this.setState({
                        availableTreeFilteredOptions: (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTreeWithFolders)(newFilteredOptions)
                    });
                }
                else {
                    this.setState({
                        availableFilteredOptions: newFilteredOptions
                    });
                }
            }
            else if (paneType === 'chosen') {
                if (isSearchReset) {
                    this.setState({
                        chosenFilteredOptions: null,
                        chosenTreeFilteredOptions: null
                    });
                    return;
                }
                if (isTree) {
                    this.setState({
                        chosenTreeFilteredOptions: (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTreeWithFolders)(newFilteredOptions)
                    });
                }
                else {
                    this.setState({
                        chosenFilteredOptions: newFilteredOptions
                    });
                }
            }
        };
        this.addAllVisible = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newAvailable = [];
                const movedOptions = prevState.availableFilteredOptions || prevState.availableOptions;
                prevState.availableOptions.forEach(value => {
                    if (movedOptions.indexOf(value) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newAvailable.push(value);
                    }
                });
                const newChosen = [...prevState.chosenOptions, ...itemsToRemove];
                this.props.addAll && this.props.addAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    chosenOptionsSelected: [],
                    availableOptionsSelected: []
                };
            });
        };
        this.addAllTreeVisible = () => {
            this.setState(prevState => {
                const movedOptions = prevState.availableTreeFilteredOptions ||
                    (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTreeWithFolders)(prevState.availableOptions);
                const newAvailable = prevState.availableOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterRestTreeItems)(item, movedOptions));
                const currChosen = (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(prevState.chosenOptions);
                const nextChosenOptions = currChosen.concat(movedOptions);
                const newChosen = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, nextChosenOptions));
                this.props.addAll && this.props.addAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: []
                };
            });
        };
        this.addSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newAvailable = [];
                prevState.availableOptions.forEach((value, index) => {
                    if (prevState.availableOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newAvailable.push(value);
                    }
                });
                const newChosen = [...prevState.chosenOptions, ...itemsToRemove];
                this.props.addSelected && this.props.addSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable
                };
            });
        };
        this.addTreeSelected = () => {
            this.setState(prevState => {
                // Remove selected available nodes from current available nodes
                const newAvailable = prevState.availableOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterRestTreeItems)(item, prevState.availableTreeOptionsChecked));
                // Get next chosen options from current + new nodes and remap from base
                const currChosen = (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(prevState.chosenOptions);
                const nextChosenOptions = currChosen.concat(prevState.availableTreeOptionsChecked);
                const newChosen = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, nextChosenOptions));
                this.props.addSelected && this.props.addSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: [],
                    availableOptions: newAvailable,
                    chosenOptions: newChosen
                };
            });
        };
        this.removeAllVisible = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newChosen = [];
                const movedOptions = prevState.chosenFilteredOptions || prevState.chosenOptions;
                prevState.chosenOptions.forEach(value => {
                    if (movedOptions.indexOf(value) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newChosen.push(value);
                    }
                });
                const newAvailable = [...prevState.availableOptions, ...itemsToRemove];
                this.props.removeAll && this.props.removeAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    chosenOptionsSelected: [],
                    availableOptionsSelected: []
                };
            });
        };
        this.removeAllTreeVisible = () => {
            this.setState(prevState => {
                const movedOptions = prevState.chosenTreeFilteredOptions ||
                    (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTreeWithFolders)(prevState.chosenOptions);
                const newChosen = prevState.chosenOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterRestTreeItems)(item, movedOptions));
                const currAvailable = (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(prevState.availableOptions);
                const nextAvailableOptions = currAvailable.concat(movedOptions);
                const newAvailable = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, nextAvailableOptions));
                this.props.removeAll && this.props.removeAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    availableOptions: newAvailable,
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: []
                };
            });
        };
        this.removeSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newChosen = [];
                prevState.chosenOptions.forEach((value, index) => {
                    if (prevState.chosenOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newChosen.push(value);
                    }
                });
                const newAvailable = [...prevState.availableOptions, ...itemsToRemove];
                this.props.removeSelected && this.props.removeSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable
                };
            });
        };
        this.removeTreeSelected = () => {
            this.setState(prevState => {
                // Remove selected chosen nodes from current chosen nodes
                const newChosen = prevState.chosenOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterRestTreeItems)(item, prevState.chosenTreeOptionsChecked));
                // Get next chosen options from current and remap from base
                const currAvailable = (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(prevState.availableOptions);
                const nextAvailableOptions = currAvailable.concat(prevState.chosenTreeOptionsChecked);
                const newAvailable = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, nextAvailableOptions));
                this.props.removeSelected && this.props.removeSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: [],
                    availableOptions: newAvailable,
                    chosenOptions: newChosen
                };
            });
        };
        this.onOptionSelect = (e, index, isChosen, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        id, itemData, parentData
        /* eslint-enable @typescript-eslint/no-unused-vars */
        ) => {
            this.setState(prevState => {
                const originalArray = isChosen ? prevState.chosenOptionsSelected : prevState.availableOptionsSelected;
                let updatedArray = null;
                if (originalArray.indexOf(index) !== -1) {
                    updatedArray = originalArray.filter(value => value !== index);
                }
                else {
                    updatedArray = [...originalArray, index];
                }
                return {
                    chosenOptionsSelected: isChosen ? updatedArray : prevState.chosenOptionsSelected,
                    availableOptionsSelected: isChosen ? prevState.availableOptionsSelected : updatedArray
                };
            });
            this.props.onOptionSelect && this.props.onOptionSelect(e, index, isChosen, id, itemData, parentData);
        };
        this.isChecked = (treeItem, isChosen) => isChosen
            ? this.state.chosenTreeOptionsChecked.includes(treeItem.id)
            : this.state.availableTreeOptionsChecked.includes(treeItem.id);
        this.areAllDescendantsChecked = (treeItem, isChosen) => treeItem.children
            ? treeItem.children.every(child => this.areAllDescendantsChecked(child, isChosen))
            : this.isChecked(treeItem, isChosen);
        this.areSomeDescendantsChecked = (treeItem, isChosen) => treeItem.children
            ? treeItem.children.some(child => this.areSomeDescendantsChecked(child, isChosen))
            : this.isChecked(treeItem, isChosen);
        this.mapChecked = (item, isChosen) => {
            const hasCheck = this.areAllDescendantsChecked(item, isChosen);
            item.isChecked = false;
            if (hasCheck) {
                item.isChecked = true;
            }
            else {
                const hasPartialCheck = this.areSomeDescendantsChecked(item, isChosen);
                if (hasPartialCheck) {
                    item.isChecked = null;
                }
            }
            if (item.children) {
                return Object.assign(Object.assign({}, item), { children: item.children.map(child => this.mapChecked(child, isChosen)) });
            }
            return item;
        };
        this.onTreeOptionCheck = (evt, isChecked, itemData, isChosen) => {
            const { availableOptions, availableTreeFilteredOptions, chosenOptions, chosenTreeFilteredOptions } = this.state;
            let panelOptions;
            if (isChosen) {
                if (chosenTreeFilteredOptions) {
                    panelOptions = chosenOptions
                        .map(opt => Object.assign({}, opt))
                        .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, chosenTreeFilteredOptions));
                }
                else {
                    panelOptions = chosenOptions;
                }
            }
            else {
                if (availableTreeFilteredOptions) {
                    panelOptions = availableOptions
                        .map(opt => Object.assign({}, opt))
                        .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItemsWithoutFolders)(item, availableTreeFilteredOptions));
                }
                else {
                    panelOptions = availableOptions;
                }
            }
            const checkedOptionTree = panelOptions
                .map(opt => Object.assign({}, opt))
                .filter(item => (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterTreeItems)(item, [itemData.id]));
            const flatTree = (0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTreeWithFolders)(checkedOptionTree);
            const prevChecked = isChosen ? this.state.chosenTreeOptionsChecked : this.state.availableTreeOptionsChecked;
            let updatedChecked = [];
            if (isChecked) {
                updatedChecked = prevChecked.concat(flatTree.filter(id => !prevChecked.includes(id)));
            }
            else {
                updatedChecked = prevChecked.filter(id => !flatTree.includes(id));
            }
            this.setState(prevState => ({
                availableTreeOptionsChecked: isChosen ? prevState.availableTreeOptionsChecked : updatedChecked,
                chosenTreeOptionsChecked: isChosen ? updatedChecked : prevState.chosenTreeOptionsChecked
            }), () => {
                this.props.onOptionCheck && this.props.onOptionCheck(evt, isChecked, itemData.id, updatedChecked);
            });
        };
        this.state = {
            availableOptions: [...this.props.availableOptions],
            availableOptionsSelected: [],
            availableFilteredOptions: null,
            availableTreeFilteredOptions: null,
            chosenOptions: [...this.props.chosenOptions],
            chosenOptionsSelected: [],
            chosenFilteredOptions: null,
            chosenTreeFilteredOptions: null,
            availableTreeOptionsChecked: [],
            chosenTreeOptionsChecked: []
        };
    }
    // If the DualListSelector uses trees, concat the two initial arrays and merge duplicate folder IDs
    createMergedCopy() {
        const copyOfAvailable = JSON.parse(JSON.stringify(this.props.availableOptions));
        const copyOfChosen = JSON.parse(JSON.stringify(this.props.chosenOptions));
        return this.props.isTree
            ? Object.values(copyOfAvailable
                .concat(copyOfChosen)
                .reduce((mapObj, item) => {
                const key = item.id;
                if (mapObj[key]) {
                    // If map already has an item ID, add the dupe ID's children to the existing map
                    mapObj[key].children.push(...item.children);
                }
                else {
                    // Else clone the item data
                    mapObj[key] = Object.assign({}, item);
                }
                return mapObj;
            }, {}))
            : null;
    }
    componentDidUpdate() {
        if (JSON.stringify(this.props.availableOptions, this.replacer) !==
            JSON.stringify(this.state.availableOptions, this.replacer) ||
            JSON.stringify(this.props.chosenOptions, this.replacer) !==
                JSON.stringify(this.state.chosenOptions, this.replacer)) {
            this.setState({
                availableOptions: [...this.props.availableOptions],
                chosenOptions: [...this.props.chosenOptions]
            });
        }
    }
    render() {
        const _a = this.props, { availableOptionsTitle, availableOptionsActions, availableOptionsSearchAriaLabel, className, children, chosenOptionsTitle, chosenOptionsActions, chosenOptionsSearchAriaLabel, filterOption, isSearchable, chosenOptionsStatus, availableOptionsStatus, controlsAriaLabel, addAllAriaLabel, addSelectedAriaLabel, removeSelectedAriaLabel, removeAllAriaLabel, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        availableOptions: consumerPassedAvailableOptions, chosenOptions: consumerPassedChosenOptions, removeSelected, addAll, removeAll, addSelected, onListChange, onAvailableOptionsSearchInputChanged, onChosenOptionsSearchInputChanged, onOptionSelect, onOptionCheck, id, isTree, isDisabled, addAllTooltip, addAllTooltipProps, addSelectedTooltip, addSelectedTooltipProps, removeAllTooltip, removeAllTooltipProps, removeSelectedTooltip, removeSelectedTooltipProps } = _a, props = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__rest)(_a, ["availableOptionsTitle", "availableOptionsActions", "availableOptionsSearchAriaLabel", "className", "children", "chosenOptionsTitle", "chosenOptionsActions", "chosenOptionsSearchAriaLabel", "filterOption", "isSearchable", "chosenOptionsStatus", "availableOptionsStatus", "controlsAriaLabel", "addAllAriaLabel", "addSelectedAriaLabel", "removeSelectedAriaLabel", "removeAllAriaLabel", "availableOptions", "chosenOptions", "removeSelected", "addAll", "removeAll", "addSelected", "onListChange", "onAvailableOptionsSearchInputChanged", "onChosenOptionsSearchInputChanged", "onOptionSelect", "onOptionCheck", "id", "isTree", "isDisabled", "addAllTooltip", "addAllTooltipProps", "addSelectedTooltip", "addSelectedTooltipProps", "removeAllTooltip", "removeAllTooltipProps", "removeSelectedTooltip", "removeSelectedTooltipProps"]);
        const { availableOptions, chosenOptions, chosenOptionsSelected, availableOptionsSelected, chosenTreeOptionsChecked, availableTreeOptionsChecked } = this.state;
        const availableOptionsStatusToDisplay = availableOptionsStatus ||
            (isTree
                ? `${(0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterFolders)(availableOptions, availableTreeOptionsChecked)
                    .length} of ${(0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(availableOptions).length} items selected`
                : `${availableOptionsSelected.length} of ${availableOptions.length} items selected`);
        const chosenOptionsStatusToDisplay = chosenOptionsStatus ||
            (isTree
                ? `${(0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.filterFolders)(chosenOptions, chosenTreeOptionsChecked).length} of ${(0,_treeUtils__WEBPACK_IMPORTED_MODULE_1__.flattenTree)(chosenOptions).length} items selected`
                : `${chosenOptionsSelected.length} of ${chosenOptions.length} items selected`);
        const available = (isTree
            ? availableOptions.map(item => this.mapChecked(item, false))
            : availableOptions);
        const chosen = (isTree
            ? chosenOptions.map(item => this.mapChecked(item, true))
            : chosenOptions);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorContext__WEBPACK_IMPORTED_MODULE_3__.DualListSelectorContext.Provider, { value: { isTree } },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_helpers__WEBPACK_IMPORTED_MODULE_4__.GenerateId, null, randomId => (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,_patternfly_react_styles__WEBPACK_IMPORTED_MODULE_5__.css)(_patternfly_react_styles_css_components_DualListSelector_dual_list_selector__WEBPACK_IMPORTED_MODULE_6__["default"].dualListSelector, className), id: id || randomId }, props), children === '' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorPane__WEBPACK_IMPORTED_MODULE_7__.DualListSelectorPane, { isSearchable: isSearchable, onFilterUpdate: this.onFilterUpdate, searchInputAriaLabel: availableOptionsSearchAriaLabel, filterOption: filterOption, onSearchInputChanged: onAvailableOptionsSearchInputChanged, status: availableOptionsStatusToDisplay, title: availableOptionsTitle, options: available, selectedOptions: isTree ? availableTreeOptionsChecked : availableOptionsSelected, onOptionSelect: this.onOptionSelect, onOptionCheck: (e, isChecked, itemData) => this.onTreeOptionCheck(e, isChecked, itemData, false), actions: availableOptionsActions, id: `${id || randomId}-available-pane`, isDisabled: isDisabled }),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorControlsWrapper__WEBPACK_IMPORTED_MODULE_8__.DualListSelectorControlsWrapper, { "aria-label": controlsAriaLabel },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorControl__WEBPACK_IMPORTED_MODULE_9__.DualListSelectorControl, { isDisabled: (isTree ? availableTreeOptionsChecked.length === 0 : availableOptionsSelected.length === 0) ||
                            isDisabled, onClick: isTree ? this.addTreeSelected : this.addSelected, ref: this.addSelectedButtonRef, "aria-label": addSelectedAriaLabel, tooltipContent: addSelectedTooltip, tooltipProps: addSelectedTooltipProps },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_right_icon__WEBPACK_IMPORTED_MODULE_10__["default"], null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorControl__WEBPACK_IMPORTED_MODULE_9__.DualListSelectorControl, { isDisabled: availableOptions.length === 0 || isDisabled, onClick: isTree ? this.addAllTreeVisible : this.addAllVisible, ref: this.addAllButtonRef, "aria-label": addAllAriaLabel, tooltipContent: addAllTooltip, tooltipProps: addAllTooltipProps },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_double_right_icon__WEBPACK_IMPORTED_MODULE_11__["default"], null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorControl__WEBPACK_IMPORTED_MODULE_9__.DualListSelectorControl, { isDisabled: chosenOptions.length === 0 || isDisabled, onClick: isTree ? this.removeAllTreeVisible : this.removeAllVisible, "aria-label": removeAllAriaLabel, ref: this.removeAllButtonRef, tooltipContent: removeAllTooltip, tooltipProps: removeAllTooltipProps },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_double_left_icon__WEBPACK_IMPORTED_MODULE_12__["default"], null)),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorControl__WEBPACK_IMPORTED_MODULE_9__.DualListSelectorControl, { onClick: isTree ? this.removeTreeSelected : this.removeSelected, isDisabled: (isTree ? chosenTreeOptionsChecked.length === 0 : chosenOptionsSelected.length === 0) ||
                            isDisabled, ref: this.removeSelectedButtonRef, "aria-label": removeSelectedAriaLabel, tooltipContent: removeSelectedTooltip, tooltipProps: removeSelectedTooltipProps },
                        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_patternfly_react_icons_dist_esm_icons_angle_left_icon__WEBPACK_IMPORTED_MODULE_13__["default"], null))),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DualListSelectorPane__WEBPACK_IMPORTED_MODULE_7__.DualListSelectorPane, { isChosen: true, isSearchable: isSearchable, onFilterUpdate: this.onFilterUpdate, searchInputAriaLabel: chosenOptionsSearchAriaLabel, filterOption: filterOption, onSearchInputChanged: onChosenOptionsSearchInputChanged, title: