/*
 * Cobertura - http://cobertura.sourceforge.net/
 *
 * This file was taken from JavaNCSS
 * http://www.kclee.com/clemens/java/javancss/
 * Copyright (C) 2000 Chr. Clemens Lee <clemens a.t kclee d.o.t com>
 *
 * Cobertura is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * Cobertura is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/*
 *
 * WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING  
 *
 * WARNING TO COBERTURA DEVELOPERS
 *
 * DO NOT MODIFY THIS FILE!
 *
 * MODIFY THE FILES UNDER THE JAVANCSS DIRECTORY LOCATED AT THE ROOT OF THE COBERTURA PROJECT.
 *
 * FOLLOW THE PROCEDURE FOR MERGING THE LATEST JAVANCSS INTO COBERTURA LOCATED AT
 * javancss/coberturaREADME.txt
 *
 * WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   WARNING   
 */
/* Generated By:JavaCC: Do not edit this line. JavaParser.java */
package net.sourceforge.cobertura.javancss.parser;

import java.util.*;

import net.sourceforge.cobertura.javancss.ccl.Util;

import net.sourceforge.cobertura.javancss.FunctionMetric;
import net.sourceforge.cobertura.javancss.ObjectMetric;
import net.sourceforge.cobertura.javancss.PackageMetric;

/**
 * Java source code parser based on a grammar compiled by
 * JavaCC from Java1.1.jj to the JavaParser class.<p>
 *
 * This class is responsible for parsing Java code and counting
 * all metrics during this parsing process.
 * The rest of the application is only responsible for invoking
 * this parser in a convenient way and to present the results
 * to the user.<p>
 *
 * This grammar is based on the Java grammar that comes as an
 * example with JavaCC, but has been extended to collect the
 * metrics data (and adapted to support real life and jdk 1.4
 * Java sources as well).
 *
 * @author    Sriram Sankar (original JavaCC grammar)
 *            , Chr. Clemens Lee <clemens@kclee.com> (JavaNCSS metrics)
 *            , additional counting of javadoc comments done by
 *              Emilio Gongora, <emilio@sms.nl> and
 *              Guillermo Rodriguez, <guille@sms.nl>.
 *            Anonymous class count patch by Vesa Karvonnen, <vesa_karvonen@hotmail.com> 2002-10-30.
 * @version   2000-01-31 $Id: Java1.1.jj 171 2009-05-31 20:12:01Z hboutemy $
 */
public class JavaParser implements JavaParserInterface, JavaParserConstants {
    {
        /* // DEBUG MODE
        Util.setDebug( true );
        // */
    }
    private boolean _bReturn         = false;
    private int     _ncss            = 0;     // general counter
    private int     _loc             = 0;
    private int     _cyc             = 1;
    private int     _localCases      = 0;
    private String  _sName           = "";    // name of last token
    private String  _sParameter      = "";
    private String  _sPackage        = "";
    private String  _sClass          = "";
    private String  _sFunction       = "";
    private int     _functions       = 0;     // number of functions in this class
    //private int     _topLevelClasses = 0;
    private int     _classes         = 0;
    private int     _classLevel      = 0;
    private int     _anonClassCount  = 1;

    private int     _jvdcLines = 0;           // added by SMS
    private int     _jvdc      = 0;
    private boolean _bPrivate  = true;//false;        // added by SMS
    private boolean _bPublic   = true;        // added by SMS

    /**
     * For each class the number of formal
     * comments in toplevel methods, constructors, inner
     * classes, and for the class itself are counted.
     * The top level comment has to be directly before
     * the class definition, not before the package or
     * import statement as it is often seen in source code
     * examples (at the beginning of your source files you
     * should instead put your copyright notice).
     */
    private int    _javadocs   = 0;              // global javadocs
    private List/*<FunctionMetric>*/ _vFunctions = new ArrayList();   // holds the statistics for each method

    /**
     * Metrics for each class/interface are stored in this
     * vector.
     */
    private List/*<ObjectMetric>*/ _vClasses = new ArrayList();
    private List _vImports = new ArrayList();
    private Object[] _aoPackage = null;
    private Map/*<String,PackageMetric>*/ _htPackage = new HashMap();
    private PackageMetric _pPackageMetric;

    private Token _tmpToken = null;
    /** Argh, too much of a state machine. */
    private Token _tmpResultToken = null;

    private String _formatPackage(String sPackage_) {
        if (sPackage_.equals("")) {
            return ".";
        }

        return sPackage_.substring(0, sPackage_.length() - 1);
    }

    public void parse() throws Exception {
      CompilationUnit();
    }

    public void parseImportUnit() throws Exception {
      ImportUnit();
    }

    public int getNcss() {
        return _ncss;
    }

    public int getLOC() {
        return _loc;
    }

    // added by SMS
    public int getJvdc() {
        return _jvdc;
    }

    /*public int getTopLevelClasses() {
      return _topLevelClasses;
      }*/

    public List/*<FunctionMetric>*/ getFunction() {
        return _vFunctions;
    }

    /**
     * @return Top level classes in sorted order
     */
    public List/*<ObjectMetric>*/ getObject() {
        Collections.sort(_vClasses);
        return _vClasses;
    }

    /**
     * @return The empty package consists of the name ".".
     */
    public Map/*<String,PackageMetric>*/ getPackage() {
        return _htPackage;
    }

    public List getImports() {
        return _vImports;
    }

    /**
     * name, beginLine, ...
     */
    public Object[] getPackageObjects() {
        return _aoPackage;
    }

    /**
     * if javancss is used with cat *.java a long
     * input stream might get generated, so line
     * number information in case of an parse exception
     * is not very useful.
     */
    public String getLastFunction() {
        return _sPackage + _sClass + _sFunction;
    }

   /**
    * Class to hold modifiers.
    */
   static public final class ModifierSet
   {
     /* Definitions of the bits in the modifiers field.  */
     public static final int PUBLIC = 0x0001;
     public static final int PROTECTED = 0x0002;
     public static final int PRIVATE = 0x0004;
     public static final int ABSTRACT = 0x0008;
     public static final int STATIC = 0x0010;
     public static final int FINAL = 0x0020;
     public static final int SYNCHRONIZED = 0x0040;
     public static final int NATIVE = 0x0080;
     public static final int TRANSIENT = 0x0100;
     public static final int VOLATILE = 0x0200;
     public static final int STRICTFP = 0x1000;

     /** A set of accessors that indicate whether the specified modifier
         is in the set. */

     public boolean isPublic(int modifiers)
     {
       return (modifiers & PUBLIC) != 0;
     }

     public boolean isProtected(int modifiers)
     {
       return (modifiers & PROTECTED) != 0;
     }

     public boolean isPrivate(int modifiers)
     {
       return (modifiers & PRIVATE) != 0;
     }

     public boolean isStatic(int modifiers)
     {
       return (modifiers & STATIC) != 0;
     }

     public boolean isAbstract(int modifiers)
     {
       return (modifiers & ABSTRACT) != 0;
     }

     public boolean isFinal(int modifiers)
     {
       return (modifiers & FINAL) != 0;
     }

     public boolean isNative(int modifiers)
     {
       return (modifiers & NATIVE) != 0;
     }

     public boolean isStrictfp(int modifiers)
     {
       return (modifiers & STRICTFP) != 0;
     }

     public boolean isSynchronized(int modifiers)
     {
       return (modifiers & SYNCHRONIZED) != 0;
     }

     public boolean isTransient(int modifiers)
      {
       return (modifiers & TRANSIENT) != 0;
     }

     public boolean isVolatile(int modifiers)
     {
       return (modifiers & VOLATILE) != 0;
     }

     /**
      * Removes the given modifier.
      */
     static int removeModifier(int modifiers, int mod)
     {
        return modifiers & ~mod;
     }
   }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public void CompilationUnit() throws ParseException {
    int oldNcss = 0;

    // added by SMS
    int oldFormal = 0;
    int oldSingle = 0;
    int oldMulti  = 0;

    JavaParserTokenManager._iSingleComments = 0;
    JavaParserTokenManager._iMultiComments = 0;
    JavaParserTokenManager._iFormalComments = 0;

    JavaParserTokenManager._iMultiCommentsLast = 0;

    _bPrivate = true;
                _sPackage = "";
                _pPackageMetric = new PackageMetric();      // this object manages the metrics

    if (jj_2_1(2147483647)) {
      PackageDeclaration();
    } else {
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      ImportDeclaration();
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case CLASS:
      case ENUM:
      case FINAL:
      case INTERFACE:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case SEMICOLON:
      case AT:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      TypeDeclaration();
    }
             // Package classes and functions are set inside
             // class and interface bodies.
             _pPackageMetric.ncss = _ncss;

             // added by SMS
             _pPackageMetric.javadocsLn = JavaParserTokenManager._iFormalComments;
             _pPackageMetric.singleLn   = JavaParserTokenManager._iSingleComments;
             _pPackageMetric.multiLn    = JavaParserTokenManager._iMultiComments;
             //

             _htPackage.put(_formatPackage(_sPackage),
                            _pPackageMetric);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
      case PACKAGE:
      case AT:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      oldNcss = _ncss;
      _sPackage = "";
      _pPackageMetric = new PackageMetric();

      // added by SMS
      oldFormal = JavaParserTokenManager._iFormalComments;
      oldSingle = JavaParserTokenManager._iSingleComments;
      oldMulti  = JavaParserTokenManager._iMultiComments;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PACKAGE:
      case AT:
        PackageDeclaration();
        break;
      case IMPORT:
        ImportDeclaration();
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IMPORT:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_4;
        }
        ImportDeclaration();
      }
      label_5:
      while (true) {
        TypeDeclaration();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case CLASS:
        case ENUM:
        case FINAL:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case TESTAAAA:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case SEMICOLON:
        case AT:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_5;
        }
      }
      // Package classes and functions are set inside
      // class and interface bodies.
      _pPackageMetric.ncss = _ncss - oldNcss;

      // added by SMS
      _pPackageMetric.javadocsLn = JavaParserTokenManager._iFormalComments - oldFormal;
      _pPackageMetric.singleLn   = JavaParserTokenManager._iSingleComments - oldSingle;
      _pPackageMetric.multiLn    = JavaParserTokenManager._iMultiComments  - oldMulti;
      //

      PackageMetric pckmPrevious = (PackageMetric)_htPackage.
             get(_formatPackage(_sPackage));
      _pPackageMetric.add(pckmPrevious);
      _htPackage.put(_formatPackage(_sPackage),
                     _pPackageMetric);
    }
    jj_consume_token(0);
             Token pToken = getToken(1);
             _loc = pToken.endLine;
  }

  final public void ImportUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PACKAGE:
    case AT:
      PackageDeclaration();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_6;
      }
      ImportDeclaration();
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PUBLIC:
      case TESTAAAA:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      break;
    case INTERFACE:
      jj_consume_token(INTERFACE);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PackageDeclaration() throws ParseException {
    int beginLine = 1;
    int beginColumn = 1;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_8;
      }
      Annotation();
    }
    jj_consume_token(PACKAGE);
      _anonClassCount = 1;

      Token pToken = getToken( 0 );
      beginLine = pToken.beginLine ;
      beginColumn = pToken.beginColumn;
      _aoPackage = new Object[ 5 ];
    Name();
      _aoPackage[ 0 ] = _sName;
      _aoPackage[ 1 ] = new Integer( beginLine );
      _aoPackage[ 2 ] = new Integer( beginColumn );
    jj_consume_token(SEMICOLON);
      _aoPackage[ 3 ] = new Integer( getToken( 0 ).endLine );
      _aoPackage[ 4 ] = new Integer( getToken( 0 ).endColumn );
      _ncss++;
      Util.debug( "_ncss++" );
      _sPackage = _sName + ".";
  }

  final public void ImportDeclaration() throws ParseException {
    int beginLine = 1;
    int beginColumn = 1;
    Object[] aoImport = null;
    jj_consume_token(IMPORT);
      Token pToken = getToken( 0 );
      beginLine = pToken.beginLine ;
      beginColumn = pToken.beginColumn;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATIC:
      jj_consume_token(STATIC);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    Name();
      aoImport = new Object[ 5 ];
      aoImport[ 0 ] = _sName;
      aoImport[ 1 ] = new Integer( beginLine );
      aoImport[ 2 ] = new Integer( beginColumn );
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      jj_consume_token(STAR);
              aoImport[ 0 ] = aoImport[ 0 ].toString() + ".*";
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      aoImport[ 3 ] = new Integer( getToken( 0 ).endLine );
      aoImport[ 4 ] = new Integer( getToken( 0 ).endColumn );
      _vImports.add( aoImport );
      _ncss++;
      Util.debug( "_ncss++" );
  }

  final public void TypeDeclaration() throws ParseException {
   int modifiers;
    if (jj_2_2(2147483647)) {
      ClassDeclaration();
    } else if (jj_2_3(2147483647)) {
      modifiers = Modifiers();
      EnumDeclaration(modifiers);
    } else if (jj_2_4(2147483647)) {
      InterfaceDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case AT:
        modifiers = Modifiers();
        AnnotationTypeDeclaration(modifiers);
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * Declaration syntax follows.
 */
  final public void ClassDeclaration() throws ParseException {
    Token tmpToken = null;
    _javadocs = 0;
    ObjectMetric metric = null;

    // added by SMS
    int oldSingle = 0;
    int oldMulti  = 0;

    _jvdcLines    = 0;
    boolean bTemp = _bPublic;
    _bPublic      = false;
    //

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
         myToken = getToken(1);
      Annotation();
         tmpToken = myToken;
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_9;
      }
      Annotation();
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PUBLIC:
      case TESTAAAA:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case FINAL:
        jj_consume_token(FINAL);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
      _bPublic = true;         // added by SMS
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      if ( tmpToken == null ) {
          tmpToken = getToken( 1 );
      }
      while( tmpToken.specialToken != null ) {
          if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
              _javadocs++;
              Util.debug( "ClassDeclaration()._javadocs++" );
              if (_bPublic || _bPrivate) {
                  Util.debug( "_jvdc++" );
                  _jvdc++;
                  _jvdcLines += JavaParserTokenManager._iMultiCommentsLast;
                  JavaParserTokenManager._iFormalComments += JavaParserTokenManager._iMultiCommentsLast;
              }
              JavaParserTokenManager._iMultiComments -= JavaParserTokenManager._iMultiCommentsLast;
              break;
          }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
              break;
          }

          //System.out.println("\n"+tmpToken.specialToken.image);

          tmpToken = tmpToken.specialToken;
      }

      oldSingle = JavaParserTokenManager._iSingleComments;
      oldMulti = JavaParserTokenManager._iMultiComments;
    UnmodifiedClassDeclaration();
             /* removed by SMS
             while( tmpToken.specialToken != null ) {
                 if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                     _javadocs++;
                 }
                 tmpToken = tmpToken.specialToken;
             }
             */
             metric = (ObjectMetric)_vClasses.get( _vClasses.size() - 1);
             metric.javadocs = _javadocs;

             // added by SMS
             metric.javadocsLn = _jvdcLines;
             metric.singleLn = JavaParserTokenManager._iSingleComments - oldSingle;
             metric.multiLn = JavaParserTokenManager._iMultiComments - oldMulti;
             //

            // added by SMS
            _bPublic = bTemp;
  }

  final public void UnmodifiedClassDeclaration() throws ParseException {
        String sOldClass = _sClass;
        int oldNcss = _ncss;
        int oldFunctions = _functions;
        int oldClasses = _classes;

                //Added by REYNAUD Sebastien (LOGICA)
                int oldJavadocs = _javadocs;
                if (!_sClass.equals("")) {
                        _sClass += ".";
                }
                _sClass += getToken(2).image;
                _classLevel ++;
    Modifiers();
    jj_consume_token(CLASS);
    Identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      Name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_11;
        }
        jj_consume_token(DOT);
        Name();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      jj_consume_token(IMPLEMENTS);
      NameList();
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    ClassBody();
                _ncss++;
                Util.debug( "_ncss++" );
                _classLevel--;
                if (_classLevel == 0) {
                        //_topLevelClasses++;
                        ObjectMetric metric = new ObjectMetric();
                        metric.name = _sPackage + _sClass;
                        metric.ncss = _ncss - oldNcss;
                        metric.functions = _functions - oldFunctions;
                        metric.classes = _classes - oldClasses;
                        Token lastToken = getToken( 0 );
                        //metric.add( new Integer( lastToken.endLine ) );
                        //metric.add( new Integer( lastToken.endColumn ) );
                        //metric.add( new Integer( _javadocs ) );
                        _vClasses.add( metric );
                        _pPackageMetric.functions += _functions - oldFunctions;
                        _pPackageMetric.classes++;

                        // added by SMS
                        _pPackageMetric.javadocs += _javadocs;
                        //_pPackageMetric.javadocsLn += JavaParserTokenManager._iFormalComments - oldFormal;
                        //_pPackageMetric.singleLn += JavaParserTokenManager._iSingleComments - oldSingle;
                        //_pPackageMetric.multiLn += JavaParserTokenManager._iMultiComments - oldMulti;
                        //
                }
                        //Added by REYNAUD Sebastien (LOGICA)
                        else
                        {
                        ObjectMetric metric1 = new ObjectMetric();
                  metric1.name = _sPackage + _sClass ;
                        metric1.ncss = _ncss - oldNcss;
                  metric1.functions = _functions - oldFunctions;
                  metric1.classes = _classes - oldClasses;
                  Token lastToken = getToken( 0 );
                  _vClasses.add( metric1 );
                  _pPackageMetric.functions += _functions - oldFunctions;
                  _pPackageMetric.classes++;
                        metric1.javadocs = _javadocs - oldJavadocs;
                        }
                        //

                _functions = oldFunctions;
                _classes = oldClasses + 1;
                _sClass = sOldClass;
  }

  final public void ClassBody() throws ParseException {
    jj_consume_token(LBRACE);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case LT:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_12;
      }
      ClassBodyDeclaration();
    }
    jj_consume_token(RBRACE);
  }

  final public void NestedClassDeclaration() throws ParseException {
    // added by SMS
    Token tmpToken = null;

    boolean bTemp = _bPublic;
    _bPublic = false;
    boolean bPublic = false;

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
         myToken = getToken(1);
      Annotation();
         tmpToken = myToken;
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_13;
      }
      Annotation();
    }
        if(tmpToken==null)
        {
                tmpToken = getToken( 1 );
        }
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
               bPublic = true;
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                  bPublic = true;
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                        //tmpToken = getToken( 0 );//Removed by REYNAUD Sebastien (LOGICA)

                while( tmpToken.specialToken != null ) {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                        _javadocs++;
                        Util.debug( "NestedClassDeclaration()._javadocs++" );
                        if ((_bPublic && bPublic) || _bPrivate) {
                            Util.debug( "_jvdc++" );
                            _jvdc++;
                            _jvdcLines += JavaParserTokenManager._iMultiCommentsLast;
                            JavaParserTokenManager._iFormalComments += JavaParserTokenManager._iMultiCommentsLast;
                        }
                        JavaParserTokenManager._iMultiComments -= JavaParserTokenManager._iMultiCommentsLast;
                        break;
                    }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
                        break;
                    }

                    //System.out.println("\n"+tmpToken.specialToken.image);

                    tmpToken = tmpToken.specialToken;
                }
    UnmodifiedClassDeclaration();
       //added by SMS
      _bPublic = bTemp;
  }

  final public void ClassBodyDeclaration() throws ParseException {
    int modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      EmptyStatement();
      break;
    default:
      jj_la1[31] = jj_gen;
      if (jj_2_5(2)) {
        Initializer();
      } else if (jj_2_6(2147483647)) {
        modifiers = Modifiers();
        AnnotationTypeDeclaration(modifiers);
      } else if (jj_2_7(2147483647)) {
        CreationAnnotation();
      } else if (jj_2_8(2147483647)) {
        NestedClassDeclaration();
      } else if (jj_2_9(2147483647)) {
        //LOOKAHEAD( ( "static" | "abstract" | "final" | "public" | "protected" | "private" | "strictfp" )* "interface" )
          modifiers = Modifiers();
        NestedInterfaceDeclaration();
      } else if (jj_2_10(2147483647)) {
        modifiers = Modifiers();
        EnumDeclaration(modifiers);
      } else if (jj_2_11(2147483647)) {
        ConstructorDeclaration();
      } else if (jj_2_12(2147483647)) {
        MethodDeclaration();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case TRANSIENT:
        case VOLATILE:
        case IDENTIFIER:
        case AT:
          label_15:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case AT:
              ;
              break;
            default:
              jj_la1[30] = jj_gen;
              break label_15;
            }
            Annotation();
          }
          FieldDeclaration();
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

// This production is to determine lookahead only.
  final public void MethodDeclarationLookahead() throws ParseException {
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_16;
      }
      Annotation();
    }
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_17;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_18;
      }
      Annotation();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    ResultType();
    Identifier();
    jj_consume_token(LPAREN);
  }

  final public void InterfaceDeclaration() throws ParseException {
        Token tmpToken = null;
        _javadocs = 0;
        //boolean bClassComment = false;
        ObjectMetric metric = null;

        // added by SMS
        int oldSingle;
        int oldMulti;

        _jvdcLines = 0;
        boolean bTemp = _bPublic;
        _bPublic = false;
        //

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
         myToken = getToken(1);
      Annotation();
         tmpToken = myToken;
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_19;
      }
      Annotation();
    }
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case PUBLIC:
      case TESTAAAA:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
      _bPublic = true;         // added by SMS
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      if ( tmpToken == null ) {
          tmpToken = getToken( 1 );
      }
                while( tmpToken.specialToken != null ) {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                        _javadocs++;
                        Util.debug( "InterfaceDeclaration()._javadocs++" );
                        if (_bPublic || _bPrivate) {
                            Util.debug( "_jvdc++" );
                            _jvdc++;
                            _jvdcLines += JavaParserTokenManager._iMultiCommentsLast;
                            JavaParserTokenManager._iFormalComments += JavaParserTokenManager._iMultiCommentsLast;
                        }
                        JavaParserTokenManager._iMultiComments -= JavaParserTokenManager._iMultiCommentsLast;
                        break;
                    }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
                        break;
                    }

                    //System.out.println("\n"+tmpToken.specialToken.image);

                    tmpToken = tmpToken.specialToken;
                }

                oldSingle = JavaParserTokenManager._iSingleComments;
                oldMulti = JavaParserTokenManager._iMultiComments;
    UnmodifiedInterfaceDeclaration();
             /* removed by SMS
             while( tmpToken.specialToken != null ) {
                 if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                     _javadocs++;
                     bClassComment = true;
                 }
                 tmpToken = tmpToken.specialToken;
                 }*/
             metric = (ObjectMetric)_vClasses.get( _vClasses.size() - 1 );
             metric.javadocs = _javadocs;

             // added by SMS
             metric.javadocsLn = _jvdcLines;
             metric.singleLn = JavaParserTokenManager._iSingleComments - oldSingle;
             metric.multiLn = JavaParserTokenManager._iMultiComments - oldMulti;
             //

            // added by SMS
            _bPublic = bTemp;
  }

  final public void NestedInterfaceDeclaration() throws ParseException {
    // added by SMS
    Token tmpToken = null;

    boolean bTemp = _bPublic;
    _bPublic = false;
    boolean bPublic = false;

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
         myToken = getToken(1);
      Annotation();
         tmpToken = myToken;
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_21;
      }
      Annotation();
    }
        if(tmpToken==null)
        {
                tmpToken = getToken( 1 );
        }
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case PUBLIC:
        jj_consume_token(PUBLIC);
               bPublic = true;
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                  bPublic = true;
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                        //tmpToken = getToken( 0 );	//Removed by REYNAUD Sebastien (LOGICA)

                while( tmpToken.specialToken != null ) {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                        _javadocs++;
                        if ((_bPublic && bPublic) || _bPrivate) {
                            Util.debug( "_jvdc++" );
                            _jvdc++;
                            _jvdcLines += JavaParserTokenManager._iMultiCommentsLast;
                            JavaParserTokenManager._iFormalComments += JavaParserTokenManager._iMultiCommentsLast;
                        }
                        JavaParserTokenManager._iMultiComments -= JavaParserTokenManager._iMultiCommentsLast;
                        break;
                    }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
                        break;
                    }

                    //System.out.println("\n"+tmpToken.specialToken.image);

                    tmpToken = tmpToken.specialToken;
                }
    UnmodifiedInterfaceDeclaration();
      // added by SMS
      _bPublic = bTemp;
  }

  final public void UnmodifiedInterfaceDeclaration() throws ParseException {
        String sOldClass = _sClass;
        int oldNcss = _ncss;
        int oldFunctions = _functions;
        int oldClasses = _classes;

                //Added by REYNAUD Sebastien (LOGICA)
                int oldJavadocs = _javadocs;
                if (!_sClass.equals("")) {
                        _sClass += ".";
                }
                _sClass += getToken(2).image;
                _classLevel ++;
    jj_consume_token(INTERFACE);
    Identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      NameList();
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case SEMICOLON:
      case AT:
      case LT:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_23;
      }
      InterfaceMemberDeclaration();
    }
    jj_consume_token(RBRACE);
                _ncss++;
                Util.debug( "_ncss++" );
                _classLevel--;
                if (_classLevel == 0)
                {
                        //_topLevelClasses++;
                        ObjectMetric metric = new ObjectMetric();
                        metric.name = _sPackage + _sClass;
                        metric.ncss = _ncss - oldNcss;
                        metric.functions = _functions - oldFunctions;
                        metric.classes = _classes - oldClasses;
                        //metric.add( Util.getConstantObject() );
                        //metric.add( Util.getConstantObject() );
                        _vClasses.add( metric );
                        _pPackageMetric.functions += _functions - oldFunctions;
                        _pPackageMetric.classes++;

                        // added by SMS
                        _pPackageMetric.javadocs += _javadocs;
                        //_pPackageMetric.javadocsLn += JavaParserTokenManager._iFormalComments - oldFormal;
                        //_pPackageMetric.singleLn += JavaParserTokenManager._iSingleComments - oldSingle;
                        //_pPackageMetric.multiLn += JavaParserTokenManager._iMultiComments - oldMulti;
                        //
                }
                        //Added by REYNAUD Sebastien (LOGICA)
                        else
                        {
                        ObjectMetric metric1 = new ObjectMetric();
                  metric1.name = _sPackage + _sClass;
                        metric1.ncss = _ncss - oldNcss;
                  metric1.functions = _functions - oldFunctions;
                  metric1.classes = _classes - oldClasses;
                  Token lastToken = getToken( 0 );
                  _vClasses.add( metric1 );
                  _pPackageMetric.functions += _functions - oldFunctions;
                  _pPackageMetric.classes++;
                        //_pPackageMetric.javadocs += _javadocs;
                        metric1.javadocs = _javadocs - oldJavadocs;
                        }
                        //

                _functions = oldFunctions;
                _classes = oldClasses + 1;
                _sClass = sOldClass;
  }

  final public void InterfaceMemberDeclaration() throws ParseException {
   int modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      EmptyStatement();
      break;
    default:
      jj_la1[49] = jj_gen;
      if (jj_2_13(2147483647)) {
        NestedClassDeclaration();
      } else if (jj_2_14(2147483647)) {
        NestedInterfaceDeclaration();
      } else if (jj_2_15(2147483647)) {
        modifiers = Modifiers();
        EnumDeclaration(modifiers);
      } else if (jj_2_16(2147483647)) {
        MethodDeclaration();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case TESTAAAA:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case IDENTIFIER:
        case AT:
          modifiers = Modifiers();
          FieldDeclaration();
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void FieldDeclaration() throws ParseException {
    // added by SMS
    Token tmpToken = null;
    boolean bPublic = false;
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FINAL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TRANSIENT:
      case VOLATILE:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
               bPublic = true;
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                  bPublic = true;
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case FINAL:
        jj_consume_token(FINAL);
        break;
      case TRANSIENT:
        jj_consume_token(TRANSIENT);
        break;
      case VOLATILE:
        jj_consume_token(VOLATILE);
        break;
      default:
        jj_la1[52] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                tmpToken = getToken( 0 );

                while( tmpToken.specialToken != null )
                {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) )
                    {
                        if ((bPublic && _bPublic) || _bPrivate)
                        {
                            //_javadocs++;
                            Util.debug( "_jvdc++" );
                            _jvdc++;
                            _jvdcLines += JavaParserTokenManager._iMultiCommentsLast;
                            JavaParserTokenManager._iFormalComments += JavaParserTokenManager._iMultiCommentsLast;
                        }
                        JavaParserTokenManager._iMultiComments -= JavaParserTokenManager._iMultiCommentsLast;
                        break;
                    }
                    else if ( tmpToken.specialToken.image.startsWith( "/*" ) )
                    {
                        break;
                    }

                    //System.out.println("\n"+tmpToken.specialToken.image);

                    tmpToken = tmpToken.specialToken;
                }
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_25;
      }
      Annotation();
    }
    Type();
    VariableDeclarator();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
    jj_consume_token(SEMICOLON);
    _ncss++; Util.debug( "_ncss++" );
  }

  final public void VariableDeclarator() throws ParseException {
    VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      VariableInitializer();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
  }

  final public void VariableDeclaratorId() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENUM:
      jj_consume_token(ENUM);
      break;
    case ASSERT:
    case IDENTIFIER:
      Identifier();
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_27;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
                                          _sName += "[]";
    }
  }

  final public void VariableInitializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      ArrayInitializer();
      break;
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      Expression();
      break;
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ArrayInitializer() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case LBRACE:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      VariableInitializer();
      label_28:
      while (true) {
        if (jj_2_17(2)) {
          ;
        } else {
          break label_28;
        }
        jj_consume_token(COMMA);
        VariableInitializer();
      }
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

  final public void MethodDeclaration() throws ParseException {
    int oldNcss = _ncss;
    int oldFunctions = _functions;
    String sOldFunction = _sFunction;
    int oldcyc = _cyc;
    boolean bOldReturn = _bReturn;
    Token tmpToken = null;
    int jvdc = 0;

    // added by SMS
    int jvdcLines = 0;
    int oldSingle;
    int oldMulti;
    boolean bPublic = false;
    //

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken = null;
        _tmpToken=null;
    if ( _tmpToken != null )
    {
        tmpToken = _tmpToken;
    }
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_29;
      }
         myToken = getToken(1);
      Annotation();
      if ( tmpToken == null ) {

          //tmpToken = getToken( 0 ); //Removed by REYNAUD Sebastien (LOGICA)

                //Added by REYNAUD Sebastien (LOGICA)
                tmpToken = myToken;
                //
      }
    }
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
        ;
        break;
      default:
        jj_la1[62] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
               bPublic = true;
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                    bPublic = true;
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case STATIC:
        jj_consume_token(STATIC);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case FINAL:
        jj_consume_token(FINAL);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_31;
      }
      Annotation();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
               _tmpResultToken = null;
    ResultType();
            if ( tmpToken == null )
            {
                tmpToken = _tmpResultToken;
                if ( tmpToken == null )
                {
                    tmpToken = getToken( 0 );
                }
                Util.debug( "result type tmpToken: " + tmpToken );
            }
    MethodDeclarator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      NameList();
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
                _cyc = 1;
                _bReturn = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      Block();
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  // added by SMS
  {
      Util.debug( "Token: " + String.valueOf( tmpToken.image ) );
      while( tmpToken.specialToken != null )
      {
          Util.debug( "Token comment: " + String.valueOf( tmpToken.specialToken.image ) );
          if ( tmpToken.specialToken.image.startsWith( "/**" ) )
          {
              _javadocs++;
              Util.debug( "MethodDeclaration()._javadocs++" );
              jvdc++;
              if ((bPublic && _bPublic) || _bPrivate) {
                  Util.debug( "_jvdc++" );
                  _jvdc++;
                  jvdcLines = JavaParserTokenManager._iMultiCommentsLast;
                  _jvdcLines += jvdcLines;
                  JavaParserTokenManager._iFormalComments += jvdcLines;
              }
              JavaParserTokenManager._iMultiComments -= jvdcLines;
              break;
          }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
              jvdcLines = 0;
              break;
          }

          //System.out.println("\n"+tmpToken.specialToken.image);

          tmpToken = tmpToken.specialToken;
      }

      oldSingle = JavaParserTokenManager._iSingleComments;
      oldMulti = JavaParserTokenManager._iMultiComments;
  }


             // removed by ccl
             /*
             while( tmpToken.specialToken != null ) {
                 if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                     jvdc++;
                     _javadocs++;
                 }
                 tmpToken = tmpToken.specialToken;
             }
             */
             // removed by SMS
             /*
               while( tmpToken.specialToken != null ) {
               if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
               jvdc++;
               _javadocs++;
               _bJavadoc = true;
               }

               tmpToken = tmpToken.specialToken;
               }
             */

             if (_bReturn)
             {
                 _cyc--;
             }
             _ncss++;
             Util.debug( "MethodDeclaration()._ncss++" );

             FunctionMetric functionMetrics = new FunctionMetric();
             functionMetrics.name = _sPackage + _sClass + _sFunction;
             functionMetrics.ncss = _ncss - oldNcss;
             functionMetrics.ccn = _cyc;
             functionMetrics.javadocs = jvdc;

             // added by SMS
             functionMetrics.javadocsLn = 0; //jvdcLines;
             functionMetrics.singleLn = 0; //JavaParserTokenManager._iSingleComments - oldSingle;
             functionMetrics.multiLn = 0; //JavaParserTokenManager._iMultiComments - oldMulti;
             //

             // specially added for Cobertura
             // Commenting out for now until the rest of patch 2353196 is applied.
             //functionMetrics.beginLine = (new Integer(beginLine));
             //functionMetrics.endLine = (new Integer(endLine));

             _vFunctions.add(functionMetrics);
             _sFunction = sOldFunction;
             _functions = oldFunctions + 1;
             _cyc = oldcyc;
             _bReturn = bOldReturn;

                //Added by REYNAUD Sebastien (LOGICA)
                _tmpToken = null;
                //

  }

  final public void MethodDeclarator() throws ParseException {
                _sFunction = "." + getToken(1).image;
    Identifier();
    FormalParameters();
                _sFunction += _sParameter;
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_32;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
              _sFunction += "[]";
    }
  }

  final public void FormalParameters() throws ParseException {
                _sParameter = "(";
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case TESTAAAA:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:
      FormalParameter();
                            _sParameter += _sName;
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[69] = jj_gen;
          break label_33;
        }
        jj_consume_token(COMMA);
        FormalParameter();
                            _sParameter += "," + _sName;
      }
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                _sParameter += ")";
  }

  final public void FormalParameter() throws ParseException {
    Modifiers();
    Type();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    VariableDeclaratorId();
  }

  final public void ConstructorDeclaration() throws ParseException {
        int oldNcss = _ncss;
        int oldFunctions = _functions;
        String sOldFunction = _sFunction;
        int oldcyc = _cyc;
        boolean bOldReturn = _bReturn;
        Token tmpToken = null;
        int jvdc = 0;

        // added by SMS
        int oldSingle;
        int oldMulti;
        int jvdcLines = 0;
        boolean bPublic = false;
        //

        //Added by REYNAUD Sebastien (LOGICA)
        Token myToken = null;
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_34;
      }
         myToken = getToken(1);
      Annotation();
        if ( tmpToken == null )
                {
                        tmpToken = myToken;
        }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
               bPublic = true;
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                 bPublic = true;
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
      if ( tmpToken == null ) {
          tmpToken = getToken( 0 );
      }
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    Identifier();
            if ( tmpToken == null ) {
                tmpToken = getToken( 0 );
            }
                _cyc = 1;
                _sFunction = _sPackage + _sClass + "." + getToken(0).image;
    FormalParameters();
                _sFunction += _sParameter;
                _bReturn = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      NameList();
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    if (jj_2_18(2147483647)) {
      ExplicitConstructorInvocation();
    } else {
      ;
    }
    if (jj_2_19(2147483647)) {
      ExplicitConstructorInvocation();
    } else {
      ;
    }
                while( tmpToken.specialToken != null ) {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                        _javadocs++;
                        jvdc++;
                        if ((bPublic && _bPublic) || _bPrivate) {
                            Util.debug( "_jvdc++" );
                            _jvdc++;
                            jvdcLines = JavaParserTokenManager._iMultiCommentsLast;
                            _jvdcLines += jvdcLines;
                            JavaParserTokenManager._iFormalComments += jvdcLines;
                        }
                        JavaParserTokenManager._iMultiComments -= jvdcLines;
                        break;
                    }  else if ( tmpToken.specialToken.image.startsWith( "/*" ) ) {
                        jvdcLines = 0;
                        break;
                    }

                    //System.out.println("\n"+tmpToken.specialToken.image);

                    tmpToken = tmpToken.specialToken;
                }


                oldSingle = JavaParserTokenManager._iSingleComments;
                oldMulti = JavaParserTokenManager._iMultiComments;
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CLASS:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FINAL:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case RETURN:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRANSIENT:
      case TRUE:
      case TRY:
      case VOID:
      case VOLATILE:
      case WHILE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case INCR:
      case DECR:
        ;
        break;
      default:
        jj_la1[77] = jj_gen;
        break label_35;
      }
      BlockStatement();
    }
    jj_consume_token(RBRACE);
            /*
                while( tmpToken.specialToken != null ) {
                    if ( tmpToken.specialToken.image.startsWith( "/**" ) ) {
                        jvdc++;
                        _javadocs++;
                    }
                    tmpToken = tmpToken.specialToken;
                }
            */
                if (_bReturn) {
                        _cyc--;
                }
                _ncss++;
                Util.debug( "_ncss++" );

                FunctionMetric functionMetrics = new FunctionMetric();
                functionMetrics.name = _sFunction;
                functionMetrics.ncss = _ncss - oldNcss;
                functionMetrics.ccn = _cyc;
                functionMetrics.javadocs = jvdc;

                // added by SMS
                functionMetrics.javadocsLn = jvdcLines;
                functionMetrics.singleLn = JavaParserTokenManager._iSingleComments - oldSingle;
                functionMetrics.multiLn = JavaParserTokenManager._iMultiComments - oldMulti;
                //
                // specially added for Cobertura
                // Commenting out for now until the rest of patch 2353196 is applied.
                //functionMetrics.endLine = beginLine;
                //functionMetrics.endLine = endLine;

                _vFunctions.add(functionMetrics);
                _sFunction = sOldFunction;
                _functions = oldFunctions + 1;
                _cyc = oldcyc;
                _bReturn = bOldReturn;

                //Added by REYNAUD Sebastien (LOGICA)
                _tmpToken = null;
                //

  }

  final public void ExplicitConstructorInvocation() throws ParseException {
    if (jj_2_21(2147483647)) {
      jj_consume_token(THIS);
      Arguments();
      jj_consume_token(SEMICOLON);
           _ncss++;       Util.debug( "_ncss++" );
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
        if (jj_2_20(2147483647)) {
          PrimaryExpression();
          jj_consume_token(DOT);
        } else {
          ;
        }
        jj_consume_token(SUPER);
        Arguments();
        jj_consume_token(SEMICOLON);
    _ncss++;       Util.debug( "_ncss++" );
//System.out.println( "\n\nAfter ExplicitConstructorInvocation\n" );

        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Initializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATIC:
      jj_consume_token(STATIC);
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    Block();
          _ncss++;       Util.debug( "_ncss++" );
  }

/*
 * Type, name and expression syntax follows.
 */
  final public void Type() throws ParseException {
    if (jj_2_22(2)) {
      ReferenceType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
        PrimitiveType();
                  _sName = getToken(0).image;
        break;
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
ccl 2008-01-24
{
  ( PrimitiveType()
          {
                  _sName = getToken(0).image;
          }
    | Name()
    [TypeArguments() ["." Identifier()] ]
) ( "[" "]" { _sName += "[]"; } )*
}
*/

/*
 * Takes special consideration for assert.
 */
  final public void FieldTypeLookahead() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      break;
    case IDENTIFIER:
      FieldTypeNameLookahead();
      break;
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[82] = jj_gen;
        break label_36;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    }
  }

  final public void PrimitiveType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case BYTE:
      jj_consume_token(BYTE);
      break;
    case SHORT:
      jj_consume_token(SHORT);
      break;
    case INT:
      jj_consume_token(INT);
      break;
    case LONG:
      jj_consume_token(LONG);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      break;
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ResultType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      Type();
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Name() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENUM:
      jj_consume_token(ENUM);
      break;
    case ASSERT:
    case IDENTIFIER:
      Identifier();
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                _sName = getToken(0).image;
                _tmpResultToken = getToken( 0 );
                Util.debug( "Name._tmpResultToken: " + _tmpResultToken );
    label_37:
    while (true) {
      if (jj_2_23(2)) {
        ;
      } else {
        break label_37;
      }
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENUM:
        jj_consume_token(ENUM);
        break;
      case ASSERT:
      case IDENTIFIER:
        Identifier();
        break;
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                _sName += "." + getToken(0).image;
    }
  }

/**
 * Takes special consideration for assert.
 */
  final public void FieldTypeNameLookahead() throws ParseException {
    jj_consume_token(IDENTIFIER);
    label_38:
    while (true) {
      if (jj_2_24(2)) {
        ;
      } else {
        break label_38;
      }
      jj_consume_token(DOT);
      Identifier();
    }
  }

  final public void NameList() throws ParseException {
    Name();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeArguments();
      break;
    default:
      jj_la1[87] = jj_gen;
      ;
    }
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[88] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
      Name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[89] = jj_gen;
        ;
      }
    }
  }

/*
 * Expression syntax follows.
 */
  final public void Expression() throws ParseException {
    if (jj_2_25(2147483647)) {
      Assignment();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case BANG:
      case TILDE:
      case INCR:
      case DECR:
      case PLUS:
      case MINUS:
        ConditionalExpression();
        break;
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Assignment() throws ParseException {
    PrimaryExpression();
    AssignmentOperator();
    Expression();
  }

  final public void AssignmentOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
      break;
    case STARASSIGN:
      jj_consume_token(STARASSIGN);
      break;
    case SLASHASSIGN:
      jj_consume_token(SLASHASSIGN);
      break;
    case REMASSIGN:
      jj_consume_token(REMASSIGN);
      break;
    case PLUSASSIGN:
      jj_consume_token(PLUSASSIGN);
      break;
    case MINUSASSIGN:
      jj_consume_token(MINUSASSIGN);
      break;
    case LSHIFTASSIGN:
      jj_consume_token(LSHIFTASSIGN);
      break;
    case RSIGNEDSHIFTASSIGN:
      jj_consume_token(RSIGNEDSHIFTASSIGN);
      break;
    case RUNSIGNEDSHIFTASSIGN:
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
      break;
    case ANDASSIGN:
      jj_consume_token(ANDASSIGN);
      break;
    case XORASSIGN:
      jj_consume_token(XORASSIGN);
      break;
    case ORASSIGN:
      jj_consume_token(ORASSIGN);
      break;
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ConditionalExpression() throws ParseException {
    ConditionalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOOK:
      jj_consume_token(HOOK);
      Expression();
      jj_consume_token(COLON);
      ConditionalExpression();
                                                                             _cyc++;
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[93] = jj_gen;
        break label_40;
      }
      jj_consume_token(SC_OR);
                                      _cyc++;
      ConditionalAndExpression();
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    InclusiveOrExpression();
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_41;
      }
      jj_consume_token(SC_AND);
                                   _cyc++;
      InclusiveOrExpression();
    }
  }

  final public void InclusiveOrExpression() throws ParseException {
    ExclusiveOrExpression();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_42;
      }
      jj_consume_token(BIT_OR);
      ExclusiveOrExpression();
    }
  }

  final public void ExclusiveOrExpression() throws ParseException {
    AndExpression();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[96] = jj_gen;
        break label_43;
      }
      jj_consume_token(XOR);
      AndExpression();
    }
  }

  final public void AndExpression() throws ParseException {
    EqualityExpression();
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[97] = jj_gen;
        break label_44;
      }
      jj_consume_token(BIT_AND);
      EqualityExpression();
    }
  }

  final public void EqualityExpression() throws ParseException {
    InstanceOfExpression();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_45;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        break;
      case NE:
        jj_consume_token(NE);
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      InstanceOfExpression();
    }
  }

  final public void InstanceOfExpression() throws ParseException {
    RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTANCEOF:
      jj_consume_token(INSTANCEOF);
      Type();
      break;
    default:
      jj_la1[100] = jj_gen;
      ;
    }
  }

  final public void RelationalExpression() throws ParseException {
    ShiftExpression();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
      case LT:
      case LE:
      case GE:
        ;
        break;
      default:
        jj_la1[101] = jj_gen;
        break label_46;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        jj_consume_token(LT);
        break;
      case GT:
        jj_consume_token(GT);
        break;
      case LE:
        jj_consume_token(LE);
        break;
      case GE:
        jj_consume_token(GE);
        break;
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ShiftExpression();
    }
  }

  final public void ShiftExpression() throws ParseException {
    AdditiveExpression();
    label_47:
    while (true) {
      if (jj_2_26(3)) {
        ;
      } else {
        break label_47;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSHIFT:
        jj_consume_token(LSHIFT);
        break;
      case GT:
        jj_consume_token(GT);
        jj_consume_token(GT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT:
          jj_consume_token(GT);
          break;
        default:
          jj_la1[103] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[104] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      AdditiveExpression();
    }
  }

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[105] = jj_gen;
        break label_48;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      MultiplicativeExpression();
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_49;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case SLASH:
        jj_consume_token(SLASH);
        break;
      case REM:
        jj_consume_token(REM);
        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
    }
  }

  final public void UnaryExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
      UnaryExpressionNotPlusMinus();
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PreIncrementExpression() throws ParseException {
    jj_consume_token(INCR);
    PrimaryExpression();
  }

  final public void PreDecrementExpression() throws ParseException {
    jj_consume_token(DECR);
    PrimaryExpression();
  }

  final public void UnaryExpressionNotPlusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BANG:
    case TILDE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TILDE:
        jj_consume_token(TILDE);
        break;
      case BANG:
        jj_consume_token(BANG);
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      UnaryExpression();
      break;
    default:
      jj_la1[112] = jj_gen;
      if (jj_2_27(2147483647)) {
        CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSERT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
          PostfixExpression();
          break;
        default:
          jj_la1[113] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

// This production is to determine lookahead only.  The LOOKAHEAD specifications
// below are not used, but they are there just to indicate that we know about
// this.
  final public void CastLookahead() throws ParseException {
    if (jj_2_28(2)) {
      jj_consume_token(LPAREN);
      PrimitiveType();
    } else if (jj_2_29(2147483647)) {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TILDE:
          jj_consume_token(TILDE);
          break;
        case BANG:
          jj_consume_token(BANG);
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          break;
        case ASSERT:
        case IDENTIFIER:
          Identifier();
          break;
        case THIS:
          jj_consume_token(THIS);
          break;
        case SUPER:
          jj_consume_token(SUPER);
          break;
        case NEW:
          jj_consume_token(NEW);
          break;
        case FALSE:
        case NULL:
        case TRUE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
          Literal();
          break;
        default:
          jj_la1[114] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// To fix bug Test48.java. Clemens [2000-10-03]
  final public void PostfixLookahead() throws ParseException {
    jj_consume_token(LPAREN);
    Name();
    label_50:
    while (true) {
      if (jj_2_30(2)) {
        ;
      } else {
        break label_50;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    }
    jj_consume_token(DOT);
  }

  final public void PostfixExpression() throws ParseException {
    PrimaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
    case DECR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCR:
        jj_consume_token(INCR);
        break;
      case DECR:
        jj_consume_token(DECR);
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
  }

  final public void CastExpression() throws ParseException {
    if (jj_2_31(2147483647)) {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(RPAREN);
      UnaryExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        Type();
        jj_consume_token(RPAREN);
        UnaryExpressionNotPlusMinus();
        break;
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimaryExpression() throws ParseException {
    PrimaryPrefix();
    label_51:
    while (true) {
      if (jj_2_32(2)) {
        ;
      } else {
        break label_51;
      }
      PrimarySuffix();
    }
  }

  final public void PrimaryPrefix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      Literal();
      break;
    case THIS:
      jj_consume_token(THIS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        break;
      default:
        jj_la1[119] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSERT:
      case IDENTIFIER:
        Identifier();
        break;
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[123] = jj_gen;
      if (jj_2_34(2)) {
        jj_consume_token(SUPER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          jj_consume_token(DOT);
          break;
        default:
          jj_la1[121] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSERT:
        case IDENTIFIER:
          Identifier();
          break;
        default:
          jj_la1[122] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          Expression();
          jj_consume_token(RPAREN);
          break;
        case NEW:
          AllocationExpression();
          break;
        default:
          jj_la1[124] = jj_gen;
          if (jj_2_35(2147483647)) {
            ResultType();
            jj_consume_token(DOT);
            jj_consume_token(CLASS);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASSERT:
            case ENUM:
            case IDENTIFIER:
              Name();
              if (jj_2_33(3)) {
                jj_consume_token(DOT);
                jj_consume_token(SUPER);
                jj_consume_token(DOT);
                Identifier();
              } else {
                ;
              }
              break;
            default:
              jj_la1[125] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
  }

  final public void PrimarySuffix() throws ParseException {
    if (jj_2_36(2)) {
      jj_consume_token(DOT);
      jj_consume_token(THIS);
    } else if (jj_2_37(2)) {
      jj_consume_token(DOT);
      AllocationExpression();
    } else if (jj_2_38(3)) {
      MemberSelector();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        Expression();
        jj_consume_token(RBRACKET);
        break;
      case DOT:
        jj_consume_token(DOT);
        Identifier();
        break;
      case LPAREN:
        Arguments();
        break;
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
      break;
    case FALSE:
    case TRUE:
      BooleanLiteral();
      break;
    case NULL:
      NullLiteral();
      break;
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
      break;
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void NullLiteral() throws ParseException {
    jj_consume_token(NULL);
  }

  final public void Arguments() throws ParseException {
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      ArgumentList();
      break;
    default:
      jj_la1[129] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void ArgumentList() throws ParseException {
    Expression();
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[130] = jj_gen;
        break label_52;
      }
      jj_consume_token(COMMA);
      Expression();
    }
  }

  final public void AllocationExpression() throws ParseException {
        String sOldClass = _sClass;
        //int oldNcss = _ncss;
        int oldFunctions = _functions;
        int oldClasses = _classes;
        String sName;

        //Added by REYNAUD Sebastien (LOGICA)
        int oldJavadocs = _javadocs;
        int oldNcss = _ncss;
    if (jj_2_39(2)) {
      jj_consume_token(NEW);
      PrimitiveType();
      ArrayDimsAndInits();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEW:
        jj_consume_token(NEW);
        Name();
                          sName = _sName;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[131] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ArrayDimsAndInits();
          break;
        case LPAREN:
          Arguments();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
                         if (!_sClass.equals("")) {
                                 _sClass += ".";
                         }
                         /*_sClass += sName;*/
                         //_sClass += sName + "$" + _anonClassCount ;//Removed by REYNAUD Sebastien (LOGICA)

                                //Added by REYNAUD Sebastien (LOGICA)
                                _sClass += sName;
                                //
                         _classLevel ++;
            ClassBody();
                                //Added by REYNAUD Sebastien (LOGICA)
                                ObjectMetric metric = new ObjectMetric();
                                metric.name = _sPackage + _sClass;
                                metric.ncss = _ncss - oldNcss;
                            metric.functions = _functions - oldFunctions;
                      metric.classes = _classes - oldClasses;
                        Token lastToken = getToken( 0 );
                        _vClasses.add( metric );
                        _pPackageMetric.functions += _functions - oldFunctions;
                        _pPackageMetric.classes++;
                                metric.javadocs = _javadocs - oldJavadocs;
                                //
                                _classLevel--;
                                _functions = oldFunctions;
                                _classes = oldClasses + 1;
                                _sClass = sOldClass;
            break;
          default:
            jj_la1[132] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[133] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[134] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * The third LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
  final public void ArrayDimsAndInits() throws ParseException {
    if (jj_2_42(2)) {
      label_53:
      while (true) {
        jj_consume_token(LBRACKET);
        Expression();
        jj_consume_token(RBRACKET);
        if (jj_2_40(2)) {
          ;
        } else {
          break label_53;
        }
      }
      label_54:
      while (true) {
        if (jj_2_41(2)) {
          ;
        } else {
          break label_54;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        label_55:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            ;
            break;
          default:
            jj_la1[135] = jj_gen;
            break label_55;
          }
        }
        ArrayInitializer();
        break;
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * Statement syntax follows.
 */
  final public void Statement() throws ParseException {
        _bReturn = false;
    if (jj_2_43(2)) {
      LabeledStatement();
    } else if (jj_2_44(2147483647)) {
      AssertStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        Block();
        break;
      case SEMICOLON:
        EmptyStatement();
        break;
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case INCR:
      case DECR:
        StatementExpression();
        jj_consume_token(SEMICOLON);
          _ncss++;       Util.debug( "_ncss++" );
        break;
      case SWITCH:
        SwitchStatement();
        break;
      case IF:
        IfStatement();
          _cyc++;
        break;
      case WHILE:
        WhileStatement();
          _cyc++;
        break;
      case DO:
        DoStatement();
          _cyc++;
        break;
      case FOR:
        ForStatement();
          _cyc++;
        break;
      case BREAK:
        BreakStatement();
        break;
      case CONTINUE:
        ContinueStatement();
        break;
      case RETURN:
        ReturnStatement();
        break;
      case THROW:
        ThrowStatement();
        break;
      case SYNCHRONIZED:
        SynchronizedStatement();
        break;
      case TRY:
        TryStatement();
        break;
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void LabeledStatement() throws ParseException {
    Identifier();
    jj_consume_token(COLON);
    Statement();
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void AssertStatementLookahead() throws ParseException {
    jj_consume_token(ASSERT);
    Expression();
  }

  final public void AssertStatement() throws ParseException {
    jj_consume_token(ASSERT);
    Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      Expression();
      break;
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    _ncss++;       Util.debug( "_ncss++" );
  }

  final public void Block() throws ParseException {
    jj_consume_token(LBRACE);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CLASS:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FINAL:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case RETURN:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRANSIENT:
      case TRUE:
      case TRY:
      case VOID:
      case VOLATILE:
      case WHILE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case INCR:
      case DECR:
        ;
        break;
      default:
        jj_la1[139] = jj_gen;
        break label_56;
      }
      BlockStatement();
    }
    jj_consume_token(RBRACE);
  }

  final public void BlockStatement() throws ParseException {
    if (jj_2_45(2147483647)) {
      LocalVariableDeclaration();
      jj_consume_token(SEMICOLON);
                _ncss++;       Util.debug( "_ncss++" );
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BREAK:
      case BYTE:
      case CHAR:
      case CONTINUE:
      case DO:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case FOR:
      case IF:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case RETURN:
      case SHORT:
      case SUPER:
      case SWITCH:
      case SYNCHRONIZED:
      case THIS:
      case THROW:
      case TRUE:
      case TRY:
      case VOID:
      case WHILE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
      case SEMICOLON:
      case INCR:
      case DECR:
        Statement();
        break;
      case ABSTRACT:
      case CLASS:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case TESTAAAA:
      case TRANSIENT:
      case VOLATILE:
      case AT:
        UnmodifiedClassDeclaration();
        break;
      case INTERFACE:
        UnmodifiedInterfaceDeclaration();
        break;
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*void LocalVariableDeclaration() :
{}
{
  [ "final" ] Type() VariableDeclarator() ( "," VariableDeclarator() )*
}*/
  final public void LocalVariableDeclaration() throws ParseException {
    Modifiers();
    Type();
    VariableDeclarator();
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[141] = jj_gen;
        break label_57;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
  }

  final public void EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
  }

  final public void StatementExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCR:
      PreIncrementExpression();
      break;
    case DECR:
      PreDecrementExpression();
      break;
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
      PrimaryExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
      case INCR:
      case DECR:
      case PLUSASSIGN:
      case MINUSASSIGN:
      case STARASSIGN:
      case SLASHASSIGN:
      case ANDASSIGN:
      case ORASSIGN:
      case XORASSIGN:
      case REMASSIGN:
      case LSHIFTASSIGN:
      case RSIGNEDSHIFTASSIGN:
      case RUNSIGNEDSHIFTASSIGN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INCR:
          jj_consume_token(INCR);
          break;
        case DECR:
          jj_consume_token(DECR);
          break;
        case ASSIGN:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case LSHIFTASSIGN:
        case RSIGNEDSHIFTASSIGN:
        case RUNSIGNEDSHIFTASSIGN:
          AssignmentOperator();
          Expression();
          break;
        default:
          jj_la1[142] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[144] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SwitchStatement() throws ParseException {
                _localCases = 0;
    jj_consume_token(SWITCH);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case _DEFAULT:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_58;
      }
      SwitchLabel();
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case ASSERT:
        case BOOLEAN:
        case BREAK:
        case BYTE:
        case CHAR:
        case CLASS:
        case CONTINUE:
        case DO:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FINAL:
        case FLOAT:
        case FOR:
        case IF:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case NEW:
        case NULL:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case RETURN:
        case SHORT:
        case STATIC:
        case TESTAAAA:
        case SUPER:
        case SWITCH:
        case SYNCHRONIZED:
        case THIS:
        case THROW:
        case TRANSIENT:
        case TRUE:
        case TRY:
        case VOID:
        case VOLATILE:
        case WHILE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case INCR:
        case DECR:
          ;
          break;
        default:
          jj_la1[146] = jj_gen;
          break label_59;
        }
        BlockStatement();
      }
    }
    jj_consume_token(RBRACE);
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void SwitchLabel() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
      jj_consume_token(CASE);
      Expression();
      jj_consume_token(COLON);
                _ncss++;
                Util.debug( "_ncss++" );
                _localCases++;
                _cyc++;
      break;
    case _DEFAULT:
      jj_consume_token(_DEFAULT);
      jj_consume_token(COLON);
                _ncss++;       Util.debug( "_ncss++" );
      break;
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void IfStatement() throws ParseException {
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Statement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
                                                                _ncss++;       Util.debug( "_ncss++" );
      Statement();
      break;
    default:
      jj_la1[148] = jj_gen;
      ;
    }
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void WhileStatement() throws ParseException {
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Statement();
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void DoStatement() throws ParseException {
    jj_consume_token(DO);
    Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void ForStatement() throws ParseException {
    jj_consume_token(FOR);
    jj_consume_token(LPAREN);
    if (jj_2_46(2147483647)) {
      Modifiers();
      Type();
      jj_consume_token(IDENTIFIER);
      jj_consume_token(COLON);
      Expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case NATIVE:
      case NEW:
      case NULL:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SUPER:
      case SYNCHRONIZED:
      case THIS:
      case TRANSIENT:
      case TRUE:
      case VOID:
      case VOLATILE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case SEMICOLON:
      case AT:
      case INCR:
      case DECR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case ASSERT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case NATIVE:
        case NEW:
        case NULL:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case TESTAAAA:
        case SUPER:
        case SYNCHRONIZED:
        case THIS:
        case TRANSIENT:
        case TRUE:
        case VOID:
        case VOLATILE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:
        case INCR:
        case DECR:
          ForInit();
          break;
        default:
          jj_la1[149] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSERT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case BANG:
        case TILDE:
        case INCR:
        case DECR:
        case PLUS:
        case MINUS:
          Expression();
          break;
        default:
          jj_la1[150] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSERT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case INCR:
        case DECR:
          ForUpdate();
          break;
        default:
          jj_la1[151] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    Statement();
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void ForInit() throws ParseException {
    if (jj_2_47(2147483647)) {
      LocalVariableDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case INCR:
      case DECR:
        StatementExpressionList();
        break;
      default:
        jj_la1[153] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void StatementExpressionList() throws ParseException {
    StatementExpression();
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_60;
      }
      jj_consume_token(COMMA);
      StatementExpression();
    }
  }

  final public void ForUpdate() throws ParseException {
    StatementExpressionList();
  }

  final public void BreakStatement() throws ParseException {
    jj_consume_token(BREAK);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case IDENTIFIER:
      Identifier();
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void ContinueStatement() throws ParseException {
    jj_consume_token(CONTINUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case IDENTIFIER:
      Identifier();
      break;
    default:
      jj_la1[156] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void ReturnStatement() throws ParseException {
    jj_consume_token(RETURN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      Expression();
      break;
    default:
      jj_la1[157] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
                _ncss++;
                Util.debug( "_ncss++" );
                _cyc++;
                _bReturn = true;
  }

  final public void ThrowStatement() throws ParseException {
    jj_consume_token(THROW);
    Expression();
    jj_consume_token(SEMICOLON);
                _ncss++;
                Util.debug( "_ncss++" );
                _cyc++;
  }

  final public void SynchronizedStatement() throws ParseException {
    jj_consume_token(SYNCHRONIZED);
    jj_consume_token(LPAREN);
    Expression();
    jj_consume_token(RPAREN);
    Block();
          _ncss++;       Util.debug( "_ncss++" );
  }

  final public void TryStatement() throws ParseException {
    jj_consume_token(TRY);
    Block();
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
        ;
        break;
      default:
        jj_la1[158] = jj_gen;
        break label_61;
      }
      jj_consume_token(CATCH);
      jj_consume_token(LPAREN);
      FormalParameter();
      jj_consume_token(RPAREN);
      Block();
                                                _ncss++;       Util.debug( "_ncss++" ); _cyc++;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINALLY:
      jj_consume_token(FINALLY);
      Block();
                        _ncss++;       Util.debug( "_ncss++" );
      break;
    default:
      jj_la1[159] = jj_gen;
      ;
    }
  }

  final public void Identifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case ASSERT:
      jj_consume_token(ASSERT);
      break;
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* Annotation syntax follows. */
  final public void Annotation() throws ParseException {
    if (jj_2_48(2147483647)) {
      NormalAnnotation();
    } else if (jj_2_49(2147483647)) {
      SingleMemberAnnotation();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        MarkerAnnotation();
        break;
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void NormalAnnotation() throws ParseException {
    jj_consume_token(AT);
    Name();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      MemberValuePairs();
      break;
    default:
      jj_la1[162] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void MarkerAnnotation() throws ParseException {
    jj_consume_token(AT);
    Name();
  }

  final public void SingleMemberAnnotation() throws ParseException {
    jj_consume_token(AT);
    Name();
    jj_consume_token(LPAREN);
    MemberValue();
    jj_consume_token(RPAREN);
  }

  final public void MemberValuePairs() throws ParseException {
    MemberValuePair();
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_62;
      }
      jj_consume_token(COMMA);
      MemberValuePair();
    }
  }

  final public void MemberValuePair() throws ParseException {
    jj_consume_token(IDENTIFIER);
    jj_consume_token(ASSIGN);
    MemberValue();
  }

  final public void MemberValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      Annotation();
      break;
    case LBRACE:
      MemberValueArrayInitializer();
      break;
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      ConditionalExpression();
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void MemberValueArrayInitializer() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
    case LBRACE:
    case AT:
    case BANG:
    case TILDE:
    case INCR:
    case DECR:
    case PLUS:
    case MINUS:
      MemberValue();
      break;
    default:
      jj_la1[165] = jj_gen;
      ;
    }
    label_63:
    while (true) {
      if (jj_2_50(2)) {
        ;
      } else {
        break label_63;
      }
      jj_consume_token(COMMA);
      MemberValue();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[166] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

/*
 =================================================
 Java 1.5 stuff starts here
 =================================================
*/

/* Annotation Types. */

//Added by REYNAUD Sebastien (LOGICA)
  final public void CreationAnnotation() throws ParseException {
    jj_consume_token(AT);
    jj_consume_token(INTERFACE);
    jj_consume_token(IDENTIFIER);
    jj_consume_token(LBRACE);
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case IDENTIFIER:
      case SEMICOLON:
      case AT:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_64;
      }
      AnnotationTypeMemberDeclaration();
    }
    jj_consume_token(RBRACE);
  }

//
  final public void AnnotationTypeDeclaration(int modifiers) throws ParseException {
    jj_consume_token(AT);
    jj_consume_token(INTERFACE);
    jj_consume_token(IDENTIFIER);
    AnnotationTypeBody();
  }

  final public void AnnotationTypeBody() throws ParseException {
    jj_consume_token(LBRACE);
       _ncss++;       Util.debug( "_ncss++" );
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case IDENTIFIER:
      case SEMICOLON:
      case AT:
        ;
        break;
      default:
        jj_la1[168] = jj_gen;
        break label_65;
      }
      AnnotationTypeMemberDeclaration();
    }
    jj_consume_token(RBRACE);
  }

  final public void AnnotationTypeMemberDeclaration() throws ParseException {
   int modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case CLASS:
    case DOUBLE:
    case ENUM:
    case FINAL:
    case FLOAT:
    case INT:
    case INTERFACE:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case TESTAAAA:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:
      modifiers = Modifiers();
      if (jj_2_51(2147483647)) {
        Type();
        jj_consume_token(IDENTIFIER);
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case _DEFAULT:
          DefaultValue();
          break;
        default:
          jj_la1[169] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
            _ncss++;
            Util.debug( "_ncss++" );
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CLASS:
        case INTERFACE:
          ClassOrInterfaceDeclaration(modifiers);
          break;
        case ENUM:
          EnumDeclaration(modifiers);
          break;
        case AT:
          AnnotationTypeDeclaration(modifiers);
          break;
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
        case IDENTIFIER:
          FieldDeclaration15(modifiers);
          break;
        default:
          jj_la1[170] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
            _ncss++;
            Util.debug( "_ncss++" );
      break;
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DefaultValue() throws ParseException {
    jj_consume_token(_DEFAULT);
    MemberValue();
  }

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public int Modifiers() throws ParseException {
   int modifiers = 0;
   _tmpToken = null;
    label_66:
    while (true) {
      if (jj_2_52(2)) {
        ;
      } else {
        break label_66;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
              modifiers |= ModifierSet.PUBLIC;
      if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case STATIC:
        jj_consume_token(STATIC);
              modifiers |= ModifierSet.STATIC;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                 modifiers |= ModifierSet.PROTECTED;       if ( _tmpToken == null ) {
       _tmpToken = getToken( 0 );
      }
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
               modifiers |= ModifierSet.PRIVATE;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case FINAL:
        jj_consume_token(FINAL);
             modifiers |= ModifierSet.FINAL;       if ( _tmpToken == null ) {
       _tmpToken = getToken( 0 );
      }
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
                modifiers |= ModifierSet.ABSTRACT;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
                    modifiers |= ModifierSet.SYNCHRONIZED;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
              modifiers |= ModifierSet.NATIVE;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case TRANSIENT:
        jj_consume_token(TRANSIENT);
                 modifiers |= ModifierSet.TRANSIENT;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case VOLATILE:
        jj_consume_token(VOLATILE);
                modifiers |= ModifierSet.VOLATILE;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case TESTAAAA:
        jj_consume_token(TESTAAAA);
                modifiers |= ModifierSet.STRICTFP;       if ( _tmpToken == null ) {
          _tmpToken = getToken( 0 );
      }
        break;
      case AT:
        Annotation();
        break;
      default:
        jj_la1[172] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return modifiers;}
    throw new Error("Missing return statement in function");
  }

  final public void ClassOrInterfaceDeclaration(int modifiers) throws ParseException {
   boolean isInterface = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      break;
    case INTERFACE:
      jj_consume_token(INTERFACE);
                            isInterface = true;
      break;
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      TypeParameters();
      break;
    default:
      jj_la1[174] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      ExtendsList(isInterface);
      break;
    default:
      jj_la1[175] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      ImplementsList(isInterface);
      break;
    default:
      jj_la1[176] = jj_gen;
      ;
    }
    ClassOrInterfaceBody(isInterface);
  }

  final public void EnumDeclaration(int modifiers) throws ParseException {
        String sOldClass = _sClass;
        int oldClasses = _classes;
        int oldNcss = _ncss;
        int oldFunctions = _functions;

        // Chris Povirk
        int oldSingle;
        int oldMulti;
      Util.debug( "EnumDeclaration().START" );
    jj_consume_token(ENUM);
    jj_consume_token(IDENTIFIER);
                if (!_sClass.equals("")) {
                        _sClass += ".";
                }
                _sClass += getToken(0).image;
                _classLevel ++;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      ImplementsList(false);
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
        // Chris Povirk
      oldSingle = JavaParserTokenManager._iSingleComments;
      oldMulti = JavaParserTokenManager._iMultiComments;
    EnumBody();
             _classLevel--;
             if (_classLevel == 0) {
                 //_topLevelClasses++;
                 ObjectMetric metric = new ObjectMetric();
                 metric.name = _sPackage + _sClass;
                 metric.ncss = _ncss - oldNcss;
                 metric.functions = _functions - oldFunctions;
                 metric.classes = _classes - oldClasses;
                 Token lastToken = getToken( 0 );
                 //metric.add( new Integer( lastToken.endLine ) );
                 //metric.add( new Integer( lastToken.endColumn ) );
                 metric.javadocs = _javadocs;

                 // Chris Povirk
                 metric.javadocsLn = _jvdcLines;
                 metric.singleLn = JavaParserTokenManager._iSingleComments - oldSingle;
                 metric.multiLn = JavaParserTokenManager._iMultiComments - oldMulti;

                 _vClasses.add(metric);
                 _pPackageMetric.functions += _functions - oldFunctions;
                 _pPackageMetric.classes++;

                 // added by SMS
                 _pPackageMetric.javadocs += _javadocs;
                 //_pPackageMetric.javadocsLn += JavaParserTokenManager._iFormalComments - oldFormal;
                 //_pPackageMetric.singleLn += JavaParserTokenManager._iSingleComments - oldSingle;
                 //_pPackageMetric.multiLn += Manager._iMultiComments - oldMulti;
                 //
             }
             _functions = oldFunctions;
             _classes = oldClasses + 1;
             _sClass = sOldClass;
  }

  final public void TypeParameters() throws ParseException {
    jj_consume_token(LT);
    TypeParameter();
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[178] = jj_gen;
        break label_67;
      }
      jj_consume_token(COMMA);
      TypeParameter();
    }
    jj_consume_token(GT);
  }

  final public void ExtendsList(boolean isInterface) throws ParseException {
   boolean extendsMoreThanOne = false;
    jj_consume_token(EXTENDS);
    ClassOrInterfaceType();
    label_68:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[179] = jj_gen;
        break label_68;
      }
      jj_consume_token(COMMA);
      ClassOrInterfaceType();
                                  extendsMoreThanOne = true;
    }
      if (extendsMoreThanOne && !isInterface)
         {if (true) throw new ParseException("A class cannot extend more than one other class");}
  }

  final public void ImplementsList(boolean isInterface) throws ParseException {
    jj_consume_token(IMPLEMENTS);
    ClassOrInterfaceType();
    label_69:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[180] = jj_gen;
        break label_69;
      }
      jj_consume_token(COMMA);
      ClassOrInterfaceType();
    }
      if (isInterface)
         {if (true) throw new ParseException("An interface cannot implement other interfaces");}
  }

  final public void ClassOrInterfaceBody(boolean isInterface) throws ParseException {
    jj_consume_token(LBRACE);
           _ncss++; Util.debug( "ClassOrInterfaceBody()._ncss++" );
    label_70:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case LT:
        ;
        break;
      default:
        jj_la1[181] = jj_gen;
        break label_70;
      }
      ClassOrInterfaceBodyDeclaration(isInterface);
    }
    jj_consume_token(RBRACE);
  }

  final public void EnumBody() throws ParseException {
    jj_consume_token(LBRACE);
               _ncss++;
               Util.debug( "_ncss++" );
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case FINAL:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case STATIC:
    case TESTAAAA:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:
      EnumConstant();
      label_71:
      while (true) {
        if (jj_2_53(2)) {
          ;
        } else {
          break label_71;
        }
        jj_consume_token(COMMA);
        EnumConstant();
      }
      break;
    default:
      jj_la1[182] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_72:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case ASSERT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case TESTAAAA:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOID:
        case VOLATILE:
        case IDENTIFIER:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case LT:
          ;
          break;
        default:
          jj_la1[184] = jj_gen;
          break label_72;
        }
        ClassOrInterfaceBodyDeclaration(false);
      }
      break;
    default:
      jj_la1[185] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

  final public void TypeParameter() throws ParseException {
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      TypeBound();
      break;
    default:
      jj_la1[186] = jj_gen;
      ;
    }
  }

  final public void ClassOrInterfaceType() throws ParseException {
    jj_consume_token(IDENTIFIER);
                _sName = getToken(0).image;
                if ( _tmpResultToken == null )
                {
                  _tmpResultToken = getToken( 0 );
                  Util.debug( "ClassOrInterfaceType._tmpResultToken: " + _tmpResultToken );
                }
    if (jj_2_54(4)) {
      TypeArguments();
    } else {
      ;
    }
    label_73:
    while (true) {
      if (jj_2_55(2)) {
        ;
      } else {
        break label_73;
      }
      jj_consume_token(DOT);
      jj_consume_token(IDENTIFIER);
                _sName += "." + getToken(0).image;
      if (jj_2_56(2)) {
        TypeArguments();
      } else {
        ;
      }
    }
  }

  final public void ClassOrInterfaceBodyDeclaration(boolean isInterface) throws ParseException {
   //boolean isNestedInterface = false;
   int modifiers;
    if (jj_2_59(2)) {
      Initializer();
     if (isInterface)
        {if (true) throw new ParseException("An interface cannot have initializers");}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case ASSERT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case TESTAAAA:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case IDENTIFIER:
      case AT:
      case LT:
        modifiers = Modifiers();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CLASS:
        case INTERFACE:
          ClassOrInterfaceDeclaration(modifiers);
          break;
        case ENUM:
          EnumDeclaration(modifiers);
          break;
        default:
          jj_la1[187] = jj_gen;
          if (jj_2_57(2147483647)) {
            ConstructorDeclaration();
          } else if (jj_2_58(2147483647)) {
            FieldDeclaration15(modifiers);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ABSTRACT:
            case BOOLEAN:
            case BYTE:
            case CHAR:
            case DOUBLE:
            case FINAL:
            case FLOAT:
            case INT:
            case LONG:
            case NATIVE:
            case PRIVATE:
            case PROTECTED:
            case PUBLIC:
            case SHORT:
            case STATIC:
            case TESTAAAA:
            case SYNCHRONIZED:
            case VOID:
            case IDENTIFIER:
            case AT:
            case LT:
              MethodDeclaration15(modifiers);
              break;
            default:
              jj_la1[188] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[189] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void EnumConstant() throws ParseException {
    Modifiers();
    jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      Arguments();
      break;
    default:
      jj_la1[190] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      ClassOrInterfaceBody(false);
      break;
    default:
      jj_la1[191] = jj_gen;
      ;
    }
  }

  final public void TypeBound() throws ParseException {
    jj_consume_token(EXTENDS);
    ClassOrInterfaceType();
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[192] = jj_gen;
        break label_74;
      }
      jj_consume_token(BIT_AND);
      ClassOrInterfaceType();
    }
  }

  final public void TypeArguments() throws ParseException {
    jj_consume_token(LT);
    TypeArgument();
    label_75:
    while (true) {
      if (jj_2_60(2)) {
        ;
      } else {
        break label_75;
      }
      jj_consume_token(COMMA);
      TypeArgument();
    }
    jj_consume_token(GT);
  }

  final public void TypeArgument() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
      ReferenceType();
      break;
    case HOOK:
      jj_consume_token(HOOK);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTENDS:
      case SUPER:
        WildcardBounds();
        break;
      default:
        jj_la1[193] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[194] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ReferenceType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      label_76:
      while (true) {
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
                                            _sName += "[]";
        if (jj_2_61(2)) {
          ;
        } else {
          break label_76;
        }
      }
      break;
    case IDENTIFIER:
      ClassOrInterfaceType();
      label_77:
      while (true) {
        if (jj_2_62(2)) {
          ;
        } else {
          break label_77;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
                                                       _sName += "[]";
      }
      break;
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void WildcardBounds() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      ReferenceType();
      break;
    case SUPER:
      jj_consume_token(SUPER);
      ReferenceType();
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void FieldDeclaration15(int modifiers) throws ParseException {
    Type();
    VariableDeclarator();
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[197] = jj_gen;
        break label_78;
      }
      jj_consume_token(COMMA);
      VariableDeclarator();
    }
    jj_consume_token(SEMICOLON);
  }

  final public void MethodDeclaration15(int modifiers) throws ParseException {
    MethodDeclaration();
  }

  final public void MethodDeclarator15() throws ParseException {
    jj_consume_token(IDENTIFIER);
    FormalParameters();
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[198] = jj_gen;
        break label_79;
      }
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    }
  }

  final public void FormalParameters15() throws ParseException {
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case TESTAAAA:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case IDENTIFIER:
    case AT:
      FormalParameter15();
      label_80:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[199] = jj_gen;
          break label_80;
        }
        jj_consume_token(COMMA);
        FormalParameter15();
      }
      break;
    default:
      jj_la1[200] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void FormalParameter15() throws ParseException {
    Modifiers();
    Type();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
      break;
    default:
      jj_la1[201] = jj_gen;
      ;
    }
    VariableDeclaratorId();
  }

  final public void MemberSelector() throws ParseException {
    jj_consume_token(DOT);
    TypeArguments();
    jj_consume_token(IDENTIFIER);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    }
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_344()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_314()) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_389()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_315()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_321() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_320()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_321()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_50()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(84)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_23()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_3R_239()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_240()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_3R_162()) return true;
    }
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_123()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_94()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) return true;
    }
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) return true;
    }
    return false;
  }

  private boolean jj_3R_439() {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_386()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(TRY)) return true;
    if (jj_3R_142()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_438()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_439()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_437() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_3R_102()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_436() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_3R_102()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_391() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_263()) return true;
    return false;
  }

  private boolean jj_3R_446() {
    if (jj_3R_451()) return true;
    return false;
  }

  private boolean jj_3R_435() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_364() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) return true;
    }
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_451() {
    if (jj_3R_454()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    }
    return false;
  }

  private boolean jj_3R_445() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_3R_263()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_455()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_95() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_145()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_146()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_147()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_148()) jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    if (jj_3R_105()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_11() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_91()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_92()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) jj_scanpos = xsp;
    if (jj_3R_94()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_453() {
    if (jj_3R_454()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_46() {
    if (jj_3R_84()) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_452() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_450() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) {
    jj_scanpos = xsp;
    if (jj_3R_453()) return true;
    }
    return false;
  }

  private boolean jj_3R_300() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_310()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(ENUM)) return true;
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_3R_450()) return true;
    return false;
  }

  private boolean jj_3R_433() {
    if (jj_3R_84()) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_434() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_445()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3R_446()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_433()) {
    jj_scanpos = xsp;
    if (jj_3R_434()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_84()) return true;
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_8() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_90()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_84()) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_223()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_7() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_88()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_86()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_3R_304()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_223()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_84()) return true;
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_443() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_102()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_448() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_442() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) return true;
    }
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_3R_442()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_443()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_431()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_447() {
    if (jj_3R_106()) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_441() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_3R_447()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_3R_102()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_441()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_318() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_263() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_305() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_317()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_318()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_325() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_3R_84()) return true;
    if (jj_3R_111()) return true;
    if (jj_3R_341()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_415()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_308() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_324()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_325()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_326()) jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    if (jj_3R_327()) return true;
    xsp = jj_scanpos;
    if (jj_3R_328()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_331()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_3R_84()) return true;
    if (jj_3R_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_3R_120()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_287()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_196() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_3R_222()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_382()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_3R_84()) return true;
    if (jj_3R_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(122)) jj_scanpos = xsp;
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_174()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_430() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_117()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_3R_386()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_387()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_386()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_105()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_3R_105()) return true;
    if (jj_3R_327()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_374()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_273()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(CLASS)) return true;
    if (jj_3R_105()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    if (jj_3R_276()) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_3R_265()) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_264()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_421() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_3R_263()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_62() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_255() {
    Token xsp;
    if (jj_3R_275()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_275()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3_42() {
    Token xsp;
    if (jj_3_40()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    return false;
  }

  private boolean jj_3_61() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_3R_111()) return true;
    if (jj_3R_341()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_421()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    }
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_3R_413()) return true;
    return false;
  }

  private boolean jj_3_60() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_62()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_3R_110()) return true;
    Token xsp;
    if (jj_3_61()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_61()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_103() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_206()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_276()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) return true;
    }
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_140()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_60()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_3R_189()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) return true;
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_226()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_58() {
    if (jj_3R_111()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_139()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_110()) return true;
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_405()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_406()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_425() {
    if (jj_3R_308()) return true;
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_3R_411()) return true;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_117()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_277()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_3R_84()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_204()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_407() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_59() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_scan_token(TESTAAAA)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_56() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_227() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) return true;
    }
    return false;
  }

  private boolean jj_3_55() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3_54() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(ENUM)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_53() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3_2() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_82()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_83()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_3R_407()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_scan_token(SEMICOLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_385()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_136()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_53()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_357()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_358()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_422() {
    if (jj_3R_407()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3R_370()) {
    jj_scanpos = xsp;
    if (jj_3R_371()) {
    jj_scanpos = xsp;
    if (jj_3R_372()) {
    jj_scanpos = xsp;
    if (jj_3R_373()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_422()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_114()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_3R_94()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_384()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_3R_114()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_175()) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_428() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_184()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_440()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_332()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_333()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_334()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_335()) jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    if (jj_3R_336()) return true;
    xsp = jj_scanpos;
    if (jj_3R_337()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(SUPER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(85)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_175()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_176()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(THIS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(85)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) return true;
    }
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_3R_100()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_151()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_286()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_377() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_393()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    return false;
  }

  private boolean jj_3_30() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_257() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_102()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_3R_377()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_378()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_14() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_98()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_99()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_3R_188()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3_13() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_97()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_111()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_419() {
    if (jj_3R_428()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_257()) return true;
    return false;
  }

  private boolean jj_3R_418() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_339() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_81()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PACKAGE)) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_411() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_417()) return true;
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_418()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_419()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) jj_scanpos = xsp;
    if (jj_3R_413()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_339()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_340()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_111()) return true;
    if (jj_3R_341()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_342()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_216() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_232() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) return true;
    }
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_84()) return true;
    if (jj_scan_token(ENUM)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_186() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    }
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_3R_84()) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_3R_309()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(TESTAAAA)) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_3R_84()) return true;
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_200() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) return true;
    }
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3R_383() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_3R_400()) {
    jj_scanpos = xsp;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_3R_185()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_186()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3R_343() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    }
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_154()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_155()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) return true;
    }
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_3R_108()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_26()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_3R_312()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_343()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_259()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_301()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_291()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_302()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_288()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_292()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_117()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_52()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_3R_281()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_289()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_3R_416()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_3R_259()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_282()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_105()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_354()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_355()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_3R_235()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_218()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_236()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_205()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_3R_111()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_3R_411()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_102()) return true;
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_102()) return true;
    if (jj_3R_106()) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_3R_111()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_3R_84()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_394()) {
    jj_scanpos = xsp;
    if (jj_3R_395()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) {
    jj_scanpos = xsp;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_345() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) {
    jj_scanpos = xsp;
    if (jj_3R_380()) return true;
    }
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_3R_137()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public JavaParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[202];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x90202000,0x0,0x0,0x0,0x90202000,0x0,0x0,0x80002000,0x80002000,0x200000,0x0,0x0,0x0,0x80002000,0x0,0x0,0x80002000,0x80002000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x9432e000,0x0,0x0,0x80002000,0x80002000,0x0,0x0,0x84128000,0x0,0x80002000,0x80002000,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x80002000,0x80002000,0x0,0x20000000,0x9432a000,0x0,0x8412a000,0x80000000,0x80000000,0x0,0x0,0x0,0x10004000,0x0,0x5412c000,0x5412c000,0x0,0x0,0x80002000,0x80002000,0x0,0x0,0x0,0x0,0x0,0x0,0x8412a000,0x0,0x0,0x0,0x0,0x0,0x0,0xd6b3e000,0x5412c000,0x0,0x4128000,0x4128000,0x0,0x4128000,0x4128000,0x10004000,0x10004000,0x0,0x0,0x0,0x5412c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5412c000,0x0,0x0,0x5412c000,0x40004000,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x40000000,0x0,0x10004000,0x0,0x40000000,0x40000000,0x5412c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5693c000,0x0,0xd6b3e000,0xd6b3e000,0x0,0x0,0x0,0x5412c000,0x1040000,0xd6b3e000,0x1040000,0x8000000,0xd412e000,0x5412c000,0x5412c000,0xd412e000,0x5412c000,0x0,0x4000,0x4000,0x5412c000,0x80000,0x0,0x4000,0x0,0x0,0x0,0x5412c000,0x5412c000,0x0,0x9432a000,0x9432a000,0x1000000,0x14328000,0x9432a000,0x80002000,0x200000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x9432e000,0x80002000,0x0,0x9432e000,0x0,0x20000000,0x10200000,0x8412a000,0x9432e000,0x0,0x0,0x0,0x20000000,0x4128000,0x4128000,0x20000000,0x0,0x0,0x0,0x8412a000,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x40,0x11338a00,0x4040,0x4040,0x40,0x11338a00,0x4000,0x40,0x1220000,0x1220000,0x200,0x0,0x100000,0x0,0x11338800,0x0,0x0,0x1220000,0x1220000,0x0,0x0,0x0,0x0,0x0,0x20,0x913b8f02,0x0,0x0,0x338000,0x338000,0x0,0x0,0x101b8502,0x0,0x1338800,0x1338800,0x0,0x0,0x0,0x0,0x220000,0x220000,0x0,0x0,0x338000,0x338000,0x0,0x0,0x913b8f02,0x0,0x113b8d02,0x10138000,0x10138000,0x0,0x0,0x0,0x0,0x0,0xa2483502,0xa2483502,0x0,0x0,0x1338800,0x1338800,0x0,0x0,0x8000000,0x0,0x0,0x0,0x113b8d02,0x0,0x0,0x38000,0x38000,0x0,0x8000000,0xf7ffbf16,0xa2483502,0x100000,0x80502,0x80502,0x0,0x80502,0x80080502,0x0,0x0,0x0,0x0,0x0,0xa2483502,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa2483502,0x0,0x0,0xa2483502,0x22403000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22002000,0x1000,0x0,0x0,0x20002000,0x20000000,0xa2483502,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0xe7cc3516,0x0,0xf7ffbf16,0xf7ffbf16,0x0,0x0,0x0,0xa2483502,0x0,0xf7ffbf16,0x0,0x0,0xb37bbd02,0xa2483502,0xa2483502,0xb37bbd02,0xa2483502,0x0,0x0,0x0,0xa2483502,0x0,0x1,0x0,0x0,0x0,0x0,0xa2483502,0xa2483502,0x0,0x113b8f02,0x113b8f02,0x0,0x80702,0x113b8f02,0x11338800,0x200,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x913b8f02,0x11338800,0x0,0x913b8f02,0x0,0x0,0x200,0x813b8d02,0x913b8f02,0x0,0x0,0x0,0x400000,0x80502,0x80502,0x400000,0x0,0x0,0x0,0x113b8d02,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x480001,0x400000,0x400000,0x0,0x480001,0x400000,0x0,0x0,0x0,0x0,0x400000,0x0,0x200000,0x480001,0x400000,0x400000,0x0,0x0,0x2000000,0x2000000,0x200000,0x2000000,0x0,0x0,0x2488401,0x400000,0x400000,0x0,0x0,0x400000,0x80000,0x400401,0x400000,0x0,0x0,0x400000,0x2000000,0x400000,0x400000,0x0,0x0,0x400000,0x400000,0x0,0x0,0x2000000,0x0,0x2480401,0x80000,0x400401,0x1,0x1,0x400000,0x100000,0x800000,0x400,0x20000,0xc00a744,0xc00a744,0x100000,0x400000,0x0,0x0,0x400000,0x2000000,0x0,0x88000,0x20000,0x100000,0x400401,0x0,0x400000,0x0,0x0,0x2000000,0x0,0x48a747,0x2744,0x0,0x0,0x400,0x20000,0x0,0x400,0x400,0x400,0x2000000,0x100000,0x2000000,0xc002744,0x800000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x83000000,0x83000000,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0xc002744,0xc000000,0xc000000,0x2744,0xc002744,0x2000,0x0,0x0,0x2000,0x200000,0x400,0x200000,0x400,0x344,0x2000,0x400,0x222000,0x344,0x0,0xc002744,0x100000,0x2000000,0x8000,0x22000,0x0,0x20000,0x20000,0x8a746,0x20000000,0x48a747,0x48a747,0x100000,0x800000,0x800000,0x2744,0x0,0x48a747,0x0,0x0,0x402745,0xc002744,0x2744,0x482745,0x2744,0x100000,0x400,0x400,0xc002744,0x0,0x0,0x400,0x400000,0x400,0x100000,0xc40a744,0xc40a744,0x100000,0x480401,0x480401,0x0,0x400400,0x480401,0x400001,0x0,0x2000000,0x0,0x0,0x0,0x100000,0x100000,0x100000,0x2488401,0x400401,0x100000,0x2488401,0x80000,0x0,0x0,0x2400400,0x2480401,0x2000,0x8000,0x0,0x0,0x10000400,0x400,0x0,0x100000,0x20000,0x100000,0x400401,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0x3ff8000,0x0,0x4,0x8,0x800,0x1000,0x400,0x2,0x2,0x0,0x1,0x1,0x0,0x4000,0xc0,0xc0,0x2300,0x2300,0xc0,0xf0,0x0,0x0,0x0,0x0,0x0,0x30,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x0,0x30,0x30,0x0,0x3ff8030,0x3ff8030,0x30,0x0,0x30,0x0,0x0,0x30,0xf0,0x30,0x30,0x30,0x0,0x0,0x0,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0xf0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[62];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public JavaParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public JavaParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JavaParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public JavaParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new JavaParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public JavaParser(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 202; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[123];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 202; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 123; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 62; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
