macro(VsSpectreMitigation_check tgt spectre_expect)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(HAVE_SpectreMitigation 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<SpectreMitigation>([^<>]+)</SpectreMitigation>")
      set(spectre_actual "${CMAKE_MATCH_1}")
      if(NOT "${spectre_actual}" STREQUAL "${spectre_expect}")
        set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has <SpectreMitigation> '${spectre_actual}', not '${spectre_expect}'.")
        return()
      endif()
      set(HAVE_SpectreMitigation 1)
      break()
    endif()
  endforeach()

  if(NOT HAVE_SpectreMitigation AND NOT "${spectre_expect}" STREQUAL "")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SpectreMitigation> field.")
    return()
  endif()
endmacro()

VsSpectreMitigation_check(SpectreMitigationOn-C "Spectre")
VsSpectreMitigation_check(SpectreMitigationOff-C "false")
