This git repo contains the following scripts that make interfacing with gitlab.com/CentOS and/or gitlab.com/redhat/centos-stream/

Tools:

 * get_sources.sh: when run from inside a package git checkout (from https://gitlab.com/CentOS - so for SIGs), will download the relevant non-text sources from the lookaside cache ([https://src.sigs.centos.org](https://src.sigs.centos.org)) and drop them into the SOURCES/ dir (if it detects rpm-style layout) or in current dir (if it detects flat style layout); note: it will generate 0 byte files in place, rather than download them.

 * get_stream_sources.sh: when run from inside a package git checkout (from https://gitlab.com/redhat/centos-stream/ - so official CentOS Stream git infra), will download the relevant non-text sources from the lookaside cache ([https://sources.stream.centos.org](https://sources.stream.centos.org)) and drop them into the current dir

 * into_srpm.sh:  reconstructs the srpm from a given commit

 * return_disttag.sh:  Extracts what appears to be the value of %{dist} from the commit message. <b>NOTE</b>: Requires the package <b>scl-utils-build</b> to be installed to use.

 * rpm-tree-prep.sh:  A very simple script that prepares a git tree for patching. (runs rpmbuild -bp on the tree)

 * show\_possible\_srpms.sh:  when run from inside a package git checkout, shows the list of possible SRPMs available to be built.

========================

Unless otherwise noted inside the code of an individual script, all scripts in this repository are licensed with the [GPL Version 2.0](http://opensource.org/licenses/GPL-2.0 "GPL Version 2.0") by default.  Community members who initially contribute a script can also choose any [OSI Approved License](http://opensource.org/licenses/alphabetical "Approved OSI Licenses") for their scripts if they would rather have something other than the default.  
