# Manifest

- [1. Property `Manifest > name`](#name)
- [2. Property `Manifest > version`](#version)
- [3. Property `Manifest > target`](#target)
- [4. Property `Manifest > content`](#content)
  - [4.1. Property `Manifest > content > rpms`](#content_rpms)
    - [4.1.1. Manifest > content > rpms > rpms items](#content_rpms_items)
  - [4.2. Property `Manifest > content > enable_repos`](#content_enable_repos)
    - [4.2.1. Manifest > content > enable_repos > enable_repos items](#content_enable_repos_items)
  - [4.3. Property `Manifest > content > repos`](#content_repos)
    - [4.3.1. Manifest > content > repos > repo](#content_repos_items)
      - [4.3.1.1. Property `Manifest > content > repos > repos items > id`](#content_repos_items_id)
      - [4.3.1.2. Property `Manifest > content > repos > repos items > baseurl`](#content_repos_items_baseurl)
      - [4.3.1.3. Property `Manifest > content > repos > repos items > priority`](#content_repos_items_priority)
  - [4.4. Property `Manifest > content > container_images`](#content_container_images)
    - [4.4.1. Manifest > content > container_images > container_image](#content_container_images_items)
      - [4.4.1.1. Property `Manifest > content > container_images > container_images items > source`](#content_container_images_items_source)
      - [4.4.1.2. Property `Manifest > content > container_images > container_images items > tag`](#content_container_images_items_tag)
      - [4.4.1.3. Property `Manifest > content > container_images > container_images items > digest`](#content_container_images_items_digest)
      - [4.4.1.4. Property `Manifest > content > container_images > container_images items > name`](#content_container_images_items_name)
      - [4.4.1.5. Property `Manifest > content > container_images > container_images items > containers-transport`](#content_container_images_items_containers-transport)
      - [4.4.1.6. Property `Manifest > content > container_images > container_images items > index`](#content_container_images_items_index)
  - [4.5. Property `Manifest > content > add_files`](#content_add_files)
    - [4.5.1. Manifest > content > add_files > add_file](#content_add_files_items)
      - [4.5.1.1. Property `Manifest > content > add_files > add_files items > oneOf > item 0`](#content_add_files_items_oneOf_i0)
        - [4.5.1.1.1. Property `Manifest > content > add_files > add_files items > oneOf > item 0 > path`](#content_add_files_items_oneOf_i0_path)
        - [4.5.1.1.2. Property `Manifest > content > add_files > add_files items > oneOf > item 0 > source_path`](#content_add_files_items_oneOf_i0_source_path)
      - [4.5.1.2. Property `Manifest > content > add_files > add_files items > oneOf > item 1`](#content_add_files_items_oneOf_i1)
        - [4.5.1.2.1. Property `Manifest > content > add_files > add_files items > oneOf > item 1 > path`](#content_add_files_items_oneOf_i1_path)
        - [4.5.1.2.2. Property `Manifest > content > add_files > add_files items > oneOf > item 1 > url`](#content_add_files_items_oneOf_i1_url)
      - [4.5.1.3. Property `Manifest > content > add_files > add_files items > oneOf > item 2`](#content_add_files_items_oneOf_i2)
        - [4.5.1.3.1. Property `Manifest > content > add_files > add_files items > oneOf > item 2 > path`](#content_add_files_items_oneOf_i2_path)
        - [4.5.1.3.2. Property `Manifest > content > add_files > add_files items > oneOf > item 2 > text`](#content_add_files_items_oneOf_i2_text)
      - [4.5.1.4. Property `Manifest > content > add_files > add_files items > oneOf > item 3`](#content_add_files_items_oneOf_i3)
        - [4.5.1.4.1. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > path`](#content_add_files_items_oneOf_i3_path)
        - [4.5.1.4.2. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > source_glob`](#content_add_files_items_oneOf_i3_source_glob)
        - [4.5.1.4.3. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > preserve_path`](#content_add_files_items_oneOf_i3_preserve_path)
        - [4.5.1.4.4. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > max_files`](#content_add_files_items_oneOf_i3_max_files)
        - [4.5.1.4.5. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > allow_empty`](#content_add_files_items_oneOf_i3_allow_empty)
  - [4.6. Property `Manifest > content > chmod_files`](#content_chmod_files)
    - [4.6.1. Manifest > content > chmod_files > chmod_file](#content_chmod_files_items)
      - [4.6.1.1. Property `Manifest > content > chmod_files > chmod_files items > path`](#content_chmod_files_items_path)
      - [4.6.1.2. Property `Manifest > content > chmod_files > chmod_files items > mode`](#content_chmod_files_items_mode)
      - [4.6.1.3. Property `Manifest > content > chmod_files > chmod_files items > recursive`](#content_chmod_files_items_recursive)
  - [4.7. Property `Manifest > content > chown_files`](#content_chown_files)
    - [4.7.1. Manifest > content > chown_files > chown_file](#content_chown_files_items)
      - [4.7.1.1. Property `Manifest > content > chown_files > chown_files items > anyOf > item 0`](#content_chown_files_items_anyOf_i0)
        - [4.7.1.1.1. The following properties are required](#autogenerated_heading_2)
      - [4.7.1.2. Property `Manifest > content > chown_files > chown_files items > anyOf > item 1`](#content_chown_files_items_anyOf_i1)
        - [4.7.1.2.1. The following properties are required](#autogenerated_heading_3)
      - [4.7.1.3. Property `Manifest > content > chown_files > chown_files items > path`](#content_chown_files_items_path)
      - [4.7.1.4. Property `Manifest > content > chown_files > chown_files items > user`](#content_chown_files_items_user)
        - [4.7.1.4.1. Property `Manifest > content > chown_files > chown_files items > user > oneOf > item 0`](#content_chown_files_items_user_oneOf_i0)
        - [4.7.1.4.2. Property `Manifest > content > chown_files > chown_files items > user > oneOf > item 1`](#content_chown_files_items_user_oneOf_i1)
      - [4.7.1.5. Property `Manifest > content > chown_files > chown_files items > group`](#content_chown_files_items_group)
        - [4.7.1.5.1. Property `Manifest > content > chown_files > chown_files items > group > oneOf > item 0`](#content_chown_files_items_group_oneOf_i0)
        - [4.7.1.5.2. Property `Manifest > content > chown_files > chown_files items > group > oneOf > item 1`](#content_chown_files_items_group_oneOf_i1)
      - [4.7.1.6. Property `Manifest > content > chown_files > chown_files items > recursive`](#content_chown_files_items_recursive)
  - [4.8. Property `Manifest > content > remove_files`](#content_remove_files)
    - [4.8.1. Manifest > content > remove_files > remove_file](#content_remove_files_items)
      - [4.8.1.1. Property `Manifest > content > remove_files > remove_files items > path`](#content_remove_files_items_path)
  - [4.9. Property `Manifest > content > make_dirs`](#content_make_dirs)
    - [4.9.1. Manifest > content > make_dirs > make_dir](#content_make_dirs_items)
      - [4.9.1.1. Property `Manifest > content > make_dirs > make_dirs items > path`](#content_make_dirs_items_path)
      - [4.9.1.2. Property `Manifest > content > make_dirs > make_dirs items > mode`](#content_make_dirs_items_mode)
      - [4.9.1.3. Property `Manifest > content > make_dirs > make_dirs items > parents`](#content_make_dirs_items_parents)
      - [4.9.1.4. Property `Manifest > content > make_dirs > make_dirs items > exist_ok`](#content_make_dirs_items_exist_ok)
  - [4.10. Property `Manifest > content > add_symlinks`](#content_add_symlinks)
    - [4.10.1. Manifest > content > add_symlinks > symlink_file](#content_add_symlinks_items)
      - [4.10.1.1. Property `Manifest > content > add_symlinks > add_symlinks items > link`](#content_add_symlinks_items_link)
      - [4.10.1.2. Property `Manifest > content > add_symlinks > add_symlinks items > target`](#content_add_symlinks_items_target)
  - [4.11. Property `Manifest > content > systemd`](#content_systemd)
    - [4.11.1. Property `Manifest > content > systemd > enabled_services`](#content_systemd_enabled_services)
      - [4.11.1.1. Manifest > content > systemd > enabled_services > enabled_services items](#content_systemd_enabled_services_items)
    - [4.11.2. Property `Manifest > content > systemd > disabled_services`](#content_systemd_disabled_services)
      - [4.11.2.1. Manifest > content > systemd > disabled_services > disabled_services items](#content_systemd_disabled_services_items)
    - [4.11.3. Property `Manifest > content > systemd > masked_services`](#content_systemd_masked_services)
      - [4.11.3.1. Manifest > content > systemd > masked_services > masked_services items](#content_systemd_masked_services_items)
  - [4.12. Property `Manifest > content > sbom`](#content_sbom)
    - [4.12.1. Property `Manifest > content > sbom > doc_path`](#content_sbom_doc_path)
- [5. Property `Manifest > qm`](#qm)
  - [5.1. Property `Manifest > qm > content`](#qm_content)
  - [5.2. Property `Manifest > qm > memory_limit`](#qm_memory_limit)
    - [5.2.1. Property `Manifest > qm > memory_limit > max`](#qm_memory_limit_max)
    - [5.2.2. Property `Manifest > qm > memory_limit > high`](#qm_memory_limit_high)
  - [5.3. Property `Manifest > qm > cpu_weight`](#qm_cpu_weight)
    - [5.3.1. Property `Manifest > qm > cpu_weight > oneOf > item 0`](#qm_cpu_weight_oneOf_i0)
    - [5.3.2. Property `Manifest > qm > cpu_weight > oneOf > item 1`](#qm_cpu_weight_oneOf_i1)
  - [5.4. Property `Manifest > qm > container_checksum`](#qm_container_checksum)
- [6. Property `Manifest > network`](#network)
  - [6.1. Property `Manifest > network > static`](#network_static)
    - [6.1.1. Property `Manifest > network > static > ip`](#network_static_ip)
    - [6.1.2. Property `Manifest > network > static > ip_prefixlen`](#network_static_ip_prefixlen)
    - [6.1.3. Property `Manifest > network > static > gateway`](#network_static_gateway)
    - [6.1.4. Property `Manifest > network > static > dns`](#network_static_dns)
    - [6.1.5. Property `Manifest > network > static > iface`](#network_static_iface)
    - [6.1.6. Property `Manifest > network > static > load_module`](#network_static_load_module)
  - [6.2. Property `Manifest > network > dynamic`](#network_dynamic)
- [7. Property `Manifest > image`](#image)
  - [7.1. Property `Manifest > image > image_size`](#image_image_size)
  - [7.2. Property `Manifest > image > sealed`](#image_sealed)
  - [7.3. Property `Manifest > image > selinux_mode`](#image_selinux_mode)
  - [7.4. Property `Manifest > image > selinux_policy`](#image_selinux_policy)
  - [7.5. Property `Manifest > image > selinux_booleans`](#image_selinux_booleans)
    - [7.5.1. Property `Manifest > image > selinux_booleans > additionalProperties`](#image_selinux_booleans_additionalProperties)
  - [7.6. Property `Manifest > image > partitions`](#image_partitions)
    - [7.6.1. Pattern Property `Manifest > image > partitions > root`](#image_partitions_pattern1)
      - [7.6.1.1. Property `Manifest > image > partitions > root > grow`](#image_partitions_pattern1_grow)
    - [7.6.2. Pattern Property `Manifest > image > partitions > (aboot\|ukiboot\|boot\|efi\|vbmeta\|sbl)`](#image_partitions_pattern2)
      - [7.6.2.1. Property `Manifest > image > partitions > (aboot\|ukiboot\|boot\|efi\|vbmeta\|sbl) > size`](#image_partitions_pattern2_size)
    - [7.6.3. Pattern Property `Manifest > image > partitions > var`](#image_partitions_pattern3)
      - [7.6.3.1. Property `Manifest > image > partitions > var > relative_size`](#image_partitions_pattern3_relative_size)
      - [7.6.3.2. Property `Manifest > image > partitions > var > size`](#image_partitions_pattern3_size)
      - [7.6.3.3. Property `Manifest > image > partitions > var > external`](#image_partitions_pattern3_external)
      - [7.6.3.4. Property `Manifest > image > partitions > var > uuid`](#image_partitions_pattern3_uuid)
    - [7.6.4. Pattern Property `Manifest > image > partitions > var_qm`](#image_partitions_pattern4)
      - [7.6.4.1. Property `Manifest > image > partitions > var_qm > relative_size`](#image_partitions_pattern4_relative_size)
      - [7.6.4.2. Property `Manifest > image > partitions > var_qm > size`](#image_partitions_pattern4_size)
      - [7.6.4.3. Property `Manifest > image > partitions > var_qm > external`](#image_partitions_pattern4_external)
      - [7.6.4.4. Property `Manifest > image > partitions > var_qm > uuid`](#image_partitions_pattern4_uuid)
  - [7.7. Property `Manifest > image > hostname`](#image_hostname)
  - [7.8. Property `Manifest > image > ostree_ref`](#image_ostree_ref)
- [8. Property `Manifest > auth`](#auth)
  - [8.1. Property `Manifest > auth > root_password`](#auth_root_password)
  - [8.2. Property `Manifest > auth > root_ssh_keys`](#auth_root_ssh_keys)
  - [8.3. Property `Manifest > auth > sshd_config`](#auth_sshd_config)
    - [8.3.1. Property `Manifest > auth > sshd_config > PasswordAuthentication`](#auth_sshd_config_PasswordAuthentication)
    - [8.3.2. Property `Manifest > auth > sshd_config > PermitRootLogin`](#auth_sshd_config_PermitRootLogin)
      - [8.3.2.1. Property `Manifest > auth > sshd_config > PermitRootLogin > oneOf > item 0`](#auth_sshd_config_PermitRootLogin_oneOf_i0)
      - [8.3.2.2. Property `Manifest > auth > sshd_config > PermitRootLogin > oneOf > item 1`](#auth_sshd_config_PermitRootLogin_oneOf_i1)
  - [8.4. Property `Manifest > auth > users`](#auth_users)
    - [8.4.1. Pattern Property `Manifest > auth > users > add_user`](#auth_users_pattern1)
      - [8.4.1.1. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > gid`](#auth_users_pattern1_gid)
      - [8.4.1.2. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > uid`](#auth_users_pattern1_uid)
      - [8.4.1.3. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > groups`](#auth_users_pattern1_groups)
        - [8.4.1.3.1. Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > groups > groups items](#auth_users_pattern1_groups_items)
      - [8.4.1.4. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > description`](#auth_users_pattern1_description)
      - [8.4.1.5. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > home`](#auth_users_pattern1_home)
      - [8.4.1.6. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > shell`](#auth_users_pattern1_shell)
      - [8.4.1.7. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > password`](#auth_users_pattern1_password)
      - [8.4.1.8. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > key`](#auth_users_pattern1_key)
      - [8.4.1.9. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > keys`](#auth_users_pattern1_keys)
        - [8.4.1.9.1. Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > keys > keys items](#auth_users_pattern1_keys_items)
      - [8.4.1.10. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > expiredate`](#auth_users_pattern1_expiredate)
      - [8.4.1.11. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > force_password_reset`](#auth_users_pattern1_force_password_reset)
  - [8.5. Property `Manifest > auth > groups`](#auth_groups)
    - [8.5.1. Pattern Property `Manifest > auth > groups > add_group`](#auth_groups_pattern1)
      - [8.5.1.1. Property `Manifest > auth > groups > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > gid`](#auth_groups_pattern1_gid)
- [9. Property `Manifest > kernel`](#kernel)
  - [9.1. Property `Manifest > kernel > debug_logging`](#kernel_debug_logging)
  - [9.2. Property `Manifest > kernel > cmdline`](#kernel_cmdline)
  - [9.3. Property `Manifest > kernel > kernel_package`](#kernel_kernel_package)
  - [9.4. Property `Manifest > kernel > kernel_version`](#kernel_kernel_version)
  - [9.5. Property `Manifest > kernel > loglevel`](#kernel_loglevel)
  - [9.6. Property `Manifest > kernel > remove_modules`](#kernel_remove_modules)
- [10. Property `Manifest > experimental`](#experimental)
  - [10.1. Property `Manifest > experimental > internal_defines`](#experimental_internal_defines)

**Title:** Manifest

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** The automotive-image-builder format describes how to build an OS image, with options like what content (files, packages, containers) to install as well as detailed configuration options.

| Property                         | Pattern | Type   | Deprecated | Definition              | Title/Description                                                                                                                                     |
| -------------------------------- | ------- | ------ | ---------- | ----------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------- |
| + [name](#name )                 | No      | string | No         | -                       | The name of the manifest                                                                                                                              |
| - [version](#version )           | No      | string | No         | -                       | The version of the manifest. If set, this is used as the "os version" in the ostree commit and will be available as IMAGE_VERSION in /etc/build-info. |
| - [target](#target )             | No      | string | No         | -                       | The (default) hardware target to build for                                                                                                            |
| - [content](#content )           | No      | object | No         | In #/$defs/partition    | The content to add to the rootfs, such as packages, files and container images, and systemd services.                                                 |
| - [qm](#qm )                     | No      | object | No         | In #/$defs/qm           | If this section is included then a separate QM partion will be created in the image with the defined content.                                         |
| - [network](#network )           | No      | object | No         | In #/$defs/network      | Define the Network setup, which can be of two types, \`dynamic\` or \`static\`, the default is dynamic                                                |
| - [image](#image )               | No      | object | No         | In #/$defs/image        | Configure global options for the image.                                                                                                               |
| - [auth](#auth )                 | No      | object | No         | In #/$defs/auth         | Configuration related to users, group and authentications.                                                                                            |
| - [kernel](#kernel )             | No      | object | No         | In #/$defs/kernel       | Kernel options                                                                                                                                        |
| - [experimental](#experimental ) | No      | object | No         | In #/$defs/experimental | Experimental options. Unsupported, may change over time without warning.                                                                              |

## <a name="name"></a>1. Property `Manifest > name`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The name of the manifest

## <a name="version"></a>2. Property `Manifest > version`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The version of the manifest. If set, this is used as the "os version" in the ostree commit and will be available as IMAGE_VERSION in /etc/build-info.

## <a name="target"></a>3. Property `Manifest > target`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The (default) hardware target to build for

## <a name="content"></a>4. Property `Manifest > content`

|                           |                   |
| ------------------------- | ----------------- |
| **Type**                  | `object`          |
| **Required**              | No                |
| **Additional properties** | Not allowed       |
| **Defined in**            | #/$defs/partition |

**Description:** The content to add to the rootfs, such as packages, files and container images, and systemd services.

| Property                                         | Pattern | Type                      | Deprecated | Definition | Title/Description                                                                                                                                                                                                                                                                                                 |
| ------------------------------------------------ | ------- | ------------------------- | ---------- | ---------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| - [rpms](#content_rpms )                         | No      | array of string           | No         | -          | A list of rpms to install. The packages will be installed from the default repositores, but can be extended with the enable_repos and repos options.<br /><br />The package names can optionally contain version, but otherwise the repo priorities and available versions will be used to chose a version.<br /> |
| - [enable_repos](#content_enable_repos )         | No      | array of enum (of string) | No         | -          | Enable named predefined default repos which are not on by default.                                                                                                                                                                                                                                                |
| - [repos](#content_repos )                       | No      | array                     | No         | -          | A list of additional dnf repositories to use when installing packages                                                                                                                                                                                                                                             |
| - [container_images](#content_container_images ) | No      | array                     | No         | -          | A list of container images to embedd into the image                                                                                                                                                                                                                                                               |
| - [add_files](#content_add_files )               | No      | array                     | No         | -          | Add regular files (inline or from local file / url) to the image                                                                                                                                                                                                                                                  |
| - [chmod_files](#content_chmod_files )           | No      | array                     | No         | -          | -                                                                                                                                                                                                                                                                                                                 |
| - [chown_files](#content_chown_files )           | No      | array                     | No         | -          | -                                                                                                                                                                                                                                                                                                                 |
| - [remove_files](#content_remove_files )         | No      | array                     | No         | -          | -                                                                                                                                                                                                                                                                                                                 |
| - [make_dirs](#content_make_dirs )               | No      | array                     | No         | -          | -                                                                                                                                                                                                                                                                                                                 |
| - [add_symlinks](#content_add_symlinks )         | No      | array                     | No         | -          | Create symbolic links in the image                                                                                                                                                                                                                                                                                |
| - [systemd](#content_systemd )                   | No      | object                    | No         | -          | Configure what systemd services are to be running other than the default ones.                                                                                                                                                                                                                                    |
| - [sbom](#content_sbom )                         | No      | object                    | No         | -          | Generate a Software Bill of Materials (SBOM) document in SPDX v2 format for the installed RPM packages.                                                                                                                                                                                                           |

### <a name="content_rpms"></a>4.1. Property `Manifest > content > rpms`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** A list of rpms to install. The packages will be installed from the default repositores, but can be extended with the enable_repos and repos options.

The package names can optionally contain version, but otherwise the repo priorities and available versions will be used to chose a version.

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be   | Description |
| --------------------------------- | ----------- |
| [rpms items](#content_rpms_items) | -           |

#### <a name="content_rpms_items"></a>4.1.1. Manifest > content > rpms > rpms items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

### <a name="content_enable_repos"></a>4.2. Property `Manifest > content > enable_repos`

|              |                             |
| ------------ | --------------------------- |
| **Type**     | `array of enum (of string)` |
| **Required** | No                          |

**Description:** Enable named predefined default repos which are not on by default.

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                   | Description |
| ------------------------------------------------- | ----------- |
| [enable_repos items](#content_enable_repos_items) | -           |

#### <a name="content_enable_repos_items"></a>4.2.1. Manifest > content > enable_repos > enable_repos items

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |

Must be one of:
* "debug"
* "devel"

### <a name="content_repos"></a>4.3. Property `Manifest > content > repos`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** A list of additional dnf repositories to use when installing packages

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be | Description                           |
| ------------------------------- | ------------------------------------- |
| [repo](#content_repos_items)    | A dnf repository to install rpms from |

#### <a name="content_repos_items"></a>4.3.1. Manifest > content > repos > repo

|                           |              |
| ------------------------- | ------------ |
| **Type**                  | `object`     |
| **Required**              | No           |
| **Additional properties** | Not allowed  |
| **Defined in**            | #/$defs/repo |

**Description:** A dnf repository to install rpms from

| Property                                     | Pattern | Type    | Deprecated | Definition | Title/Description                                                                                                                                                                                                                                                                                        |
| -------------------------------------------- | ------- | ------- | ---------- | ---------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| + [id](#content_repos_items_id )             | No      | string  | No         | -          | The id to use for this repo in the configuration                                                                                                                                                                                                                                                         |
| + [baseurl](#content_repos_items_baseurl )   | No      | string  | No         | -          | The url to the repo, or a pathname to a local repository                                                                                                                                                                                                                                                 |
| - [priority](#content_repos_items_priority ) | No      | integer | No         | -          | The priority of the repo, defaults to 99 if not specified. If there is more than one candidate package for a particular operation, the one from a repo with the lowest priority value is picked, possibly despite being less convenient otherwise (e.g. by being a lower version) (source: man dnf.conf) |

##### <a name="content_repos_items_id"></a>4.3.1.1. Property `Manifest > content > repos > repos items > id`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The id to use for this repo in the configuration

##### <a name="content_repos_items_baseurl"></a>4.3.1.2. Property `Manifest > content > repos > repos items > baseurl`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The url to the repo, or a pathname to a local repository

##### <a name="content_repos_items_priority"></a>4.3.1.3. Property `Manifest > content > repos > repos items > priority`

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |

**Description:** The priority of the repo, defaults to 99 if not specified. If there is more than one candidate package for a particular operation, the one from a repo with the lowest priority value is picked, possibly despite being less convenient otherwise (e.g. by being a lower version) (source: man dnf.conf)

### <a name="content_container_images"></a>4.4. Property `Manifest > content > container_images`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** A list of container images to embedd into the image

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                    | Description                            |
| -------------------------------------------------- | -------------------------------------- |
| [container_image](#content_container_images_items) | A container image reference to install |

#### <a name="content_container_images_items"></a>4.4.1. Manifest > content > container_images > container_image

|                           |                         |
| ------------------------- | ----------------------- |
| **Type**                  | `object`                |
| **Required**              | No                      |
| **Additional properties** | Not allowed             |
| **Defined in**            | #/$defs/container_image |

**Description:** A container image reference to install

| Property                                                                        | Pattern | Type             | Deprecated | Definition | Title/Description                                                                  |
| ------------------------------------------------------------------------------- | ------- | ---------------- | ---------- | ---------- | ---------------------------------------------------------------------------------- |
| + [source](#content_container_images_items_source )                             | No      | string           | No         | -          | The container image name, for example \`quay.io/fedora/fedora\`.                   |
| - [tag](#content_container_images_items_tag )                                   | No      | string           | No         | -          | The tag to use in the repository                                                   |
| - [digest](#content_container_images_items_digest )                             | No      | string           | No         | -          | Use a specific version of the image specified by digest                            |
| - [name](#content_container_images_items_name )                                 | No      | string           | No         | -          | The name to use for the container image when embedded (if not set, same as source) |
| - [containers-transport](#content_container_images_items_containers-transport ) | No      | enum (of string) | No         | -          | The containers transport from which to copy the container.                         |
| - [index](#content_container_images_items_index )                               | No      | boolean          | No         | -          | If set to true, also install the related manifest-list for the image.              |

##### <a name="content_container_images_items_source"></a>4.4.1.1. Property `Manifest > content > container_images > container_images items > source`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The container image name, for example `quay.io/fedora/fedora`.

##### <a name="content_container_images_items_tag"></a>4.4.1.2. Property `Manifest > content > container_images > container_images items > tag`

|              |            |
| ------------ | ---------- |
| **Type**     | `string`   |
| **Required** | No         |
| **Default**  | `"latest"` |

**Description:** The tag to use in the repository

##### <a name="content_container_images_items_digest"></a>4.4.1.3. Property `Manifest > content > container_images > container_images items > digest`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Use a specific version of the image specified by digest

##### <a name="content_container_images_items_name"></a>4.4.1.4. Property `Manifest > content > container_images > container_images items > name`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The name to use for the container image when embedded (if not set, same as source)

##### <a name="content_container_images_items_containers-transport"></a>4.4.1.5. Property `Manifest > content > container_images > container_images items > containers-transport`

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |

**Description:** The containers transport from which to copy the container.

Must be one of:
* "docker"
* "containers-storage"

##### <a name="content_container_images_items_index"></a>4.4.1.6. Property `Manifest > content > container_images > container_images items > index`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** If set to true, also install the related manifest-list for the image.

### <a name="content_add_files"></a>4.5. Property `Manifest > content > add_files`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** Add regular files (inline or from local file / url) to the image

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be      | Description |
| ------------------------------------ | ----------- |
| [add_file](#content_add_files_items) | -           |

#### <a name="content_add_files_items"></a>4.5.1. Manifest > content > add_files > add_file

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `combining`      |
| **Required**              | No               |
| **Additional properties** | Any type allowed |
| **Defined in**            | #/$defs/add_file |

| One of(Option)                              |
| ------------------------------------------- |
| [item 0](#content_add_files_items_oneOf_i0) |
| [item 1](#content_add_files_items_oneOf_i1) |
| [item 2](#content_add_files_items_oneOf_i2) |
| [item 3](#content_add_files_items_oneOf_i3) |

##### <a name="content_add_files_items_oneOf_i0"></a>4.5.1.1. Property `Manifest > content > add_files > add_files items > oneOf > item 0`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Add local file

| Property                                                        | Pattern | Type   | Deprecated | Definition          | Title/Description                                                    |
| --------------------------------------------------------------- | ------- | ------ | ---------- | ------------------- | -------------------------------------------------------------------- |
| + [path](#content_add_files_items_oneOf_i0_path )               | No      | string | No         | In #/$defs/abs_path | The absolute destination pathname of the added file.                 |
| + [source_path](#content_add_files_items_oneOf_i0_source_path ) | No      | string | No         | In #/$defs/path     | The local (absolute or relative to manifest) path of the file to add |

###### <a name="content_add_files_items_oneOf_i0_path"></a>4.5.1.1.1. Property `Manifest > content > add_files > add_files items > oneOf > item 0 > path`

|                |                  |
| -------------- | ---------------- |
| **Type**       | `string`         |
| **Required**   | Yes              |
| **Defined in** | #/$defs/abs_path |

**Description:** The absolute destination pathname of the added file.

| Restrictions                      |                                                                                                                                                       |
| --------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^\/?(?!\.\.)((?!\/\.\.\/).)+$``` [Test](https://regex101.com/?regex=%5E%5C%2F%3F%28%3F%21%5C.%5C.%29%28%28%3F%21%5C%2F%5C.%5C.%5C%2F%29.%29%2B%24) |

###### <a name="content_add_files_items_oneOf_i0_source_path"></a>4.5.1.1.2. Property `Manifest > content > add_files > add_files items > oneOf > item 0 > source_path`

|                |              |
| -------------- | ------------ |
| **Type**       | `string`     |
| **Required**   | Yes          |
| **Defined in** | #/$defs/path |

**Description:** The local (absolute or relative to manifest) path of the file to add

##### <a name="content_add_files_items_oneOf_i1"></a>4.5.1.2. Property `Manifest > content > add_files > add_files items > oneOf > item 1`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Add file from a http url

| Property                                          | Pattern | Type   | Deprecated | Definition                                              | Title/Description                                    |
| ------------------------------------------------- | ------- | ------ | ---------- | ------------------------------------------------------- | ---------------------------------------------------- |
| + [path](#content_add_files_items_oneOf_i1_path ) | No      | string | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute destination pathname of the added file. |
| + [url](#content_add_files_items_oneOf_i1_url )   | No      | string | No         | -                                                       | The url of the file to add                           |

###### <a name="content_add_files_items_oneOf_i1_path"></a>4.5.1.2.1. Property `Manifest > content > add_files > add_files items > oneOf > item 1 > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute destination pathname of the added file.

###### <a name="content_add_files_items_oneOf_i1_url"></a>4.5.1.2.2. Property `Manifest > content > add_files > add_files items > oneOf > item 1 > url`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The url of the file to add

##### <a name="content_add_files_items_oneOf_i2"></a>4.5.1.3. Property `Manifest > content > add_files > add_files items > oneOf > item 2`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Create file from inline data

| Property                                          | Pattern | Type   | Deprecated | Definition                                              | Title/Description                                    |
| ------------------------------------------------- | ------- | ------ | ---------- | ------------------------------------------------------- | ---------------------------------------------------- |
| + [path](#content_add_files_items_oneOf_i2_path ) | No      | string | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute destination pathname of the added file. |
| + [text](#content_add_files_items_oneOf_i2_text ) | No      | string | No         | -                                                       | Embedded text content to use for the added file      |

###### <a name="content_add_files_items_oneOf_i2_path"></a>4.5.1.3.1. Property `Manifest > content > add_files > add_files items > oneOf > item 2 > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute destination pathname of the added file.

###### <a name="content_add_files_items_oneOf_i2_text"></a>4.5.1.3.2. Property `Manifest > content > add_files > add_files items > oneOf > item 2 > text`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** Embedded text content to use for the added file

##### <a name="content_add_files_items_oneOf_i3"></a>4.5.1.4. Property `Manifest > content > add_files > add_files items > oneOf > item 3`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Add files using glob pattern

| Property                                                            | Pattern | Type    | Deprecated | Definition                                              | Title/Description                                                                            |
| ------------------------------------------------------------------- | ------- | ------- | ---------- | ------------------------------------------------------- | -------------------------------------------------------------------------------------------- |
| + [path](#content_add_files_items_oneOf_i3_path )                   | No      | string  | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute destination pathname of the added file.                                         |
| + [source_glob](#content_add_files_items_oneOf_i3_source_glob )     | No      | string  | No         | -                                                       | The glob pattern (absolute or relative to manifest) to match files for copying               |
| - [preserve_path](#content_add_files_items_oneOf_i3_preserve_path ) | No      | boolean | No         | -                                                       | If true, preserve the directory structure of matched files. If false, flatten files to path. |
| - [max_files](#content_add_files_items_oneOf_i3_max_files )         | No      | integer | No         | -                                                       | Maximum number of files to process from glob pattern. Raises TooManyFilesError if exceeded.  |
| - [allow_empty](#content_add_files_items_oneOf_i3_allow_empty )     | No      | boolean | No         | -                                                       | If true, allow glob patterns with no matches. Useful for creating drop-in directories.       |

###### <a name="content_add_files_items_oneOf_i3_path"></a>4.5.1.4.1. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute destination pathname of the added file.

###### <a name="content_add_files_items_oneOf_i3_source_glob"></a>4.5.1.4.2. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > source_glob`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The glob pattern (absolute or relative to manifest) to match files for copying

###### <a name="content_add_files_items_oneOf_i3_preserve_path"></a>4.5.1.4.3. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > preserve_path`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

**Description:** If true, preserve the directory structure of matched files. If false, flatten files to path.

###### <a name="content_add_files_items_oneOf_i3_max_files"></a>4.5.1.4.4. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > max_files`

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |
| **Default**  | `1000`    |

**Description:** Maximum number of files to process from glob pattern. Raises TooManyFilesError if exceeded.

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 1 |

###### <a name="content_add_files_items_oneOf_i3_allow_empty"></a>4.5.1.4.5. Property `Manifest > content > add_files > add_files items > oneOf > item 3 > allow_empty`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

**Description:** If true, allow glob patterns with no matches. Useful for creating drop-in directories.

### <a name="content_chmod_files"></a>4.6. Property `Manifest > content > chmod_files`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be          | Description             |
| ---------------------------------------- | ----------------------- |
| [chmod_file](#content_chmod_files_items) | Change file permissions |

#### <a name="content_chmod_files_items"></a>4.6.1. Manifest > content > chmod_files > chmod_file

|                           |                    |
| ------------------------- | ------------------ |
| **Type**                  | `object`           |
| **Required**              | No                 |
| **Additional properties** | Not allowed        |
| **Defined in**            | #/$defs/chmod_file |

**Description:** Change file permissions

| Property                                             | Pattern | Type    | Deprecated | Definition                                              | Title/Description                           |
| ---------------------------------------------------- | ------- | ------- | ---------- | ------------------------------------------------------- | ------------------------------------------- |
| + [path](#content_chmod_files_items_path )           | No      | string  | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute pathname of the file to change |
| + [mode](#content_chmod_files_items_mode )           | No      | string  | No         | -                                                       | Symbolic or numeric octal mode              |
| - [recursive](#content_chmod_files_items_recursive ) | No      | boolean | No         | -                                                       | -                                           |

##### <a name="content_chmod_files_items_path"></a>4.6.1.1. Property `Manifest > content > chmod_files > chmod_files items > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute pathname of the file to change

##### <a name="content_chmod_files_items_mode"></a>4.6.1.2. Property `Manifest > content > chmod_files > chmod_files items > mode`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** Symbolic or numeric octal mode

##### <a name="content_chmod_files_items_recursive"></a>4.6.1.3. Property `Manifest > content > chmod_files > chmod_files items > recursive`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

### <a name="content_chown_files"></a>4.7. Property `Manifest > content > chown_files`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be          | Description                                  |
| ---------------------------------------- | -------------------------------------------- |
| [chown_file](#content_chown_files_items) | Change owner and/or group of installed files |

#### <a name="content_chown_files_items"></a>4.7.1. Manifest > content > chown_files > chown_file

|                           |                    |
| ------------------------- | ------------------ |
| **Type**                  | `combining`        |
| **Required**              | No                 |
| **Additional properties** | Not allowed        |
| **Defined in**            | #/$defs/chown_file |

**Description:** Change owner and/or group of installed files

| Property                                             | Pattern | Type    | Deprecated | Definition                                              | Title/Description                           |
| ---------------------------------------------------- | ------- | ------- | ---------- | ------------------------------------------------------- | ------------------------------------------- |
| - [path](#content_chown_files_items_path )           | No      | string  | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute pathname of the file to change |
| - [user](#content_chown_files_items_user )           | No      | object  | No         | In #/$defs/user                                         | User name or id                             |
| - [group](#content_chown_files_items_group )         | No      | object  | No         | In #/$defs/group                                        | Group name or id                            |
| - [recursive](#content_chown_files_items_recursive ) | No      | boolean | No         | -                                                       | Change ownership recursively                |

| Any of(Option)                                |
| --------------------------------------------- |
| [item 0](#content_chown_files_items_anyOf_i0) |
| [item 1](#content_chown_files_items_anyOf_i1) |

##### <a name="content_chown_files_items_anyOf_i0"></a>4.7.1.1. Property `Manifest > content > chown_files > chown_files items > anyOf > item 0`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

###### <a name="autogenerated_heading_2"></a>4.7.1.1.1. The following properties are required
* path
* user

##### <a name="content_chown_files_items_anyOf_i1"></a>4.7.1.2. Property `Manifest > content > chown_files > chown_files items > anyOf > item 1`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

###### <a name="autogenerated_heading_3"></a>4.7.1.2.1. The following properties are required
* path
* group

##### <a name="content_chown_files_items_path"></a>4.7.1.3. Property `Manifest > content > chown_files > chown_files items > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | No                                             |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute pathname of the file to change

##### <a name="content_chown_files_items_user"></a>4.7.1.4. Property `Manifest > content > chown_files > chown_files items > user`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `combining`      |
| **Required**              | No               |
| **Additional properties** | Any type allowed |
| **Defined in**            | #/$defs/user     |

**Description:** User name or id

| One of(Option)                                     |
| -------------------------------------------------- |
| [item 0](#content_chown_files_items_user_oneOf_i0) |
| [item 1](#content_chown_files_items_user_oneOf_i1) |

###### <a name="content_chown_files_items_user_oneOf_i0"></a>4.7.1.4.1. Property `Manifest > content > chown_files > chown_files items > user > oneOf > item 0`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

| Restrictions                      |                                                                                                                                     |
| --------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$``` [Test](https://regex101.com/?regex=%5E%5BA-Za-z0-9_.%5D%5BA-Za-z0-9_.-%5D%7B0%2C31%7D%24) |

###### <a name="content_chown_files_items_user_oneOf_i1"></a>4.7.1.4.2. Property `Manifest > content > chown_files > chown_files items > user > oneOf > item 1`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 0 |

##### <a name="content_chown_files_items_group"></a>4.7.1.5. Property `Manifest > content > chown_files > chown_files items > group`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `combining`      |
| **Required**              | No               |
| **Additional properties** | Any type allowed |
| **Defined in**            | #/$defs/group    |

**Description:** Group name or id

| One of(Option)                                      |
| --------------------------------------------------- |
| [item 0](#content_chown_files_items_group_oneOf_i0) |
| [item 1](#content_chown_files_items_group_oneOf_i1) |

###### <a name="content_chown_files_items_group_oneOf_i0"></a>4.7.1.5.1. Property `Manifest > content > chown_files > chown_files items > group > oneOf > item 0`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

| Restrictions                      |                                                                                                                                     |
| --------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$``` [Test](https://regex101.com/?regex=%5E%5BA-Za-z0-9_.%5D%5BA-Za-z0-9_.-%5D%7B0%2C31%7D%24) |

###### <a name="content_chown_files_items_group_oneOf_i1"></a>4.7.1.5.2. Property `Manifest > content > chown_files > chown_files items > group > oneOf > item 1`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 0 |

##### <a name="content_chown_files_items_recursive"></a>4.7.1.6. Property `Manifest > content > chown_files > chown_files items > recursive`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

**Description:** Change ownership recursively

### <a name="content_remove_files"></a>4.8. Property `Manifest > content > remove_files`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be            | Description              |
| ------------------------------------------ | ------------------------ |
| [remove_file](#content_remove_files_items) | Remove an installed file |

#### <a name="content_remove_files_items"></a>4.8.1. Manifest > content > remove_files > remove_file

|                           |                     |
| ------------------------- | ------------------- |
| **Type**                  | `object`            |
| **Required**              | No                  |
| **Additional properties** | Not allowed         |
| **Defined in**            | #/$defs/remove_file |

**Description:** Remove an installed file

| Property                                    | Pattern | Type   | Deprecated | Definition                                              | Title/Description                           |
| ------------------------------------------- | ------- | ------ | ---------- | ------------------------------------------------------- | ------------------------------------------- |
| + [path](#content_remove_files_items_path ) | No      | string | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute pathname of the file to remove |

##### <a name="content_remove_files_items_path"></a>4.8.1.1. Property `Manifest > content > remove_files > remove_files items > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute pathname of the file to remove

### <a name="content_make_dirs"></a>4.9. Property `Manifest > content > make_dirs`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be      | Description        |
| ------------------------------------ | ------------------ |
| [make_dir](#content_make_dirs_items) | Create a directory |

#### <a name="content_make_dirs_items"></a>4.9.1. Manifest > content > make_dirs > make_dir

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Not allowed      |
| **Defined in**            | #/$defs/make_dir |

**Description:** Create a directory

| Property                                         | Pattern | Type    | Deprecated | Definition                                              | Title/Description                                 |
| ------------------------------------------------ | ------- | ------- | ---------- | ------------------------------------------------------- | ------------------------------------------------- |
| + [path](#content_make_dirs_items_path )         | No      | string  | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute pathname of the directory to create  |
| - [mode](#content_make_dirs_items_mode )         | No      | number  | No         | -                                                       | -                                                 |
| - [parents](#content_make_dirs_items_parents )   | No      | boolean | No         | -                                                       | If true, parent directories are created if needed |
| - [exist_ok](#content_make_dirs_items_exist_ok ) | No      | boolean | No         | -                                                       | If true, don't fail if directory exists           |

##### <a name="content_make_dirs_items_path"></a>4.9.1.1. Property `Manifest > content > make_dirs > make_dirs items > path`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute pathname of the directory to create

##### <a name="content_make_dirs_items_mode"></a>4.9.1.2. Property `Manifest > content > make_dirs > make_dirs items > mode`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

##### <a name="content_make_dirs_items_parents"></a>4.9.1.3. Property `Manifest > content > make_dirs > make_dirs items > parents`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** If true, parent directories are created if needed

##### <a name="content_make_dirs_items_exist_ok"></a>4.9.1.4. Property `Manifest > content > make_dirs > make_dirs items > exist_ok`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** If true, don't fail if directory exists

### <a name="content_add_symlinks"></a>4.10. Property `Manifest > content > add_symlinks`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** Create symbolic links in the image

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be             | Description            |
| ------------------------------------------- | ---------------------- |
| [symlink_file](#content_add_symlinks_items) | Create a symbolic link |

#### <a name="content_add_symlinks_items"></a>4.10.1. Manifest > content > add_symlinks > symlink_file

|                           |                      |
| ------------------------- | -------------------- |
| **Type**                  | `object`             |
| **Required**              | No                   |
| **Additional properties** | Not allowed          |
| **Defined in**            | #/$defs/symlink_file |

**Description:** Create a symbolic link

| Property                                        | Pattern | Type   | Deprecated | Definition                                              | Title/Description                                            |
| ----------------------------------------------- | ------- | ------ | ---------- | ------------------------------------------------------- | ------------------------------------------------------------ |
| + [link](#content_add_symlinks_items_link )     | No      | string | No         | Same as [path](#content_add_files_items_oneOf_i0_path ) | The absolute pathname of the symlink to create               |
| + [target](#content_add_symlinks_items_target ) | No      | string | No         | -                                                       | The target path the symlink points to (absolute or relative) |

##### <a name="content_add_symlinks_items_link"></a>4.10.1.1. Property `Manifest > content > add_symlinks > add_symlinks items > link`

|                        |                                                |
| ---------------------- | ---------------------------------------------- |
| **Type**               | `string`                                       |
| **Required**           | Yes                                            |
| **Same definition as** | [path](#content_add_files_items_oneOf_i0_path) |

**Description:** The absolute pathname of the symlink to create

##### <a name="content_add_symlinks_items_target"></a>4.10.1.2. Property `Manifest > content > add_symlinks > add_symlinks items > target`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** The target path the symlink points to (absolute or relative)

### <a name="content_systemd"></a>4.11. Property `Manifest > content > systemd`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Configure what systemd services are to be running other than the default ones.

| Property                                                   | Pattern | Type            | Deprecated | Definition | Title/Description                   |
| ---------------------------------------------------------- | ------- | --------------- | ---------- | ---------- | ----------------------------------- |
| - [enabled_services](#content_systemd_enabled_services )   | No      | array of string | No         | -          | List of systemd services to enable  |
| - [disabled_services](#content_systemd_disabled_services ) | No      | array of string | No         | -          | List of systemd services to disable |
| - [masked_services](#content_systemd_masked_services )     | No      | array of string | No         | -          | List of systemd services to mask    |

#### <a name="content_systemd_enabled_services"></a>4.11.1. Property `Manifest > content > systemd > enabled_services`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** List of systemd services to enable

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                   | Description |
| ----------------------------------------------------------------- | ----------- |
| [enabled_services items](#content_systemd_enabled_services_items) | -           |

##### <a name="content_systemd_enabled_services_items"></a>4.11.1.1. Manifest > content > systemd > enabled_services > enabled_services items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="content_systemd_disabled_services"></a>4.11.2. Property `Manifest > content > systemd > disabled_services`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** List of systemd services to disable

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                     | Description |
| ------------------------------------------------------------------- | ----------- |
| [disabled_services items](#content_systemd_disabled_services_items) | -           |

##### <a name="content_systemd_disabled_services_items"></a>4.11.2.1. Manifest > content > systemd > disabled_services > disabled_services items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="content_systemd_masked_services"></a>4.11.3. Property `Manifest > content > systemd > masked_services`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** List of systemd services to mask

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                 | Description |
| --------------------------------------------------------------- | ----------- |
| [masked_services items](#content_systemd_masked_services_items) | -           |

##### <a name="content_systemd_masked_services_items"></a>4.11.3.1. Manifest > content > systemd > masked_services > masked_services items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

### <a name="content_sbom"></a>4.12. Property `Manifest > content > sbom`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Generate a Software Bill of Materials (SBOM) document in SPDX v2 format for the installed RPM packages.

| Property                              | Pattern | Type   | Deprecated | Definition | Title/Description             |
| ------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------------------- |
| - [doc_path](#content_sbom_doc_path ) | No      | string | No         | -          | Output path for the SBOM file |

#### <a name="content_sbom_doc_path"></a>4.12.1. Property `Manifest > content > sbom > doc_path`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Output path for the SBOM file

## <a name="qm"></a>5. Property `Manifest > qm`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |
| **Defined in**            | #/$defs/qm  |

**Description:** If this section is included then a separate QM partion will be created in the image with the defined content.

| Property                                        | Pattern | Type        | Deprecated | Definition                   | Title/Description                                                     |
| ----------------------------------------------- | ------- | ----------- | ---------- | ---------------------------- | --------------------------------------------------------------------- |
| - [content](#qm_content )                       | No      | object      | No         | Same as [content](#content ) | The content to add to the qm partition                                |
| - [memory_limit](#qm_memory_limit )             | No      | object      | No         | -                            | -                                                                     |
| - [cpu_weight](#qm_cpu_weight )                 | No      | Combination | No         | -                            | CPUWeight for the QM partition (see systemd.resource-control manpage) |
| - [container_checksum](#qm_container_checksum ) | No      | string      | No         | -                            | Optional container digest that is validated at boot                   |

### <a name="qm_content"></a>5.1. Property `Manifest > qm > content`

|                           |                     |
| ------------------------- | ------------------- |
| **Type**                  | `object`            |
| **Required**              | No                  |
| **Additional properties** | Not allowed         |
| **Same definition as**    | [content](#content) |

**Description:** The content to add to the qm partition

### <a name="qm_memory_limit"></a>5.2. Property `Manifest > qm > memory_limit`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

| Property                         | Pattern | Type   | Deprecated | Definition | Title/Description                                                  |
| -------------------------------- | ------- | ------ | ---------- | ---------- | ------------------------------------------------------------------ |
| - [max](#qm_memory_limit_max )   | No      | string | No         | -          | MemoryMax for QM partition (see systemd.resource-control manpage)  |
| - [high](#qm_memory_limit_high ) | No      | string | No         | -          | MemoryHigh for QM partition (see systemd.resource-control manpage) |

#### <a name="qm_memory_limit_max"></a>5.2.1. Property `Manifest > qm > memory_limit > max`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** MemoryMax for QM partition (see systemd.resource-control manpage)

#### <a name="qm_memory_limit_high"></a>5.2.2. Property `Manifest > qm > memory_limit > high`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** MemoryHigh for QM partition (see systemd.resource-control manpage)

### <a name="qm_cpu_weight"></a>5.3. Property `Manifest > qm > cpu_weight`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `combining`      |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

**Description:** CPUWeight for the QM partition (see systemd.resource-control manpage)

| One of(Option)                    |
| --------------------------------- |
| [item 0](#qm_cpu_weight_oneOf_i0) |
| [item 1](#qm_cpu_weight_oneOf_i1) |

#### <a name="qm_cpu_weight_oneOf_i0"></a>5.3.1. Property `Manifest > qm > cpu_weight > oneOf > item 0`

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |

Must be one of:
* "idle"

#### <a name="qm_cpu_weight_oneOf_i1"></a>5.3.2. Property `Manifest > qm > cpu_weight > oneOf > item 1`

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |

| Restrictions |          |
| ------------ | -------- |
| **Minimum**  | &ge; 1   |
| **Maximum**  | &le; 100 |

### <a name="qm_container_checksum"></a>5.4. Property `Manifest > qm > container_checksum`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Optional container digest that is validated at boot

## <a name="network"></a>6. Property `Manifest > network`

|                           |                   |
| ------------------------- | ----------------- |
| **Type**                  | `object`          |
| **Required**              | No                |
| **Additional properties** | Not allowed       |
| **Default**               | `{"dynamic": {}}` |
| **Defined in**            | #/$defs/network   |

**Description:** Define the Network setup, which can be of two types, `dynamic` or `static`, the default is dynamic

| Property                       | Pattern | Type   | Deprecated | Definition                 | Title/Description                                                                                         |
| ------------------------------ | ------- | ------ | ---------- | -------------------------- | --------------------------------------------------------------------------------------------------------- |
| - [static](#network_static )   | No      | object | No         | In #/$defs/static_network  | Section to configure the network with static IP addresses (i.e. no DHCP) and fixed configuration options. |
| - [dynamic](#network_dynamic ) | No      | object | No         | In #/$defs/dynamic_network | Use network manager for dynamic network setup, currently has no options                                   |

### <a name="network_static"></a>6.1. Property `Manifest > network > static`

|                           |                        |
| ------------------------- | ---------------------- |
| **Type**                  | `object`               |
| **Required**              | No                     |
| **Additional properties** | Not allowed            |
| **Defined in**            | #/$defs/static_network |

**Description:** Section to configure the network with static IP addresses (i.e. no DHCP) and fixed configuration options.

| Property                                        | Pattern | Type   | Deprecated | Definition | Title/Description                                                                                                                                                                                                                                                                                                  |
| ----------------------------------------------- | ------- | ------ | ---------- | ---------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| - [ip](#network_static_ip )                     | No      | string | No         | -          | The fixed ip address assigned to the node.                                                                                                                                                                                                                                                                         |
| - [ip_prefixlen](#network_static_ip_prefixlen ) | No      | number | No         | -          | Prefix length is the number of bits that define the network portion of an IP address, specified in CIDR notation. For example 24 for a 255.255.255.0 netmask.                                                                                                                                                      |
| - [gateway](#network_static_gateway )           | No      | string | No         | -          | the default route taken by non-local packets when the host does not know where the destination is.                                                                                                                                                                                                                 |
| - [dns](#network_static_dns )                   | No      | string | No         | -          | DNS is the IP address of the name server to be used (eg. example.com to 192.0.2.1).                                                                                                                                                                                                                                |
| - [iface](#network_static_iface )               | No      | string | No         | -          | The hardware network interface name to setup for the static ip at boot (for example eth0). Normally this doesn't need to be specified, as the default network interface for the target board will be used. However, in case you are using a non-standard network driver or card this can be used to override that. |
| - [load_module](#network_static_load_module )   | No      | string | No         | -          | Optional name of a kernel module to load at boot for the network support. Normally this feature may not be needed because the target board will load the default network drivers, but if a non-standard network driver is used, it can be specified using this option.                                             |

#### <a name="network_static_ip"></a>6.1.1. Property `Manifest > network > static > ip`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The fixed ip address assigned to the node.

#### <a name="network_static_ip_prefixlen"></a>6.1.2. Property `Manifest > network > static > ip_prefixlen`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** Prefix length is the number of bits that define the network portion of an IP address, specified in CIDR notation. For example 24 for a 255.255.255.0 netmask.

#### <a name="network_static_gateway"></a>6.1.3. Property `Manifest > network > static > gateway`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** the default route taken by non-local packets when the host does not know where the destination is.

#### <a name="network_static_dns"></a>6.1.4. Property `Manifest > network > static > dns`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** DNS is the IP address of the name server to be used (eg. example.com to 192.0.2.1).

#### <a name="network_static_iface"></a>6.1.5. Property `Manifest > network > static > iface`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The hardware network interface name to setup for the static ip at boot (for example eth0). Normally this doesn't need to be specified, as the default network interface for the target board will be used. However, in case you are using a non-standard network driver or card this can be used to override that.

#### <a name="network_static_load_module"></a>6.1.6. Property `Manifest > network > static > load_module`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Optional name of a kernel module to load at boot for the network support. Normally this feature may not be needed because the target board will load the default network drivers, but if a non-standard network driver is used, it can be specified using this option.

### <a name="network_dynamic"></a>6.2. Property `Manifest > network > dynamic`

|                           |                         |
| ------------------------- | ----------------------- |
| **Type**                  | `object`                |
| **Required**              | No                      |
| **Additional properties** | Any type allowed        |
| **Defined in**            | #/$defs/dynamic_network |

**Description:** Use network manager for dynamic network setup, currently has no options

## <a name="image"></a>7. Property `Manifest > image`

|                           |               |
| ------------------------- | ------------- |
| **Type**                  | `object`      |
| **Required**              | No            |
| **Additional properties** | Not allowed   |
| **Defined in**            | #/$defs/image |

**Description:** Configure global options for the image.

| Property                                       | Pattern | Type             | Deprecated | Definition | Title/Description                                                                                               |
| ---------------------------------------------- | ------- | ---------------- | ---------- | ---------- | --------------------------------------------------------------------------------------------------------------- |
| - [image_size](#image_image_size )             | No      | string           | No         | -          | The size of the total image, allows suffixes like "GB" (powers of 1000) or "GiB" (powers of 1024)               |
| - [sealed](#image_sealed )                     | No      | boolean          | No         | -          | Sealed images can only boot the original, or re-sealed images, not e.g. layered bootc images. Defaults to true. |
| - [selinux_mode](#image_selinux_mode )         | No      | enum (of string) | No         | -          | The selinux mode (enforcing or permissive)                                                                      |
| - [selinux_policy](#image_selinux_policy )     | No      | string           | No         | -          | The name of the selinux policy to use                                                                           |
| - [selinux_booleans](#image_selinux_booleans ) | No      | object           | No         | -          | Set individual selinux policy boolean options                                                                   |
| - [partitions](#image_partitions )             | No      | object           | No         | -          | Disk partition details, like sizes.                                                                             |
| - [hostname](#image_hostname )                 | No      | string           | No         | -          | The network hostname                                                                                            |
| - [ostree_ref](#image_ostree_ref )             | No      | string           | No         | -          | The name of the ostree ref (defaults to $distro_name/$arch/$target-$naem)                                       |

### <a name="image_image_size"></a>7.1. Property `Manifest > image > image_size`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The size of the total image, allows suffixes like "GB" (powers of 1000) or "GiB" (powers of 1024)

| Restrictions                      |                                                                                                                                                                |
| --------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9]+ *(kB\|KiB\|MB\|MiB\|GB\|GiB\|TB\|TiB)$``` [Test](https://regex101.com/?regex=%5E%5B0-9%5D%2B+%2A%28kB%7CKiB%7CMB%7CMiB%7CGB%7CGiB%7CTB%7CTiB%29%24) |

### <a name="image_sealed"></a>7.2. Property `Manifest > image > sealed`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Sealed images can only boot the original, or re-sealed images, not e.g. layered bootc images. Defaults to true.

### <a name="image_selinux_mode"></a>7.3. Property `Manifest > image > selinux_mode`

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |
| **Default**  | `"enforcing"`      |

**Description:** The selinux mode (enforcing or permissive)

Must be one of:
* "enforcing"
* "permissive"

### <a name="image_selinux_policy"></a>7.4. Property `Manifest > image > selinux_policy`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The name of the selinux policy to use

### <a name="image_selinux_booleans"></a>7.5. Property `Manifest > image > selinux_booleans`

|                           |                                                                                                     |
| ------------------------- | --------------------------------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                                            |
| **Required**              | No                                                                                                  |
| **Additional properties** | [Each additional property must conform to the schema](#image_selinux_booleans_additionalProperties) |

**Description:** Set individual selinux policy boolean options

| Property                                            | Pattern | Type    | Deprecated | Definition | Title/Description |
| --------------------------------------------------- | ------- | ------- | ---------- | ---------- | ----------------- |
| - [](#image_selinux_booleans_additionalProperties ) | No      | boolean | No         | -          | -                 |

#### <a name="image_selinux_booleans_additionalProperties"></a>7.5.1. Property `Manifest > image > selinux_booleans > additionalProperties`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

### <a name="image_partitions"></a>7.6. Property `Manifest > image > partitions`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Disk partition details, like sizes.

| Property                                                                  | Pattern | Type   | Deprecated | Definition | Title/Description                  |
| ------------------------------------------------------------------------- | ------- | ------ | ---------- | ---------- | ---------------------------------- |
| - [root](#image_partitions_pattern1 )                                     | Yes     | object | No         | -          | -                                  |
| - [(aboot\|ukiboot\|boot\|efi\|vbmeta\|sbl)](#image_partitions_pattern2 ) | Yes     | object | No         | -          | -                                  |
| - [var](#image_partitions_pattern3 )                                      | Yes     | object | No         | -          | Use separate partition for /var    |
| - [var_qm](#image_partitions_pattern4 )                                   | Yes     | object | No         | -          | Use separate partition for /var/qm |

#### <a name="image_partitions_pattern1"></a>7.6.1. Pattern Property `Manifest > image > partitions > root`
> All properties whose name matches the regular expression
```root``` ([Test](https://regex101.com/?regex=root))
must respect the following conditions

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

| Property                                   | Pattern | Type    | Deprecated | Definition | Title/Description                                                 |
| ------------------------------------------ | ------- | ------- | ---------- | ---------- | ----------------------------------------------------------------- |
| - [grow](#image_partitions_pattern1_grow ) | No      | boolean | No         | -          | Support for growing root filesystem to match physical image size. |

##### <a name="image_partitions_pattern1_grow"></a>7.6.1.1. Property `Manifest > image > partitions > root > grow`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Support for growing root filesystem to match physical image size.

#### <a name="image_partitions_pattern2"></a>7.6.2. Pattern Property `Manifest > image > partitions > (aboot\|ukiboot\|boot\|efi\|vbmeta\|sbl)`
> All properties whose name matches the regular expression
```(aboot|ukiboot|boot|efi|vbmeta|sbl)``` ([Test](https://regex101.com/?regex=%28aboot%7Cukiboot%7Cboot%7Cefi%7Cvbmeta%7Csbl%29))
must respect the following conditions

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

| Property                                   | Pattern | Type   | Deprecated | Definition | Title/Description           |
| ------------------------------------------ | ------- | ------ | ---------- | ---------- | --------------------------- |
| - [size](#image_partitions_pattern2_size ) | No      | string | No         | -          | size of partition (if used) |

##### <a name="image_partitions_pattern2_size"></a>7.6.2.1. Property `Manifest > image > partitions > (aboot\|ukiboot\|boot\|efi\|vbmeta\|sbl) > size`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** size of partition (if used)

| Restrictions                      |                                                                                                                                                                |
| --------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9]+ *(kB\|KiB\|MB\|MiB\|GB\|GiB\|TB\|TiB)$``` [Test](https://regex101.com/?regex=%5E%5B0-9%5D%2B+%2A%28kB%7CKiB%7CMB%7CMiB%7CGB%7CGiB%7CTB%7CTiB%29%24) |

#### <a name="image_partitions_pattern3"></a>7.6.3. Pattern Property `Manifest > image > partitions > var`
> All properties whose name matches the regular expression
```var``` ([Test](https://regex101.com/?regex=var))
must respect the following conditions

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Use separate partition for /var

| Property                                                     | Pattern | Type    | Deprecated | Definition | Title/Description                                                                                                                                                         |
| ------------------------------------------------------------ | ------- | ------- | ---------- | ---------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| - [relative_size](#image_partitions_pattern3_relative_size ) | No      | number  | No         | -          | Size of /var partition(s) relative to total image size, 0 to disable<br /><br />Note: This size includes the /var/qm if that is used, see qm_relative_size options.<br /> |
| - [size](#image_partitions_pattern3_size )                   | No      | string  | No         | -          | Size of /var partition in bytes (with suffix), 0 to disable                                                                                                               |
| - [external](#image_partitions_pattern3_external )           | No      | boolean | No         | -          | The /var partition is on an external device (not an image parition)                                                                                                       |
| - [uuid](#image_partitions_pattern3_uuid )                   | No      | object  | No         | -          | The uuid of the partition                                                                                                                                                 |

##### <a name="image_partitions_pattern3_relative_size"></a>7.6.3.1. Property `Manifest > image > partitions > var > relative_size`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |
| **Default**  | `0.3`    |

**Description:** Size of /var partition(s) relative to total image size, 0 to disable

Note: This size includes the /var/qm if that is used, see qm_relative_size options.

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 0 |
| **Maximum**  | N/A    |

##### <a name="image_partitions_pattern3_size"></a>7.6.3.2. Property `Manifest > image > partitions > var > size`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Size of /var partition in bytes (with suffix), 0 to disable

| Restrictions                      |                                                                                                                                                                |
| --------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9]+ *(kB\|KiB\|MB\|MiB\|GB\|GiB\|TB\|TiB)$``` [Test](https://regex101.com/?regex=%5E%5B0-9%5D%2B+%2A%28kB%7CKiB%7CMB%7CMiB%7CGB%7CGiB%7CTB%7CTiB%29%24) |

##### <a name="image_partitions_pattern3_external"></a>7.6.3.3. Property `Manifest > image > partitions > var > external`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** The /var partition is on an external device (not an image parition)

##### <a name="image_partitions_pattern3_uuid"></a>7.6.3.4. Property `Manifest > image > partitions > var > uuid`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

**Description:** The uuid of the partition

**Example:**

```json
"9c6ae55b-cf88-45b8-84e8-64990759f39d"
```

| Restrictions                      |                                                                                                                                                                                                                                               |
| --------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9A-Za-z]{8}(-[0-9A-Za-z]{4}){3}-[0-9A-Za-z]{12}$``` [Test](https://regex101.com/?regex=%5E%5B0-9A-Za-z%5D%7B8%7D%28-%5B0-9A-Za-z%5D%7B4%7D%29%7B3%7D-%5B0-9A-Za-z%5D%7B12%7D%24&testString=%229c6ae55b-cf88-45b8-84e8-64990759f39d%22) |

#### <a name="image_partitions_pattern4"></a>7.6.4. Pattern Property `Manifest > image > partitions > var_qm`
> All properties whose name matches the regular expression
```var_qm``` ([Test](https://regex101.com/?regex=var_qm))
must respect the following conditions

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Use separate partition for /var/qm

| Property                                                     | Pattern | Type    | Deprecated | Definition | Title/Description                                                                                                                    |
| ------------------------------------------------------------ | ------- | ------- | ---------- | ---------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| - [relative_size](#image_partitions_pattern4_relative_size ) | No      | number  | No         | -          | Size of /var/qm partition relative to total image size. 0 to disable.<br /><br />Note: This is only included if qm is enabled.<br /> |
| - [size](#image_partitions_pattern4_size )                   | No      | string  | No         | -          | Size of /var/qm partition in bytes (with suffix), 0 to disable.<br /><br />Note: This is only included if qm is enabled.<br />       |
| - [external](#image_partitions_pattern4_external )           | No      | boolean | No         | -          | The /var/qm partition is on an external device (not an image parition)                                                               |
| - [uuid](#image_partitions_pattern4_uuid )                   | No      | object  | No         | -          | The uuid of the partition                                                                                                            |

##### <a name="image_partitions_pattern4_relative_size"></a>7.6.4.1. Property `Manifest > image > partitions > var_qm > relative_size`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |
| **Default**  | `0`      |

**Description:** Size of /var/qm partition relative to total image size. 0 to disable.

Note: This is only included if qm is enabled.

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 0 |
| **Maximum**  | N/A    |

##### <a name="image_partitions_pattern4_size"></a>7.6.4.2. Property `Manifest > image > partitions > var_qm > size`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Size of /var/qm partition in bytes (with suffix), 0 to disable.

Note: This is only included if qm is enabled.

| Restrictions                      |                                                                                                                                                                |
| --------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9]+ *(kB\|KiB\|MB\|MiB\|GB\|GiB\|TB\|TiB)$``` [Test](https://regex101.com/?regex=%5E%5B0-9%5D%2B+%2A%28kB%7CKiB%7CMB%7CMiB%7CGB%7CGiB%7CTB%7CTiB%29%24) |

##### <a name="image_partitions_pattern4_external"></a>7.6.4.3. Property `Manifest > image > partitions > var_qm > external`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** The /var/qm partition is on an external device (not an image parition)

##### <a name="image_partitions_pattern4_uuid"></a>7.6.4.4. Property `Manifest > image > partitions > var_qm > uuid`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

**Description:** The uuid of the partition

**Example:**

```json
"9c6ae55b-cf88-45b8-84e8-64990759f39d"
```

| Restrictions                      |                                                                                                                                                                                                                                               |
| --------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```^[0-9A-Za-z]{8}(-[0-9A-Za-z]{4}){3}-[0-9A-Za-z]{12}$``` [Test](https://regex101.com/?regex=%5E%5B0-9A-Za-z%5D%7B8%7D%28-%5B0-9A-Za-z%5D%7B4%7D%29%7B3%7D-%5B0-9A-Za-z%5D%7B12%7D%24&testString=%229c6ae55b-cf88-45b8-84e8-64990759f39d%22) |

### <a name="image_hostname"></a>7.7. Property `Manifest > image > hostname`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The network hostname

### <a name="image_ostree_ref"></a>7.8. Property `Manifest > image > ostree_ref`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** The name of the ostree ref (defaults to $distro_name/$arch/$target-$naem)

## <a name="auth"></a>8. Property `Manifest > auth`

|                           |              |
| ------------------------- | ------------ |
| **Type**                  | `object`     |
| **Required**              | No           |
| **Additional properties** | Not allowed  |
| **Defined in**            | #/$defs/auth |

**Description:** Configuration related to users, group and authentications.

| Property                                | Pattern | Type           | Deprecated | Definition | Title/Description                                                                                                                |
| --------------------------------------- | ------- | -------------- | ---------- | ---------- | -------------------------------------------------------------------------------------------------------------------------------- |
| - [root_password](#auth_root_password ) | No      | string or null | No         | -          | Roots's encrypted password, as returned by crypt(3), or empty for no password. Use null to disallow login, which is the default. |
| - [root_ssh_keys](#auth_root_ssh_keys ) | No      | array or null  | No         | -          | Roots's ssh keys, or nothing to disable                                                                                          |
| - [sshd_config](#auth_sshd_config )     | No      | object         | No         | -          | Configuration of ssh daemon                                                                                                      |
| - [users](#auth_users )                 | No      | object         | No         | -          | Keys are usernames, values are objects giving user info.                                                                         |
| - [groups](#auth_groups )               | No      | object         | No         | -          | Keys are group, values are objects giving group info.                                                                            |

### <a name="auth_root_password"></a>8.1. Property `Manifest > auth > root_password`

|              |                  |
| ------------ | ---------------- |
| **Type**     | `string or null` |
| **Required** | No               |

**Description:** Roots's encrypted password, as returned by crypt(3), or empty for no password. Use null to disallow login, which is the default.

### <a name="auth_root_ssh_keys"></a>8.2. Property `Manifest > auth > root_ssh_keys`

|              |                 |
| ------------ | --------------- |
| **Type**     | `array or null` |
| **Required** | No              |

**Description:** Roots's ssh keys, or nothing to disable

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | N/A                |

### <a name="auth_sshd_config"></a>8.3. Property `Manifest > auth > sshd_config`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Configuration of ssh daemon

| Property                                                              | Pattern | Type        | Deprecated | Definition | Title/Description                            |
| --------------------------------------------------------------------- | ------- | ----------- | ---------- | ---------- | -------------------------------------------- |
| - [PasswordAuthentication](#auth_sshd_config_PasswordAuthentication ) | No      | boolean     | No         | -          | Enable or disable password authentication    |
| - [PermitRootLogin](#auth_sshd_config_PermitRootLogin )               | No      | Combination | No         | -          | Specifies whether root can log in using ssh. |

#### <a name="auth_sshd_config_PasswordAuthentication"></a>8.3.1. Property `Manifest > auth > sshd_config > PasswordAuthentication`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Enable or disable password authentication

#### <a name="auth_sshd_config_PermitRootLogin"></a>8.3.2. Property `Manifest > auth > sshd_config > PermitRootLogin`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `combining`      |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

**Description:** Specifies whether root can log in using ssh.

| One of(Option)                                       |
| ---------------------------------------------------- |
| [item 0](#auth_sshd_config_PermitRootLogin_oneOf_i0) |
| [item 1](#auth_sshd_config_PermitRootLogin_oneOf_i1) |

##### <a name="auth_sshd_config_PermitRootLogin_oneOf_i0"></a>8.3.2.1. Property `Manifest > auth > sshd_config > PermitRootLogin > oneOf > item 0`

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |

Must be one of:
* "prohibit-password"
* "forced-commands-only"

##### <a name="auth_sshd_config_PermitRootLogin_oneOf_i1"></a>8.3.2.2. Property `Manifest > auth > sshd_config > PermitRootLogin > oneOf > item 1`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

### <a name="auth_users"></a>8.4. Property `Manifest > auth > users`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Keys are usernames, values are objects giving user info.

| Property                                                       | Pattern | Type   | Deprecated | Definition          | Title/Description |
| -------------------------------------------------------------- | ------- | ------ | ---------- | ------------------- | ----------------- |
| - [^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$](#auth_users_pattern1 ) | Yes     | object | No         | In #/$defs/add_user | -                 |

#### <a name="auth_users_pattern1"></a>8.4.1. Pattern Property `Manifest > auth > users > add_user`
> All properties whose name matches the regular expression
```^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$``` ([Test](https://regex101.com/?regex=%5E%5BA-Za-z0-9_.%5D%5BA-Za-z0-9_.-%5D%7B0%2C31%7D%24))
must respect the following conditions

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Not allowed      |
| **Defined in**            | #/$defs/add_user |

| Property                                                             | Pattern | Type            | Deprecated | Definition | Title/Description                                                                                                          |
| -------------------------------------------------------------------- | ------- | --------------- | ---------- | ---------- | -------------------------------------------------------------------------------------------------------------------------- |
| - [gid](#auth_users_pattern1_gid )                                   | No      | number          | No         | -          | User UID                                                                                                                   |
| - [uid](#auth_users_pattern1_uid )                                   | No      | number          | No         | -          | User GID                                                                                                                   |
| - [groups](#auth_users_pattern1_groups )                             | No      | array of string | No         | -          | Array of group names for this user                                                                                         |
| - [description](#auth_users_pattern1_description )                   | No      | string          | No         | -          | User account description (or full name)                                                                                    |
| - [home](#auth_users_pattern1_home )                                 | No      | string          | No         | -          | Path to user's home directory                                                                                              |
| - [shell](#auth_users_pattern1_shell )                               | No      | string          | No         | -          | User's login shell                                                                                                         |
| - [password](#auth_users_pattern1_password )                         | No      | string          | No         | -          | User's encrypted password, as returned by crypt(3)                                                                         |
| - [key](#auth_users_pattern1_key )                                   | No      | string          | No         | -          | SSH Public Key to add to ~/.ssh/authorized_keys                                                                            |
| - [keys](#auth_users_pattern1_keys )                                 | No      | array of string | No         | -          | Array of SSH Public Keys to add to ~/.ssh/authorized_keys                                                                  |
| - [expiredate](#auth_users_pattern1_expiredate )                     | No      | integer         | No         | -          | The date on which the user account will be disabled. This date is represented as a number of days since January 1st, 1970. |
| - [force_password_reset](#auth_users_pattern1_force_password_reset ) | No      | boolean         | No         | -          | Force this user to change their password on first login                                                                    |

##### <a name="auth_users_pattern1_gid"></a>8.4.1.1. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > gid`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** User UID

##### <a name="auth_users_pattern1_uid"></a>8.4.1.2. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > uid`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** User GID

##### <a name="auth_users_pattern1_groups"></a>8.4.1.3. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > groups`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** Array of group names for this user

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                   | Description |
| ------------------------------------------------- | ----------- |
| [groups items](#auth_users_pattern1_groups_items) | -           |

###### <a name="auth_users_pattern1_groups_items"></a>8.4.1.3.1. Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > groups > groups items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

##### <a name="auth_users_pattern1_description"></a>8.4.1.4. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > description`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** User account description (or full name)

##### <a name="auth_users_pattern1_home"></a>8.4.1.5. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > home`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Path to user's home directory

##### <a name="auth_users_pattern1_shell"></a>8.4.1.6. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > shell`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** User's login shell

##### <a name="auth_users_pattern1_password"></a>8.4.1.7. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > password`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** User's encrypted password, as returned by crypt(3)

##### <a name="auth_users_pattern1_key"></a>8.4.1.8. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > key`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** SSH Public Key to add to ~/.ssh/authorized_keys

##### <a name="auth_users_pattern1_keys"></a>8.4.1.9. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > keys`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** Array of SSH Public Keys to add to ~/.ssh/authorized_keys

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be               | Description |
| --------------------------------------------- | ----------- |
| [keys items](#auth_users_pattern1_keys_items) | -           |

###### <a name="auth_users_pattern1_keys_items"></a>8.4.1.9.1. Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > keys > keys items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

##### <a name="auth_users_pattern1_expiredate"></a>8.4.1.10. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > expiredate`

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |

**Description:** The date on which the user account will be disabled. This date is represented as a number of days since January 1st, 1970.

##### <a name="auth_users_pattern1_force_password_reset"></a>8.4.1.11. Property `Manifest > auth > users > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > force_password_reset`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Force this user to change their password on first login

### <a name="auth_groups"></a>8.5. Property `Manifest > auth > groups`

|                           |             |
| ------------------------- | ----------- |
| **Type**                  | `object`    |
| **Required**              | No          |
| **Additional properties** | Not allowed |

**Description:** Keys are group, values are objects giving group info.

| Property                                                        | Pattern | Type   | Deprecated | Definition           | Title/Description |
| --------------------------------------------------------------- | ------- | ------ | ---------- | -------------------- | ----------------- |
| - [^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$](#auth_groups_pattern1 ) | Yes     | object | No         | In #/$defs/add_group | -                 |

#### <a name="auth_groups_pattern1"></a>8.5.1. Pattern Property `Manifest > auth > groups > add_group`
> All properties whose name matches the regular expression
```^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$``` ([Test](https://regex101.com/?regex=%5E%5BA-Za-z0-9_.%5D%5BA-Za-z0-9_.-%5D%7B0%2C31%7D%24))
must respect the following conditions

|                           |                   |
| ------------------------- | ----------------- |
| **Type**                  | `object`          |
| **Required**              | No                |
| **Additional properties** | Not allowed       |
| **Defined in**            | #/$defs/add_group |

| Property                            | Pattern | Type   | Deprecated | Definition | Title/Description  |
| ----------------------------------- | ------- | ------ | ---------- | ---------- | ------------------ |
| - [gid](#auth_groups_pattern1_gid ) | No      | number | No         | -          | GID for this group |

##### <a name="auth_groups_pattern1_gid"></a>8.5.1.1. Property `Manifest > auth > groups > ^[A-Za-z0-9_.][A-Za-z0-9_.-]{0,31}$ > gid`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** GID for this group

## <a name="kernel"></a>9. Property `Manifest > kernel`

|                           |                |
| ------------------------- | -------------- |
| **Type**                  | `object`       |
| **Required**              | No             |
| **Additional properties** | Not allowed    |
| **Defined in**            | #/$defs/kernel |

**Description:** Kernel options

| Property                                    | Pattern | Type    | Deprecated | Definition | Title/Description                                               |
| ------------------------------------------- | ------- | ------- | ---------- | ---------- | --------------------------------------------------------------- |
| - [debug_logging](#kernel_debug_logging )   | No      | boolean | No         | -          | Add more debug logging                                          |
| - [cmdline](#kernel_cmdline )               | No      | array   | No         | -          | Extra kernel commandline options                                |
| - [kernel_package](#kernel_kernel_package ) | No      | string  | No         | -          | Use a custom kernel package name (instead of kernel-automotive) |
| - [kernel_version](#kernel_kernel_version ) | No      | string  | No         | -          | Use a custom kernel package version                             |
| - [loglevel](#kernel_loglevel )             | No      | integer | No         | -          | Use a kernel log level                                          |
| - [remove_modules](#kernel_remove_modules ) | No      | array   | No         | -          | Remove kernel modules (and dependendices) from image            |

### <a name="kernel_debug_logging"></a>9.1. Property `Manifest > kernel > debug_logging`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Add more debug logging

### <a name="kernel_cmdline"></a>9.2. Property `Manifest > kernel > cmdline`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** Extra kernel commandline options

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | N/A                |

### <a name="kernel_kernel_package"></a>9.3. Property `Manifest > kernel > kernel_package`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Use a custom kernel package name (instead of kernel-automotive)

### <a name="kernel_kernel_version"></a>9.4. Property `Manifest > kernel > kernel_version`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Use a custom kernel package version

### <a name="kernel_loglevel"></a>9.5. Property `Manifest > kernel > loglevel`

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |

**Description:** Use a kernel log level

### <a name="kernel_remove_modules"></a>9.6. Property `Manifest > kernel > remove_modules`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

**Description:** Remove kernel modules (and dependendices) from image

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | N/A                |

## <a name="experimental"></a>10. Property `Manifest > experimental`

|                           |                      |
| ------------------------- | -------------------- |
| **Type**                  | `object`             |
| **Required**              | No                   |
| **Additional properties** | Not allowed          |
| **Defined in**            | #/$defs/experimental |

**Description:** Experimental options. Unsupported, may change over time without warning.

| Property                                              | Pattern | Type   | Deprecated | Definition | Title/Description            |
| ----------------------------------------------------- | ------- | ------ | ---------- | ---------- | ---------------------------- |
| - [internal_defines](#experimental_internal_defines ) | No      | object | No         | -          | Internal OSBuild MPP defines |

### <a name="experimental_internal_defines"></a>10.1. Property `Manifest > experimental > internal_defines`

|                           |                  |
| ------------------------- | ---------------- |
| **Type**                  | `object`         |
| **Required**              | No               |
| **Additional properties** | Any type allowed |

**Description:** Internal OSBuild MPP defines

| Property                                                   | Pattern | Type   | Deprecated | Definition | Title/Description |
| ---------------------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [](#experimental_internal_defines_additionalProperties ) | No      | object | No         | -          | -                 |

----------------------------------------------------------------------------------------------------------------------------
Generated using [json-schema-for-humans](https://github.com/coveooss/json-schema-for-humans) on 2026-01-20 at 14:39:42 +0100
