(*
Module: Test_Anaconda
  Provides unit tests and examples for the <Anaconda> lens.

  - 'exampleN' snippets are taken from the documentation:
    https://anaconda-installer.readthedocs.io/en/latest/user-interaction-config-file-spec.html
  - 'installedN' snippets are taken from the resulting files after
    a successful installation
*)

module Test_Anaconda =

let example1 = "# comment example - before the section headers

[section_1]
# comment example - inside section 1
key_a_in_section1=some_value
key_b_in_section1=some_value

[section_2]
# comment example - inside section 2
key_a_in_section2=some_value
"

test Anaconda.lns get example1 =
  { "#comment" = "comment example - before the section headers" }
  { }
  { "section_1"
    { "#comment" = "comment example - inside section 1" }
    { "key_a_in_section1" = "some_value" }
    { "key_b_in_section1" = "some_value" }
    { }
  }
  { "section_2"
    { "#comment" = "comment example - inside section 2" }
    { "key_a_in_section2" = "some_value" }
  }

let example2 = "# this is the user interaction config file

[General]
post_install_tools_disabled=0

[DatetimeSpoke]
# the date and time spoke has been visited
visited=1
changed_timezone=1
changed_ntp=0
changed_timedate=1

[KeyboardSpoke]
# the keyboard spoke has not been visited
visited=0
"

test Anaconda.lns get example2 =
  { "#comment" = "this is the user interaction config file" }
  { }
  { "General"
    { "post_install_tools_disabled" = "0" }
    { }
  }
  { "DatetimeSpoke"
    { "#comment" = "the date and time spoke has been visited" }
    { "visited" = "1" }
    { "changed_timezone" = "1" }
    { "changed_ntp" = "0" }
    { "changed_timedate" = "1" }
    { }
  }
  { "KeyboardSpoke"
    { "#comment" = "the keyboard spoke has not been visited" }
    { "visited" = "0" }
  }

let installed1 = "# This file has been generated by the Anaconda Installer 21.48.22.134-1

[ProgressSpoke]
visited = 1

"

test Anaconda.lns get installed1 =
  { "#comment" = "This file has been generated by the Anaconda Installer 21.48.22.134-1" }
  { }
  { "ProgressSpoke"
    { "visited" = "1" }
    { }
  }
