(*
Module: Test_Fonts
  Provides unit tests and examples for the <Fonts> lens.
*)

module Test_Fonts =

(* Variable: conf *)
let conf = "<?xml version=\"1.0\"?>
<!DOCTYPE fontconfig SYSTEM \"fonts.dtd\">
<!-- /etc/fonts/fonts.conf file to configure system font access -->
<fontconfig>

<!--
	DO NOT EDIT THIS FILE.
	IT WILL BE REPLACED WHEN FONTCONFIG IS UPDATED.
	LOCAL CHANGES BELONG IN 'local.conf'.

	The intent of this standard configuration file is to be adequate for
	most environments.  If you have a reasonably normal environment and
	have found problems with this configuration, they are probably
	things that others will also want fixed.  Please submit any
	problems to the fontconfig bugzilla system located at fontconfig.org

	Note that the normal 'make install' procedure for fontconfig is to
	replace any existing fonts.conf file with the new version.  Place
	any local customizations in local.conf which this file references.

	Keith Packard
-->

<!-- Font directory list -->

	<dir>/usr/share/fonts</dir>
	<dir>/usr/X11R6/lib/X11/fonts</dir> <dir>/usr/local/share/fonts</dir>
	<dir>~/.fonts</dir>

<!--
  Accept deprecated 'mono' alias, replacing it with 'monospace'
-->
	<match target=\"pattern\">
		<test qual=\"any\" name=\"family\">
			<string>mono</string>
		</test>
		<edit name=\"family\" mode=\"assign\">
			<string>monospace</string>
		</edit>
	</match>

<!--
  Accept alternate 'sans serif' spelling, replacing it with 'sans-serif'
-->
	<match target=\"pattern\">
		<test qual=\"any\" name=\"family\">
			<string>sans serif</string>
		</test>
		<edit name=\"family\" mode=\"assign\">
			<string>sans-serif</string>
		</edit>
	</match>

<!--
  Accept deprecated 'sans' alias, replacing it with 'sans-serif'
-->
	<match target=\"pattern\">
		<test qual=\"any\" name=\"family\">
			<string>sans</string>
		</test>
		<edit name=\"family\" mode=\"assign\">
			<string>sans-serif</string>
		</edit>
	</match>

<!--
  Load local system customization file
-->
	<include ignore_missing=\"yes\">conf.d</include>

<!-- Font cache directory list -->

	<cachedir>/var/cache/fontconfig</cachedir>
	<cachedir>~/.fontconfig</cachedir>

	<config>
<!--
  These are the default Unicode chars that are expected to be blank
  in fonts.  All other blank chars are assumed to be broken and
  won't appear in the resulting charsets
 -->
		<blank>
			<int>0x0020</int>	<!-- SPACE -->
			<int>0x00A0</int>	<!-- NO-BREAK SPACE -->
			<int>0x00AD</int>	<!-- SOFT HYPHEN -->
			<int>0x034F</int>	<!-- COMBINING GRAPHEME JOINER -->
			<int>0x0600</int>	<!-- ARABIC NUMBER SIGN -->
			<int>0x0601</int>	<!-- ARABIC SIGN SANAH -->
			<int>0x0602</int>	<!-- ARABIC FOOTNOTE MARKER -->
			<int>0x0603</int>	<!-- ARABIC SIGN SAFHA -->
			<int>0x06DD</int>	<!-- ARABIC END OF AYAH -->
			<int>0x070F</int>	<!-- SYRIAC ABBREVIATION MARK -->
			<int>0x115F</int>	<!-- HANGUL CHOSEONG FILLER -->
			<int>0x1160</int>	<!-- HANGUL JUNGSEONG FILLER -->
			<int>0x1680</int>	<!-- OGHAM SPACE MARK -->
			<int>0x17B4</int>	<!-- KHMER VOWEL INHERENT AQ -->
			<int>0x17B5</int>	<!-- KHMER VOWEL INHERENT AA -->
			<int>0x180E</int>	<!-- MONGOLIAN VOWEL SEPARATOR -->
			<int>0x2000</int>	<!-- EN QUAD -->
			<int>0x2001</int>	<!-- EM QUAD -->
			<int>0x2002</int>	<!-- EN SPACE -->
			<int>0x2003</int>	<!-- EM SPACE -->
			<int>0x2004</int>	<!-- THREE-PER-EM SPACE -->
			<int>0x2005</int>	<!-- FOUR-PER-EM SPACE -->
			<int>0x2006</int>	<!-- SIX-PER-EM SPACE -->
			<int>0x2007</int>	<!-- FIGURE SPACE -->
			<int>0x2008</int>	<!-- PUNCTUATION SPACE -->
			<int>0x2009</int>	<!-- THIN SPACE -->
			<int>0x200A</int>	<!-- HAIR SPACE -->
			<int>0x200B</int>	<!-- ZERO WIDTH SPACE -->
			<int>0x200C</int>	<!-- ZERO WIDTH NON-JOINER -->
			<int>0x200D</int>	<!-- ZERO WIDTH JOINER -->
			<int>0x200E</int>	<!-- LEFT-TO-RIGHT MARK -->
			<int>0x200F</int>	<!-- RIGHT-TO-LEFT MARK -->
			<int>0x2028</int>	<!-- LINE SEPARATOR -->
			<int>0x2029</int>	<!-- PARAGRAPH SEPARATOR -->
			<int>0x202A</int>	<!-- LEFT-TO-RIGHT EMBEDDING -->
			<int>0x202B</int>	<!-- RIGHT-TO-LEFT EMBEDDING -->
			<int>0x202C</int>	<!-- POP DIRECTIONAL FORMATTING -->
			<int>0x202D</int>	<!-- LEFT-TO-RIGHT OVERRIDE -->
			<int>0x202E</int>	<!-- RIGHT-TO-LEFT OVERRIDE -->
			<int>0x202F</int>	<!-- NARROW NO-BREAK SPACE -->
			<int>0x205F</int>	<!-- MEDIUM MATHEMATICAL SPACE -->
			<int>0x2060</int>	<!-- WORD JOINER -->
			<int>0x2061</int>	<!-- FUNCTION APPLICATION -->
			<int>0x2062</int>	<!-- INVISIBLE TIMES -->
			<int>0x2063</int>	<!-- INVISIBLE SEPARATOR -->
			<int>0x206A</int>	<!-- INHIBIT SYMMETRIC SWAPPING -->
			<int>0x206B</int>	<!-- ACTIVATE SYMMETRIC SWAPPING -->
			<int>0x206C</int>	<!-- INHIBIT ARABIC FORM SHAPING -->
			<int>0x206D</int>	<!-- ACTIVATE ARABIC FORM SHAPING -->
			<int>0x206E</int>	<!-- NATIONAL DIGIT SHAPES -->
			<int>0x206F</int>	<!-- NOMINAL DIGIT SHAPES -->
			<int>0x2800</int>	<!-- BRAILLE PATTERN BLANK -->
			<int>0x3000</int>	<!-- IDEOGRAPHIC SPACE -->
			<int>0x3164</int>	<!-- HANGUL FILLER -->
			<int>0xFEFF</int>	<!-- ZERO WIDTH NO-BREAK SPACE -->
			<int>0xFFA0</int>	<!-- HALFWIDTH HANGUL FILLER -->
			<int>0xFFF9</int>	<!-- INTERLINEAR ANNOTATION ANCHOR -->
			<int>0xFFFA</int>	<!-- INTERLINEAR ANNOTATION SEPARATOR -->
			<int>0xFFFB</int>	<!-- INTERLINEAR ANNOTATION TERMINATOR -->
		</blank>
<!--
  Rescan configuration every 30 seconds when FcFontSetList is called
 -->
		<rescan>
			<int>30</int>
		</rescan>
	</config>

</fontconfig>
"

(* Test: Fonts.lns *)
test Fonts.lns get conf =
  { "#declaration"
    { "#attribute"
      { "version" = "1.0" }
    }
  }
  { "!DOCTYPE" = "fontconfig"
    { "SYSTEM" = "fonts.dtd" }
  }
  { "#comment" = " /etc/fonts/fonts.conf file to configure system font access " }
  { "fontconfig"
    { "#text" = "

" }
    { "#comment" = "
	DO NOT EDIT THIS FILE.
	IT WILL BE REPLACED WHEN FONTCONFIG IS UPDATED.
	LOCAL CHANGES BELONG IN 'local.conf'.

	The intent of this standard configuration file is to be adequate for
	most environments.  If you have a reasonably normal environment and
	have found problems with this configuration, they are probably
	things that others will also want fixed.  Please submit any
	problems to the fontconfig bugzilla system located at fontconfig.org

	Note that the normal 'make install' procedure for fontconfig is to
	replace any existing fonts.conf file with the new version.  Place
	any local customizations in local.conf which this file references.

	Keith Packard
" }
    { "#text" = "

" }
    { "#comment" = " Font directory list " }
    { "#text" = "

	" }
    { "dir"
      { "#text" = "/usr/share/fonts" }
    }
    { "#text" = "	" }
    { "dir"
      { "#text" = "/usr/X11R6/lib/X11/fonts" }
    }
    { "#text" = " " }
    { "dir"
      { "#text" = "/usr/local/share/fonts" }
    }
    { "#text" = "	" }
    { "dir"
      { "#text" = "~/.fonts" }
    }
    { "#text" = "
" }
    { "#comment" = "
  Accept deprecated 'mono' alias, replacing it with 'monospace'
" }
    { "#text" = "
	" }
    { "match"
      { "#attribute"
        { "target" = "pattern" }
      }
      { "#text" = "
		" }
      { "test"
        { "#attribute"
          { "qual" = "any" }
          { "name" = "family" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "mono" }
        }
        { "#text" = "		" }
      }
      { "#text" = "		" }
      { "edit"
        { "#attribute"
          { "name" = "family" }
          { "mode" = "assign" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "monospace" }
        }
        { "#text" = "		" }
      }
      { "#text" = "	" }
    }
    { "#text" = "
" }
    { "#comment" = "
  Accept alternate 'sans serif' spelling, replacing it with 'sans-serif'
" }
    { "#text" = "
	" }
    { "match"
      { "#attribute"
        { "target" = "pattern" }
      }
      { "#text" = "
		" }
      { "test"
        { "#attribute"
          { "qual" = "any" }
          { "name" = "family" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "sans serif" }
        }
        { "#text" = "		" }
      }
      { "#text" = "		" }
      { "edit"
        { "#attribute"
          { "name" = "family" }
          { "mode" = "assign" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "sans-serif" }
        }
        { "#text" = "		" }
      }
      { "#text" = "	" }
    }
    { "#text" = "
" }
    { "#comment" = "
  Accept deprecated 'sans' alias, replacing it with 'sans-serif'
" }
    { "#text" = "
	" }
    { "match"
      { "#attribute"
        { "target" = "pattern" }
      }
      { "#text" = "
		" }
      { "test"
        { "#attribute"
          { "qual" = "any" }
          { "name" = "family" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "sans" }
        }
        { "#text" = "		" }
      }
      { "#text" = "		" }
      { "edit"
        { "#attribute"
          { "name" = "family" }
          { "mode" = "assign" }
        }
        { "#text" = "
			" }
        { "string"
          { "#text" = "sans-serif" }
        }
        { "#text" = "		" }
      }
      { "#text" = "	" }
    }
    { "#text" = "
" }
    { "#comment" = "
  Load local system customization file
" }
    { "#text" = "
	" }
    { "include"
      { "#attribute"
        { "ignore_missing" = "yes" }
      }
      { "#text" = "conf.d" }
    }
    { "#text" = "
" }
    { "#comment" = " Font cache directory list " }
    { "#text" = "

	" }
    { "cachedir"
      { "#text" = "/var/cache/fontconfig" }
    }
    { "#text" = "	" }
    { "cachedir"
      { "#text" = "~/.fontconfig" }
    }
    { "#text" = "
	" }
    { "config"
      { "#text" = "
" }
      { "#comment" = "
  These are the default Unicode chars that are expected to be blank
  in fonts.  All other blank chars are assumed to be broken and
  won't appear in the resulting charsets
 " }
      { "#text" = "
		" }
      { "blank"
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x0020" }
        }
        { "#text" = "	" }
        { "#comment" = " SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x00A0" }
        }
        { "#text" = "	" }
        { "#comment" = " NO-BREAK SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x00AD" }
        }
        { "#text" = "	" }
        { "#comment" = " SOFT HYPHEN " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x034F" }
        }
        { "#text" = "	" }
        { "#comment" = " COMBINING GRAPHEME JOINER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x0600" }
        }
        { "#text" = "	" }
        { "#comment" = " ARABIC NUMBER SIGN " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x0601" }
        }
        { "#text" = "	" }
        { "#comment" = " ARABIC SIGN SANAH " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x0602" }
        }
        { "#text" = "	" }
        { "#comment" = " ARABIC FOOTNOTE MARKER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x0603" }
        }
        { "#text" = "	" }
        { "#comment" = " ARABIC SIGN SAFHA " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x06DD" }
        }
        { "#text" = "	" }
        { "#comment" = " ARABIC END OF AYAH " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x070F" }
        }
        { "#text" = "	" }
        { "#comment" = " SYRIAC ABBREVIATION MARK " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x115F" }
        }
        { "#text" = "	" }
        { "#comment" = " HANGUL CHOSEONG FILLER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x1160" }
        }
        { "#text" = "	" }
        { "#comment" = " HANGUL JUNGSEONG FILLER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x1680" }
        }
        { "#text" = "	" }
        { "#comment" = " OGHAM SPACE MARK " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x17B4" }
        }
        { "#text" = "	" }
        { "#comment" = " KHMER VOWEL INHERENT AQ " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x17B5" }
        }
        { "#text" = "	" }
        { "#comment" = " KHMER VOWEL INHERENT AA " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x180E" }
        }
        { "#text" = "	" }
        { "#comment" = " MONGOLIAN VOWEL SEPARATOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2000" }
        }
        { "#text" = "	" }
        { "#comment" = " EN QUAD " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2001" }
        }
        { "#text" = "	" }
        { "#comment" = " EM QUAD " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2002" }
        }
        { "#text" = "	" }
        { "#comment" = " EN SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2003" }
        }
        { "#text" = "	" }
        { "#comment" = " EM SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2004" }
        }
        { "#text" = "	" }
        { "#comment" = " THREE-PER-EM SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2005" }
        }
        { "#text" = "	" }
        { "#comment" = " FOUR-PER-EM SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2006" }
        }
        { "#text" = "	" }
        { "#comment" = " SIX-PER-EM SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2007" }
        }
        { "#text" = "	" }
        { "#comment" = " FIGURE SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2008" }
        }
        { "#text" = "	" }
        { "#comment" = " PUNCTUATION SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2009" }
        }
        { "#text" = "	" }
        { "#comment" = " THIN SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200A" }
        }
        { "#text" = "	" }
        { "#comment" = " HAIR SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200B" }
        }
        { "#text" = "	" }
        { "#comment" = " ZERO WIDTH SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200C" }
        }
        { "#text" = "	" }
        { "#comment" = " ZERO WIDTH NON-JOINER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200D" }
        }
        { "#text" = "	" }
        { "#comment" = " ZERO WIDTH JOINER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200E" }
        }
        { "#text" = "	" }
        { "#comment" = " LEFT-TO-RIGHT MARK " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x200F" }
        }
        { "#text" = "	" }
        { "#comment" = " RIGHT-TO-LEFT MARK " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2028" }
        }
        { "#text" = "	" }
        { "#comment" = " LINE SEPARATOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2029" }
        }
        { "#text" = "	" }
        { "#comment" = " PARAGRAPH SEPARATOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202A" }
        }
        { "#text" = "	" }
        { "#comment" = " LEFT-TO-RIGHT EMBEDDING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202B" }
        }
        { "#text" = "	" }
        { "#comment" = " RIGHT-TO-LEFT EMBEDDING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202C" }
        }
        { "#text" = "	" }
        { "#comment" = " POP DIRECTIONAL FORMATTING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202D" }
        }
        { "#text" = "	" }
        { "#comment" = " LEFT-TO-RIGHT OVERRIDE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202E" }
        }
        { "#text" = "	" }
        { "#comment" = " RIGHT-TO-LEFT OVERRIDE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x202F" }
        }
        { "#text" = "	" }
        { "#comment" = " NARROW NO-BREAK SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x205F" }
        }
        { "#text" = "	" }
        { "#comment" = " MEDIUM MATHEMATICAL SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2060" }
        }
        { "#text" = "	" }
        { "#comment" = " WORD JOINER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2061" }
        }
        { "#text" = "	" }
        { "#comment" = " FUNCTION APPLICATION " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2062" }
        }
        { "#text" = "	" }
        { "#comment" = " INVISIBLE TIMES " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2063" }
        }
        { "#text" = "	" }
        { "#comment" = " INVISIBLE SEPARATOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206A" }
        }
        { "#text" = "	" }
        { "#comment" = " INHIBIT SYMMETRIC SWAPPING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206B" }
        }
        { "#text" = "	" }
        { "#comment" = " ACTIVATE SYMMETRIC SWAPPING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206C" }
        }
        { "#text" = "	" }
        { "#comment" = " INHIBIT ARABIC FORM SHAPING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206D" }
        }
        { "#text" = "	" }
        { "#comment" = " ACTIVATE ARABIC FORM SHAPING " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206E" }
        }
        { "#text" = "	" }
        { "#comment" = " NATIONAL DIGIT SHAPES " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x206F" }
        }
        { "#text" = "	" }
        { "#comment" = " NOMINAL DIGIT SHAPES " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x2800" }
        }
        { "#text" = "	" }
        { "#comment" = " BRAILLE PATTERN BLANK " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x3000" }
        }
        { "#text" = "	" }
        { "#comment" = " IDEOGRAPHIC SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0x3164" }
        }
        { "#text" = "	" }
        { "#comment" = " HANGUL FILLER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0xFEFF" }
        }
        { "#text" = "	" }
        { "#comment" = " ZERO WIDTH NO-BREAK SPACE " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0xFFA0" }
        }
        { "#text" = "	" }
        { "#comment" = " HALFWIDTH HANGUL FILLER " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0xFFF9" }
        }
        { "#text" = "	" }
        { "#comment" = " INTERLINEAR ANNOTATION ANCHOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0xFFFA" }
        }
        { "#text" = "	" }
        { "#comment" = " INTERLINEAR ANNOTATION SEPARATOR " }
        { "#text" = "
			" }
        { "int"
          { "#text" = "0xFFFB" }
        }
        { "#text" = "	" }
        { "#comment" = " INTERLINEAR ANNOTATION TERMINATOR " }
        { "#text" = "
		" }
      }
      { "#comment" = "
  Rescan configuration every 30 seconds when FcFontSetList is called
 " }
      { "#text" = "
		" }
      { "rescan"
        { "#text" = "
			" }
        { "int"
          { "#text" = "30" }
        }
        { "#text" = "		" }
      }
      { "#text" = "	" }
    }
    { "#text" = "
" }
  }

