% REGISTRIES(1) 
% Brent Baude
% May 2017
# NAME
registries - parses a TOML configuration file for registries

# SYNOPSIS
**registries**
[**-h**|**--help**]
[**-i**][**--input**]
[**-j**][**--json**]
[**-o**][**--output**]
[**-V**][**--variable**]

# DESCRIPTION
**registries** parses a TOML configuration file about registries and has the
ability to output in string or JSON formats.  By default, `registries` will
put its output to stdout in string format.  The output is primarily for other
programs.

# OPTIONS:
**-h** **--help**
Print usage statement

**-i** **--input**
Allows you to specify a different path and name for a YAML input file.  It 
overrides the default configuration file of `/etc/containers/registries.conf`.

**-j** **--json**
Specifies the output be in JSON format.  The default is to output as a string.

**-o** **--output**
Redirects the output from stdout to a file. This option is useful when your
program requires its input come from a file (i.e. Systemd Environment files).

**-V** **--variable**
This option allows you to specify a variable name in the final output.  The contents
of the variable will also be quoted.  It can only be used when writing to 
an output file.  For example, a `--variable` of
`REGISTRIES` will result in the output format to be like:
```
     REGISTRIES="OUTPUT"
```
This option is useful for putting the contents into a SystemD Environment file
for use by a SystemD service.

# EXAMPLES

To parse the default file location and obtain a result to stdout in string
format:
```
# registries
```

To parse the default file location and obtain a result to stdout as JSON:
```
# registries -j
```

To parse the default file location and write the results to a file and insert
a variable that can be exported.
```
# registries -o /tmp/foo -V registries
```

You can also use the -i command line switch to read in a file other than the
default input file:
```
# registries -i /tmp/new_file
```

# MIGRATION FROM YAML
The initial registries.conf files were based on a YAML structure.  This version  of registries
still supports reading YAML.  However, you should preferably migrate the YAML to TOML.
To do this, make a back up copy of `/etc/containers/registries.conf`.  Then run the
registries_migrator tool which will output in the TOML format.  Verify the output
looks correct and then pipe it to `/etc/containers/registries.conf`.  For example:

```
# /usr/libexec/registries_migrator > /etc/containers/registries.conf

```

# HISTORY
May 2017, Originally compiled by Brent Baude (bbaude at redhat dot com)

