/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2012-2017 the original author or authors.
 */
package org.assertj.core.api.charsequence;

import static org.mockito.Mockito.verify;

import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.CharSequenceAssertBaseTest;

/**
 * Tests for <code>{@link org.assertj.core.api.CharSequenceAssert#isEqualToIgnoringWhitespace(CharSequence)}</code>.
 *
 * @author Alexander Bischof
 */
public class CharSequenceAssert_isEqualToIgnoringWhitespace_Test extends CharSequenceAssertBaseTest {

  @Override
  protected CharSequenceAssert invoke_api_method() {
    return assertions.isEqualToIgnoringWhitespace(" my foo bar ");
  }

  @Override
  protected void verify_internal_effects() {
    verify(strings).assertEqualsIgnoringWhitespace(getInfo(assertions), getActual(assertions), " my foo bar ");
  }
}
