/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.ivy.osgi.core;

import org.apache.ivy.osgi.util.VersionRange;

public class BundleRequirement {

    private final String name;

    private final String resolution;

    private final VersionRange version;

    private final String type;

    public BundleRequirement(String type, String name, VersionRange version, String resolution) {
        this.type = type;
        this.name = name;
        this.version = version;
        this.resolution = resolution;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public VersionRange getVersion() {
        return version;
    }

    public String getResolution() {
        return resolution;
    }

    public String toString() {
        return name + (version == null ? "" : ";" + version)
                + (resolution == null ? "" : " (" + resolution + ")");
    }

    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((resolution == null) ? 0 : resolution.hashCode());
        result = prime * result + ((version == null) ? 0 : version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleRequirement)) {
            return false;
        }
        BundleRequirement other = (BundleRequirement) obj;
        if (type == null) {
            if (other.type != null) {
                return false;
            }
        } else if (!type.equals(other.type)) {
            return false;
        }
        if (name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!name.equals(other.name)) {
            return false;
        }
        if (resolution == null) {
            if (other.resolution != null) {
                return false;
            }
        } else if (!resolution.equals(other.resolution)) {
            return false;
        }
        return version == null ? other.version == null : version.equals(other.version);
    }
}
