import os
import sys
import re

param_docs = {
    "ccache": "The local ccache",
    "installer_ccache": "The installer ccache setting",
    "_top_dir": "The installer _top_dir setting",
    "_ca_enabled": "The installer _ca_enabled setting",
    "_add_to_ipaservers": "The installer _add_to_ipaservers setting",
    "_ca_subject": "The installer _ca_subject setting",
    "_subject_base": "The installer _subject_base setting",
    "config_setup_ca": "The config setup_ca setting",
    "config_master_host_name": "The config master_host_name setting",
    "config_ca_host_name": "The config ca_host_name setting",
    "config_ips": "The config ips setting",
    "_ca_file": "The installer _ca_file setting",
    "_kra_enabled": "The installer _kra_enabled setting",
    "_dirsrv_pkcs12_info": "The installer _dirsrv_pkcs12_info setting",
    "_pkinit_pkcs12_info": "The installer _pkinit_pkcs12_info setting",
    "_http_pkcs12_info": "The installer _http_pkcs12_info setting",
    "ds_ca_subject": "The ds.ca_subject setting",
    "ca_subject": "The installer ca_subject setting",
    "_hostname_overridden": "The installer _hostname_overridden setting",
    "_kra_host_name": "The installer _kra_host_name setting",
    "_http_ca_cert": "The installer _http_ca_cert setting",
    "_update_hosts_file": "The installer _update_host_file setting",
    "sssd": "The installer sssd setting",
    "dnsok": "The installer dnsok setting",

    "dm_password":  "Directory Manager password",
    "password": "Admin user kerberos password",
    "ip_addresses": "List of Master Server IP Addresses",
    "domain": "Primary DNS domain of the IPA deployment",
    "realm": "Kerberos realm name of the IPA deployment",
    "hostname": "Fully qualified name of this host",
    "ca_cert_file": [
        "A CA certificate to use. Do not acquire the IPA CA certificate via",
        "automated means"
    ],
    "ca_cert_files": [
        "List of files containing CA certificates for the service certificate",
        "files"
    ],
    "no_host_dns": "Do not use DNS for hostname lookup during installation",
    "setup_adtrust": "Configure AD trust capability",
    "setup_ca": "Configure a dogtag CA",
    "setup_kra": "Configure a dogtag KRA",
    "setup_dns": "Configure bind with our zone",
    "dirserv_cert_files": [
        "File containing the Directory Server SSL certificate and private key"
    ],
    "force_join": "Force client enrollment even if already enrolled",
    "subject_base": [
        "The certificate subject base (default O=<realm-name>).",
        "RDNs are in LDAP order (most specific RDN first)."
    ],
    "server": "Fully qualified name of IPA server to enroll to",
    "dirman_password": "Directory Manager (master) password",
    "no_pkinit": "Disable pkinit setup steps",
    "no_ui_redirect": "Do not automatically redirect to the Web UI",
    "external_ca": "External ca setting",
    "setup_adtrust": "Configure AD trust capability",
    "external_cert_files": [
        "File containing the IPA CA certificate and the external CA certificate",
        "chain"
    ],
    "reverse_zones": "The reverse DNS zones to use",
    "no_reverse": "Do not create new reverse DNS zone",
    "auto_reverse": "Create necessary reverse zones",
    "forwarders": "Add DNS forwarders",
    "no_forwarders": "Do not add any DNS forwarders, use root servers instead",
    "auto_forwarders": "Use DNS forwarders configured in /etc/resolv.conf",
    "forward_policy": "DNS forwarding policy for global forwarders",
    "enable_compat": "Enable support for trusted domains for old clients",
    "netbios_name": "NetBIOS name of the IPA domain",
    "rid_base": "Start value for mapping UIDs and GIDs to RIDs",
    "secondary_rid_base": [
        "Start value of the secondary range for mapping UIDs and GIDs to RIDs"
    ],
    "pki_config_override": "Path to ini file with config overrides",
    "servers": "Fully qualified name of IPA servers to enroll to",
    "hidden_replica": "Install a hidden replica",
    "dirsrv_config_file": [
        "The path to LDIF file that will be used to modify configuration of",
        "dse.ldif during installation of the directory server instance"
    ],
    "dirsrv_cert_files": [
        "Files containing the Directory Server SSL certificate and private key"
    ],
    "http_cert_files": [
        "File containing the Apache Server SSL certificate and private key"
    ],
    "pkinit_cert_files": [
        "File containing the Kerberos KDC SSL certificate and private key"
    ],
    "no_ntp": "Do not configure ntp",
    "ntp_servers": "ntp servers to use",
    "ntp_pool": "ntp server pool to use",
    "no_dnssec_validation": "Disable DNSSEC validation",
    "master": "Master host name",
    "master_password": "kerberos master password (normally autogenerated)",
    "principal": [
        "User Principal allowed to promote replicas and join IPA realm"
    ],
    "dirsrv_pin": "The password to unlock the Directory Server private key",
    "http_pin": "The password to unlock the Apache Server private key",
    "pkinit_pin": "The password to unlock the Kerberos KDC private key",
    "dirsrv_cert_name": "Name of the Directory Server SSL certificate to install",
    "http_cert_name": "Name of the Apache Server SSL certificate to install",
    "pkinit_cert_name": "Name of the Kerberos KDC SSL certificate to install",
    "keytab": "Path to backed up keytab from previous enrollment",
    "mkhomedir": "Create home directories for users on their first login",
    "adtrust_netbios_name": "The adtrust netbios_name setting",
    "adtrust_reset_netbios_name": "The adtrust reset_netbios_name setting",
    "zonemgr": "DNS zone manager e-mail address. Defaults to hostmaster@DOMAIN",
    "ssh_trust_dns": "Configure OpenSSH client to trust DNS SSHFP records",
    "dns_ip_addresses": "The dns ip_addresses setting",
    "dns_reverse_zones": "The dns reverse_zones setting",
    "no_ssh": "Do not configure OpenSSH client",
    "no_sshd": "Do not configure OpenSSH server",
    "no_dns_sshfp": "Do not automatically create DNS SSHFP records",
    "allow_zone_overlap": "Create DNS zone even if it already exists",
    "skip_conncheck": "Skip connection check to remote master",
    "idstart": "The starting value for the IDs range (default random)",
    "idmax": "The max value for the IDs range (default: idstart+199999)",
    "no_hbac_allow": "Don't install allow_all HBAC rule",
    "domainlevel": "The domain level",
    "external_ca_type": "Type of the external CA",
    "external_ca_profile": [
        "Specify the certificate profile/template to use at the external CA"
    ],
    "force": "Installer force parameter",
    "ca_signing_algorithm": "Signing algorithm of the IPA CA certificate",
    "debug": "Turn on extra debugging",
    "basedn": "The basedn of the IPA server (of the form dc=example,dc=com)",
    "allow_repair": [
        "Allow repair of already joined hosts. Contrary to ipaclient_force_join",
        "the host entry will not be changed on the server"
    ],
    "backup": "File to backup",
    "fqdn": [
        "The fully-qualified hostname of the host to add/modify/remove"
    ],
    "certificates": "A list of host certificates",
    "sshpubkey": "The SSH public key for the host",
    "ipaddress": "The IP address for the host",
    "random": "Generate a random password to be used in bulk enrollment",
    "state": "The desired host state",
    "kdc": "The name or address of the host running the KDC",
    "admin_keytab": "The path to a local admin keytab",
    "kinit_attempts": "Repeat the request for host Kerberos ticket X times",
    "automount_location": "The automount location",
    "firefox_dir": [
        "Specify directory where Firefox is installed (for example",
        "'/usr/lib/firefox')"
    ],
    "client_domain": "Primary DNS domain of the IPA deployment",
    "nisdomain": "The NIS domain name",
    "ca_enabled": "Whether the Certificate Authority is enabled or not",
    "on_master": "Whether the configuration is done on the master or not",
    "enable_dns_updates": [
        "Configures the machine to attempt dns updates when the ip address",
        "changes"
    ],
    "all_ip_addresses": [
        "All routable IP addresses configured on any interface will be added",
        "to DNS"
    ],
    "request_cert": "Request certificate for the machine",
    "preserve_sssd": "Preserve old SSSD configuration if possible",
    "no_sudo": "Do not configure SSSD as data source for sudo",
    "fixed_primary": "Configure sssd to use fixed server as primary IPA server",
    "permit": "Disable access rules by default, permit all access",
    "no_krb5_offline_passwords": [
        "Configure SSSD not to store user password when the server is offline"
    ],
    "force_ntpd": [
        "Stop and disable any time&date synchronization services besides ntpd",
        "Deprecated since 4.7"
    ],
    "no_nisdomain": "Do not configure NIS domain name",
    "configure_firefox": "Configure Firefox to use IPA domain credentials",
}


def gen_module_docs(module_in):
    lines = [ ]

    with open(module_in) as in_f:
        in_lines = in_f.readlines()

    arg_spec = False
    args = []
    i = 0
    while i < len(in_lines):
        line = in_lines[i]
        stripped = line.strip()
        #print("stripped: %s" % repr(stripped))
        if stripped.startswith("# "):
            pass
        elif stripped.startswith("argument_spec=dict()"):
            pass
        elif stripped.startswith("argument_spec=dict("):
            arg_spec = True
        elif stripped.startswith("),") and arg_spec:
            arg_spec = False
        elif arg_spec:
            #if not "dict=(" in stripped:
            #    print("%s: Bad argument dict line '%s'" % (module_in,
            #                                               stripped))
            while ")," not in stripped and i < len(in_lines) - 1:
                next_stripped = in_lines[i+1].strip()
                if not next_stripped.startswith("# "):
                    stripped += next_stripped
                i += 1
            #print("stripped: '%s'" % stripped)

            try:
                param, _dict = stripped.split("=", 1)
            except:
                print("Failed to split line '%s'" % stripped)
                sys.exit(1)

            #print("_dict: '%s'" % _dict)
            if not _dict.startswith("dict(") or not _dict.endswith("),"):
                print("%s: Bad argument dict line 2 '%s'" % (module_in, _dict))
                sys.exit(1)
            else:
                _dict = _dict[5:-2]

            if param not in param_docs:
                print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                print("%s: param '%s' is not in param_docs" % (module_in, param))
                print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                sys.exit(1)
                
            #print("param: '%s', dict: '%s'" % (param, _dict))

            opts = _dict.split(',')
            opts = [ o.strip() for o in opts ]
            required = False
            #no_log = False
            if "required=True" in opts:
                required = True
            #if "no_log=True" in opts:
            #    no_log = True
            
            #args.append([param, required, no_log])
            args.append([param, required])
        i += 1

    #print("%s: %s" % (module_in, repr(args)))

    def add_options(args):
        for param, required in args:
            out_lines.append("  %s:\n" % param)
            if isinstance(param_docs[param], list):
                out_lines.append("    description:\n")
                for x in param_docs[param]:
                    out_lines.append("      %s\n" % x)
            else:
                out_lines.append("    description: %s\n" % param_docs[param])
            out_lines.append("    required: %s\n" % ("yes","no")[required])
    
    out_lines = []
    options = False
    in_options = False
    changed = False
    docs = False
    for line in in_lines:
        stripped = line.strip()
        if stripped.startswith("DOCUMENTATION = '''"):
            docs = True
        elif stripped.startswith("options:"):
            out_lines.append(line)
            add_options(args)
            options = True
            in_options = True
            changed = True
            continue
        elif stripped.startswith("author:"):
            if not options:
                add_options(args)
                options = True
                changed = True
            in_options = False
        elif stripped.startswith("'''"):
            if not options:
                add_options(args)
                options = True
                changed = True
            in_options = False
            docs = False
        elif docs and in_options:
            continue

        out_lines.append(line)

    print(module_in)
    #for line in out_lines:
    #    sys.stdout.write(line)

    if changed:
        with open(module_in, "w") as out_f:
            for line in out_lines:
                out_f.write(line)

gen_module_docs(sys.argv[1])
