/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright(c) 2019 Intel Corporation. All rights reserved. */
#ifndef _IAA_COMPRESS_H_
#define _IAA_COMPRESS_H_

#include <stdint.h>
#include <stdbool.h>

#define IAA_COMPRESS_AECS_SIZE (1568)
#define IAA_COMPRESS_SRC2_SIZE (IAA_COMPRESS_AECS_SIZE * 2)
#define IAA_COMPRESS_MAX_DEST_SIZE (2097152 * 2)
#define IAA_DECOMPRESS_AECS_SIZE (5376)
#define IAA_DECOMPRESS_SRC2_SIZE (IAA_DECOMPRESS_AECS_SIZE * 2)
#define IAA_DECOMPRESS_MAX_DEST_SIZE (2097152 * 2)

static const uint32_t iaa_compress_aecs[IAA_COMPRESS_AECS_SIZE / 4] = {
0x12345678, // crc
0x0000abcd, // XOR Checksum
0x00000000, // Reserved
0x00000000, // Reserved
0x00000000, // Reserved
0x00000000, // Reserved
0x00000000, // Reserved
0x00000003, // Num Acc Bits Valid
0x00000003, // Output Accumulator Data start
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000, // Output Accumulator Data end
0x00040030, // Huffman Literal Code 0 start
0x00040031,
0x00040032,
0x00040033,
0x00040034,
0x00040035,
0x00040036,
0x00040037,
0x00040038,
0x00040039,
0x0004003A,
0x0004003B,
0x0004003C,
0x0004003D,
0x0004003E,
0x0004003F,
0x00040040,
0x00040041,
0x00040042,
0x00040043,
0x00040044,
0x00040045,
0x00040046,
0x00040047,
0x00040048,
0x00040049,
0x0004004A,
0x0004004B,
0x0004004C,
0x0004004D,
0x0004004E,
0x0004004F,
0x00040050,
0x00040051,
0x00040052,
0x00040053,
0x00040054,
0x00040055,
0x00040056,
0x00040057,
0x00040058,
0x00040059,
0x0004005A,
0x0004005B,
0x0004005C,
0x0004005D,
0x0004005E,
0x0004005F,
0x00040060,
0x00040061,
0x00040062,
0x00040063,
0x00040064,
0x00040065,
0x00040066,
0x00040067,
0x00040068,
0x00040069,
0x0004006A,
0x0004006B,
0x0004006C,
0x0004006D,
0x0004006E,
0x0004006F,
0x00040070,
0x00040071,
0x00040072,
0x00040073,
0x00040074,
0x00040075,
0x00040076,
0x00040077,
0x00040078,
0x00040079,
0x0004007A,
0x0004007B,
0x0004007C,
0x0004007D,
0x0004007E,
0x0004007F,
0x00040080,
0x00040081,
0x00040082,
0x00040083,
0x00040084,
0x00040085,
0x00040086,
0x00040087,
0x00040088,
0x00040089,
0x0004008A,
0x0004008B,
0x0004008C,
0x0004008D,
0x0004008E,
0x0004008F,
0x00040090,
0x00040091,
0x00040092,
0x00040093,
0x00040094,
0x00040095,
0x00040096,
0x00040097,
0x00040098,
0x00040099,
0x0004009A,
0x0004009B,
0x0004009C,
0x0004009D,
0x0004009E,
0x0004009F,
0x000400A0,
0x000400A1,
0x000400A2,
0x000400A3,
0x000400A4,
0x000400A5,
0x000400A6,
0x000400A7,
0x000400A8,
0x000400A9,
0x000400AA,
0x000400AB,
0x000400AC,
0x000400AD,
0x000400AE,
0x000400AF,
0x000400B0,
0x000400B1,
0x000400B2,
0x000400B3,
0x000400B4,
0x000400B5,
0x000400B6,
0x000400B7,
0x000400B8,
0x000400B9,
0x000400BA,
0x000400BB,
0x000400BC,
0x000400BD,
0x000400BE,
0x000400BF,
0x00048190,
0x00048191,
0x00048192,
0x00048193,
0x00048194,
0x00048195,
0x00048196,
0x00048197,
0x00048198,
0x00048199,
0x0004819A,
0x0004819B,
0x0004819C,
0x0004819D,
0x0004819E,
0x0004819F,
0x000481A0,
0x000481A1,
0x000481A2,
0x000481A3,
0x000481A4,
0x000481A5,
0x000481A6,
0x000481A7,
0x000481A8,
0x000481A9,
0x000481AA,
0x000481AB,
0x000481AC,
0x000481AD,
0x000481AE,
0x000481AF,
0x000481B0,
0x000481B1,
0x000481B2,
0x000481B3,
0x000481B4,
0x000481B5,
0x000481B6,
0x000481B7,
0x000481B8,
0x000481B9,
0x000481BA,
0x000481BB,
0x000481BC,
0x000481BD,
0x000481BE,
0x000481BF,
0x000481C0,
0x000481C1,
0x000481C2,
0x000481C3,
0x000481C4,
0x000481C5,
0x000481C6,
0x000481C7,
0x000481C8,
0x000481C9,
0x000481CA,
0x000481CB,
0x000481CC,
0x000481CD,
0x000481CE,
0x000481CF,
0x000481D0,
0x000481D1,
0x000481D2,
0x000481D3,
0x000481D4,
0x000481D5,
0x000481D6,
0x000481D7,
0x000481D8,
0x000481D9,
0x000481DA,
0x000481DB,
0x000481DC,
0x000481DD,
0x000481DE,
0x000481DF,
0x000481E0,
0x000481E1,
0x000481E2,
0x000481E3,
0x000481E4,
0x000481E5,
0x000481E6,
0x000481E7,
0x000481E8,
0x000481E9,
0x000481EA,
0x000481EB,
0x000481EC,
0x000481ED,
0x000481EE,
0x000481EF,
0x000481F0,
0x000481F1,
0x000481F2,
0x000481F3,
0x000481F4,
0x000481F5,
0x000481F6,
0x000481F7,
0x000481F8,
0x000481F9,
0x000481FA,
0x000481FB,
0x000481FC,
0x000481FD,
0x000481FE,
0x000481FF,
0x00038000,
0x00038001,
0x00038002,
0x00038003,
0x00038004,
0x00038005,
0x00038006,
0x00038007,
0x00038008,
0x00038009,
0x0003800A,
0x0003800B,
0x0003800C,
0x0003800D,
0x0003800E,
0x0003800F,
0x00038010,
0x00038011,
0x00038012,
0x00038013,
0x00038014,
0x00038015,
0x00038016,
0x00038017,
0x000400C0,
0x000400C1,
0x000400C2,
0x000400C3,
0x000400C4,
0x000400C5, // Huffman Literal Code 0 end
0x00000000, // Reserved
0x00000000, // Reserved
0x00028000, // Huffman Distance Code 0 start
0x00028001,
0x00028002,
0x00028003,
0x00028004,
0x00028005,
0x00028006,
0x00028007,
0x00028008,
0x00028009,
0x0002800A,
0x0002800B,
0x0002800C,
0x0002800D,
0x0002800E,
0x0002800F,
0x00028010,
0x00028011,
0x00028012,
0x00028013,
0x00028014,
0x00028015,
0x00028016,
0x00028017,
0x00028018,
0x00028019,
0x0002801A,
0x0002801B,
0x0002801C,
0x0002801D, // Huffman Distance Code 0 end
0x00000000,
0x00000000,
};

int iaa_do_decompress(void *dst, void *src, int src_len, int *out_len);

#endif
