'''OpenGL extension ARB.vertex_array_object

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.vertex_array_object to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces named vertex array objects which encapsulate
	vertex array state on the client side.  These objects allow applications
	to rapidly switch between large sets of array state.  In addition, layered
	libraries can return to the default array state by simply creating and
	binding a new vertex array object.
	
	This extension differs from GL_APPLE_vertex_array_object in that client
	memory cannot be accessed through a non-zero vertex array object.  It also
	differs in that vertex array objects are explicitly not sharable between
	contexts.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/vertex_array_object.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.vertex_array_object import *
### END AUTOGENERATED SECTION