'''OpenGL extension ARB.multitexture

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.multitexture to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/multitexture.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.multitexture import *
### END AUTOGENERATED SECTION
for typ,arrayType in (
    ('d',arrays.GLdoubleArray),
    ('f',arrays.GLfloatArray),
    ('i',arrays.GLintArray),
    ('s',arrays.GLshortArray),
):
    for size in (1,2,3,4):
        name = 'glMultiTexCoord%(size)s%(typ)svARB'%globals()
        globals()[name] = arrays.setInputArraySizeType(
            globals()[name],
            size,
            arrayType, 
            'v',
        )
        del size,name
    del typ,arrayType