/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.UtilLoggingLevel;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LevelEqualsRule
extends AbstractRule {
    static final long serialVersionUID = -3638386582899583994L;
    private transient Level level;
    private static List levelList = new LinkedList();

    private LevelEqualsRule(Level level) {
        this.level = level;
    }

    private static void populateLevels() {
        levelList = new LinkedList();
        levelList.add(Level.FATAL.toString());
        levelList.add(Level.ERROR.toString());
        levelList.add(Level.WARN.toString());
        levelList.add(Level.INFO.toString());
        levelList.add(Level.DEBUG.toString());
        levelList.add(Level.TRACE.toString());
    }

    public static Rule getRule(String value) {
        Level thisLevel = null;
        thisLevel = levelList.contains(value.toUpperCase()) ? Level.toLevel(value.toUpperCase()) : UtilLoggingLevel.toLevel(value.toUpperCase());
        return new LevelEqualsRule(thisLevel);
    }

    public boolean evaluate(LoggingEvent event) {
        return this.level.equals(event.getLevel());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        LevelEqualsRule.populateLevels();
        boolean isUtilLogging = in.readBoolean();
        int levelInt = in.readInt();
        this.level = isUtilLogging ? UtilLoggingLevel.toLevel(levelInt) : Level.toLevel(levelInt);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.level instanceof UtilLoggingLevel);
        out.writeInt(this.level.toInt());
    }

    static {
        LevelEqualsRule.populateLevels();
    }
}

