/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEventListener;
import org.apache.log4j.spi.LoggerRepositoryEx;

public final class PluginRegistry {
    private final Map pluginMap;
    private final LoggerRepositoryEx loggerRepository;
    private final RepositoryListener listener = new RepositoryListener();
    private final List listenerList = Collections.synchronizedList(new ArrayList());

    public PluginRegistry(LoggerRepositoryEx loggerRepository) {
        this.pluginMap = new HashMap();
        this.loggerRepository = loggerRepository;
        this.loggerRepository.addLoggerRepositoryEventListener(this.listener);
    }

    public LoggerRepositoryEx getLoggerRepository() {
        return this.loggerRepository;
    }

    public boolean pluginNameExists(String name) {
        Map map = this.pluginMap;
        synchronized (map) {
            boolean bl = this.pluginMap.containsKey(name);
            return bl;
        }
    }

    public void addPlugin(Plugin plugin) {
        Map map = this.pluginMap;
        synchronized (map) {
            String name = plugin.getName();
            plugin.setLoggerRepository(this.getLoggerRepository());
            Plugin existingPlugin = (Plugin)this.pluginMap.get(name);
            if (existingPlugin != null) {
                existingPlugin.shutdown();
            }
            this.pluginMap.put(name, plugin);
            this.firePluginStarted(plugin);
        }
    }

    private void firePluginStarted(Plugin plugin) {
        PluginEvent e = null;
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                PluginListener listener = (PluginListener)iter.next();
                if (e == null) {
                    e = new PluginEvent(plugin);
                }
                listener.pluginStarted(e);
            }
        }
    }

    private void firePluginStopped(Plugin plugin) {
        PluginEvent e = null;
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                PluginListener listener = (PluginListener)iter.next();
                if (e == null) {
                    e = new PluginEvent(plugin);
                }
                listener.pluginStopped(e);
            }
        }
    }

    public List getPlugins() {
        Map map = this.pluginMap;
        synchronized (map) {
            ArrayList pluginList = new ArrayList(this.pluginMap.size());
            Iterator iter = this.pluginMap.values().iterator();
            while (iter.hasNext()) {
                pluginList.add(iter.next());
            }
            ArrayList arrayList = pluginList;
            return arrayList;
        }
    }

    public List getPlugins(Class pluginClass) {
        Map map = this.pluginMap;
        synchronized (map) {
            ArrayList pluginList = new ArrayList(this.pluginMap.size());
            Iterator iter = this.pluginMap.values().iterator();
            while (iter.hasNext()) {
                Object plugin = iter.next();
                if (!pluginClass.isInstance(plugin)) continue;
                pluginList.add(plugin);
            }
            ArrayList arrayList = pluginList;
            return arrayList;
        }
    }

    public Plugin stopPlugin(String pluginName) {
        Map map = this.pluginMap;
        synchronized (map) {
            Plugin plugin = (Plugin)this.pluginMap.get(pluginName);
            if (plugin == null) {
                Plugin plugin2 = null;
                return plugin2;
            }
            plugin.shutdown();
            this.pluginMap.remove(pluginName);
            this.firePluginStopped(plugin);
            Plugin plugin3 = plugin;
            return plugin3;
        }
    }

    public void stopAllPlugins() {
        Map map = this.pluginMap;
        synchronized (map) {
            this.loggerRepository.removeLoggerRepositoryEventListener(this.listener);
            Iterator iter = this.pluginMap.values().iterator();
            while (iter.hasNext()) {
                Plugin plugin = (Plugin)iter.next();
                plugin.shutdown();
                this.firePluginStopped(plugin);
            }
        }
    }

    public final void addPluginListener(PluginListener l) {
        this.listenerList.add(l);
    }

    public final void removePluginListener(PluginListener l) {
        this.listenerList.remove(l);
    }

    private class RepositoryListener
    implements LoggerRepositoryEventListener {
        private RepositoryListener() {
        }

        public void configurationResetEvent(LoggerRepository repository) {
            PluginRegistry.this.stopAllPlugins();
        }

        public void configurationChangedEvent(LoggerRepository repository) {
        }

        public void shutdownEvent(LoggerRepository repository) {
            PluginRegistry.this.stopAllPlugins();
        }
    }
}

