/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.boolex.Matcher;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.janino.ExpressionEvaluator;

public abstract class JaninoEventEvaluatorBase
extends ContextAwareBase
implements EventEvaluator,
LifeCycle {
    static Class EXPRESSION_TYPE = Boolean.TYPE;
    static Class[] THROWN_EXCEPTIONS = new Class[1];
    public static final int ERROR_THRESHOLD = 4;
    protected boolean start = false;
    private String name;
    private String expression;
    ExpressionEvaluator ee;
    private int errorCount = 0;
    protected List<Matcher> matcherList = new ArrayList<Matcher>();

    static {
        JaninoEventEvaluatorBase.THROWN_EXCEPTIONS[0] = EvaluationException.class;
    }

    protected abstract String getDecoratedExpression();

    protected abstract String[] getParameterNames();

    protected abstract Class[] getParameterTypes();

    protected abstract Object[] getParameterValues(Object var1);

    public boolean isStarted() {
        return this.start;
    }

    public void stop() {
        this.start = false;
    }

    public void start() {
        try {
            assert (this.context != null);
            ClassLoader cl = this.context.getClass().getClassLoader();
            this.ee = new ExpressionEvaluator(this.getDecoratedExpression(), EXPRESSION_TYPE, this.getParameterNames(), this.getParameterTypes(), THROWN_EXCEPTIONS, cl);
            this.start = true;
        }
        catch (Exception e) {
            this.addError("Could not start evaluator with expression [" + this.expression + "]", e);
        }
    }

    public boolean evaluate(Object event) throws EvaluationException {
        if (!this.start) {
            throw new IllegalStateException("Evaluator [" + this.name + "] was called in stopped state");
        }
        try {
            Boolean result = (Boolean)this.ee.evaluate(this.getParameterValues(event));
            return result;
        }
        catch (Exception ex) {
            ++this.errorCount;
            if (this.errorCount >= 4) {
                this.start = false;
            }
            throw new EvaluationException("Evaluator [" + this.name + "] caused an exception", ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("name has been already set");
        }
        this.name = name;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void addMatcher(Matcher matcher) {
        this.matcherList.add(matcher);
    }

    public List getMatcherList() {
        return this.matcherList;
    }
}

