/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreGlobal;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CallerDataConverter
extends ClassicConverter {
    int depth = 5;
    List<EventEvaluator> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    public void start() {
        String depthStr = this.getFirstOption();
        if (depthStr == null) {
            return;
        }
        try {
            this.depth = Integer.parseInt(depthStr);
        }
        catch (NumberFormatException nfe) {
            this.addError("");
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            int optionListSize = optionList.size();
            int i = 1;
            while (i < optionListSize) {
                Map evaluatorMap;
                EventEvaluator ee;
                String evaluatorStr = (String)optionList.get(i);
                Context context = this.getContext();
                if (context != null && (ee = (EventEvaluator)(evaluatorMap = (Map)context.getObject("EVALUATOR_MAP")).get(evaluatorStr)) != null) {
                    this.addEvaluator(ee);
                }
                ++i;
            }
        }
    }

    private void addEvaluator(EventEvaluator ee) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator>();
        }
        this.evaluatorList.add(ee);
    }

    public String convert(LoggingEvent le) {
        CallerData[] cda;
        StringBuffer buf = new StringBuffer();
        if (this.evaluatorList != null) {
            boolean printCallerData = false;
            int i = 0;
            while (i < this.evaluatorList.size()) {
                block9: {
                    EventEvaluator ee = this.evaluatorList.get(i);
                    try {
                        if (ee.evaluate((Object)le)) {
                            printCallerData = true;
                            break;
                        }
                    }
                    catch (EvaluationException eex) {
                        ++this.errorCount;
                        if (this.errorCount < 4) {
                            this.addError("Exception thrown for evaluator named [" + ee.getName() + "]", eex);
                        }
                        if (this.errorCount != 4) break block9;
                        ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + ee.getName() + "].", (Object)this, (Throwable)eex);
                        errorStatus.add((Status)new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", (Object)this));
                        this.addStatus((Status)errorStatus);
                    }
                }
                ++i;
            }
            if (!printCallerData) {
                return "";
            }
        }
        if ((cda = le.getCallerData()) != null && cda.length > 0) {
            int limit = this.depth < cda.length ? this.depth : cda.length;
            int i = 0;
            while (i < limit) {
                buf.append("Caller+");
                buf.append(i);
                buf.append("\t at ");
                buf.append(cda[i]);
                buf.append(CoreGlobal.LINE_SEPARATOR);
                ++i;
            }
            return buf.toString();
        }
        return CallerData.CALLER_DATA_NA;
    }
}

