/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.migrator.ConversionException;
import org.slf4j.migrator.FileSelector;
import org.slf4j.migrator.InplaceFileConverter;
import org.slf4j.migrator.RuleSetFactory;
import org.slf4j.migrator.internal.MigratorFrame;
import org.slf4j.migrator.internal.ProgressListener;
import org.slf4j.migrator.line.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConverter {
    private RuleSet ruleSet;
    private List<ConversionException> exception;
    ProgressListener progressListener;

    public static void main(String[] args) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MigratorFrame inst = new MigratorFrame();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public ProjectConverter(int conversionType, ProgressListener progressListener) {
        this.progressListener = progressListener;
        this.ruleSet = RuleSetFactory.getMatcherImpl(conversionType);
        if (this.ruleSet == null) {
            this.addException(new ConversionException("Conversion mode not implemented yet"));
        }
    }

    public void convertProject(File folder) {
        FileSelector fs = new FileSelector(this.progressListener);
        List<File> fileList = fs.selectJavaFilesInFolder(folder);
        this.scanFileList(fileList);
        this.progressListener.onDone();
    }

    private void scanFileList(List<File> lstFiles) {
        this.progressListener.onFileScanBegin();
        for (File currentFile : lstFiles) {
            this.progressListener.onFileScan(currentFile);
            this.scanFile(currentFile);
        }
    }

    private void scanFile(File file) {
        try {
            InplaceFileConverter fc = new InplaceFileConverter(this.ruleSet, this.progressListener);
            fc.convert(file);
        }
        catch (IOException exc) {
            this.addException(new ConversionException(exc.toString()));
        }
    }

    public void addException(ConversionException exc) {
        if (this.exception == null) {
            this.exception = new ArrayList<ConversionException>();
        }
        this.exception.add(exc);
    }

    public void printException() {
        if (this.exception != null) {
            for (ConversionException exc : this.exception) {
                exc.print();
            }
            this.exception = null;
        }
    }
}

