use std::slice::Iter;

use core::ColorInterface;
use HSL;

#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum Color {
    Black,
    Red,
    Green,
    Yellow,
    Blue,
    Magenta,
    Cyan,
    LightGray,
    DarkGray,
    LightRed,
    LightGreen,
    LightYellow,
    LightBlue,
    LightMagenta,
    LightCyan,
    White,
    Grey0,
    NavyBlue,
    DarkBlue,
    Blue3a,
    Blue3b,
    Blue1,
    DarkGreen,
    DeepSkyBlue4a,
    DeepSkyBlue4b,
    DeepSkyBlue4c,
    DodgerBlue3,
    DodgerBlue2,
    Green4,
    SpringGreen4,
    Turquoise4,
    DeepSkyBlue3a,
    DeepSkyBlue3b,
    DodgerBlue1,
    Green3a,
    SpringGreen3a,
    DarkCyan,
    LightSeaGreen,
    DeepSkyBlue2,
    DeepSkyBlue1,
    Green3b,
    SpringGreen3b,
    SpringGreen2a,
    Cyan3,
    DarkTurquoise,
    Turquoise2,
    Green1,
    SpringGreen2b,
    SpringGreen1,
    MediumSpringGreen,
    Cyan2,
    Cyan1,
    DarkRed1,
    DeepPink4a,
    Purple4a,
    Purple4b,
    Purple3,
    BlueViolet,
    Orange4a,
    Grey37,
    MediumPurple4,
    SlateBlue3a,
    SlateBlue3b,
    RoyalBlue1,
    Chartreuse4,
    DarkSeaGreen4a,
    PaleTurquoise4,
    SteelBlue,
    SteelBlue3,
    CornflowerBlue,
    Chartreuse3a,
    DarkSeaGreen4b,
    CadetBlue2,
    CadetBlue1,
    SkyBlue3,
    SteelBlue1a,
    Chartreuse3b,
    PaleGreen3a,
    SeaGreen3,
    Aquamarine3,
    MediumTurquoise,
    SteelBlue1b,
    Chartreuse2a,
    SeaGreen2,
    SeaGreen1a,
    SeaGreen1b,
    Aquamarine1a,
    DarkSlateGray2,
    DarkRed2,
    DeepPink4b,
    DarkMagenta1,
    DarkMagenta2,
    DarkViolet1a,
    Purple1a,
    Orange4b,
    LightPink4,
    Plum4,
    MediumPurple3a,
    MediumPurple3b,
    SlateBlue1,
    Yellow4a,
    Wheat4,
    Grey53,
    LightSlateGrey,
    MediumPurple,
    LightSlateBlue,
    Yellow4b,
    DarkOliveGreen3a,
    DarkGreenSea,
    LightSkyBlue3a,
    LightSkyBlue3b,
    SkyBlue2,
    Chartreuse2b,
    DarkOliveGreen3b,
    PaleGreen3b,
    DarkSeaGreen3a,
    DarkSlateGray3,
    SkyBlue1,
    Chartreuse1,
    LightGreen2,
    LightGreen3,
    PaleGreen1a,
    Aquamarine1b,
    DarkSlateGray1,
    Red3a,
    DeepPink4c,
    MediumVioletRed,
    Magenta3a,
    DarkViolet1b,
    Purple1b,
    DarkOrange3a,
    IndianRed1a,
    HotPink3a,
    MediumOrchid3,
    MediumOrchid,
    MediumPurple2a,
    DarkGoldenrod,
    LightSalmon3a,
    RosyBrown,
    Grey63,
    MediumPurple2b,
    MediumPurple1,
    Gold3a,
    DarkKhaki,
    NavajoWhite3,
    Grey69,
    LightSteelBlue3,
    LightSteelBlue,
    Yellow3a,
    DarkOliveGreen3,
    DarkSeaGreen3b,
    DarkSeaGreen2,
    LightCyan3,
    LightSkyBlue1,
    GreenYellow,
    DarkOliveGreen2,
    PaleGreen1b,
    DarkSeaGreen5b,
    DarkSeaGreen5a,
    PaleTurquoise1,
    Red3b,
    DeepPink3a,
    DeepPink3b,
    Magenta3b,
    Magenta3c,
    Magenta2a,
    DarkOrange3b,
    IndianRed1b,
    HotPink3b,
    HotPink2,
    Orchid,
    MediumOrchid1a,
    Orange3,
    LightSalmon3b,
    LightPink3,
    Pink3,
    Plum3,
    Violet,
    Gold3b,
    LightGoldenrod3,
    Tan,
    MistyRose3,
    Thistle3,
    Plum2,
    Yellow3b,
    Khaki3,
    LightGoldenrod2a,
    LightYellow3,
    Grey84,
    LightSteelBlue1,
    Yellow2,
    DarkOliveGreen1a,
    DarkOliveGreen1b,
    DarkSeaGreen1,
    Honeydew2,
    LightCyan1,
    Red1,
    DeepPink2,
    DeepPink1a,
    DeepPink1b,
    Magenta2b,
    Magenta1,
    OrangeRed1,
    IndianRed1c,
    IndianRed1d,
    HotPink1a,
    HotPink1b,
    MediumOrchid1b,
    DarkOrange,
    Salmon1,
    LightCoral,
    PaleVioletRed1,
    Orchid2,
    Orchid1,
    Orange1,
    SandyBrown,
    LightSalmon1,
    LightPink1,
    Pink1,
    Plum1,
    Gold1,
    LightGoldenrod2b,
    LightGoldenrod2c,
    NavajoWhite1,
    MistyRose1,
    Thistle1,
    Yellow1,
    LightGoldenrod1,
    Khaki1,
    Wheat1,
    CornSilk1,
    Grey100,
    Grey3,
    Grey7,
    Grey11,
    Grey15,
    Grey19,
    Grey23,
    Grey27,
    Grey30,
    Grey35,
    Grey39,
    Grey42,
    Grey46,
    Grey50,
    Grey54,
    Grey58,
    Grey62,
    Grey66,
    Grey70,
    Grey74,
    Grey78,
    Grey82,
    Grey85,
    Grey89,
    Grey93,
}

impl ColorInterface for Color {
    fn to_color_str(&self) -> String {
        format!("{}",
                match self {
                    Color::Black => "0",
                    Color::Red => "1",
                    Color::Green => "2",
                    Color::Yellow => "3",
                    Color::Blue => "4",
                    Color::Magenta => "5",
                    Color::Cyan => "6",
                    Color::LightGray => "7",
                    Color::DarkGray => "8",
                    Color::LightRed => "9",
                    Color::LightGreen => "10",
                    Color::LightYellow => "11",
                    Color::LightBlue => "12",
                    Color::LightMagenta => "13",
                    Color::LightCyan => "14",
                    Color::White => "15",
                    Color::Grey0 => "16",
                    Color::NavyBlue => "17",
                    Color::DarkBlue => "18",
                    Color::Blue3a => "19",
                    Color::Blue3b => "20",
                    Color::Blue1 => "21",
                    Color::DarkGreen => "22",
                    Color::DeepSkyBlue4a => "23",
                    Color::DeepSkyBlue4b => "24",
                    Color::DeepSkyBlue4c => "25",
                    Color::DodgerBlue3 => "26",
                    Color::DodgerBlue2 => "27",
                    Color::Green4 => "28",
                    Color::SpringGreen4 => "29",
                    Color::Turquoise4 => "30",
                    Color::DeepSkyBlue3a => "31",
                    Color::DeepSkyBlue3b => "32",
                    Color::DodgerBlue1 => "33",
                    Color::Green3a => "34",
                    Color::SpringGreen3a => "35",
                    Color::DarkCyan => "36",
                    Color::LightSeaGreen => "37",
                    Color::DeepSkyBlue2 => "38",
                    Color::DeepSkyBlue1 => "39",
                    Color::Green3b => "40",
                    Color::SpringGreen3b => "41",
                    Color::SpringGreen2a => "42",
                    Color::Cyan3 => "43",
                    Color::DarkTurquoise => "44",
                    Color::Turquoise2 => "45",
                    Color::Green1 => "46",
                    Color::SpringGreen2b => "47",
                    Color::SpringGreen1 => "48",
                    Color::MediumSpringGreen => "49",
                    Color::Cyan2 => "50",
                    Color::Cyan1 => "51",
                    Color::DarkRed1 => "52",
                    Color::DeepPink4a => "53",
                    Color::Purple4a => "54",
                    Color::Purple4b => "55",
                    Color::Purple3 => "56",
                    Color::BlueViolet => "57",
                    Color::Orange4a => "58",
                    Color::Grey37 => "59",
                    Color::MediumPurple4 => "60",
                    Color::SlateBlue3a => "61",
                    Color::SlateBlue3b => "62",
                    Color::RoyalBlue1 => "63",
                    Color::Chartreuse4 => "64",
                    Color::DarkSeaGreen4a => "65",
                    Color::PaleTurquoise4 => "66",
                    Color::SteelBlue => "67",
                    Color::SteelBlue3 => "68",
                    Color::CornflowerBlue => "69",
                    Color::Chartreuse3a => "70",
                    Color::DarkSeaGreen4b => "71",
                    Color::CadetBlue2 => "72",
                    Color::CadetBlue1 => "73",
                    Color::SkyBlue3 => "74",
                    Color::SteelBlue1a => "75",
                    Color::Chartreuse3b => "76",
                    Color::PaleGreen3a => "77",
                    Color::SeaGreen3 => "78",
                    Color::Aquamarine3 => "79",
                    Color::MediumTurquoise => "80",
                    Color::SteelBlue1b => "81",
                    Color::Chartreuse2a => "82",
                    Color::SeaGreen2 => "83",
                    Color::SeaGreen1a => "84",
                    Color::SeaGreen1b => "85",
                    Color::Aquamarine1a => "86",
                    Color::DarkSlateGray2 => "87",
                    Color::DarkRed2 => "88",
                    Color::DeepPink4b => "89",
                    Color::DarkMagenta1 => "90",
                    Color::DarkMagenta2 => "91",
                    Color::DarkViolet1a => "92",
                    Color::Purple1a => "93",
                    Color::Orange4b => "94",
                    Color::LightPink4 => "95",
                    Color::Plum4 => "96",
                    Color::MediumPurple3a => "97",
                    Color::MediumPurple3b => "98",
                    Color::SlateBlue1 => "99",
                    Color::Yellow4a => "100",
                    Color::Wheat4 => "101",
                    Color::Grey53 => "102",
                    Color::LightSlateGrey => "103",
                    Color::MediumPurple => "104",
                    Color::LightSlateBlue => "105",
                    Color::Yellow4b => "106",
                    Color::DarkOliveGreen3a => "107",
                    Color::DarkGreenSea => "108",
                    Color::LightSkyBlue3a => "109",
                    Color::LightSkyBlue3b => "110",
                    Color::SkyBlue2 => "111",
                    Color::Chartreuse2b => "112",
                    Color::DarkOliveGreen3b => "113",
                    Color::PaleGreen3b => "114",
                    Color::DarkSeaGreen3a => "115",
                    Color::DarkSlateGray3 => "116",
                    Color::SkyBlue1 => "117",
                    Color::Chartreuse1 => "118",
                    Color::LightGreen2 => "119",
                    Color::LightGreen3 => "120",
                    Color::PaleGreen1a => "121",
                    Color::Aquamarine1b => "122",
                    Color::DarkSlateGray1 => "123",
                    Color::Red3a => "124",
                    Color::DeepPink4c => "125",
                    Color::MediumVioletRed => "126",
                    Color::Magenta3a => "127",
                    Color::DarkViolet1b => "128",
                    Color::Purple1b => "129",
                    Color::DarkOrange3a => "130",
                    Color::IndianRed1a => "131",
                    Color::HotPink3a => "132",
                    Color::MediumOrchid3 => "133",
                    Color::MediumOrchid => "134",
                    Color::MediumPurple2a => "135",
                    Color::DarkGoldenrod => "136",
                    Color::LightSalmon3a => "137",
                    Color::RosyBrown => "138",
                    Color::Grey63 => "139",
                    Color::MediumPurple2b => "140",
                    Color::MediumPurple1 => "141",
                    Color::Gold3a => "142",
                    Color::DarkKhaki => "143",
                    Color::NavajoWhite3 => "144",
                    Color::Grey69 => "145",
                    Color::LightSteelBlue3 => "146",
                    Color::LightSteelBlue => "147",
                    Color::Yellow3a => "148",
                    Color::DarkOliveGreen3 => "149",
                    Color::DarkSeaGreen3b => "150",
                    Color::DarkSeaGreen2 => "151",
                    Color::LightCyan3 => "152",
                    Color::LightSkyBlue1 => "153",
                    Color::GreenYellow => "154",
                    Color::DarkOliveGreen2 => "155",
                    Color::PaleGreen1b => "156",
                    Color::DarkSeaGreen5b => "157",
                    Color::DarkSeaGreen5a => "158",
                    Color::PaleTurquoise1 => "159",
                    Color::Red3b => "160",
                    Color::DeepPink3a => "161",
                    Color::DeepPink3b => "162",
                    Color::Magenta3b => "163",
                    Color::Magenta3c => "164",
                    Color::Magenta2a => "165",
                    Color::DarkOrange3b => "166",
                    Color::IndianRed1b => "167",
                    Color::HotPink3b => "168",
                    Color::HotPink2 => "169",
                    Color::Orchid => "170",
                    Color::MediumOrchid1a => "171",
                    Color::Orange3 => "172",
                    Color::LightSalmon3b => "173",
                    Color::LightPink3 => "174",
                    Color::Pink3 => "175",
                    Color::Plum3 => "176",
                    Color::Violet => "177",
                    Color::Gold3b => "178",
                    Color::LightGoldenrod3 => "179",
                    Color::Tan => "180",
                    Color::MistyRose3 => "181",
                    Color::Thistle3 => "182",
                    Color::Plum2 => "183",
                    Color::Yellow3b => "184",
                    Color::Khaki3 => "185",
                    Color::LightGoldenrod2a => "186",
                    Color::LightYellow3 => "187",
                    Color::Grey84 => "188",
                    Color::LightSteelBlue1 => "189",
                    Color::Yellow2 => "190",
                    Color::DarkOliveGreen1a => "191",
                    Color::DarkOliveGreen1b => "192",
                    Color::DarkSeaGreen1 => "193",
                    Color::Honeydew2 => "194",
                    Color::LightCyan1 => "195",
                    Color::Red1 => "196",
                    Color::DeepPink2 => "197",
                    Color::DeepPink1a => "198",
                    Color::DeepPink1b => "199",
                    Color::Magenta2b => "200",
                    Color::Magenta1 => "201",
                    Color::OrangeRed1 => "202",
                    Color::IndianRed1c => "203",
                    Color::IndianRed1d => "204",
                    Color::HotPink1a => "205",
                    Color::HotPink1b => "206",
                    Color::MediumOrchid1b => "207",
                    Color::DarkOrange => "208",
                    Color::Salmon1 => "209",
                    Color::LightCoral => "210",
                    Color::PaleVioletRed1 => "211",
                    Color::Orchid2 => "212",
                    Color::Orchid1 => "213",
                    Color::Orange1 => "214",
                    Color::SandyBrown => "215",
                    Color::LightSalmon1 => "216",
                    Color::LightPink1 => "217",
                    Color::Pink1 => "218",
                    Color::Plum1 => "219",
                    Color::Gold1 => "220",
                    Color::LightGoldenrod2b => "221",
                    Color::LightGoldenrod2c => "222",
                    Color::NavajoWhite1 => "223",
                    Color::MistyRose1 => "224",
                    Color::Thistle1 => "225",
                    Color::Yellow1 => "226",
                    Color::LightGoldenrod1 => "227",
                    Color::Khaki1 => "228",
                    Color::Wheat1 => "229",
                    Color::CornSilk1 => "230",
                    Color::Grey100 => "231",
                    Color::Grey3 => "232",
                    Color::Grey7 => "233",
                    Color::Grey11 => "234",
                    Color::Grey15 => "235",
                    Color::Grey19 => "236",
                    Color::Grey23 => "237",
                    Color::Grey27 => "238",
                    Color::Grey30 => "239",
                    Color::Grey35 => "240",
                    Color::Grey39 => "241",
                    Color::Grey42 => "242",
                    Color::Grey46 => "243",
                    Color::Grey50 => "244",
                    Color::Grey54 => "245",
                    Color::Grey58 => "246",
                    Color::Grey62 => "247",
                    Color::Grey66 => "248",
                    Color::Grey70 => "249",
                    Color::Grey74 => "250",
                    Color::Grey78 => "251",
                    Color::Grey82 => "252",
                    Color::Grey85 => "253",
                    Color::Grey89 => "254",
                    Color::Grey93 => "255",
                }
        )
    }
    fn to_hsl(&self) -> HSL {
        match self {
            Color::Black => HSL::new(0.0, 0.0, 0.0),
            Color::Red => HSL::new(0.0, 1.0, 0.25),
            Color::Green => HSL::new(0.3333333333333333, 1.0, 0.25),
            Color::Yellow => HSL::new(0.16666666666666666, 1.0, 0.25),
            Color::Blue => HSL::new(0.6666666666666666, 1.0, 0.25),
            Color::Magenta => HSL::new(0.8333333333333334, 1.0, 0.25),
            Color::Cyan => HSL::new(0.5, 1.0, 0.25),
            Color::LightGray => HSL::new(0.0, 0.0, 0.75),
            Color::DarkGray => HSL::new(0.0, 0.0, 0.5),
            Color::LightRed => HSL::new(0.0, 1.0, 0.5),
            Color::LightGreen => HSL::new(0.3333333333333333, 1.0, 0.5),
            Color::LightYellow => HSL::new(0.16666666666666666, 1.0, 0.5),
            Color::LightBlue => HSL::new(0.6666666666666666, 1.0, 0.5),
            Color::LightMagenta => HSL::new(0.8333333333333334, 1.0, 0.5),
            Color::LightCyan => HSL::new(0.5, 1.0, 0.5),
            Color::White => HSL::new(0.0, 0.0, 1.0),
            Color::Grey0 => HSL::new(0.0, 0.0, 0.0),
            Color::NavyBlue => HSL::new(0.6666666666666666, 1.0, 0.18),
            Color::DarkBlue => HSL::new(0.6666666666666666, 1.0, 0.26),
            Color::Blue3a => HSL::new(0.6666666666666666, 1.0, 0.34),
            Color::Blue3b => HSL::new(0.6666666666666666, 1.0, 0.42),
            Color::Blue1 => HSL::new(0.6666666666666666, 1.0, 0.5),
            Color::DarkGreen => HSL::new(0.3333333333333333, 1.0, 0.18),
            Color::DeepSkyBlue4a => HSL::new(0.5, 1.0, 0.18),
            Color::DeepSkyBlue4b => HSL::new(0.5493827160493834, 1.0, 0.26),
            Color::DeepSkyBlue4c => HSL::new(0.5761904761904749, 1.0, 0.34),
            Color::DodgerBlue3 => HSL::new(0.5930232558139528, 1.0, 0.42),
            Color::DodgerBlue2 => HSL::new(0.6045751633986917, 1.0, 0.5),
            Color::Green4 => HSL::new(0.3333333333333333, 1.0, 0.26),
            Color::SpringGreen4 => HSL::new(0.4506172839506167, 1.0, 0.26),
            Color::Turquoise4 => HSL::new(0.5, 1.0, 0.26),
            Color::DeepSkyBlue3a => HSL::new(0.538095238095239, 1.0, 0.34),
            Color::DeepSkyBlue3b => HSL::new(0.5620155038759694, 1.0, 0.42),
            Color::DodgerBlue1 => HSL::new(0.5784313725490194, 1.0, 0.5),
            Color::Green3a => HSL::new(0.3333333333333333, 1.0, 0.34),
            Color::SpringGreen3a => HSL::new(0.423809523809525, 1.0, 0.34),
            Color::DarkCyan => HSL::new(0.4619047619047611, 1.0, 0.34),
            Color::LightSeaGreen => HSL::new(0.5, 1.0, 0.34),
            Color::DeepSkyBlue2 => HSL::new(0.5310077519379833, 1.0, 0.42),
            Color::DeepSkyBlue1 => HSL::new(0.5522875816993472, 1.0, 0.5),
            Color::Green3b => HSL::new(0.3333333333333333, 1.0, 0.42),
            Color::SpringGreen3b => HSL::new(0.40697674418604723, 1.0, 0.42),
            Color::SpringGreen2a => HSL::new(0.43798449612403056, 1.0, 0.42),
            Color::Cyan3 => HSL::new(0.4689922480620166, 1.0, 0.42),
            Color::DarkTurquoise => HSL::new(0.5, 1.0, 0.42),
            Color::Turquoise2 => HSL::new(0.5261437908496722, 1.0, 0.5),
            Color::Green1 => HSL::new(0.3333333333333333, 1.0, 0.5),
            Color::SpringGreen2b => HSL::new(0.39542483660130834, 1.0, 0.5),
            Color::SpringGreen1 => HSL::new(0.4215686274509806, 1.0, 0.5),
            Color::MediumSpringGreen => HSL::new(0.4477124183006528, 1.0, 0.5),
            Color::Cyan2 => HSL::new(0.4738562091503278, 1.0, 0.5),
            Color::Cyan1 => HSL::new(0.5, 1.0, 0.5),
            Color::DarkRed1 => HSL::new(0.0, 1.0, 0.18),
            Color::DeepPink4a => HSL::new(0.8333333333333334, 1.0, 0.18),
            Color::Purple4a => HSL::new(0.78395061728395, 1.0, 0.26),
            Color::Purple4b => HSL::new(0.7571428571428583, 1.0, 0.34),
            Color::Purple3 => HSL::new(0.7403100775193806, 1.0, 0.42),
            Color::BlueViolet => HSL::new(0.7287581699346417, 1.0, 0.5),
            Color::Orange4a => HSL::new(0.16666666666666666, 1.0, 0.18),
            Color::Grey37 => HSL::new(0.0, 0.0, 0.37),
            Color::MediumPurple4 => HSL::new(0.6666666666666666, 0.17, 0.45),
            Color::SlateBlue3a => HSL::new(0.6666666666666666, 0.33, 0.52),
            Color::SlateBlue3b => HSL::new(0.6666666666666666, 0.6, 0.6),
            Color::RoyalBlue1 => HSL::new(0.6666666666666666, 1.0, 0.68),
            Color::Chartreuse4 => HSL::new(0.21604938271604945, 1.0, 0.26),
            Color::DarkSeaGreen4a => HSL::new(0.3333333333333333, 0.17, 0.45),
            Color::PaleTurquoise4 => HSL::new(0.5, 0.17, 0.45),
            Color::SteelBlue => HSL::new(0.5833333333333334, 0.33, 0.52),
            Color::SteelBlue3 => HSL::new(0.6111111111111112, 0.6, 0.6),
            Color::CornflowerBlue => HSL::new(0.625, 1.0, 0.68),
            Color::Chartreuse3a => HSL::new(0.24285714285714277, 1.0, 0.34),
            Color::DarkSeaGreen4b => HSL::new(0.3333333333333333, 0.33, 0.52),
            Color::CadetBlue2 => HSL::new(0.4166666666666667, 0.33, 0.52),
            Color::CadetBlue1 => HSL::new(0.5, 0.33, 0.52),
            Color::SkyBlue3 => HSL::new(0.5555555555555556, 0.6, 0.6),
            Color::SteelBlue1a => HSL::new(0.5833333333333334, 1.0, 0.68),
            Color::Chartreuse3b => HSL::new(0.2596899224806203, 1.0, 0.42),
            Color::PaleGreen3a => HSL::new(0.3333333333333333, 0.6, 0.6),
            Color::SeaGreen3 => HSL::new(0.3888888888888889, 0.6, 0.6),
            Color::Aquamarine3 => HSL::new(0.4444444444444444, 0.6, 0.6),
            Color::MediumTurquoise => HSL::new(0.5, 0.6, 0.6),
            Color::SteelBlue1b => HSL::new(0.5416666666666666, 1.0, 0.68),
            Color::Chartreuse2a => HSL::new(0.27124183006535946, 1.0, 0.5),
            Color::SeaGreen2 => HSL::new(0.3333333333333333, 1.0, 0.68),
            Color::SeaGreen1a => HSL::new(0.375, 1.0, 0.68),
            Color::SeaGreen1b => HSL::new(0.4166666666666667, 1.0, 0.68),
            Color::Aquamarine1a => HSL::new(0.4583333333333333, 1.0, 0.68),
            Color::DarkSlateGray2 => HSL::new(0.5, 1.0, 0.68),
            Color::DarkRed2 => HSL::new(0.0, 1.0, 0.26),
            Color::DeepPink4b => HSL::new(0.8827160493827166, 1.0, 0.26),
            Color::DarkMagenta1 => HSL::new(0.8333333333333334, 1.0, 0.26),
            Color::DarkMagenta2 => HSL::new(0.7952380952380944, 1.0, 0.34),
            Color::DarkViolet1a => HSL::new(0.7713178294573639, 1.0, 0.42),
            Color::Purple1a => HSL::new(0.7549019607843138, 1.0, 0.5),
            Color::Orange4b => HSL::new(0.11728395061728389, 1.0, 0.26),
            Color::LightPink4 => HSL::new(0.0, 0.17, 0.45),
            Color::Plum4 => HSL::new(0.8333333333333334, 0.17, 0.45),
            Color::MediumPurple3a => HSL::new(0.75, 0.33, 0.52),
            Color::MediumPurple3b => HSL::new(0.7222222222222222, 0.6, 0.6),
            Color::SlateBlue1 => HSL::new(0.7083333333333334, 1.0, 0.68),
            Color::Yellow4a => HSL::new(0.16666666666666666, 1.0, 0.26),
            Color::Wheat4 => HSL::new(0.16666666666666666, 0.17, 0.45),
            Color::Grey53 => HSL::new(0.0, 0.0, 0.52),
            Color::LightSlateGrey => HSL::new(0.6666666666666666, 0.2, 0.6),
            Color::MediumPurple => HSL::new(0.6666666666666666, 0.5, 0.68),
            Color::LightSlateBlue => HSL::new(0.6666666666666666, 1.0, 0.76),
            Color::Yellow4b => HSL::new(0.2047619047619047, 1.0, 0.34),
            Color::DarkOliveGreen3a => HSL::new(0.25, 0.33, 0.52),
            Color::DarkGreenSea => HSL::new(0.3333333333333333, 0.2, 0.6),
            Color::LightSkyBlue3a => HSL::new(0.5, 0.2, 0.6),
            Color::LightSkyBlue3b => HSL::new(0.5833333333333334, 0.5, 0.68),
            Color::SkyBlue2 => HSL::new(0.6111111111111112, 1.0, 0.76),
            Color::Chartreuse2b => HSL::new(0.22868217054263557, 1.0, 0.42),
            Color::DarkOliveGreen3b => HSL::new(0.2777777777777778, 0.6, 0.6),
            Color::PaleGreen3b => HSL::new(0.3333333333333333, 0.5, 0.68),
            Color::DarkSeaGreen3a => HSL::new(0.4166666666666667, 0.5, 0.68),
            Color::DarkSlateGray3 => HSL::new(0.5, 0.5, 0.68),
            Color::SkyBlue1 => HSL::new(0.5555555555555556, 1.0, 0.76),
            Color::Chartreuse1 => HSL::new(0.2450980392156864, 1.0, 0.5),
            Color::LightGreen2 => HSL::new(0.2916666666666667, 1.0, 0.68),
            Color::LightGreen3 => HSL::new(0.3333333333333333, 1.0, 0.76),
            Color::PaleGreen1a => HSL::new(0.3888888888888889, 1.0, 0.76),
            Color::Aquamarine1b => HSL::new(0.4444444444444444, 1.0, 0.76),
            Color::DarkSlateGray1 => HSL::new(0.5, 1.0, 0.76),
            Color::Red3a => HSL::new(0.0, 1.0, 0.34),
            Color::DeepPink4c => HSL::new(0.9095238095238083, 1.0, 0.34),
            Color::MediumVioletRed => HSL::new(0.8714285714285722, 1.0, 0.34),
            Color::Magenta3a => HSL::new(0.8333333333333334, 1.0, 0.34),
            Color::DarkViolet1b => HSL::new(0.80232558139535, 1.0, 0.42),
            Color::Purple1b => HSL::new(0.7810457516339862, 1.0, 0.5),
            Color::DarkOrange3a => HSL::new(0.09047619047619054, 1.0, 0.34),
            Color::IndianRed1a => HSL::new(0.0, 0.33, 0.52),
            Color::HotPink3a => HSL::new(0.9166666666666666, 0.33, 0.52),
            Color::MediumOrchid3 => HSL::new(0.8333333333333334, 0.33, 0.52),
            Color::MediumOrchid => HSL::new(0.7777777777777778, 0.6, 0.6),
            Color::MediumPurple2a => HSL::new(0.75, 1.0, 0.68),
            Color::DarkGoldenrod => HSL::new(0.12857142857142861, 1.0, 0.34),
            Color::LightSalmon3a => HSL::new(0.08333333333333333, 0.33, 0.52),
            Color::RosyBrown => HSL::new(0.0, 0.2, 0.6),
            Color::Grey63 => HSL::new(0.8333333333333334, 0.2, 0.6),
            Color::MediumPurple2b => HSL::new(0.75, 0.5, 0.68),
            Color::MediumPurple1 => HSL::new(0.7222222222222222, 1.0, 0.76),
            Color::Gold3a => HSL::new(0.16666666666666666, 1.0, 0.34),
            Color::DarkKhaki => HSL::new(0.16666666666666666, 0.33, 0.52),
            Color::NavajoWhite3 => HSL::new(0.16666666666666666, 0.2, 0.6),
            Color::Grey69 => HSL::new(0.0, 0.0, 0.68),
            Color::LightSteelBlue3 => HSL::new(0.6666666666666666, 0.33, 0.76),
            Color::LightSteelBlue => HSL::new(0.6666666666666666, 1.0, 0.84),
            Color::Yellow3a => HSL::new(0.1976744186046511, 1.0, 0.42),
            Color::DarkOliveGreen3 => HSL::new(0.2222222222222222, 0.6, 0.6),
            Color::DarkSeaGreen3b => HSL::new(0.25, 0.5, 0.68),
            Color::DarkSeaGreen2 => HSL::new(0.3333333333333333, 0.33, 0.76),
            Color::LightCyan3 => HSL::new(0.5, 0.33, 0.76),
            Color::LightSkyBlue1 => HSL::new(0.5833333333333334, 1.0, 0.84),
            Color::GreenYellow => HSL::new(0.21895424836601304, 1.0, 0.5),
            Color::DarkOliveGreen2 => HSL::new(0.25, 1.0, 0.68),
            Color::PaleGreen1b => HSL::new(0.2777777777777778, 1.0, 0.76),
            Color::DarkSeaGreen5b => HSL::new(0.3333333333333333, 1.0, 0.84),
            Color::DarkSeaGreen5a => HSL::new(0.4166666666666667, 1.0, 0.84),
            Color::PaleTurquoise1 => HSL::new(0.5, 1.0, 0.84),
            Color::Red3b => HSL::new(0.0, 1.0, 0.42),
            Color::DeepPink3a => HSL::new(0.926356589147286, 1.0, 0.42),
            Color::DeepPink3b => HSL::new(0.8953488372093028, 1.0, 0.42),
            Color::Magenta3b => HSL::new(0.8643410852713166, 1.0, 0.42),
            Color::Magenta3c => HSL::new(0.8333333333333334, 1.0, 0.42),
            Color::Magenta2a => HSL::new(0.8071895424836611, 1.0, 0.5),
            Color::DarkOrange3b => HSL::new(0.07364341085271306, 1.0, 0.42),
            Color::IndianRed1b => HSL::new(0.0, 0.6, 0.6),
            Color::HotPink3b => HSL::new(0.9444444444444444, 0.6, 0.6),
            Color::HotPink2 => HSL::new(0.8888888888888888, 0.6, 0.6),
            Color::Orchid => HSL::new(0.8333333333333334, 0.6, 0.6),
            Color::MediumOrchid1a => HSL::new(0.7916666666666666, 1.0, 0.68),
            Color::Orange3 => HSL::new(0.10465116279069778, 1.0, 0.42),
            Color::LightSalmon3b => HSL::new(0.05555555555555555, 0.6, 0.6),
            Color::LightPink3 => HSL::new(0.0, 0.5, 0.68),
            Color::Pink3 => HSL::new(0.9166666666666666, 0.5, 0.68),
            Color::Plum3 => HSL::new(0.8333333333333334, 0.5, 0.68),
            Color::Violet => HSL::new(0.7777777777777778, 1.0, 0.76),
            Color::Gold3b => HSL::new(0.13565891472868222, 1.0, 0.42),
            Color::LightGoldenrod3 => HSL::new(0.1111111111111111, 0.6, 0.6),
            Color::Tan => HSL::new(0.08333333333333333, 0.5, 0.68),
            Color::MistyRose3 => HSL::new(0.0, 0.33, 0.76),
            Color::Thistle3 => HSL::new(0.8333333333333334, 0.33, 0.76),
            Color::Plum2 => HSL::new(0.75, 1.0, 0.84),
            Color::Yellow3b => HSL::new(0.16666666666666666, 1.0, 0.42),
            Color::Khaki3 => HSL::new(0.16666666666666666, 0.6, 0.6),
            Color::LightGoldenrod2a => HSL::new(0.16666666666666666, 0.5, 0.68),
            Color::LightYellow3 => HSL::new(0.16666666666666666, 0.33, 0.76),
            Color::Grey84 => HSL::new(0.0, 0.0, 0.84),
            Color::LightSteelBlue1 => HSL::new(0.6666666666666666, 1.0, 0.92),
            Color::Yellow2 => HSL::new(0.19281045751633974, 1.0, 0.5),
            Color::DarkOliveGreen1a => HSL::new(0.20833333333333334, 1.0, 0.68),
            Color::DarkOliveGreen1b => HSL::new(0.2222222222222222, 1.0, 0.76),
            Color::DarkSeaGreen1 => HSL::new(0.25, 1.0, 0.84),
            Color::Honeydew2 => HSL::new(0.3333333333333333, 1.0, 0.92),
            Color::LightCyan1 => HSL::new(0.5, 1.0, 0.92),
            Color::Red1 => HSL::new(0.0, 1.0, 0.5),
            Color::DeepPink2 => HSL::new(0.937908496732025, 1.0, 0.5),
            Color::DeepPink1a => HSL::new(0.9117647058823528, 1.0, 0.5),
            Color::DeepPink1b => HSL::new(0.8856209150326805, 1.0, 0.5),
            Color::Magenta2b => HSL::new(0.8594771241830055, 1.0, 0.5),
            Color::Magenta1 => HSL::new(0.8333333333333334, 1.0, 0.5),
            Color::OrangeRed1 => HSL::new(0.06209150326797389, 1.0, 0.5),
            Color::IndianRed1c => HSL::new(0.0, 1.0, 0.68),
            Color::IndianRed1d => HSL::new(0.9583333333333334, 1.0, 0.68),
            Color::HotPink1a => HSL::new(0.9166666666666666, 1.0, 0.68),
            Color::HotPink1b => HSL::new(0.875, 1.0, 0.68),
            Color::MediumOrchid1b => HSL::new(0.8333333333333334, 1.0, 0.68),
            Color::DarkOrange => HSL::new(0.08823529411764694, 1.0, 0.5),
            Color::Salmon1 => HSL::new(0.041666666666666664, 1.0, 0.68),
            Color::LightCoral => HSL::new(0.0, 1.0, 0.76),
            Color::PaleVioletRed1 => HSL::new(0.9444444444444444, 1.0, 0.76),
            Color::Orchid2 => HSL::new(0.8888888888888888, 1.0, 0.76),
            Color::Orchid1 => HSL::new(0.8333333333333334, 1.0, 0.76),
            Color::Orange1 => HSL::new(0.11437908496732027, 1.0, 0.5),
            Color::SandyBrown => HSL::new(0.08333333333333333, 1.0, 0.68),
            Color::LightSalmon1 => HSL::new(0.05555555555555555, 1.0, 0.76),
            Color::LightPink1 => HSL::new(0.0, 1.0, 0.84),
            Color::Pink1 => HSL::new(0.9166666666666666, 1.0, 0.84),
            Color::Plum1 => HSL::new(0.8333333333333334, 1.0, 0.84),
            Color::Gold1 => HSL::new(0.14052287581699335, 1.0, 0.5),
            Color::LightGoldenrod2b => HSL::new(0.125, 1.0, 0.68),
            Color::LightGoldenrod2c => HSL::new(0.1111111111111111, 1.0, 0.76),
            Color::NavajoWhite1 => HSL::new(0.08333333333333333, 1.0, 0.84),
            Color::MistyRose1 => HSL::new(0.0, 1.0, 0.92),
            Color::Thistle1 => HSL::new(0.8333333333333334, 1.0, 0.92),
            Color::Yellow1 => HSL::new(0.16666666666666666, 1.0, 0.5),
            Color::LightGoldenrod1 => HSL::new(0.16666666666666666, 1.0, 0.68),
            Color::Khaki1 => HSL::new(0.16666666666666666, 1.0, 0.76),
            Color::Wheat1 => HSL::new(0.16666666666666666, 1.0, 0.84),
            Color::CornSilk1 => HSL::new(0.16666666666666666, 1.0, 0.92),
            Color::Grey100 => HSL::new(0.0, 0.0, 1.0),
            Color::Grey3 => HSL::new(0.0, 0.0, 0.03),
            Color::Grey7 => HSL::new(0.0, 0.0, 0.07),
            Color::Grey11 => HSL::new(0.0, 0.0, 0.1),
            Color::Grey15 => HSL::new(0.0, 0.0, 0.14),
            Color::Grey19 => HSL::new(0.0, 0.0, 0.18),
            Color::Grey23 => HSL::new(0.0, 0.0, 0.22),
            Color::Grey27 => HSL::new(0.0, 0.0, 0.26),
            Color::Grey30 => HSL::new(0.0, 0.0, 0.3),
            Color::Grey35 => HSL::new(0.0, 0.0, 0.34),
            Color::Grey39 => HSL::new(0.0, 0.0, 0.37),
            Color::Grey42 => HSL::new(0.0, 0.0, 0.4),
            Color::Grey46 => HSL::new(0.0, 0.0, 0.46),
            Color::Grey50 => HSL::new(0.0, 0.0, 0.5),
            Color::Grey54 => HSL::new(0.0, 0.0, 0.54),
            Color::Grey58 => HSL::new(0.0, 0.0, 0.58),
            Color::Grey62 => HSL::new(0.0, 0.0, 0.61),
            Color::Grey66 => HSL::new(0.0, 0.0, 0.65),
            Color::Grey70 => HSL::new(0.0, 0.0, 0.69),
            Color::Grey74 => HSL::new(0.0, 0.0, 0.73),
            Color::Grey78 => HSL::new(0.0, 0.0, 0.77),
            Color::Grey82 => HSL::new(0.0, 0.0, 0.81),
            Color::Grey85 => HSL::new(0.0, 0.0, 0.85),
            Color::Grey89 => HSL::new(0.0, 0.0, 0.89),
            Color::Grey93 => HSL::new(0.0, 0.0, 0.93),
        }
    }
}

impl Color {
    pub fn iterator() -> Iter<'static, Color> {
        use Color::*;
        static ITEMS: [Color; 256] = [Black, Red, Green, Yellow, Blue, Magenta, Cyan, LightGray, DarkGray, LightRed, LightGreen, LightYellow, LightBlue, LightMagenta, LightCyan, White, Grey0, NavyBlue, DarkBlue, Blue3a, Blue3b, Blue1, DarkGreen, DeepSkyBlue4a, DeepSkyBlue4b, DeepSkyBlue4c, DodgerBlue3, DodgerBlue2, Green4, SpringGreen4, Turquoise4, DeepSkyBlue3a, DeepSkyBlue3b, DodgerBlue1, Green3a, SpringGreen3a, DarkCyan, LightSeaGreen, DeepSkyBlue2, DeepSkyBlue1, Green3b, SpringGreen3b, SpringGreen2a, Cyan3, DarkTurquoise, Turquoise2, Green1, SpringGreen2b, SpringGreen1, MediumSpringGreen, Cyan2, Cyan1, DarkRed1, DeepPink4a, Purple4a, Purple4b, Purple3, BlueViolet, Orange4a, Grey37, MediumPurple4, SlateBlue3a, SlateBlue3b, RoyalBlue1, Chartreuse4, DarkSeaGreen4a, PaleTurquoise4, SteelBlue, SteelBlue3, CornflowerBlue, Chartreuse3a, DarkSeaGreen4b, CadetBlue2, CadetBlue1, SkyBlue3, SteelBlue1a, Chartreuse3b, PaleGreen3a, SeaGreen3, Aquamarine3, MediumTurquoise, SteelBlue1b, Chartreuse2a, SeaGreen2, SeaGreen1a, SeaGreen1b, Aquamarine1a, DarkSlateGray2, DarkRed2, DeepPink4b, DarkMagenta1, DarkMagenta2, DarkViolet1a, Purple1a, Orange4b, LightPink4, Plum4, MediumPurple3a, MediumPurple3b, SlateBlue1, Yellow4a, Wheat4, Grey53, LightSlateGrey, MediumPurple, LightSlateBlue, Yellow4b, DarkOliveGreen3a, DarkGreenSea, LightSkyBlue3a, LightSkyBlue3b, SkyBlue2, Chartreuse2b, DarkOliveGreen3b, PaleGreen3b, DarkSeaGreen3a, DarkSlateGray3, SkyBlue1, Chartreuse1, LightGreen2, LightGreen3, PaleGreen1a, Aquamarine1b, DarkSlateGray1, Red3a, DeepPink4c, MediumVioletRed, Magenta3a, DarkViolet1b, Purple1b, DarkOrange3a, IndianRed1a, HotPink3a, MediumOrchid3, MediumOrchid, MediumPurple2a, DarkGoldenrod, LightSalmon3a, RosyBrown, Grey63, MediumPurple2b, MediumPurple1, Gold3a, DarkKhaki, NavajoWhite3, Grey69, LightSteelBlue3, LightSteelBlue, Yellow3a, DarkOliveGreen3, DarkSeaGreen3b, DarkSeaGreen2, LightCyan3, LightSkyBlue1, GreenYellow, DarkOliveGreen2, PaleGreen1b, DarkSeaGreen5b, DarkSeaGreen5a, PaleTurquoise1, Red3b, DeepPink3a, DeepPink3b, Magenta3b, Magenta3c, Magenta2a, DarkOrange3b, IndianRed1b, HotPink3b, HotPink2, Orchid, MediumOrchid1a, Orange3, LightSalmon3b, LightPink3, Pink3, Plum3, Violet, Gold3b, LightGoldenrod3, Tan, MistyRose3, Thistle3, Plum2, Yellow3b, Khaki3, LightGoldenrod2a, LightYellow3, Grey84, LightSteelBlue1, Yellow2, DarkOliveGreen1a, DarkOliveGreen1b, DarkSeaGreen1, Honeydew2, LightCyan1, Red1, DeepPink2, DeepPink1a, DeepPink1b, Magenta2b, Magenta1, OrangeRed1, IndianRed1c, IndianRed1d, HotPink1a, HotPink1b, MediumOrchid1b, DarkOrange, Salmon1, LightCoral, PaleVioletRed1, Orchid2, Orchid1, Orange1, SandyBrown, LightSalmon1, LightPink1, Pink1, Plum1, Gold1, LightGoldenrod2b, LightGoldenrod2c, NavajoWhite1, MistyRose1, Thistle1, Yellow1, LightGoldenrod1, Khaki1, Wheat1, CornSilk1, Grey100, Grey3, Grey7, Grey11, Grey15, Grey19, Grey23, Grey27, Grey30, Grey35, Grey39, Grey42, Grey46, Grey50, Grey54, Grey58, Grey62, Grey66, Grey70, Grey74, Grey78, Grey82, Grey85, Grey89, Grey93];
        ITEMS.iter()
    }
}

#[derive(Copy, Clone)]
pub enum ColorMode {
    SIMPLE,
    RGB,
    HSL,
}

#[derive(Clone)]
pub struct Colorado {
    mode: ColorMode,
    color: String,
}


impl Default for Colorado {
    fn default() -> Colorado {
        Colorado {
            mode: ColorMode::SIMPLE,
            color: String::default(),
        }
    }
}

impl Colorado {
    pub fn new<C: ColorInterface>(color: C) -> Colorado {
        let c = format!("{}", color.to_color_str());
        Colorado {
            color: c.clone(),
            mode: if c.contains(";") {
                ColorMode::RGB
            } else {
                ColorMode::SIMPLE
            },
        }
    }
    pub fn get_color(&self) -> String { self.color.clone() }
    pub fn get_mode(&self) -> ColorMode { self.mode }
}


#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_rgb_iterator() {
        for _ in Color::iterator() {}
    }
}