# Last Change: Mon Aug 20 01:00 PM 2007 J
# Implement partial application (should only be used if functools is not
# available (eg python < 2.5)
from __future__ import division, print_function, absolute_import

class partial:
    def __init__(self, fun, *args, **kwargs):
        self.fun = fun
        self.pending = args[:]
        self.kwargs = kwargs.copy()

    def __call__(self, *args, **kwargs):
        if kwargs and self.kwargs:
            kw = self.kwargs.copy()
            kw.update(kwargs)
        else:
            kw = kwargs or self.kwargs

        return self.fun(*(self.pending + args), **kw)
