#!/bin/bash
# This is part of the rsyslog testbench, licensed under ASL 2.0

. $srcdir/diag.sh init
generate_conf
add_conf '
global(environment=["http_proxy=http://127.0.0.1", "SECOND=OK OK"])

set $!prx = getenv("http_proxy");
set $!second = getenv("SECOND");

template(name="outfmt" type="string" string="%$!prx%, %$!second%\n")
:msg, contains, "msgnum:" action(type="omfile" template="outfmt"
			         file=`echo $RSYSLOG_OUT_LOG`)
'
startup
. $srcdir/diag.sh injectmsg  0 1
shutdown_when_empty # shut down rsyslogd when done processing messages
wait_shutdown    # we need to wait until rsyslogd is finished!

echo 'http://127.0.0.1, OK OK' | cmp - $RSYSLOG_OUT_LOG
if [ ! $? -eq 0 ]; then
  echo "invalid content seen, $RSYSLOG_OUT_LOG is:"
  cat $RSYSLOG_OUT_LOG
  error_exit 1
fi;

exit_test
