linux-system-roles/network
==========================
[![Coverage Status](https://coveralls.io/repos/github/linux-system-roles/network/badge.svg)](https://coveralls.io/github/linux-system-roles/network)
[![Travis Build Status](https://travis-ci.com/linux-system-roles/network.svg?branch=master)](https://travis-ci.com/linux-system-roles/network)
[![Code Style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/linux-system-roles/network.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/linux-system-roles/network/context:python)

Overview
--------

The `network` role enables users to configure network on the target machines.
This role can be used to configure:

- Ethernet interfaces
- Bridge interfaces
- Bonded interfaces
- VLAN interfaces
- MacVLAN interfaces
- Infiniband interfaces
- Wireless (WiFi) interfaces
- IP configuration
- 802.1x authentication

Introduction
------------
The  `network` role supports two providers: `nm` and `initscripts`. `nm` is
used by default in RHEL7 and `initscripts` in RHEL6. These providers can be
configured per host via the [`network_provider`](#provider) variable. In
absence of explicit configuration, it is autodetected based on the
distribution. However, note that either `nm` or `initscripts` is not tied to a certain
distribution. The `network` role works everywhere the required API is available.
This means that `nm` requires at least NetworkManager's API version 1.2 available.
For `initscripts`, the legacy network service is required as used in Fedora or RHEL.

For each host a list of networking profiles can be configured via the
`network_connections` variable.

- For `initscripts`, profiles correspond to ifcfg files in the `/etc/sysconfig/network-scripts/ifcfg-*` directory.

- For `NetworkManager`, profiles correspond to connection profiles as handled by
  NetworkManager.  Fedora and RHEL use the `ifcfg-rh-plugin` for NetworkManager,
  which also writes or reads configuration files to `/etc/sysconfig/network-scripts/ifcfg-*`
  for compatibility.

Note that the `network` role primarily operates on networking profiles (connections) and
not on devices, but it uses the profile name by default as the interface name.
It is also possible to create generic profiles, by creating for example a
profile with a certain IP configuration without activating the profile. To
apply the configuration to the actual networking interface, use the `nmcli`
commands on the target system.

**Warning**: The `network` role updates or creates all connection profiles on
the target system as specified in the `network_connections` variable. Therefore,
the `network` role removes options from the specified profiles if the options are
only present on the system but not in the `network_connections` variable.
Exceptions are mentioned below.

Variables
---------
The `network` role is configured via variables starting  with  `network_` as the name prefix.
List of variables:

* `network_provider` - The `network_provider` variable allows to set a specific
  provider (`nm` or `initscripts`) . Setting it to `{{ network_provider_os_default }}`,
  the provider is set depending on the operating system. This is usually `nm`
  except for RHEL 6 or CentOS 6 systems.
* `network_connections` - The connection profiles are configured as `network_connections`,
  which is a list of dictionaries that include specific options.
* `network_allow_restart` - Certain configurations require the role to restart network services.
  For example, if a wireless connection is configured and NetworkManager-wifi is not installed,
  NetworkManager must be restarted prior to the connection being configured. Setting this to
  `no` will prevent the role from restarting network service.

Examples of Variables
---------------------

Setting the variables

```yaml
network_provider: nm
network_connections:
  - name: eth0
    #...
network_allow_restart: yes
```

Options
-------
The `network_connections` variable is a list of dictionaries that include the following options.
List of options:

### `name` (required)

The `name` option identifies the connection profile. It is not the name of the
networking interface for which the profile applies, though we can associate
the profile with an interface and give them the same name.
Note that you can have multiple profiles for the same device, but only
one profile can be active on the device each time.
For NetworkManager, a connection can only be active at one device each time.

* For `NetworkManager`, the `name` option corresponds to the
  [`connection.id`](https://developer.gnome.org/NetworkManager/stable/nm-settings.html#nm-settings.property.connection.id)
  property option.
  Although NetworkManager supports multiple connections with the same `connection.id`,
  the `network` role cannot handle a duplicate `name`. Specifying a `name` multiple
  times refers to the same connection profile.

* For `initscripts`, the `name` option determines the ifcfg file name `/etc/sysconfig/network-scripts/ifcfg-$NAME`.
  Note that the `name` does not specify the `DEVICE` but a filename. As a consequence,
  `'/'` is not a valid character for the `name`.

You can also use the same connection profile multiple times. Therefore, it is possible to create a profile and activate it separately.

### `state`

The `state` option identifies what is the runtime state of  each connection profile. The `state` option (optional) can be set to the following values:

* `up` -  the connection profile is activated
* `down` - the connection profile is deactivated

#### `state: up`
- For `NetworkManager`, this corresponds to `nmcli connection id {{name}} up`.

- For `initscripts`, this corresponds to `ifup {{name}}`.

When the `state` option is set to `up`, you can also specify the `wait` option (optional):

* `wait: 0` - initiates only the activation, but does not wait until the device is fully connected.
The connection will be completed in the background, for example after a DHCP lease was received.
* `wait: <seconds>` is a timeout that enables you to decide how long you give the device to
activate. The default is using a suitable timeout. Note that the `wait` option is
only supported by NetworkManager.

Note that `state: up` always re-activates the profile and possibly changes the
networking configuration, even if the profile was already active before. As
a consequence, `state: up` always changes the system.

#### `state: down`

- For `NetworkManager`,  it corresponds to `nmcli connection id {{name}} down`.

- For `initscripts`, it corresponds to call `ifdown {{name}}`.

You can deactivate a connection profile, even if is currently not active. As a consequence, `state: down` always changes the system.

Note that if the `state` option is unset, the connection profile’s runtime state will not be changed.


### `persistent_state`

The `persistent_state` option identifies if a connection profile is persistent (saved on disk). The `persistent_state` option can be set to the following values:

#### `persistent_state: present` (default)

Note that if `persistent_state` is `present` and the connection profile contains
the `type` option, the profile will be created or updated. If the connection profile is
incomplete (no `type` option), the behavior is undefined. Also, the `present` value
does not directly result in a change in the network configuration. If the `state` option
is not set to `up`, the profile is only created or modified, not activated.

For NetworkManager, the new connection profile is created with the `autoconnect`
option enabled by default. Therefore, NetworkManager can activate the new
profile on a currently disconnected device. ([rh#1401515](https://bugzilla.redhat.com/show_bug.cgi?id=1401515)).

#### `persistent_state: absent`

The `absent` value ensures that the profile is not present on the
target host. If a profile with the given `name` exists, it will be deleted. In this case:

- `NetworkManager` deletes all connection profiles with the corresponding `connection.id`.
    Deleting a profile usually does not change the current networking configuration, unless
    the profile was currently activated on a device. Deleting the currently
    active connection profile disconnects the device. That makes the device eligible
    to autoconnect another connection (for more details, see [rh#1401515](https://bugzilla.redhat.com/show_bug.cgi?id=1401515)).

- `initscripts` deletes the ifcfg file in most cases with no impact on the runtime state of the system unless some component is watching the sysconfig directory.

**Note**: For profiles that only contain a `state` option, the `network` role only activates
or deactivates the connection without changing its configuration.


### `type`

The `type` option can be set to the following values:

  - `ethernet`
  - `bridge`
  - `bond`
  - `team`
  - `vlan`
  - `macvlan`
  - `infiniband`
  - `wireless`

#### `type: ethernet`

If the type is `ethernet`, then there can be an extra `ethernet` dictionary with the following
items (options): `autoneg`, `speed` and `duplex`, which correspond to the
settings of the `ethtool` utility with the same name.

* `autoneg`: `yes` (default) or `no` [if auto-negotiation is enabled or disabled]
* `speed`: speed in Mbit/s
* `duplex`: `half` or `full`

Note that the `speed` and `duplex` link settings are required when autonegotiation is disabled (autoneg:no).

#### `type: bridge`, `type: bond`, `type: team`

The `bridge`, `bond`, `team` device types work similar. Note that `team` is not supported in RHEL6 kernels.

For slaves, the `slave_type` and `master` properties must be set. Note that slaves should not have `ip` settings.

The `master` refers to the `name` of a profile in the Ansible
playbook. It is neither an interface-name nor a connection-id of
NetworkManager.

- For NetworkManager, `master` will be converted to the `connection.uuid`
  of the corresponding profile.

- For initscripts, the master is looked up as the `DEVICE` from the corresponding
  ifcfg file.

As `master` refers to other profiles of the same or another play,
the order of the `connections` list matters. Also, `--check` ignores
the value of the `master` and assumes it will be present during a real
run. That means, in presence of an invalid `master`, `--check` may
signal success but the actual play run fails.

The `team` type uses `roundrobin` as the `runner` configuration. No further configuration is supported at the moment.
#### `type: vlan`

Similar to `master`, the `parent` references the connection profile in the ansible
role.

#### `type: macvlan`

Similar to `master` and `vlan`, the `parent` references the connection profile in the ansible
role.

#### `type: wireless`

The `wireless` type supports WPA-PSK (password) authentication and WPA-EAP (802.1x) authentication.

`nm` (NetworkManager) is the only supported `network_provider` for this type.

If WPA-EAP is used, ieee802_1x settings must be defined in the [ieee802_1x](#-`ieee802_1x`) option.

The following options are supported:

* `ssid`: the SSID of the wireless network (required)
* `key_mgmt`: `wpa-psk` or `wpa-eap` (required)
* `password`: password for the network (required if `wpa-psk` is used)

### `autoconnect`

By default, profiles are created with autoconnect enabled.

- For `NetworkManager`, this corresponds to the `connection.autoconnect` property.

- For `initscripts`, this corresponds to the `ONBOOT` property.

### `mac`

The `mac` address is optional and restricts the profile to be usable only on
devices with the given MAC address. `mac` is only allowed for `type`
`ethernet` or `infiniband` to match a non-virtual device with the
profile.

- For `NetworkManager`, `mac` is the permanent MAC address, `ethernet.mac-address`.

- For `initscripts`,  `mac` is the currently configured MAC address of the device (`HWADDR`).

### `mtu`

The `mtu` option denotes the maximum transmission unit for the profile's
device. The maximum value depends on the device. For virtual devices, the
maximum value of the `mtu` option depends on the underlying device.

### `interface_name`

For the `ethernet` and `infiniband`  types, the `interface_name` option restricts the profile to
the given interface by name. This argument is optional and by default the
profile name is used unless a mac address is specified using the `mac` key.
Specifying an empty string (`""`) means that the profile is not
restricted to a network interface.

**Note:** With [persistent interface naming](https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/Networking_Guide/ch-Consistent_Network_Device_Naming.html),
the interface is predictable based on the hardware configuration.
Otherwise, the `mac` address might be an option.

For virtual interface types such as bridges, the `interface_name` is the name of the created
interface. In case of a missing `interface_name`, the `name` of the profile name is used.

**Note:** The `name` (the profile name) and the `interface_name` (the device name) may be
different or the profile may not be tied to an interface at all.

### `zone`

The `zone` option sets the firewalld zone for the interface.

Slaves to the bridge, bond or team devices cannot specify a zone.


### `ip`

The IP configuration supports the following options:

* `address`

    Manual addressing can be specified via a list of addresses under the `address` option.

* `dhcp4` and  `auto6`

    Also, manual addressing can be specified by setting either `dhcp4` or `auto6`.
    The `dhcp4` key is  for DHCPv4 and `auto6`  for  StateLess Address Auto Configuration
    (SLAAC). Note that the `dhcp4` and `auto6` keys can be omitted and the default key
    depends on the presence of manual addresses.


* `dhcp4_send_hostname`

    If `dhcp4` is enabled, it can be configured whether the DHCPv4 request includes
    the hostname via the `dhcp4_send_hostname` option. Note that `dhcp4_send_hostname`
    is only supported by the `nm` provider and corresponds to
    [`ipv4.dhcp-send-hostname`](https://developer.gnome.org/NetworkManager/stable/nm-settings.html#nm-settings.property.ipv4.dhcp-send-hostname)
    property.

* `dns` and `dns_search`

    Manual DNS configuration can be specified via a list of addresses
    given in the `dns` option and a list of domains to search given in the
    `dns_search` option.


* `route_metric4` and `route_metric6`

    - For `NetworkManager`, `route_metric4` and `route_metric6` corresponds to the
    [`ipv4.route-metric`](https://developer.gnome.org/NetworkManager/stable/nm-settings.html#nm-settings.property.ipv4.route-metric) and
    [`ipv6.route-metric`](https://developer.gnome.org/NetworkManager/stable/nm-settings.html#nm-settings.property.ipv6.route-metric)
    properties, respectively. If specified, it determines the route metric for DHCP
    assigned routes and the default route, and thus the priority for multiple interfaces.

* `route`

    Static route configuration can be specified via a list of routes given in the `route`
    option. The default value is an empty list. Each route is a dictionary with the following
    entries: `network`, `prefix`, `gateway` and `metric`. `network` and `prefix` specify
    the destination network.
    Note that Classless inter-domain routing (CIDR) notation or network mask notation are not supported yet.

* `route_append_only`

    The `route_append_only` option allows only to add new routes to the
    existing routes on the system.

    If the `route_append_only` boolean option is set to `yes`, the specified routes are appended to the existing routes.
    If `route_append_only` is set to `no` (default), the current routes are replaced.
    Note that setting `route_append_only`  to `yes` without setting `route` has the effect of preserving the current static routes.

* `rule_append_only`

    The `rule_append_only` boolean option allows to preserve the current routing rules.
    Note that specifying routing rules is not supported yet.

**Note:** When `route_append_only` or `rule_append_only` is not specified, the `network` role deletes the current routes or routing rules.

**Note:** Slaves to the bridge, bond or team devices cannot specify `ip` settings.

### `ethtool`

The ethtool settings allow to enable or disable various features. The names
correspond to the names used by the `ethtool` utility. Depending on the actual
kernel and device, changing some features might not be supported.

```yaml
  ethtool:
    features:
      esp_hw_offload: yes|no  # optional
      esp_tx_csum_hw_offload: yes|no  # optional
      fcoe_mtu: yes|no  # optional
      gro: yes|no  # optional
      gso: yes|no  # optional
      highdma: yes|no  # optional
      hw_tc_offload: yes|no  # optional
      l2_fwd_offload: yes|no  # optional
      loopback: yes|no  # optional
      lro: yes|no  # optional
      ntuple: yes|no  # optional
      rx: yes|no  # optional
      rx_all: yes|no  # optional
      rx_fcs: yes|no  # optional
      rx_gro_hw: yes|no  # optional
      rx_udp_tunnel_port_offload: yes|no  # optional
      rx_vlan_filter: yes|no  # optional
      rx_vlan_stag_filter: yes|no  # optional
      rx_vlan_stag_hw_parse: yes|no  # optional
      rxhash: yes|no  # optional
      rxvlan: yes|no  # optional
      sg: yes|no  # optional
      tls_hw_record: yes|no  # optional
      tls_hw_tx_offload: yes|no  # optional
      tso: yes|no  # optional
      tx: yes|no  # optional
      tx_checksum_fcoe_crc: yes|no  # optional
      tx_checksum_ip_generic: yes|no  # optional
      tx_checksum_ipv4: yes|no  # optional
      tx_checksum_ipv6: yes|no  # optional
      tx_checksum_sctp: yes|no  # optional
      tx_esp_segmentation: yes|no  # optional
      tx_fcoe_segmentation: yes|no  # optional
      tx_gre_csum_segmentation: yes|no  # optional
      tx_gre_segmentation: yes|no  # optional
      tx_gso_partial: yes|no  # optional
      tx_gso_robust: yes|no  # optional
      tx_ipxip4_segmentation: yes|no  # optional
      tx_ipxip6_segmentation: yes|no  # optional
      tx_nocache_copy: yes|no  # optional
      tx_scatter_gather: yes|no  # optional
      tx_scatter_gather_fraglist: yes|no  # optional
      tx_sctp_segmentation: yes|no  # optional
      tx_tcp_ecn_segmentation: yes|no  # optional
      tx_tcp_mangleid_segmentation: yes|no  # optional
      tx_tcp_segmentation: yes|no  # optional
      tx_tcp6_segmentation: yes|no  # optional
      tx_udp_segmentation: yes|no  # optional
      tx_udp_tnl_csum_segmentation: yes|no  # optional
      tx_udp_tnl_segmentation: yes|no  # optional
      tx_vlan_stag_hw_insert: yes|no  # optional
      txvlan: yes|no  # optional
```

### `ieee802_1x`

Configures 802.1x authentication for an interface.

Currently, NetworkManager is the only supported provider and EAP-TLS is the only supported EAP method.

SSL certificates and keys must be deployed on the host prior to running the role.

* `eap`

    The allowed EAP method to be used when authenticating to the network with 802.1x.

    Currently, `tls` is the default and the only accepted value.

* `identity` (required)

    Identity string for EAP authentication methods.

* `private_key` (required)

    Absolute path to the client's PEM or PKCS#12 encoded private key used for 802.1x authentication.

 * `private_key_password`

    Password to the private key specified in `private_key`.

 * `private_key_password_flags`

    List of flags to configure how the private key password is managed.

    Multiple flags may be specified.

    Valid flags are:
    - `none`
    - `agent-owned`
    - `not-saved`
    - `not-required`

    See NetworkManager documentation on "Secret flag types" more details (`man 5 nm-settings`).

 * `client_cert` (required)

    Absolute path to the client's PEM encoded certificate used for 802.1x authentication.

 * `ca_cert`

    Absolute path to the PEM encoded certificate authority used to verify the EAP server.

 * `ca_path`

    Absolute path to directory containing additional pem encoded ca certificates used to
    verify the EAP server. Can be used instead of or in addition to ca_cert. Cannot be
    used if system_ca_certs is enabled.

  * `system_ca_certs`

    If set to `True`, NetworkManager will use the system's trusted ca certificates to verify the EAP server.

  * `domain_suffix_match`

    If set, NetworkManager will ensure the domain name of the EAP server certificate matches this string.

### `bond`

The `bond` setting configures the options of bonded interfaces
(type `bond`). It supports the following options:

  * `mode`

    Bonding mode.  See the
    [kernel documentation](https://www.kernel.org/doc/Documentation/networking/bonding.txt)
    or your distribution `nmcli` documentation for valid values.
    NetworkManager defaults to `balance-rr`.

  * `miimon`

    Sets the MII link monitoring interval (in milliseconds)

Examples of Options
-------------------

Setting the same connection profile multiple times:

```yaml
network_connections:
  - name: Wired0
    type: ethernet
    interface_name: eth0
    ip:
      dhcp4: yes

  - name: Wired0
    state: up
```

Activating a preexisting connection profile:

```yaml
network_connections:
  - name: eth0
    state: up
```

Deactivating a preexisting connection profile:

```yaml
network_connections:
  - name: eth0
    state: down
```

Creating a persistent connection profile:

```yaml
network_connections:
  - name: eth0
    #persistent_state: present  # default
    type: ethernet
    autoconnect: yes
    mac: 00:00:5e:00:53:5d
    ip:
      dhcp4: yes
```

Deleting a connection profile named `eth0` (if it exists):

```yaml
network_connections:
  - name: eth0
    persistent_state: absent
```

Configuring the Ethernet link settings:

```yaml
network_connections:
  - name: eth0
    type: ethernet

    ethernet:
      autoneg: no
      speed: 1000
      duplex: full
```

Creating a bridge connection:

```yaml
network_connections:
  - name: br0
    type: bridge
    #interface_name: br0  # defaults to the connection name
```


Configuring a bridge connection:

```yaml
network_connections:
  - name: internal-br0
    interface_name: br0
    type: bridge
    ip:
      dhcp4: no
      auto6: no
```

Setting `master` and `slave_type`:

```yaml
network_connections:
  - name: br0-bond0
    type: bond
    interface_name: bond0
    master: internal-br0
    slave_type: bridge

  - name: br0-bond0-eth1
    type: ethernet
    interface_name: eth1
    master: br0-bond0
    slave_type: bond
```

Configuring VLANs:

```yaml
network_connections:
  - name: eth1-profile
    autoconnet: no
    type: ethernet
    interface_name: eth1
    ip:
      dhcp4: no
      auto6: no

  - name: eth1.6
    autoconnect: no
    type: vlan
    parent: eth1-profile
    vlan:
      id: 6
    ip:
      address:
        - 192.0.2.5/24
      auto6: no
```

Configuring MACVLAN:

```yaml
network_connections:
  - name: eth0-profile
    type: ethernet
    interface_name: eth0
    ip:
      address:
        - 192.168.0.1/24

  - name: veth0
    type: macvlan
    parent: eth0-profile
    macvlan:
      mode: bridge
      promiscuous: yes
      tap: no
    ip:
      address:
        - 192.168.1.1/24
```

Configuring a wireless connection:

```yaml
network_connections:
  - name: wlan0
    type: wireless
    wireless:
      ssid: "My WPA2-PSK Network"
      key_mgmt: "wpa-psk"
      # recommend vault encrypting the wireless password
      # see https://docs.ansible.com/ansible/latest/user_guide/vault.html
      password: "p@55w0rD"
```

Setting the IP configuration:

```yaml
network_connections:
  - name: eth0
    type: ethernet
    ip:
      route_metric4: 100
      dhcp4: no
      #dhcp4_send_hostname: no
      gateway4: 192.0.2.1

      dns:
        - 192.0.2.2
        - 198.51.100.5
      dns_search:
        - example.com
        - subdomain.example.com

      route_metric6: -1
      auto6: no
      gateway6: 2001:db8::1

      address:
        - 192.0.2.3/24
        - 198.51.100.3/26
        - 2001:db8::80/7

      route:
        - network: 198.51.100.128
          prefix: 26
          gateway: 198.51.100.1
          metric: 2
        - network: 198.51.100.64
          prefix: 26
          gateway: 198.51.100.6
          metric: 4
      route_append_only: no
      rule_append_only: yes
```

Configuring 802.1x:

```yaml
network_connections:
  - name: eth0
    type: ethernet
    ieee802_1x:
      identity: myhost
      eap: tls
      private_key: /etc/pki/tls/client.key
      # recommend vault encrypting the private key password
      # see https://docs.ansible.com/ansible/latest/user_guide/vault.html
      private_key_password: "p@55w0rD"
      client_cert: /etc/pki/tls/client.pem
      ca_cert: /etc/pki/tls/cacert.pem
      domain_suffix_match: example.com
```

### Invalid and Wrong Configuration

The `network` role rejects invalid configurations. It is recommended to test the role
with `--check` first. There is no protection against wrong (but valid) configuration.
Double-check your configuration before applying it.


Compatibility
-------------

The `network` role supports the same configuration scheme for both providers (`nm`
and `initscripts`). That means, you can use the same playbook with NetworkManager
and initscripts. However, note that not every option is handled exactly the same
by every provider. Do a test run first with `--check`.

It is not supported to create a configuration for one provider, and expect another
provider to handle them. For example, creating profiles with the `initscripts` provider,
and later enabling NetworkManager is not guaranteed to work automatically. Possibly,
you have to adjust the configuration so that it can be used by another provider.

For example, configuring a RHEL6 host with initscripts and upgrading to
RHEL7 while continuing to use initscripts in RHEL7 is an acceptable scenario. What
is not guaranteed is to upgrade to RHEL7, disable initscripts and expect NetworkManager
to take over the configuration automatically.

Depending on NetworkManager's configuration, connections may be stored as ifcfg files
as well, but it is not guaranteed that plain initscripts can handle these ifcfg files
after disabling the NetworkManager service.

Limitations
-----------

As Ansible usually works via the network, for example via SSH, there are some limitations to be considered:

The `network` role does not support bootstraping networking configuration. One
option may be [ansible-pull](https://docs.ansible.com/ansible/playbooks_intro.html#ansible-pull).
Another option maybe be to initially auto-configure the host during installation
(ISO based, kickstart, etc.), so that the host is connected to a management LAN
or VLAN. It strongly depends on your environment.

For `initscripts` provider, deploying a profile merely means to create the ifcfg
files. Nothing happens automatically until the play issues `ifup` or `ifdown`
via the `up` or `down` [states](#state) -- unless there are other
components that rely on the ifcfg files and react on changes.

The `initscripts` provider requires the different profiles to be in the right
order when they depend on each other. For example the bonding master device
needs to be specified before the slave devices.

When removing a profile for NetworkManager it also takes the connection
down and possibly removes virtual interfaces. With the `initscripts` provider
removing a profile does not change its current runtime state (this is a future
feature for NetworkManager as well).

For NetworkManager, modifying a connection with autoconnect enabled
may result in the activation of a new profile on a previously disconnected
interface. Also, deleting a NetworkManager connection that is currently active
results in removing the interface. Therefore, the order of the steps should be
followed, and carefully handling of [autoconnect](#autoconnect) property may be
necessary. This should be improved in NetworkManager RFE [rh#1401515](https://bugzilla.redhat.com/show_bug.cgi?id=1401515).

It seems difficult to change networking of the target host in a way that breaks
the current SSH connection of ansible. If you want to do that, ansible-pull might
be a solution. Alternatively, a combination of `async`/`poll` with changing
the `ansible_host` midway of the play.

**TODO** The current role does not yet support to easily split the
play in a pre-configure step, and a second step to activate the new configuration.

In general, to successfully run the play, determine which configuration is
active in the first place, and then carefully configure a sequence of steps to change to
the new configuration. The actual solution depends strongly on your environment.

### Handling potential problems

When something goes wrong while configuring networking remotely, you might need
to get physical access to the machine to recover.

**TODO** NetworkManager supports a
[checkpoint/rollback](https://developer.gnome.org/NetworkManager/stable/gdbus-org.freedesktop.NetworkManager.html#gdbus-method-org-freedesktop-NetworkManager.CheckpointCreate)
feature. At the beginning of the play we could create a checkpoint and if we lose
connectivity due to an error, NetworkManager would automatically rollback after
timeout. The limitations is that this would only work with NetworkManager, and
it is not clear that rollback will result in a working configuration.


*Want to contribute? Take a look at our [contributing
guidelines](https://github.com/linux-system-roles/network/blob/master/contributing.md)!*
