/*
 * Copyright 2012-2017 Red Hat, Inc.
 *
 * This file is part of Thermostat.
 *
 * Thermostat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * Thermostat is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Thermostat; see the file COPYING.  If not see
 * <http://www.gnu.org/licenses/>.
 *
 * Linking this code with other modules is making a combined work
 * based on this code.  Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this code give
 * you permission to link this code with independent modules to
 * produce an executable, regardless of the license terms of these
 * independent modules, and to copy and distribute the resulting
 * executable under terms of your choice, provided that you also
 * meet, for each linked independent module, the terms and conditions
 * of the license of that module.  An independent module is a module
 * which is not derived from or based on this code.  If you modify
 * this code, you may extend this exception to your version of the
 * library, but you are not obligated to do so.  If you do not wish
 * to do so, delete this exception statement from your version.
 */

package com.redhat.thermostat.vm.profiler.client.swing.internal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.redhat.thermostat.client.swing.components.experimental.TreeMap;
import com.redhat.thermostat.client.swing.components.experimental.TreeMapNode;
import com.redhat.thermostat.vm.profiler.client.swing.internal.SwingVmProfileTreeMapView.TimeToolTipRenderer;

public class TimeToolTipRendererTest {

    private static final String ROOT_LABEL = "root";
    private static final String CHILD_LABEL = "child";
    private static final double ROOT_WEIGHT = 1024.0;
    private static final double CHILD_WEIGHT = 3.14;

    private TimeToolTipRenderer renderer;
    private TreeMapNode root;

    @Before
    public void setUp() {
        root = new TreeMapNode(ROOT_LABEL, ROOT_WEIGHT);
        root.addChild(new TreeMapNode(CHILD_LABEL, CHILD_WEIGHT));
        renderer = new TimeToolTipRenderer();
    }

    @Test
    public void testTimeToolTipRenderer() {
        String result = renderer.render(root);
        assertEquals("root - 1024ms", result);

        TreeMapNode child = TreeMap.searchNode(root, CHILD_LABEL);
        assertNotNull(child);
        result = renderer.render(child);
        assertEquals("child - 3ms", result);
    }
}
