/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.demo;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class SWTTimeSeriesDemo {
    private static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Legal & General Unit Trust Prices", (String)"Date", (String)"Price Per Unit", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MMM-yyyy"));
        return chart;
    }

    private static XYDataset createDataset() {
        TimeSeries s1 = new TimeSeries((Comparable)((Object)"L&G European Index Trust"));
        s1.add((RegularTimePeriod)new Month(2, 2001), 181.8);
        s1.add((RegularTimePeriod)new Month(3, 2001), 167.3);
        s1.add((RegularTimePeriod)new Month(4, 2001), 153.8);
        s1.add((RegularTimePeriod)new Month(5, 2001), 167.6);
        s1.add((RegularTimePeriod)new Month(6, 2001), 158.8);
        s1.add((RegularTimePeriod)new Month(7, 2001), 148.3);
        s1.add((RegularTimePeriod)new Month(8, 2001), 153.9);
        s1.add((RegularTimePeriod)new Month(9, 2001), 142.7);
        s1.add((RegularTimePeriod)new Month(10, 2001), 123.2);
        s1.add((RegularTimePeriod)new Month(11, 2001), 131.8);
        s1.add((RegularTimePeriod)new Month(12, 2001), 139.6);
        s1.add((RegularTimePeriod)new Month(1, 2002), 142.9);
        s1.add((RegularTimePeriod)new Month(2, 2002), 138.7);
        s1.add((RegularTimePeriod)new Month(3, 2002), 137.3);
        s1.add((RegularTimePeriod)new Month(4, 2002), 143.9);
        s1.add((RegularTimePeriod)new Month(5, 2002), 139.8);
        s1.add((RegularTimePeriod)new Month(6, 2002), 137.0);
        s1.add((RegularTimePeriod)new Month(7, 2002), 132.8);
        TimeSeries s2 = new TimeSeries((Comparable)((Object)"L&G UK Index Trust"));
        s2.add((RegularTimePeriod)new Month(2, 2001), 129.6);
        s2.add((RegularTimePeriod)new Month(3, 2001), 123.2);
        s2.add((RegularTimePeriod)new Month(4, 2001), 117.2);
        s2.add((RegularTimePeriod)new Month(5, 2001), 124.1);
        s2.add((RegularTimePeriod)new Month(6, 2001), 122.6);
        s2.add((RegularTimePeriod)new Month(7, 2001), 119.2);
        s2.add((RegularTimePeriod)new Month(8, 2001), 116.5);
        s2.add((RegularTimePeriod)new Month(9, 2001), 112.7);
        s2.add((RegularTimePeriod)new Month(10, 2001), 101.5);
        s2.add((RegularTimePeriod)new Month(11, 2001), 106.1);
        s2.add((RegularTimePeriod)new Month(12, 2001), 110.3);
        s2.add((RegularTimePeriod)new Month(1, 2002), 111.7);
        s2.add((RegularTimePeriod)new Month(2, 2002), 111.0);
        s2.add((RegularTimePeriod)new Month(3, 2002), 109.6);
        s2.add((RegularTimePeriod)new Month(4, 2002), 113.2);
        s2.add((RegularTimePeriod)new Month(5, 2002), 111.6);
        s2.add((RegularTimePeriod)new Month(6, 2002), 108.8);
        s2.add((RegularTimePeriod)new Month(7, 2002), 101.6);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    public static void main(String[] args) {
        JFreeChart chart = SWTTimeSeriesDemo.createChart(SWTTimeSeriesDemo.createDataset());
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(600, 300);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Time series demo for jfreechart running with SWT");
        ChartComposite frame = new ChartComposite((Composite)shell, 0, chart, true);
        frame.setDisplayToolTips(true);
        frame.setHorizontalAxisTrace(false);
        frame.setVerticalAxisTrace(false);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

