/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;

public class StreamSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamSource/feature";
    private String publicId = null;
    private String systemId = null;
    private InputStream inputStream = null;
    private Reader reader = null;

    public StreamSource() {
    }

    public StreamSource(File file) {
        this.setSystemId(file);
    }

    public StreamSource(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public StreamSource(InputStream inputStream, String string) {
        this.inputStream = inputStream;
        this.systemId = string;
    }

    public StreamSource(Reader reader) {
        this.reader = reader;
    }

    public StreamSource(Reader reader, String string) {
        this.reader = reader;
        this.systemId = string;
    }

    public StreamSource(String string) {
        this.systemId = string;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setSystemId(File file) {
        try {
            this.systemId = StreamSource.fileToURL(file).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    static String fileToURL(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("no such file: " + file.getName());
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return "file:" + string;
    }
}

