/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            if (pdfPRow.cells[i] == null) continue;
            this.cells[i] = new PdfPCell(pdfPRow.cells[i]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f = 0.0f;
        this.calculated = false;
        for (int i = 0; i < fArray.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            pdfPCell.setLeft(f);
            int n = i + pdfPCell.getColspan();
            while (i < n) {
                f += fArray[i];
                ++i;
            }
            --i;
            pdfPCell.setRight(f);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i = 0; i < this.cells.length; ++i) {
            float f;
            float f2;
            float f3;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            boolean bl = pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270;
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f3 = bl ? image.getScaledHeight() : image.getScaledWidth();
                f2 = (pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getLeft()) / f3;
                image.scalePercent(f2 * 100.0f);
                f = bl ? image.getScaledWidth() : image.getScaledHeight();
                pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - f);
            } else if (bl && pdfPCell.hasFixedHeight()) {
                pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getFixedHeight());
            } else {
                float f4;
                float f5;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                if (bl) {
                    f2 = 20000.0f;
                    f = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                    f5 = 0.0f;
                    f4 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                } else {
                    f2 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                    f = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                    f5 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                    f4 = pdfPCell.hasFixedHeight() ? f + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getFixedHeight() : -1.0737418E9f;
                }
                this.setColumn(columnText, f5, f4, f2, f);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                if (bl) {
                    pdfPCell.setBottom(pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - columnText.getFilledWidth());
                } else {
                    float f6 = columnText.getYLine();
                    if (pdfPCell.isUseDescender()) {
                        f6 += columnText.getDescender();
                    }
                    pdfPCell.setBottom(f6 - pdfPCell.getEffectivePaddingBottom());
                }
            }
            f3 = pdfPCell.getFixedHeight();
            if (f3 <= 0.0f) {
                f3 = pdfPCell.getHeight();
            }
            if (f3 < pdfPCell.getFixedHeight()) {
                f3 = pdfPCell.getFixedHeight();
            } else if (f3 < pdfPCell.getMinimumHeight()) {
                f3 = pdfPCell.getMinimumHeight();
            }
            if (!(f3 > this.maxHeight)) continue;
            this.maxHeight = f3;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f, float f2, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        Color color = pdfPCell.getBackgroundColor();
        if (color != null || pdfPCell.hasBorders()) {
            Object object;
            float f3 = pdfPCell.getRight() + f;
            float f4 = pdfPCell.getTop() + f2;
            float f5 = pdfPCell.getLeft() + f;
            float f6 = f4 - this.maxHeight;
            if (color != null) {
                object = pdfContentByteArray[1];
                ((PdfContentByte)object).setColorFill(color);
                ((PdfContentByte)object).rectangle(f5, f6, f3 - f5, f4 - f6);
                ((PdfContentByte)object).fill();
            }
            if (pdfPCell.hasBorders()) {
                object = new Rectangle(f5, f6, f3, f4);
                ((Rectangle)object).cloneNonPositionParameters(pdfPCell);
                ((Rectangle)object).setBackgroundColor(null);
                PdfContentByte pdfContentByte = pdfContentByteArray[2];
                pdfContentByte.rectangle((Rectangle)object);
            }
        }
    }

    private void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f, float f2, float f3, float f4, float f5, float f6) {
        int n = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n * 2];
        }
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            this.canvasesPos[i * 2] = byteBuffer.size();
            pdfContentByteArray[i].saveState();
            pdfContentByteArray[i].concatCTM(f, f2, f3, f4, f5, f6);
            this.canvasesPos[i * 2 + 1] = byteBuffer.size();
        }
    }

    private void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n = 4;
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            int n2 = byteBuffer.size();
            pdfContentByteArray[i].restoreState();
            if (n2 != this.canvasesPos[i * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i * 2]);
        }
    }

    private float setColumn(ColumnText columnText, float f, float f2, float f3, float f4) {
        if (f > f3) {
            f3 = f;
        }
        if (f2 > f4) {
            f4 = f2;
        }
        columnText.setSimpleColumn(f, f2, f3, f4);
        return f4;
    }

    public void writeCells(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        n2 = n2 < 0 ? this.cells.length : Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            f -= this.widths[n3 - 1];
        }
        f -= this.cells[n3].getLeft();
        for (int i = n3; i < n2; ++i) {
            float f3;
            float f4;
            float f5;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackground(f, f2, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f6 = 0.0f;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f6 = pdfPCell.getTop() + f2 - this.maxHeight + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                case 5: {
                    f6 = pdfPCell.getTop() + f2 + (pdfPCell.getHeight() - this.maxHeight) / 2.0f - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                default: {
                    f6 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.getHeight() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f5 = (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.getScaledHeight();
                    image.scalePercent(f5 * 100.0f);
                    bl = true;
                }
                f5 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 = f + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f5 = f + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth();
                            break;
                        }
                    }
                    f6 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f5, f6 - image.getScaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f7 = this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f5 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f7 + 0.001f, -f5);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f8 = -columnText.getYLine();
                if (f7 <= 0.0f || f5 <= 0.0f) {
                    f8 = 0.0f;
                }
                if (f8 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f8 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(0.0f, -0.001f, f7 + 0.001f, f8);
                    if (pdfPCell.getRotation() == 90) {
                        f4 = pdfPCell.getTop() + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.getLeft() + f + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f8) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft() + f8;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f3, f4);
                    } else {
                        f4 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.getLeft() + f + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f8) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.getLeft() + f + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f8;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f3, f4);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f9 = pdfPCell.getFixedHeight();
                f5 = pdfPCell.getRight() + f - pdfPCell.getEffectivePaddingRight();
                float f10 = pdfPCell.getLeft() + f + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 += 10000.0f;
                            f10 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            if (pdfPCell.getRotation() == 180) {
                                f5 += 20000.0f;
                                break;
                            }
                            f10 -= 20000.0f;
                            break;
                        }
                        default: {
                            if (pdfPCell.getRotation() == 180) {
                                f10 -= 20000.0f;
                                break;
                            }
                            f5 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f3 = f6 - (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f9 > 0.0f && pdfPCell.getHeight() > this.maxHeight) {
                    f6 = pdfPCell.getTop() + f2 - pdfPCell.getEffectivePaddingTop();
                    f3 = pdfPCell.getTop() + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                }
                if ((f6 > f3 || columnText.zeroHeightElement()) && f10 < f5) {
                    columnText.setSimpleColumn(f10, f3 - 0.001f, f5, f6);
                    if (pdfPCell.getRotation() == 180) {
                        f4 = f10 + f5;
                        float f11 = f2 + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f4, f11);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f, pdfPCell.getTop() + f2 - this.maxHeight, pdfPCell.getRight() + f, pdfPCell.getTop() + f2);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f) {
        this.maxHeight = f;
    }

    float[] getEventWidth(float f) {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i].getWidth();
            ++n;
        }
        return fArray;
    }

    public PdfPRow splitRow(float f) {
        PdfPCell pdfPCell;
        int n;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length];
        float[] fArray2 = new float[this.cells.length];
        boolean bl = true;
        for (n = 0; n < this.cells.length; ++n) {
            pdfPCell = this.cells[n];
            if (pdfPCell == null) continue;
            fArray[n] = pdfPCell.getFixedHeight();
            fArray2[n] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    pdfPCell2.setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n2;
                float f2;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f3 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                float f4 = pdfPCell.getTop() + pdfPCell.getEffectivePaddingBottom() - f;
                float f5 = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                float f6 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                switch (pdfPCell.getRotation()) {
                    case 90: 
                    case 270: {
                        f2 = this.setColumn(columnText, f4, f3, f6, f5);
                        break;
                    }
                    default: {
                        f2 = this.setColumn(columnText, f3, f4, pdfPCell.isNoWrap() ? 20000.0f : f5, f6);
                    }
                }
                try {
                    n2 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f2;
                if (bl2) {
                    pdfPCell2.setColumn(ColumnText.duplicate(pdfPCell.getColumn()));
                    columnText.setFilledWidth(0.0f);
                } else if ((n2 & 1) == 0) {
                    pdfPCell2.setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    pdfPCell2.setPhrase(null);
                }
                bl = bl && bl2;
            }
            pdfPCellArray[n] = pdfPCell2;
            pdfPCell.setFixedHeight(f);
        }
        if (bl) {
            for (n = 0; n < this.cells.length; ++n) {
                pdfPCell = this.cells[n];
                if (pdfPCell == null) continue;
                if (fArray[n] > 0.0f) {
                    pdfPCell.setFixedHeight(fArray[n]);
                    continue;
                }
                pdfPCell.setMinimumHeight(fArray2[n]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

