/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MeterChartDemo1
extends ApplicationFrame {
    private static DefaultValueDataset dataset;

    public MeterChartDemo1(String string) {
        super(string);
        JPanel jPanel = MeterChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(ValueDataset valueDataset) {
        MeterPlot meterPlot = new MeterPlot(valueDataset);
        meterPlot.setRange(new Range(0.0, 60.0));
        meterPlot.addInterval(new MeterInterval("Normal", new Range(0.0, 35.0), Color.lightGray, new BasicStroke(2.0f), new Color(0, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval("Warning", new Range(35.0, 50.0), Color.lightGray, new BasicStroke(2.0f), new Color(255, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval("Critical", new Range(50.0, 60.0), Color.lightGray, new BasicStroke(2.0f), new Color(255, 0, 0, 128)));
        meterPlot.setNeedlePaint(Color.darkGray);
        meterPlot.setDialBackgroundPaint(Color.white);
        meterPlot.setDialOutlinePaint(Color.gray);
        meterPlot.setDialShape(DialShape.CHORD);
        meterPlot.setMeterAngle(260);
        meterPlot.setTickLabelsVisible(true);
        meterPlot.setTickLabelFont(new Font("Dialog", 1, 10));
        meterPlot.setTickLabelPaint(Color.darkGray);
        meterPlot.setTickSize(5.0);
        meterPlot.setTickPaint(Color.lightGray);
        meterPlot.setValuePaint(Color.black);
        meterPlot.setValueFont(new Font("Dialog", 1, 14));
        JFreeChart jFreeChart = new JFreeChart("Meter Chart 1", JFreeChart.DEFAULT_TITLE_FONT, meterPlot, true);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        dataset = new DefaultValueDataset(23.0);
        JFreeChart jFreeChart = MeterChartDemo1.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        MeterChartDemo1 meterChartDemo1 = new MeterChartDemo1("JFreeChart: MeterChartDemo1.java");
        meterChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)meterChartDemo1));
        meterChartDemo1.setVisible(true);
    }
}

