/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.BooleanList;

public class BooleanListTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$BooleanListTests;

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$BooleanListTests == null ? (class$org$jfree$util$junit$BooleanListTests = BooleanListTests.class$("org.jfree.util.junit.BooleanListTests")) : class$org$jfree$util$junit$BooleanListTests);
    }

    public BooleanListTests(String name) {
        super(name);
    }

    public void testEquals() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = new BooleanList();
        l2.setBoolean(0, Boolean.TRUE);
        l2.setBoolean(1, Boolean.FALSE);
        l2.setBoolean(2, null);
        BooleanListTests.assertTrue((boolean)l1.equals(l2));
        BooleanListTests.assertTrue((boolean)l2.equals(l2));
    }

    public void testCloning() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = null;
        try {
            l2 = (BooleanList)l1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("BooleanListTests.testCloning: failed to clone.");
        }
        BooleanListTests.assertTrue((l1 != l2 ? 1 : 0) != 0);
        BooleanListTests.assertTrue((l1.getClass() == l2.getClass() ? 1 : 0) != 0);
        BooleanListTests.assertTrue((boolean)l1.equals(l2));
        l2.setBoolean(0, Boolean.FALSE);
        BooleanListTests.assertFalse((boolean)l1.equals(l2));
    }

    public void testSerialization() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (BooleanList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        BooleanListTests.assertEquals((Object)l1, l2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

