/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JArrayType;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JObjectType;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public abstract class JType {
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;
    public static final int T_VOID = 12;
    public static final int T_ARRAY = 13;
    public static final int T_OBJECT = 14;
    public static final int T_UNKNOWN = 15;
    public static final int T_ADDRESS = 16;
    public static final int T_REFERENCE = 17;
    public static final JType[] EMPTY_ARRAY = new JType[0];
    public static JType VOID = new JType(){

        public int getSize() {
            return 0;
        }

        public String getSignature() {
            return "V";
        }

        public int getTag() {
            return 12;
        }

        public String toString() {
            return "void";
        }

        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type VOID is no real data type therefore cannot be assigned to " + other.toString());
        }
    };
    public static JType BOOLEAN = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "Z";
        }

        public int getTag() {
            return 4;
        }

        public String toString() {
            return "boolean";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType BYTE = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "B";
        }

        public int getTag() {
            return 8;
        }

        public String toString() {
            return "byte";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType CHAR = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "C";
        }

        public int getTag() {
            return 5;
        }

        public String toString() {
            return "char";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType SHORT = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "S";
        }

        public int getTag() {
            return 9;
        }

        public String toString() {
            return "short";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType INT = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "I";
        }

        public int getTag() {
            return 10;
        }

        public String toString() {
            return "int";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType FLOAT = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            return "F";
        }

        public int getTag() {
            return 6;
        }

        public String toString() {
            return "float";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == FLOAT;
        }
    };
    public static JType LONG = new JType(){

        public int getSize() {
            return 2;
        }

        public String getSignature() {
            return "J";
        }

        public int getTag() {
            return 11;
        }

        public String toString() {
            return "long";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == LONG;
        }
    };
    public static JType DOUBLE = new JType(){

        public int getSize() {
            return 2;
        }

        public String getSignature() {
            return "D";
        }

        public int getTag() {
            return 7;
        }

        public String toString() {
            return "double";
        }

        public boolean isValueType() {
            return true;
        }

        public boolean isCompatibleWith(JType other) {
            return other == DOUBLE;
        }
    };
    public static JType REFERENCE = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            throw new UnsupportedOperationException("type REFERENCE is no real data type and therefore has no signature");
        }

        public int getTag() {
            return 17;
        }

        public String toString() {
            return "<reference>";
        }

        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type REFERENCE is no real data type and therefore cannot be assigned to " + other.toString());
        }
    };
    public static JType ADDRESS = new JType(){

        public int getSize() {
            return 1;
        }

        public String getSignature() {
            throw new UnsupportedOperationException("type ADDRESS is no usable data type and therefore has no signature");
        }

        public int getTag() {
            return 16;
        }

        public String toString() {
            return "<address>";
        }

        public boolean isCompatibleWith(JType other) {
            return other == ADDRESS;
        }
    };
    public static JType UNKNOWN = new JType(){

        public int getSize() {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore has no size");
        }

        public String getSignature() {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore has no signature");
        }

        public int getTag() {
            return 15;
        }

        public String toString() {
            return "<unknown>";
        }

        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore cannot be assigned to " + other.toString());
        }
    };

    public abstract int getSize();

    public abstract String getSignature();

    public abstract int getTag();

    public abstract String toString();

    public abstract boolean isCompatibleWith(JType var1);

    public boolean isValueType() {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isReferenceType() {
        return false;
    }

    protected static JType parseSig(StringReader s) throws IOException {
        int nextChar = s.read();
        if (nextChar == -1) {
            throw new IllegalArgumentException();
        }
        switch ((char)nextChar) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'L': {
                StringBuffer className = new StringBuffer();
                while ((nextChar = s.read()) != -1 && nextChar != 59) {
                    className.append((char)(nextChar == 47 ? 58 : (char)nextChar));
                }
                if (nextChar != 59) {
                    throw new IllegalArgumentException();
                }
                return new JObjectType(className.toString());
            }
            case '[': {
                JType elemType = JType.parseSig(s);
                return new JArrayType(elemType);
            }
            case '(': {
                ArrayList<JType> argTps = new ArrayList<JType>();
                while (true) {
                    s.mark(1);
                    nextChar = s.read();
                    if (nextChar == -1 || nextChar == 41) break;
                    s.reset();
                    argTps.add(JType.parseSig(s));
                }
                if (nextChar != 41) {
                    throw new IllegalArgumentException("a");
                }
                JType[] argTpsA = argTps.toArray(new JType[argTps.size()]);
                JType returnType = JType.parseSig(s);
                return new JMethodType(returnType, argTpsA);
            }
        }
        throw new IllegalArgumentException();
    }

    public static JType parseSignature(String signature) {
        try {
            StringReader sigReader = new StringReader(signature);
            JType parsed = JType.parseSig(sigReader);
            if (sigReader.read() != -1) {
                throw new IllegalArgumentException();
            }
            return parsed;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid signature " + signature);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static int getTotalSize(JType[] types) {
        int size = 0;
        for (int i = 0; i < types.length; ++i) {
            size += types[i].getSize();
        }
        return size;
    }

    protected JType() {
    }

    protected static String tagToString(int tag) {
        switch (tag) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 12: {
                return "void";
            }
            case 13: {
                return "[]";
            }
            case 14: {
                return "Object";
            }
            case 15: {
                return "<unknown>";
            }
            case 16: {
                return "<address>";
            }
        }
        return String.valueOf(tag);
    }
}

