/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.PrintStream;
import scala.Console$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Source;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.sys.package$;
import scala.xml.Comment;
import scala.xml.Document;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PCData$;
import scala.xml.PrefixedAttribute;
import scala.xml.ProcInstr;
import scala.xml.SpecialNode;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TextBuffer$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;
import scala.xml.Utility$Escapes$;
import scala.xml.dtd.AttrDecl;
import scala.xml.dtd.DEFAULT;
import scala.xml.dtd.DTD;
import scala.xml.dtd.Decl;
import scala.xml.dtd.ExtDef;
import scala.xml.dtd.ExternalID;
import scala.xml.dtd.IMPLIED$;
import scala.xml.dtd.IntDef;
import scala.xml.dtd.PublicID;
import scala.xml.dtd.REQUIRED$;
import scala.xml.dtd.SystemID;
import scala.xml.parsing.FatalError;
import scala.xml.parsing.MarkupHandler;
import scala.xml.parsing.MarkupParser;

public abstract class MarkupParser$class {
    public static Nothing$ truncatedError(MarkupHandler $this, String msg) {
        throw new FatalError(msg);
    }

    public static Nothing$ errorNoEnd(MarkupHandler $this, String tag) {
        throw new FatalError(new StringBuilder().append((Object)"expected closing tag of ").append((Object)tag).toString());
    }

    public static void xHandleError(MarkupHandler $this, char that, String msg) {
        $this.reportSyntaxError(msg);
    }

    public static BufferedIterator lookahead(MarkupHandler $this) {
        BufferedIterator<Object> bufferedIterator;
        Source source = $this.curInput();
        if (source instanceof MarkupParser.WithLookAhead) {
            MarkupParser.WithLookAhead x2 = (MarkupParser.WithLookAhead)source;
            bufferedIterator = x2.lookahead();
        } else {
            MarkupParser.WithLookAhead newInput = new MarkupParser.WithLookAhead($this, $this.curInput());
            $this.curInput_$eq(newInput);
            bufferedIterator = newInput.lookahead();
        }
        return bufferedIterator;
    }

    public static char ch(MarkupHandler $this) {
        if ($this.nextChNeeded()) {
            if ($this.curInput().hasNext()) {
                $this.lastChRead_$eq($this.curInput().next());
                $this.pos_$eq($this.curInput().pos());
            } else {
                int ilen = $this.inpStack().length();
                if (ilen != $this.extIndex() && ilen > 0) {
                    $this.pop();
                } else {
                    $this.reachedEof_$eq(true);
                    $this.lastChRead_$eq((char)0);
                }
            }
            $this.nextChNeeded_$eq(false);
        }
        return $this.lastChRead();
    }

    public static boolean eof(MarkupHandler $this) {
        $this.ch();
        return $this.reachedEof();
    }

    public static MetaData xmlProcInstr(MarkupHandler $this) {
        $this.xToken(Predef$.MODULE$.wrapString("xml"));
        $this.xSpace();
        Tuple2<MetaData, NamespaceBinding> tuple2 = $this.xAttributes(TopScope$.MODULE$);
        if (tuple2 != null) {
            NamespaceBinding scp;
            Tuple2<MetaData, NamespaceBinding> tuple22;
            MetaData md = tuple2._1();
            NamespaceBinding scp2 = tuple2._2();
            Tuple2<MetaData, NamespaceBinding> tuple23 = tuple22 = new Tuple2<MetaData, NamespaceBinding>(md, scp2);
            MetaData md2 = tuple23._1();
            NamespaceBinding namespaceBinding = scp = tuple23._2();
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (namespaceBinding == null ? topScope$ != null : !((Object)namespaceBinding).equals(topScope$)) {
                $this.reportSyntaxError("no xmlns definitions here, please.");
            }
            $this.xToken('?');
            $this.xToken('>');
            return md2;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Tuple3 prologOrTextDecl(MarkupHandler $this, boolean isProlog) {
        void var4_11;
        void var3_7;
        void var2_4;
        Seq<Node> seq;
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ none$3 = None$.MODULE$;
        MetaData m = $this.xmlProcInstr();
        int n = 0;
        if (isProlog) {
            $this.xSpaceOpt();
        }
        if ((seq = m.apply("version")) == null) {
            Seq<Node> x4 = seq;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String p2;
            String string2;
            Option<String> o11 = Text$.MODULE$.unapply(seq);
            if (!o11.isEmpty() && "1.0".equals(string2 = (p2 = o11.get()))) {
                String x5 = p2;
                Some<String> some = new Some<String>("1.0");
                ++n;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.reportSyntaxError("cannot deal with versions != 1.0");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        Seq<Node> seq2 = m.apply("encoding");
        if (seq2 == null) {
            Seq<Node> x3 = seq2;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            Option<String> o9 = Text$.MODULE$.unapply(seq2);
            if (o9.isEmpty()) {
                throw new MatchError(seq2);
            }
            String enc = o9.get();
            if ($this.isValidIANAEncoding(Predef$.MODULE$.wrapString(enc))) {
                Some<String> some = new Some<String>(enc);
                ++n;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit2;
                $this.reportSyntaxError(new StringBuilder().append((Object)"\"").append((Object)enc).append((Object)"\" is not a valid encoding").toString());
                boxedUnit = boxedUnit2 = BoxedUnit.UNIT;
            }
        }
        if (isProlog) {
            Seq<Node> seq3 = m.apply("standalone");
            if (seq3 == null) {
                Seq<Node> x6 = seq3;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String p2;
                String string3;
                Option<String> o14 = Text$.MODULE$.unapply(seq3);
                if (!o14.isEmpty() && "yes".equals(string3 = (p2 = o14.get()))) {
                    String x7 = p2;
                    Some<Boolean> some = new Some<Boolean>(BoxesRunTime.boxToBoolean(true));
                    ++n;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String p4;
                    String string4;
                    Option<String> o16 = Text$.MODULE$.unapply(seq3);
                    if (!o16.isEmpty() && "no".equals(string4 = (p4 = o16.get()))) {
                        String x8 = p4;
                        Some<Boolean> some = new Some<Boolean>(BoxesRunTime.boxToBoolean(false));
                        ++n;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        $this.reportSyntaxError("either 'yes' or 'no' expected");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
        if (m.length() - n != 0) {
            String s2 = isProlog ? "SDDecl? " : "";
            $this.reportSyntaxError(new StringOps(Predef$.MODULE$.augmentString("VersionInfo EncodingDecl? %sor '?>' expected!")).format(Predef$.MODULE$.genericWrapArray(new Object[]{s2})));
        }
        return new Tuple3<void, void, void>(var2_4, var3_7, var4_11);
    }

    public static Tuple3 prolog(MarkupHandler $this) {
        return MarkupParser$class.prologOrTextDecl($this, true);
    }

    public static Tuple2 textDecl(MarkupHandler $this) {
        Tuple3 tuple3 = MarkupParser$class.prologOrTextDecl($this, false);
        if (tuple3 != null) {
            Option x1 = (Option)tuple3._1();
            Option x2 = (Option)tuple3._2();
            Option p2 = (Option)tuple3._3();
            Tuple2<Option, Option> tuple2 = new Tuple2<Option, Option>(x1, x2);
            return tuple2;
        }
        throw new MatchError(tuple3);
    }

    public static Document document(MarkupHandler $this) {
        $this.doc_$eq(new Document());
        $this.dtd_$eq(null);
        Tuple3<Option, Option, Option> info_prolog = new Tuple3<None$, None$, None$>(None$.MODULE$, None$.MODULE$, None$.MODULE$);
        if ('<' != $this.ch()) {
            $this.reportSyntaxError("< expected");
            return null;
        }
        $this.nextch();
        NodeSeq children = null;
        if ('?' == $this.ch()) {
            $this.nextch();
            info_prolog = $this.prolog();
            $this.doc().version_$eq(info_prolog._1());
            $this.doc().encoding_$eq(info_prolog._2());
            $this.doc().standAlone_$eq(info_prolog._3());
            children = $this.content(TopScope$.MODULE$);
        } else {
            NodeBuffer ts = new NodeBuffer();
            $this.content1(TopScope$.MODULE$, ts);
            ts.$amp$plus($this.content(TopScope$.MODULE$));
            children = NodeSeq$.MODULE$.fromSeq(ts);
        }
        IntRef elemCount = new IntRef(0);
        ObjectRef<Object> theNode = new ObjectRef<Object>(null);
        children.foreach(new Serializable($this, elemCount, theNode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MarkupHandler $outer;
            private final IntRef elemCount$1;
            private final ObjectRef theNode$1;

            public final void apply(Node c) {
                Node node;
                block10: {
                    block6: {
                        block9: {
                            BoxedUnit boxedUnit;
                            block8: {
                                block7: {
                                    block5: {
                                        node = c;
                                        if (!(node instanceof ProcInstr)) break block5;
                                        ProcInstr x2 = (ProcInstr)node;
                                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (!(node instanceof Comment)) break block7;
                                    Comment x3 = (Comment)node;
                                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!(node instanceof EntityRef)) break block8;
                                EntityRef x4 = (EntityRef)node;
                                ((MarkupParser)((Object)this.$outer)).reportSyntaxError("no entity references allowed here");
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                break block6;
                            }
                            if (!(node instanceof SpecialNode)) break block9;
                            SpecialNode x5 = (SpecialNode)node;
                            if (x5.toString().trim().length() > 0) {
                                this.elemCount$1.elem += 2;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit5 = boxedUnit;
                            break block6;
                        }
                        if (node == null) break block10;
                        Node x6 = node;
                        ++this.elemCount$1.elem;
                        this.theNode$1.elem = x6;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(node);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.elemCount$1 = elemCount$1;
                this.theNode$1 = theNode$1;
            }
        });
        if (1 != elemCount.elem) {
            $this.reportSyntaxError("document must contain exactly one element");
            Console$.MODULE$.println(children.toList());
        }
        $this.doc().children_$eq(children);
        $this.doc().docElem_$eq((Node)theNode.elem);
        return $this.doc();
    }

    public static StringBuilder putChar(MarkupHandler $this, char c) {
        return $this.cbuf().append(c);
    }

    public static MarkupHandler initialize(MarkupHandler $this) {
        $this.nextch();
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public static char ch_returning_nextch(MarkupHandler $this) {
        void var1_1;
        char res = $this.ch();
        $this.nextch();
        return (char)var1_1;
    }

    public static Tuple2 mkAttributes(MarkupHandler $this, String name, NamespaceBinding pscope) {
        return $this.isNameStart($this.ch()) ? $this.xAttributes(pscope) : new Tuple2<MetaData, NamespaceBinding>(Null$.MODULE$, pscope);
    }

    public static NodeSeq mkProcInstr(MarkupHandler $this, int position, String name, String text2) {
        return $this.scala$xml$parsing$MarkupParser$$handle().procInstr(position, name, text2);
    }

    public static void nextch(MarkupHandler $this) {
        $this.ch();
        $this.nextChNeeded_$eq(true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Tuple2 xAttributes(MarkupHandler $this, NamespaceBinding pscope) {
        scope = pscope;
        aMap /* !! */  = Null$.MODULE$;
        while ($this.isNameStart($this.ch())) {
            pos = $this.pos();
            qname = $this.xName();
            $this.xEQ();
            _ = BoxedUnit.UNIT;
            value = $this.xAttributeValue();
            rc7 = false;
            x3 = null;
            var10_10 = Utility$.MODULE$.prefix(qname);
            if (!(var10_10 instanceof Some)) ** GOTO lbl-1000
            rc7 = true;
            x3 = (Some)var10_10;
            if (x3 == null) ** GOTO lbl-1000
            var12_12 = p2 = (String)x3.x();
            if (!("xmlns" != null ? "xmlns".equals(var12_12) == false : var12_12 != null)) {
                x5 = p2;
                prefix = qname.substring(6, qname.length());
                scope = new NamespaceBinding(prefix, value, scope);
                var14_14 = BoxedUnit.UNIT;
            } else if (rc7 && x3 != null) {
                prefix = (String)x3.x();
                key = qname.substring(prefix.length() + 1, qname.length());
                aMap /* !! */  = new PrefixedAttribute(prefix, key, Text$.MODULE$.apply(value), (MetaData)aMap /* !! */ );
                var14_14 = BoxedUnit.UNIT;
            } else {
                v0 = qname;
                var18_18 = "xmlns";
                if (!(v0 != null ? v0.equals(var18_18) == false : var18_18 != null)) {
                    scope = new NamespaceBinding(null, value, scope);
                    v1 = BoxedUnit.UNIT;
                } else {
                    aMap /* !! */  = new UnprefixedAttribute(qname, Text$.MODULE$.apply(value), (MetaData)aMap /* !! */ );
                    v1 = var14_14 = BoxedUnit.UNIT;
                }
            }
            if ($this.ch() == '/' || $this.ch() == '>' || '?' == $this.ch()) continue;
            $this.xSpace();
        }
        if (!aMap /* !! */ .wellformed(scope)) {
            $this.reportSyntaxError("double attribute");
        }
        return new Tuple2<Null$, NamespaceBinding>(aMap /* !! */ , scope);
    }

    /*
     * WARNING - void declaration
     */
    public static String xEntityValue(MarkupHandler $this) {
        void var2_2;
        char endch = $this.ch();
        $this.nextch();
        while ($this.ch() != endch && !$this.eof()) {
            $this.putChar($this.ch());
            $this.nextch();
        }
        $this.nextch();
        String str = $this.cbuf().toString();
        $this.cbuf().length_$eq(0);
        return var2_2;
    }

    public static NodeSeq xCharData(MarkupHandler $this) {
        $this.xToken(Predef$.MODULE$.wrapString("[CDATA["));
        return $this.xTakeUntil(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MarkupHandler $outer;

            public final NodeSeq apply(int pos, String s2) {
                return MarkupParser$class.mkResult$1(this.$outer, pos, s2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MarkupHandler $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((MarkupParser)((Object)this.$outer)).pos();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), "]]>");
    }

    public static NodeSeq xComment(MarkupHandler $this) {
        StringBuilder sb = new StringBuilder();
        $this.xToken(Predef$.MODULE$.wrapString("--"));
        while (true) {
            if ($this.ch() == '-') {
                sb.append($this.ch());
                $this.nextch();
                if ($this.ch() == '-') {
                    sb.length_$eq(sb.length() - 1);
                    $this.nextch();
                    $this.xToken('>');
                    return $this.scala$xml$parsing$MarkupParser$$handle().comment($this.pos(), sb.toString());
                }
            }
            sb.append($this.ch());
            $this.nextch();
        }
    }

    public static void appendText(MarkupHandler $this, int pos, NodeBuffer ts, String txt) {
        if ($this.preserveWS()) {
            ts.$amp$plus($this.scala$xml$parsing$MarkupParser$$handle().text(pos, txt));
        } else {
            TextBuffer$.MODULE$.fromString(txt).toText().foreach(new Serializable($this, pos, ts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MarkupHandler $outer;
                private final int pos$1;
                private final NodeBuffer ts$2;

                public final NodeBuffer apply(Text t) {
                    return this.ts$2.$amp$plus(((MarkupParser)((Object)this.$outer)).scala$xml$parsing$MarkupParser$$handle().text(this.pos$1, t.text()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.pos$1 = pos$1;
                    this.ts$2 = ts$2;
                }
            });
        }
    }

    public static void content1(MarkupHandler $this, NamespaceBinding pscope, NodeBuffer ts) {
        char c = $this.ch();
        switch (c) {
            default: {
                ts.$amp$plus($this.element1(pscope));
                break;
            }
            case '?': {
                $this.nextch();
                ts.$amp$plus($this.xProcInstr());
                break;
            }
            case '!': {
                $this.nextch();
                if ('[' == $this.ch()) {
                    ts.$amp$plus($this.xCharData());
                    break;
                }
                if ('D' == $this.ch()) {
                    $this.parseDTD();
                    break;
                }
                ts.$amp$plus($this.xComment());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static NodeSeq content(MarkupHandler $this, NamespaceBinding pscope) {
        ObjectRef<NodeBuffer> ts = new ObjectRef<NodeBuffer>(new NodeBuffer());
        boolean exit = $this.eof();
        while (!exit) {
            void var2_2;
            $this.tmppos_$eq($this.pos());
            boolean bl = $this.eof();
            if ($this.eof()) {
                return MarkupParser$class.done$1($this, (ObjectRef)var2_2);
            }
            char c = $this.ch();
            block0 : switch (c) {
                default: {
                    $this.appendText($this.tmppos(), (NodeBuffer)var2_2.elem, MarkupParser$class.xText($this));
                    java.io.Serializable serializable2 = BoxedUnit.UNIT;
                    break;
                }
                case '&': {
                    java.io.Serializable serializable2;
                    $this.nextch();
                    char c2 = $this.ch();
                    switch (c2) {
                        default: {
                            String n = $this.xName();
                            $this.xToken(';');
                            if (Utility$Escapes$.MODULE$.pairs().contains(n)) {
                                $this.scala$xml$parsing$MarkupParser$$handle().entityRef($this.tmppos(), n);
                                serializable2 = ((NodeBuffer)var2_2.elem).$amp$plus(Utility$Escapes$.MODULE$.pairs().apply(n));
                                break block0;
                            }
                            $this.push(n);
                            serializable2 = BoxedUnit.UNIT;
                            break block0;
                        }
                        case '#': 
                    }
                    $this.nextch();
                    NodeSeq theChar = $this.scala$xml$parsing$MarkupParser$$handle().text($this.tmppos(), $this.xCharRef((Function0<Object>)((Object)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MarkupHandler $outer;

                        public final char apply() {
                            return this.apply$mcC$sp();
                        }

                        public char apply$mcC$sp() {
                            return ((MarkupParser)((Object)this.$outer)).ch();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }), (Function0<BoxedUnit>)((Object)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MarkupHandler $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            ((MarkupParser)((Object)this.$outer)).nextch();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    })));
                    $this.xToken(';');
                    serializable2 = ((NodeBuffer)var2_2.elem).$amp$plus(theChar);
                    break;
                }
                case '<': {
                    $this.nextch();
                    char c3 = $this.ch();
                    switch (c3) {
                        default: {
                            $this.content1(pscope, (NodeBuffer)var2_2.elem);
                            break;
                        }
                        case '/': {
                            bl = true;
                        }
                    }
                    java.io.Serializable serializable2 = BoxedUnit.UNIT;
                }
            }
        }
        return MarkupParser$class.done$1($this, ts);
    }

    public static ExternalID externalID(MarkupHandler $this) {
        ExternalID externalID;
        char c = $this.ch();
        switch (c) {
            default: {
                throw new MatchError(BoxesRunTime.boxToCharacter(c));
            }
            case 'P': {
                $this.nextch();
                $this.xToken(Predef$.MODULE$.wrapString("UBLIC"));
                $this.xSpace();
                String pubID = $this.pubidLiteral();
                $this.xSpace();
                String sysID = $this.systemLiteral();
                externalID = new PublicID(pubID, sysID);
                break;
            }
            case 'S': {
                $this.nextch();
                $this.xToken(Predef$.MODULE$.wrapString("YSTEM"));
                $this.xSpace();
                String sysID = $this.systemLiteral();
                externalID = new SystemID(sysID);
            }
        }
        return externalID;
    }

    public static void parseDTD(MarkupHandler $this) {
        ObjectRef<Object> extID = new ObjectRef<Object>(null);
        if ($this.dtd() != null) {
            $this.reportSyntaxError("unexpected character (DOCTYPE already defined");
        }
        $this.xToken(Predef$.MODULE$.wrapString("DOCTYPE"));
        $this.xSpace();
        String n = $this.xName();
        $this.xSpace();
        if ('S' == $this.ch() || 'P' == $this.ch()) {
            extID.elem = $this.externalID();
            $this.xSpaceOpt();
        }
        if ((ExternalID)extID.elem != null && $this.isValidating()) {
            $this.pushExternal(((ExternalID)extID.elem).systemId());
            $this.extIndex_$eq($this.inpStack().length());
            $this.extSubset();
            $this.pop();
            $this.extIndex_$eq(-1);
        }
        if ('[' == $this.ch()) {
            $this.nextch();
            $this.intSubset();
            $this.xToken(']');
            $this.xSpaceOpt();
        }
        $this.xToken('>');
        $this.dtd_$eq(new DTD($this, extID){
            {
                this.externalID_$eq((ExternalID)extID$1.elem);
                this.decls_$eq((List<Decl>)((MarkupParser)((Object)$outer)).scala$xml$parsing$MarkupParser$$handle().decls().reverse());
            }
        });
        if ($this.doc() != null) {
            $this.doc().dtd_$eq($this.dtd());
        }
        $this.scala$xml$parsing$MarkupParser$$handle().endDTD(n);
    }

    public static NodeSeq element(MarkupHandler $this, NamespaceBinding pscope) {
        $this.xToken('<');
        return $this.element1(pscope);
    }

    public static NodeSeq element1(MarkupHandler $this, NamespaceBinding pscope) {
        int pos = $this.pos();
        Tuple2<String, Object> tuple2 = $this.xTag(pscope);
        if (tuple2 != null) {
            String qname = tuple2._1();
            Tuple2 p2 = (Tuple2)tuple2._2();
            if (p2 != null) {
                Tuple2<Object, String> tuple22;
                Some x2;
                Tuple3<String, MetaData, NamespaceBinding> tuple3;
                MetaData aMap = (MetaData)p2._1();
                NamespaceBinding scope = (NamespaceBinding)p2._2();
                Tuple3<String, MetaData, NamespaceBinding> tuple32 = tuple3 = new Tuple3<String, MetaData, NamespaceBinding>(qname, aMap, scope);
                String qname2 = tuple32._1();
                MetaData aMap2 = tuple32._2();
                NamespaceBinding scope2 = tuple32._3();
                Option<String> option = Utility$.MODULE$.prefix(qname2);
                if (option instanceof Some && (x2 = (Some)option) != null) {
                    String p = (String)x2.x();
                    tuple22 = new Tuple2(p, new StringOps(Predef$.MODULE$.augmentString(qname2)).drop(p.length() + 1));
                } else {
                    tuple22 = new Tuple2<Object, String>(null, qname2);
                }
                Tuple2<Object, String> tuple23 = tuple22;
                if (tuple23 != null) {
                    NodeSeq nodeSeq;
                    Tuple2<String, String> tuple24;
                    String pre = tuple23._1();
                    String local = tuple23._2();
                    Tuple2<String, String> tuple25 = tuple24 = new Tuple2<String, String>(pre, local);
                    String pre2 = tuple25._1();
                    String local2 = tuple25._2();
                    if ($this.ch() == '/') {
                        $this.xToken(Predef$.MODULE$.wrapString("/>"));
                        $this.scala$xml$parsing$MarkupParser$$handle().elemStart(pos, pre2, local2, aMap2, scope2);
                        nodeSeq = NodeSeq$.MODULE$.Empty();
                    } else {
                        $this.xToken('>');
                        $this.scala$xml$parsing$MarkupParser$$handle().elemStart(pos, pre2, local2, aMap2, scope2);
                        NodeSeq tmp = $this.content(scope2);
                        $this.xEndTag(qname2);
                        nodeSeq = tmp;
                    }
                    NodeSeq ts = nodeSeq;
                    NodeSeq nodeSeq2 = ts;
                    NodeSeq nodeSeq3 = NodeSeq$.MODULE$.Empty();
                    NodeSeq res = $this.scala$xml$parsing$MarkupParser$$handle().elem(pos, pre2, local2, aMap2, scope2, !(nodeSeq2 != null ? !((Object)nodeSeq2).equals(nodeSeq3) : nodeSeq3 != null), ts);
                    $this.scala$xml$parsing$MarkupParser$$handle().elemEnd(pos, pre2, local2);
                    return res;
                }
                throw new MatchError(tuple23);
            }
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private static String xText(MarkupHandler $this) {
        boolean exit = false;
        while (true) {
            if (exit) {
                void var3_3;
                String str = $this.cbuf().toString();
                $this.cbuf().length_$eq(0);
                return var3_3;
            }
            $this.putChar($this.ch());
            int opos = $this.pos();
            $this.nextch();
            boolean bl = $this.eof() || $this.ch() == '<' || $this.ch() == '&';
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String systemLiteral(MarkupHandler $this) {
        void var2_2;
        char endch = $this.ch();
        if ($this.ch() != '\'' && $this.ch() != '\"') {
            $this.reportSyntaxError("quote ' or \" expected");
        }
        $this.nextch();
        while ($this.ch() != endch && !$this.eof()) {
            $this.putChar($this.ch());
            $this.nextch();
        }
        $this.nextch();
        String str = $this.cbuf().toString();
        $this.cbuf().length_$eq(0);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String pubidLiteral(MarkupHandler $this) {
        void var2_2;
        char endch = $this.ch();
        if ($this.ch() != '\'' && $this.ch() != '\"') {
            $this.reportSyntaxError("quote ' or \" expected");
        }
        $this.nextch();
        while ($this.ch() != endch && !$this.eof()) {
            $this.putChar($this.ch());
            if (!$this.isPubIDChar($this.ch())) {
                $this.reportSyntaxError(new StringBuilder().append((Object)"char '").append(BoxesRunTime.boxToCharacter($this.ch())).append((Object)"' is not allowed in public id").toString());
            }
            $this.nextch();
        }
        $this.nextch();
        String str = $this.cbuf().toString();
        $this.cbuf().length_$eq(0);
        return var2_2;
    }

    public static void extSubset(MarkupHandler $this) {
        Object object;
        Tuple2<Option<String>, Option<String>> textdecl = null;
        if ($this.ch() == '<') {
            $this.nextch();
            if ($this.ch() == '?') {
                $this.nextch();
                textdecl = $this.textDecl();
                object = BoxedUnit.UNIT;
            } else {
                object = $this.markupDecl1();
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        while (!$this.eof()) {
            $this.markupDecl();
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object markupDecl1(MarkupHandler $this) {
        Object object;
        if ('?' == $this.ch()) {
            $this.nextch();
            object = $this.xProcInstr();
            return object;
        } else {
            $this.xToken('!');
            char c = $this.ch();
            switch (c) {
                case '[': {
                    if ($this.inpStack().length() >= $this.extIndex()) {
                        $this.nextch();
                        $this.xSpaceOpt();
                        char c2 = $this.ch();
                        block7 : switch (c2) {
                            default: {
                                throw new MatchError(BoxesRunTime.boxToCharacter(c2));
                            }
                            case 'I': {
                                $this.nextch();
                                char c3 = $this.ch();
                                switch (c3) {
                                    default: {
                                        throw new MatchError(BoxesRunTime.boxToCharacter(c3));
                                    }
                                    case 'N': {
                                        $this.nextch();
                                        $this.xToken(Predef$.MODULE$.wrapString("NCLUDE"));
                                        MarkupParser$class.doInclude$1($this);
                                        break block7;
                                    }
                                    case 'G': 
                                }
                                $this.nextch();
                                $this.xToken(Predef$.MODULE$.wrapString("NORE"));
                                $this.xSpaceOpt();
                                MarkupParser$class.doIgnore$1($this);
                                break;
                            }
                            case '%': {
                                String string2;
                                $this.nextch();
                                String ent = $this.xName();
                                $this.xToken(';');
                                $this.xSpaceOpt();
                                $this.push(ent);
                                $this.xSpaceOpt();
                                String stmt = $this.xName();
                                $this.xSpaceOpt();
                                String string3 = string2 = stmt;
                                if (!("INCLUDE" != null ? !"INCLUDE".equals(string3) : string3 != null)) {
                                    String x2 = string2;
                                    MarkupParser$class.doInclude$1($this);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break;
                                }
                                String string4 = string2;
                                if ("IGNORE" != null ? !"IGNORE".equals(string4) : string4 != null) throw new MatchError((Object)string2);
                                String x3 = string2;
                                MarkupParser$class.doIgnore$1($this);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        $this.xToken(']');
                        $this.xToken('>');
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                }
                default: {
                    Source qual$1 = $this.curInput();
                    int x$6 = $this.pos();
                    String x$7 = new StringBuilder().append((Object)"unexpected character '").append(BoxesRunTime.boxToCharacter($this.ch())).append((Object)"', expected some markupdecl").toString();
                    PrintStream x$8 = qual$1.reportError$default$3();
                    qual$1.reportError(x$6, x$7, x$8);
                    while ($this.ch() != '>') {
                        $this.nextch();
                    }
                    object = BoxedUnit.UNIT;
                    return object;
                }
                case 'N': {
                    $this.nextch();
                    $this.notationDecl();
                    object = BoxedUnit.UNIT;
                    return object;
                }
                case 'A': {
                    $this.nextch();
                    $this.attrDecl();
                    object = BoxedUnit.UNIT;
                    return object;
                }
                case 'E': {
                    $this.nextch();
                    if ('L' == $this.ch()) {
                        $this.nextch();
                        $this.elementDecl();
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                    $this.entityDecl();
                    object = BoxedUnit.UNIT;
                    return object;
                }
                case '-': {
                    object = $this.xComment();
                }
            }
        }
        return object;
    }

    public static void markupDecl(MarkupHandler $this) {
        char c = $this.ch();
        switch (c) {
            default: {
                if ($this.isSpace($this.ch())) {
                    $this.xSpace();
                    break;
                }
                $this.reportSyntaxError(new StringBuilder().append((Object)"markupdecl: unexpected character '").append(BoxesRunTime.boxToCharacter($this.ch())).append((Object)"' #").append(BoxesRunTime.boxToInteger($this.ch())).toString());
                $this.nextch();
                break;
            }
            case '<': {
                $this.nextch();
                $this.markupDecl1();
                break;
            }
            case '%': {
                $this.nextch();
                String ent = $this.xName();
                $this.xToken(';');
                if ($this.isValidating()) {
                    $this.push(ent);
                    break;
                }
                $this.scala$xml$parsing$MarkupParser$$handle().peReference(ent);
            }
        }
    }

    public static void intSubset(MarkupHandler $this) {
        $this.xSpace();
        while (']' != $this.ch()) {
            $this.markupDecl();
        }
    }

    public static void elementDecl(MarkupHandler $this) {
        $this.xToken(Predef$.MODULE$.wrapString("EMENT"));
        $this.xSpace();
        String n = $this.xName();
        $this.xSpace();
        while ('>' != $this.ch()) {
            $this.putChar($this.ch());
            $this.nextch();
        }
        $this.nextch();
        String cmstr = $this.cbuf().toString();
        $this.cbuf().length_$eq(0);
        $this.scala$xml$parsing$MarkupParser$$handle().elemDecl(n, cmstr);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void attrDecl(MarkupHandler $this) {
        void var2_3;
        $this.xToken(Predef$.MODULE$.wrapString("TTLIST"));
        $this.xSpace();
        String n = $this.xName();
        $this.xSpace();
        Nil$ nil$ = Nil$.MODULE$;
        while ('>' != $this.ch()) {
            DEFAULT dEFAULT;
            String aname = $this.xName();
            $this.xSpace();
            while ('\"' != $this.ch() && '\'' != $this.ch() && '#' != $this.ch() && '<' != $this.ch()) {
                java.io.Serializable serializable2 = $this.isSpace($this.ch()) ? BoxedUnit.UNIT : $this.cbuf().append($this.ch());
                $this.nextch();
            }
            String atpe = $this.cbuf().toString();
            $this.cbuf().length_$eq(0);
            char c = $this.ch();
            switch (c) {
                default: {
                    dEFAULT = null;
                    break;
                }
                case '#': {
                    void var10_12;
                    String string2;
                    $this.nextch();
                    String string3 = string2 = $this.xName();
                    if (!("FIXED" != null ? !"FIXED".equals(string3) : string3 != null)) {
                        String x2 = string2;
                        $this.xSpace();
                        DEFAULT dEFAULT2 = new DEFAULT(true, $this.xAttributeValue());
                    } else {
                        String string4 = string2;
                        if (!("IMPLIED" != null ? !"IMPLIED".equals(string4) : string4 != null)) {
                            String x3 = string2;
                            IMPLIED$ iMPLIED$ = IMPLIED$.MODULE$;
                        } else {
                            String string5 = string2;
                            if ("REQUIRED" != null ? !"REQUIRED".equals(string5) : string5 != null) throw new MatchError((Object)string2);
                            String x4 = string2;
                            REQUIRED$ rEQUIRED$ = REQUIRED$.MODULE$;
                        }
                    }
                    dEFAULT = var10_12;
                    break;
                }
                case '\"': 
                case '\'': {
                    dEFAULT = new DEFAULT(false, $this.xAttributeValue());
                }
            }
            DEFAULT defdecl = dEFAULT;
            $this.xSpaceOpt();
            List<AttrDecl> list2 = var2_3.$colon$colon(new AttrDecl(aname, atpe, defdecl));
            $this.cbuf().length_$eq(0);
        }
        $this.nextch();
        $this.scala$xml$parsing$MarkupParser$$handle().attListDecl(n, (List<AttrDecl>)var2_3.reverse());
    }

    public static void entityDecl(MarkupHandler $this) {
        boolean isParameterEntity = false;
        Object entdef = null;
        $this.xToken(Predef$.MODULE$.wrapString("NTITY"));
        $this.xSpace();
        if ('%' == $this.ch()) {
            $this.nextch();
            isParameterEntity = true;
            $this.xSpace();
        }
        String n = $this.xName();
        $this.xSpace();
        char c = $this.ch();
        switch (c) {
            default: {
                throw new MatchError(BoxesRunTime.boxToCharacter(c));
            }
            case '\"': 
            case '\'': {
                String av = $this.xEntityValue();
                $this.xSpaceOpt();
                $this.xToken('>');
                if (isParameterEntity) {
                    $this.scala$xml$parsing$MarkupParser$$handle().parameterEntityDecl(n, new IntDef(av));
                    break;
                }
                $this.scala$xml$parsing$MarkupParser$$handle().parsedEntityDecl(n, new IntDef(av));
                break;
            }
            case 'P': 
            case 'S': {
                ExternalID extID = $this.externalID();
                if (isParameterEntity) {
                    $this.xSpaceOpt();
                    $this.xToken('>');
                    $this.scala$xml$parsing$MarkupParser$$handle().parameterEntityDecl(n, new ExtDef(extID));
                    break;
                }
                $this.xSpace();
                if ('>' != $this.ch()) {
                    $this.xToken(Predef$.MODULE$.wrapString("NDATA"));
                    $this.xSpace();
                    String notat = $this.xName();
                    $this.xSpaceOpt();
                    $this.xToken('>');
                    $this.scala$xml$parsing$MarkupParser$$handle().unparsedEntityDecl(n, extID, notat);
                    break;
                }
                $this.nextch();
                $this.scala$xml$parsing$MarkupParser$$handle().parsedEntityDecl(n, new ExtDef(extID));
            }
        }
    }

    public static void notationDecl(MarkupHandler $this) {
        block5: {
            ExternalID externalID;
            String notat;
            block4: {
                block3: {
                    $this.xToken(Predef$.MODULE$.wrapString("OTATION"));
                    $this.xSpace();
                    notat = $this.xName();
                    $this.xSpace();
                    if ($this.ch() != 'S') break block3;
                    externalID = $this.externalID();
                    break block4;
                }
                if ($this.ch() != 'P') break block5;
                $this.nextch();
                $this.xToken(Predef$.MODULE$.wrapString("UBLIC"));
                $this.xSpace();
                String pubID = $this.pubidLiteral();
                $this.xSpaceOpt();
                String sysID = $this.ch() != '>' ? $this.systemLiteral() : null;
                externalID = new PublicID(pubID, sysID);
            }
            ExternalID extID = externalID;
            $this.xSpaceOpt();
            $this.xToken('>');
            $this.scala$xml$parsing$MarkupParser$$handle().notationDecl(notat, extID);
            return;
        }
        $this.reportSyntaxError("PUBLIC or SYSTEM expected");
        throw package$.MODULE$.error("died parsing notationdecl");
    }

    public static void reportSyntaxError(MarkupHandler $this, int pos, String str) {
        Source qual$2 = $this.curInput();
        int x$9 = pos;
        String x$10 = str;
        PrintStream x$11 = qual$2.reportError$default$3();
        qual$2.reportError(x$9, x$10, x$11);
    }

    public static void reportSyntaxError(MarkupHandler $this, String str) {
        $this.reportSyntaxError($this.pos(), str);
    }

    public static void reportValidationError(MarkupHandler $this, int pos, String str) {
        $this.reportSyntaxError(pos, str);
    }

    public static void push(MarkupHandler $this, String entityName) {
        if (!$this.eof()) {
            Source source = $this.curInput();
            $this.inpStack_$eq($this.inpStack().$colon$colon(source));
        }
        $this.ch();
        $this.curInput_$eq($this.replacementText(entityName));
        $this.nextch();
    }

    public static void pushExternal(MarkupHandler $this, String systemId) {
        if (!$this.eof()) {
            Source source = $this.curInput();
            $this.inpStack_$eq($this.inpStack().$colon$colon(source));
        }
        $this.ch();
        $this.curInput_$eq($this.externalSource(systemId));
        $this.nextch();
    }

    public static void pop(MarkupHandler $this) {
        $this.curInput_$eq((Source)$this.inpStack().head());
        $this.inpStack_$eq((List)$this.inpStack().tail());
        $this.lastChRead_$eq($this.curInput().ch());
        $this.nextChNeeded_$eq(false);
        $this.pos_$eq($this.curInput().pos());
        $this.reachedEof_$eq(false);
    }

    public static final NodeSeq mkResult$1(MarkupHandler $this, int pos, String s2) {
        $this.scala$xml$parsing$MarkupParser$$handle().text(pos, s2);
        return PCData$.MODULE$.apply(s2);
    }

    private static final NodeSeq done$1(MarkupHandler $this, ObjectRef ts$1) {
        return new NodeSeq($this, ts$1){
            private final List<Node> theSeq;

            public List<Node> theSeq() {
                return this.theSeq;
            }
            {
                this.theSeq = ((NodeBuffer)ts$1.elem).toList();
            }
        };
    }

    private static final void doInclude$1(MarkupHandler $this) {
        $this.xToken('[');
        while (']' != $this.ch()) {
            $this.markupDecl();
        }
        $this.nextch();
    }

    private static final void doIgnore$1(MarkupHandler $this) {
        $this.xToken('[');
        while (']' != $this.ch()) {
            $this.nextch();
        }
        $this.nextch();
    }

    public static void $init$(MarkupHandler $this) {
        ((MarkupParser)((Object)$this)).curInput_$eq($this.input());
        ((MarkupParser)((Object)$this)).scala$xml$parsing$MarkupParser$_setter_$scala$xml$parsing$MarkupParser$$handle_$eq($this);
        ((MarkupParser)((Object)$this)).inpStack_$eq(Nil$.MODULE$);
        ((MarkupParser)((Object)$this)).extIndex_$eq(-1);
        ((MarkupParser)((Object)$this)).nextChNeeded_$eq(false);
        ((MarkupParser)((Object)$this)).reachedEof_$eq(false);
        ((MarkupParser)((Object)$this)).scala$xml$parsing$MarkupParser$_setter_$cbuf_$eq(new StringBuilder());
        ((MarkupParser)((Object)$this)).dtd_$eq(null);
        ((MarkupParser)((Object)$this)).doc_$eq(null);
    }
}

