/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class Module
extends CustomAttributeProvider {
    public final String Name;
    public final String FullyQualifiedName;
    public String ScopeName;
    public final Assembly Assembly;
    protected final Map typesMap = new HashMap();
    protected Type[] types;
    protected FieldInfo[] fields = FieldInfo.EMPTY_ARRAY;
    protected MethodInfo[] methods = MethodInfo.EMPTY_ARRAY;
    private boolean initTypes = true;
    private boolean initGlobals = true;

    protected Module(String name, String filename, String scopeName, Assembly assembly) {
        this.Name = name;
        this.FullyQualifiedName = filename;
        this.ScopeName = scopeName;
        this.Assembly = assembly;
    }

    public Type GetType(String name) {
        this.initTypes();
        return (Type)this.typesMap.get(name);
    }

    public Type[] GetTypes() {
        this.initTypes();
        return (Type[])this.types.clone();
    }

    public FieldInfo GetField(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].Name.equals(name)) continue;
            return this.fields[i];
        }
        return null;
    }

    public FieldInfo[] GetFields() {
        return (FieldInfo[])this.fields.clone();
    }

    public MethodInfo GetMethod(String name) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].Name.equals(name)) continue;
            return this.methods[i];
        }
        return null;
    }

    public MethodInfo[] GetMethods() {
        return (MethodInfo[])this.methods.clone();
    }

    public String toString() {
        return this.Name;
    }

    protected Type addType(Type type) {
        this.addType(type.FullName, type);
        this.Assembly.addType(type);
        return type;
    }

    protected Type addType(String name, Type type) {
        assert (type != null);
        this.typesMap.put(name, type);
        return type;
    }

    protected final void initTypes() {
        if (this.initTypes) {
            this.loadTypes();
            this.initTypes = false;
        }
    }

    protected void loadTypes() {
    }

    protected final void initGlobals() {
        if (this.initGlobals) {
            this.loadGlobals();
            this.initGlobals = false;
        }
    }

    protected void loadGlobals() {
    }
}

