// this class's bytecode, compiled under -optimize is analyzed by the test
// method a's bytecode should be identical to method b's bytecode
class SameBytecode {
  case class Foo(x: Int, y: String)

  def a = 
    Foo(1, "a") match {
      case Foo(_: Int, y) => y
    }

  // this method's body holds the tree that should be generated by the pattern matcher for method a (-Xprint:patmat)
  // the test checks that bytecode for a and b is identical (modulo line numbers)
  // we can't diff trees as they are quite different (patmat uses jumps to labels that cannot be expressed in source, for example)
  // note that the actual tree is quite bad: we do an unnecessary null check, and local val (x3)
  // some of these will be fixed soon (the initial null check is for the scrutinee, which is harder to fix in patmat)
  def b: String = {
    val x1 = Foo(1, "a")
    if (x1.ne(null)) {
      return x1.y
    }

    throw new MatchError(x1)
  }
}