'use strict';
/*
 * The goal of this test is to cover the Workers' implementation of
 * Worker.prototype.destroy. Worker.prototype.destroy is called within
 * the worker's context: once when the worker is still connected to the
 * master, and another time when it's not connected to it, so that we cover
 * both code paths.
 */

const common = require('../common');
const assert = require('assert');
const cluster = require('cluster');
let worker1, worker2;

if (cluster.isMaster) {
  worker1 = cluster.fork();
  worker2 = cluster.fork();

  [worker1, worker2].forEach(function(worker) {
    worker.on('disconnect', common.mustCall());
    worker.on('exit', common.mustCall());
  });
} else {
  if (cluster.worker.id === 1) {
    // Call destroy when worker is disconnected
    cluster.worker.process.on('disconnect', function() {
      cluster.worker.destroy();
    });

    const w = cluster.worker.disconnect();
    assert.strictEqual(w, cluster.worker, 'did not return a reference');
  } else {
    // Call destroy when worker is not disconnected yet
    cluster.worker.destroy();
  }
}
