# Node Foundation CTC Meeting 2016-01-27

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2016-01-27
* **GitHub Issue**: https://github.com/nodejs/node/issues/4901
* **Minutes Google Doc**: <https://docs.google.com/document/d/145ND-9pGdAwZ1eoOMypX1_wtx5FCVoanWtLl8zzyxH8>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1X3RbJhhLvFNojmQwxmsfUb2qPMyNPcVzcSS2aAoAon0>_

## Present

* James Snell (CTC)
* Trevor Norris (CTC)
* Colin Ihrig (CTC)
* Brian White (CTC)
* Alexis Campailla (CTC)
* Bert Belder (CTC) (absent)
* Chris Dickinson (CTC)
* Shigeki Ohtsu (CTC) (absent)
* Steven Loomis (observer) (absent)
* Mikeal Rogers (observer)
* Fedor Indutny (CTC)
* Jeremiah Senkpiel (CTC)
* Rod Vagg (CTC)
* Ben Noordhuis (CTC)
* Domenic Denicola (observer) (absent)
* Nikita Skovoroda (observer)
* Ali Sheikh (observer) (absent)
* Evan Lucas (observer)
* Rich Trott (observer)
* Michael Dawson (observer)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

* Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)
* CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)
* buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682)
* Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)
* doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Drop Windows XP (and Vista) support in 6.0 [#3804](https://github.com/nodejs/node/issues/3804)

## Standup

* James Snell (CTC) — Buffer API change proposal, PR review, error handling summit yesterday, community related issues
* Trevor Norris (CTC) — Writing a patch for Buffer#fill, so it can accept an encoding and a buffer; making MakeCallback reentrant; have a fix but not sure how it’ll affect 3p debugger modules; want to be thorough because this should extend back to v4
* Colin Ihrig (CTC) — Reviewing issues/PRs, fixing bugs; PR landed in libuv for looking up tmpdir, PR into child process
* Brian White (CTC) — Reviewing/commenting on PRs and issues, working on JS optimizations inside core modules.
* Alexis Campailla (CTC) — Issues/PRs, some work in the testing repo, some work in CI, visual C++ build tools for making modules, investigated a couple issues in libuv
* Chris Dickinson (CTC) — docs WG organization
* Mikeal Rogers (observer) — New education initiatives coming up from Foundation board, legal, working on size & scope of TSC stuff and the incubator
* Jeremiah Senkpiel (CTC) — Administrative and TSC stuff; moderating large issues [CD — thank you!]
* Rod Vagg (CTC) — (Possibly catching up on sleep)
* Ben Noordhuis (CTC) — Reviewing libuv+node PRs, reply to issues, 2 months ahead are busy
* Nikita Skovoroda (observer) — some comments/reviews, nothing interesting. Npm code search update. [JS - Thanks for doing the npm search things!]
* Evan Lucas (observer) — Minor dns/net cleanups, Responding to issues/PRs
* Rich Trott (observer) — Tests, spinning up Testing WG, removing redeclaration of vars from code, especially tests, thus reducing side effects and making it easier to split up tests.
* Michael Dawson (observer) — Benchmarks, results of benchmarks on the website, PPC for big endian machines, V8 testing separate from the node install
* Fedor Indutny (CTC) - Reviewing Pull Requests, fixing issues, V8 code cache API
* Seth Thompson (observer) - Google folks replied to James’ scheduling for face to face meeting for talking about swapping out VMs

## Review of last meeting


* Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)
* CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)
* buffer: add Buffer.from(), Buffer.zalloc() and Buffer.alloc(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682)
* Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)
* util: deprecate `util._extend` [#4593](https://github.com/nodejs/node/pull/4593)
* ArrayBuffer.isView() and buffer.buffer property [#4420](https://github.com/nodejs/node/issues/4420)
* doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* fs: optimize realpath using uv_fs_realpath() [#3594](https://github.com/nodejs/node/pull/3594)


## Minutes

### Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)

Alexis: No action items on the PR itself, which was locked to collabs, since it was turning into noise. Another issue was opened (roadmap#54) by Mikeal re: whether we should be VM agnostic in the future, there’s discussion of pros and cons as well as talk of how this might happen in the future. Chakra folks are on board for the API wg group / VM agnostic API.

Fedor: Do we have consensus yet?

Alexis: Not yet.

Mikeal: The vast majority agree that we should be moving toward it,

Ben: Is it actually true? I’ve seen it go both ways.

Mikeal: I haven’t seen objections to being VM neutral, but how we go about it — there’s no agreement at all.

James: There’s concerns around language support between the two and how that affects us — there’s a lot of issues like that, related to the “how” we go about this, but there seems to be a consensus that this is the way we want to go.

Mikeal: I’d like to do this before April?

Ben: Are there collaborators that haven’t spoken up yet, on the principle that they don’t feel too strongly about it?

Jeremiah: I’m more in line with Oglas (the guy maintaining JXCore), he’s got a lot of experience with this, and his idea was to move to its own VM. I’m not sure we could

Trevor: You mean maintaining our own VM?

Mikeal: I had a conversation with Mark Mayo and he thought that would be the direction we’d actually land.

Alexis: That would require an enormous amount of resources.

Mikeal: This PR, you say we locked it to collabs, but aren’t the folks posting it not collabs?

Jeremiah: In the meantime we can add them to a team for this purpose.

Alexis: I think it looks like the original PR submitter can still comment.

Alexis: I can facilitate since I’m in contact with them daily.

Mikeal: We should create teams for V8 and a team for Chakra, for our convenience.

Alexis: We do have a v8 team, but I think it’s the Node experts on V8.

Seth: I can make sure the right people from the team are on there.

Alexis: And I can create one for the Chakra team.

Michael: there are a few folks I’d like to add from my team, how would I do it.

Mikeal: James can do it.

Another question: assuming we do move this direction, should we start an issue around no longer pulling deps into the source tree?

Michael: Being vm-neutral doesn’t mean we bring in every VM into the source tree?

Mikeal: But we’re set up to do that right now.

Alexis: This also affects ICU.

Jeremiah: I don’t think this is an immediate concern.

Fedor: Release cycle — Chakra and V8’s release cycle are not aligned, how will that affect us?

Alexis: Chakra team has folks dedicated to working with Node’s release cycle, so we would align.

Mikeal: If we tackle this ABI compatibility problem, we may end up revisiting the release cycle since that’s driven by these big VM breaks.

### CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)

Jeremiah: We’re going to keep this open for a couple weeks while the nominees sit in. The vote is TBD. We don’t do this often so the process is rusty.

### buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682)

James: Where we’re at right now: continuing to update the PR and the EPS proposal that goes along with this based on the conversation. The new APIs seem uncontroversial. Unsurprisingly the name of one method is the most controversial. Currently, it’s allocUnsafe, a few folks don’t like “Unsafe”, would prefer “Raw”. [CD - yay bikesheds!]

Some of the feedback from Trevor was that the API should be tweaked a bit, where we can pass encoding or a buffer to `.fill`, other than that the conversation around it is dying down. We haven’t decided if we’re going to change the default `new Buffer(n)` to zero-fill — if we do make that change we have to make it all the way down to v0.10 to keep it consistent.

Mikeal: Call it buffer.remoteDisclosure().

Just kidding.

Ben: if we could make zero-fill as fast as the current impl, then we would of course pick that.

James: Yes.

Ben: I’ve been playing with doing init in a separate thread. Perhaps I can close the gap.

Mikeal: The only objection is perf.

James: Yep. The baseline impl is that zero fill uses calloc.

Trevor: We use a pool. It’s always been possible to reach the pool from any buffer instance. Do we want to remove pooling?

James: Current impl is that zerofill does not pool.

Trevor: So much overhead!

_(in document chat)_

_Chris: why not use WeakMap for pooling?_

_Ben: no weakmaps in v0.10._

Jeremiah: Do we have benchmarks for calloc?

James: Once we get a little further, I’ll revisit benchmarks.

Trevor: Can the kernel do magic where memory isn’t actually allocated when it’s done in a tight loop? [CD - I didn’t capture this completely]

Ben: You can mmap memory, memory isn’t actually allocated + zerofilled until you touch it, but touching it causes a page fault.

### Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)

Jeremiah: Looks like we covered this.

### doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)

Chris: Onboarded some folks. Completed drafting the docs roadmap proposal. Making sure we have adequate tooling to build docs to the website from the node.js core repo.

Chris: There is a docs wg meeting next week [10AM PST] [Wednesday @ 10am Feb 3rd]

Chris: Also working with the inclusivity WG to make a new collaborator guide.

Ben: No loosening of commit formatting, right?

Chris, Mikeal: nope

Jeremiah: Has anyone read through the proposed charter?

Mikeal: hasn’t changed recently

Ben, James: read though it recently, lgtm

Jeremiah: Vote?

Mikeal: No need, no-one objects.

Jeremiah: Ok, good to go.

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

Mikeal: We’re nearing final documents, and we have some additions to contributing guide that come from legal. The SPDX stuff we talked about. The Foundations IP policy, we mention that we’re going to use CC-4.0 for docs. We should put this to the Docs WG about this. We should have a proper policy from the legal committee really soon.

Chris: I will bring the CC-4.0 license to the Docs WG.

### Drop Windows XP (and Vista) support in 6.0 [#3804](https://github.com/nodejs/node/issues/3804)

Jeremiah: Realpath brought this back up.

Ben: That was Rod but I can take over. The proposal was to drop vista support in the next major release, that would let us drop a lot of legacy of code. TBH, I thought we had already decided on this, so I’m surprised about this. If you’re not in favor, now would be the time to speak up.

Trevor: Didn’t libuv drop XP?

Ben: Nope.

Trevor: Everything but some subset of the API works on XP?

Alexis: I also thought this decision was already made.

Jeremiah: It might have been in some other issue. I seem to recall.

Alexis: Does anyone object to dropping XP?

_[crickets]_

Fedor: I do! `</sarcasm>`

No objections.

Alexis: Does anyone object to drop Vista support.

Mikeal: Let’s get data from NPM.

Ben: Info was posted on the issue, looks like there’s more XP users than Vista, but still very small percentage.

Mikeal: Last I checked there were banks that required it, so it’s still out there.

Trevor: They have LTS, right?

Colin: If we were going to drop support, that we need to start messaging as soon as possible.

Alexis: And that we’d put a check so that Node would exit on those platforms.

Mikeal: It sounds like we’re going to cut some number of users. As long as we’re okay with that…

Alexis: I think we’re going to support the other users better.

Trevor: We have v4, and that will be around for [another year? CD] Maybe even V8 won’t support XP by the time v4 expires.

Jeremiah: I think V8 already stopped supporting it.

Alexis: I think Nikita articulated that.

Jeremiah: Seth, if you’re still there, do you have any idea when V8 will drop XP support.

Seth: We’ve planned that Chrome will probably drop XP support at the same time as … I have to double check. I’ll come back when I find out.

Mikeal: We’ll drop it, and if anyone complains we’ll just say Microsoft told us to do it :)

Alexis: I can make the change to stop on startup; in terms of messaging what needs to happen?

Colin: We just need to get the word out. A tweet or a blogpost or something?

Jeremiah: We should loop in marketing.

Seth: It’s April 2016 for sure on the Chrome side.

Jeremiah: So we have 3 months.

Mikeal: It’d be a major?

Jeremiah: Yep. v6.

Alexis to PR this in.

## Next Meeting

2016-02-03
