# Node Foundation CTC Meeting 2015-12-16

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2015-12-16
* **GitHub Issue**: https://github.com/nodejs/node/issues/4309
* **Minutes Google Doc**: <https://docs.google.com/document/d/1084kuafyFax-1dymqvMlVUPvu3apdzw0ZM_4FX3z1RM>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1fCXy_N0kGISl7JEPf6g1n15eJ_ZcebUPzNA0Mkd79Lc>_

## Present

* James Snell (CTC)
* Trevor Norris (CTC)
* Colin Ihrig (CTC)
* Brian White (CTC)
* Michael Dawson (observer)
* Alexis Campailla (CTC)
* Bert Belder (CTC)
* Chris Dickinson (CTC)
* Ali Ijaz Sheikh (observer)
* Shigeki Ohtsu (CTC)
* Seth Thompson (observer)
* Steven Loomis (observer)
* Mikeal Rogers (observer)
* Jeremiah Senkpiel (CTC)
* Rod Vagg (CTC)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Discussion: OpenSSL 1.1.0 planning [#4270](https://github.com/nodejs/node/issues/4270)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)
* Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)

### nodejs/LTS

* Discuss possibility of adjusting LTS schedule for better alignment with V8 schedule [#62](https://github.com/nodejs/LTS/issues/62)
* AsyncWrap for LTS Argon [#59](https://github.com/nodejs/LTS/issues/59)


### Standup

* James Snell (CTC) — Node interactive, looking at PRs, i18n
* Trevor Norris (CTC) — Been sick, some review
* Colin Ihrig (CTC) — Node interactive, reviewing issues and PRs, yesterday started 5.3.0 release (held up to issue with debugging), am process of releasing 5.3.0 right now
* Brian White (CTC) — Submitted PRs, commenting on issues and PRs
* Michael Dawson (observer) - Node interactive - catching up
* Alexis Campailla (CTC) — Node interactive – MS is open sourcing Chakra, and submitting a PR to Node, mid-January
* Bert Belder (CTC) — Missed NI, was on vacation, commented on some issues
* Chris Dickinson (CTC) — Node Interactive, commenting on issues and PRs
* Shigeki Ohtsu (CTC) - Looking at new version of openssl-1.1.0
* Steven Loomis (observer) — Node interactive, INTL meeting, went over existing issues (esp. re: TC39 standards-level happenings)
* Mikeal Rogers (observer) — Node interactive, board meeting last week, the board accepted the request for legal advice, kicked off to legal committee which will come back with a recommendation or will be handed off to outside counsel
* Jeremiah Senkpiel (CTC)- Node.js Interactive, general issues/PRs, made #io.js on freenode irc forward to #node-dev

## Review of last meeting

* tools: change tick processor install path [#4021](https://github.com/nodejs/node/pull/4021)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)
* Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)
* doc: update irc channels to point to #node.js and #node-dev [#2743](https://github.com/nodejs/node/pull/2743)

## Minutes

### Discussion: OpenSSL 1.1.0 planning [#4270](https://github.com/nodejs/node/issues/4270)

Do we want to delay v6 release for OpenSSL 1.1.0?

James: If we stick with the current LTS cycle, the current version of OpenSSL would be supported for well past the v6 LTS.

Alexis: Would an OpenSSL upgrade be forbidden once v6 goes LTS?

James:

Shigeki: API changes are large, it may be costly to upgrade before LTS. Current 1.0.2 is supported until 2019. It might be best to wait until October

James: So, better to launch this with v7 than v6?
Jeremiah: What does it give us?

Rod: There’s a discussion in the thread.

Alexis: OpenSSL 1.0.2 would be supported for lifetime of v6?

James: If the changes are large, it’s probably best not to rush it in.

Brian: I think I agree.

Alexis: Yes, based on the case presented here.

James: Does anyone think we absolutely should get v1.1.0 into v6?

`<crickets>`

James: Hearing nothing, I’m going to assume that

Jeremiah: Do we know Fedor’s opinion on this?

Rod: He was interested in chacha but that’s about it.
There isn’t really anything hugely compelling here.

James: I think we’ve got general consensus for not delaying for this. We may have other reasons (V8) but not for OpenSSL v1.1.0.

Bert: I know only the version number, delaying would require someone to make a case for it. [CD — I missed some of this due to an errant notification]

Jeremiah: I agree with Bert

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

Rod — left this on the agenda to provide an update. It went to the board last week. There was a bit of discussion, it went to the legal committee. They will shape the document I provided into a request for proper legal advice from a paid lawyer, somewhere — something bounded, “please give advice on these points”. the legal committee is meeting tomorrow.

Bert: OK, cool. Why is this part of the private section of the board meeting?

Mikeal: I can answer that. You really can’t talk about legal issues in the public section. It’s a strange constraint to be under. I’m pushing to change how we do these meetings.

Bert: But it’s okay for the CTC to talk about?

Mikeal: CTC is not fiduciarily bound like the board.

### Potential Licensing issues with npm [#3959](https://github.com/nodejs/node/issues/3959)

Rod: No updates. We have got clarification that npm is moving to the LICENSE on master branch, which is the Artistic License.

### Joyent Copyright still in header of many files [#3926](https://github.com/nodejs/node/issues/3926)

Rod: Same bundle as above.

### AsyncWrap for LTS Argon [#59](https://github.com/nodejs/LTS/issues/59)

Rod: We have AsyncWrap in v4 and v5, but undocumented, so breaking changes are okay. The question is whether or not to bring v4’s asyncwrap up to parity with v5. We landed on not documenting it in v4, but making it public in v5.

James: I have no objections.

Michael: Are there any performance effects?

Trevor: No.

Bert: I find it really strange in the state that node is in, to designate an undocumented API as LTS stable. Three people in the world, maybe, know how this API works. I’d like to have this documented before we freeze it.

Trevor: Touching asyncwrap means touching everything. IMO it’s more about possible mitigation of issues, because you’re right, it’s totally undocumented, hidden behind process.bindings, by keeping parity, it offers advantages for backporting. It’s in a place where a lot of things will touch it, so not backporting it will make other backports difficult if not impossible.

Bert: What you want is folks not touching it in an LTS release, because it’s risky, not to freeze it.

Trevor: Once it is documented, I believe people will want to use it in v4, so at least we’ll have parity between v5 and v4.

Rod: It’s in v4 now, it’s just not in the same state as in v5; the risk is that we publicize it, folks try to use it on v4, and it breaks unexpectedly.

Trevor: There are a few places where improper use will trigger an abort. I don’t like the idea that exposing something to JS that can cause abrupt core dumps.

James: I’d prefer not to document it in v4,

Chris: I don’t think not documenting it in v4 will keep folks from using it once the docs hit v5.

[minutes not captured beyond this point]

### Discuss possibility of adjusting LTS schedule for better alignment with V8 schedule [#62](https://github.com/nodejs/LTS/issues/62)

## Next Meeting

December 23rd, 2015
