# Node Foundation CTC Meeting 2016-07-06

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: https://github.com/nodejs/node/issues/7558
* **Minutes Google Doc**: <https://docs.google.com/document/d/1NWIKwYxDTApvc9Xbq5JTMorRPKIBuBKAA0zcjm8K_II>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1a19l2ICQHCw2w6cM4AayRM8QX8cIrgnHXCtzmuxfWuM>_

## Present

* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* James Snell @jasnell (CTC)
* John-David Dalton @jdalton (observer/Microsoft)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Alexis Campailla @orangemocha (CTC)
* Shigeki Ohtsu @shigeki (CTC)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Standup

* Сковорода Никита Андреевич @ChALkeR (CTC)
    * Nothing significant.
* Colin Ihrig @cjihrig (CTC)
    * Reviewed issues. Reviewed pull requests. Opened a couple PRs
* Evan Lucas @evanlucas (CTC)
    * Commented on a few issues, not much else
* Jeremiah Senkpiel @Fishrock123 (CTC)
    * v6.3.0 Release, most difficult to date, lots of merge conflicts.
    * Various PR / Issue review
* John-David Dalton @jdalton (observer/Microsoft)
    * Another round of questions with Chakra dev about Unambiguous JS Grammar confirming difficulty level of API is not significant
    * Updated Unambiguous JS Grammar based on feedback
* Josh Gavant @joshgav (observer/Microsoft)
    * Out for July 4th holiday.
* Michael Dawson @mhdawson (CTC)
    * Added linuxOne to regression tests/watched for issues, all looks good, next step is to add to nightly releases
    * Chasing down AIX build breaks test failures
    * Continued work on ABI stable module API and scheduling of next WG meeting
    * misc PR/Issue reviews/pull requests
    * post-mortem work and scheduling of next meeting
    * small update to benchmark graphs
    * keeping up to date with issues
* Brian White @mscdex (CTC)
    * Started the process of rebasing the old js http parser onto master to see how it compares to the current http implementation
    * Reviewed PRs, commented on issues
* Alexis Campailla @orangemocha (CTC)
    * Nothing to report (was out on vacation)
* Shigeki Ohtsu @shigeki (CTC)
    * Reviewed only one PR for crypto doc
* Trevor Norris @trevnorris (CTC)
    * Updated AsyncWrap EP
    * fs.realpath() deep symlink PR
* Rich Trott @Trott (CTC)
    * Onboarded @bzoz
    * Fixing test-net-write-slow on FreeBSD (PR #7555)
* James M Snell @jasnell (CTC)
    * WHATWG http implementation
    * Closing up other business before going on vacation for a week

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/issues/7484)
* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)

### nodejs/node-eps

* Replace section 5.1 with unambiguous JavaScript grammar. [#33](https://github.com/nodejs/node-eps/pull/33)
* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

## Previous Meeting

* New Buffer API backport to v4.x [#7475](https://github.com/nodejs/node/pull/7475)

    * New PR: https://github.com/nodejs/node/pull/7562

* child_process: validate fork/execFile arguments [#7399](https://github.com/nodejs/node/pull/7399)
* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)
* repl: Default `useGlobal` to false in CLI REPL. [#5703](https://github.com/nodejs/node/pull/5703)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
* Mention odd-number release has eight months support as Current. [#113](https://github.com/nodejs/LTS/issues/113)
* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

## Minutes

### build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/issues/7484) (@jasnell)

Consider v6 and v7 separately. All agree on moving to VS 2015 for v7. Only question is v6 prior to LTS. We need more info to make decision on v6.

If we stay with 2013 for v6 we’ll have to support it for the entire lifetime of v6 LTS. But it needs to still be possible to build native addons with 2013.

@jasnell - Our recommendation is to build native addons with VS 2015 unless it doesn’t work (e.g. in [node-sass#1283](https://github.com/sass/node-sass/issues/1283).

@orangemocha - No problem building `node.exe` with VS 2015 in v7. But dropping support for 2013 would break some modules (breaking change) due to ABI incompatibilities, so it might not be appropriate for v6. Need more time to assess impact.

### Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)

@trevnorris - fix is working, test in development. Comment further in the PR.

### Replace section 5.1 with unambiguous JavaScript grammar. [#33](https://github.com/nodejs/node-eps/pull/33)

@jdalton added line stating explicitly that the .mjs proposal is still possible.

Vote taken in favor of merging this PR. Alexis officially abstained.

### AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

See also [#7565](https://github.com/nodejs/node/issues/7565), which questions whether AsyncWrap should exist (from @bnoordhuis).

@jasnell - Error handling should be addressed.

@trott - A vote for the EP means “*if* we implement, this is what the JavaScript API will look like” and not necessarily “we intend to implement this.”

@trevnorris - Correct. Confirm the API, then more work is needed on implementation, e.g. to include info on promises.

@trevnorris - biggest missing chunk is public C++ API. Trouble is that it requires exposing some things which are not currently in public headers.

@trevnorris - Goal is to include this as experimental in v6 before LTS. But still waiting on additional hooks into promises from V8.

@Fishrock123 - AsyncWrap is best bet for CLS across async activities, replaces deprecated domains.

Vote: 7-8 ayes, 0 opposed, 0 abstentions.


## Q/A on public fora

None.

## Next Meeting

* Move to VS 2015 for release build in v6? Is this a breaking change?

## Upcoming TLP & WG Meetings

* CTC: 2016-07-13
* TSC: 2016-07-14
* Diagnostics: 2016-07-13
* Post-Mortem: [nodejs/post-mortem#31](https://github.com/nodejs/post-mortem/issues/31)
* LTS:
* Build:
