# Node Foundation CTC Meeting 2016-08-10

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8030](https://github.com/nodejs/node/issues/8030)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1L65L7qhX5MrGeFwrub4-Z8klrwxJym-Q8CIEZsedohE>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1ufR5dNuN3JLmFPvCvLYGRa98_-eqy5yY3zJuTnT60K8>_



## Present

* Anna Henningsen @addaleax (CTC)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Ben Noordhuis @bnoordhuis (CTC)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* James M Snell @jasnell (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Myles Borins @TheAlphaNerd (observer/IBM)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Standup

* Anna Henningsen @addaleax (CTC)
  * Issues/PR review
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Came up with overhauled plan for Module moving forward
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * A bit more work on the ecosystem detection tool
  * Mostly comments, nothing significant
  * Will file a docs linting PR soon — needs some final cleanup
* Colin Ihrig @cjihrig (CTC)
  * Reviewing issues and PRs
  * Working on the v6.4.0 release
* Evan Lucas @evanlucas (CTC)
  * some more commit validation work
  * backport pr for worker.exitedAfterDisconnect to v4.x
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Nothing in particular
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* James M Snell @jasnell (CTC)
  * Going through PRs/Issues
  * More exploration of possibility of HTTP/2 impl in core
  * Other miscellaneous things
* Josh Gavant @joshgav (observer/Microsoft)
  * meetings notes
  * review some issues
* Michael Dawson @mhdawson (CTC)
  * adding linxuOne release machine to the release CI, and getting linuxOne added to release job so that we get nightlies for that platform
  * configuring new AIX machines from osuosl, adding to CI and validating with AIX build jobs that they look good.  Working to get added to regular regression jobs.
  * Working on build wg, FIPs and post-mortem presentations for Node interactive Europe 
  * Landing a few PRs
  * Reading/commenting on issues
  * Participation in LTS and Build WGs
  * ABI stable API PoC
* Brian White @mscdex (CTC)
  * Reviewing PRs, commenting on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * v8_inspector updates, V8 backports, writing up a doc on maintaining V8
* Myles Borins @TheAlphaNerd (observer/IBM)
  * v4.5.0 testing (potential regression)
  * ABI Smoke Testing Job
  * Landing V8 5.1 on v6.x
  * junit reporters for CI with Johann
* Trevor Norris @trevnorris (CTC)
  * PR reviews
  * Vacation most of the week
* Rich Trott @Trott (CTC)
  * onboarded @fhinkel
  * minor work on tests
  * ESLint update, minor indentation rule update
* Steven Loomis (Observer)
  * Asked me to pass on his regrets as he’s on vacation.
  * He’s been working on more Intl related items.


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)
* buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)
* Revert "fs: add a temporary fix for re-evaluation support" [#6413](https://github.com/nodejs/node/pull/6413)
* errors: add internal/errors module [#6573](https://github.com/nodejs/node/pull/6573)
* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

### general

* discussion: CommonJS and ES6 modules interoperability (<https://gist.github.com/bmeck/52ee45e7c34d1eac44ce8c5fe436d753>)


## Previous Meeting

### nodejs/node

* CTC membership nomination: @addaleax [#7607](https://github.com/nodejs/node/issues/7607)
* Revert fs changes [#7846](https://github.com/nodejs/node/pull/7846)
* [meta] realpath issues in v6 [#7726](https://github.com/nodejs/node/issues/7726)
* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)
* build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/issues/7484)
  * New issue specifically for v6: [#7989](https://github.com/nodejs/node/issues/7989)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

## Minutes

### v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

@thealphanerd: investigating problem with Bower, may delay release, if so will notify everyone.

**Next steps**:

* As above.

---

### buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)

@trevnorris: In the future the Buffer function will need to be a proper class so that `iterate` can return a buffer and so that users can inherit from Buffer.

Enabling inheritance forces the use of `new`. Thus it will break anyone who uses `Buffer` without the `new` keyword.

@evanlucas: Wasn’t there a way around that?
Perhaps with use of @@species symbol, but still doesn’t remove the fact that we’ll need to remove the `new` keyword at some point.

@addaleax: We could work around using `Reflect` API and check if call was made with `new` or not. There were perf concerns, @RReverser worked on something (see <https://github.com/nodejs/node/pull/7152#discussion_r74932064>).

@evanlucas: Can we do that and just soft-deprecate not using `new`?

@jasnell: We should absolutely *not* deprecate `new Buffer(...)`.

@chalker: [Deprecating `new Buffer()` will force libraries to work around this in 0.10, 0.12, and LTS <4.4, doesn’t sound like a good thing to do now.

**Next steps**:

* Continue discussion in GitHub.
* Finalize decision next week.

---

### Revert "fs: add a temporary fix for re-evaluation support" [#6413](https://github.com/nodejs/node/pull/6413)

Do we land the revert?

@chalker: This is going to break modules, notably those which depend on `graceful-fs`, including `gulp` and `unzip` (there’s another unzip module people use, unzip is not updated for a long time and its usage is rapidly decreasing), other inactive modules.

gulp will update `graceful-fs` Gulp v4. Gulp accounts for 42% of usage of `graceful-fs`. Gulp doesn’t want to update `graceful-fs` in v3 because it's a semver-major change, wants to wait for semver-major update till v4.

@jasnell: If we keep it as is I don’t think the modules are going to get fixed.

@thealphanerd: if gulp v3 isn’t updated then it will continue to cause problems for people through v7 lifetime. Can gulp do something to make this easier on the community?

@thealphanerd will follow up with gulp project leads about updating `graceful-fs` in Gulp v3.

@chalker: Old version of `graceful-fs` now includes its own message that it will be broken in Node v7. Would be best to live up to our commitment.

**Next steps**:

* Myles to follow up with Gulp about changes in v3, notify CTC as appropriate.
* Finalize decision next week.

---

### proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

Should `url` be a global or not?
@jasnell: To start let’s just not make it a global.

@jasnell: No need to include this in v6; include in master and in v7.

First step is to decide to land this as an EP in Node-EPs. Then, consider implementation.

@evanlucas: Will the similarity of these cause confusion?
`require(‘url’).Url` and `require(‘url’).URL`.

@jasnell: best answer is I’m not sure yet.

@jasnell: We’ll move forward on the EP without the global.

**Next steps**:

* Remove global then land EP.
* Continue work/review on impl.

---

### errors: add internal/errors module [#6573](https://github.com/nodejs/node/pull/6573)

@jasnell: This begins the process of changing errors implementation so that changes to their text are not semver-major.

Do we want this to land in v7? If we do, it needs to be complete by the end of August.

@Fishrock123: think about whether we can keep the syntax similar between js and c++.

@jasnell: if additional work is needed for C errors we should not rush it.

**Next steps**:

* Review in GitHub.
* Finalize next week.

---

### Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)

@thealphanerd: If we had a staging branch we’d avoid blocking releases due to problematic commits.

@Fishrock123: You can already stage to `v6.x` but usually people don’t do that.

@thealphanerd: Since it has the same function as `staging` it would be good to name them similarly.

@bnoordhuis: it’s confusing that there are different ways to get PRs backported in different branches.

@Fishrock123: Actual practices are not likely to change.

**Next steps**:

* Continue discussion in GH.
* Keep on agenda.

---

### discussion: CommonJS and ES6 modules interoperability (see <https://gist.github.com/bmeck/52ee45e7c34d1eac44ce8c5fe436d753>)

@bmeck:

* Cannot match babel’s semantics.
* Cannot support named imports from CJS modules.

We cannot match babel’s semantics so whatever happens in the future, at a minimum people who use babel to compile will have to change to use whatever Node is using for ES modules.

There’s no real way for us to support named imports from CJS modules, so these will be imported as the `default` property only, so people will not be able to use just `readFile` from `fs`.

Those 2 breakages mean we have to rethink this. First route was to match babel.

@bmeck proposes Node does a hard break. Remove most of Node’s magic names.

We’ll need a separate WHATWG `registry` object

@bmeck: New features are going to be targeting the module grammar exclusively. For example, `await` is not a keyword in the script grammar and if it’s treated that way it’s a language extension. TC39 considers `script` somewhat legacy.

**Next steps**:

* Schedule a session specifically on modules.

---

## Q/A on public fora

Q: Regarding WHATWG URL, how will updates be handled - major, minor, bug fix?

@jasnell: Still need to figure out process. Currently monitoring WHATWG to get a sense of their process. If their change is semver-major ours would presumably also be.

## Upcoming Meetings

* CTC: 2016-08-17
* TSC: 2016-08-11
* Build: Sept
* LTS: Sept
* Diagnostics: Sept
* Post-Mortem: Sept
* API: Sept
