# Node Foundation CTC Meeting 2016-08-17

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8125](https://github.com/nodejs/node/issues/8125)
* **Minutes Google Doc**: <https://docs.google.com/document/d/10fKK2lyZrxJ1Gt4zJvVSIsfmTGVD547vJJOp6eVKk-k>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1L65L7qhX5MrGeFwrub4-Z8klrwxJym-Q8CIEZsedohE>_

## Present

* Anna Henningsen @addaleax (CTC)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Ben Noordhuis @bnoordhuis (CTC)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* James M Snell @jasnell (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Julien Gilli @misterdjules (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Rod Vagg @rvagg (CTC)
* Myles Borins @TheAlphaNerd (observer)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Standup

* Anna Henningsen @addaleax (CTC)
  * Issues & PR review
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Modules - talks w/ transpilers about paths forward , looks like clean break / may not be able to support forward transpilation
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Comments on issues and PRs
* Colin Ihrig @cjihrig (CTC)
  * v6.4.0 release
  * Reviewed issues and PRs
* Evan Lucas @evanlucas (CTC)
  * some small doc updates
  * pr to revert \r\n change to util/repl
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * only a few PR/Issue comments
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
  * working on inclusivity strategies, stay tuned for issues in the next few days
  * certification scoping: reach out to me if you’d like to be part of that
* James M Snell @jasnell (CTC)
  * PR review
  * More investigation into HTTP/2
  * Work on proposed icu module
  * Some inclusivity related discussions
* Josh Gavant @joshgav (observer/Microsoft)
  * onboarded!
  * internal work
* Julien Gilli @misterdjules (CTC)
  * soliciting feedback on testing release candidates from customers
* Brian White @mscdex (CTC)
  * Submitted a couple of small PRs
  * Reviewed PRs, commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Auditing upstream bug fixes on V8
* Rod Vagg @rvagg (CTC)
  * Taking time off
* Myles Borins @TheAlphaNerd (observer)
  * Released v4.5.0
  * Landed **fix** into graceful-fs
  * continued research into how to minimize ecosystem breakage with fs changes
  * continued work on V8 ABI testing for citgm
  * New native modules included in citgm
  * CI job in jenkins
* Trevor Norris @trevnorris (CTC)
  * Nothing of note
* Rich Trott @Trott (CTC)
  * Onboarding @joshgav
  * ESLint updates and enabling of rules
  * small tests to plug holes in test coverage (per @addaleax’s coverage web page https://node-core-coverage.addaleax.net/)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* CTC membership nomination: @TheAlphaNerd [#8058](https://github.com/nodejs/node/issues/8058)
* buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)
* Revert "fs: add a temporary fix for re-evaluation support" [#6413](https://github.com/nodejs/node/pull/6413)
* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)


## Previous Meeting

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

  * @thealphanerd will investigate problem with Bower, may delay release, if so will notify everyone.

* buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)

  * Continue discussion in GitHub.
  * Finalize decision next week.

* Revert "fs: add a temporary fix for re-evaluation support" [#6413](https://github.com/nodejs/node/pull/6413)

  * Myles to follow up with Gulp, notify CTC as appropriate.
  * Finalize decision next week.

* errors: add internal/errors module [#6573](https://github.com/nodejs/node/pull/6573)

  * Review in GitHub.
  * Finalize next week.
  * **Decided not to discuss today, continue work in GH.**

* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)

  * Continue discussion in GH.
  * Keep on agenda.

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)

  * Remove global than land EP.
  * Continue work/review on impl.

### general

* discussion: CommonJS and ES6 modules interoperability (<https://gist.github.com/bmeck/52ee45e7c34d1eac44ce8c5fe436d753>)

  * Schedule a session specifically on modules.


## Minutes

### CTC membership nomination: @TheAlphaNerd [#8058](https://github.com/nodejs/node/issues/8058)

Generally we require attendance as an observer at least 4 times to ensure fit on both sides. Myles has already attended several meetings and all are comfortable.

We will vote on this next week.

**Next steps**:

* Vote next week.

---

### buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)

In order to enable inheritance from Buffer, need to declare it as a class, which will then require `new` keyword to create a new Buffer.

`new Buffer(...)` works in all versions.

Options

1. Keep as is - `Buffer(...)` would still work without `new`, and Buffer wouldn’t be subclassable.
2. Deprecate creating a buffer without `new`. `Buffer(...)` would no longer work.
3. Fully deprecate any use of Buffer constructor even without `new`. Neither `Buffer(...)` nor `new Buffer(...)` would work.

@trevnorris: Another option is to retain UInt8Array constructor signatures as Buffer constructor signatures.

@Fishrock123: We should deprecate use without `new`, but deprecating entire constructor isn’t reasonable due to ecosystem usage.

@jasnell: It would be a hard deprecation warning, i.e. by default print a warning message.

@trott: That would imply full removal in v9.x at the earliest.

@trevnorris: ecosystem has to use workarounds to subclass Buffer. So this refactor is actually blocking use cases.

@Fishrock123: We could differentiate between `require(‘buffer’).Buffer` and the global `Buffer`; imported Buffer would have deprecation, but Buffer as a global would not have that deprecation.

@addaleax: No. The types should still match (behave the same).

@jasnell: Separate into 2 PRs: one for deprecation of `Buffer()` without `new`, and another for complete deprecation of constructor, even with `new`.

**Next steps**:

* Separate into 2 PRs as above.
* Discuss again next week.

---

### Revert "fs: add a temporary fix for re-evaluation support" [#6413](https://github.com/nodejs/node/pull/6413)

@thealphanerd: Making many patches in `graceful-fs` and concerned that will not scale.

Previously graceful-fs put something through `vm` module. Then we used something in `internal/util` and it blew everything up. This happened near v6 release so we added this temporary fix.

Now this temporary fix is blocking progress on other issues.

We’ve had to patch `graceful-fs` several times, no guarantee that we won’t have to again. Each time it’s putting internal/util methods directly into graceful-fs.

Gulp transitively relies on graceful-fs v3.

Myles spoke to Blaine (head of gulp). Very reluctant to make a breaking change within v3 major release. Nothing seems to be broken, Myles ran tests, but not every possible workflow.

[#8149](https://github.com/nodejs/node/issues/8149) opened by @isaacs to discuss benefits of `internal`, worth discussing this in that context.

We want to move things to `internal` but we also don’t want to break gulp and the ecosystem (e.g. ember CLI).

@Fishrock123: Why can’t we use the updated shim to make graceful-fs v2 and v3 work?

Myles: More changes coming that will further break graceful-fs, such as [#6749](https://github.com/nodejs/node/pull/6749), the Errors PR James is working on, a PR to move StringToFlags to internal/fs.

Reasons to stop treating graceful-fs specially:

* We’ll need to patch graceful-fs v2 whenever we patch `internal/fs`.
* New things could be added to `internal` in `nodejs/node` which we don’t expect to be relevant to the ecosystem but in fact will need to be added graceful-fs.

@rvagg: Perhaps we should move slower, graceful-fs is an important module.

@jasnell: Consider errors PR, helps us reduce inconsistencies and problems. We’d need alternate code in graceful-fs to do that.

We are doing that currently with streams. I have to treat it special cause of the `readable-stream` module.

It makes things significantly harder.

@thealphanerd: Should we shim `process.binding('internal/*')` to intercept this call and return patched module when needed?

@thealphanerd: Let’s add graceful-fs v3 to CITGM and ensure it keeps working.

@jasnell: perhaps we should have our own `graceful-fs` module in core.

@Fishrock123: Let’s backport all patches in graceful-fs v4 to v3 and v2.

@Chalker: This is what gulp objects to, they can’t backport to make a semver-major change.

@Fishrock123: If in fact it’s not breaking then they should backport them.

@jasnell: We need to decide if we want to land before v7. This particular PR, if landed, would not break `graceful-fs` v3. (Myles: but it would break v2).

@rvagg: I’d vote for slowing down on this. This group is not a primary group of Node users, they’re using for frontend toolchain. They aren’t used to dealing with Node and won’t know how to handle problems. Better for us to accept a little pain than to inflict on lots of users.

@bnoordhuis: if not now when?

@myles: graceful-fs v2 patch wouldn’t take a long time.

A lot of people in ecosystem who don’t feel like we’re listening. There’s not much technical advantage to landing this. (We could update the patch to use an updated form of deprecation.)

On the other hand, to land all the other fs fixes we need to land this.

So if we’re going to land the rest, we should land this. Otherwise, hold.

@jasnell: no consensus to land this before v7. Next possible time is v8.x (which becomes LTS).

@thealphanerd: still possible to land in v7.

@bnoordhuis: What might change in v8.x timeframe?

@thealphanerd: more gulp v4 adoption, more ecosystem testing to see how to avoid breaking people.

@trevnorris: will the ecosystem upgrade from v3 to v4?

@thealphanerd: at least they’ll have the option to upgrade and be unbroken.

**Next steps**:

* Myles working with @isaacs to integrate a fix in graceful-fs@3 to address all these concerns, see <https://github.com/nodejs/node/pull/8245#issuecomment-242192458>.

---

### Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)

Deferred till next week.

---

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

@rvagg to follow up with legal committee.

---

### Modules Update (from Bradley)

@jasnell will set up a Doodle for a meeting on modules.

---

## Q/A on public channels

Q: Where should the question of accepting creationix/nvm go?
[TSC#96](https://github.com/nodejs/TSC/issues/96)

@jasnell: TSC meeting, add to next week’s agenda.

## Upcoming Meetings

* CTC: 2016-08-24
* TSC: 2016-08-25
* Benchmarking: [Benchmarking#56](https://github.com/nodejs/benchmarking/issues/56)
* Build: 
* LTS: 
* Diagnostics: 
* Post-Mortem: 
* API: 
