# io.js TC Meeting 2014-12-30

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=O60sOsesjOo
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/211
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1KLfX2MZQbVSIaD2lBVqOFK0Kap4uFz9cTGihnpTuvPE

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* sys: Remove after 3 years of deprecation #182 https://github.com/nodejs/io.js/pull/182
* module: force require('process') to return a reference to process #206 https://github.com/nodejs/io.js/pull/206
* File copyright policy #216 https://github.com/nodejs/io.js/pull/216
* Rename v0.12 to v1.0.0 https://github.com/nodejs/io.js/issues/218
* Merge strategy (v0.10 and joyent/node)

## Minutes

### Present

* Rod (build, facilitator)
* Ben (TC)
* Bert (TC)
* Chris (TC)
* Fedor (TC)
* Trevor (TC)

### sys: Remove after 3 years of deprecation #182 

https://github.com/nodejs/io.js/pull/182

* Ben: what sort of strategy to take? Deprecated only in the docs but no warning. Looking for an official deprecation policy.
* Bert: suggest we could properly deprecate but not a good case for removing it completely, Chris agreed
* Fedor: suggested a policy that removal of deprecated features should be done where there is a maintenance overhead, but otherwise if there is little/no cost then "who cares"
* Discussed a deprecation message on `require(‘sys’)`
  * Ben: -0
  * Fedor: +1
  * Chris: +1
  * Trevor: -0
  * Bert: +1
* No disagreement to adding a deprecation message, **ask initial PR submitter to change to just adding a message**

### module: force require('process') to return a reference to process #206

https://github.com/nodejs/io.js/pull/206

* #157 has a long discussion on this: https://github.com/nodejs/io.js/issues/157
* Chris: +1 on a PR adding this
* Trevor: it just returns a global, no point
* Bert: not the way that JS adds new features; discussed the new Intl addition to joyent/node, in favor of making more things requirable rather than adding new globals all the time
* Tangential discussion on the Intl object being added in joyent/node
* Collected votes:
  * Bert: +0
  * Ben: +0.5
  * Trevor: -0
  * Fedor: +1
  * Chris: +1
* **Ben to handle the merge / resolution**


### File copyright policy #216

https://github.com/nodejs/io.js/pull/216

* Rod asked if there are any strong opinions about how to handle this
* **Group agreed that Rod will take this issue and seek legal advice to find a way forward**

### Rename v0.12 to v1.0.0

https://github.com/nodejs/io.js/issues/218

* Trevor: concerns about 1.0 vs 1.x branch naming with maintaining semver releases while also doing LTS, 1.x effectively becomes master until a 2.0 comes along.
* Bert: -1
* Ben: +1
* Chris: +1
* Fedor: +1
* Trevor: 0

Action: **Rename to "v1.x", Ben agreed to make the change**


### Merge strategy (v0.10 and joyent/node)

* _Much_ discussion about merge strategies, patches, branches, etc.
* Agreed to merge regularly
* **Bert agreed to monitor the situation and propose a merge strategy when the time is right**

### Next meeting

* Agreed to meet again on the 7th of January UTC
* Agreed to have mini-stand-up at the beginning of each meeting


