# io.js TC Meeting 2015-02-04

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=k27NObxy0ps
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/509
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1IIfubVivCORgP0nQfo8Mf4gXhwBrndRm9cwmNGBXmtE

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* assert: don't compare object `prototype` property [#636](https://github.com/nodejs/io.js/pull/636) _and_  assert: introduce `deepStrictEqual` [#639](https://github.com/nodejs/io.js/pull/639) / @vkurchatkin
* Release PGP key strategy and policy [#709](https://github.com/nodejs/io.js/issues/709)
* If time: vm bugs? [#548](https://github.com/nodejs/io.js/issues/548), [joyent/node#9084](https://github.com/joyent/node/issues/9084)
## Minutes

### Present

* Ben (TC)
* Bert (TC)
* Chris (TC)
* Colin (TC)
* Fedor (TC)
* Isaac (TC)
* Trevor (TC)
* Mikeal
* Domenic
* Rod

### Mini stand-up

* Bert: Lots of commenting, still working on ICU, investigating binary size and memory size minimisation, playing with transforming the data to C
* Chris: Integrating ESLint, held first Streams WG meeting
* Colin: Issues and codez, removed all util.is type functions
* Isaac: “Real job” stuff
* Domenic: Streams WG
* Mikeal: Starting Tracing WG, lots of org stuff, roadmap work, early feedback from reaching out to companies is that there is concern about version number conflict between io.js and Node, and debugging/tracing.
* Trevor: moving house, tracing
* Rod: build collaboration stuff

### Review of last meeting

*  governance: Add new Collaborators [#234](https://github.com/nodejs/io.js/issues/234) / feedback and more contribs / @chrisdickinson
*  Stabilization and Release Cycles and Process [#405](https://github.com/nodejs/io.js/issues/405) / further discussion / @iojs/tc
  -  doc: add releases document detail release cycle [#630](https://github.com/nodejs/io.js/issues/630) / proposal from @chrisdickinson
*  dgram: implicit binds should be exclusive [#325](https://github.com/nodejs/io.js/issues/325) / minor version bump / @bnoordhuis
*  buffer: implement `iterable` interface [#525](https://github.com/nodejs/io.js/issues/525)  / minor version bump / @bnoordhuis
* replace util.isType() with typeof [#607](https://github.com/nodejs/io.js/issues/607) / general use of util.is*() in core re perf
* docs: lower the maximum stability level to "stable" (https://github.com/nodejs/io.js/pull/633)
* maintain our own package registries for io.js related packages (https://github.com/nodejs/io.js/issues/640#issuecomment-71882645)
* Working Groups PR (https://github.com/nodejs/io.js/pull/599)
* Remove “unstable” from messaging (https://github.com/nodejs/website/issues/108)
* Node.js and io.js should not break each other (no, they shouldn't)
* Working group reports


### assert: don't compare object `prototype` property _and_  assert: introduce `deepStrictEqual` / @vkurchatkin 
@vkurchatkin questions:

* the future of assert module;
* relationship between assert and CommonJS Unit Testing spec;
* particular #636 bug;
* what "deep equality" means and how it should deal with prototypes;
* [#639](https://github.com/nodejs/io.js/pull/639) proposal

* Isaac: CommonJS is gone & dead, good ideas have to stand on their own
* Mikeal: assert probably shouldn’t be in core
* Isaac: it’s useful for testing Node itself and useful for runtime asserts
* Rod asked if anyone had any objections to the changes because perhaps Validmir should just be given a blessing to go ahead and improve it.
* Domenic: medium risk, low reward, perhaps slate this for a 2.0 release.
* Lots of discussion about the technical merits
* Ben: the `a.prototype !== b.prototype` is clearly a bug in the initial implementation, it should have been checking `__proto__`
* Rod: new deepStrictEqual() does that check properly


Conclusion: accept both of

- [#636](https://github.com/nodejs/io.js/pull/636)
- [#639](https://github.com/nodejs/io.js/pull/639)

(Contrast #636 with [#621](https://github.com/nodejs/io.js/pull/621), which is a more ambitious change and probably not a good idea.)

1. deepEqual = No prototype checking
2. deepStrictEqual = proper prototype checking
Passed without objection

### Release PGP key strategy and policy / @rvagg

[#709](https://github.com/nodejs/io.js/issues/709)

* Rod summarised how the current release key strategy works and is documented on the README. Asked for feedback on:
  - Which keyserver(s) to use
  - Whether to go with a master/sub key design for the project
* No strong opinions, nothing actionable here

### VM bugs? [#548](https://github.com/nodejs/io.js/issues/548) / @domenic

[joyent/node#9084](https://github.com/joyent/node/issues/9084)

* Domenic introduced #548, some odd VM bugs that seem to be V8 bugs, 
* Isaac encouraged Domenic to follow this up with the V8 team to get feedback on how this works

### Next meeting

* Skipping a week due to Node Summit
* Feb 18th 2015
