# Node Foundation CTC Meeting 2016-05-04

## Links

* **Audio Recording**: https://www.youtube.com/watch?v=3M95wsWs7qQ
* **GitHub Issue**: https://github.com/nodejs/node/issues/6567
* **Minutes Google Doc**: <https://docs.google.com/document/d/1eP0HyB452ZmoMlljCXJNyWO-BZyhzo9j6kNn17sDCEg>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/16t1um6sXBlFZT2aCLqnlwumcEcM2K-_xeEFnnsA_rBQ>_

## Present

* Bradley Farias @bmeck (observer/modules EPS/GoDaddy)
* Brian Terlson @bterlson (observer/modules EPS/tc39/Microsoft)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* James M Snell @jasnell (CTC)
* Josh Gavant (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Rod Vagg @rvagg (CTC)
* Seth Thompson (observer/Google)
* Shigeki Ohtsu @shigeki (CTC)
* Steven R Loomis @srl295 (observer/IBM/ICU)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Revert 5950 [#6537](https://github.com/nodejs/node/pull/6537)
* src: refactor constants, deprecate require('constants') [#6534](https://github.com/nodejs/node/pull/6534)
* doc: refactor the changelog by version [#6503](https://github.com/nodejs/node/pull/6503)
* Request for discussion of https://github.com/dherman/defense-of-dot-js vs EPS on modules



## Standup

* Сковорода Никита Андреевич:
    * Nothing too significant, some comments (as usual).

* Colin Ihrig:
    * A few PRs
    * Reviewing issues and PRs

* Evan Lucas:
  * Submitted a doc and util pr.
  * Working on a http bug.
  * Been trying to help some packages get updated to work with v6.
  * Left some comments on a few issues.
  * Have been working on a commit validator tool.

* Jeremiah Senkpiel:
    * v6 Breaking changes doc
    * working on v6.1.0 release
    * assorted PRs, Issues, EPs -- done a bunch of reviews

* James M Snell:
  * v6 Release
  * Fixed 2 util.inspect bugs (proxy and array length)
  * Helped troubleshoot buffer indexOf/lastIndexOf bug
  * Troubleshooting 5950 issues
  * Work on error code refactoring
  * Work on constants refactoring
  * Work on changelog refactoring
  * Ongoing http implementation security / spec compliance review
  * Working on compliance follow ups from vm summit
  * Investigating possible alternative solutions for stdout/stderr
    non-blocking issues

* Josh Gavant:
  * Testing use of trace-event macros, designing tracing module, reviewing AsyncWrap and alternatives.

* Michael Dawson:
  * Investigated ppc be release machine issues
  * validating be build from nightly release job
  * AsyncWrap EP review
  * switched benchmarking vof v6 over to new v6 branch
  * wrote/submitted stable ABI module EP
  * misc reviews/lands

* Brian White:
  * Worked on http server code refactor and other http performance improvements
  * Reviewed PRs/issues

* Rod Vagg:
  * Time off, now catching up

* Seth Thompson:
  * continue to work on getting v8 inspector to work with node
  * meeting with Ali as he.s visiting in person

* Shigeki Ohtsu:
    * Upgrading openssl and reviewing one PR for GCM IV

* Steven R Loomis:
    * turn/rebase/clean ci for https://github.com/nodejs/node/pull/6088 ( checkin ICU into master ) and https://github.com/nodejs/node/pull/4253 ( v8BreakIterator to throw error rather than fatal crash
    * opened Doodle poll to get Intl WG going again (monthly) https://github.com/nodejs/Intl/issues/33

* Trevor Norris:
    * Don't abort on access of invalid pointer returned by Unwrap PR
    * Tuning the AsyncWrap EP and writing patches as result

* Rich Trott:
  * Added undocumented-for-now -F flag to jslint.js to automatically fix lint issues. Dog-fooding it right now. Give it a shot if you.re brave.
  * Open PR to have `known_issues` tests run via CI and `make test`. PTAL. https://github.com/nodejs/node/pull/6559
  * Assessments for long-dormant issues.

* Bradley Farias:
  * Investigated counter proposal details to node EP for modules
  * Started test framework for modules EP


## Review of last meeting


* governance: add new collaborators XII [#6282](https://github.com/nodejs/node/issues/6282)
* doc: doc-only deprecation for util.log() [#6161](https://github.com/nodejs/node/pull/6161)
* Check (small) ICU into repo [#6088](https://github.com/nodejs/node/pull/6088)
* doc, tls: deprecate createSecurePair [#6063](https://github.com/nodejs/node/pull/6063)
* Planning for v6 [#5766](https://github.com/nodejs/node/issues/5766)
* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)
* ES6 Modules detection update / https://github.com/nodejs/node-eps/issues/13


## Minutes

### Revert 5950 [#6537](https://github.com/nodejs/node/pull/6537)
* James: Bug picked up in v6 for symlinked peer dependencies, our tests/CI didn.t pick it up unfortunately. Proposal is to revert the change and review it after adding some tests for this.
* Rod: there was some discussion about a revert being semver major
* Jeremiah: not optimal, reverting is technically a semver-major
* Rod: does anyone have an objection to a revert at this stage?
* Jeremiah: I believe some of the new behaviour was useful, is there a path to reintroducing it?
* James: least invasive route would be to add the new behaviour behind a flag, there are some other approaches being investigated. The folks who proposed this change in the first place are behind the reversion at this stage.

### Request for discussion of https://github.com/dherman/defense-of-dot-js vs EPS on modules


* Bradley: we merged our proposal last week and afterward a counter-proposal (that we.ve been waiting on for many weeks) showed up. The proposal is a package.json-based solution. It does address all of the major use-cases of Node and it does this in slightly different ways than we.ve seen before. It.s still lacking some existing behaviour of CJS files (you can.t detect some filepaths for CJS), e.g. ~/.config.js. It introduces a path-expansion mechanism. You add a module.root to your package.json. I still have concerns about this but it.s much better than the previous ones based on package.json. I.ll be having a more in-depth conversation with Brian Terlson (TC39/Microsoft), if anyone wants to join.
* Jeremiah: is the main downside of the file extension about sharing files from servers that aren.t configured for it?
* Bradley: yes, the main concern is about firewalls and configs that block transmission of the new files.
* Rod: can you help us empathise with the sentimentality around the file extension, are there objective problems that we are not picking up on?
* Bradley: there.s a concern . _something about a lodash example_ . shell scripts not finding the new files with *.js.
* Brian Terlson: there.s an expectation that JavaScript is contained in a .js file and we.re in a nice place now that this is true with some minor exceptions. For TypeScript we.d have to add a .mts and .mtsx extension.
* Rod: _asking about the sentimentality again_
* Brian Terlson: that.s a mischaracterisation of the defense of .js proposal
* Jeremiah: there will be developer friction either way
* Brian Terlson: but friction will be limited to node developers as opposed to all javascript developers
* Rod: what state is standard ?
* Bradley: Some pieces still have minor changes going on but mostly locked down.
* Brian Terlson: we have been thinking about all of these kinds of things during the whole process. I don.t think spec changes are off the table, TC39 could reconsider some aspects of the spec to improve matters. No promises, but don.t feel like you shouldn.t bring it up because we.re so late in process.
* Bradley: forward detection is the main problem. Have examples of specifics.  As long as implicit strict mode is enforced we are going to have a hard time.
Rod: what.s the path forward ? On our side seems like strong preference is still on the file extension side.
* Bradley: Either way was ecosystem effects. Personally towards file extensions, most response on social media is either .better than nothing. or .don.t like file extension but not pushing for package.json either..  Will discuss further with Brian and others from Microsoft.
* Rod: EP does not mean it is final, but it does mean it is the preferred way forward and CTC members would have to be convinced otherwise.
* Bradley: likely need longer discussion in next week or so either way.


### src: refactor constants, deprecate require('constants') [#6534](https://github.com/nodejs/node/pull/6534)
* James: recent PR asking to add new constant.  They are mentioned in the docs in a few places, but not well documented.  Figured should take a run at documenting and refactoring to make it make more sense. Cleans up the structure and properly documents.  Would it be semver major since we have never documented before ?
* Jeremiah: marked as semver major because it was deprecating existing constants.
* James: hard deprecation pretty much blows up everything as npm uses them ,etc. Thats why it is a soft deprecation.
* Jerimiah: we should find way to document
* James: add to release notes saying to use the new versions.
* Rich: Move discussion back to github
* Rod: Any objection to doing this, want consensus before we spend a lot of time doing it.


### doc: refactor the changelog by version [#6503](https://github.com/nodejs/node/pull/6503)

* James: changelog grew to point where it is no longer visible/usable on github.  To make it at least visible it was temporarily split out into an archive.  This PR is to split it out by version instead.  Each version release would link to the individual version change log.  One at top level becomes an index to the version specific ones.  Acceptable or do we need another approach?  Archive for io.js release and before v.10.  Should not add too much additional work to release process.
* Rod: maybe io.js ones should be in separate files as well instead archive.
* Jeremiah: io.js v1 has particularly large set of changes
* James: any major objections ?
* Rod: take it back to github, roll forward unless objections on github.

### Q/A on public fora
* call for questions on public channels.
* no existing ones so far.
* will wait a few minutes to see if any come in
* ok moving on.


## Next Meeting

2016-05-11
