# Node Foundation CTC Meeting 2016-07-13

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: https://github.com/nodejs/node/issues/7707
* [Minutes Google Doc](https://docs.google.com/document/d/1fP9_ZNcPoFh2VWCgUFu9-rDiDcMP88vhCC_oX6Aj528)
* _[Previous Minutes Google Doc](https://docs.google.com/document/d/1NWIKwYxDTApvc9Xbq5JTMorRPKIBuBKAA0zcjm8K_II)_

## Present

* Anna Henningsen @addaleax (observer)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Ben Noordhuis @bnoordhuis (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Fedor Indutny @indutny (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Alexis Campailla @orangemocha (CTC)
* Rod Vagg @rvagg (CTC)
* Stephen Loomis @srl295 (observer/ICU)
* Myles Borins @TheAlphaNerd (observer)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Standup

* Anna Henningsen @addaleax (observer)
  * PRs & issues
  * Some v4.x backports
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Bad news from V8/Chakra. Can’t do property hoisting for Babel like CJS interop.
  * Figuring out hooks for creating Modules in older Node versions
* Ben Noordhuis @bnoordhuis (CTC)
  * Back-porting patches
  * Moving stuff over from malloc() to new[] because of AIX
  * ABI compatibility tool
  * PRs & issues, of course - how could I forget?
* Colin Ihrig @cjihrig (CTC)
  * Reviewed issues and PRs
  * Opened a few PRs
* Evan Lucas @evanlucas (CTC)
  * Simple doc fix
  * Working on cherry-picking into v6.x
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Fixed a TTY test that was silently failing for over a year
  * misc PR & issue work
* Fedor Indutny @indutny (CTC)
  * Various GYP-related tooling
  * Code reviews, and fixing issues
* Josh Gavant @joshgav (observer/Microsoft)
  * Diagnostics WG meeting
  * debugging docs
* Michael Dawson @mhdawson (CTC)
  * Added LinuxOne to v8 tests in CI
  * Involvement on some AIX issues
  * Working on ABI stable API, API WG meeting this week
  * Re-scheduled post-mortem WG meeting for next week, LTS and diagnostic WG meetings
  * misc reviews/lands and keeping up on issues
* Brian White @mscdex (CTC)
  * Worked on PR to check for accidental git conflict markers when linting in CI
  * Backported some commits to v4.x
  * Reviewed PRs and commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Back from vacation, buried in email (sorry for late responses!)
* Alexis Campailla @orangemocha (CTC)
  * Investigating ABI incompatibilities. Preparing to drop VS 2013.
  * Reviewed miscellaneous Windows issues.
  * Resumed work on a PR for case normalization of the module cache on Windows
* Rod Vagg @rvagg (CTC)
  * LTS README rework
* Steven Loomis @srl295 (observer/ICU)
  * not much here, just trying to keep an eye on issues/PRs
* Myles Borins @TheAlphaNerd (observer)
  * Working on v4.5.0 release https://github.com/nodejs/node/pull/7688
  * CITGM Enhancements (XML + Queue)
  * Working with V8 team to improve workflow for managing floated commits https://github.com/nodejs/LTS/issues/111
* Trevor Norris @trevnorris (CTC)
  * Working fix for one of the realpath bugs
  * Backporting for v4.x
  * Working on AsyncWrap implementation details
* Rich Trott @Trott (CTC)
  * Trying to handle flaky test outbreak on FreeBSD in CI
  * Various ESLint updates/improvements
  * Banging my head against test-tick-processor flakiness which is easily the longest-standing flaky test.


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/pull/7484)
* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/pull/7175)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)
* v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

### nodejs/node-eps

* proposal: WHATWG URL standard implementation [#28](https://github.com/nodejs/node-eps/pull/28)


## Previous Meeting

### build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/issues/7484) (@jasnell)

To be discussed again.

### Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)

@trevnorris was to complete changes, to be discussed again.

### Replace section 5.1 with unambiguous JavaScript grammar. [#33](https://github.com/nodejs/node-eps/pull/33)

@jdalton’s proposal was merged.

### AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

API was accepted, implementation TBD before October.


## Minutes

### build: drop support for VS 2013 in v7 [#7484](https://github.com/nodejs/node/issues/7484)

@orangemocha: Decision to drop in v7 isn’t controversial. Will need to add tests for modules compiled with 2013 used with Node compiled with 2015.

@orangemocha: Main question is switching in v6 before LTS. Is it a breaking change?

Issue with node-sass module only comes up on Windows XP so can be discounted.

No way to be sure if user modules compiled with 2013 might be incompatible with Node compiled with 2015. Have to run tests. Will CITGM provide sufficient testing?

@myles: may not be enough native modules in CITGM to provide confidence.

@Fishrock123: be sure to also test on pre-gyp’ed modules.

@orangemocha: we may never have complete confidence that this isn’t a breaking change, but node-sass is the only issue ever reported.

@orangemocha: Should we support modules built with 2013 in v7?
@rvagg: need to include that in tests.

**Next steps**: Run tests with modules compiled with 2013 to see if there are issues. Keep on agenda for next week and check on progress.

### Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/pull/7175)

* ELOOP fix: https://github.com/nodejs/node/pull/7548
* Windows PR: https://github.com/nodejs/node/pull/7559 (see also https://github.com/nodejs/node/issues/7192)

ELOOP issue has been resolved. Windows problem being addressed in another PR. May have to use JS impl for Windows.

@rvagg: If libuv can’t handle the realpath issue for Windows what should we do?

@orangemocha: We’re using the JS impl for Windows.

@trevnorris: we can use the libuv impl and defer to the JS impl if the libuv impl throws unexpectedly.

@rvagg: should we just revert? How common is the case where this provides a speed-up?

@trevnorris: keep both libuv and js impl for now.

**Next steps**: All please review #7548 and #7559.

### http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)

@mscdex: Prevent clash of header names with properties inherited from Object (e.g., `__proto__`). An object with a null prototype is already being used for the same purpose in `querystring.parse` since v6 release.

@mscdex: Some have suggested cherry-picking some methods from Object such as `toString`:

  * So that object can be inspected.
  * To ensure backward compatibility.

@mscdex: An eventual goal may be to store headers in an ES6 Map instead of on a plain object, but that will change the API considerably.

@evanlucas: we should follow what we did with query string parameters.

@rvagg: first need to review as some opposition to that.

**Next steps**: All review PR.

### proposal: WHATWG URL standard implementation [node-eps#28](https://github.com/nodejs/node-eps/pull/28)

@trevnorris: Some discussion about supporting unregistered schemes (e.g. `chrome://`). We should support them, Chrome supports them.

@trevnorris: `url.parse` can handle incomplete URLs (e.g. no scheme).

@rvagg: Most important question is should `URL` be a global? There would be a `url` module and a different `URL` global.

@fishrock123: there would be a transition period and then functionality would be in `URL`

@rvagg: new impl is quite different from existing `url` module. Would like to see a diff. Migration will be difficult.

**Next steps**: Waiting for @jasnell to return. Review again next week.

### v4.5.0 proposal [#7688](https://github.com/nodejs/node/pull/7688)

@thealphanerd:

* Would like to include libuv v1.9.1.
* Would like very extensive testing prior to release to exclude breaking changes.

How can we best test?

@rvagg: Promote the RC on social media.

@thealphanerd: npm could help test, Myles will reach out.

@rvagg: Heroku? (Hunter Loftis) Travis CI? Probably not because it depends on nvm which doesn’t do RC’s yet.

@thealphanerd: will talk with @ljharb about nvm support for RCs.

**Next steps**: @thealphanerd will ping all to test RC.

### ES Modules update

@bmeck: named imports from CJS modules (e.g. `import {use, route} from "express"` or `import {readFile, readFileSync} from "fs"`) can’t work.

Updates to come on the topic via: https://github.com/nodejs/node-eps/issues/26

## Q/A on public fora

## Upcoming Meetings

* CTC: 2016-07-20
* TSC: 2016-07-14
* Diagnostics: 2016-08-03
* Post-Mortem: 2016-07-18
* API: 2016-07-14
* LTS: 2016-07-25
* Build: 2016-07-19
