# io.js TC Meeting 2015-03-04

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=vxX2CkFPEtk
* **Google Plus Event page**: https://plus.google.com/events/c9ijr7edl14im7dspk5njktmjq4
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/1053
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1RoIE68l8B2iWLdEPM7ApSN2FxFDd3OY0wfTeqUh-K9w

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* lib: fix process.send() sync i/o regression [#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis
* iojs: introduce internal modules [#848](https://github.com/nodejs/io.js/issues/848) / @chrisdickinson / @trevnorris / (@vkurchatkin)
* url: significantly improve the performance of the url module [#933](https://github.com/nodejs/io.js/issues/933) / @mikeal
* Ship websockets in core [#1010](https://github.com/nodejs/io.js/issues/1010) / @piscisaureus
* RFC: upgrade to V8 4.2? [#1026](https://github.com/nodejs/io.js/issues/1026) / @bnoordhuis
* Colin resigning from TC [#1056](https://github.com/nodejs/io.js/pull/1056)

## Minutes

### Present

* Ben (TC)
* Bert (TC)
* Chris (TC)
* Domenic
* Fedor (TC)
* Mikeal (meeting lead)
* Isaac (TC)
* Trevor (TC)
* Rod

### Mini stand-up

* Ben: PRs, bugs, perf improvements, same old awesome Ben
* Bert: talking, child process bugs, looking further in to Windows bugs that are still outstanding, no coding
* Chris: reviewing PRs, onboarding Julian, Christian, Brian, Robert, Ben. Code for core module discovery / use in packages in npm.
* Domenic: Streams work WHATWG sync with io.js streams ideas.
* Fedor: fixing bugs, PRs
* Isaac: coding for fun, node-tap rewrite, global/window alias discussions, node_modules flattening, Windows stuff. Looking in to TLS issues for io.js and 0.12, TLS over Pound causes problems, possibly OpenSSL problem.
* Mikeal: Website and Evangelism WG work, lots of new collabs and work, getting things in sync
* Rod: Releases, Windows bug / Jenkins drama, ARMv8 support
* Trevor: Buffer.indexOf(), nextTick perf improvement


### Review of last meeting

* util: fixed behavior of isObject() [#822](https://github.com/nodejs/io.js/issues/822) / @chrisdickinson / major version release
* Translate installers for OS X and Windows [#819](https://github.com/nodejs/io.js/issues/819) / @rvagg / maintenance overhead
* lib: fix process.send() sync i/o regression [#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis
* Implement unhandled rejection tracking [#758](https://github.com/nodejs/io.js/issues/758) / @rvagg / how can we help this land
* Logo / Brand Treatment
[website/181] https://github.com/nodejs/website/issues/181 @ mikeal
https://www.behance.net/gallery/23269525/IOJS-logo-concept
* Stability Policy/Statement & Roadmap
[#725](https://github.com/nodejs/io.js/issues/725) / @mikeal
[roadmap/14](https://github.com/nodejs/roadmap/issues/14) / @mikeal


### Colin resigning from TC [#1056](https://github.com/nodejs/io.js/pull/1056)


### lib: fix process.send() sync i/o regression
[#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis

* Ben: @orangemocha did some work on Windows for libuv, unsure if this helps.
* Bert: process.send() has been made sync on *nix because otherwise it’s a breaking change, but on Windows it’s always been async so changing it to sync would also be a breaking change. So the situation is crazy.
* Isaac: ideal is that they behave the same and behave well
* Discussion about whether this would be a breaking change or a bugfix
* Bikeshed, moving to GitHub
* Bert: proposed that we revert Unix behaviour and leave Windows as it is
* Ben: current fix adds blocking on Windows


### iojs: introduce internal modules
[#848](https://github.com/nodejs/io.js/issues/848) / @chrisdickinson / @trevnorris / (@vkurchatkin)

Chris: lets us have modules that can’t be required from outside of core. I’m in favor; it’s a nice insurance policy, especially in light of the stability policy that we will try not to make any breaking changes to the JavaScript API.

Mikeal: this doesn’t change the existing pseudo-internal modules to become truly internal, right?

Chris: correct, that is separate.

Domenic: but, doing that operation would be a good thing to do in a major version bump.

Isaac/Mikeal: yes, but don’t do that for `util._extend`, too many people use it.

Chris: *gives example of how this would have been helpful for a recent refactor*

Ben: how will the test suite test internal functions from then on?

Chris: there would be a flag, e.g. --allow_internal_modules.

Mikeal: I like it.

Bert: I like it too. However I am concerned about products that do monkeypatching; would that still be possible?

Chris: I think so, as long as they monkeypatch the public APIs…

Ben: not sure that’s quite sufficient…

Domenic: seems like a pure win because it allows you not to have to put everything in one file to keep things private.

### url: significantly improve the performance of the url module
[#933](https://github.com/nodejs/io.js/issues/933) / @mikeal

This will get rolled in to the major version issue Chris is putting together.

### Ship websockets in core
[#1010](https://github.com/nodejs/io.js/issues/1010) / @piscisaureus

Bert: I’m not sure I believe in this any more; the major reason I wanted this was that building native addons is terrible, but people brought up that the native part of the web socket implementations only do some bitwise buffer stuff and so we could probably just add *those* to core.

Discussion of how we should probably just add more Buffer methods to core.

Bert: there’s another aspect of this. At some point Node was really modern, but we’ve fallen behind. We can’t even get HTTP/2 or web sockets, we’re in trouble.

Domenic: we’ve learned a lot over the last few years that pushes us to userland code instead of in core. But we need to have some things be “official.”

Trevor: I would like the infrastructure for HTTP/2 to be similar to HTTP/1, with http-parser etc.

Ben: is there any reason HTTP/2 couldn’t be done in pure JS?

Discussion of http-parser and current HTTP/1 implementation strategy and speed.

Bert: I think as a TC what we should say is “we would like to support HTTP/2, but want to see some userland ideas first.” We don’t need to actually start implementation progress right now.

Ben: does anyone on the TC want to write a userland HTTP/2 module?

Discussion of how Fedor already has a SPDY implementation.

Trevor: are we going to do TLS-only HTTP/2?

Mikeal: we probably don't want to, because our HTTPS is not as fast as terminators.

Conclusion:
We should start an issue in NG about the core modules/modernity stuff.
We should publicly state that we’re interested in supporting HTTP/2 in the related issue thread, although we’re not sure about implementation strategy and want to see experiments.

### RFC: upgrade to V8 4.2?
[#1026](https://github.com/nodejs/io.js/issues/1026) / @bnoordhuis

* Ben: V8 4.1 has gone gold/stable so we should probably upgrade by un-floating a revert we placed on top of it. I propose we revert that revert, so that we get 4.1-as-shipped-in-Chrome. [#952](https://github.com/nodejs/io.js/pull/952) for details on the floating revert.
* Domenic: do we have clarity about ABI vs. API implications for io.js major version?
* Ben: ABI change means everyone has to recompile their add-ons so we should bump the minor.
* Fedor: this feels more like a major version?
* Domenic: do we consider forcing people to run “npm rebuild” a breaking change?
* Chris: I think I agree that users should not expect to have to rebuild within the same major version.
* Mikeal: how often does a V8 ABI change happen *after that V8 gets into stable Chrome*?
* Domenic: not sure, but would suspect not often at all. Maybe we should check with V8.
* Ben: yes, not often.
* Fedor: having a call with V8 might be helpful.
* Mikeal: if it doesn’t happen, then we won’t end up in this situation again.

Conclusion:

Work with V8 team to make sure this doesn’t happen again
Add “un-revert” to the growing list of issues that would trigger a minor version bump.

### Next meeting

* 
