# Node Foundation CTC Meeting 2016-09-07

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8425](https://github.com/nodejs/node/issues/8425)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1GRgBC5Dv5luqlRc6egtxmkrQULJXa3M3CqGqWfoogV8>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1qYUOfiiytaZ0-YZVZ1NZX9O-4SE28QNooapOdcjlPqA>

## Present

* Anna Henningsen @addaleax (CTC)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Tracy Hinds @hackygolucky (observer/Node.js Foundation)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Julien Gilli @misterdjules (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Rod Vagg @rvagg (CTC)
* Seth Thompson @s3ththompson (observer/Google)
* Steven R Loomis @srl295 (observer/IBM/ICU)
* Myles Borins @TheAlphaNerd (CTC)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Standup

* Anna Henningsen @addaleax (CTC)
  * Issues & PR review
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Just emails around modules
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Some private ecosystem things
* Evan Lucas @evanlucas (CTC)
  * opened PR for adding back --harmony-proxies flag, not much else
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Working on v6.6.0
  * issue & PRs, Async_Wrap review, some Timers PRs.
* Fedor Indutny @indutny (CTC)
  * Reviewing PRs & Fixing bugs (sorry for not joining you today)
* Josh Gavant @joshgav (observer/Microsoft)
  * Issues and PRs
* Michael Dawson @mhdawson (CTC)
  * Investigating and PRs to move AIX to green in CI
  * Migration to new set of PPC machines
  * Addition of linuxOne to nightlies
  * Moved API work to nodejs/abi-stable-nodenodejs/abi-stable-node-addons-examples
  * presentations for Node Interactive EU
* Brian White @mscdex (CTC)
  * Worked on finding improvements in http code
  * Commented on issues, reviewed PRs
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Wrangle some V8 backports.
  * Looking at performance w/ new ignition interpreter
* Rod Vagg @rvagg (CTC)
  * Raspberry Pi cluster hardware problems, blog post
* Seth Thompson @s3ththompson (observer/Google)
  * V8 team working on Ignition interpreter and V8 Inspector migration
* Steven R Loomis @srl295 (observer/IBM/ICU)
  * PRs.
* Myles Borins @TheAlphaNerd (CTC)
  * Auditing commits for v4.x
  * Modifying output of testrunner
  * preparing for interactive EU
* Trevor Norris @trevnorris (CTC)
  * AsyncHook (formerly known as AsyncWrap); update embedder API to improve performance
* Rich Trott @Trott (CTC)
  * Backporting a few small commits to v4.x
  * Updating Build and Onboarding docs based on contributor mentoring and onboarding activities
  * A few test PRs designed to increase test coverage


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* src: add no-op for --harmony-proxies flag [#8395](https://github.com/nodejs/node/pull/8395)

### nodejs/node-eps

* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)


## Previous Meeting Review

* Process for determining supported platforms [#8265](https://github.com/nodejs/node/issues/8265)
  * Build WG will prepare initial list of supported platforms in their next meeting.
  * Then CTC will review and decide next steps.

* child_process, win: fix shell spawn with AutoRun [#8063](https://github.com/nodejs/node/pull/8063)
  * Remove from CTC agenda.
  * @joshgav to check for opinions within Microsoft.
  * Ask @joaocgreis in GitHub for more explanation.

* fs: undeprecate existsSync; use access instead of stat for performance [#7455](https://github.com/nodejs/node/pull/7455)
  * @trott to ping nodejs/collaborators in that thread. If no response then [fix].

* doc: add Google Analytics tracking. [#6601](https://github.com/nodejs/node/pull/6601)
  * Merge!

* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)
  * Do this as proposed.

* Move ecosystem detection tool to nodejs org [#7935](https://github.com/nodejs/node/issues/7935)
  * Prep repo for migration.
  * Open issue in nodejs/tsc.

* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)
  * Trevor to update all code and ask for vote on specific item(s).
  * CTC to review again once complete.


## Minutes

### src: add no-op for --harmony-proxies flag [#8395](https://github.com/nodejs/node/pull/8395)

We upgraded to V8 5.1 in v6.5. That removed several flags, notably the --harmony-* flags. Many in the ecosystem have hard-coded these flags and as a result are getting errors since v6.5.

@evanlucas added a PR to no-op those flags. There was quite a bit of resistance to that, as it implies that we apply semver semantics to experimental features.

@addaleax: Does anyone have concrete reason to not no-op these flags?

@trott: For clarity, do we mean to no-op them till the next semver-major release?

@addaleax: Yes.

@Fishrock123: This would only ever land in v6.

@evanlucas: Some feel this should be floated on V8.

@trevnorris: Could they?

@ofrobots: Trivial to do it, but this is on 5.1 which is an abandoned upstream.

@trevnorris: We were told we could re-open abandoned branches?

@ofrobots: That’s correct.

@? : Were the flags removed because their behavior is V8's default?

@ofrobots: Yes, support was already there but flags had not yet been removed.

@? : Other flags were removed too.

@addaleax: Main issue is the --harmony flags, I haven’t seen the other flags as issues.

@ofrobots: I’m supportive of adding no-ops for --harmony flags cause they break the ecosystem. Others no.

@Fishrock123: What about strong mode flags?

@ofrobots: Mainstream users are not likely to be using strong mode flags.

@ofrobots: The ones recommended as no-ops I agree should be added back as no-ops.

@rvagg: We can adopt a new policy if we want, for example state that when we upgrade V8 flags may change and you have to do feature detection to address that.

@addaleax: Seems to be that’s what some people want in comments, but it seems that it might not be what people expect.

@rvagg: Many flags unlikely to be used in real code, but some may be used in production code. Ones that are potentially usable in production code, sure.

@trevnorris: Let’s re-add the no-ops and see if people raise issues about the others.
It would be more pure to backport in V8, but I don’t see why floating it in Node would be an issue.

@addaleax: @bnoordhuis was strongly -1 on floating a patch on V8, but didn’t give a reason.

@misterdjules: what do we mean by floating a patch?

@trevnorris: we don’t even have to let these through to V8, just catch it ourselves.

@Fishrock123: That would be harder.

@ChALkeR: perhaps warn in runtime on unsupported flags for next major?

@rvagg: Colin and Ben had negative positions.
Is proposal to ask Ali to move forward in V8?

@addaleax: Not expecting a definite decision, hoping to hear from people who are -1. Would be happy if someone put together a PR with all the flags we want to no-op and discuss in next meeting if necessary.

@trev: How long to get a patch on the V8 branch?

@ofrobots: Probably not too long, dependent on me finding a half hour.
This will be a patch we float on our downstream of V8 5.1. We are the de facto owners of this branch now.

@rvagg: Open a PR, move discussion there, people with negatives can expand on them there.

**Next steps**:

* @ofrobots to float a patch on our branch of V8 5.1 and open a PR. Discussion to continue there.
* Keep on agenda for next week just in case.


### AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)

@trevnorris: EP is near 100% ready, only thing likely to change is the native C++ API but after doing testing and implementation it’s where it needs to be for all of the goals set for it.

@rvagg: We need to sign off on the EP. Can’t do that today, right?

@trevnorris: No, but EP is there. I’ve updated it with code, examples, stuff like that.

@rvagg: Will there be changes in node-eps#18 between now and next week?

@trevnorris: No, unless some major change comes in.

@trevnorris: No docs yet, Bradley has volunteered.

@rvagg: There will eventually be a discussion of backporting to V4.

@trevnorris: Discussion continues on promise side.

@rvagg: cause we don’t have insight into the microtask queue?

@trevnorris: Yes. It’s proceeding.

@seththompson: V8 team is interested in helping with this. Looks like async/await won’t make cut for v7, gives us more time to work on the right thing here.

**Next steps**:

* Everyone read [node-eps#18](https://github.com/nodejs/node-eps/pull/18).
* Vote next week on Node-EP.
* Open a PR for implementation in nodejs/node.


### Modules

@bmeck: There were several concerns about the rewritten EP for ES6 module compat. Note that we haven’t merged that yet, people are welcome to comment in that issue.

@rvagg: Those who are concerned should definitely get in touch with Bradley (@bmeck).


## Q/A on public channels

* Thanks for the heads-up on async/await.


## Upcoming Meetings

* CTC: 2016-09-14
* TSC: 2016-09-08
* Benchmarking: [Benchmarking#56](https://github.com/nodejs/benchmarking/issues/56)
* Build: 2016-09-20
