# Node Foundation CTC Meeting 2016-06-29

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: https://github.com/nodejs/node/issues/7474
* **Minutes Google Doc**: <https://docs.google.com/document/d/1a19l2ICQHCw2w6cM4AayRM8QX8cIrgnHXCtzmuxfWuM>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1X9PTcpYgTKJO-PRKOLBrL4fIV-7XDR0x71FAxJWn0II>_

## Present

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Colin Ihrig @cjihrig (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* James M Snell @jasnell (CTC)
* John-David Dalton @jdalton (observer/Lodash/Microsoft)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Rod Vagg @rvagg (CTC)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* New Buffer API backport to v4.x [#7475](https://github.com/nodejs/node/pull/7475)
* child_process: validate fork/execFile arguments [#7399](https://github.com/nodejs/node/pull/7399)
* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)
* repl: Default `useGlobal` to false in CLI REPL. [#5703](https://github.com/nodejs/node/pull/5703)
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

### nodejs/LTS

* Mention odd-number release has eight months support as Current. [#113](https://github.com/nodejs/LTS/issues/113)

### nodejs/node-eps

* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

## Standup

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Trying to gather all stakeholders in ES Module implementations into a meeting
  * Back and forth with V8 about details of CJS bridge
* John-David Dalton @jdalton (observer/Lodash/Microsoft)
  * Dropped caching from unambiguous JS proposal
  * PR to Node EPS repo
  * Discussed with V8 (Adam Klein) and Chakra about adding the API, no blockers
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Filed #7475 to backport new Buffer API to 4.x LTS
* Colin Ihrig @cjihrig (CTC)
  * Reviewing issues and PRs. Made a couple libuv PRs.
* Evan Lucas @evanlucas (CTC)
  * Merged pr to allow passing prompt to readline
  * Merged pr that prints experimental warning when using inspector
  * Worked on v6.x branch a little
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Was away a bit adjusting to Europe.
  * Misc PRs/Issues work.
  * Also working to resolve https://github.com/nodejs/node/issues/5426 (ages old timers issue)
* Josh Gavant @joshgav (observer/Microsoft)
  * Scheduled next Diag WG meeting (7/13 12 Pacific) (https://github.com/nodejs/diagnostics/issues/60)
  * “Inspector Gateway” proposal (https://github.com/nodejs/node/issues/7393)
  * Module discussions
* Michael Dawson @mhdawson (CTC)
  * Testing problematic PPC machine after move to new node, adding back to regular CI runs
  * Working on ABI stable API prototype with Ian/Sampson
  * Post mortem work with Richard C
  * Misc PR reviews/lands
  * Adding linuxOne to master test jobs in CI (since 5.1 landed there)
  * LTS, Build WG meetings
  * Starting to work on presentations for upcoming conferences
* Brian White @mscdex (CTC)
  * Landed a fix for a StringDecoder regression
  * Reviewed PRs, commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * Busy with non-Node stuff mostly.
* Rod Vagg @rvagg (CTC)
  * Chat with Electron team
  * Foundation board meeting
  * npm publish bug hunt
  * node-gyp release, fix for latest MSVS 2015 release
* Steven R Loomis @srl295 (observer/IBM/ICU)
  * regrets for this meeting- nothing to add at this point(hopefully soon)
* Trevor Norris @trevnorris (CTC)
  * working on solution for user API for AsyncWrap (?)
* Rich Trott @Trott (CTC)
  * child_process fixes
  * examining https://node-core-coverage.addaleax.net/ results (thanks, @addaleax!)
  * re-certifying flaky tests

## Minutes

### child_process: validate fork/execFile arguments [#7399](https://github.com/nodejs/node/pull/7399)

@trott: Semver-major change requires review.

@trott: fixing a bug that James filed some time ago - if nonsensical arguments are passed to these methods they silently ignore those arguments. Rich and James think it should throw if you give it garbage.

@nodejs/ctc: No objections.

### Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)

@trevnorris was to work on capturing new errors and handling them. Discovered that all fs methods suffer same issue. Trevor has idea on how to handle it, will submit PR in the next day or two.

@bzoz understands Windows issues and will address them.

### buffer: backport --zero-fill-buffers command line option [#5745](https://github.com/nodejs/node/pull/5745)

See also [#7475](https://github.com/nodejs/node/pull/7475).

Backport to v4. Was discussed and CTC thought it wasn’t a good idea, but want to revisit now. What was previous issue? @Fishrock123 - another change, possibly security-related, blocked it.

@rvagg: Same objections as backport to 0.12, should be treated the same.

@nodejs/ctc: No objections currently. This is relevant to security.

### repl: Default `useGlobal` to false in CLI REPL. [#5703](https://github.com/nodejs/node/pull/5703)

* Some discussion in the original issue: https://github.com/nodejs/node/issues/5659#issuecomment-195543607
* Moving back to GitHub.

### Mention odd-number release has eight months support as Current. [lts#113](https://github.com/nodejs/LTS/issues/113)

* Current state is that Current (formerly Stable) branch is supported for **two** months after next release but some people think it’s **three** months. For example, v5 is supported till end of June 2016. But we’d like this to be stated clearly.

@mhdawson: discussion in last LTS meeting but it’s not in the scope of the LTS WG’s work so it’s up to the CTC. Is it Current+2 or Current+3?

@nodejs/ctc: Previous Current version is supported for two months after next version is released.

@rvagg: v5 is still heavily used.

@Fishrock123: npm metrics also show high usage of v5, not much decline.

Need to make clear that people need to upgrade. Should we push this harder or adjust to usage pattern?

@nodejs/ctc: Stick with plan to stop supporting v5 shortly.

Metrics: https://nodejs.org/metrics/summaries/version.png


### AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)

@Fishrock123 - responses have been primarily positive, time for CTC to consider.

@rvagg - Goal is to raise awareness amongst CTC today, vote on it next week.

@rvagg - currently marked as experimental. We should associate a message/warning with experimental API usage. EPs are for experimental APIs.

@trevnorris - AsyncWrap cannot track callbacks from native addons. Also investigating why sometimes messages are dropped (?).

### replace section 5.1 with unambiguous JavaScript grammar  [node-eps#33](https://github.com/nodejs/node-eps/pull/33)

@jdalton wants to get agreement from Node.js CTC so that he can proceed to browser vendors.

TC39 may want to add other “goals” for files in addition to module and script such as asm.js, “frozen realms”.

@rvagg: If we go with `.mjs` we’d have to have extensions for new parse goals too...

@rvagg: We prefer a spec change in TC39/ES262 or an acknowledgement at least. @jdalton will add that caveat into the PR.

@Fishrock123: What about avoiding double parsing?
@bmeck: Chakra said maybe, V8 said probably not. @trevnorris did benchmarks and they weren’t too bad.

`module.root` for fat packages? With .mjs it wasn’t needed, people would include .js and .mjs files; but with new proposal it is needed. However `module.root` isn’t foolproof because people could use it for general redirection/hiding of package internals instead of only for ES6 modules.

@rvagg: Let’s slate for vote on Wednesday 7/6, those who are unavailable can vote in the issues.

## Q/A on public fora

None.

## Next Meeting

* AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)
* replace section 5.1 with unambiguous JavaScript grammar.
[node-eps#33](https://github.com/nodejs/node-eps/pull/33)

CTC: 2016-07-06
