# io.js TC Meeting 2015-05-13

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=UbYiFLf7MpU
* **Google Plus Event page**: https://plus.google.com/events/cu606mlllfehl11u8kcj7q2407k
* **GitHub Issue**: https://github.com/iojs/io.js/issues/1689
* **Original Minutes Google Doc**: https://docs.google.com/document/d/15Y_kJlYm-8cIf-alniaqUWMM-TjGISCqLf40G3pv4sM

## Agenda

Extracted from https://github.com/iojs/io.js/labels/tc-agenda prior to meeting.

* V8 4.4 to remove indexed properties via external data [#1451](https://github.com/iojs/io.js/issues/1451)
* NODE_PATH deprecation [#1627](https://github.com/iojs/io.js/issues/1627)
* Join the Node Foundation? [#1664](https://github.com/iojs/io.js/issues/1664)
* Put `*Sync` methods behind a flag in some future major version [#1665](https://github.com/iojs/io.js/issues/1665)
* TC Nominations
 - Shigeki Ohtsu @shigeki [#1501](https://github.com/iojs/io.js/issues/1501)
 - Brian White @mscdex [#1500](https://github.com/iojs/io.js/issues/1500)
 - @mikeal [#1481](https://github.com/iojs/io.js/issues/1481)
* Public QA via #io.js channel on Freenode

### Present

* Ben (TC)
* Bert (TC)
* Brian
* Chris (TC)
* Domenic
* Jeremiah (TC)
* Mikeal
* Rod (TC)
* Shigeki
* Trevor (TC)

### Quick stand-up

* Ben: Upgraded V8, upgraded cares for the first time in 2 years, reviewed pull requests
* Bert: Played Keen, not much io.js stuff; last Monday met with James, Mikeal about convergence
* Brian: looking over potential optimizations in the JS codebase, started working on a DNS resolver as a potential replacement for cares
* Chris: fixing race conditions in the REPL, poking at adding Ctrl-R history searching to readline
* Domenic: working with V8 team in Munich, working on v8-extras feature, putting large portions of things into snapshot to speed up startup and other things: https://groups.google.com/forum/#!topic/v8-users/D6FmTwlvCgk
* Jeremiah: issue management, working on tooling for automatic dependency upgrades, see [#1688](https://github.com/iojs/io.js/pull/1688)
* Mikeal: Foundation stuff, getting ducks in a row
* Shigeki: holiday in JP, fix TLS bug involving edge-case, needs review
* Trevor: Helped with re-enabling snapshots, looking at changing the Buffer APIs to use TypedArrays
* Rod: Been doing lots of little things, working on the CI and build cluster

### Review of last meeting

* Release Proposal: v2.0.0 [#1532](https://github.com/iojs/io.js/pull/1532)
* Forward-port from v1.x [#1559](https://github.com/iojs/io.js/pull/1559)
* Convergence plan (https://github.com/jasnell/dev-policy/pull/66)
* Combined node.js/io.js TC/core call [#1413](https://github.com/iojs/io.js/issues/1413)

## Minutes

* Discussed creating a more formal deprecation policy, chris to open an issue.

### V8 4.4 to remove indexed properties via external data [#1451](https://github.com/iojs/io.js/issues/1451)

* ‘smalloc’ has to go away when we land this V8, thankfully it’s not been around for long but this is a forced deprecation & removal.
* currently usage of ‘smalloc’ gives a deprecation warning, as of v2.0.0
* @jeisinger has been backporting some APIs needed for Buffer, NAN will have to catch up but @kkoopa is involved
* Domenic: V8 4.3 will be next week, 7 weeks from now will be 4.4 (~1 week behind Chrome release)
* Trevor: no major problems with JS API, most problems will be in the C++ API, should be able to shim to ease it

### NODE_PATH deprecation [#1627](https://github.com/iojs/io.js/issues/1627)

* Jeremiah: there was a suggestion to deprecate NODE_PATH entirely, debate is over deprecation or not, lots of people appear to be finding novel uses of it.
* Domenic: maybe we should document it
* Chris: it is documented, Googling shows that it’s been ingrained into the Node background, there’s lots of info out there about how it’s used
* Domenic: https://iojs.org/api/modules.html#modules_loading_from_the_global_folders
* Mikeal: maybe write docs about how it exists but you shouldn’t use it

**Action: Mikeal to open an issue to change the docs to talk about how you probably shouldn’t use them** (note: it might be as simple as styling!)

### Join the Node Foundation? [#1664](https://github.com/iojs/io.js/issues/1664)

* Mikeal: Mostly a consensus in the issue about joining
* Mikeal: Next step is to move the “iojs” org to “nodejs”, then move the convergence repo in to be “node” to be the new tip: https://github.com/jasnell/node.js-convergence

Lots of discussions about process and what needs to happen & when, Mikeal pushing for a vote to get the org moved.

**Voting Question**: The io.js TC agrees to:
 1. have the io.js project join the Node Foundation
 2. rename the entire “iojs” GitHub org to be “nodejs”
 3. invite the the current Node.js TC on to our TC to form the basis of a Node Foundation TSC under the policies of the Node Foundation
 4. moving the io.js Working Groups to be under the Node Foundation

**Voting Results**:

* Fedor: 0
* Ben: +1
* Bert: +1
* Chris: +1
* Jeremiah: +1
* Trevor: +1
* Rod: +1

Action: Mikeal to make the move happen in a coordinated way so we get redirects and whatnot

### Put `*Sync` methods behind a flag in some future major version [#1665](https://github.com/iojs/io.js/issues/1665)

* Ben: some people feel that `fs.*Sync()` methods are harmful and would like to see them go away and be behind a flag
* Bert: don’t agree with deprecating but agree with a flag
* Rod: agree with Bert, but would like to see doc changes
* Trevor: working on a flag to print a stack trace

### TC Nominations

* Shigeki Ohtsu @shigeki [#1501](https://github.com/iojs/io.js/issues/1501)
* Brian White @mscdex [#1500](https://github.com/iojs/io.js/issues/1500)
* @mikeal [#1481](https://github.com/iojs/io.js/issues/1481)

* Mikeal: joining
* Rod: timing is awkward with convergence but I’d like to make sure that Shigeki and Brian have a path to join the TC and not have that delayed too much

### Public QA via #io.js channel on Freenode

* `<therebelrobot> After the converged release, will io.js/node still be semver? for example, the history would be node 0.10, 0.12, iojs 1.x 2.x then the converged one would be node 3.x?`
 - Mikeal: the dev policy says so, there’s nobody advocating not to
* `<evanlucas> Are there plans to symlink node to iojs in the installers after the first converged release?`
 - Bert: undecided. We should figure out a way to allow users to “node lts” and “node bleeding edge” side by side.
 - Mikeal: part of the above is covered by a thread in NG about localizing the node installation to global modules.
* `<phpnode> will members of the core team be able to revive io.js if they disagree with the direction of the project in future`
 - (Group) Yes
* `<skinan5> any plans for nan resolution?`
 - Rod: it’s just a header file and you need it for older versions of Node so it doesn’t make sense to _not_ use it from npm
 - Ben: current NAN isn’t suitable for bringing in
 - Trevor: would support bringing in something that would provide proper ABI support
 - Action: Trevor to open an issue on the NAN repo to talk about a stable C++ layer

## Next meeting

* May 20th, invite joyent/node TC members, figure out who that is and if this timeslot works for them when we have a combined call tomorrow (14th)
