# io.js TC Meeting 2015-02-18

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=jeBPYLJ2_Yc
* **Google Plus Event page**: https://plus.google.com/events/ccrkam8uup1k8qbo0fmcea0n2v4
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/509
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1JnujRu6Rfnp6wvbvwCfxXnsjLySunQ_yah91pkvSFdQ

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* util: fixed behavior of isObject() [#822](https://github.com/nodejs/io.js/issues/822) / @chrisdickinson / major version release
* Translate installers for OS X and Windows [#819](https://github.com/nodejs/io.js/issues/819) / @rvagg / maintenance overhead
* lib: fix process.send() sync i/o regression [#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis
* Implement unhandled rejection tracking [#758](https://github.com/nodejs/io.js/issues/758) / @rvagg / how can we help this land
* Logo / Brand Treatment
[website/181](https://github.com/nodejs/website/issues/181) @ mikeal
https://www.behance.net/gallery/23269525/IOJS-logo-concept
* Stability Policy/Statement & Roadmap
[#725](https://github.com/nodejs/io.js/issues/725) / @mikeal
[roadmap/14](https://github.com/nodejs/roadmap/issues/14) / @mikeal

## Minutes

### Present

* Bert (TC)
* Chris (TC)
* Colin (TC)
* Isaac (TC)
* Trevor (TC)
* Mikeal
* Domenic
* Rod
* Apologies for Ben and Fedor

### Mini stand-up

* Bert: NodeSummit and company stuff, Windows io.js stuff
* Chris: styleguide work, wrangling ESLint, slow week
* Colin: busy with work, porting joyent/node work to io.js
* Domenic: having fun with VM stuff in jsdom, have a release coming soon
* Rod: not as much as usual, preparing for 1.3.0
* Isaac: Node Summit, npm stuff
* Mikeal: i18 groups, >160 new people doing translations, press inquiries because of Node Foundation news, lots of website stuff (i18n & build), roadmap and stability
* Trevor: Some critical stuff on joyent/node, work, moving house

### Review of last meeting

* assert: don't compare object `prototype` property _and_  assert: introduce `deepStrictEqual` / @vkurchatkin 
* Release PGP key strategy and policy / @rvagg
* VM bugs? [#548](https://github.com/nodejs/io.js/issues/548) / @domenic

### util: fixed behavior of isObject() [#822](https://github.com/nodejs/io.js/issues/822) / @chrisdickinson / major version release

* Chris: Requires semver-major, what’s the vibe on bumping major at this stage?
* Chris: isObject() would now return true when checking for functions
* Mikeal: interested in separating “things that break” and “API breakage”
* Chris: consider this a “fix” but is also an API change that could break people’s downstream code
* Isaac: probably want to put off a 2.x release until we have more substantial changes, not to wait for 2 years but have some time frame, like 6 months
* Bert: messaging is off for a 2.0 bump just for this
* Domenic: versions shouldn’t mean the same as they used to, major version bumps should be more casual
* Rod: are we stopping saying that this is compatible with “Node”?
* Mikeal: compatible with past-Node, not joyent/node 0.12+ because we have no control over that
* Mikeal: release channels - standard semver & canary which is everything else
* Chris: +1 for release channels, but not so much on substance of the proposal.
* Rod: concerned about the emotional energy we’re still investing in version numbers when we should be just doing semver
* Mikeal: ignore version numbers, have a “canary” type branch and start releasing on that until we’re confident to merge back in
* Chris: difference between Mikeal’s proposal and the original proposal is having a “canary” branch that stuff gets merged in to and eventually is merged in to master, original proposal merged new stuff in to master and used the time delay as “canary” (like Chrome)
* Rod: proposal is to tag this issue as a milestone for now and punt until we have more substantive changes - no disagreements, passed

### Translate installers for OS X and Windows [#819](https://github.com/nodejs/io.js/issues/819) / @rvagg / maintenance overhead

* Rod: concern here is the maintenance overhead in keeping all of the translations in sync, are we happy to have that headache in core?
* Mikeal: let English be the default and let the translation teams be responsible for watching for changes and making updates as appropriate
* Bert: installer framework is largely out of our control for how the mechanics of translations and fallbacks work, -1 on this because it’s just an installer and there are probably better targets for translation
* Mikeal: the translation teams will prioritise for themselves what gets translated.
* Domenic: enable the community as long as it doesn’t add friction
* Bert: if there is no technical issue then OK with landing this, the responsibility for translation will have to be with that community
* Resolution: allow this to land unless there are going to be technical blockers to future installer changes needing to wait for translations to be updated

### lib: fix process.send() sync i/o regression [#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis

* Ben’s issue, punt till next meeting, note in “known issues” for releases

### Implement unhandled rejection tracking [#758](https://github.com/nodejs/io.js/issues/758) / @rvagg / how can we help this land

* Rod: Brought to TC to get some more engagement and help get this landed unless there are any major objections
* Domenic: PR looks good, it’s mainly a matter of code quality, doesn’t add any default handlers which is a good incremental way of adding this
* Trevor discussed concerns about how V8 runs the events, synchronously vs on the micro-task queue
* Trevor: OK with the change because there is almost no overhead if you’re not using Promises or this event, concerned about the disconnect between the V8 API vs what we expect it to be--the PR compensates for V8 behavior.
* Domenic: user-exposed semantics of this PR are good
* Mikeal: concerned about behavior change in the future leading to a 
* Rod: proposed resolution is to give the TC’s blessing to that PR for it to land when everyone in there is happy with it
  - No objections

### Logo / Brand Treatment
[website/181](https://github.com/nodejs/website/issues/181) @ mikeal
https://www.behance.net/gallery/23269525/IOJS-logo-concept

* Mikeal discussed the proposed website changes and logo choice @ https://www.behance.net/gallery/23269525/IOJS-logo-concept
* Some discussion about choice of logo, no strong opinions on design
* Rod: may be best to let the website group make this choice because they are more qualified from a design perspective
* Chris: design group could be asked to come up with a few options and present them for selection
* Mikeal: design by committee sucks, everyone knows this
* Chris: can we come up with some standards and assert them ack to designers - such as number of colors, needs to look good at 16x16 all the way up
* Rod: maybe this group isn’t qualified to even do that, perhaps push it on to the WG
* Discussion on the process of selecting a logo and brand treatment
* Agreed to delegate to the website WG to make this decision

### Stability Policy/Statement & Roadmap
[#725](https://github.com/nodejs/io.js/issues/725) / @mikeal
[roadmap/14](https://github.com/nodejs/roadmap/issues/14) / @mikeal

* Mikeal: none of this is fixed in stone, we can change it in the future if we decide it won’t work
 - one change still to go in is that the wording on stability should be that “we won’t remove an API”
 - people are terrified that we’re going to break compatibility and go off in new directions, this is a way of dealing with that
* Bert: concerned about this being a reflection of the way we work rather than enforcing new behaviors
* Discussion around breaking / removing APIs and how firm this policy is going forward
* Rod asked for specific things that need to be resolved now vs punting to a later meeting
* Mikeal: https://github.com/nodejs/roadmap/commit/190690a1b5f206c22f64adc3d29d10c4b08cb8cd
* Group discussed presentations, no major objections so the blessing was given for Mikeal to move forward with ratifying that, expect further discussion on the broader topic next meeting.

### Next meeting

* Next week, 25th Feb 2015

