'use strict';
var bindings
try {
  bindings = require('../build/Release/weakref.node')
} catch (e) {
  if (e.code === 'MODULE_NOT_FOUND') {
    bindings = require('../build/Debug/weakref.node')
  } else {
    throw e
  }
}
module.exports = bindings.create

// backwards-compat with node-weakref
bindings.weaken = bindings.create

Object.keys(bindings).forEach(function(name) {
  module.exports[name] = bindings[name]
})
