# Node.js Foundation TSC Meeting 2015-06-03

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-06-03
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/47
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1sTD0uryasBR15UBzEbJj3oHYtnuN9ZIqVxA2A_-N56E

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/io.js

* Add working group state per Project Lifecycle. [#1880](https://github.com/nodejs/io.js/pull/1880)
* Proposal: Split TSC agenda in to two meetings [#1879](https://github.com/nodejs/io.js/issues/1879)
* Chrome 43 released; time for V8 4.3! [#1735](https://github.com/nodejs/io.js/issues/1735)
* TSC needs to elect a board representative. [#1697](https://github.com/nodejs/io.js/issues/1697)
* Expose `deepEqual` and `deepStrictEqual` in `util`. #1172 [#1177](https://github.com/nodejs/io.js/pull/1177)

## Present

* Rod Vagg (TSC)
* Mikeal Rogers
* Shigeki Ohtsu (TSC)
* Chris Dickinson (TSC)
* Colin Ihrig (TSC)
* Julien Gilli (TSC)
* James Snell (TSC)
* Michael Dawson (TSC)
* Bert Belder (TSC)
* Fedor Indutny (TSC)
* Jeremiah Senkpiel (TSC)
* Domenic Denicola
* Alexis Campailla (TSC)
* Ben Noordhuis (TSC)

## Quick stand-up

* Rod: working on the build, looking into npm smoke-testing
* Mikeal: getting foundation legalities and officialities in order
* Shigeki: working on security issues, reviewing root cert update
* Chris: working on getting npm static analysis working [estoc](https://github.com/chrisdickinson/estoc)
* Colin: reviewing prs and issues, doing some libuv work (uv_os_homedir, which landed in libuv 1.6.0)
* Julien: vacation, nodejs.org downtime postmortem
* James: working on convergence, triaging joyent/node issues
* Michael: triaging some joyent/node issues, working on powerpc build and npm testing
* Bert: not much, looked at some issues, discussing with Saul if libuv should move into the Node Foundation
* Fedor: reviewed some pull requests and issues, working on some openssl mode
* Jeremiah: issues, convergence, `_unrefActive` timers work, looking at improving Ben’s binary heap implementation
* Domenic: vm fixes in v8 integrating patches
* Alexis: patch for timers firing early, CI convergence work - jenkins hackery
* Ben: reviewing pull requests, making libuv threadpool more scalable
* Brian: JS dns resolver
* Trevor: merged UInt8Array Buffer changes into the next branch, additional ArrayBuffer-related changes and fiddling

## Review of last meeting

### nodejs/node

* \[Converge\] timers: Avoid linear scan in `_unrefActive`. [#23](https://github.com/nodejs/node/issues/23)
* \[Converge\] child_process argument type checking [#22](https://github.com/nodejs/node/issues/22)
* \[Converge\] SSLv2/3 disable/enable related commits [#20](https://github.com/nodejs/node/issues/20)
* doc: Add new working groups [#15](https://github.com/nodejs/node/pull/15)

### nodejs/io.js

* Buffer implemented using Uint8Array [#1810](https://github.com/nodejs/io.js/issues/1810)
* \[Discussion\] FFI - Giving Buffer more low-level C functionality [#1750](https://github.com/nodejs/io.js/pull/1750)
* Chrome 43 released; time for V8 4.3! [#1735](https://github.com/nodejs/io.js/issues/1735)
* Deprecation Policy [#1704](https://github.com/nodejs/io.js/issues/1704)
* TSC needs to elect a board representative. [#1697](https://github.com/nodejs/io.js/issues/1697)
* V8 4.4 to remove indexed properties via external data [#1451](https://github.com/nodejs/io.js/issues/1451)

## Minutes

### Add working group state per Project Lifecycle. [#1880](https://github.com/nodejs/io.js/pull/1880)

* Mikeal: making working groups as “core” means they get to elect a TSC seat.
* Brief discussion about what WG’s should be considered “core” and get a TSC seat.
* Deferred to GitHub.

### Chrome 43 released; time for V8 4.3! [#1735](https://github.com/nodejs/io.js/issues/1735)

Domenic: things are ready to go. There’s some concern about double-breakage in 4.3 and 4.4.

Jeremiah: what about the maybe changes?

Domenic: the non-Maybe versions are still there, and haven’t been removed yet, either in 4.3 or 4.4 or even 4.5 (which isn’t finalized yet though).

Rod: blocker is whether the double-breakage is real, if not then we should move forward.

Domenic: there’s also the issue of some people in the thread advocating blocking a release on readying the ecosystem.

Rod: we shouldn’t be following the ecosystem and waiting for them to catch up before we release.

Mikeal: it’s more a matter of how we approach these things.

Michael: LTS should help this?

Mikeal: the problem is about major releases and the messaging - currently when people download them lots of stuff is broken.

Domenic called for a vote on a 3.0 release _assuming there is no double-breakage_.

Rod: I need to get the fix for node-gyp in place. Also we should see if we can get nvm to allow testing nightlies so that people can test them more easily (including on Travis).

Jeremiah: when I last talked to Jordan (@ljharb) he wanted to make sure that the mechanism we used for nightlies would also be the mechanism used in the converged project.

Mikeal: well that’s definitely true. So we should be good.

Trevor: do we have a way of measuring uptake?

Domenic/Rod: npm traffic is probably the best metric.

Rod calls for a vote.

Domenic: can we clarify whether we allow minor, covered-by-nan breakages between 4.3/3.0.0 and 4.4/4.0.0, or do we require no breakages at all?

Mikeal: is nan released?

Jeremiah: not yet; it is experimental and they don’t release until we merge next into master

Mikeal: that seems bad

(General agreement that we want nan to release first.)

Trevor: looking at nan they seem to be working to encapsulate changes all the way out to V8 4.6.

Bert: what was the problem with putting nan into core?

Rod/Ben: sometimes V8 makes big changes that cause breaking changes in nan. E.g. isolates, buffer changes, maybes. Until now it’s been just individual APIs, but the 4.3 and 4.4 change has been very big. nan’s promise is just that you can write against a single, possibly-changing API that will support multiple node versions.

### Expose `deepEqual` and `deepStrictEqual` in `util`. #1172 [#1177](https://github.com/nodejs/io.js/pull/1177)

Jeremiah: what do we want to expose from core, there’s pressure from some parts of the community for core to be more isomorphic and support a lot of browser stuff. This issue is specifically about exposing what’s already implemented.

Ben: why not pull it out of core and put it in npm? util has always been about utilities that core uses.

Rod: when you expose something you’re stuck with it forever, minimising surface area should be our goal because the more we have to officially support the slower our release cycle will be.

### Proposal: Split TSC agenda in to two meetings [#1879](https://github.com/nodejs/io.js/issues/1879)

Mikeal: the scope of the TSC responsibilities are too wide, making meeting times go to long. The suggestion is to split up in to “project” related issues and “core” related issues.

Rod: can there be a clear distinction between the issues?

Domenic: assuming nobody wanted to attend two meetings, would there be enough?

Mikeal: yes because there are lots of people that aren’t here who would be in the other group

Rod: I wonder about the timing, e.g. letting the foundation kickoff happen first; it feels a bit premature to split now.

Mikeal: it’s a little premature but that’s because we haven’t onboarded the core working groups to this meeting.

Bert: in favour of the proposal.

_Discussed the pros and cons and agreed to tentatively move forward with experimentation, time slot for the new “project” meeting would either be after the current meeting or the day after that meeting._

### TSC needs to elect a board representative. [#1697](https://github.com/nodejs/io.js/issues/1697)

***Call ended prematurely due to Uberconference difficulties***

## Next meeting

* 

